@ /* $XConsortium: LookupCmap.c,v 1.7 89/10/08 15:00:44 rws Exp $   *  >  * Copyright 1989 by the Massachusetts Institute of Technology  *H  * Permission to use, copy, modify, and distribute this software and itsM  * documentation for any purpose and without fee is hereby granted, provided  K  * that the above copyright notice appear in all copies and that both that  D  * copyright notice and this permission notice appear in supporting H  * documentation, and that the name of M.I.T. not be used in advertisingM  * or publicity pertaining to distribution of the software without specific,  G  * written prior permission. M.I.T. makes no representations about the  H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION I  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *,  * Author:  Donna Converse, MIT X Consortium  */    #include <stdio.h> #include <X11/Xlib.h>  #include <X11/Xatom.h> #include <X11/Xutil.h> #include <X11/Xmu/StdCmap.h>   extern char *malloc(); static Status lookup();    /*D  * To create a standard colormap if one does not currently exist, or9  * replace the currently existing standard colormap, use    * XmuLookupStandardColormap().   *H  * Given a screen, a visual, and a property, XmuLookupStandardColormap()J  * will determine the best allocation for the property under the specifiedG  * visual, and determine the whether to create a new colormap or to use J  * the default colormap of the screen.  It will call XmuStandardColormap()#  * to create the standard colormap.   *G  * If replace is true, any previous definition of the property will be  F  * replaced.  If retain is true, the property and the colormap will beC  * made permanent for the duration of the server session.  However, J  * pre-existing property definitions which are not replaced cannot be madeK  * permanent by a call to XmuLookupStandardColormap(); a request to retain  1  * resources pertains to newly created resources.   *E  * Returns 0 on failure, non-zero on success.  A request to create a  E  * standard colormap upon a visual which cannot support such a map is D  * considered a failure.  An example of this would be requesting anyG  * standard colormap property on a monochrome visual, or, requesting an 7  * RGB_BEST_MAP on a display whose colormap size is 16.   */   H Status XmuLookupStandardColormap(dpy, screen, visualid, depth, property, 				 replace, retain) 7     Display		*dpy;		/* specifies X server connection */ 4     int			screen; 	/* specifies screen of display */7     VisualID		visualid;	/* specifies the visual type */ 9     unsigned int	depth;		/* specifies  the visual type */ 6     Atom		property;	/* a standard colormap property */5     Bool		replace;	/* specifies whether to replace */ 4     Bool		retain;		/* specifies whether to retain */ { 6     Display		*odpy;		/* original display connection */!     XStandardColormap	*colormap;	 5     XVisualInfo		vinfo_template, *vinfo;	/* visual */      long		vinfo_mask; 7     unsigned long	r_max, g_max, b_max;	/* allocation */      int			count;	 '     Colormap		cmap;			/* colormap ID */      Status		status = 0;     $     /* Match the requested visual */  (     vinfo_template.visualid = visualid;	#     vinfo_template.screen = screen; !     vinfo_template.depth = depth; C     vinfo_mask = VisualIDMask | VisualScreenMask | VisualDepthMask; M     if ((vinfo = XGetVisualInfo(dpy, vinfo_mask, &vinfo_template, &count)) ==  	NULL)
 	return 0;  2     /* Monochrome visuals have no standard maps */  $     if (vinfo->colormap_size <= 2) { 	XFree((char *) vinfo);  	return 0;	      }   E     /* If the requested property already exists on this screen, and,  D      * if the replace flag has not been set to true, return success.B      * lookup() will remove a pre-existing map if replace is true.      */   K     if (lookup(dpy, screen, visualid, property, (XStandardColormap *) NULL,  	       replace) && !replace) {  	XFree((char *) vinfo); 
 	return 1;     }   J     /* Determine the best allocation for this property under the requestedJ      * visualid and depth, and determine whether or not to use the default      * colormap of the screen.      */   M     if (!XmuGetColormapAllocation(vinfo, property, &r_max, &g_max, &b_max)) {  	XFree((char *) vinfo); 
 	return 0;     }   +     cmap = (property == XA_RGB_DEFAULT_MAP) ' 	? DefaultColormap(dpy, screen) : None;   J     /* If retaining resources, open a new connection to the same server */       if (retain) {  	odpy = dpy;: 	if ((dpy = XOpenDisplay(XDisplayString(odpy))) == NULL) { 	    XFree((char *) vinfo);  	    return 0; 	}     }   &     /* Create the standard colormap */  J     colormap = XmuStandardColormap(dpy, screen, visualid, depth, property," 				   cmap, r_max, g_max, b_max);  ,     /* Set the standard colormap property */       if (colormap) {  	XGrabServer(dpy);  B 	if (lookup(dpy, screen, visualid, property, colormap, replace) && 	    !replace) {> 	    /* Someone has defined the property since we last looked.@ 	     * Since we will not replace it, release our own resources.B 	     * If this is the default map, our allocations will be freed $ 	     * when this connection closes. 	     */6 	    if (colormap->killid == ReleaseByFreeingColormap)) 		XFreeColormap(dpy, colormap->colormap);  	} 	else if (retain) { * 		XSetCloseDownMode(dpy, RetainPermanent); 	} 	XUngrabServer(dpy); 	XFree((char *) colormap); 	status = 1;     }        if (retain)  	XCloseDisplay(dpy);     XFree((char *) vinfo);     return status; }   M /***************************************************************************/   L /* Lookup a standard colormap property.  If the property is RGB_DEFAULT_MAP,L  * the visualid is used to determine whether the indicated standard colormapL  * exists.  If the map exists and replace is true, delete the resources usedF  * by the map and remove the property.  Return true if the map exists,G  * or did exist and was deleted; return false if the map was not found.   *G  * Note that this is not the way that a Status return is normally used.   *I  * If new is not NULL, new points to an XStandardColormap structure which L  * describes a standard colormap of the specified property.  It will be madeK  * a standard colormap of the screen if none already exists, or if replace    * is true.   */   C static Status lookup(dpy, screen, visualid, property, new, replace) 6     Display		*dpy;		/* specifies display connection */0     int			screen;		/* specifies screen number */<     VisualID		visualid;	/* specifies visualid for std map */:     Atom		property;	/* specifies colormap property name */@     XStandardColormap	*new;		/* specifies a standard colormap */5     Bool		replace;	/* specifies whether to replace */  {      register int	i;      int			count;$     XStandardColormap	*stdcmaps, *s;*     Window		win = RootWindow(dpy, screen);  -     /* The property does not already exist */   D     if (! XGetRGBColormaps(dpy, win, &stdcmaps, &count, property)) {	 	if (new) 2 	    XSetRGBColormaps(dpy, win, new, 1, property);
 	return 0;     }   G     /* The property exists and is not describing the RGB_DEFAULT_MAP */   )     if (property != XA_RGB_DEFAULT_MAP) {  	if (replace) { 6 	    XmuDeleteStandardColormap(dpy, screen, property);
 	    if (new) / 		XSetRGBColormaps(dpy, win, new, 1, property);  	} 	XFree((char *)stdcmaps); 
 	return 1;     }   4     /* The property exists and is RGB_DEFAULT_MAP */     M     for (i=0, s=stdcmaps; (i < count) && (s->visualid != visualid); i++, s++)  	;  @     /* No RGB_DEFAULT_MAP property matches the given visualid */       if (i == count) {  	if (new) { ! 	    XStandardColormap	*m, *maps;   D 	    s = (XStandardColormap *) malloc((unsigned) ((count+1) * sizeof! 					      (XStandardColormap)));   G 	    for (i = 0, m = s, maps = stdcmaps; i < count; i++, m++, maps++) { ! 		m->colormap   = maps->colormap;   		m->red_max    = maps->red_max;! 		m->red_mult   = maps->red_mult; " 		m->green_max  = maps->green_max;# 		m->green_mult = maps->green_mult; ! 		m->blue_max   = maps->blue_max; " 		m->blue_mult  = maps->blue_mult;! 		m->visualid   = maps->visualid;  		m->killid     = maps->killid;  	    }# 	    m->colormap   = new->colormap; " 	    m->red_max    = new->red_max;# 	    m->red_mult   = new->red_mult; $ 	    m->green_max  = new->green_max;% 	    m->green_mult = new->green_mult; # 	    m->blue_max   = new->blue_max; $ 	    m->blue_mult  = new->blue_mult;# 	    m->visualid   = new->visualid; ! 	    m->killid     = new->killid;   6 	    XSetRGBColormaps(dpy, win, s, ++count, property); 	    free((char *) s); 	} 	XFree((char *) stdcmaps);
 	return 0;     }   D     /* Found an RGB_DEFAULT_MAP property with a matching visualid */       if (replace) {A 	/* Free old resources first - we may need them, particularly in  B 	 * the default colormap of the screen.  However, because of this,B 	 * it is possible that we will destroy the old resource and fail 7 	 * to create a new one if XmuStandardColormap() fails.  	 */   	if (count == 1) {6 	    XmuDeleteStandardColormap(dpy, screen, property);
 	    if (new) / 		XSetRGBColormaps(dpy, win, new, 1, property);  	} 	else {  	    XStandardColormap	*map;  ; 	    /* s still points to the matching standard colormap */   1 	    if (s->killid == ReleaseByFreeingColormap) {  		if ((s->colormap != None) &&4 		    (s->colormap != DefaultColormap(dpy, screen)))& 		    XFreeColormap(dpy, s->colormap); 	    }  	    else if (s->killid != None) 		XKillClient(dpy, s->killid);  , 	    map = (new) ? new : stdcmaps + --count;  # 	    s->colormap   = map->colormap; " 	    s->red_max    = map->red_max;# 	    s->red_mult   = map->red_mult; $ 	    s->green_max  = map->green_max;% 	    s->green_mult = map->green_mult; # 	    s->blue_max   = map->blue_max; $ 	    s->blue_mult  = map->blue_mult;# 	    s->visualid   = map->visualid; ! 	    s->killid     = map->killid;   ; 	    XSetRGBColormaps(dpy, win, stdcmaps, count, property);  	}     }      XFree((char *) stdcmaps); 
     return 1;  } 