D /* $XConsortium: DisplayQue.h,v 1.5 91/07/22 23:45:45 converse Exp $  *7  * Copyright 1989 Massachusetts Institute of Technology   *N  * Permission to use, copy, modify, distribute, and sell this software and itsM  * documentation for any purpose is hereby granted without fee, provided that E  * the above copyright notice appear in all copies and that both that C  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION I  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *  */    #ifndef _XMU_DISPLAYQUE_H_ #define _XMU_DISPLAYQUE_H_   #include <X11/Xmu/CloseHook.h> #include <X11/Xfuncproto.h>    /*  *			      Public Entry Points  *    *  ;  * XmuDisplayQueue *XmuDQCreate (closefunc, freefunc, data) *  *     XmuCloseDisplayQueueProc closefunc;(  *     XmuFreeDisplayQueueProc freefunc;  *     caddr_t data;  *  O  *         Creates and returns a queue into which displays may be placed.  When N  *         the display is closed, the closefunc (if non-NULL) is upcalled with  *         as follows:  *.  *                 (*closefunc) (queue, entry)  *L  *         The freeproc, if non-NULL, is called whenever the last display isK  *         closed, notifying the creator that display queue may be released   *         using XmuDQDestroy.  *  *%  * Bool XmuDQDestroy (q, docallbacks)   *     XmuDisplayQueue *q;  *     Bool docallbacks;  *  O  *         Releases all memory for the indicated display queue.  If docallbacks H  *         is true, then the closefunc (if non-NULL) is called for each   *         display.   *    *  4  * XmuDisplayQueueEntry *XmuDQLookupDisplay (q, dpy)  *     XmuDisplayQueue *q;  *     Display *dpy;  *K  *         Returns the queue entry for the specified display or NULL if the '  *         display is not in the queue.   *  *  7  * XmuDisplayQueueEntry *XmuDQAddDisplay (q, dpy, data)   *     XmuDisplayQueue *q;  *     Display *dpy;  *     caddr_t data;  *K  *         Adds the indicated display to the end of the queue or NULL if it K  *         is unable to allocate memory.  The data field may be used by the N  *         caller to attach arbitrary data to this display in this queue.  TheM  *         caller should use XmuDQLookupDisplay to make sure that the display %  *         hasn't already been added.   *    *  #  * Bool XmuDQRemoveDisplay (q, dpy)   *     XmuDisplayQueue *q;  *     Display *dpy;  *G  *         Removes the specified display from the given queue.  If the  K  *         indicated display is not found on this queue, False is returned, &  *         otherwise True is returned.  */   0 typedef struct _XmuDisplayQueue XmuDisplayQueue;: typedef struct _XmuDisplayQueueEntry XmuDisplayQueueEntry;  ( typedef int (*XmuCloseDisplayQueueProc)( #if NeedFunctionPrototypes"     XmuDisplayQueue*		/* queue */,%     XmuDisplayQueueEntry*	/* entry */  #endif );  ' typedef int (*XmuFreeDisplayQueueProc)(  #if NeedFunctionPrototypes!     XmuDisplayQueue*		/* queue */  #endif );   struct _XmuDisplayQueueEntry {.     struct _XmuDisplayQueueEntry *prev, *next;     Display *display;      CloseHook closehook;     caddr_t data;  };   struct _XmuDisplayQueue {      int nentries; &     XmuDisplayQueueEntry *head, *tail;'     XmuCloseDisplayQueueProc closefunc; %     XmuFreeDisplayQueueProc freefunc;      caddr_t data;  };   _XFUNCPROTOBEGIN  $ extern XmuDisplayQueue *XmuDQCreate( #if NeedFunctionPrototypes-     XmuCloseDisplayQueueProc	/* closefunc */, +     XmuFreeDisplayQueueProc	/* freefunc */,      caddr_t	/* data */ #endif );   extern Bool XmuDQDestroy(  #if NeedFunctionPrototypes     XmuDisplayQueue*	/* q */,      Bool		/* docallbacks */  #endif );  0 extern XmuDisplayQueueEntry *XmuDQLookupDisplay( #if NeedFunctionPrototypes     XmuDisplayQueue*	/* q */,      Display*		/* dpy */  #endif );  - extern XmuDisplayQueueEntry *XmuDQAddDisplay(  #if NeedFunctionPrototypes     XmuDisplayQueue*	/* q */,      Display*		/* dpy */,     caddr_t		/* data */  #endif );   extern Bool XmuDQRemoveDisplay(  #if NeedFunctionPrototypes     XmuDisplayQueue*	/* q */,      Display*		/* dpy */  #endif );   _XFUNCPROTOEND  ) #define XmuDQNDisplays(q) ((q)->nentries)    #endif /* _XMU_DISPLAYQUE_H_ */ 