 /*D  * $XConsortium: DisplayQue.c,v 1.4 91/05/28 16:16:46 converse Exp $  *7  * Copyright 1989 Massachusetts Institute of Technology   *H  * Permission to use, copy, modify, and distribute this software and itsL  * documentation for any purpose and without fee is hereby granted, providedJ  * that the above copyright notice appear in all copies and that both thatC  * copyright notice and this permission notice appear in supporting H  * documentation, and that the name of M.I.T. not be used in advertisingL  * or publicity pertaining to distribution of the software without specific,G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION J  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *(  * Author:  Jim Fulton, MIT X Consortium  */    #include <stdio.h> #include <X11/Xos.h> #include <X11/Xlib.h>  #include <X11/Xmu/DisplayQue.h>    static int _DQCloseDisplay();   D #define CallCloseCallback(q,e) (void) (*((q)->closefunc)) ((q), (e)); #define CallFreeCallback(q) (void) (*((q)->freefunc)) ((q))    /*'  * XmuDQCreate - create a display queue   */ 8 XmuDisplayQueue *XmuDQCreate (closefunc, freefunc, data)'     XmuCloseDisplayQueueProc closefunc; %     XmuFreeDisplayQueueProc freefunc;      caddr_t data;  { O     XmuDisplayQueue *q = (XmuDisplayQueue *) malloc (sizeof (XmuDisplayQueue));      if (q) { 	q->nentries = 0;  	q->head = q->tail = NULL; 	q->closefunc = closefunc; 	q->freefunc = freefunc; 	q->data = data;     } 
     return q;  }      /*G  * XmuDQDestroy - free all storage associated with this display queue,  +  * optionally invoking the close callbacks.   */   " Bool XmuDQDestroy (q, docallbacks)     XmuDisplayQueue *q;      Bool docallbacks;  { &     XmuDisplayQueueEntry *e = q->head;       while (e) { ' 	XmuDisplayQueueEntry *nexte = e->next; ; 	if (docallbacks && q->closefunc) CallCloseCallback (q, e);  	free ((char *) e);  	e = nexte;      }      free ((char *) q);     return True; }      /*F  * XmuDQLookupDisplay - finds the indicated display on the given queue  */ 1 XmuDisplayQueueEntry *XmuDQLookupDisplay (q, dpy)      XmuDisplayQueue *q;      Display *dpy;  {      XmuDisplayQueueEntry *e;  '     for (e = q->head; e; e = e->next) { ! 	if (e->display == dpy) return e;      }      return NULL; }      /*J  * XmuDQAddDisplay - add the specified display to the queue; set data as aD  * convenience.  Does not ensure that dpy hasn't already been added.  */ 4 XmuDisplayQueueEntry *XmuDQAddDisplay (q, dpy, data)     XmuDisplayQueue *q;      Display *dpy;      caddr_t data;  {      XmuDisplayQueueEntry *e;  Q     if (!(e = (XmuDisplayQueueEntry *) malloc (sizeof (XmuDisplayQueueEntry)))) { 
 	return NULL;      } F     if (!(e->closehook = XmuAddCloseDisplayHook (dpy, _DQCloseDisplay, 						 (caddr_t) q))) {  	free ((char *) e); 
 	return NULL;      }        e->display = dpy;      e->next = NULL;      e->data = data;        if (q->tail) { 	q->tail->next = e;  	e->prev = q->tail;      } else {
 	q->head = e;  	e->prev = NULL;     }      q->tail = e;     q->nentries++;
     return e;  }      /*C  * XmuDQRemoveDisplay - remove the specified display from the queue   */   Bool XmuDQRemoveDisplay (q, dpy)     XmuDisplayQueue *q;      Display *dpy;  {      XmuDisplayQueueEntry *e;  '     for (e = q->head; e; e = e->next) {  	if (e->display == dpy) {  	    if (q->head == e): 	      q->head = e->next;	/* if at head, then bump head */	 	    else 5 	      e->prev->next = e->next;	/* else splice out */  	    if (q->tail == e): 	      q->tail = e->prev;	/* if at tail, then bump tail */	 	    else 5 	      e->next->prev = e->prev;	/* else splice out */ 9 	    (void) XmuRemoveCloseDisplayHook (dpy, e->closehook, ) 					      _DQCloseDisplay, (caddr_t) q);  	    free ((char *) e);  	    q->nentries--;  	    return True;  	}     }      return False;  }     N /*****************************************************************************;  *			       private functions                             * O  *****************************************************************************/    /*M  * _DQCloseDisplay - upcalled from CloseHook to notify this queue; remove the   * display when finished  */ % static int _DQCloseDisplay (dpy, arg)      Display *dpy;      caddr_t arg; { 1     XmuDisplayQueue *q = (XmuDisplayQueue *) arg;      XmuDisplayQueueEntry *e;  '     for (e = q->head; e; e = e->next) {  	if (e->display == dpy) { 0 	    if (q->closefunc) CallCloseCallback (q, e);( 	    (void) XmuDQRemoveDisplay (q, dpy);? 	    if (q->nentries == 0 && q->freefunc) CallFreeCallback (q);  	    return 1; 	}     }   
     return 0;  } 