@ /* $XConsortium: CrCmap.c,v 1.3 91/04/10 16:45:46 converse Exp $  *F  * CreateCmap.c - given a standard colormap description, make the map.  *  >  * Copyright 1989 by the Massachusetts Institute of Technology  *H  * Permission to use, copy, modify, and distribute this software and itsM  * documentation for any purpose and without fee is hereby granted, provided  K  * that the above copyright notice appear in all copies and that both that  D  * copyright notice and this permission notice appear in supporting H  * documentation, and that the name of M.I.T. not be used in advertisingM  * or publicity pertaining to distribution of the software without specific,  G  * written prior permission. M.I.T. makes no representations about the  H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION I  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *,  * Author:  Donna Converse, MIT X Consortium  */    #include <stdio.h> #include <X11/Xlib.h>  #include <X11/Xutil.h>   extern char	*calloc();  8 static int	ROmap();		/* allocate entire map Read Only */D static Status	ROorRWcell();		/* allocate a cell, prefer Read Only */9 static Status	RWcell();		/* allocate a cell Read Write */ * static int	compare();		/* for quicksort */E static Status 	contiguous();		/* find contiguous sequence of cells */ @ static void	free_cells();		/* frees resources before quitting */E static Status	readonly_map();		/* create a map in a RO visual type */ E static Status	readwrite_map();	/* create a map in a RW visual type */    /*H  * To create any one colormap which is described by an XStandardColormap&  * structure, use XmuCreateColormap().  *,  * Return 0 on failure, non-zero on success.=  * Resources created by this function are not made permanent. A  * No argument error checking is provided.  Use at your own risk.   *K  * All colormaps are created with read only allocations, with the exception E  * of read only allocations of colors in the default map or otherwise M  * which fail to return the expected pixel value, and these are individually  I  * defined as read/write allocations.  This is done so that all the cells J  * defined in the default map are contiguous, for use in image processing.B  * This typically happens with White and Black in the default map.  *K  * Colormaps of static visuals are considered to be successfully created if C  * the map of the static visual matches the definition given in the   * standard colormap structure.   */      ' Status XmuCreateColormap(dpy, colormap) 6     Display		*dpy;		/* specifies the connection under # 					 * which the map is created */ D     XStandardColormap	*colormap;	/* specifies the map to be created,( 					 * and returns, particularly if the) 					 * map is created as a subset of the ' 					 * default colormap of the screen, " 					 * the base_pixel of the map. 					 */ { B     XVisualInfo		vinfo_template;	/* template visual information */;     XVisualInfo		*vinfo;		/* matching visual information */ =     XVisualInfo		*vpointer;	/* for freeing the entire list */ ;     long		vinfo_mask;	/* specifies the visual mask value */ .     int 		n;		/* number of matching visuals */     int			status;		   1     vinfo_template.visualid = colormap->visualid;      vinfo_mask = VisualIDMask;O     if ((vinfo = XGetVisualInfo(dpy, vinfo_mask, &vinfo_template, &n)) == NULL) 
 	return 0;  F     /* A visual id may be valid on multiple screens.  Also, there may K      * be multiple visuals with identical visual ids at different depths.   G      * If the colormap is the Default Colormap, use the Default Visual. 6      * Otherwise, arbitrarily, use the deepest visual.      */      vpointer = vinfo;      if (n > 1)     {  	register int	i; 	register int	screen_number; 	Bool 		def_cmap;    	def_cmap = False;? 	for (screen_number = ScreenCount(dpy); --screen_number >= 0; ) E 	    if (colormap->colormap == DefaultColormap(dpy, screen_number)) {  		def_cmap = True; 		break; 	    }   	if (def_cmap) {% 	    for (i=0; i < n; i++, vinfo++) { 9 		if (vinfo->visual == DefaultVisual(dpy, screen_number)) 	 			break;  	    }	 	} else {  	    unsigned int	maxdepth = 0;  	    XVisualInfo		*v;   # 	    for (i=0; i < n; i++, vinfo++)   		if (vinfo->depth > maxdepth) { 		    maxdepth = vinfo->depth; 		    v = vinfo; 		}  	    vinfo = v;  	}     }   E     if (vinfo->class == PseudoColor || vinfo->class == DirectColor ||  	vinfo->class == GrayScale) . 	status = readwrite_map(dpy, vinfo, colormap);	     else  - 	status = readonly_map(dpy, vinfo, colormap);           XFree((char *) vpointer);      return status; }   N /****************************************************************************/1 static Status readwrite_map(dpy, vinfo, colormap)      Display		*dpy;     XVisualInfo		*vinfo;      XStandardColormap	*colormap; { ,     register int	i, n;		/* index counters */7     int			ncolors;	/* number of colors to be defined */ 7     int			npixels;	/* number of pixels allocated R/W */ 9     int			first_index;	/* first index of pixels to use */ 3     int			remainder;	/* first index of remainder */ 3     XColor		color;		/* the definition of a color */ 9     unsigned long	*pixels;	/* array of colormap pixels */        =     /* Determine ncolors, the number of colors to be defined. 4      * Insure that 1 < ncolors <= the colormap size.      */ 6     ncolors = colormap->red_max * colormap->red_mult +3 	      colormap->green_max * colormap->green_mult + 4 	      colormap->blue_max * colormap->blue_mult + 1;A     if (ncolors <= 1 || ncolors > vinfo->colormap_size)	return 0;   J     /* Allocate Read/Write as much of the colormap as we can possibly get.B      * Then insure that the pixels we were allocated are given in G      * monotonically increasing order, using a quicksort.  Next, insure J      * that our allocation includes a subset of contiguous pixels at leastH      * as long as the number of colors to be defined.  Now we know that        * these conditions are met:2      *	1) There are no free cells in the colormap.B      *  2) We have a contiguous sequence of pixels, monotonically C      *     increasing, of length >= the number of colors requested.       *G      * One cell at a time, we will free, compute the next color value,  8      * then allocate read only.  This takes a long time.G      * This is done to insure that cells are allocated read only in the G      * contiguous order which we prefer.  If the server has a choice of J      * cells to grant to an allocation request, the server may give us any8      * cell, so that is why we do these slow gymnastics.      */   K     if ((pixels = (unsigned long *) calloc((unsigned) vinfo->colormap_size, * 				      sizeof(unsigned long))) == NULL)
 	return 0;  9     if ((npixels = ROmap(dpy, colormap->colormap, pixels, - 			   vinfo->colormap_size, ncolors)) == 0) {  	free((char *) pixels); 
 	return 0;     }   D     qsort((char *) pixels, npixels, sizeof(unsigned long), compare);  I     if (! contiguous(pixels, npixels, ncolors, &first_index, &remainder))      { 2 	/* can't find enough contiguous cells, give up */6 	XFreeColors(dpy, colormap->colormap, pixels, npixels, 		    (unsigned long) 0);  	free((char *) pixels); 
 	return 0;     } /     colormap->base_pixel = pixels[first_index];        /* construct a gray map */?     if (colormap->red_mult == 1 && colormap->green_mult == 1 &&  	colormap->blue_mult == 1)9 	for (n=colormap->base_pixel, i=0; i < ncolors; i++, n++)  	{% 	    color.pixel = (unsigned long) n; + 	    color.blue = color.green = color.red = 6 		(unsigned short) ((i * 65535) / (colormap->red_max + 						 colormap->green_max + 						 colormap->blue_max));  G 	    if (! ROorRWcell(dpy, colormap->colormap, pixels, npixels, &color,  			     first_index + i, n)) 		return 0;  	}  "     /* construct a red ramp map */A     else if (colormap->green_max == 0 && colormap->blue_max == 0) =     	for (n=colormap->base_pixel, i=0; i < ncolors; i++, n++)  	{% 	    color.pixel = (unsigned long) n; D 	    color.red = (unsigned short) ((i * 65535) / colormap->red_max);" 	    color.green = color.blue = 0;  G 	    if (! ROorRWcell(dpy, colormap->colormap, pixels, npixels, &color,  			     first_index + i, n)) 		return 0;  	}  $     /* construct a green ramp map */?     else if (colormap->red_max == 0 && colormap->blue_max == 0) =     	for (n=colormap->base_pixel, i=0; i < ncolors; i++, n++)  	{% 	    color.pixel = (unsigned long) n; H 	    color.green = (unsigned short) ((i * 65535) / colormap->green_max);  	    color.red = color.blue = 0;  G 	    if (! ROorRWcell(dpy, colormap->colormap, pixels, npixels, &color,  			     first_index + i, n)) 		return 0;  	}  #     /* construct a blue ramp map */ @     else if (colormap->red_max == 0 && colormap->green_max == 0)=     	for (n=colormap->base_pixel, i=0; i < ncolors; i++, n++)  	{% 	    color.pixel = (unsigned long) n; F 	    color.blue = (unsigned short) ((i * 65535) / colormap->blue_max);! 	    color.red = color.green = 0;   G 	    if (! ROorRWcell(dpy, colormap->colormap, pixels, npixels, &color,  			     first_index + i, n)) 		return 0;  	}  6     /* construct a standard red green blue cube map */     else     {  	int r = colormap->red_mult; 	int g = colormap->green_mult;" 	int gg = colormap->green_max + 1;  =     	for (n=colormap->base_pixel, i=0; i < ncolors; i++, n++)  	{% 	    color.pixel = (unsigned long) n; H 	    color.red = (unsigned short) (((i/r) * 65535) / colormap->red_max);; 	    color.green = (unsigned short) ((((i/g)%gg) * 65535) /  					    colormap->green_max);5 	    color.blue = (unsigned short) (((i%g) * 65535) /  					   colormap->blue_max);G 	    if (! ROorRWcell(dpy, colormap->colormap, pixels, npixels, &color,  			     first_index + i, n)) 		return 0;  	}     } ?     /* We have a read-only map defined.  Now free unused cells, B      * first those occuring before the contiguous sequence begins,2      * then any following the contiguous sequence.      */        if (first_index); 	XFreeColors(dpy, colormap->colormap, pixels, first_index,   		    (unsigned long) 0);      if (remainder)% 	XFreeColors(dpy, colormap->colormap, 2 		    &(pixels[first_index + ncolors]), remainder, 		    (unsigned long) 0);        free((char *) pixels);
     return 1;  }     N /****************************************************************************/) static int ROmap(dpy, cmap, pixels, m, n) 1     Display		*dpy;		/* the X server connection */ 0     Colormap		cmap;		/* specifies colormap ID */;     unsigned long	pixels[];	/* returns pixel allocations */ +     int			m;		/* specifies colormap size */ .     int			n;		/* specifies number of colors */ {      register int	p;   3     /* first try to allocate the entire colormap */ ?     if (XAllocColorCells(dpy, cmap, 1, (unsigned long *) NULL,  ( 			 (unsigned) 0, pixels, (unsigned) m))
 	return m;  C     /* Allocate all available cells in the colormap, using a binary L      * algorithm to discover how many cells we can allocate in the colormap.      */      m--;     while (n <= m) { 	p = n + ((m - n + 1) / 2); ; 	if (XAllocColorCells(dpy, cmap, 1, (unsigned long *) NULL, . 			     (unsigned) 0, pixels, (unsigned) p)) { 	    if (p == m) 		return p;  	    else { 7 		XFreeColors(dpy, cmap, pixels, p, (unsigned long) 0);  		n = p; 	    } 	} 	else  	    m = p - 1;      } 
     return 0;  }          N /****************************************************************************/> static Status contiguous(pixels, npixels, ncolors, first, rem)<     unsigned long	pixels[];	/* specifies allocated pixels */:     int			npixels;	/* specifies count of alloc'd pixels */9     int			ncolors;	/* specifies needed sequence length */ 8     int			*first;		/* returns first index of sequence */7     int			*rem;		/* returns first index after sequence,  					 * or 0, if none follow */  { A     register int i = 1;		/* walking index into the pixel array */ F     register int count = 1;	/* length of sequence discovered so far */       *rem = npixels - 1;      *first = 0; 6     while (count < ncolors && ncolors - count <= *rem)     { " 	if (pixels[i-1] + 1 == pixels[i])
 	    count++;  	else {  	    count = 1;  	    *first = i; 	} 	i++; 
 	(*rem)--;     }      if (count != ncolors) 
 	return 0;
     return 1;  }     N /****************************************************************************/A static Status ROorRWcell(dpy, cmap, pixels, npixels, color, p, n)      Display		*dpy;     Colormap		cmap;      unsigned long	pixels[];      int			npixels;     XColor		*color;      int			p;     int			n; {      unsigned long	pixel;     XColor		request;  B     /* Free the read/write allocation of one cell in the colormap.B      * Request a read only allocation of one cell in the colormap.F      * If the read only allocation cannot be granted, give up, because3      * there must be no free cells in the colormap. H      * If the read only allocation is granted, but gives us a cell whichF      * is not the one that we just freed, it is probably the case thatF      * we are trying allocate White or Black or some other color whichD      * already has a read-only allocation in the map.  So we try to G      * allocate the previously freed cell with a read/write allocation, H      * because we want contiguous cells for image processing algorithms.      */             pixel = (unsigned long) n;     request.red = color->red; !     request.green = color->green;      request.blue = color->blue;   9     XFreeColors(dpy, cmap, &pixel, 1, (unsigned long) 0); (     if (! XAllocColor(dpy, cmap, color)  	|| (color->pixel != pixel && 8 	    (!RWcell(dpy, cmap, color, &request, &pixel, n))))      { + 	free_cells(dpy, cmap, pixels, npixels, p); 
 	return 0;     } 
     return 1;  }     N /****************************************************************************/6 static void free_cells(dpy, cmap, pixels, npixels,  p)     Display		*dpy;     Colormap		cmap; -     unsigned long	pixels[];	/* to be freed */ 9     int			npixels;        /* original number allocated */      int			p;	    { ;     /* One of the npixels allocated has already been freed. )      * p is the index of the freed pixel. C      * First free the pixels preceeding p, and there are p of them; K      * then free the pixels following p, there are npixels - p - 1 of them.       */ 9     XFreeColors(dpy, cmap, pixels, p, (unsigned long) 0); O     XFreeColors(dpy, cmap, &(pixels[p+1]), npixels - p - 1, (unsigned long) 0);      free((char *) pixels); }     N /****************************************************************************/9 static Status RWcell(dpy, cmap, color, request, pixel, n)      Display		*dpy;     Colormap		cmap;      XColor		*color;      XColor		*request;      unsigned long	*pixel;      int			n; { A     XFreeColors(dpy, cmap, &(color->pixel), 1, (unsigned long)0); G     if (! XAllocColorCells(dpy, cmap, (Bool) 0, (unsigned long *) NULL, ) 			   (unsigned) 0, pixel, (unsigned) 1)) 
 	return 0;     if (*pixel != n)     { 5 	XFreeColors(dpy, cmap, pixel, 1, (unsigned long) 0); 
 	return 0;     }      color->pixel = *pixel;,     color->flags = DoRed | DoGreen | DoBlue;     color->red = request->red;"     color->green = request->green;      color->blue = request->blue;&     XStoreColors(dpy, cmap, color, 1);
     return 1;  }     N /****************************************************************************/ static int compare(e1, e2)     unsigned long	*e1, *e2;  {      if (*e1 < *e2)	return -1;      if (*e1 > *e2)	return 1;
     return 0;  }     N /****************************************************************************/0 static Status readonly_map(dpy, vinfo, colormap)     Display		*dpy;     XVisualInfo		*vinfo;      XStandardColormap	*colormap; {      int			i, last_pixel;     XColor		color;  G     last_pixel = (colormap->red_max + 1) * (colormap->green_max + 1) *  5 	(colormap->blue_max + 1) + colormap->base_pixel - 1;   7     for(i=colormap->base_pixel; i <= last_pixel; i++) {   ! 	color.pixel = (unsigned long) i;  	color.red = (unsigned short) < 	    (((i/colormap->red_mult) * 65535) / colormap->red_max);  @ 	if (vinfo->class == StaticColor || vinfo->class == TrueColor) {# 	    color.green = (unsigned short) < 		((((i/colormap->green_mult) % (colormap->green_max + 1)) *" 		  65535) / colormap->green_max);" 	    color.blue = (unsigned short)< 		(((i%colormap->green_mult) * 65535) / colormap->blue_max); 	}? 	else	/* vinfo->class == GrayScale, old style allocation XXX */ * 	    color.green = color.blue = color.red;  . 	XAllocColor(dpy, colormap->colormap, &color);& 	if (color.pixel != (unsigned long) i) 	    return 0;     } 
     return 1;  } 