 /*A  * $XConsortium: CmapAlloc.c,v 1.4 91/07/19 16:36:50 gildea Exp $   *  >  * Copyright 1989 by the Massachusetts Institute of Technology  *H  * Permission to use, copy, modify, and distribute this software and itsM  * documentation for any purpose and without fee is hereby granted, provided  K  * that the above copyright notice appear in all copies and that both that  D  * copyright notice and this permission notice appear in supporting H  * documentation, and that the name of M.I.T. not be used in advertisingM  * or publicity pertaining to distribution of the software without specific,  G  * written prior permission. M.I.T. makes no representations about the  H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION I  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *,  * Author:  Donna Converse, MIT X Consortium  */    #include <X11/Xlib.h>  #include <X11/Xatom.h> #include <X11/Xutil.h> #include <stdio.h>    static int default_allocation(); static void best_allocation(); static void gray_allocation(); static int icbrt();  static int icbrt_with_bits();  static int icbrt_with_guess();  D /* To determine the best allocation of reds, greens, and blues in a 3  * standard colormap, use XmuGetColormapAllocation. ;  * 	vinfo		specifies visual information for a chosen visual A  *	property	specifies one of the standard colormap property names '  * 	red_max		returns maximum red value  -  *      green_max	returns maximum green value '  * 	blue_max	returns maximum blue value   *F  * XmuGetColormapAllocation returns 0 on failure, non-zero on success.J  * It is assumed that the visual is appropriate for the colormap property.  */   N Status XmuGetColormapAllocation(vinfo, property, red_max, green_max, blue_max)     XVisualInfo		*vinfo;     Atom		property; 2     unsigned long	*red_max, *green_max, *blue_max; {      Status 	status = 1;   "     if (vinfo->colormap_size <= 2)
 	return 0;       switch (property)      {        case XA_RGB_DEFAULT_MAP:B 	status = default_allocation(vinfo, red_max, green_max, blue_max); 	break;        case XA_RGB_BEST_MAP: 6 	best_allocation(vinfo, red_max, green_max, blue_max); 	break;        case XA_RGB_GRAY_MAP: E 	gray_allocation(vinfo->colormap_size, red_max, green_max, blue_max);  	break;        case XA_RGB_RED_MAP:% 	*red_max = vinfo->colormap_size - 1;  	*green_max = *blue_max = 0; 	break;        case XA_RGB_GREEN_MAP:' 	*green_max = vinfo->colormap_size - 1;  	*red_max = *blue_max = 0; 	break;        case XA_RGB_BLUE_MAP: & 	*blue_max = vinfo->colormap_size - 1; 	*red_max = *green_max = 0;  	break;        default: 	status = 0;     }      return status; }   N /****************************************************************************/? /* Determine the appropriate color allocations of a gray scale.   *"  * Keith Packard, MIT X Consortium  */   < static void gray_allocation(n, red_max, green_max, blue_max)7     int		n;	/* the number of cells of the gray scale */ 2     unsigned long *red_max, *green_max, *blue_max; {      *red_max = (n * 30) / 100;!     *green_max = (n * 59) / 100;        *blue_max = (n * 11) / 100; B     *green_max += ((n - 1) - (*red_max + *green_max + *blue_max)); }   N /****************************************************************************/E /* Determine an appropriate color allocation for the RGB_DEFAULT_MAP. J  * If a map has less than a minimum number of definable entries, we do not2  * produce an allocation for an RGB_DEFAULT_MAP.    *K  * For 24 planes, the default colormap will have 64 reds, 64 greens, and 64 J  * blues.  For 8 planes, let n = the number of colormap entries, which mayK  * be 256 or 254.  Then, maximum red value = floor(cube_root(n - 125)) - 1. F  * Maximum green and maximum blue values are identical to maximum red.=  * This leaves at least 125 cells which clients can allocate.   *E  * Return 0 if an allocation has been determined, non-zero otherwise.   */   6 static int default_allocation(vinfo, red, green, blue)     XVisualInfo		*vinfo;&     unsigned long	*red, *green, *blue; { -     int			ngrays;		/* number of gray cells */   1     if (vinfo->colormap_size < 250)	/* skip it */ 
 	return 0;       switch (vinfo->class) {        case PseudoColor:        case DirectColor:   # 	if (vinfo->colormap_size > 500000) / 	    /* intended for displays with 24 planes */ 0 	    *red = *green = *blue = (unsigned long) 63;& 	else if (vinfo->colormap_size > 4000)/ 	    /* intended for displays with 12 planes */ 0 	    *red = *green = *blue = (unsigned long) 12; 	else . 	    /* intended for displays with 8 planes */, 	    *red = *green = *blue = (unsigned long)* 		(icbrt(vinfo->colormap_size - 125) - 1); 	break;          case GrayScale:   $ 	if (vinfo->colormap_size > 5000000) 	    ngrays = 4096; & 	else if (vinfo->colormap_size > 4000) 	    ngrays = 512; 	else  	    ngrays = 12; + 	gray_allocation(ngrays, red, green, blue);  	break;  	        default:
 	return 0;     } 
     return 1;  }   N /****************************************************************************/B /* Determine an appropriate color allocation for the RGB_BEST_MAP.  *F  * For a DirectColor or TrueColor visual, the allocation is determinedI  * by the red_mask, green_mask, and blue_mask members of the visual info.   *G  * Otherwise, if the colormap size is an integral power of 2, determine F  * the allocation according to the number of bits given to each color,E  * with green getting more than red, and red more than blue, if there E  * are to be inequities in the distribution.  If the colormap size is F  * not an integral power of 2, let n = the number of colormap entries.4  * Then maximum red value = floor(cube_root(n)) - 1;1  * 	maximum blue value = floor(cube_root(n)) - 1; D  *	maximum green value = n / ((# red values) * (# blue values)) - 1;F  * Which, on a GPX, allows for 252 entries in the best map, out of 254  * defineable colormap entries.   */    4 static void best_allocation(vinfo, red, green, blue)     XVisualInfo		*vinfo;&     unsigned long	*red, *green, *blue; {   A     if (vinfo->class == DirectColor ||	vinfo->class == TrueColor)      {  	*red = vinfo->red_mask; 	while ((*red & 01) == 0)  	    *red >>= 1; 	*green = vinfo->green_mask; 	while ((*green & 01) == 0)  	    *green >>=1;  	*blue = vinfo->blue_mask; 	while ((*blue & 01) == 0) 	    *blue >>= 1;      }      else     {  	register int bits, n; 	 E 	/* Determine n such that n is the least integral power of 2 which is C 	 * greater than or equal to the number of entries in the colormap.           */  	n = 1; 
 	bits = 0;! 	while (vinfo->colormap_size > n)  	{ 	    n = n << 1; 	    bits++; 	} 	 G 	/* If the number of entries in the colormap is a power of 2, determine H 	 * the allocation by "dealing" the bits, first to green, then red, thenH 	 * blue.  If not, find the maximum integral red, green, and blue valuesA 	 * which, when multiplied together, do not exceed the number of     	 * colormap entries.  	 */ 	if (n == vinfo->colormap_size)  	{ 	    register int r, g, b; 	    b = bits / 3;" 	    g = b + ((bits % 3) ? 1 : 0);) 	    r = b + (((bits % 3) == 2) ? 1 : 0);  	    *red = 1 << r;  	    *green = 1 << g;  	    *blue = 1 << b; 	} 	else  	{8 	    *red = icbrt_with_bits(vinfo->colormap_size, bits); 	    *blue = *red;	 : 	    *green = (vinfo->colormap_size / ((*red) * (*blue))); 	}
 	(*red)--; 	(*green)--; 	(*blue)--;      }      return;  }    /*(  * integer cube roots by Newton's method  *.  * Stephen Gildea, MIT X Consortium, July 1991  */   , static int icbrt(a)		/* integer cube root */
     int a; {      register int bits = 0;     register unsigned n = a;  
     while (n)      {  	bits++;	 	n >>= 1;      } $     return icbrt_with_bits(a, bits); }     # static int icbrt_with_bits(a, bits) 
     int a;      int bits;			/* log 2 of a */ { ,     return icbrt_with_guess(a, a>>2*bits/3); }    #ifdef _X_ROOT_STATS int icbrt_loopcount; #endif  : /* Newton's Method:  x_n+1 = x_n - ( f(x_n) / f'(x_n) ) */  ? /* for cube roots, x^3 - a = 0,  x_new = x - 1/3 (x - a/x^2) */    /*I  * Quick and dirty cube roots.  Nothing fancy here, just Newton's method. ?  * Only works for positive integers (since that's all we need). K  * We actually return floor(cbrt(a)) because that's what we need here, too.   */   % static int icbrt_with_guess(a, guess)      int a, guess;  {      register int delta;    #ifdef _X_ROOT_STATS     icbrt_loopcount = 0; #endif     if (a <= 0) 
 	return 0;     if (guess < 1) 	guess = 1;        do { #ifdef _X_ROOT_STATS 	icbrt_loopcount++;  #endif% 	delta = (guess - a/(guess*guess))/3;  #ifdef DEBUGH 	printf("pass %d: guess=%d, delta=%d\n", icbrt_loopcount, guess, delta); #endif 	guess -= delta;     } while (delta != 0);        if (guess*guess*guess > a)	 	guess--;        return guess;  } 