F /* $XConsortium: Viewport.c,v 1.68 91/07/24 18:56:11 converse Exp $ */  < /***********************************************************N Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,H and the Massachusetts Institute of Technology, Cambridge, Massachusetts.  +                         All Rights Reserved   F Permission to use, copy, modify, and distribute this software and its A documentation for any purpose and without fee is hereby granted,  F provided that the above copyright notice appear in all copies and that@ both that copyright notice and this permission notice appear in E supporting documentation, and that the names of Digital or MIT not be B used in advertising or publicity pertaining to distribution of the6 software without specific, written prior permission.    H DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDINGH ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALLG DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR C ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, F WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,C ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 	 SOFTWARE.   C ******************************************************************/    #include <X11/IntrinsicP.h>  #include <X11/StringDefs.h>    #include <X11/Xaw/XawInit.h> #include <X11/Xmu/Misc.h>  #include <X11/Xaw/Scrollbar.h> #include <X11/Xaw/ViewportP.h>  , static void ScrollUpDownProc(), ThumbProc(); static Boolean GetGeometry();   # static void ComputeWithForceBars();   = #define offset(field) XtOffsetOf(ViewportRec, viewport.field) ! static XtResource resources[] = { ;     {XtNforceBars, XtCBoolean, XtRBoolean, sizeof(Boolean), 5 	 offset(forcebars), XtRImmediate, (XtPointer)False}, <     {XtNallowHoriz, XtCBoolean, XtRBoolean, sizeof(Boolean),6 	 offset(allowhoriz), XtRImmediate, (XtPointer)False},;     {XtNallowVert, XtCBoolean, XtRBoolean, sizeof(Boolean), 5 	 offset(allowvert), XtRImmediate, (XtPointer)False}, ;     {XtNuseBottom, XtCBoolean, XtRBoolean, sizeof(Boolean), 5 	 offset(usebottom), XtRImmediate, (XtPointer)False}, :     {XtNuseRight, XtCBoolean, XtRBoolean, sizeof(Boolean),4 	 offset(useright), XtRImmediate, (XtPointer)False},J     {XtNreportCallback, XtCReportCallback, XtRCallback, sizeof(XtPointer),< 	 offset(report_callbacks), XtRImmediate, (XtPointer) NULL}, };
 #undef offset   1 static void Initialize(), ConstraintInitialize(), )     Realize(), Resize(), ChangeManaged(); % static Boolean SetValues(), Layout(); ? static XtGeometryResult GeometryManager(), PreferredGeometry();   " #define superclass	(&formClassRec)% ViewportClassRec viewportClassRec = {    { /* core_class fields */ 0     /* superclass	  */	(WidgetClass) superclass,"     /* class_name	  */	"Viewport",,     /* widget_size	  */	sizeof(ViewportRec),4     /* class_initialize	  */	XawInitializeWidgetSet,%     /* class_part_init    */    NULL,      /* class_inited	  */	FALSE, "     /* initialize	  */	Initialize,%     /* initialize_hook    */    NULL,      /* realize		  */	Realize,      /* actions		  */	NULL,     /* num_actions	  */	0,      /* resources	  */	resources,.     /* num_resources	  */	XtNumber(resources),      /* xrm_class	  */	NULLQUARK,!     /* compress_motion	  */	TRUE, "     /* compress_exposure  */	TRUE,%     /* compress_enterleave*/    TRUE, #     /* visible_interest	  */	FALSE,      /* destroy		  */	NULL,     /* resize		  */	Resize, $     /* expose		  */	XtInheritExpose,!     /* set_values	  */	SetValues, %     /* set_values_hook    */    NULL, 9     /* set_values_almost  */    XtInheritSetValuesAlmost, "     /* get_values_hook    */	NULL,     /* accept_focus	  */	NULL,*     /* version            */    XtVersion,"     /* callback_private	  */	NULL,     /* tm_table    	  */	NULL,2     /* query_geometry     */    PreferredGeometry,9     /* display_accelerator*/	XtInheritDisplayAccelerator, !     /* extension          */	NULL    },    { /* composite_class fields */-     /* geometry_manager	  */	GeometryManager, )     /* change_managed	  */	ChangeManaged, .     /* insert_child	  */	XtInheritInsertChild,.     /* delete_child	  */	XtInheritDeleteChild,!     /* extension          */	NULL    },!   { /* constraint_class fields */      /* subresourses	  */	NULL,     /* subresource_count  */	0, ;     /* constraint_size	  */	sizeof(ViewportConstraintsRec), ,     /* initialize	  */	ConstraintInitialize,     /* destroy		  */	NULL,     /* set_values	  */	NULL,!     /* extension          */	NULL    },   { /* form_class fields */      /* layout		  */	Layout   },   { /* viewport_class fields */      /* empty		  */	0   }  };    A WidgetClass viewportWidgetClass = (WidgetClass)&viewportClassRec;   , static Widget CreateScrollbar(w, horizontal)     ViewportWidget w;      Boolean horizontal;  { #     Widget clip = w->viewport.clip; %     ViewportConstraints constraints = - 	(ViewportConstraints)clip->core.constraints;      static Arg barArgs[] = { 	{XtNorientation, NULL}, 	{XtNlength, NULL},  	{XtNleft, NULL},  	{XtNright, NULL}, 	{XtNtop, NULL}, 	{XtNbottom, NULL},  	{XtNmappedWhenManaged, False},      };     Widget bar;   (     XtSetArg(barArgs[0], XtNorientation,< 	      horizontal ? XtorientHorizontal : XtorientVertical );#     XtSetArg(barArgs[1], XtNlength, 9 	     horizontal ? clip->core.width : clip->core.height); !     XtSetArg(barArgs[2], XtNleft, J 	     (!horizontal && w->viewport.useright) ? XtChainRight : XtChainLeft);"     XtSetArg(barArgs[3], XtNright,K 	     (!horizontal && !w->viewport.useright) ? XtChainLeft : XtChainRight);       XtSetArg(barArgs[4], XtNtop,I 	     (horizontal && w->viewport.usebottom) ? XtChainBottom: XtChainTop); #     XtSetArg(barArgs[5], XtNbottom, J 	     (horizontal && !w->viewport.usebottom) ? XtChainTop: XtChainBottom);  C     bar = XtCreateWidget( (horizontal ? "horizontal" : "vertical"), % 			  scrollbarWidgetClass, (Widget)w, " 			  barArgs, XtNumber(barArgs) );H     XtAddCallback( bar, XtNscrollProc, ScrollUpDownProc, (XtPointer)w );?     XtAddCallback( bar, XtNjumpProc, ThumbProc, (XtPointer)w );        if (horizontal) {  	w->viewport.horiz_bar = bar; # 	constraints->form.vert_base = bar;      } 
     else { 	w->viewport.vert_bar = bar;$ 	constraints->form.horiz_base = bar;     }        XtManageChild( bar );        return bar;  }    /* ARGSUSED */$ static void Initialize(request, new)     Widget request, new; { +     ViewportWidget w = (ViewportWidget)new;      static Arg clip_args[8];     Cardinal num_args;     Widget h_bar, v_bar;&     Dimension clip_height, clip_width;  N     w->form.default_spacing = 0;  /* Reset the default spacing to 0 pixels. */     /*  *  * Initialize all widget pointers to NULL.  */   &     w->viewport.child = (Widget) NULL;@     w->viewport.horiz_bar = w->viewport.vert_bar = (Widget)NULL;   /*    * Create Clip Widget.  */        num_args = 0; I     XtSetArg(clip_args[num_args], XtNbackgroundPixmap, None); num_args++; A     XtSetArg(clip_args[num_args], XtNborderWidth, 0); num_args++; D     XtSetArg(clip_args[num_args], XtNleft, XtChainLeft); num_args++;F     XtSetArg(clip_args[num_args], XtNright, XtChainRight); num_args++;B     XtSetArg(clip_args[num_args], XtNtop, XtChainTop); num_args++;H     XtSetArg(clip_args[num_args], XtNbottom, XtChainBottom); num_args++;G     XtSetArg(clip_args[num_args], XtNwidth, w->core.width); num_args++; I     XtSetArg(clip_args[num_args], XtNheight, w->core.height); num_args++;   F     w->viewport.clip = XtCreateManagedWidget("clip", widgetClass, new, 					     clip_args, num_args);         if (!w->viewport.forcebars) H         return;		 /* If we are not forcing the bars then we are done. */        if (w->viewport.allowhoriz) &       (void) CreateScrollbar(w, True);     if (w->viewport.allowvert)  '       (void) CreateScrollbar(w, False);   "     h_bar = w->viewport.horiz_bar;!     v_bar = w->viewport.vert_bar;    /*-  * Set the clip widget to the correct height.   */        clip_width = w->core.width; !     clip_height = w->core.height;        if ( (h_bar != NULL) &&  	 ((int)w->core.width > 9 	  (int)(h_bar->core.width + h_bar->core.border_width)) ) C         clip_width -= h_bar->core.width + h_bar->core.border_width;           if ( (v_bar != NULL) &&  	 ((int)w->core.height >: 	  (int)(v_bar->core.height + v_bar->core.border_width)) )E         clip_height -= v_bar->core.height + v_bar->core.border_width;        num_args = 0; D     XtSetArg(clip_args[num_args], XtNwidth, clip_width); num_args++;F     XtSetArg(clip_args[num_args], XtNheight, clip_height); num_args++;7     XtSetValues(w->viewport.clip, clip_args, num_args);  }    /* ARGSUSED */. static void ConstraintInitialize(request, new)     Widget request, new; { N     ((ViewportConstraints)new->core.constraints)->viewport.reparented = False; }   3 static void Realize(widget, value_mask, attributes)      Widget widget;     XtValueMask *value_mask;%     XSetWindowAttributes *attributes;  { .     ViewportWidget w = (ViewportWidget)widget;.     register Widget child = w->viewport.child;,     register Widget clip = w->viewport.clip;        *value_mask |= CWBitGravity;/     attributes->bit_gravity = NorthWestGravity; F     (*superclass->core_class.realize)(widget, value_mask, attributes);  J     (*w->core.widget_class->core_class.resize)(widget);	/* turn on bars */        if (child != (Widget)NULL) {1 	XtMoveWidget( child, (Position)0, (Position)0 );  	XtRealizeWidget( clip );  	XtRealizeWidget( child );@ 	XReparentWindow( XtDisplay(w), XtWindow(child), XtWindow(clip), 			 (Position)0, (Position)0 );  	XtMapWidget( child );     }  }    /* ARGSUSED *// static Boolean SetValues(current, request, new) !     Widget current, request, new;  { +     ViewportWidget w = (ViewportWidget)new; 0     ViewportWidget cw = (ViewportWidget)current;  =     if ( (w->viewport.forcebars != cw->viewport.forcebars) || 6 	 (w->viewport.allowvert != cw->viewport.allowvert) ||8 	 (w->viewport.allowhoriz != cw->viewport.allowhoriz) ||4 	 (w->viewport.useright != cw->viewport.useright) ||6 	 (w->viewport.usebottom != cw->viewport.usebottom) )      { H 	(*w->core.widget_class->core_class.resize)(new); /* Recompute layout.*/     }        return False;  }     ! static void ChangeManaged(widget)      Widget widget; { .     ViewportWidget w = (ViewportWidget)widget;:     register int num_children = w->composite.num_children;#     register Widget child, *childP;      register int i;        child = (Widget)NULL; N     for (childP=w->composite.children, i=0; i < num_children; childP++, i++) { 	if (XtIsManaged(*childP) # 	    && *childP != w->viewport.clip ( 	    && *childP != w->viewport.horiz_bar( 	    && *childP != w->viewport.vert_bar) 	{ 	    child = *childP;  	    break;  	}     }   %     if (child != w->viewport.child) {  	w->viewport.child = child;  	if (child != (Widget)NULL) { . 	    XtResizeWidget( child, child->core.width,* 			    child->core.height, (Dimension)0 );  	    if (XtIsRealized(widget)) {# 		ViewportConstraints constraints = 3 		    (ViewportConstraints)child->core.constraints;  		if (!XtIsRealized(child)) { " 		    Window window = XtWindow(w);6 		    XtMoveWidget( child, (Position)0, (Position)0 );
 #ifdef notdef ; 		    /* this is dirty, but it saves the following code: */  		    XtRealizeWidget( child ); 5 		    XReparentWindow( XtDisplay(w), XtWindow(child), $ 				     XtWindow(w->viewport.clip),$ 				     (Position)0, (Position)0 );* 		    if (child->core.mapped_when_managed) 			XtMapWidget( child ); #else 2 		    w->core.window = XtWindow(w->viewport.clip); 		    XtRealizeWidget( child );  		    w->core.window = window; #endif /* notdef */ . 		    constraints->viewport.reparented = True; 		} / 		else if (!constraints->viewport.reparented) { 5 		    XReparentWindow( XtDisplay(w), XtWindow(child), $ 				     XtWindow(w->viewport.clip),$ 				     (Position)0, (Position)0 );. 		    constraints->viewport.reparented = True;* 		    if (child->core.mapped_when_managed) 			XtMapWidget( child ); 		}  	    }B 	    GetGeometry( widget, child->core.width, child->core.height );F 	    (*((ViewportWidgetClass)w->core.widget_class)->form_class.layout)3 		( (FormWidget)w, w->core.width, w->core.height ); 8 	    /* %%% do we need to hide this child from Form?  */ 	}     }   
 #ifdef notdef <     (*superclass->composite_class.change_managed)( widget ); #endif }     ) static void SetBar(w, top, length, total) 
     Widget w;      Position top;      Dimension length, total; { 4     XawScrollbarSetThumb(w, (float)top/(float)total,  			 (float)length/(float)total); }    static void RedrawThumbs(w)    ViewportWidget w;  { .     register Widget child = w->viewport.child;,     register Widget clip = w->viewport.clip;  .     if (w->viewport.horiz_bar != (Widget)NULL)1 	SetBar( w->viewport.horiz_bar, -(child->core.x), / 	        clip->core.width, child->core.width );   -     if (w->viewport.vert_bar != (Widget)NULL) 0 	SetBar( w->viewport.vert_bar, -(child->core.y),1 	        clip->core.height, child->core.height );  }       # static void SendReport (w, changed)      ViewportWidget w;      unsigned int changed;  {      XawPannerReport rep;  '     if (w->viewport.report_callbacks) { + 	register Widget child = w->viewport.child; ) 	register Widget clip = w->viewport.clip;    	rep.changed = changed; 5 	rep.slider_x = -child->core.x;	/* child is canvas */ 4 	rep.slider_y = -child->core.y;	/* clip is slider */% 	rep.slider_width = clip->core.width; ' 	rep.slider_height = clip->core.height; & 	rep.canvas_width = child->core.width;( 	rep.canvas_height = child->core.height;> 	XtCallCallbackList ((Widget) w, w->viewport.report_callbacks, 			    (XtPointer) &rep);      }  }      static void MoveChild(w, x, y)     ViewportWidget w;      Position x, y; { .     register Widget child = w->viewport.child;,     register Widget clip = w->viewport.clip;  ;     /* make sure we never move past right/bottom borders */ <     if (-x + (int)clip->core.width > (int)child->core.width)- 	x = -(child->core.width - clip->core.width);   >     if (-y + (int)clip->core.height > (int)child->core.height)/ 	y = -(child->core.height - clip->core.height);   7     /* make sure we never move past left/top borders */      if (x >= 0) x = 0;     if (y >= 0) y = 0;       XtMoveWidget(child, x, y);2     SendReport (w, (XawPRSliderX | XawPRSliderY));       RedrawThumbs(w); }     < static void ComputeLayout(widget, query, destroy_scrollbars)"     Widget widget;		/* Viewport */7     Boolean query;		/* query child's preferred geom? */ C     Boolean destroy_scrollbars;	/* destroy un-needed scrollbars? */  { .     ViewportWidget w = (ViewportWidget)widget;.     register Widget child = w->viewport.child;,     register Widget clip = w->viewport.clip;#     ViewportConstraints constraints / 	= (ViewportConstraints)clip->core.constraints; "     Boolean needshoriz, needsvert;      int clip_width, clip_height;     XtWidgetGeometry intended;  '     if (child == (Widget) NULL) return;        clip_width = w->core.width; !     clip_height = w->core.height; *     intended.request_mode = CWBorderWidth;     intended.border_width = 0;        if (w->viewport.forcebars) {*         needsvert = w->viewport.allowvert;,         needshoriz = w->viewport.allowhoriz;7         ComputeWithForceBars(widget, query, &intended,  # 			     &clip_width, &clip_height);      } 
     else {*         Dimension prev_width, prev_height; 	XtGeometryMask prev_mode; 	XtWidgetGeometry preferred;    	needshoriz = needsvert = False;   	/* A 	 * intended.{width,height} caches the eventual child dimensions, A 	 * but we don't set the mode bits until after we decide that the + 	 * child's preferences are not acceptable.  	 */   	if (!w->viewport.allowhoriz) & 	    intended.request_mode |= CWWidth;  * 	if ((int)child->core.width < clip_width) ! 	    intended.width = clip_width;  	else ( 	    intended.width = child->core.width;  , 	if ((int)child->core.height < clip_height) # 	    intended.height = clip_height;  	else * 	    intended.height = child->core.height;   	if (!w->viewport.allowvert)  ' 	    intended.request_mode |= CWHeight;    	if (!query) {) 	    preferred.width = child->core.width; + 	    preferred.height = child->core.height;  	}# 	do { /* while intended != prev  */    	    if (query) { @ 	        (void) XtQueryGeometry( child, &intended, &preferred );, 		if ( !(preferred.request_mode & CWWidth) )' 		    preferred.width = intended.width; - 		if ( !(preferred.request_mode & CWHeight) ) ) 		    preferred.height = intended.height;  	    }! 	    prev_width = intended.width; # 	    prev_height = intended.height; ' 	    prev_mode = intended.request_mode;  	    /* ; 	     * note that having once decided to turn on either bar ; 	     * we'll not change our mind until we're next resized, - 	     * thus avoiding potential oscillations.  	     */ #define CheckHoriz()							  \* 	    if ( w->viewport.allowhoriz &&				  \. 		 (int)preferred.width > clip_width) { 			  \# 	        if (!needshoriz) {					  \ ! 		    Widget bar;					          \ ' 		    needshoriz = True;				          \ = 		    if ((bar = w->viewport.horiz_bar) == (Widget)NULL)    \ 6 		        bar = CreateScrollbar(w, True);		          \4 		    clip_height -= bar->core.height +		          \* 			           bar->core.border_width;		  \0 		    if (clip_height < 1) clip_height = 1;		  \
 		}							  \ 0 	        intended.width = preferred.width;			  \ 	    }
 /*enddef*/ 	    CheckHoriz();H 	    if (w->viewport.allowvert && (int)preferred.height > clip_height) { 	        if (!needsvert) { 		    Widget bar;  		    needsvert = True; 7 		    if ((bar = w->viewport.vert_bar) == (Widget)NULL) * 		        bar = CreateScrollbar(w, False);= 		    clip_width -= bar->core.width + bar->core.border_width; ) 		    if (clip_width < 1) clip_width = 1;  		    CheckHoriz();  		} % 		intended.height = preferred.height;  	    }$ 	    if ( !w->viewport.allowhoriz ||' 		 (int)preferred.width < clip_width) { % 	        intended.width = clip_width; # 		intended.request_mode |= CWWidth;  	    }# 	    if ( !w->viewport.allowvert || ) 		 (int)preferred.height < clip_height) { ' 	        intended.height = clip_height; $ 		intended.request_mode |= CWHeight; 	    }, 	} while (intended.request_mode != prev_mode& 		 || (intended.request_mode & CWWidth' 		     && intended.width != prev_width) ' 		 || (intended.request_mode & CWHeight + 		     && intended.height != prev_height));      }        if (XtIsRealized(clip)) 1 	XRaiseWindow( XtDisplay(clip), XtWindow(clip) );        XtMoveWidget( clip, + 		  needsvert ? (w->viewport.useright ? 0 : , 			       w->viewport.vert_bar->core.width +7 			       w->viewport.vert_bar->core.border_width) : 0, - 		  needshoriz ? (w->viewport.usebottom ? 0 : ( 				w->viewport.horiz_bar->core.height +: 			        w->viewport.horiz_bar->core.border_width) : 0);0     XtResizeWidget( clip, (Dimension)clip_width,- 		    (Dimension)clip_height, (Dimension)0 );  	 0     if (w->viewport.horiz_bar != (Widget)NULL) {- 	register Widget bar = w->viewport.horiz_bar;  	if (!needshoriz) { 0 	    constraints->form.vert_base = (Widget)NULL; 	    if (destroy_scrollbars) { 		XtDestroyWidget( bar ); ' 		w->viewport.horiz_bar = (Widget)NULL;  	    } 	} 	else { . 	    register int bw = bar->core.border_width;= 	    XtResizeWidget( bar, clip_width, bar->core.height, bw );  	    XtMoveWidget( bar, * 			  ((needsvert && !w->viewport.useright)( 			   ? w->viewport.vert_bar->core.width
 			   : -bw),  			  (w->viewport.usebottom / 			    ? w->core.height - bar->core.height - bw  			    : -bw) );) 	    XtSetMappedWhenManaged( bar, True );  	}     }   /     if (w->viewport.vert_bar != (Widget)NULL) { , 	register Widget bar = w->viewport.vert_bar; 	if (!needsvert) {1 	    constraints->form.horiz_base = (Widget)NULL;  	    if (destroy_scrollbars) { 		XtDestroyWidget( bar ); & 		w->viewport.vert_bar = (Widget)NULL; 	    } 	} 	else { . 	    register int bw = bar->core.border_width;= 	    XtResizeWidget( bar, bar->core.width, clip_height, bw );  	    XtMoveWidget( bar,  			  (w->viewport.useright- 			   ? w->core.width - bar->core.width - bw  
 			   : -bw), , 			  ((needshoriz && !w->viewport.usebottom)+ 			    ? w->viewport.horiz_bar->core.height  			    : -bw) );) 	    XtSetMappedWhenManaged( bar, True );  	}     }         if (child != (Widget)NULL) {2 	XtResizeWidget( child, (Dimension)intended.width,5 		        (Dimension)intended.height, (Dimension)0 ); 
 	MoveChild(w, # 		  needshoriz ? child->core.x : 0, # 		  needsvert ? child->core.y : 0);      }        SendReport (w, XawPRAll);  }   + /*      Function Name: ComputeWithForceBars ?  *      Description: Computes the layout give forcebars is set. 0  *      Arguments: widget - the viewport widget.=  *                 query - whether or not to query the child. ?  *                 intended - the cache of the childs height is @  *                            stored here ( USED AND RETURNED ).A  *                 clip_width, clip_height - size of clip window. B  *                                           (USED AND RETURNED ).  *      Returns: none.  */    static void F ComputeWithForceBars(widget, query, intended, clip_width, clip_height) Widget widget; Boolean query; XtWidgetGeometry * intended; int *clip_width, *clip_height; { .     ViewportWidget w = (ViewportWidget)widget;.     register Widget child = w->viewport.child;     XtWidgetGeometry preferred;    /**  * If forcebars then needs = allows = has.5  * Thus if needsvert is set it MUST have a scrollbar.   */         if (w->viewport.allowvert) {# 	if (w->viewport.vert_bar == NULL)  6 	    w->viewport.vert_bar = CreateScrollbar(w, False);  2 	*clip_width -= w->viewport.vert_bar->core.width +1 		       w->viewport.vert_bar->core.border_width;      }   !     if (w->viewport.allowhoriz) { $ 	if (w->viewport.horiz_bar == NULL) 6 	    w->viewport.horiz_bar = CreateScrollbar(w, True);  <         *clip_height -= w->viewport.horiz_bar->core.height +2 		       w->viewport.horiz_bar->core.border_width;     }         AssignMax( *clip_width, 1 );!     AssignMax( *clip_height, 1 );   !     if (!w->viewport.allowvert) { (         intended->height = *clip_height;*         intended->request_mode = CWHeight;     } "     if (!w->viewport.allowhoriz) {&         intended->width = *clip_width;)         intended->request_mode = CWWidth;      }        if ( query ) {C         if ( (w->viewport.allowvert || w->viewport.allowhoriz) ) {  4 	    XtQueryGeometry( child, intended, &preferred ); 	   / 	    if ( !(intended->request_mode & CWWidth) ) 0 	        if ( preferred.request_mode & CWWidth )( 		    intended->width = preferred.width; 		else* 		    intended->width = child->core.width;  0 	    if ( !(intended->request_mode & CWHeight) )1 	        if ( preferred.request_mode & CWHeight ) * 		    intended->height = preferred.height; 		else, 		    intended->height = child->core.height; 	}     } 
     else {"         if (w->viewport.allowvert)+ 	    intended->height = child->core.height;  	if (w->viewport.allowhoriz)) 	    intended->width = child->core.width;      }   +     if (*clip_width > (int)intended->width)  	intended->width = *clip_width; -     if (*clip_height > (int)intended->height) ! 	intended->height = *clip_height;  }    static void Resize(widget)     Widget widget; { >     ComputeLayout( widget, /*query=*/True, /*destroy=*/True ); }      /* ARGSUSED */' static Boolean Layout(w, width, height)      FormWidget w;      Dimension width, height; { A     ComputeLayout( (Widget)w, /*query=*/True, /*destroy=*/True ); ,     w->form.preferred_width = w->core.width;.     w->form.preferred_height = w->core.height;     return False;  }     8 static void ScrollUpDownProc(widget, closure, call_data)     Widget widget;     XtPointer closure;     XtPointer call_data; { /     ViewportWidget w = (ViewportWidget)closure; .     register Widget child = w->viewport.child;     int pix = (int)call_data;      Position x, y;  8     if (child == NULL) return;	/* no child to scroll. */  F     x = child->core.x - ((widget == w->viewport.horiz_bar) ? pix : 0);E     y = child->core.y - ((widget == w->viewport.vert_bar) ? pix : 0);      MoveChild(w, x, y);  }      /* ARGSUSED *// static void ThumbProc(widget, closure, percent)      Widget widget;     XtPointer closure;     float *percent;c {e/     ViewportWidget w = (ViewportWidget)closure;*.     register Widget child = w->viewport.child;     Position x, y;  8     if (child == NULL) return;	/* no child to scroll. */  (     if (widget == w->viewport.horiz_bar)2 #ifdef macII				/* bug in the macII A/UX 1.0 cc */* 	x = (int)(-*percent * child->core.width); #else /* else not macII */* 	x = -(int)(*percent * child->core.width); #endif /* macII */     else 	x = child->core.x;b  '     if (widget == w->viewport.vert_bar)n2 #ifdef macII				/* bug in the macII A/UX 1.0 cc */+ 	y = (int)(-*percent * child->core.height);n #else /* else not macII */+ 	y = -(int)(*percent * child->core.height);b #endif /* macII */     else 	y = child->core.y;w       MoveChild(w, x, y);i }p   static XtGeometryResultC% TestSmaller(w, request, reply_return)S@      ViewportWidget w; XtWidgetGeometry *request, *reply_return; {II   if (request->width < w->core.width || request->height < w->core.height)NC     return XtMakeGeometryRequest((Widget)w, request, reply_return);    else     return XtGeometryYes;    }I   static XtGeometryResultOB GeometryRequestPlusScrollbar(w, horizontal, request, reply_return)      Boolean horizontal;      ViewportWidget w; *.      XtWidgetGeometry *request, *reply_return; {*   Widget sb;"   XtWidgetGeometry plusScrollbars;   plusScrollbars = *request;3   if ((sb = w->viewport.horiz_bar) == (Widget)NULL)c)     sb = CreateScrollbar( w, horizontal);a#   request->width += sb->core.width;p%   request->height += sb->core.height;n   XtDestroyWidget(sb);J   return XtMakeGeometryRequest((Widget) w, &plusScrollbars, reply_return);  }  7 #define WidthChange() (request->width != w->core.width) : #define HeightChange() (request->height != w->core.height)   static XtGeometryResult ' QueryGeometry(w, request, reply_return)r@      ViewportWidget w; XtWidgetGeometry *request, *reply_return; {	7   if (w->viewport.allowhoriz && w->viewport.allowvert) l1     return TestSmaller(w, request, reply_return);e  >   else if (w->viewport.allowhoriz && !w->viewport.allowvert) {)     if (WidthChange() && !HeightChange())t3       return TestSmaller(w, request, reply_return);X.     else if (!WidthChange() && HeightChange())F       return XtMakeGeometryRequest((Widget) w, request, reply_return);=     else if (WidthChange() && HeightChange()) /* hard part */ J       return GeometryRequestPlusScrollbar(w, True, request, reply_return);0     else /* !WidthChange() && !HeightChange() */       return XtGeometryYes;z   }C>   else if (!w->viewport.allowhoriz && w->viewport.allowvert) {)     if (!WidthChange() && HeightChange())r3       return TestSmaller(w, request, reply_return); .     else if (WidthChange() && !HeightChange())E       return XtMakeGeometryRequest((Widget)w, request, reply_return); =     else if (WidthChange() && HeightChange()) /* hard part */eK       return GeometryRequestPlusScrollbar(w, False, request, reply_return);*0     else /* !WidthChange() && !HeightChange() */       return XtGeometryYes;i	   }      I@   else /* (!w->viewport.allowhoriz && !w->viewport.allowvert) */D     return XtMakeGeometryRequest((Widget) w, request, reply_return); }    #undef WidthChange #undef HeightChangem  > static XtGeometryResult GeometryManager(child, request, reply)     Widget child;s&     XtWidgetGeometry *request, *reply; {u:     ViewportWidget w = (ViewportWidget)child->core.parent;@     Boolean rWidth = (Boolean)(request->request_mode & CWWidth);B     Boolean rHeight = (Boolean)(request->request_mode & CWHeight);     XtWidgetGeometry allowed;      XtGeometryResult result;     Boolean reconfigured;l     Boolean child_changed_size;o     Dimension height_remaining;/  .     if (request->request_mode & XtCWQueryOnly).       return QueryGeometry(w, request, reply);  "     if (child != w->viewport.child7         || request->request_mode & ~(CWWidth | CWHeightG 				     | CWBorderWidth)c, 	|| ((request->request_mode & CWBorderWidth)# 	    && request->border_width > 0))  	return XtGeometryNo;f       allowed = *request;a  *     reconfigured = GetGeometry( (Widget)w,5 			        (rWidth ? request->width : w->core.width),I7 			        (rHeight ? request->height : w->core.height)e 			      );   L     child_changed_size = ((rWidth && child->core.width != request->width) ||9 			  (rHeight && child->core.height != request->height));   &     height_remaining = w->core.height;4     if (rWidth && w->core.width != request->width) {@ 	if (w->viewport.allowhoriz && request->width > w->core.width) {H 	    /* horizontal scrollbar will be needed so possibly reduce height */ 	    Widget bar; *7 	    if ((bar = w->viewport.horiz_bar) == (Widget)NULL)e# 		bar = CreateScrollbar( w, True );sC 	    height_remaining -= bar->core.height + bar->core.border_width;d 	    reconfigured = True;z 	} 	else {i# 	    allowed.width = w->core.width;t 	}     } 9     if (rHeight && height_remaining != request->height) { C 	if (w->viewport.allowvert && request->height > height_remaining) {tF 	    /* vertical scrollbar will be needed, so possibly reduce width */E 	    if (!w->viewport.allowhoriz || request->width < w->core.width) {N
 		Widget bar;p3 		if ((bar = w->viewport.vert_bar) == (Widget)NULL) ( 		    bar = CreateScrollbar( w, False ); 		if (!rWidth) {$ 		    allowed.width = w->core.width;& 		    allowed.request_mode |= CWWidth; 		}  		if ( (int)allowed.width >i8 		     (int)(bar->core.width + bar->core.border_width) )@ 		    allowed.width -= bar->core.width + bar->core.border_width; 		else 		    allowed.width = 1; 		reconfigured = True; 	    } 	} 	else {i' 	    allowed.height = height_remaining;i 	}     }   O     if (allowed.width != request->width || allowed.height != request->height) {B 	*reply = allowed; 	result = XtGeometryAlmost;N     } 
     else {1 	if (rWidth)  child->core.width = request->width;C3 	if (rHeight) child->core.height = request->height;  	result = XtGeometryYes;     }	  +     if (reconfigured || child_changed_size)r 	ComputeLayout( (Widget)w, 		       /*query=*/ False,A 		       /*destroy=*/ (result == XtGeometryYes) ? True : False );        return result;   }P    , static Boolean GetGeometry(w, width, height)
     Widget w;b     Dimension width, height; {e+     XtWidgetGeometry geometry, return_geom;r     XtGeometryResult result;  ;     if (width == w->core.width && height == w->core.height)  	return False;  /     geometry.request_mode = CWWidth | CWHeight;t     geometry.width = width;e     geometry.height = height;(       if (XtIsRealized(w)) {G 	if (((ViewportWidget)w)->viewport.allowhoriz && width > w->core.width) $ 	    geometry.width = w->core.width;H 	if (((ViewportWidget)w)->viewport.allowvert && height > w->core.height)& 	    geometry.height = w->core.height;     } else {G 	/* This is the Realize call; we'll inherit a w&h iff none currently */o 	if (w->core.width != 0) {+ 	    if (w->core.height != 0) return False;d$ 	    geometry.width = w->core.width; 	}; 	if (w->core.height != 0) geometry.height = w->core.height;s     }   ?     result = XtMakeGeometryRequest(w, &geometry, &return_geom); #     if (result == XtGeometryAlmost)f7 	result = XtMakeGeometryRequest(w, &return_geom, NULL);a  %     return (result == XtGeometryYes);; }   @ static XtGeometryResult PreferredGeometry(w, constraints, reply)
     Widget w;_*     XtWidgetGeometry *constraints, *reply; {a4     if (((ViewportWidget)w)->viewport.child != NULL)= 	return XtQueryGeometry( ((ViewportWidget)w)->viewport.child,t 			       constraints, reply );s     else 	return XtGeometryYes; }t     void #if NeedFunctionPrototypes" XawViewportSetLocation (Widget gw, #if NeedWidePrototypes 			double xoff, double yoff) #else  			float xoff, float yoff) #endif #elsee' XawViewportSetLocation (gw, xoff, yoff)      Widget gw;     float  xoff,yoff;  #endif {v+     ViewportWidget w = (ViewportWidget) gw;l.     register Widget child = w->viewport.child;     Position x, y;  +     if (xoff > 1.0)			/* scroll to right */i        x = child->core.width;*?     else if (xoff < 0.0)		/* if the offset is < 0.0 nothing */ .        x = child->core.x;      else;        x = (Position) (((float) child->core.width) * xoff);b       if (yoff > 1.0)         y = child->core.height;     else if (yoff < 0.0)        y = child->core.y;f     else<        y = (Position) (((float) child->core.height) * yoff);       MoveChild (w, -x, -y); })   void #if NeedFunctionPrototypes% XawViewportSetCoordinates (Widget gw,  #if NeedWidePrototypes 			   int x, int y)n #else] 			   Position x, Position y)g #endif #elseA$ XawViewportSetCoordinates (gw, x, y)     Widget gw;     Position x, y; #endif {p+     ViewportWidget w = (ViewportWidget) gw;G%     Widget child = w->viewport.child;i  $     if (x > (int)child->core.width)        x = child->core.width;     else if (x < 0)i       x = child->core.x;  $     if (y > (int)child->core.height)       y = child->core.height;      else if (y < 0)        y = child->core.y;       MoveChild (w, -x, -y); }t  