E /* $XConsortium: TextSrc.c,v 1.11 91/02/20 17:58:08 converse Exp $ */    /*7  * Copyright 1989 Massachusetts Institute of Technology   *N  * Permission to use, copy, modify, distribute, and sell this software and itsM  * documentation for any purpose is hereby granted without fee, provided that E  * the above copyright notice appear in all copies and that both that C  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION I  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *-  * Author:  Chris Peterson, MIT X Consortium.   *6  * Much code taken from X11R3 String and Disk Sources.  */    /*>  * TextSrc.c - TextSrc object. (For use with the text widget).  *  */    #include <stdio.h> #include <ctype.h> #include <X11/IntrinsicP.h>  #include <X11/StringDefs.h>  #include <X11/Xaw/XawInit.h> #include <X11/Xaw/TextSrcP.h>  #include <X11/Xmu/CharSet.h>  A /****************************************************************   *  * Full class record constant   *B  ****************************************************************/   /* Private Data */  ; #define offset(field) XtOffsetOf(TextSrcRec, textSrc.field) ! static XtResource resources[] = { E     {XtNeditType, XtCEditType, XtREditMode, sizeof(XawTextEditType),  .         offset(edit_mode), XtRString, "read"}, };  E static void ClassInitialize(), ClassPartInitialize(), SetSelection(); " static void CvtStringToEditMode();" static Boolean ConvertSelection();0 static XawTextPosition Search(), Scan(), Read(); static int Replace();   % #define SuperClass		(&objectClassRec) # TextSrcClassRec textSrcClassRec = {    {  /* core_class fields */	1     /* superclass	  	*/	(WidgetClass) SuperClass, "     /* class_name	  	*/	"TextSrc",,     /* widget_size	  	*/	sizeof(TextSrcRec),.     /* class_initialize   	*/	ClassInitialize,4     /* class_part_initialize	*/	ClassPartInitialize,$     /* class_inited       	*/	FALSE,     /* initialize	  	*/	NULL,       /* initialize_hook		*/	NULL,     /* realize		  	*/	NULL,      /* actions		  	*/	NULL,      /* num_actions	  	*/	0, !     /* resources	  	*/	resources, /     /* num_resources	  	*/	XtNumber(resources), !     /* xrm_class	  	*/	NULLQUARK, #     /* compress_motion	  	*/	FALSE, $     /* compress_exposure  	*/	FALSE,$     /* compress_enterleave	*/	FALSE,$     /* visible_interest	  	*/	FALSE,     /* destroy		  	*/	NULL,      /* resize		  	*/	NULL,     /* expose		  	*/	NULL,     /* set_values	  	*/	NULL,       /* set_values_hook		*/	NULL,!     /* set_values_almost	*/	NULL,       /* get_values_hook		*/	NULL,     /* accept_focus	 	*/	NULL,     /* version			*/	XtVersion,#     /* callback_private   	*/	NULL,      /* tm_table		   	*/	NULL,      /* query_geometry		*/	NULL, #     /* display_accelerator	*/	NULL,      /* extension		*/	NULL    }, /* textSrc_class fields */   { -     /* Read                     */      Read, 0     /* Replace                  */      Replace,-     /* Scan                     */      Scan, /     /* Search                   */      Search, 5     /* SetSelection             */      SetSelection, 8     /* ConvertSelection         */      ConvertSelection   }  };  ? WidgetClass textSrcObjectClass = (WidgetClass)&textSrcClassRec;    static void  ClassInitialize () {      XawInitializeWidgetSet ();M     XtAddConverter(XtRString, XtREditMode,   CvtStringToEditMode,   NULL, 0);  }      static void  ClassPartInitialize(wc)  WidgetClass wc;  { ,   register TextSrcObjectClass t_src, superC;  "   t_src = (TextSrcObjectClass) wc;?   superC = (TextSrcObjectClass) t_src->object_class.superclass;    /*  C  * We don't need to check for null super since we'll get to TextSrc   * eventually.  */   4     if (t_src->textSrc_class.Read == XtInheritRead) =       t_src->textSrc_class.Read = superC->textSrc_class.Read;   :     if (t_src->textSrc_class.Replace == XtInheritReplace) C       t_src->textSrc_class.Replace = superC->textSrc_class.Replace;   4     if (t_src->textSrc_class.Scan == XtInheritScan) =       t_src->textSrc_class.Scan = superC->textSrc_class.Scan;   8     if (t_src->textSrc_class.Search == XtInheritSearch) A       t_src->textSrc_class.Search = superC->textSrc_class.Search;   D     if (t_src->textSrc_class.SetSelection == XtInheritSetSelection) M       t_src->textSrc_class.SetSelection = superC->textSrc_class.SetSelection;   L     if (t_src->textSrc_class.ConvertSelection == XtInheritConvertSelection) -       t_src->textSrc_class.ConvertSelection = G 	                               superC->textSrc_class.ConvertSelection;  }   = /************************************************************   *  * Class specific methods.  *>  ************************************************************/   /*	Function Name: Read/  *	Description: This function reads the source. %  *	Arguments: w - the TextSrc Object. :  *                 pos - position of the text to retreive.E  * RETURNED        text - text block that will contain returned text. A  *                 length - maximum number of characters to read. :  *	Returns: The number of characters read into the buffer.  */    /* ARGSUSED */ static XawTextPosition Read(w, pos, text, length)	 Widget w;  XawTextPosition pos; XawTextBlock *text;	
 int length;		  { .   XtAppError(XtWidgetToApplicationContext(w), 6 	     "TextSrc Object: No read function is defined."); }    /*	Function Name: Replace.7  *	Description: Replaces a block of text with new text. +  *	Arguments: src - the Text Source Object. H  *                 startPos, endPos - ends of text that will be removed.J  *                 text - new text to be inserted into buffer at startPos.  *	Returns: XawEditError.   */    /*ARGSUSED*/ static int  # Replace (w, startPos, endPos, text) 	 Widget w; ! XawTextPosition startPos, endPos;  XawTextBlock *text;  {    return(XawEditError);  }    /*	Function Name: Scan=  *	Description: Scans the text source for the number and type '  *                   of item specified. %  *	Arguments: w - the TextSrc Object. =  *                 position - the position to start scanning. 4  *                 type - type of thing to scan for.+  *                 dir - direction to scan. G  *                 count - which occurance if this thing to search for. M  *                 include - whether or not to include the character found in <  *                           the position that is returned. (  *	Returns: EXITS WITH AN ERROR MESSAGE.  *  */    /* ARGSUSED */ static   XawTextPosition - Scan (w, position, type, dir, count, include)  Widget                w; XawTextPosition       position;  XawTextScanType       type;  XawTextScanDirection  dir; int     	      count;  Boolean	              include; { .   XtAppError(XtWidgetToApplicationContext(w), 6 	     "TextSrc Object: No SCAN function is defined."); }    /*	Function Name: SearchA  *	Description: Searchs the text source for the text block passed (  *	Arguments: w - the TextSource Object.=  *                 position - the position to start scanning. +  *                 dir - direction to scan. 7  *                 text - the text block to search for.   *	Returns: XawTextSearchError.   */    /* ARGSUSED */ static XawTextPosition   Search(w, position, dir, text) Widget                w; XawTextPosition       position;  XawTextScanDirection  dir; XawTextBlock *        text;  {    return(XawTextSearchError);  }   " /*	Function Name: ConvertSelection*  *	Description: Dummy selection converter.%  *	Arguments: w - the TextSrc object. :  *                 selection - the current selection atom.7  *                 target    - the current target atom. C  *                 type      - the type to conver the selection to. L  * RETURNED        value, length - the return value that has been converted.@  * RETURNED        format    - the format of the returned value.5  *	Returns: TRUE if the selection has been converted.   *  */    /* ARGSUSED */ static BooleanC ConvertSelection(w, selection, target, type, value, length, format) 	 Widget w; # Atom * selection, * target, * type;  XtPointer * value; unsigned long * length; 
 int * format;  {    return(FALSE); }    /*	Function Name: SetSelection8  *	Description: allows special setting of the selection.%  *	Arguments: w - the TextSrc object. 9  *                 left, right - bounds of the selection. 2  *                 selection - the selection atom.  *	Returns: none  */    /* ARGSUSED */ static void ' SetSelection(w, left, right, selection) 	 Widget w;  XawTextPosition left, right; Atom selection;  { ,   /* This space intentionally left blank. */ }      #define done(address, type) \ H         { toVal->size = sizeof(type); toVal->addr = (caddr_t) address; }   /* ARGSUSED */ static void 3 CvtStringToEditMode(args, num_args, fromVal, toVal)  XrmValuePtr args;		/* unused */   Cardinal	*num_args;	/* unused */ XrmValuePtr	fromVal; XrmValuePtr	toVal; { "   static XawTextEditType editType;*   static  XrmQuark  QRead, QAppend, QEdit;   XrmQuark    q;    char        lowerName[BUFSIZ];    static Boolean inited = FALSE;        if ( !inited ) {0     QRead   = XrmPermStringToQuark(XtEtextRead);2     QAppend = XrmPermStringToQuark(XtEtextAppend);0     QEdit   = XrmPermStringToQuark(XtEtextEdit);     inited = TRUE;   }   =   XmuCopyISOLatin1Lowered (lowerName, (char *)fromVal->addr); "   q = XrmStringToQuark(lowerName);  8   if       (q == QRead)          editType = XawtextRead;:   else if (q == QAppend)         editType = XawtextAppend;8   else if (q == QEdit)           editType = XawtextEdit;   else {     done(NULL, 0);     return;    } #   done(&editType, XawTextEditType); 	   return;  }       = /************************************************************   *  * Public Functions.  *>  ************************************************************/  # /*	Function Name: XawTextSourceRead /  *	Description: This function reads the source. %  *	Arguments: w - the TextSrc Object. :  *                 pos - position of the text to retreive.E  * RETURNED        text - text block that will contain returned text. A  *                 length - maximum number of characters to read. :  *	Returns: The number of characters read into the buffer.  */    XawTextPosition  #if NeedFunctionPrototypesD XawTextSourceRead(Widget w, XawTextPosition pos, XawTextBlock *text, 		  int length)  #else ' XawTextSourceRead(w, pos, text, length) 	 Widget w;  XawTextPosition pos; XawTextBlock *text;	 int length;  #endif { G   TextSrcObjectClass class = (TextSrcObjectClass) w->core.widget_class;   =   return((*class->textSrc_class.Read)(w, pos, text, length));  }   ' /*	Function Name: XawTextSourceReplace. 7  *	Description: Replaces a block of text with new text. +  *	Arguments: src - the Text Source Object. H  *                 startPos, endPos - ends of text that will be removed.J  *                 text - new text to be inserted into buffer at startPos.(  *	Returns: XawEditError or XawEditDone.  */    /*ARGSUSED*/ int  #if NeedFunctionPrototypes: XawTextSourceReplace (Widget w, XawTextPosition startPos, 3 		      XawTextPosition endPos, XawTextBlock *text)  #else 0 XawTextSourceReplace (w, startPos, endPos, text)	 Widget w; ! XawTextPosition startPos, endPos;  XawTextBlock *text;  #endif { G   TextSrcObjectClass class = (TextSrcObjectClass) w->core.widget_class;   E   return((*class->textSrc_class.Replace)(w, startPos, endPos, text));  }   # /*	Function Name: XawTextSourceScan =  *	Description: Scans the text source for the number and type '  *                   of item specified. %  *	Arguments: w - the TextSrc Object. =  *                 position - the position to start scanning. 4  *                 type - type of thing to scan for.+  *                 dir - direction to scan. G  *                 count - which occurance if this thing to search for. M  *                 include - whether or not to include the character found in <  *                           the position that is returned. %  *	Returns: The position of the text.   *  */    XawTextPosition  #if NeedFunctionPrototypes5 XawTextSourceScan(Widget w, XawTextPosition position,  #if NeedWidePrototypes 		  int type, int dir, #else 3 		  XawTextScanType type, XawTextScanDirection dir,  #endif 		  int count, #if NeedWidePrototypes 		  int include) #else  		  Boolean include) #endif #else 9 XawTextSourceScan(w, position, type, dir, count, include)  Widget                w; XawTextPosition       position;  XawTextScanType       type;  XawTextScanDirection  dir; int     	      count;  Boolean	              include; #endif { G   TextSrcObjectClass class = (TextSrcObjectClass) w->core.widget_class;   O   return((*class->textSrc_class.Scan)(w, position, type, dir, count, include));  }   % /*	Function Name: XawTextSourceSearch A  *	Description: Searchs the text source for the text block passed (  *	Arguments: w - the TextSource Object.=  *                 position - the position to start scanning. +  *                 dir - direction to scan. 7  *                 text - the text block to search for. <  *	Returns: The position of the text we are searching for or$  *               XawTextSearchError.  */    XawTextPosition  #if NeedFunctionPrototypes7 XawTextSourceSearch(Widget w, XawTextPosition position,  #if NeedWidePrototypes 		    int dir, #else  		    XawTextScanDirection dir,  #endif 		    XawTextBlock *text)  #else + XawTextSourceSearch(w, position, dir, text)  Widget                w; XawTextPosition       position;  XawTextScanDirection  dir; XawTextBlock *        text;  #endif { G   TextSrcObjectClass class = (TextSrcObjectClass) w->core.widget_class;   A   return((*class->textSrc_class.Search)(w, position, dir, text));  }   / /*	Function Name: XawTextSourceConvertSelection *  *	Description: Dummy selection converter.%  *	Arguments: w - the TextSrc object. :  *                 selection - the current selection atom.7  *                 target    - the current target atom. C  *                 type      - the type to conver the selection to. L  * RETURNED        value, length - the return value that has been converted.@  * RETURNED        format    - the format of the returned value.5  *	Returns: TRUE if the selection has been converted.   *  */    Boolean  #if NeedFunctionPrototypesG XawTextSourceConvertSelection(Widget w, Atom *selection, Atom *target,  & 			      Atom *type, XtPointer *value,, 			      unsigned long *length, int *format) #else , XawTextSourceConvertSelection(w, selection, - 			      target, type, value, length, format) 	 Widget w; # Atom * selection, * target, * type;  XtPointer * value; unsigned long * length; 
 int * format;  #endif { G   TextSrcObjectClass class = (TextSrcObjectClass) w->core.widget_class;   M   return((*class->textSrc_class.ConvertSelection)(w, selection, target, type,   						  value, length, format)); }   + /*	Function Name: XawTextSourceSetSelection 8  *	Description: allows special setting of the selection.%  *	Arguments: w - the TextSrc object. 9  *                 left, right - bounds of the selection. 2  *                 selection - the selection atom.  *	Returns: none  */    void #if NeedFunctionPrototypes: XawTextSourceSetSelection(Widget w, XawTextPosition left, + 			  XawTextPosition right, Atom selection)  #else 4 XawTextSourceSetSelection(w, left, right, selection)	 Widget w;  XawTextPosition left, right; Atom selection;  #endif { G   TextSrcObjectClass class = (TextSrcObjectClass) w->core.widget_class;   B   (*class->textSrc_class.SetSelection)(w, left, right, selection); }     