F /* $XConsortium: TextSink.c,v 1.16 91/05/28 10:50:01 converse Exp $ */   /*7  * Copyright 1989 Massachusetts Institute of Technology   *N  * Permission to use, copy, modify, distribute, and sell this software and itsM  * documentation for any purpose is hereby granted without fee, provided that E  * the above copyright notice appear in all copies and that both that C  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION I  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *-  * Author:  Chris Peterson, MIT X Consortium.   *(  * Much code taken from X11R3 AsciiSink.  */    /*@  * TextSink.c - TextSink object. (For use with the text widget).  *  */    #include <stdio.h> #include <ctype.h> #include <X11/IntrinsicP.h>  #include <X11/StringDefs.h>  #include <X11/Xaw/XawInit.h> #include <X11/Xaw/TextSinkP.h> #include <X11/Xaw/TextP.h>  A /****************************************************************   *  * Full class record constant   *B  ****************************************************************/  ; static void ClassPartInitialize(), Initialize(), Destroy();  static Boolean SetValues();   # static int MaxHeight(), MaxLines(); O static void DisplayText(), InsertCursor(), ClearToBackground(), FindPosition(); D static void FindDistance(), Resolve(), SetTabs(), GetCursorBounds();  > #define offset(field) XtOffsetOf(TextSinkRec, text_sink.field)! static XtResource resources[] = { ;   {XtNfont, XtCFont, XtRFontStruct, sizeof (XFontStruct *), -      offset(font), XtRString, XtDefaultFont}, :   {XtNforeground, XtCForeground, XtRPixel, sizeof (Pixel),:      offset(foreground), XtRString, XtDefaultForeground}, :   {XtNbackground, XtCBackground, XtRPixel, sizeof (Pixel),:      offset(background), XtRString, XtDefaultBackground},  };
 #undef offset   % #define SuperClass		(&objectClassRec) % TextSinkClassRec textSinkClassRec = {    {  /* core_class fields */	1     /* superclass	  	*/	(WidgetClass) SuperClass, #     /* class_name	  	*/	"TextSink", -     /* widget_size	  	*/	sizeof(TextSinkRec), 5     /* class_initialize   	*/	XawInitializeWidgetSet, 4     /* class_part_initialize	*/	ClassPartInitialize,$     /* class_inited       	*/	FALSE,#     /* initialize	  	*/	Initialize,       /* initialize_hook		*/	NULL,     /* obj1		  	*/	NULL,     /* obj2		  	*/	NULL,     /* obj3	  		*/	0, !     /* resources	  	*/	resources, /     /* num_resources	  	*/	XtNumber(resources), !     /* xrm_class	  	*/	NULLQUARK,      /* obj4		  	*/	FALSE,      /* obj5	  		*/	FALSE,      /* obj6			*/	FALSE,      /* obj7	  	  	*/	FALSE,      /* destroy		  	*/	Destroy,     /* obj8		  	*/	NULL,     /* obj9		  	*/	NULL,"     /* set_values	  	*/	SetValues,      /* set_values_hook		*/	NULL,     /* obj10			*/	NULL,       /* get_values_hook		*/	NULL,     /* obj11		 	*/	NULL,     /* version			*/	XtVersion,#     /* callback_private   	*/	NULL,      /* obj12		   	*/	NULL,     /* obj13			*/	NULL,      /* obj14			*/	NULL,      /* extension		*/	NULL    }, /* textSink_class fields */    { 4     /* DisplayText              */      DisplayText,5     /* InsertCursor             */      InsertCursor, :     /* ClearToBackground        */      ClearToBackground,5     /* FindPosition             */      FindPosition, 5     /* FindDistance             */      FindDistance, 0     /* Resolve                  */      Resolve,1     /* MaxLines                 */      MaxLines, 2     /* MaxHeight                */      MaxHeight,0     /* SetTabs                  */      SetTabs,8     /* GetCursorBounds          */      GetCursorBounds,   }  };  A WidgetClass textSinkObjectClass = (WidgetClass)&textSinkClassRec;    static void  ClassPartInitialize(wc)  WidgetClass wc;  { -   register TextSinkObjectClass t_src, superC;   #   t_src = (TextSinkObjectClass) wc; @   superC = (TextSinkObjectClass) t_src->object_class.superclass;   /*  D  * We don't need to check for null super since we'll get to TextSink  * eventually.  */   D     if (t_src->text_sink_class.DisplayText == XtInheritDisplayText) O       t_src->text_sink_class.DisplayText = superC->text_sink_class.DisplayText;   F     if (t_src->text_sink_class.InsertCursor == XtInheritInsertCursor) +       t_src->text_sink_class.InsertCursor = J                   	                  superC->text_sink_class.InsertCursor;  O     if (t_src->text_sink_class.ClearToBackground== XtInheritClearToBackground)  1       t_src->text_sink_class.ClearToBackground =  H 	                             superC->text_sink_class.ClearToBackground;  F     if (t_src->text_sink_class.FindPosition == XtInheritFindPosition) ,       t_src->text_sink_class.FindPosition = H 	                                  superC->text_sink_class.FindPosition;  F     if (t_src->text_sink_class.FindDistance == XtInheritFindDistance) ,       t_src->text_sink_class.FindDistance = G 	                                 superC->text_sink_class.FindDistance;   <     if (t_src->text_sink_class.Resolve == XtInheritResolve) G       t_src->text_sink_class.Resolve = superC->text_sink_class.Resolve;   >     if (t_src->text_sink_class.MaxLines == XtInheritMaxLines) I       t_src->text_sink_class.MaxLines = superC->text_sink_class.MaxLines;   @     if (t_src->text_sink_class.MaxHeight == XtInheritMaxHeight) K       t_src->text_sink_class.MaxHeight = superC->text_sink_class.MaxHeight;   <     if (t_src->text_sink_class.SetTabs == XtInheritSetTabs) G       t_src->text_sink_class.SetTabs = superC->text_sink_class.SetTabs;   L     if (t_src->text_sink_class.GetCursorBounds == XtInheritGetCursorBounds) /       t_src->text_sink_class.GetCursorBounds =  O                                        superC->text_sink_class.GetCursorBounds;  }    /*	Function Name: Initialize0  *	Description: Initializes the TextSink Object.H  *	Arguments: request, new - the requested and new values for the object+  *                                instance.   *	Returns: none.   *  */    /* ARGSUSED */ static void  Initialize(request, new) Widget request, new; { -   TextSinkObject sink = (TextSinkObject) new;   @   sink->text_sink.tab_count = 0; /* Initialize the tab stops. */   sink->text_sink.tabs = NULL;#   sink->text_sink.char_tabs = NULL;  }    /*	Function Name: Destroy ;  *	Description: This function cleans up when the object is    *                   destroyed. &  *	Arguments: w - the TextSink Object.  *	Returns: none.   */    static void 
 Destroy(w) { +   TextSinkObject sink = (TextSinkObject) w;   (   XtFree((char *) sink->text_sink.tabs);-   XtFree((char *) sink->text_sink.char_tabs);  }    /*	Function Name: SetValues 0  *	Description: Sets the values for the TextSink4  *	Arguments: current - current state of the object.0  *                 request - what was requested.5  *                 new - what the object will become. (  *	Returns: True if redisplay is needed.  */    /* ARGSUSED */ static Boolean  SetValues(current, request, new) Widget current, request, new;  { *   TextSinkObject w = (TextSinkObject) new;2   TextSinkObject old_w = (TextSinkObject) current;K   TextSinkObjectClass class = (TextSinkObjectClass) w->object.widget_class;   3   if (w->text_sink.font != old_w->text_sink.font) { C     (*class->text_sink_class.SetTabs)(new, w->text_sink.tab_count,  " 				      w->text_sink.char_tabs);>     ((TextWidget)XtParent(new))->text.redisplay_needed = True;
   } else {A       if (w->text_sink.foreground != old_w->text_sink.foreground) = 	  ((TextWidget)XtParent(new))->text.redisplay_needed = True;    }      return FALSE;  }   = /************************************************************   *  * Class specific methods.  *>  ************************************************************/   /*	Function Name: DisplayText D  *	Description: Stub function that in subclasses will display text. &  *	Arguments: w - the TextSink Object.9  *                 x, y - location to start drawing text. F  *                 pos1, pos2 - location of starting and ending points3  *                              in the text buffer. 4  *                 highlight - hightlight this text?  *	Returns: none.   *F  * This function doesn't actually display anything, it is only a place
  * holder.  */    /* ARGSUSED */ static void + DisplayText(w, x, y, pos1, pos2, highlight) 	 Widget w;  Position x, y; Boolean highlight; XawTextPosition pos1, pos2;  { 	   return;  }    /*	Function Name: InsertCursor(  *	Description: Places the InsertCursor.&  *	Arguments: w - the TextSink Object.2  *                 x, y - location for the cursor.A  *                 staye - whether to turn the cursor on, or off.   *	Returns: none.   *F  * This function doesn't actually display anything, it is only a place
  * holder.  */    /* ARGSUSED */ static void  InsertCursor(w, x, y, state)	 Widget w;  Position x, y; XawTextInsertState state;  { 	   return;  }   # /*	Function Name: ClearToBackground D  *	Description: Clears a region of the sink to the background color.&  *	Arguments: w - the TextSink Object.5  *                 x, y  - location of area to clear. 8  *                 width, height - size of area to clear  *	Returns: void.   *  */    /* ARGSUSED */ static void * ClearToBackground (w, x, y, width, height)	 Widget w;  Position x, y; Dimension width, height; {  /*  +  * Don't clear in height or width are zero. 6  * XClearArea() has special semantic for these values.  */   0     if ( (height == 0) || (width == 0) ) return;9     XClearArea(XtDisplayOfObject(w), XtWindowOfObject(w), $ 	       x, y, width, height, False); }    /*	Function Name: FindPosition-  *	Description: Finds a position in the text. &  *	Arguments: w - the TextSink Object.0  *                 fromPos - reference position.0  *                 fromX   - reference location.<  *                 width,  - width of section to paint text.G  *                 stopAtWordBreak - returned position is a word break? E  *                 resPos - Position to return.      *** RETURNED *** E  *                 resWidth - Width actually used.   *** RETURNED *** E  *                 resHeight - Height actually used. *** RETURNED ***   *	Returns: none (see above).   */    /* ARGSUSED */ static void 8 FindPosition(w, fromPos, fromx, width, stopAtWordBreak, " 	     resPos, resWidth, resHeight)	 Widget w;  XawTextPosition fromPos;   int fromx, width;			 Boolean stopAtWordBreak;		 XawTextPosition *resPos;	  int *resWidth, *resHeight;		 {    *resPos = fromPos;   *resHeight = *resWidth = 0;  }    /*	Function Name: FindDistanceC  *	Description: Find the Pixel Distance between two text Positions. &  *	Arguments: w - the TextSink Object./  *                 fromPos - starting Position. =  *                 fromX   - x location of starting Position. *  *                 toPos   - end Position.A  *                 resWidth - Distance between fromPos and toPos. 0  *                 resPos   - Acutal toPos used.<  *                 resHeight - Height required by this text.  *	Returns: none.   */    /* ARGSUSED */ static void D FindDistance (w, fromPos, fromx, toPos, resWidth, resPos, resHeight)	 Widget w;  XawTextPosition fromPos;
 int fromx; XawTextPosition toPos; int *resWidth; XawTextPosition *resPos; int *resHeight;  {    *resWidth = *resHeight = 0;    *resPos = fromPos; }    /*	Function Name: Resolve 2  *	Description: Resloves a location to a position.&  *	Arguments: w - the TextSink Object..  *                 pos - a reference Position.0  *                 fromx - a reference Location.)  *                 width - width to move. 3  *                 resPos - the resulting position.   *	Returns: none  */    /* ARGSUSED */ static void & Resolve (w, pos, fromx, width, resPos)	 Widget w;  XawTextPosition pos; int fromx, width;  XawTextPosition *resPos; {    *resPos = pos; }    /*	Function Name: MaxLinesB  *	Description: Finds the Maximum number of lines that will fit in$  *                   a given height.&  *	Arguments: w - the TextSink Object.5  *                 height - height to fit lines into. .  *	Returns: the number of lines that will fit.  */    /* ARGSUSED */
 static int MaxLines(w, height) 	 Widget w;  Dimension height;  { +   TextSinkObject sink = (TextSinkObject) w;    int font_height;  M   font_height = sink->text_sink.font->ascent + sink->text_sink.font->descent; )   return( ((int) height) / font_height );  }    /*	Function Name: MaxHeight I  *	Description: Finds the Minium height that will contain a given number    *                   lines. &  *	Arguments: w - the TextSink Object./  *                 lines - the number of lines.   *	Returns: the height.   */    /* ARGSUSED */
 static int MaxHeight(w, lines) 	 Widget w; 
 int lines; { +   TextSinkObject sink = (TextSinkObject) w;   1   return(lines * (sink->text_sink.font->ascent +  $ 		  sink->text_sink.font->descent)); }    /*	Function Name: SetTabs #  *	Description: Sets the Tab stops. &  *	Arguments: w - the TextSink Object.>  *                 tab_count - the number of tabs in the list.9  *                 tabs - the text positions of the tabs.   *	Returns: none  */    static void  SetTabs(w, tab_count, tabs) 	 Widget w;  int tab_count; short *tabs; { +   TextSinkObject sink = (TextSinkObject) w;    int i;   Atom XA_FIGURE_WIDTH; !   unsigned long figure_width = 0; +   XFontStruct *font = sink->text_sink.font;    /*-  * Find the figure width of the current font.   */   M   XA_FIGURE_WIDTH = XInternAtom(XtDisplayOfObject(w), "FIGURE_WIDTH", FALSE); "   if ( XA_FIGURE_WIDTH != None && E        ( (!XGetFontProperty(font, XA_FIGURE_WIDTH, &figure_width)) ||  	 (figure_width == 0)) )  ;     if (font->per_char && font->min_char_or_byte2 <= '$' &&   	font->max_char_or_byte2 >= '$')I       figure_width = font->per_char['$' - font->min_char_or_byte2].width;      else,       figure_width = font->max_bounds.width;  .   if (tab_count > sink->text_sink.tab_count) {'     sink->text_sink.tabs = (Position *) ) 	XtRealloc((char *) sink->text_sink.tabs, / 		  (Cardinal) (tab_count * sizeof(Position))); )     sink->text_sink.char_tabs = (short *) . 	XtRealloc((char *) sink->text_sink.char_tabs,, 		  (Cardinal) (tab_count * sizeof(short)));   }   '   for ( i = 0 ; i < tab_count ; i++ ) { 5     sink->text_sink.tabs[i] = tabs[i] * figure_width; +     sink->text_sink.char_tabs[i] = tabs[i];    }      (   sink->text_sink.tab_count = tab_count; }   ! /*	Function Name: GetCursorBounds D  *	Description: Finds the bounding box for the insert curor (caret).%  *	Arguments: w - the TextSinkObject. E  *                 rect - an X rectance containing the cursor bounds. !  *	Returns: none (fills in rect).   */    /* ARGSUSED */ static void  GetCursorBounds(w, rect)	 Widget w;  XRectangle * rect; { 5   rect->x = rect->y = rect->width = rect->height = 0;  } = /************************************************************   *  * Public Functions.  *>  ************************************************************/    ( /*	Function Name: XawTextSinkDisplayTextD  *	Description: Stub function that in subclasses will display text. &  *	Arguments: w - the TextSink Object.9  *                 x, y - location to start drawing text. F  *                 pos1, pos2 - location of starting and ending points3  *                              in the text buffer. 4  *                 highlight - hightlight this text?  *	Returns: none.   *F  * This function doesn't actually display anything, it is only a place
  * holder.  */    /* ARGSUSED */ void #if NeedFunctionPrototypes  XawTextSinkDisplayText(Widget w, #if NeedWidePrototypes4 		       /* Position */ int x, /* Position */ int y, #else   		       Position x, Position y, #endif4 		       XawTextPosition pos1, XawTextPosition pos2, #if NeedWidePrototypes% 		       /* Boolean */ int highlight)  #else  		       Boolean highlight)  #endif #else 6 XawTextSinkDisplayText(w, x, y, pos1, pos2, highlight)	 Widget w;  Position x, y; Boolean highlight; XawTextPosition pos1, pos2;  #endif { I   TextSinkObjectClass class = (TextSinkObjectClass) w->core.widget_class;   H   (*class->text_sink_class.DisplayText)(w, x, y, pos1, pos2, highlight); }   ) /*	Function Name: XawTextSinkInsertCursor (  *	Description: Places the InsertCursor.&  *	Arguments: w - the TextSink Object.2  *                 x, y - location for the cursor.A  *                 staye - whether to turn the cursor on, or off.   *	Returns: none.   *F  * This function doesn't actually display anything, it is only a place
  * holder.  */    /* ARGSUSED */ void #if NeedFunctionPrototypes! XawTextSinkInsertCursor(Widget w,  #if NeedWidePrototypes 			int x, int y, int state)  #else 4 			Position x, Position y, XawTextInsertState state) #endif	 #else     ' XawTextSinkInsertCursor(w, x, y, state) 	 Widget w;  Position x, y; XawTextInsertState state;  #endif { I   TextSinkObjectClass class = (TextSinkObjectClass) w->core.widget_class;      9   (*class->text_sink_class.InsertCursor)(w, x, y, state);  }     . /*	Function Name: XawTextSinkClearToBackgroundD  *	Description: Clears a region of the sink to the background color.&  *	Arguments: w - the TextSink Object.5  *                 x, y  - location of area to clear. 8  *                 width, height - size of area to clear  *	Returns: void.   *F  * This function doesn't actually display anything, it is only a place
  * holder.  */    /* ARGSUSED */ void #if NeedFunctionPrototypes' XawTextSinkClearToBackground (Widget w,  #if NeedWidePrototypes- 			      int x, int y, int width, int height)  #else ! 			      Position x, Position y,  + 			      Dimension width, Dimension height)  #endif #else 5 XawTextSinkClearToBackground (w, x, y, width, height) 	 Widget w;  Position x, y; Dimension width, height; #endif { I   TextSinkObjectClass class = (TextSinkObjectClass) w->core.widget_class;   F   (*class->text_sink_class.ClearToBackground)(w, x, y, width, height); }   ) /*	Function Name: XawTextSinkFindPosition -  *	Description: Finds a position in the text. &  *	Arguments: w - the TextSink Object.0  *                 fromPos - reference position.0  *                 fromX   - reference location.<  *                 width,  - width of section to paint text.G  *                 stopAtWordBreak - returned position is a word break? E  *                 resPos - Position to return.      *** RETURNED *** E  *                 resWidth - Width actually used.   *** RETURNED *** E  *                 resHeight - Height actually used. *** RETURNED ***   *	Returns: none (see above).   */    /* ARGSUSED */ void #if NeedFunctionPrototypesE XawTextSinkFindPosition(Widget w, XawTextPosition fromPos, int fromx, 
 			int width,  #if NeedWidePrototypes% 			/* Boolean */ int stopAtWordBreak,  #else  			Boolean stopAtWordBreak,  #endif: 			XawTextPosition *resPos, int *resWidth, int *resHeight) #else C XawTextSinkFindPosition(w, fromPos, fromx, width, stopAtWordBreak,   			resPos, resWidth, resHeight) 	 Widget w;  XawTextPosition fromPos;   int fromx, width;			 Boolean stopAtWordBreak;		 XawTextPosition *resPos;	  int *resWidth, *resHeight; #endif { I   TextSinkObjectClass class = (TextSinkObjectClass) w->core.widget_class;   B   (*class->text_sink_class.FindPosition)(w, fromPos, fromx, width, 					 stopAtWordBreak,  # 					 resPos, resWidth, resHeight);  }   ) /*	Function Name: XawTextSinkFindDistance C  *	Description: Find the Pixel Distance between two text Positions. &  *	Arguments: w - the TextSink Object./  *                 fromPos - starting Position. =  *                 fromX   - x location of starting Position. *  *                 toPos   - end Position.A  *                 resWidth - Distance between fromPos and toPos. 0  *                 resPos   - Acutal toPos used.<  *                 resHeight - Height required by this text.  *	Returns: none.   */    /* ARGSUSED */ void #if NeedFunctionPrototypesF XawTextSinkFindDistance (Widget w, XawTextPosition fromPos, int fromx,* 			 XawTextPosition toPos, int *resWidth, , 			 XawTextPosition *resPos, int *resHeight) #else O XawTextSinkFindDistance (w, fromPos, fromx, toPos, resWidth, resPos, resHeight) 	 Widget w; ( XawTextPosition fromPos, toPos, *resPos;! int fromx, *resWidth, *resHeight;  #endif { I   TextSinkObjectClass class = (TextSinkObjectClass) w->core.widget_class;   B   (*class->text_sink_class.FindDistance)(w, fromPos, fromx, toPos,# 					 resWidth, resPos, resHeight);  }   $ /*	Function Name: XawTextSinkResolve2  *	Description: Resloves a location to a position.&  *	Arguments: w - the TextSink Object..  *                 pos - a reference Position.0  *                 fromx - a reference Location.)  *                 width - width to move. 3  *                 resPos - the resulting position.   *	Returns: none  */    /* ARGSUSED */ void #if NeedFunctionPrototypesG XawTextSinkResolve(Widget w, XawTextPosition pos, int fromx, int width,  		   XawTextPosition *resPos)  #else 0 XawTextSinkResolve(w, pos, fromx, width, resPos)	 Widget w;  XawTextPosition pos; int fromx, width;  XawTextPosition *resPos; #endif { I   TextSinkObjectClass class = (TextSinkObjectClass) w->core.widget_class;   B   (*class->text_sink_class.Resolve)(w, pos, fromx, width, resPos); }   % /*	Function Name: XawTextSinkMaxLines B  *	Description: Finds the Maximum number of lines that will fit in$  *                   a given height.&  *	Arguments: w - the TextSink Object.5  *                 height - height to fit lines into. .  *	Returns: the number of lines that will fit.  */    /* ARGSUSED */ int  #if NeedFunctionPrototypes XawTextSinkMaxLines(Widget w,  #if NeedWidePrototypes! 		    /* Dimension */ int height)  #else  		    Dimension height)  #endif #else  XawTextSinkMaxLines(w, height)	 Widget w;  Dimension height;  #endif { I   TextSinkObjectClass class = (TextSinkObjectClass) w->core.widget_class;   8   return((*class->text_sink_class.MaxLines)(w, height)); }   & /*	Function Name: XawTextSinkMaxHeightJ  *	Description: Finds the Minimum height that will contain a given number   *                   lines. &  *	Arguments: w - the TextSink Object./  *                 lines - the number of lines.   *	Returns: the height.   */    /* ARGSUSED */ int  #if NeedFunctionPrototypes) XawTextSinkMaxHeight(Widget w, int lines)  #else  XawTextSinkMaxHeight(w, lines)	 Widget w; 
 int lines; #endif { I   TextSinkObjectClass class = (TextSinkObjectClass) w->core.widget_class;   8   return((*class->text_sink_class.MaxHeight)(w, lines)); }   $ /*	Function Name: XawTextSinkSetTabs#  *	Description: Sets the Tab stops. &  *	Arguments: w - the TextSink Object.>  *                 tab_count - the number of tabs in the list.9  *                 tabs - the text positions of the tabs.   *	Returns: none  */    void #if NeedFunctionPrototypes6 XawTextSinkSetTabs(Widget w, int tab_count, int *tabs) #else & XawTextSinkSetTabs(w, tab_count, tabs)	 Widget w;  int tab_count, *tabs;  #endif {    if (tab_count > 0) {K     TextSinkObjectClass class = (TextSinkObjectClass) w->core.widget_class; M     short *char_tabs = (short*)XtMalloc( (unsigned)tab_count*sizeof(short) );      register short *tab;     register int i;   I     for (i = tab_count, tab = char_tabs; i; i--) *tab++ = (short)*tabs++;   ?     (*class->text_sink_class.SetTabs)(w, tab_count, char_tabs);      XtFree((char *)char_tabs);   }  }  						  , /*	Function Name: XawTextSinkGetCursorBoundsD  *	Description: Finds the bounding box for the insert curor (caret).%  *	Arguments: w - the TextSinkObject. E  *                 rect - an X rectance containing the cursor bounds. !  *	Returns: none (fills in rect).   */    /* ARGSUSED */ void #if NeedFunctionPrototypes6 XawTextSinkGetCursorBounds(Widget w, XRectangle *rect) #else1# XawTextSinkGetCursorBounds(w, rect)l	 Widget w;* XRectangle * rect; #endif {yI   TextSinkObjectClass class = (TextSinkObjectClass) w->core.widget_class;o  5   (*class->text_sink_class.GetCursorBounds)(w, rect);a }e