@ /* $XConsortium: TextPop.c,v 1.22 91/07/25 18:10:22 rws Exp $ */  < /***********************************************************< Copyright 1989 by the Massachusetts Institute of Technology, Cambridge, Massachusetts.   +                         All Rights Reserved   F Permission to use, copy, modify, and distribute this software and its A documentation for any purpose and without fee is hereby granted,  F provided that the above copyright notice appear in all copies and that@ both that copyright notice and this permission notice appear in E supporting documentation, and that the names of Digital or MIT not be B used in advertising or publicity pertaining to distribution of the6 software without specific, written prior permission.    H DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDINGH ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALLG DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR C ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, F WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,C ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 	 SOFTWARE.   C ******************************************************************/   = /************************************************************   *>  * This file is broken up into three sections one dealing with)  * each of the three popups created here:   *#  * FileInsert, Search, and Replace.   *<  * There is also a section at the end for utility functions .  * used by all more than one of these dialogs.  *?  * The following functions are the only non-static ones defined ;  * in this module.  They are located at the begining of the 8  * section that contains this dialog box that uses them.  *  ?  * void _XawTextInsertFileAction(w, event, params, num_params); =  * void _XawTextDoSearchAction(w, event, params, num_params); >  * void _XawTextDoReplaceAction(w, event, params, num_params);9  * void _XawTextInsertFile(w, event, params, num_params);   *?  *************************************************************/    #include <X11/IntrinsicP.h>  #include <X11/StringDefs.h>  #include <X11/Shell.h>     #include <X11/Xaw/TextP.h> #include <X11/Xaw/AsciiText.h> #include <X11/Xaw/Cardinals.h> #include <X11/Xaw/Command.h> #include <X11/Xaw/Form.h>  #include <X11/Xaw/Toggle.h>  #include <X11/Xmu/CharSet.h> #include <stdio.h>( #include <X11/Xos.h>		/* for O_RDONLY */ #include <errno.h>   extern int errno, sys_nerr;  extern char* sys_errlist[];   ' #define INSERT_FILE ("Enter Filename:")   7 #define SEARCH_LABEL_1  ("Use <Tab> to change fields.") 2 #define SEARCH_LABEL_2  ("Use ^q<Tab> for <Tab>.")  #define DISMISS_NAME  ("cancel") #define DISMISS_NAME_LEN 6 #define FORM_NAME     ("form") #define LABEL_NAME    ("label")  #define TEXT_NAME     ("text")   #define R_OFFSET      1   L static void CenterWidgetOnPoint(), PopdownSearch(), DoInsert(), _SetField();G static void InitializeSearchWidget(), SetResource(), SetSearchLabels(); + static void DoReplaceOne(), DoReplaceAll(); ) static Widget CreateDialog(), GetShell(); ( static void SetWMProtocolTranslations();: static Boolean DoSearch(), SetResourceByName(), Replace(); static String GetString();  $ static void AddInsertFileChildren();! static Boolean InsertFileNamed();   static void AddSearchChildren();  " static char radio_trans_string[] =,     "<Btn1Down>,<Btn1Up>:   set() notify()";  " static char search_text_trans[] = 6   "~Shift<Key>Return:      DoSearchAction(Popdown) \n\A    Shift<Key>Return:       DoSearchAction() SetField(Replace) \n\ /    Ctrl<Key>q,<Key>Tab:    insert-char()    \n\ 4    Ctrl<Key>c:             PopdownSearchAction() \n\>    <Btn1Down>:             select-start() SetField(Search) \n\?    <Key>Tab:               DoSearchAction() SetField(Replace)";    static char rep_text_trans[] =  7   "~Shift<Key>Return:      DoReplaceAction(Popdown) \n\ /    Shift<Key>Return:       SetField(Search) \n\ 0    Ctrl<Key>q,<Key>Tab:    insert-char()     \n\4    Ctrl<Key>c:             PopdownSearchAction() \n\O    <Btn1Down>:             select-start() DoSearchAction() SetField(Replace)\n\ -    <Key>Tab:               SetField(Search)";   = /************************************************************   *  <  * This section of the file contains all the functions that #  * the file insert dialog box uses.   *>  ************************************************************/  * /*	Function Name: _XawTextInsertFileActionA  *	Description: Action routine that can be bound to dialog box's  F  *                   Text Widget that will insert a file into the main!  *                   Text Widget. /  *	Arguments:   (Standard Action Routine args)    *	Returns:     none.   */    /* ARGSUSED */ void  6 _XawTextInsertFileAction(w, event, params, num_params)	 Widget w;  XEvent *event; String * params; Cardinal * num_params; { A   DoInsert(w, (XtPointer) XtParent(XtParent(XtParent(w))), NULL);  }   $ /*	Function Name: _XawTextInsertFileC  *	Description: Action routine that can be bound to the text widget >  *                   it will popup the insert file dialog box.$  *	Arguments:   w - the text widget.D  *                   event - X Event (used to get x and y location).=  *                   params, num_params - the parameter list.   *	Returns:     none.   *  * NOTE:  *,  * The parameter list may contain one entry.  *H  *  Entry:  This entry is optional and contains the value of the default  *          file to insert.   */    void  0 _XawTextInsertFile(w, event, params, num_params)	 Widget w;  XEvent *event; String * params; Cardinal * num_params; { !   TextWidget ctx = (TextWidget)w; 
   char * ptr;    XawTextEditType edit_mode;   Arg args[1];  ,   XtSetArg(args[0], XtNeditType,&edit_mode);+   XtGetValues(ctx->text.source, args, ONE);    !   if (edit_mode != XawtextEdit) {      XBell(XtDisplay(w), 0);      return;    }      if (*num_params == 0) 
     ptr = "";    else       ptr = params[0];        if (!ctx->text.file_insert) { >     ctx->text.file_insert = CreateDialog(w, ptr, "insertFile", 					 AddInsertFileChildren); +     XtRealizeWidget(ctx->text.file_insert); 5     SetWMProtocolTranslations(ctx->text.file_insert);    }   4   CenterWidgetOnPoint(ctx->text.file_insert, event);-   XtPopup(ctx->text.file_insert, XtGrabNone);  }   # /*	Function Name: PopdownFileInsert 1  *	Description: Pops down the file insert button. 5  *	Arguments: w - the widget that caused this action. C  *                 closure - a pointer to the main text widget that 3  *                           popped up this dialog. 0  *                 call_data - *** NOT USED ***.  *	Returns: none.   */    /* ARGSUSED */ static void ( PopdownFileInsert(w, closure, call_data), Widget w;			/* The Dialog Button Pressed. */& XtPointer closure;		/* Text Widget. */" XtPointer call_data;		/* unused */ { (   TextWidget ctx = (TextWidget) closure;  %   XtPopdown( ctx->text.file_insert ); ?   (void) SetResourceByName( ctx->text.file_insert, LABEL_NAME,  ( 			   XtNlabel, (XtArgVal) INSERT_FILE); }    /*	Function Name: DoInsertA  *	Description: Actually insert the file named in the text widget (  *                   of the file dialog.<  *	Arguments:   w - the widget that activated this callback.I  *                   closure - a pointer to the text widget to insert the )  *                             file into.   *	Returns: none.   */    /* ARGSUSED */ static void  DoInsert(w, closure, call_data) , Widget w;			/* The Dialog Button Pressed. */% XtPointer closure;		/* Text Widget */ " XtPointer call_data;		/* unused */ { (   TextWidget ctx = (TextWidget) closure;    char buf[BUFSIZ], msg[BUFSIZ];   Widget temp_widget;   .   sprintf(buf, "%s.%s", FORM_NAME, TEXT_NAME);M   if ( (temp_widget = XtNameToWidget(ctx->text.file_insert, buf)) == NULL ) {      strcpy(msg, C 	   "*** Error: Could not get text widget from file insert popup");    }    else  C     if (InsertFileNamed( (Widget) ctx, GetString( temp_widget ))) { /       PopdownFileInsert(w, closure, call_data); 
       return;      }      else(       sprintf( msg, "*** Error: %s ***",( 	      (errno > 0 && errno < sys_nerr) ?0 	      sys_errlist[errno] : "Can't open file" );     1   (void)SetResourceByName(ctx->text.file_insert,  + 			  LABEL_NAME, XtNlabel, (XtArgVal) msg);    XBell(XtDisplay(w), 0);  }   ! /*	Function Name: InsertFileNamed 4  *	Description: Inserts a file into the text widget.<  *	Arguments: tw - The text widget to insert this file into.4  *                 str - name of the file to insert.>  *	Returns: TRUE if the insert was sucessful, FALSE otherwise.  */    static Boolean InsertFileNamed(tw, str)
 Widget tw;
 char *str; { 
   int fid;   XawTextBlock text;   char buf[BUFSIZ]; !   XawTextPosition start_pos, pos;   .   if ( (str == NULL) || (strlen(str) == 0) || *        ((fid = open(str, O_RDONLY)) <= 0))     return(FALSE);  1   start_pos = pos = XawTextGetInsertionPoint(tw);    text.firstPos = 0;   text.format = FMT8BIT;  6   while ((text.length = read(fid, buf, BUFSIZ)) > 0) {     text.ptr = buf; =     if (XawTextReplace(tw, pos, pos, &text) != XawEditDone) {        /*8        * If the replace failed then remove what we have .        * replaced so far, and return an error.	        */        text.length = 0;7       (void) XawTextReplace(tw, start_pos, pos, &text);        (void) close(fid);       return(FALSE);     }      pos += text.length;    }    (void) close(fid);$   XawTextSetInsertionPoint(tw, pos);   return(TRUE);  }   ' /*	Function Name: AddInsertFileChildren B  *	Description: Adds all children to the InsertFile dialog widget.B  *	Arguments: form - the form widget for the insert dialog widget.M  *                 ptr - a pointer to the initial string for the Text Widget. -  *                 tw - the main text widget.   *	Returns: none  */    static void $ AddInsertFileChildren(form, ptr, tw) Widget form, tw; char * ptr;  {    Arg args[10];    Cardinal num_args;%   Widget label, text, cancel, insert;    XtTranslations trans;      num_args = 0; =   XtSetArg(args[num_args], XtNlabel, INSERT_FILE);num_args++; =   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; >   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;<   XtSetArg(args[num_args], XtNresizable, TRUE ); num_args++;;   XtSetArg(args[num_args], XtNborderWidth, 0 ); num_args++; C   label = XtCreateManagedWidget(LABEL_NAME, labelWidgetClass, form,  				args, num_args);      num_args = 0; ;   XtSetArg(args[num_args], XtNfromVert, label); num_args++; =   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; ?   XtSetArg(args[num_args], XtNright, XtChainRight); num_args++; A   XtSetArg(args[num_args], XtNeditType, XawtextEdit); num_args++; ;   XtSetArg(args[num_args], XtNresizable, TRUE); num_args++; F   XtSetArg(args[num_args], XtNresize, XawtextResizeWidth); num_args++;7   XtSetArg(args[num_args], XtNstring, ptr); num_args++; E   text = XtCreateManagedWidget(TEXT_NAME, asciiTextWidgetClass, form,  				args, num_args);     num_args = 0; @   XtSetArg(args[num_args], XtNlabel, "Insert File"); num_args++;:   XtSetArg(args[num_args], XtNfromVert, text); num_args++;=   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; >   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;D   insert = XtCreateManagedWidget("insert", commandWidgetClass, form, 				 args, num_args);      num_args = 0; ;   XtSetArg(args[num_args], XtNlabel, "Cancel"); num_args++; :   XtSetArg(args[num_args], XtNfromVert, text); num_args++;=   XtSetArg(args[num_args], XtNfromHoriz, insert); num_args++; =   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; >   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;H   cancel = XtCreateManagedWidget(DISMISS_NAME, commandWidgetClass, form, 				 args, num_args);   H   XtAddCallback(cancel, XtNcallback, PopdownFileInsert, (XtPointer) tw);?   XtAddCallback(insert, XtNcallback, DoInsert, (XtPointer) tw);   !   XtSetKeyboardFocus(form, text);    /*  * Bind <CR> to insert file.  */   E   trans = XtParseTranslationTable("<Key>Return: InsertFileAction()"); &   XtOverrideTranslations(text, trans);   }   = /************************************************************   *  <  * This section of the file contains all the functions that   * the search dialog box uses.  *>  ************************************************************/  ( /*	Function Name: _XawTextDoSearchActionA  *	Description: Action routine that can be bound to dialog box's  K  *                   Text Widget that will search for a string in the main  !  *                   Text Widget. /  *	Arguments:   (Standard Action Routine args)    *	Returns:     none.   *  * Note:  *  D  * If the search was sucessful and the argument popdown is passed toF  * this action routine then the widget will automatically popdown the   * search widget.   */    /* ARGSUSED */ void  4 _XawTextDoSearchAction(w, event, params, num_params)	 Widget w;  XEvent *event; String * params; Cardinal * num_params; { ?   TextWidget tw = (TextWidget) XtParent(XtParent(XtParent(w)));    Boolean popdown = FALSE;     if ( (*num_params == 1) &&9        ((params[0][0] == 'p') || (params[0][0] == 'P')) )        popdown = TRUE;      +   if (DoSearch(tw->text.search) && popdown) 8     PopdownSearch(w, (XtPointer) tw->text.search, NULL); }   - /*	Function Name: _XawTextPopdownSearchAction A  *	Description: Action routine that can be bound to dialog box's  E  *                   Text Widget that will popdown the search widget. /  *	Arguments:   (Standard Action Routine args)    *	Returns:     none.   */    /* ARGSUSED */ void  9 _XawTextPopdownSearchAction(w, event, params, num_params) 	 Widget w;  XEvent *event; String * params; Cardinal * num_params; { ?   TextWidget tw = (TextWidget) XtParent(XtParent(XtParent(w)));   6   PopdownSearch(w, (XtPointer) tw->text.search, NULL); }    /*	Function Name: PopdownSeach:  *	Description: Pops down the search widget and resets it.#  *	Arguments: w - *** NOT USED ***. ?  *                 closure - a pointer to the search structure. 0  *                 call_data - *** NOT USED ***.  *	Returns: none  */    /* ARGSUSED */ static void $ PopdownSearch(w, closure, call_data) Widget w;			 XtPointer closure;		 XtPointer call_data;		 { I   struct SearchAndReplace * search = (struct SearchAndReplace *) closure;   $   XtPopdown( search->search_popup );A   SetSearchLabels(search, SEARCH_LABEL_1, SEARCH_LABEL_2, FALSE);  }    /*	Function Name: SearchButton=  *	Description: Performs a search when the button is clicked. "  *	Arguments: w - *** NOT USED **.:  *                 closure - a pointer to the search info.0  *                 call_data - *** NOT USED ***.  *	Returns:   */    /* ARGSUSED */ static void # SearchButton(w, closure, call_data)  Widget w;			 XtPointer closure;		 XtPointer call_data; { 9   (void) DoSearch( (struct SearchAndReplace *) closure );  }     /*	Function Name: _XawTextSearchC  *	Description: Action routine that can be bound to the text widget 9  *                   it will popup the search dialog box. $  *	Arguments:   w - the text widget.D  *                   event - X Event (used to get x and y location).=  *                   params, num_params - the parameter list.   *	Returns:     none.   *  * NOTE:  *L  * The parameter list contains one or two entries that may be the following.  *H  * First Entry:   The first entry is the direction to search by default.J  *                This arguement must be specified and may have a value of$  *                "left" or "right".  *N  * Second Entry:  This entry is optional and contains the value of the default'  *                string to search for.   */   1 #define SEARCH_HEADER ("Text Widget - Search():")    void  , _XawTextSearch(w, event, params, num_params)	 Widget w;  XEvent *event; String * params; Cardinal * num_params; { !   TextWidget ctx = (TextWidget)w;    XawTextScanDirection dir;    char * ptr, buf[BUFSIZ];   XawTextEditType edit_mode;   Arg args[1];  
 #ifdef notdef )   if (ctx->text.source->Search == NULL) {        XBell(XtDisplay(w), 0); 
       return;    }  #endif  1   if ( (*num_params < 1) || (*num_params > 2) ) { K     sprintf(buf, "%s %s\n%s", SEARCH_HEADER, "This action must have only",   	    "one or two parameters");7     XtAppWarning(XtWidgetToApplicationContext(w), buf);      return;    }    else if (*num_params == 1)  
     ptr = "";    else       ptr = params[1];     switch(params[0][0]) {   case 'b':			/* Left. */    case 'B':      dir = XawsdLeft;
     break;   case 'f':			/* Right. */   case 'F':      dir = XawsdRight; 
     break;
   default:K     sprintf(buf, "%s %s\n%s", SEARCH_HEADER, "The first parameter must be", ' 	    "Either 'backward' or 'forward'"); 7     XtAppWarning(XtWidgetToApplicationContext(w), buf);      return;    }       if (ctx->text.search== NULL) {6     ctx->text.search = XtNew(struct SearchAndReplace);C     ctx->text.search->search_popup = CreateDialog(w, ptr, "search",  						  AddSearchChildren); 4     XtRealizeWidget(ctx->text.search->search_popup);>     SetWMProtocolTranslations(ctx->text.search->search_popup);   }    else if (*num_params > 1) { G     XtVaSetValues(ctx->text.search->search_text, XtNstring, ptr, NULL);    }   ,   XtSetArg(args[0], XtNeditType,&edit_mode);+   XtGetValues(ctx->text.source, args, ONE);   L   InitializeSearchWidget(ctx->text.search, dir, (edit_mode == XawtextEdit));  =   CenterWidgetOnPoint(ctx->text.search->search_popup, event); 6   XtPopup(ctx->text.search->search_popup, XtGrabNone); }   ( /*	Function Name: InitializeSearchWidget?  *	Description: This function initializes the search widget and G  *                   is called each time the search widget is poped up. 3  *	Arguments: search - the search widget structure. .  *                 dir - direction to search. E  *                 replace_active - state of the sensitivity for the  3  *                                  replace button.   *	Returns: none.   */    static void 3 InitializeSearchWidget(search, dir, replace_active) ! struct SearchAndReplace * search;  XawTextScanDirection dir;  Boolean replace_active;  { H   SetResource(search->rep_one, XtNsensitive, (XtArgVal) replace_active);H   SetResource(search->rep_all, XtNsensitive, (XtArgVal) replace_active);J   SetResource(search->rep_label, XtNsensitive, (XtArgVal) replace_active);I   SetResource(search->rep_text, XtNsensitive, (XtArgVal) replace_active);      switch (dir) {   case XawsdLeft: @     SetResource(search->left_toggle, XtNstate, (XtArgVal) TRUE);
     break;   case XawsdRight:A     SetResource(search->right_toggle, XtNstate, (XtArgVal) TRUE); 
     break;
   default:
     break;   }  }     # /*	Function Name: AddSearchChildren >  *	Description: Adds all children to the Search Dialog Widget.;  *	Arguments: form - the form widget for the search widget. M  *                 ptr - a pointer to the initial string for the Text Widget. -  *                 tw - the main text widget.   *	Returns: none.   */    static void   AddSearchChildren(form, ptr, tw) Widget form, tw; char * ptr;  {    Arg args[10];    Cardinal num_args;8   Widget cancel, search_button, s_label, s_text, r_text;   XtTranslations trans; D   struct SearchAndReplace * search = ((TextWidget) tw)->text.search;     num_args = 0; =   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; >   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;<   XtSetArg(args[num_args], XtNresizable, TRUE ); num_args++;;   XtSetArg(args[num_args], XtNborderWidth, 0 ); num_args++; D   search->label1 = XtCreateManagedWidget("label1", labelWidgetClass, 					 form, args, num_args);     num_args = 0; D   XtSetArg(args[num_args], XtNfromVert, search->label1); num_args++;=   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; >   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;<   XtSetArg(args[num_args], XtNresizable, TRUE ); num_args++;;   XtSetArg(args[num_args], XtNborderWidth, 0 ); num_args++; D   search->label2 = XtCreateManagedWidget("label2", labelWidgetClass, 					 form, args, num_args);    /*  H  * We need to add R_OFFSET to the radio_data, because the value zero (0)  * has special meaning.   */      num_args = 0; =   XtSetArg(args[num_args], XtNlabel, "Backward"); num_args++; D   XtSetArg(args[num_args], XtNfromVert, search->label2); num_args++;=   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; >   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;I   XtSetArg(args[num_args], XtNradioData, (caddr_t) XawsdLeft + R_OFFSET); 
   num_args++; N   search->left_toggle = XtCreateManagedWidget("backwards", toggleWidgetClass, ! 					      form, args, num_args);      num_args = 0; <   XtSetArg(args[num_args], XtNlabel, "Forward"); num_args++;D   XtSetArg(args[num_args], XtNfromVert, search->label2); num_args++;J   XtSetArg(args[num_args], XtNfromHoriz, search->left_toggle); num_args++;=   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; >   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;K   XtSetArg(args[num_args], XtNradioGroup, search->left_toggle); num_args++; J   XtSetArg(args[num_args], XtNradioData, (caddr_t) XawsdRight + R_OFFSET);
   num_args++; N   search->right_toggle = XtCreateManagedWidget("forwards", toggleWidgetClass, " 					       form, args, num_args);     { &     XtTranslations radio_translations;  E     radio_translations = XtParseTranslationTable(radio_trans_string); D     XtOverrideTranslations(search->left_toggle, radio_translations);E     XtOverrideTranslations(search->right_toggle, radio_translations);    }      num_args = 0; I   XtSetArg(args[num_args], XtNfromVert, search->left_toggle); num_args++; A   XtSetArg(args[num_args], XtNlabel, "Search for:  ");num_args++; =   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; >   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;;   XtSetArg(args[num_args], XtNborderWidth, 0 ); num_args++; B   s_label = XtCreateManagedWidget("searchLabel", labelWidgetClass, 				  form, args, num_args);     num_args = 0; I   XtSetArg(args[num_args], XtNfromVert, search->left_toggle); num_args++; >   XtSetArg(args[num_args], XtNfromHoriz, s_label); num_args++;=   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; ?   XtSetArg(args[num_args], XtNright, XtChainRight); num_args++; A   XtSetArg(args[num_args], XtNeditType, XawtextEdit); num_args++; ;   XtSetArg(args[num_args], XtNresizable, TRUE); num_args++; F   XtSetArg(args[num_args], XtNresize, XawtextResizeWidth); num_args++;7   XtSetArg(args[num_args], XtNstring, ptr); num_args++; J   s_text = XtCreateManagedWidget("searchText", asciiTextWidgetClass, form, 				 args, num_args);    search->search_text = s_text;      num_args = 0; <   XtSetArg(args[num_args], XtNfromVert, s_text); num_args++;A   XtSetArg(args[num_args], XtNlabel, "Replace with:");num_args++; =   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; >   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;;   XtSetArg(args[num_args], XtNborderWidth, 0 ); num_args++; M   search->rep_label = XtCreateManagedWidget("replaceLabel", labelWidgetClass,  					    form, args, num_args);      num_args = 0; >   XtSetArg(args[num_args], XtNfromHoriz, s_label); num_args++;<   XtSetArg(args[num_args], XtNfromVert, s_text); num_args++;=   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; ?   XtSetArg(args[num_args], XtNright, XtChainRight); num_args++; A   XtSetArg(args[num_args], XtNeditType, XawtextEdit); num_args++; ;   XtSetArg(args[num_args], XtNresizable, TRUE); num_args++; F   XtSetArg(args[num_args], XtNresize, XawtextResizeWidth); num_args++;6   XtSetArg(args[num_args], XtNstring, ""); num_args++;E   r_text = XtCreateManagedWidget("replaceText", asciiTextWidgetClass,  				 form, args, num_args);    search->rep_text = r_text;      num_args = 0; ;   XtSetArg(args[num_args], XtNlabel, "Search"); num_args++; <   XtSetArg(args[num_args], XtNfromVert, r_text); num_args++;=   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++; >   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;K   search_button = XtCreateManagedWidget("search", commandWidgetClass, form,  					args, num_args);      num_args = 0; <   XtSetArg(args[num_args], XtNlabel, "Replace"); num_args++;<   XtSetArg(args[num_args], XtNfromVert, r_text); num_args++;D   XtSetArg(args[num_args], XtNfromHoriz, search_button); num_args++;=   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++;M>   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;K   search->rep_one = XtCreateManagedWidget("replaceOne", commandWidgetClass,u 					  form, args, num_args);i     num_args = 0; @   XtSetArg(args[num_args], XtNlabel, "Replace All"); num_args++;<   XtSetArg(args[num_args], XtNfromVert, r_text); num_args++;F   XtSetArg(args[num_args], XtNfromHoriz, search->rep_one); num_args++;=   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++;n>   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;K   search->rep_all = XtCreateManagedWidget("replaceAll", commandWidgetClass,W 					  form, args, num_args);R     num_args = 0;B;   XtSetArg(args[num_args], XtNlabel, "Cancel"); num_args++;N<   XtSetArg(args[num_args], XtNfromVert, r_text); num_args++;F   XtSetArg(args[num_args], XtNfromHoriz, search->rep_all); num_args++;=   XtSetArg(args[num_args], XtNleft, XtChainLeft); num_args++;N>   XtSetArg(args[num_args], XtNright, XtChainLeft); num_args++;H   cancel = XtCreateManagedWidget(DISMISS_NAME, commandWidgetClass, form, 				 args, num_args);*  N   XtAddCallback(search_button, XtNcallback, SearchButton, (XtPointer) search);P   XtAddCallback(search->rep_one, XtNcallback, DoReplaceOne, (XtPointer) search);P   XtAddCallback(search->rep_all, XtNcallback, DoReplaceAll, (XtPointer) search);H   XtAddCallback(cancel, XtNcallback, PopdownSearch, (XtPointer) search);   /*$  * Initialize the text entry fields.  */t     {e     Pixel color;     num_args = 0;a@     XtSetArg(args[num_args], XtNbackground, &color); num_args++;2     XtGetValues(search->rep_text, args, num_args);     num_args = 0;v@     XtSetArg(args[num_args], XtNborderColor, color); num_args++;2     XtSetValues(search->rep_text, args, num_args);2     XtSetKeyboardFocus(form, search->search_text);   }e  A   SetSearchLabels(search, SEARCH_LABEL_1, SEARCH_LABEL_2, FALSE);*   /*  * Bind Extra translations.*  */   5   trans = XtParseTranslationTable(search_text_trans); 5   XtOverrideTranslations(search->search_text, trans);>  2   trans = XtParseTranslationTable(rep_text_trans);2   XtOverrideTranslations(search->rep_text, trans); }/   /*	Function Name: DoSearch"  *	Description: Performs a search.,  *	Arguments: search - the serach structure.  *	Returns: TRUE if sucessful.  */n   /* ARGSUSED */ static Boolean DoSearch(search)! struct SearchAndReplace * search;L {"   char msg[BUFSIZ]; -   Widget tw = XtParent(search->search_popup);i   XawTextPosition pos;   XawTextScanDirection dir;T   XawTextBlock text;  ,   text.ptr = GetString(search->search_text);!   text.length = strlen(text.ptr);f   text.firstPos = 0;   text.format = FMT8BIT;   X   dir = (XawTextScanDirection)(int) ((caddr_t)XawToggleGetCurrent(search->left_toggle) - 				R_OFFSET);   '   pos = XawTextSearch( tw, dir, &text);t   !   if (pos == XawTextSearchError)  ;     sprintf( msg, "Could not find string '%s'.", text.ptr);r   else {     if (dir == XawsdRight)7       XawTextSetInsertionPoint( tw, pos + text.length);,     else)       XawTextSetInsertionPoint( tw, pos);r     5     XawTextSetSelection( tw, pos, pos + text.length);n?     search->selection_changed = FALSE; /* selection is good. */c     return(TRUE);i   }=      XawTextUnsetSelection(tw);)   SetSearchLabels(search, msg, "", TRUE);n   return(FALSE); }>  = /************************************************************   * S<  * This section of the file contains all the functions that   * the replace dialog box uses.<  *>  ************************************************************/  ) /*	Function Name: _XawTextDoReplaceAction<A  *	Description: Action routine that can be bound to dialog box's tH  *                   Text Widget that will replace a string in the main !  *                   Text Widget. /  *	Arguments:   (Standard Action Routine args) b  *	Returns:     none.\  */    /* ARGSUSED */ void P5 _XawTextDoReplaceAction(w, event, params, num_params)l	 Widget w;  XEvent *event; String * params; Cardinal * num_params; { @   TextWidget ctx = (TextWidget) XtParent(XtParent(XtParent(w)));   Boolean popdown = FALSE;     if ( (*num_params == 1) &&9        ((params[0][0] == 'p') || (params[0][0] == 'P')) )      popdown = TRUE;*  ;   if (Replace( ctx->text.search, TRUE, popdown) && popdown)F9     PopdownSearch(w, (XtPointer) ctx->text.search, NULL);i }r   /*	Function Name: DoReplaceOne:  *	Description:  Replaces the first instance of the string9  *                     in the search dialog's text widget*G  *                    with the one in the replace dialog's text widget.*#  *	Arguments: w - *** Not Used ***.t?  *                 closure - a pointer to the search structure.t0  *                 call_data - *** Not Used ***.  *	Returns: none.   */i   /* ARGSUSED */ static void # DoReplaceOne(w, closure, call_data)e% Widget w;			/* The Button Pressed. */c& XtPointer closure;		/* Text Widget. */" XtPointer call_data;		/* unused */ {l=   Replace( (struct SearchAndReplace *) closure, TRUE, FALSE);t }d   /*	Function Name: DoReplaceOne6  *	Description:  Replaces every instance of the string8  *                    in the search dialog's text widgetG  *                    with the one in the replace dialog's text widget.n#  *	Arguments: w - *** Not Used ***.p?  *                 closure - a pointer to the search structure. 0  *                 call_data - *** Not Used ***.  *	Returns: none.r  */    /* ARGSUSED */ static void # DoReplaceAll(w, closure, call_data) % Widget w;			/* The Button Pressed. */ & XtPointer closure;		/* Text Widget. */" XtPointer call_data;		/* unused */ {[>   Replace( (struct SearchAndReplace *) closure, FALSE, FALSE); }    /*	Function Name: Replace=?  *	Description: This is the function that does the real work of ?  *                   replacing strings in the main text widget. ;  *	Arguments: tw - the Text Widget to replce the string in.tM  *                 once_only - If TRUE then only replace the first one found.e9  *                             other replace all of them.WJ  *                 show_current - If true then leave the selection on the J  *                                string that was just replaced, otherwise<  *                                move it onto the next one.  *	Returns: none.i  */s   static Boolean( Replace(search, once_only, show_current)! struct SearchAndReplace * search;e  Boolean once_only, show_current; {t(   XawTextPosition pos, new_pos, end_pos;   XawTextScanDirection dir;    XawTextBlock find, replace; -   Widget tw = XtParent(search->search_popup);/   int count = 0;   -   find.ptr = GetString( search->search_text);	!   find.length = strlen(find.ptr);t   find.firstPos = 0;   find.format = FMT8BIT;  ,   replace.ptr = GetString(search->rep_text);'   replace.length = strlen(replace.ptr);x   replace.firstPos = 0;    replace.format = FMT8BIT;-     X   dir = (XawTextScanDirection)(int) ((caddr_t)XawToggleGetCurrent(search->left_toggle) - 				R_OFFSET);     while (TRUE) {     if (count != 0) {d/       new_pos = XawTextSearch( tw, dir, &find);        .       if ( (new_pos == XawTextSearchError) ) { 	if (count == 0) { 	  char msg[BUFSIZ];  B 	  sprintf( msg, "%s %s %s", "*** Error: Could not find string '", 		  find.ptr, "'. ***");* 	  SetSearchLabels(search, msg, "", TRUE); 	  return(FALSE);n 	} 	elses	 	  break;a       }g       pos = new_pos;"       end_pos = pos + find.length;     }T
     else {1       XawTextGetSelectionPos(tw, &pos, &end_pos);i  &       if (search->selection_changed) {B 	SetSearchLabels(search, "Selection has been modified, aborting.",
 			"", TRUE);M 	return(FALSE);        }p       if (pos == end_pos)  	  return(FALSE);      }=  D     if (XawTextReplace(tw, pos, end_pos, &replace) != XawEditDone) {       char msg[BUFSIZ];        B       sprintf( msg, "'%s' with '%s'. ***", find.ptr, replace.ptr);F       SetSearchLabels(search, "*** Error while replacing", msg, TRUE);       return(FALSE);     }      t       if (dir == XawsdRight):       XawTextSetInsertionPoint( tw, pos + replace.length);     else)       XawTextSetInsertionPoint( tw, pos);u       if (once_only) e       if (show_current)M 	break;e       else { 	DoSearch(search); 	return(TRUE);       }F     count++;   }t     if (replace.length == 0)     XawTextUnsetSelection(tw);   else8     XawTextSetSelection( tw, pos, pos + replace.length);     return(TRUE);s }-  ! /*	Function Name: SetSearchLabelsrD  *	Description: Sets both the search labels, and also rings the bell,  *	Arguments: search - the search structure.D  *                 msg1, msg2 - message to put in each search label.1  *                 bell - if TRUE then ring bell.t  *	Returns: none.e  */)   static void ) SetSearchLabels(search, msg1, msg2, bell) ! struct SearchAndReplace * search;  String msg1, msg2;
 Boolean bell;  {tA   (void) SetResource( search->label1, XtNlabel, (XtArgVal) msg1); A   (void) SetResource( search->label2, XtNlabel, (XtArgVal) msg2);x   if (bell) .     XBell(XtDisplay(search->search_popup), 0); }   = /************************************************************a  * o=  * This section of the file contains utility routines used by    * other functions in this file.  *>  ************************************************************/    " /*	Function Name: _XawTextSetFieldA  *	Description: Action routine that can be bound to dialog box's eM  *                   Text Widget that will send input to the field specified.d/  *	Arguments:   (Standard Action Routine args)    *	Returns:     none.e  */    /* ARGSUSED */ void l. _XawTextSetField(w, event, params, num_params)	 Widget w;a XEvent *event; String * params; Cardinal * num_params; {a#   struct SearchAndReplace * search;*   Widget new, old;  G   search = ((TextWidget) XtParent(XtParent(XtParent(w))))->text.search;      if (*num_params != 1) {mC     SetSearchLabels(search, "*** Error: SetField Action must have",s) 		    "exactly one argument. ***", TRUE);_     return;e   }S   switch (params[0][0]) {t   case 's':u   case 'S':e     new = search->search_text;     old = search->rep_text;N
     break;   case 'r':a   case 'R':e     old = search->search_text;     new = search->rep_text;e
     break;
   default:O     SetSearchLabels(search, "*** Error: SetField Action's first Argument must",W4 		    "be either 'Search' or 'Replace'. ***", TRUE);     return;t   }g   _SetField(new, old); }t   /*	Function Name: SetField,  *	Description: Sets the current text field.1  *	Arguments: new, old - new and old text fields.C  *	Returns: none  */    static voidg _SetField(new, old)y Widget new, old; {_   Arg args[2];'   Pixel new_border, old_border, old_bg;      if (!XtIsSensitive(new)) {J     XBell(XtDisplay(old), 0);	/* Don't set field to an inactive Widget. */     return;g   })  *   XtSetKeyboardFocus(XtParent(new), new);  						1   XtSetArg(args[0], XtNborderColor, &old_border);s,   XtSetArg(args[1], XtNbackground, &old_bg);   XtGetValues(new, args, TWO);  1   XtSetArg(args[0], XtNborderColor, &new_border);e   XtGetValues(old, args, ONE);  E   if (old_border != old_bg)	/* Colors are already correct, return. */s
       return;C  :   SetResource(old, XtNborderColor, (XtArgVal) old_border);:   SetResource(new, XtNborderColor, (XtArgVal) new_border); }_  # /*	Function Name: SetResourceByNameXC  *	Description: Sets a resource in any of the dialog children giveneJ  *                   name of the child and the shell widget of the dialog.0  *	Arguments: shell - shell widget of the popup.,  *                 name - name of the child.3  *                 res_name - name of the resource.=5  *                 value - the value of the resource.,  *	Returns: TRUE if sucessful.  */t   static Boolean/ SetResourceByName(shell, name, res_name, value);
 Widget shell;c char * name, * res_name; XtArgVal value;) {)   Widget temp_widget;c   char buf[BUFSIZ];*  )   sprintf(buf, "%s.%s", FORM_NAME, name);n  <   if ( (temp_widget = XtNameToWidget(shell, buf)) != NULL) {.     SetResource(temp_widget, res_name, value);     return(TRUE);*   }*   return(FALSE); }*   /*	Function Name: SetResourcee+  *	Description: Sets a resource in a widgett  *	Arguments: w - the widget.u3  *                 res_name - name of the resource.*5  *                 value - the value of the resource.h  *	Returns: none.i  */c   static voida SetResource(w, res_name, value) 	 Widget w;  char * res_name; XtArgVal value;c {o   Arg args[1];   %   XtSetArg(args[0], res_name, value);    XtSetValues( w, args, ONE ); }R   /*	Function Name: GetString =  *	Description:   Gets the value for the string in the popup.tB  *	Arguments:     text - the text widget whose string we will get.  *	Returns:       the string.   */   
 static String  GetString(text)U Widget text; {X   String string;   Arg args[1];  *   XtSetArg( args[0], XtNstring, &string );!   XtGetValues( text, args, ONE );r   return(string);g }t  & /*	Function Name: CenterWidgetOnPoint.=  *	Description: Centers a shell widget on a point relative to1%  *                   the root window.(#  *	Arguments: w - the shell widget.wE  *                 event - event containing the location of the pointd  *	Returns: none.n  *8  * NOTE: The widget is not allowed to go off the screen.  */w   static void  CenterWidgetOnPoint(w, event)t	 Widget w;b XEvent *event; {s   Arg args[3];   Cardinal num_args;#   Dimension width, height, b_width;    Position x, y, max_x, max_y;      if (event != NULL) {     switch (event->type) {     case ButtonPress:e     case ButtonRelease:e        x = event->xbutton.x_root;        y = event->xbutton.y_root;       break;     case KeyPress:     case KeyRelease:       x = event->xkey.x_root;r       y = event->xkey.y_root;,       break;     default:
       return;      }t   }a      num_args = 0;D9   XtSetArg(args[num_args], XtNwidth, &width); num_args++;A;   XtSetArg(args[num_args], XtNheight, &height); num_args++;-A   XtSetArg(args[num_args], XtNborderWidth, &b_width); num_args++;-!   XtGetValues(w, args, num_args);e     width += 2 * b_width;t   height += 2 * b_width;     x -= ( (Position) width/2 );   if (x < 0) x = 0;;I   if ( x > (max_x = (Position) (XtScreen(w)->width - width)) ) x = max_x;t     y -= ( (Position) height/2 );    if (y < 0) y = 0;aK   if ( y > (max_y = (Position) (XtScreen(w)->height - height)) ) y = max_y;)      num_args = 0; 0   XtSetArg(args[num_args], XtNx, x); num_args++;0   XtSetArg(args[num_args], XtNy, y); num_args++;!   XtSetValues(w, args, num_args);  }c   /*	Function Name: CreateDialog*  *	Description: Actually creates a dialog.G  *	Arguments: parent - the parent of the dialog - the main text widget.t7  *                 ptr - initial_string for the dialog.r-  *                 name - name of the dialog.cH  *                 func - function to create the children of the dialog.*  *	Returns: the popup shell of the dialog.  *    * NOTE:  *<  * The function argument is passed the following arguements.  *-  * form - the from widget that is the dialog. 9  * ptr - the initial string for the dialog's text widget.o<  * parent - the parent of the dialog - the main text widget.  */i  
 static Widget % CreateDialog(parent, ptr, name, func)r Widget parent; String ptr, name;r void (*func)();h {o   Widget popup, form;E   Arg args[5];   Cardinal num_args;     num_args = 0;a:   XtSetArg(args[num_args], XtNiconName, name); num_args++;:   XtSetArg(args[num_args], XtNgeometry, NULL); num_args++;B   XtSetArg(args[num_args], XtNallowShellResize, TRUE); num_args++;J   XtSetArg(args[num_args], XtNtransientFor, GetShell(parent)); num_args++;>   popup = XtCreatePopupShell(name, transientShellWidgetClass,   			     parent, args, num_args);   A   form = XtCreateManagedWidget(FORM_NAME, formWidgetClass, popup,  			       NULL, ZERO);     (*func) (form, ptr, parent);   return(popup); }r    /*	Function Name: GetShellp;   * 	Description: Walks up the widget hierarchy to find thex   * 		nearest shell widget. E   * 	Arguments: w - the widget whose parent shell should be returned.(C   * 	Returns: The shell widget among the ancestors of w that is the%/   * 		fewest levels up in the widget hierarchy.    */  n
 static Widgett GetShell(w)t	 Widget w;X {d(     while ((w != NULL) && !XtIsShell(w)) 	w = XtParent(w);e          return (w);  }   " static Boolean InParams(str, p, n)     String str;h     String *p;     Cardinal n;* {f
     int i;     for (i=0; i < n; p++, i++)1 	if (! XmuCompareISOLatin1(*p, str)) return True;      return False;g }   3 static char *WM_DELETE_WINDOW = "WM_DELETE_WINDOW";   5 static void WMProtocols(w, event, params, num_params)h      Widget w;		/* popup shell */     XEvent *event;     String *params;x     Cardinal *num_params;  {      Atom wm_delete_window;     Atom wm_protocols;  I     wm_delete_window = XInternAtom(XtDisplay(w), WM_DELETE_WINDOW, True);=C     wm_protocols = XInternAtom(XtDisplay(w), "WM_PROTOCOLS", True);t  7     /* Respond to a recognized WM protocol request iff oC      * event type is ClientMessage and no parameters are passed, or*N      * event type is ClientMessage and event data is matched to parameters, orD      * event type isn't ClientMessage and parameters make a request.      */eH #define DO_DELETE_WINDOW InParams(WM_DELETE_WINDOW, params, *num_params)  (     if ((event->type == ClientMessage &&0 	 event->xclient.message_type == wm_protocols &&1 	 event->xclient.data.l[0] == wm_delete_window &&p) 	 (*num_params == 0 || DO_DELETE_WINDOW))t 	|| 6 	(event->type != ClientMessage && DO_DELETE_WINDOW)) {   #undef DO_DELETE_WINDOW    	Widget cancel; ' 	char descendant[DISMISS_NAME_LEN + 2];e* 	sprintf(descendant, "*%s", DISMISS_NAME);( 	cancel = XtNameToWidget(w, descendant);C 	if (cancel) XtCallCallbacks(cancel, XtNcallback, (XtPointer)NULL);t     }i }i  ( static void SetWMProtocolTranslations(w)(     Widget	w;	/* realized popup shell */ {*
     int i;     XtAppContext app_context;s     Atom wm_delete_window;;     static XtTranslations compiled_table;	/* initially 0 */r<     static XtAppContext *app_context_list;	/* initially 0 */2     static Cardinal list_size;			/* initially 0 */  2     app_context = XtWidgetToApplicationContext(w);  &     /* parse translation table once */B     if (! compiled_table) compiled_table = XtParseTranslationTable/ 	("<Message>WM_PROTOCOLS: XawWMProtocols()\n");v  2     /* add actions once per application context */I     for (i=0; i < list_size && app_context_list[i] != app_context; i++) ;e     if (i == list_size) {c 	XtActionsRec actions[1];s& 	actions[0].string = "XawWMProtocols"; 	actions[0].proc = WMProtocols; 
 	list_size++;a. 	app_context_list = (XtAppContext *) XtReallocB 	    ((char *)app_context_list, list_size * sizeof(XtAppContext));* 	XtAppAddActions(app_context, actions, 1);# 	app_context_list[i] = app_context;a     }g  K     /* establish communication between the window manager and each shell */r-     XtAugmentTranslations(w, compiled_table);dJ     wm_delete_window = XInternAtom(XtDisplay(w), WM_DELETE_WINDOW, False);L     (void) XSetWMProtocols(XtDisplay(w), XtWindow(w), &wm_delete_window, 1); }t