C /* $XConsortium: TextAction.c,v 1.43 91/07/23 12:23:54 rws Exp $ */   < /***********************************************************< Copyright 1989 by the Massachusetts Institute of Technology, Cambridge, Massachusetts.   +                         All Rights Reserved   F Permission to use, copy, modify, and distribute this software and its A documentation for any purpose and without fee is hereby granted,  F provided that the above copyright notice appear in all copies and that@ both that copyright notice and this permission notice appear in E supporting documentation, and that the names of Digital or MIT not be B used in advertising or publicity pertaining to distribution of the6 software without specific, written prior permission.    H DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDINGH ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALLG DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR C ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, F WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,C ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 	 SOFTWARE.   C ******************************************************************/    /*C  * NOTE:  There are some ASCII Dependancies on '\n' and '\0' that I J  *        am not too thrilled with.  There is also the implicit assumptionB  *        that the individual characters will fit inside a "char".F  *        It would be nice if we could generalize this a but more.  IfH  *        anyone out there comes up with an implementation of this stuffK  *        that has no dependency on ASCII, please send the code back to us.   *  *						Chris D. Peterson       *						MIT X Consortium    */    #include <X11/IntrinsicP.h>  #include <X11/StringDefs.h>  #include <X11/Xatom.h> #include <X11/Xmu/Misc.h>  #include <X11/Xaw/TextP.h> #include <stdio.h> #include <ctype.h>  0 #define SrcScan                XawTextSourceScan6 #define FindDist               XawTextSinkFindDistance6 #define FindPos                XawTextSinkFindPosition   /*!  * These are defined in TextPop.c   */   H void _XawTextInsertFileAction(), _XawTextInsertFile(), _XawTextSearch();K void _XawTextSearch(), _XawTextDoSearchAction(), _XawTextDoReplaceAction(); 7 void _XawTextSetField(), _XawTextPopdownSearchAction();    /*  * These are defined in Text.c  */    char * _XawTextGetText(); K void _XawTextBuildLineTable(), _XawTextAlterSelection(), _XawTextVScroll(); L void _XawTextSetSelection(), _XawTextCheckResize(), _XawTextExecuteUpdate();> void _XawTextSetScrollBars(), _XawTextClearAndCenterDisplay(); Atom * _XawTextSelectionList();    static void  StartAction(ctx, event)  TextWidget ctx;  XEvent *event; {    _XawTextPrepareToUpdate(ctx);    if (event != NULL) {     switch (event->type) {     case ButtonPress:      case ButtonRelease: +       ctx->text.time = event->xbutton.time; (       ctx->text.ev_x = event->xbutton.x;(       ctx->text.ev_y = event->xbutton.y;       break;     case KeyPress:     case KeyRelease:(       ctx->text.time = event->xkey.time;%       ctx->text.ev_x = event->xkey.x; %       ctx->text.ev_y = event->xkey.y;        break;     case MotionNotify:+       ctx->text.time = event->xmotion.time; (       ctx->text.ev_x = event->xmotion.x;(       ctx->text.ev_y = event->xmotion.y;       break;     case EnterNotify:      case LeaveNotify: -       ctx->text.time = event->xcrossing.time; *       ctx->text.ev_x = event->xcrossing.x;*       ctx->text.ev_y = event->xcrossing.y;     }    }  }    static void  EndAction(ctx) TextWidget ctx;  {    _XawTextCheckResize(ctx);    _XawTextExecuteUpdate(ctx);    ctx->text.mult = 1;  }      struct _SelectionList {      String *params;      Cardinal count;      Time time; };   static void GetSelection();    /* ARGSUSED */ static void J _SelectionReceived(w, client_data, selection, type, value, length, format)	 Widget w;  XtPointer client_data; Atom *selection, *type;  XtPointer value; unsigned long *length; int *format; { !   TextWidget ctx = (TextWidget)w;    XawTextBlock text;   7   if (*type == 0 /*XT_CONVERT_FAIL*/ || *length == 0) { F     struct _SelectionList* list = (struct _SelectionList*)client_data;     if (list != NULL) { =       GetSelection(w, list->time, list->params, list->count);        XtFree(client_data);     }      return;    }       StartAction(ctx, NULL);    text.ptr = (char*)value;   text.firstPos = 0;   text.length = *length;   text.format = FMT8BIT;N   if (_XawTextReplace(ctx, ctx->text.insertPos, ctx->text.insertPos, &text)) {     XBell(XtDisplay(ctx), 0);      return;    } G   ctx->text.insertPos = SrcScan(ctx->text.source, ctx->text.insertPos,  3 				XawstPositions, XawsdRight, text.length, TRUE);      EndAction(ctx);    _XawTextSetScrollBars(ctx);    XtFree(client_data);E   XFree(value);		/* the selection value should be freed with XFree */  }    static void ) GetSelection(w, time, params, num_params) 	 Widget w; 
 Time time;6 String *params;			/* selections in precedence order */ Cardinal num_params; {      Atom selection;      int buffer;   :     selection = XInternAtom(XtDisplay(w), *params, False);     switch (selection) {-       case XA_CUT_BUFFER0: buffer = 0; break; -       case XA_CUT_BUFFER1: buffer = 1; break; -       case XA_CUT_BUFFER2: buffer = 2; break; -       case XA_CUT_BUFFER3: buffer = 3; break; -       case XA_CUT_BUFFER4: buffer = 4; break; -       case XA_CUT_BUFFER5: buffer = 5; break; -       case XA_CUT_BUFFER6: buffer = 6; break; -       case XA_CUT_BUFFER7: buffer = 7; break; "       default:	       buffer = -1;     }      if (buffer >= 0) { 	int nbytes; 	unsigned long length; 	int fmt8 = 8; 	Atom type = XA_STRING; : 	char *line = XFetchBuffer(XtDisplay(w), &nbytes, buffer); 	if (length = nbytes) B 	    _SelectionReceived(w, NULL, &selection, &type, (caddr_t)line, 			       &length, &fmt8); 	else if (num_params > 1) 3 	    GetSelection(w, time, params+1, num_params-1);      } else { 	struct _SelectionList* list;  	if (--num_params) {) 	    list = XtNew(struct _SelectionList);  	    list->params = params + 1;  	    list->count = num_params; 	    list->time = time;  	} else list = NULL;A 	XtGetSelectionValue(w, selection, XA_STRING, _SelectionReceived,  			    (XtPointer)list, time);     }  }    static void - InsertSelection(w, event, params, num_params) 	 Widget w;  XEvent *event;; String *params;		/* precedence list of selections to try */  Cardinal *num_params;  { 4   StartAction((TextWidget)w, event); /* Get Time. */C   GetSelection(w, ((TextWidget)w)->text.time, params, *num_params);    EndAction((TextWidget)w);  }   = /************************************************************   *  * Routines for Moving Around.  *>  ************************************************************/   static void $ Move(ctx, event, dir, type, include) TextWidget ctx;  XEvent *event; XawTextScanDirection dir;  XawTextScanType type;  Boolean include; {    StartAction(ctx, event);F   ctx->text.insertPos = SrcScan(ctx->text.source, ctx->text.insertPos,( 				type, dir, ctx->text.mult, include);   EndAction(ctx);  }    /*ARGSUSED*/ static void  MoveForwardChar(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { A    Move((TextWidget) w, event, XawsdRight, XawstPositions, TRUE);  }    /*ARGSUSED*/ static void   MoveBackwardChar(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { ?   Move((TextWidget) w, event, XawsdLeft, XawstPositions, TRUE);  }    /*ARGSUSED*/ static void  MoveForwardWord(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { B   Move((TextWidget) w, event, XawsdRight, XawstWhiteSpace, FALSE); }    /*ARGSUSED*/ static void   MoveBackwardWord(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { A   Move((TextWidget) w, event, XawsdLeft, XawstWhiteSpace, FALSE);  }    /*ARGSUSED*/0 static void MoveForwardParagraph(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { A   Move((TextWidget) w, event, XawsdRight, XawstParagraph, FALSE);  }    /*ARGSUSED*/1 static void MoveBackwardParagraph(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { @   Move((TextWidget) w, event, XawsdLeft, XawstParagraph, FALSE); }    /*ARGSUSED*/ static void  MoveToLineEnd(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { ;   Move((TextWidget) w, event, XawsdRight, XawstEOL, FALSE);  }    /*ARGSUSED*/ static void  MoveToLineStart(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { :   Move((TextWidget) w, event, XawsdLeft, XawstEOL, FALSE); }      static void  MoveLine(ctx, event, dir)  TextWidget ctx;  XEvent *event; XawTextScanDirection dir;  { '   XawTextPosition new, next_line, junk;    int from_left, garbage;      StartAction(ctx, event);     if (dir == XawsdLeft)      ctx->text.mult++;   6   new = SrcScan(ctx->text.source, ctx->text.insertPos,! 		XawstEOL, XawsdLeft, 1, FALSE);   K   FindDist(ctx->text.sink, new, ctx->text.margin.left, ctx->text.insertPos, ! 	   &from_left, &junk, &garbage);   E   new = SrcScan(ctx->text.source, ctx->text.insertPos, XawstEOL, dir, ' 		ctx->text.mult, (dir == XawsdRight));   M   next_line = SrcScan(ctx->text.source, new, XawstEOL, XawsdRight, 1, FALSE);   G   FindPos(ctx->text.sink, new, ctx->text.margin.left, from_left, FALSE, / 	  &(ctx->text.insertPos), &garbage, &garbage);    &   if (ctx->text.insertPos > next_line)$     ctx->text.insertPos = next_line;     EndAction(ctx);  }    /*ARGSUSED*/ static void  MoveNextLine(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { /   MoveLine( (TextWidget) w, event, XawsdRight);  }    /*ARGSUSED*/ static void   MovePreviousLine(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { .   MoveLine( (TextWidget) w, event, XawsdLeft); }    /*ARGSUSED*/ static void # MoveBeginningOfFile(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { 9   Move((TextWidget) w, event, XawsdLeft, XawstAll, TRUE);  }    /*ARGSUSED*/ static void  MoveEndOfFile(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { :   Move((TextWidget) w, event, XawsdRight, XawstAll, TRUE); }    static void  Scroll(ctx, event, dir)  TextWidget ctx;  XEvent *event; XawTextScanDirection dir;  {    StartAction(ctx, event);     if (dir == XawsdLeft) )     _XawTextVScroll(ctx, ctx->text.mult);    else*     _XawTextVScroll(ctx, -ctx->text.mult);     EndAction(ctx);  }    /*ARGSUSED*/ static void  ScrollOneLineUp(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { ,   Scroll( (TextWidget) w, event, XawsdLeft); }    /*ARGSUSED*/ static void ! ScrollOneLineDown(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { -   Scroll( (TextWidget) w, event, XawsdRight);  }    static void  MovePage(ctx, event, dir)  TextWidget ctx;  XEvent *event; XawTextScanDirection dir;  { 2   int scroll_val = Max(1, ctx->text.lt.lines - 2);     if (dir == XawsdLeft)      scroll_val = -scroll_val;      StartAction(ctx, event);#   _XawTextVScroll(ctx, scroll_val); )   ctx->text.insertPos = ctx->text.lt.top;    EndAction(ctx);  }    /*ARGSUSED*/ static void  MoveNextPage(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { .   MovePage((TextWidget) w, event, XawsdRight); }    /*ARGSUSED*/ static void   MovePreviousPage(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { -   MovePage((TextWidget) w, event, XawsdLeft);  }   = /************************************************************   *  * Delete Routines.   *>  ************************************************************/   static void " _DeleteOrKill(ctx, from, to, kill) TextWidget ctx;  XawTextPosition from, to; 
 Boolean	kill;  {    XawTextBlock text;   char *ptr;      if (kill && from < to) {)     ptr = _XawTextGetText(ctx, from, to); 6     XStoreBuffer(XtDisplay(ctx), ptr, strlen(ptr), 1);     XtFree(ptr);   }    text.length = 0;   text.firstPos = 0;.   if (_XawTextReplace(ctx, from, to, &text)) {     XBell(XtDisplay(ctx), 50);     return;    }    ctx->text.insertPos = from; !   ctx->text.showposition = TRUE;   }    static void 2 DeleteOrKill(ctx, event, dir, type, include, kill) TextWidget	   ctx; XEvent *event; XawTextScanDirection dir;  XawTextScanType type;  Boolean	   include, kill;  {    XawTextPosition from, to;       StartAction(ctx, event);5   to = SrcScan(ctx->text.source, ctx->text.insertPos, , 	       type, dir, ctx->text.mult, include);   /*H  * If no movement actually happened, then bump the count and try again. G  * This causes the character position at the very beginning and end of    * a boundry to act correctly.    */       if (to == ctx->text.insertPos)9       to = SrcScan(ctx->text.source, ctx->text.insertPos, - 		   type, dir, ctx->text.mult + 1, include);      if (dir == XawsdLeft) {      from = to;     to = ctx->text.insertPos;    }    else       from = ctx->text.insertPos;   %   _DeleteOrKill(ctx, from, to, kill);    _XawTextSetScrollBars(ctx);    EndAction(ctx);  }    /*ARGSUSED*/ static void ! DeleteForwardChar(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { O   DeleteOrKill((TextWidget) w, event, XawsdRight, XawstPositions, TRUE, FALSE);  }    /*ARGSUSED*/ static void " DeleteBackwardChar(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { N   DeleteOrKill((TextWidget) w, event, XawsdLeft, XawstPositions, TRUE, FALSE); }    /*ARGSUSED*/ static void ! DeleteForwardWord(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { %   DeleteOrKill((TextWidget) w, event, 3 	       XawsdRight, XawstWhiteSpace, FALSE, FALSE);  }    /*ARGSUSED*/ static void " DeleteBackwardWord(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { %   DeleteOrKill((TextWidget) w, event, 2 	       XawsdLeft, XawstWhiteSpace, FALSE, FALSE); }    /*ARGSUSED*/ static void  KillForwardWord(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { &   DeleteOrKill((TextWidget) w, event, 2 	       XawsdRight, XawstWhiteSpace, FALSE, TRUE); }    /*ARGSUSED*/ static void   KillBackwardWord(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { %   DeleteOrKill((TextWidget) w, event, 1 	       XawsdLeft, XawstWhiteSpace, FALSE, TRUE);  }    /*ARGSUSED*/ static void  KillToEndOfLine(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { "   TextWidget ctx = (TextWidget) w;   XawTextPosition end_of_line;     StartAction(ctx, event);I   end_of_line = SrcScan(ctx->text.source, ctx->text.insertPos, XawstEOL,  & 			XawsdRight, ctx->text.mult, FALSE);)   if (end_of_line == ctx->text.insertPos) K     end_of_line = SrcScan(ctx->text.source, ctx->text.insertPos, XawstEOL,  ' 			  XawsdRight, ctx->text.mult, TRUE);   =   _DeleteOrKill(ctx, ctx->text.insertPos, end_of_line, TRUE);    EndAction(ctx);    _XawTextSetScrollBars(ctx);  }    /*ARGSUSED*/ static void $ KillToEndOfParagraph(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { O   DeleteOrKill((TextWidget) w, event, XawsdRight, XawstParagraph, FALSE, TRUE);  }    void  & _XawTextZapSelection(ctx, event, kill) TextWidget ctx;  XEvent *event;
 Boolean kill;  {     StartAction(ctx, event); A    _DeleteOrKill(ctx, ctx->text.s.left, ctx->text.s.right, kill);     EndAction(ctx);   _XawTextSetScrollBars(ctx);  }    /*ARGSUSED*/ static void $ KillCurrentSelection(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { 5   _XawTextZapSelection( (TextWidget) w, event, TRUE);  }    /*ARGSUSED*/ static void & DeleteCurrentSelection(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { 6   _XawTextZapSelection( (TextWidget) w, event, FALSE); }   = /************************************************************   *  * Insertion Routines.  *>  ************************************************************/   static int  # InsertNewLineAndBackupInternal(ctx)  TextWidget ctx;  { !   int count, error = XawEditDone;    XawTextBlock text;   char *buf, *ptr;  6   ptr = buf = XtMalloc(sizeof(char) * ctx->text.mult);9   for (count = 0; count < ctx->text.mult; count++, ptr++)      ptr[0] = '\n';     text.length = ctx->text.mult;    text.ptr = buf;    text.firstPos = 0;   text.format = FMT8BIT;  N   if (_XawTextReplace(ctx, ctx->text.insertPos, ctx->text.insertPos, &text)) {     XBell( XtDisplay(ctx), 50);      error = XawEditError;    }    else  "     ctx->text.showposition = TRUE;     XtFree(buf);   return(error); }    /*ARGSUSED*/ static void & InsertNewLineAndBackup(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { '   StartAction( (TextWidget) w, event ); :   (void) InsertNewLineAndBackupInternal( (TextWidget) w );   EndAction( (TextWidget) w );)   _XawTextSetScrollBars( (TextWidget) w);  }   
 static int LocalInsertNewLine(ctx, event) TextWidget ctx;  XEvent *event; {    StartAction(ctx, event);:   if (InsertNewLineAndBackupInternal(ctx) == XawEditError)     return(XawEditError); G   ctx->text.insertPos = SrcScan(ctx->text.source, ctx->text.insertPos,  : 			     XawstPositions, XawsdRight, ctx->text.mult, TRUE);   EndAction(ctx);    _XawTextSetScrollBars(ctx);    return(XawEditDone); }    /*ARGSUSED*/ static void  InsertNewLine(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { 4   (void) LocalInsertNewLine( (TextWidget) w, event); }    /*ARGSUSED*/ static void & InsertNewLineAndIndent(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; {    XawTextBlock text;   XawTextPosition pos1;    register char *ptr;    register int length;"   TextWidget ctx = (TextWidget) w;     StartAction(ctx, event);8   pos1 = SrcScan(ctx->text.source, ctx->text.insertPos, " 		 XawstEOL, XawsdLeft, 1, FALSE);  M   /* Hacked because Ascii Source Object Scan method is permanently broken. */ =   text.ptr = _XawTextGetText(ctx, pos1, ctx->text.insertPos);    length = strlen(text.ptr);>   for (ptr=text.ptr; length && isspace(*ptr); ptr++, length--)       ;    *ptr = '\0';  !   text.length = strlen(text.ptr); '   if (LocalInsertNewLine(ctx, event)) {        XtFree(text.ptr); 
       return;    }    text.firstPos = 0;M   if (_XawTextReplace(ctx,ctx->text.insertPos, ctx->text.insertPos, &text)) {      XBell(XtDisplay(ctx), 50);     XtFree(text.ptr);      EndAction(ctx);      return;    } F   ctx->text.insertPos = SrcScan(ctx->text.source, ctx->text.insertPos,3 				XawstPositions, XawsdRight, text.length, TRUE);    XtFree(text.ptr);    EndAction(ctx);    _XawTextSetScrollBars(ctx);  }   = /************************************************************   *  * Selection Routines.  *?  *************************************************************/    static void ( SelectWord(w, event, params, num_params)	 Widget w;  XEvent *event; String *params;  Cardinal *num_params;  { "   TextWidget ctx = (TextWidget) w;   XawTextPosition l, r;      StartAction(ctx, event);5   l = SrcScan(ctx->text.source, ctx->text.insertPos,  - 	      XawstWhiteSpace, XawsdLeft, 1, FALSE); J   r = SrcScan(ctx->text.source, l, XawstWhiteSpace, XawsdRight, 1, FALSE);7   _XawTextSetSelection(ctx, l, r, params, *num_params);    EndAction(ctx);  }    static void ' SelectAll(w, event, params, num_params) 	 Widget w;  XEvent *event; String *params;  Cardinal *num_params;  { "   TextWidget ctx = (TextWidget) w;     StartAction(ctx, event);N   _XawTextSetSelection(ctx,zeroPosition,ctx->text.lastPos,params,*num_params);   EndAction(ctx);  }    static void = ModifySelection(ctx, event, mode, action, params, num_params)  TextWidget ctx;  XEvent *event; XawTextSelectionMode mode; XawTextSelectionAction action; String *params;		/* unused */ " Cardinal *num_params;	/* unused */ {    StartAction(ctx, event);@   _XawTextAlterSelection(ctx, mode, action, params, num_params);   EndAction(ctx);  }  		 /* ARGSUSED */ static void ) SelectStart(w, event, params, num_params) 	 Widget w;  XEvent *event; String *params;		/* unused */ " Cardinal *num_params;	/* unused */ { )   ModifySelection((TextWidget) w, event,  9 		  XawsmTextSelect, XawactionStart, params, num_params);  }    /* ARGSUSED */ static void * SelectAdjust(w, event, params, num_params)	 Widget w;  XEvent *event; String *params;		/* unused */ " Cardinal *num_params;	/* unused */ { )   ModifySelection((TextWidget) w, event,  : 		  XawsmTextSelect, XawactionAdjust, params, num_params); }    static void ' SelectEnd(w, event, params, num_params) 	 Widget w;  XEvent *event; String *params;  Cardinal *num_params;  { )   ModifySelection((TextWidget) w, event,  7 		  XawsmTextSelect, XawactionEnd, params, num_params);  }    /* ARGSUSED */ static void ) ExtendStart(w, event, params, num_params) 	 Widget w;  XEvent *event; String *params;		/* unused */ " Cardinal *num_params;	/* unused */ { )   ModifySelection((TextWidget) w, event,  9 		  XawsmTextExtend, XawactionStart, params, num_params);  }    /* ARGSUSED */ static void * ExtendAdjust(w, event, params, num_params)	 Widget w;  XEvent *event; String *params;		/* unused */ " Cardinal *num_params;	/* unused */ { )   ModifySelection((TextWidget) w, event,  : 		  XawsmTextExtend, XawactionAdjust, params, num_params); }    static void ' ExtendEnd(w, event, params, num_params) 	 Widget w;  XEvent *event; String *params;  Cardinal *num_params;  { )   ModifySelection((TextWidget) w, event,  7 		  XawsmTextExtend, XawactionEnd, params, num_params);  }    static void ( SelectSave(w, event, params, num_params)
 Widget  w; XEvent *event; String *params;  Cardinal *num_params;  {      int	    num_atoms;     Atom*   sel;      Display* dpy = XtDisplay(w);     Atom    selections[256];       StartAction (w, event);      num_atoms = *num_params;     if (num_atoms > 256) 	num_atoms = 256; ;     for (sel=selections; --num_atoms >= 0; sel++, params++) ) 	*sel = XInternAtom(dpy, *params, False);      num_atoms = *num_params;9     _XawTextSaltAwaySelection (w, selections, num_atoms);      EndAction (w); }   = /************************************************************   *  * Misc. Routines.  *>  ************************************************************/   /* ARGSUSED */ static void  RedrawDisplay(w, event, p, n) 	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { &   StartAction( (TextWidget) w, event);0   _XawTextClearAndCenterDisplay((TextWidget) w);   EndAction( (TextWidget) w);  }    /*ARGSUSED*/ static void  TextFocusIn (w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { "   TextWidget ctx = (TextWidget) w;     ctx->text.hasfocus = TRUE;   }    /*ARGSUSED*/ static void  TextFocusOut(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; { "   TextWidget ctx = (TextWidget) w;     ctx->text.hasfocus = FALSE;  }   1 static XComposeStatus compose_status = {NULL, 0};    /*	Function Name: AutoFillA  *	Description: Breaks the line at the previous word boundry when .  *                   called inside InsertChar.$  *	Arguments: ctx - The text widget.  *	Returns: none  */    static void 
 AutoFill(ctx)  TextWidget ctx;  { ,   int width, height, x, line_num, max_width;   XawTextPosition ret_pos;   XawTextBlock text;  :   if ( !((ctx->text.auto_fill) && (ctx->text.mult == 1)) )     return;   A   for ( line_num = 0; line_num < ctx->text.lt.lines ; line_num++) F     if ( ctx->text.lt.info[line_num].position >= ctx->text.insertPos )       break;$   line_num--;			/* backup a line. */  =   max_width = Max(0, (int)(ctx->core.width - HMargins(ctx)));      x = ctx->text.margin.left;O   XawTextSinkFindPosition( ctx->text.sink,ctx->text.lt.info[line_num].position, 4 			  x, max_width, TRUE, &ret_pos, &width, &height);   '   if ( ret_pos >= ctx->text.insertPos )      return;       text.ptr = "\n";   text.length = 1;   text.firstPos = 0;   text.format = FMT8BIT;  8   if (_XawTextReplace(ctx, ret_pos - 1, ret_pos, &text))F     XBell(XtDisplay((Widget) ctx), 0);	/* Unable to edit, complain. */   }    /*ARGSUSED*/ static void  InsertChar(w, event, p, n)	 Widget w;  XEvent *event;
 String *p; Cardinal *n; {2"   TextWidget ctx = (TextWidget) w;   char *ptr, strbuf[BUFSIZ];   int count, error;*   KeySym keysym;   XawTextBlock text;  B   if ( (text.length = XLookupString (&event->xkey, strbuf, BUFSIZ,, 			       &keysym, &compose_status)) == 0) {     return;d   }a   I   text.ptr = ptr = XtMalloc(sizeof(char) * text.length * ctx->text.mult); 6   for (count = 0 ; count < ctx->text.mult ; count++) {&     strncpy(ptr, strbuf, text.length);     ptr += text.length;i   }d  -   text.length = text.length * ctx->text.mult;c   text.firstPos = 0;   text.format = FMT8BIT;      StartAction(ctx, event);   O   error = _XawTextReplace(ctx, ctx->text.insertPos,ctx->text.insertPos, &text);r     if (error == XawEditDone) {M     ctx->text.insertPos = 4       SrcScan(ctx->text.source, ctx->text.insertPos,6 	      XawstPositions, XawsdRight, text.length, TRUE);     AutoFill(ctx);   }A   else C     XBell(XtDisplay(ctx), 50);     XtFree(text.ptr);R   EndAction(ctx);O   _XawTextSetScrollBars(ctx);E }N   /*ARGSUSED*/ static void * InsertString(w, event, params, num_params)	 Widget w;N XEvent *event; String *params;C Cardinal *num_params;  {*"   TextWidget ctx = (TextWidget) w;   XawTextBlock text;   int	   i;*     text.firstPos = 0;   StartAction(ctx, event);+   for (i = *num_params; i; i--, params++) {l     unsigned char hexval;eM     if ((*params)[0] == '0' && (*params)[1] == 'x' && (*params)[2] != '\0') {a       char c, *p;        hexval = 0; *       for (p = *params+2; (c = *p); p++) { 	hexval *= 16; 	if (c >= '0' && c <= '9') 	  hexval += c - '0';u 	else if (c >= 'a' && c <= 'f')n 	  hexval += c - 'a' + 10; 	else if (c >= 'A' && c <= 'F')h 	  hexval += c - 'A' + 10; 	else break;       }*       if (c == '\0') { 	text.ptr = (char*)&hexval;i 	text.length = 1;e6       } else text.length = strlen(text.ptr = *params);4     } else text.length = strlen(text.ptr = *params);#     if (text.length == 0) continue;w2     if (_XawTextReplace(ctx, ctx->text.insertPos, ! 			ctx->text.insertPos, &text)) {         XBell(XtDisplay(ctx), 50);       EndAction(ctx);e
       return;t     }      ctx->text.insertPos =F4       SrcScan(ctx->text.source, ctx->text.insertPos,6 	      XawstPositions, XawsdRight, text.length, TRUE);   }p   EndAction(ctx);d }a   static void * DisplayCaret(w, event, params, num_params)	 Widget w;f2 XEvent *event;		/* CrossingNotify special-cased */: String *params;		/* Off, False, No, On, True, Yes, etc. */% Cardinal *num_params;	/* 0, 1 or 2 */t {(!   TextWidget ctx = (TextWidget)w;x   Boolean display_caret = True;c  A   if (event->type == EnterNotify || event->type == LeaveNotify) {nB     /* for Crossing events, the default case is to check the focusB      * field and only change the caret when focus==True.  A secondE      * argument of "always" will cause the focus field to be ignored.e      */l     Boolean check_focus = True;e=     if (*num_params == 2 && strcmp(params[1], "always") == 0)        check_focus = False;7     if (check_focus && !event->xcrossing.focus) return;y   }s  4   if (*num_params > 0) {	/* default arg is "True" */     XrmValue from, to;.     from.size = strlen(from.addr = params[0]);4     XtConvert(w, XtRString, &from, XtRBoolean, &to);<     if (to.addr != NULL) display_caret = *(Boolean*)to.addr;9     if (ctx->text.display_caret == display_caret) return;a   }    StartAction(ctx, event);*   ctx->text.display_caret = display_caret;   EndAction(ctx);  }    /*	Function Name: MultiplyC  *	Description: Multiplies the current action by the number passed. "  *	Arguments: w - the text widget.*  *                 event - ** NOT USED **.F  *                 params, num_params - The parameter list, see below.  *	Returns: none.s  *  * Parameter list;  *  H  * The parameter list may contain either a number or the string 'Reset'.  * GK  * A number will multiply the current multiplication factor by that number.aJ  * Many of the text widget actions will will perform n actions, where n is  * the multiplication factor.n  *=  * The string reset will reset the mutiplication factor to 1.w  *    */x   /* ARGSUSED */ static void & Multiply(w, event, params, num_params)	 Widget w;u XEvent *event; String * params; Cardinal * num_params; {;"   TextWidget ctx = (TextWidget) w;   int mult;      if (*num_params != 1) {t0     XtAppError(XtWidgetToApplicationContext(w), ; 	       "The multiply action takes exactly one argument.");=     XBell(XtDisplay(w), 0);o     return;t   }t  9   if ( (params[0][0] == 'r') || (params[0][0] == 'R') ) {(     XBell(XtDisplay(w), 0);-     ctx->text.mult = 1;{     return;t   }a  (   if ( (mult = atoi(params[0])) == 0 ) {     char buf[BUFSIZ];tH     sprintf(buf, "%s %s", "Text Widget: The multiply action's argument",8 	    "must be a number greater than zero, or 'Reset'.");5     XtAppError(XtWidgetToApplicationContext(w), buf);	     XBell(XtDisplay(w), 0);d     return;h   }e     ctx->text.mult *= mult;S }c    /*	Function Name: StripOutOldCRs3  *	Description: strips out the old carrige returns.n$  *	Arguments: ctx - the text widget.)  *                 from - starting point. (  *                 to - the ending pointA  *	Returns: the new ending location (we may add some characters),X5  *		 or XawTextReplaceError, which indicates failure.U  */:   static XawTextPosition StripOutOldCRs(ctx, from, to)  TextWidget ctx;  XawTextPosition from, to;  {;=   XawTextPosition startPos, endPos, eop_begin, eop_end, temp;     Widget src = ctx->text.source;   XawTextBlock text;   char *buf;     text.ptr= "  ";    text.firstPos = 0;   text.format = FMT8BIT;    e /*  * Strip out CR's. ;  */   1   eop_begin = eop_end = startPos = endPos = from;o   while (TRUE) {B     endPos=SrcScan(src, startPos, XawstEOL, XawsdRight, 1, FALSE);  D     temp=SrcScan(src, endPos, XawstWhiteSpace, XawsdLeft, 1, FALSE);C     temp=SrcScan(src, temp, XawstWhiteSpace, XawsdRight, 1, FALSE);m       if (temp > startPos) 	endPos = temp;e       if (endPos >= to)n       break;       if (endPos >= eop_begin) {       startPos = eop_end;rO       eop_begin = SrcScan(src, startPos, XawstParagraph, XawsdRight, 1, FALSE);1L       eop_end = SrcScan(src, startPos, XawstParagraph, XawsdRight, 1, TRUE);     }X
     else {+       XawTextPosition periodPos, next_word;e       int i, len;o  J       periodPos= SrcScan(src, endPos, XawstPositions, XawsdLeft, 1, TRUE);N       next_word = SrcScan(src, endPos, XawstWhiteSpace, XawsdRight, 1, FALSE);  "       len = next_word - periodPos;         text.length = 1;7       buf = _XawTextGetText(ctx, periodPos, next_word);i4       if ( (periodPos < endPos) && (buf[0] == '.') )* 	  text.length++;	/* Put in two spaces. */         /*"        * Remove all extra spaces. 	        */   !       for (i = 1 ; i < len; i++) *7 	  if ( !isspace(buf[i]) || ((periodPos + i) >= to) ) {*
 	      break;c 	  }              XtFree(buf);  "       to -= (i - text.length - 1);N       startPos = SrcScan(src, periodPos, XawstPositions, XawsdRight, i, TRUE);G       if (_XawTextReplace(ctx, endPos, startPos, &text) != XawEditDone)o 	  return XawReplaceError;"       startPos -= i - text.length;     }    }t
   return(to);  }*   /*	Function Name: InsertNewCRs0  *	Description: Inserts the new Carrige Returns.$  *	Arguments: ctx - the text widget.5  *                 from, to - the ends of the region.T  *	Returns: none  */D   static void  InsertNewCRs(ctx, from, to)p TextWidget ctx;  XawTextPosition from, to;  {d/   XawTextPosition startPos, endPos, space, eol;L   XawTextBlock text;   int i, width, height, len;
   char * buf;e     text.ptr = "\n";   text.length = 1;   text.firstPos = 0;   text.format = FMT8BIT;     startPos = from;   while (TRUE) {7     XawTextSinkFindPosition( ctx->text.sink, startPos,  # 			    (int) ctx->text.margin.left,i0 			    (int) (ctx->core.width - HMargins(ctx)), $ 			    TRUE, &eol, &width, &height);     if (eol >= to)       break;  M     eol = SrcScan(ctx->text.source, eol, XawstPositions, XawsdLeft, 1, TRUE); O     space= SrcScan(ctx->text.source, eol, XawstWhiteSpace, XawsdRight, 1,TRUE);s          startPos = endPos = eol;     if (eol == space) 
       return;a       len = (int) (space - eol);+     buf = _XawTextGetText(ctx, eol, space);*      for ( i = 0 ; i < len ; i++)       if (!isspace(buf[i])), 	break;        to -= (i - 1);.     endPos = SrcScan(ctx->text.source, endPos,, 		     XawstPositions, XawsdRight, i, TRUE);     XtFree(buf);     6     if (_XawTextReplace(ctx, startPos, endPos, &text)) 	return;2     startPos = SrcScan(ctx->text.source, startPos,. 		       XawstPositions, XawsdRight, 1, TRUE);   }  }  e    /*	Function Name: FormRegion.  *	Description: Forms up the region specified.$  *	Arguments: ctx - the text widget.5  *                 from, to - the ends of the region.T:  *	Returns: XawEditDone if successful, or XawReplaceError.  */   
 static int FormRegion(ctx, from, to)= TextWidget ctx;  XawTextPosition from, to;  {r%   if (from >= to) return XawEditDone;t  >   if ((to = StripOutOldCRs(ctx, from, to)) == XawReplaceError)       return XawReplaceError;,>   /* insure that the insertion point is within legal bounds */   if (ctx->text.insertPos >eB       SrcScan(ctx->text.source, 0, XawstAll, XawsdRight, 1, TRUE))       ctx->text.insertPos = to;S   InsertNewCRs(ctx, from, to);6   _XawTextBuildLineTable(ctx, ctx->text.lt.top, TRUE);   return XawEditDone;. }t    /*	Function Name: FormParagraph.1  *	Description: reforms up the current paragraph.t"  *	Arguments: w - the text widget.'  *                 event - the X event.o7  *                 params, num_params *** NOT USED ***.w  *	Returns: none  */w   /* ARGSUSED */ static void + FormParagraph(w, event, params, num_params) 	 Widget w;d XEvent *event; String * params; Cardinal * num_params; {w"   TextWidget ctx = (TextWidget) w;   XawTextPosition from, to;*     StartAction(ctx, event);  8   from =  SrcScan(ctx->text.source, ctx->text.insertPos,) 		  XawstParagraph, XawsdLeft, 1, FALSE);t(   to  =  SrcScan(ctx->text.source, from,) 		 XawstParagraph, XawsdRight, 1, FALSE);s  3   if (FormRegion(ctx, from, to) == XawReplaceError)i       XBell(XtDisplay(w), 0);n   EndAction(ctx);e   _XawTextSetScrollBars(ctx);l };  % /*	Function Name: TransposeCharactersR@  *	Description: Swaps the character to the left of the mark with<  *                   the character to the right of the mark."  *	Arguments: w - the text widget.<  *                 event - the event that cause this action.7  *                 params, num_params *** NOT USED ***.t  *	Returns: none.t  */  	      /* ARGSUSED */ static void 1 TransposeCharacters(w, event, params, num_params)v	 Widget w;g XEvent *event; String * params; Cardinal * num_params; {d"   TextWidget ctx = (TextWidget) w;   XawTextPosition start, end;t   XawTextBlock text;   unsigned char * buf, c;    int i;     StartAction(ctx, event);   /*  * Get bounds.    */   I   start = SrcScan(ctx->text.source, ctx->text.insertPos, XawstPositions,   		  XawsdLeft, 1, TRUE);G   end = SrcScan(ctx->text.source, ctx->text.insertPos, XawstPositions, X$ 		XawsdRight, ctx->text.mult, TRUE);  H   if ( (start == ctx->text.insertPos) || (end == ctx->text.insertPos) ) +     XBell(XtDisplay(w), 0);	/* complain. */n   else {     ctx->text.insertPos = end;       /*.      * Retrieve text and swap the characters.       */t     =     buf = (unsigned char *) _XawTextGetText(ctx, start, end);g&     text.length = strlen((char *)buf);     text.firstPos = 0;     text.format = FMT8BIT;          c = buf[0];a'     for (i = 1 ; i < text.length ; i++),       buf[i - 1] = buf[i];     buf[i - 1] = c;*          /* *       * Store new text is source.      */t          text.ptr = (char *) buf;1     if (_XawTextReplace (ctx, start, end, &text))i8 	XBell(XtDisplay(w), 0);	/* Unable to edit, complain. */     XtFree((char *) buf);    }a   EndAction(ctx);T }B   /*	Function Name: NoOp:  *	Description: This action performs no action, and allowsD  *                   the user or application programmer to unbind a !  *                   translation.n"  *	Arguments: w - the text widget.*  *                 event - *** UNUSED ***.@  *                 parms and num_params - the action parameters.  *	Returns: none.   *B  * Note: If the parameter list contains the string "RingBell" then(  *       this action will ring the bell.  */    /*ARGSUSED*/ static voidS" NoOp(w, event, params, num_params)	 Widget w;l XEvent *event; String *params;T Cardinal *num_params;  {      if (*num_params != 1)  	return;       switch(params[0][0]) {
     case 'R': 
     case 'r':i 	XBell(XtDisplay(w), 0);!     default:			/* Fall Through */y 	break;,     }u }t 	c /* Action Table */  ' XtActionsRec _XawTextActionsTable[] = {t /* motion bindings */n*   {"forward-character", 	MoveForwardChar},,   {"backward-character", 	MoveBackwardChar},&   {"forward-word", 		MoveForwardWord},(   {"backward-word", 		MoveBackwardWord},/   {"forward-paragraph", 	MoveForwardParagraph}, 1   {"backward-paragraph", 	MoveBackwardParagraph}, *   {"beginning-of-line", 	MoveToLineStart},#   {"end-of-line", 		MoveToLineEnd},l    {"next-line", 		MoveNextLine},(   {"previous-line", 		MovePreviousLine},    {"next-page", 		MoveNextPage},(   {"previous-page", 		MovePreviousPage},.   {"beginning-of-file", 	MoveBeginningOfFile},#   {"end-of-file", 		MoveEndOfFile},a+   {"scroll-one-line-up", 	ScrollOneLineUp},D/   {"scroll-one-line-down", 	ScrollOneLineDown},  /* delete bindings */*0   {"delete-next-character", 	DeleteForwardChar},4   {"delete-previous-character", DeleteBackwardChar},,   {"delete-next-word", 		DeleteForwardWord},0   {"delete-previous-word", 	DeleteBackwardWord},1   {"delete-selection", 		DeleteCurrentSelection},e /* kill bindings */ #   {"kill-word", 		KillForwardWord},W,   {"backward-kill-word", 	KillBackwardWord},-   {"kill-selection", 		KillCurrentSelection}, ,   {"kill-to-end-of-line", 	KillToEndOfLine},6   {"kill-to-end-of-paragraph", 	KillToEndOfParagraph}, /* new line stuff */2   {"newline-and-indent", 	InsertNewLineAndIndent},2   {"newline-and-backup", 	InsertNewLineAndBackup},    {"newline", 			InsertNewLine}, /* Selection stuff */e    {"select-word", 		SelectWord},   {"select-all", 		SelectAll},"   {"select-start", 		SelectStart},$   {"select-adjust", 		SelectAdjust},   {"select-end", 		SelectEnd},   {"select-save",		SelectSave},;"   {"extend-start", 		ExtendStart},$   {"extend-adjust", 		ExtendAdjust},   {"extend-end", 		ExtendEnd},)   {"insert-selection",		InsertSelection},, /* Miscellaneous */t&   {"redraw-display", 		RedrawDisplay},(   {"insert-file", 		_XawTextInsertFile},&   {"search",		        _XawTextSearch},    {"insert-char", 		InsertChar},#   {"insert-string",		InsertString},t'   {"focus-in", 	 	        TextFocusIn},i    {"focus-out", 		TextFocusOut},#   {"display-caret",		DisplayCaret}, "   {"multiply",		        Multiply},/   {"form-paragraph",            FormParagraph},X5   {"transpose-characters",      TransposeCharacters},t&   {"no-op",                     NoOp},; /* Action to bind special translations for text Dialogs. */ :   {"InsertFileAction",          _XawTextInsertFileAction},8   {"DoSearchAction",            _XawTextDoSearchAction},9   {"DoReplaceAction",           _XawTextDoReplaceAction},a2   {"SetField",                  _XawTextSetField},=   {"PopdownSearchAction",       _XawTextPopdownSearchAction},; };  D Cardinal _XawTextActionsTableCount = XtNumber(_XawTextActionsTable);