C /* $XConsortium: Text.c,v 1.182 91/07/24 22:56:47 converse Exp $ */   < /***********************************************************N Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,H and the Massachusetts Institute of Technology, Cambridge, Massachusetts.  +                         All Rights Reserved   F Permission to use, copy, modify, and distribute this software and its A documentation for any purpose and without fee is hereby granted,  F provided that the above copyright notice appear in all copies and that@ both that copyright notice and this permission notice appear in E supporting documentation, and that the names of Digital or MIT not be B used in advertising or publicity pertaining to distribution of the6 software without specific, written prior permission.    H DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDINGH ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALLG DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR C ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, F WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,C ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 	 SOFTWARE.   C ******************************************************************/    #include <X11/IntrinsicP.h>  #include <X11/StringDefs.h>  #include <X11/Shell.h> #include <X11/Xatom.h> #include <stdio.h>   #include <X11/Xmu/Atoms.h> #include <X11/Xmu/CharSet.h> #include <X11/Xmu/Converters.h>  #include <X11/Xmu/StdSel.h>  #include <X11/Xmu/Misc.h>    #include <X11/Xaw/XawInit.h> #include <X11/Xaw/Cardinals.h> #include <X11/Xaw/Scrollbar.h> #include <X11/Xaw/TextP.h>   #include <X11/Xfuncs.h>    unsigned long FMT8BIT = 0L;   ; #define SinkClearToBG          XawTextSinkClearToBackground   0 #define SrcScan                XawTextSourceScan0 #define SrcRead                XawTextSourceRead3 #define SrcReplace             XawTextSourceReplace 2 #define SrcSearch              XawTextSourceSearch< #define SrcCvtSel              XawTextSourceConvertSelection8 #define SrcSetSelection        XawTextSourceSetSelection  ! #define BIGNUM ((Dimension)32023)  #define MULTI_CLICK_TIME 500L    /*G  * Compute a the maximum length of a cut buffer that we can pass at any H  * time.  The 64 allows for the overhead of the Change Property request.  */   5 #define MAX_CUT_LEN(dpy)  (XMaxRequestSize(dpy) - 64)   1 #define IsValidLine(ctx, num) ( ((num) == 0) || \ 7 			        ((ctx)->text.lt.info[(num)].position != 0) )    /*  * Defined in Text.c  */ " static void UnrealizeScrollbars();C static void VScroll(), VJump(), HScroll(), HJump(), ClearWindow();  D static void DisplayTextWindow(), ModifySelection(), PushCopyQueue();H static void UpdateTextInLine(), UpdateTextInRectangle(), PopCopyQueue(); static void FlushUpdate();? static Boolean LineAndXYForPosition(), TranslateExposeRegion(); = static XawTextPosition FindGoodPosition(), _BuildLineTable();   7 void _XawTextAlterSelection(), _XawTextExecuteUpdate(); 7 void _XawTextBuildLineTable(), _XawTextSetScrollBars();   A /****************************************************************   *  * Full class record constant   *B  ****************************************************************/  1 static XawTextSelectType defaultSelectTypes[] = { F   XawselectPosition, XawselectWord, XawselectLine, XawselectParagraph,#   XawselectAll,      XawselectNull,  };  C static caddr_t defaultSelectTypesPtr = (caddr_t)defaultSelectTypes; I extern char *_XawDefaultTextTranslations1, *_XawDefaultTextTranslations2,     *_XawDefaultTextTranslations3;  static Dimension defWidth = 100;1 static Dimension defHeight = DEFAULT_TEXT_HEIGHT;   0 #define offset(field) XtOffsetOf(TextRec, field)! static XtResource resources[] = { 7   {XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension), =      offset(core.width), XtRDimension, (XtPointer)&defWidth}, 3   {XtNcursor, XtCCursor, XtRCursor, sizeof(Cursor), 0      offset(simple.cursor), XtRString, "xterm"},9   {XtNheight, XtCHeight, XtRDimension, sizeof(Dimension), ?      offset(core.height), XtRDimension, (XtPointer)&defHeight}, I   {XtNdisplayPosition, XtCTextPosition, XtRInt, sizeof(XawTextPosition),  6      offset(text.lt.top), XtRImmediate, (XtPointer)0},G   {XtNinsertPosition, XtCTextPosition, XtRInt, sizeof(XawTextPosition), 8      offset(text.insertPos), XtRImmediate,(XtPointer)0},<   {XtNleftMargin, XtCMargin, XtRPosition, sizeof (Position),=      offset(text.r_margin.left), XtRImmediate, (XtPointer)2}, =   {XtNrightMargin, XtCMargin, XtRPosition, sizeof (Position), >      offset(text.r_margin.right), XtRImmediate, (XtPointer)4},;   {XtNtopMargin, XtCMargin, XtRPosition, sizeof (Position), <      offset(text.r_margin.top), XtRImmediate, (XtPointer)2},>   {XtNbottomMargin, XtCMargin, XtRPosition, sizeof (Position),?      offset(text.r_margin.bottom), XtRImmediate, (XtPointer)2}, .   {XtNselectTypes, XtCSelectTypes, XtRPointer,5      sizeof(XawTextSelectType*), offset(text.sarray), 4      XtRPointer, (XtPointer)&defaultSelectTypesPtr},<   {XtNtextSource, XtCTextSource, XtRWidget, sizeof (Widget),.      offset(text.source), XtRImmediate, NULL},8   {XtNtextSink, XtCTextSink, XtRWidget, sizeof (Widget),,      offset(text.sink), XtRImmediate, NULL},;   {XtNdisplayCaret, XtCOutput, XtRBoolean, sizeof(Boolean), @      offset(text.display_caret), XtRImmediate, (XtPointer)True},J   {XtNscrollVertical, XtCScroll, XtRScrollMode, sizeof(XawTextScrollMode),M      offset(text.scroll_vert), XtRImmediate, (XtPointer) XawtextScrollNever}, L   {XtNscrollHorizontal, XtCScroll, XtRScrollMode, sizeof(XawTextScrollMode),N      offset(text.scroll_horiz), XtRImmediate, (XtPointer) XawtextScrollNever},:   {XtNwrap, XtCWrap, XtRWrapMode, sizeof(XawTextWrapMode),D      offset(text.wrap), XtRImmediate, (XtPointer) XawtextWrapNever},B   {XtNresize, XtCResize, XtRResizeMode, sizeof(XawTextResizeMode),H      offset(text.resize), XtRImmediate, (XtPointer) XawtextResizeNever},9   {XtNautoFill, XtCAutoFill, XtRBoolean, sizeof(Boolean), >      offset(text.auto_fill), XtRImmediate, (XtPointer) FALSE},E   {XtNunrealizeCallback, XtCCallback, XtRCallback, sizeof(XtPointer), E      offset(text.unrealize_callbacks), XtRCallback, (XtPointer) NULL}  };
 #undef offset    #define done(address, type) \ H         { toVal->size = sizeof(type); toVal->addr = (caddr_t) address; }       /* ARGSUSED */ static void 5 CvtStringToScrollMode(args, num_args, fromVal, toVal)  XrmValuePtr args;		/* unused */   Cardinal	*num_args;	/* unused */ XrmValuePtr	fromVal; XrmValuePtr	toVal; { &   static XawTextScrollMode scrollMode;C   static  XrmQuark  QScrollNever, QScrollAlways, QScrollWhenNeeded;    XrmQuark    q;    char        lowerName[BUFSIZ];    static Boolean inited = FALSE;        if ( !inited ) {A     QScrollNever      = XrmPermStringToQuark(XtEtextScrollNever); F     QScrollWhenNeeded = XrmPermStringToQuark(XtEtextScrollWhenNeeded);B     QScrollAlways     = XrmPermStringToQuark(XtEtextScrollAlways);     inited = TRUE;   }   =   XmuCopyISOLatin1Lowered (lowerName, (char *)fromVal->addr); "   q = XrmStringToQuark(lowerName);  G   if      (q == QScrollNever)          scrollMode = XawtextScrollNever; L   else if (q == QScrollWhenNeeded)     scrollMode = XawtextScrollWhenNeeded;H   else if (q == QScrollAlways)         scrollMode = XawtextScrollAlways;   else {     done(NULL, 0);     return;    } '   done(&scrollMode, XawTextScrollMode); 	   return;  }    /* ARGSUSED */ static void 3 CvtStringToWrapMode(args, num_args, fromVal, toVal)  XrmValuePtr args;		/* unused */   Cardinal	*num_args;	/* unused */ XrmValuePtr	fromVal; XrmValuePtr	toVal; { "   static XawTextWrapMode wrapMode;4   static  XrmQuark QWrapNever, QWrapLine, QWrapWord;   XrmQuark    q;    char        lowerName[BUFSIZ];    static Boolean inited = FALSE;        if ( !inited ) {8     QWrapNever = XrmPermStringToQuark(XtEtextWrapNever);7     QWrapLine  = XrmPermStringToQuark(XtEtextWrapLine); 7     QWrapWord  = XrmPermStringToQuark(XtEtextWrapWord);      inited = TRUE;   }   =   XmuCopyISOLatin1Lowered (lowerName, (char *)fromVal->addr); "   q = XrmStringToQuark(lowerName);  <   if      (q == QWrapNever)     wrapMode = XawtextWrapNever;;   else if (q == QWrapLine)      wrapMode = XawtextWrapLine; ;   else if (q == QWrapWord)      wrapMode = XawtextWrapWord;    else {     done(NULL, 0);     return;    } #   done(&wrapMode, XawTextWrapMode); 	   return;  }    /* ARGSUSED */ static void 5 CvtStringToResizeMode(args, num_args, fromVal, toVal)  XrmValuePtr args;		/* unused */   Cardinal	*num_args;	/* unused */ XrmValuePtr	fromVal; XrmValuePtr	toVal; { &   static XawTextResizeMode resizeMode;K   static  XrmQuark  QResizeNever, QResizeWidth, QResizeHeight, QResizeBoth;    XrmQuark    q;    char        lowerName[BUFSIZ];    static Boolean inited = FALSE;        if ( !inited ) {A     QResizeNever      = XrmPermStringToQuark(XtEtextResizeNever); A     QResizeWidth      = XrmPermStringToQuark(XtEtextResizeWidth); B     QResizeHeight     = XrmPermStringToQuark(XtEtextResizeHeight);@     QResizeBoth       = XrmPermStringToQuark(XtEtextResizeBoth);     inited = TRUE;   }   =   XmuCopyISOLatin1Lowered (lowerName, (char *)fromVal->addr); "   q = XrmStringToQuark(lowerName);  G   if      (q == QResizeNever)          resizeMode = XawtextResizeNever; G   else if (q == QResizeWidth)          resizeMode = XawtextResizeWidth; H   else if (q == QResizeHeight)         resizeMode = XawtextResizeHeight;F   else if (q == QResizeBoth)           resizeMode = XawtextResizeBoth;   else {     done(NULL, 0);     return;    } '   done(&resizeMode, XawTextResizeMode); 	   return;  }    #undef done    static void  ClassInitialize()  { 3   int len1 = strlen (_XawDefaultTextTranslations1); 3   int len2 = strlen (_XawDefaultTextTranslations2); 3   int len3 = strlen (_XawDefaultTextTranslations3); 0   char *buf = XtMalloc (len1 + len2 + len3 + 1);   char *cp = buf;      if (!FMT8BIT) .     FMT8BIT = XrmPermStringToQuark("FMT8BIT");     XawInitializeWidgetSet();    /*    * Set the number of actions.   */   B   textClassRec.core_class.num_actions = _XawTextActionsTableCount;   8   strcpy (cp, _XawDefaultTextTranslations1); cp += len1;8   strcpy (cp, _XawDefaultTextTranslations2); cp += len2;,   strcpy (cp, _XawDefaultTextTranslations3);-   textWidgetClass->core_class.tm_table = buf;   K   XtAddConverter(XtRString, XtRScrollMode, CvtStringToScrollMode, NULL, 0); K   XtAddConverter(XtRString, XtRWrapMode,   CvtStringToWrapMode,   NULL, 0); K   XtAddConverter(XtRString, XtRResizeMode, CvtStringToResizeMode, NULL, 0);  }   % /*	Function Name: PositionHScrollBar. 3  *	Description: Positions the Horizontal scrollbar. $  *	Arguments: ctx - the text widget.  *	Returns: none  */    static void  PositionHScrollBar(ctx)  TextWidget ctx;  { 6   Widget vbar = ctx->text.vbar, hbar = ctx->text.hbar;   Position top, left = 0;   %   if (ctx->text.hbar == NULL) return;      if (vbar != NULL) D     left += (Position) (vbar->core.width + vbar->core.border_width);  B   XtResizeWidget( hbar, ctx->core.width - left, hbar->core.height, 		 hbar->core.border_width );   -   left -= (Position) hbar->core.border_width;    J   top = ctx->core.height - ( hbar->core.height + hbar->core.border_width);"   XtMoveWidget( hbar, left, top);  }   % /*	Function Name: PositionVScrollBar. 1  *	Description: Positions the Vertical scrollbar. $  *	Arguments: ctx - the text widget.  *	Returns: none.   */    static void  PositionVScrollBar(ctx)  TextWidget ctx;  {    Widget vbar = ctx->text.vbar;    Dimension bw;      if (vbar == NULL) return;    bw = vbar->core.border_width;   @   XtResizeWidget( vbar, vbar->core.width, ctx->core.height, bw);5   XtMoveWidget( vbar, -(Position)bw, -(Position)bw );  }    static void  CreateVScrollBar(ctx)  TextWidget ctx;  {    Widget vbar;  %   if (ctx->text.vbar != NULL) return;      ctx->text.vbar = vbar = P     XtCreateWidget("vScrollbar", scrollbarWidgetClass, (Widget)ctx, NULL, ZERO);@   XtAddCallback( vbar, XtNscrollProc, VScroll, (XtPointer)ctx );<   XtAddCallback( vbar, XtNjumpProc, VJump, (XtPointer)ctx );   if (ctx->text.hbar == NULL) L       XtAddCallback((Widget) ctx, XtNunrealizeCallback, UnrealizeScrollbars, 		    (XtPointer) NULL);  H   ctx->text.r_margin.left += vbar->core.width + vbar->core.border_width;2   ctx->text.margin.left = ctx->text.r_margin.left;     PositionVScrollBar(ctx);C   PositionHScrollBar(ctx);	/* May modify location of Horiz. Bar. */   "   if (XtIsRealized((Widget)ctx)) {     XtRealizeWidget(vbar);     XtMapWidget(vbar);   }  }   # /*	Function Name: DestroyVScrollBar -  *	Description: Removes a vertical ScrollBar. +  *	Arguments: ctx - the parent text widget.   *	Returns: none.   */    static void  DestroyVScrollBar(ctx) TextWidget ctx;  {    Widget vbar = ctx->text.vbar;      if (vbar == NULL) return;   H   ctx->text.r_margin.left -= vbar->core.width + vbar->core.border_width;2   ctx->text.margin.left = ctx->text.r_margin.left;   if (ctx->text.hbar == NULL) O       XtRemoveCallback((Widget) ctx, XtNunrealizeCallback, UnrealizeScrollbars,  		       (XtPointer) NULL);    XtDestroyWidget(vbar);   ctx->text.vbar = NULL;   PositionHScrollBar(ctx); }     static void  CreateHScrollBar(ctx)  TextWidget ctx;  {    Arg args[1];   Widget hbar;  %   if (ctx->text.hbar != NULL) return;   8   XtSetArg(args[0], XtNorientation, XtorientHorizontal);   ctx->text.hbar = hbar = O     XtCreateWidget("hScrollbar", scrollbarWidgetClass, (Widget)ctx, args, ONE); @   XtAddCallback( hbar, XtNscrollProc, HScroll, (XtPointer)ctx );<   XtAddCallback( hbar, XtNjumpProc, HJump, (XtPointer)ctx );   if (ctx->text.vbar == NULL) L       XtAddCallback((Widget) ctx, XtNunrealizeCallback, UnrealizeScrollbars, 		    (XtPointer) NULL);     PositionHScrollBar(ctx);"   if (XtIsRealized((Widget)ctx)) {     XtRealizeWidget(hbar);     XtMapWidget(hbar);   }  }   # /*	Function Name: DestroyHScrollBar /  *	Description: Removes a horizontal ScrollBar. +  *	Arguments: ctx - the parent text widget.   *	Returns: none.   */    static void  DestroyHScrollBar(ctx) TextWidget ctx;  {    Widget hbar = ctx->text.hbar;      if (hbar == NULL) return;    /*K   ctx->text.r_margin.bottom -= hbar->core.height + hbar->core.border_width; 6   ctx->text.margin.bottom = ctx->text.r_margin.bottom; */   if (ctx->text.vbar == NULL) O       XtRemoveCallback((Widget) ctx, XtNunrealizeCallback, UnrealizeScrollbars,  		       (XtPointer) NULL);    XtDestroyWidget(hbar);   ctx->text.hbar = NULL; }    /* ARGSUSED */ static void ( Initialize(request, new, args, num_args) Widget request, new; ArgList args;			/* unused */! Cardinal *num_args;		/* unused */  { $   TextWidget ctx = (TextWidget) new;   char error_buf[BUFSIZ];      ctx->text.lt.lines = 0;    ctx->text.lt.info = NULL; A   bzero((char *) &(ctx->text.origSel), sizeof(XawTextSelection)); <   bzero((char *) &(ctx->text.s), sizeof(XawTextSelection)); '   ctx->text.s.type = XawselectPosition;    ctx->text.salt = NULL;2   ctx->text.hbar = ctx->text.vbar = (Widget) NULL;,   ctx->text.lasttime = 0; /* ||| correct? */(   ctx->text.time = 0; /* ||| correct? */    ctx->text.showposition = TRUE;B   ctx->text.lastPos = (ctx->text.source != NULL) ? GETLASTPOS : 0;   ctx->text.file_insert = NULL;    ctx->text.search = NULL;;   ctx->text.updateFrom = (XawTextPosition *) XtMalloc(ONE); 9   ctx->text.updateTo = (XawTextPosition *) XtMalloc(ONE); 0   ctx->text.numranges = ctx->text.maxranges = 0;3   ctx->text.gc = DefaultGCOfScreen(XtScreen(ctx));     ctx->text.hasfocus = FALSE; =   ctx->text.margin = ctx->text.r_margin; /* Strucure copy. */ $   ctx->text.update_disabled = FALSE;   ctx->text.old_insert = -1;   ctx->text.mult = 1;     ctx->text.single_char = FALSE;%   ctx->text.copy_area_offsets = NULL;   0   if (ctx->core.height == DEFAULT_TEXT_HEIGHT) {%     ctx->core.height = VMargins(ctx);      if (ctx->text.sink != NULL) B       ctx->core.height += XawTextSinkMaxHeight(ctx->text.sink, 1);   }   3   if (ctx->text.scroll_vert != XawtextScrollNever)  5     if ( (ctx->text.resize == XawtextResizeHeight) || 2      	 (ctx->text.resize == XawtextResizeBoth) ) {F       sprintf(error_buf, "Text Widget (%s):\n %s %s.", ctx->core.name,> 	      "Vertical scrolling not allowed with height resize.\n",3 	      "Vertical scrolling has been DEACTIVATED."); A       XtAppWarning(XtWidgetToApplicationContext(new), error_buf); 1       ctx->text.scroll_vert = XawtextScrollNever;      } :     else if (ctx->text.scroll_vert == XawtextScrollAlways)       CreateVScrollBar(ctx);  4   if (ctx->text.scroll_horiz != XawtextScrollNever) -     if (ctx->text.wrap != XawtextWrapNever) { F       sprintf(error_buf, "Text Widget (%s):\n %s %s.", ctx->core.name,B 	      "Horizontal scrolling not allowed with wrapping active.\n",5 	      "Horizontal scrolling has been DEACTIVATED."); A       XtAppWarning(XtWidgetToApplicationContext(new), error_buf); 2       ctx->text.scroll_horiz = XawtextScrollNever;     } 9     else if ( (ctx->text.resize == XawtextResizeWidth) || 2 	      (ctx->text.resize == XawtextResizeBoth) ) {F       sprintf(error_buf, "Text Widget (%s):\n %s %s.", ctx->core.name,? 	      "Horizontal scrolling not allowed with width resize.\n", 5 	      "Horizontal scrolling has been DEACTIVATED."); A       XtAppWarning(XtWidgetToApplicationContext(new), error_buf); 2       ctx->text.scroll_horiz = XawtextScrollNever;     } ;     else if (ctx->text.scroll_horiz == XawtextScrollAlways)        CreateHScrollBar(ctx); }    static void # Realize( w, valueMask, attributes ) 	 Widget w;  Mask *valueMask;! XSetWindowAttributes *attributes;  { !   TextWidget ctx = (TextWidget)w;    void _XawTextCheckResize();   ;   (*textClassRec.core_class.superclass->core_class.realize)      (w, valueMask, attributes);    K   if (ctx->text.hbar != NULL) {	        /* Put up Hbar -- Must be first. */ $     XtRealizeWidget(ctx->text.hbar);      XtMapWidget(ctx->text.hbar);   }   :   if (ctx->text.vbar != NULL) {	        /* Put up Vbar. */$     XtRealizeWidget(ctx->text.vbar);      XtMapWidget(ctx->text.vbar);   }   6   _XawTextBuildLineTable(ctx, ctx->text.lt.top, TRUE);   _XawTextSetScrollBars(ctx);    _XawTextCheckResize(ctx);  }    /*ARGSUSED*/5 static void UnrealizeScrollbars(widget, client, call) " Widget		widget;		/* Text widget */ XtPointer	client;		/* unused */  XtPointer	call; 		/* unused */ { )     TextWidget ctx = (TextWidget) widget;           if (ctx->text.hbar) # 	XtUnrealizeWidget(ctx->text.hbar);      if (ctx->text.vbar) # 	XtUnrealizeWidget(ctx->text.vbar);  }   * /* Utility routines for support of Text */   static void  _CreateCutBuffers(d) Display *d;  {    static struct _DisplayRec {      struct _DisplayRec *next;      Display *dpy;    } *dpy_list = NULL;    struct _DisplayRec *dpy_ptr;  D   for (dpy_ptr = dpy_list; dpy_ptr != NULL; dpy_ptr = dpy_ptr->next)"     if (dpy_ptr->dpy == d) return;  &   dpy_ptr = XtNew(struct _DisplayRec);   dpy_ptr->next = dpy_list;    dpy_ptr->dpy = d;    dpy_list = dpy_ptr;    #define Create(buffer) \@     XChangeProperty(d, RootWindow(d, 0), buffer, XA_STRING, 8, \  		    PropModeAppend, NULL, 0 );       Create( XA_CUT_BUFFER0 );      Create( XA_CUT_BUFFER1 );      Create( XA_CUT_BUFFER2 );      Create( XA_CUT_BUFFER3 );      Create( XA_CUT_BUFFER4 );      Create( XA_CUT_BUFFER5 );      Create( XA_CUT_BUFFER6 );      Create( XA_CUT_BUFFER7 );   
 #undef Create  }    /*K  * Procedure to manage insert cursor visibility for editable text.  It uses J  * the value of ctx->insertPos and an implicit argument. In the event thatM  * position is immediately preceded by an eol graphic, then the insert cursor 2  * is displayed at the beginning of the next line. */ static void  InsertCursor (w, state) 	 Widget w;  XawTextInsertState state;  { !   TextWidget ctx = (TextWidget)w;    Position x, y;   int line;    %   if (ctx->text.lt.lines < 1) return;   H   if ( LineAndXYForPosition(ctx, ctx->text.insertPos, &line, &x, &y) ) {"     if (line < ctx->text.lt.lines)K       y += (ctx->text.lt.info[line + 1].y - ctx->text.lt.info[line].y) + 1;      elseK       y += (ctx->text.lt.info[line].y - ctx->text.lt.info[line - 1].y) + 1;         if (ctx->text.display_caret);       XawTextSinkInsertCursor(ctx->text.sink, x, y, state);    }    ctx->text.ev_x = x;    ctx->text.ev_y = y;  }    /*N  * Procedure to register a span of text that is no longer valid on the displayM  * It is used to avoid a number of small, and potentially overlapping, screen   * updates.  */   void' _XawTextNeedsUpdating(ctx, left, right)  TextWidget ctx;  XawTextPosition left, right; {    int i;   if (left < right) { /     for (i = 0; i < ctx->text.numranges; i++) { N       if (left <= ctx->text.updateTo[i] && right >= ctx->text.updateFrom[i]) {> 	ctx->text.updateFrom[i] = Min(left, ctx->text.updateFrom[i]);; 	ctx->text.updateTo[i] = Max(right, ctx->text.updateTo[i]);  	return;       }      }      ctx->text.numranges++;4     if (ctx->text.numranges > ctx->text.maxranges) {0       ctx->text.maxranges = ctx->text.numranges;8       i = ctx->text.maxranges * sizeof(XawTextPosition);1       ctx->text.updateFrom = (XawTextPosition *)  7 	XtRealloc((char *)ctx->text.updateFrom, (unsigned) i); /       ctx->text.updateTo = (XawTextPosition *)  5 	XtRealloc((char *)ctx->text.updateTo, (unsigned) i);      } 9     ctx->text.updateFrom[ctx->text.numranges - 1] = left; 8     ctx->text.updateTo[ctx->text.numranges - 1] = right;   }  }    /*L  * Procedure to read a span of text in Ascii form. This is purely a hack andO  * we probably need to add a function to sources to provide this functionality. N  * [note: this is really a private procedure but is used in multiple modules].  */    char *! _XawTextGetText(ctx, left, right)  TextWidget ctx;  XawTextPosition left, right; {    char *result, *tempResult;   XawTextBlock text;  C   tempResult = result = XtMalloc(((Cardinal)(right - left)) + ONE);    while (left < right) {@     left = SrcRead(ctx->text.source, left, &text, right - left);     if (!text.length)  	break; 6     (void) strncpy(tempResult, text.ptr, text.length);     tempResult += text.length;   }    *tempResult = '\0';    return(result);  }   C /* like _XawTextGetText, but enforces ICCCM STRING type encoding */    char *# _XawTextGetSTRING(ctx, left, right)  TextWidget ctx;  XawTextPosition left, right; {    register unsigned char *s;   register unsigned char c;    register long i, j, n;  9   s = (unsigned char *)_XawTextGetText(ctx, left, right); B   /* only HT and NL control chars are allowed, strip out others */   n = strlen((char *)s);   i = 0;   for (j = 0; j < n; j++) { 
     c = s[j]; %     if (((c >= 0x20) && c <= 0x7f) || - 	(c >= 0xa0) || (c == '\t') || (c == '\n')) {        s[i] = c; 
       i++;     }    }    s[i] = 0;    return (char *)s;  }    /*  L  * This routine maps an x and y position in a window that is displaying text1  * into the corresponding position in the source.   *O  * NOTE: it is illegal to call this routine unless there is a valid line table!   */   ' /*** figure out what line it is on ***/    static XawTextPosition PositionForXY (ctx, x, y)  TextWidget ctx; 
 Position x,y;  { !   int fromx, line, width, height;    XawTextPosition position;   (   if (ctx->text.lt.lines == 0) return 0;   9   for (line = 0; line < ctx->text.lt.lines - 1; line++) { +     if (y <= ctx->text.lt.info[line + 1].y)        break;   } .   position = ctx->text.lt.info[line].position;$   if (position >= ctx->text.lastPos)     return(ctx->text.lastPos);'   fromx = (int) ctx->text.margin.left;  F   XawTextSinkFindPosition( ctx->text.sink, position, fromx, x - fromx,( 			  FALSE, &position, &width, &height);7   if (position >= ctx->text.lt.info[line + 1].position) N     position = SrcScan(ctx->text.source, ctx->text.lt.info[line + 1].position,- 		       XawstPositions, XawsdLeft, 1, TRUE); A   if (position > ctx->text.lastPos) position = ctx->text.lastPos;    return(position);  }    /*J  * This routine maps a source position in to the corresponding line number/  * of the text that is displayed in the window.   *O  * NOTE: It is illegal to call this routine unless there is a valid line table!   */    static int   LineForPosition (ctx, position)$ TextWidget ctx;. XawTextPosition position;  {v   int line;    3   for (line = 0; line < ctx->text.lt.lines; line++)*8     if (position < ctx->text.lt.info[line + 1].position)       break;   return(line);n }h   /*I  * This routine maps a source position into the corresponding line number H  * and the x, y coordinates of the text that is displayed in the window.  *O  * NOTE: It is illegal to call this routine unless there is a valid line table!r  */r   static Boolean+ LineAndXYForPosition (ctx, pos, line, x, y)l TextWidget ctx;  XawTextPosition pos;
 int *line; Position *x, *y; {p"   XawTextPosition linePos, endPos;   Boolean visible;   int realW, realH;b     *line = 0;   *x = ctx->text.margin.left;    *y = ctx->text.margin.top;.   if (visible = IsPositionVisible(ctx, pos)) {&     *line = LineForPosition(ctx, pos);$     *y = ctx->text.lt.info[*line].y;     *x = ctx->text.margin.left;T0     linePos = ctx->text.lt.info[*line].position;5     XawTextSinkFindDistance( ctx->text.sink, linePos,G) 			    *x, pos, &realW, &endPos, &realH);O     *x += realW;   }P   return(visible); }    /*D  * This routine builds a line table. It does this by starting at theJ  * specified position and measuring text to determine the staring positionD  * of each line to be displayed. It also determines and saves in theG  * linetable all the required metrics for displaying a given line (e.g.>*  * x offset, y offset, line length, etc.).  */i   void 15 _XawTextBuildLineTable (ctx, position, force_rebuild)< TextWidget ctx;s$ XawTextPosition position;	/* top. */ Boolean force_rebuild; {    Dimension height = 0;.   int lines = 0; a   Cardinal size;  .   if ((int)ctx->core.height > VMargins(ctx)) {.     height = ctx->core.height - VMargins(ctx);8     lines = XawTextSinkMaxLines(ctx->text.sink, height);   }k5   size = sizeof(XawTextLineTableEntry) * (lines + 1);w  G   if ( (lines != ctx->text.lt.lines) || (ctx->text.lt.info == NULL) ) {rO     ctx->text.lt.info = (XawTextLineTableEntry *) XtRealloc((char *) ctx->text.t 							    lt.info, size);     ctx->text.lt.lines = lines;v     force_rebuild = TRUE;t   }t  :   if ( force_rebuild || (position != ctx->text.lt.top) ) {,     bzero((char *) ctx->text.lt.info, size);N     (void) _BuildLineTable(ctx, ctx->text.lt.top = position, zeroPosition, 0);   }m }    /*9  * This assumes that the line table does not change size.*  */    static XawTextPosition- _BuildLineTable(ctx, position, min_pos, line)L TextWidget ctx;(# XawTextPosition position, min_pos;	t	 int line;[ {m8   XawTextLineTableEntry * lt = ctx->text.lt.info + line;   XawTextPosition endPos;r
   Position y;i!   int count, width, realW, realH;u    Widget src = ctx->text.source;  3   if ( ((ctx->text.resize == XawtextResizeWidth) ||(0 	(ctx->text.resize == XawtextResizeBoth)    ) ||-        (ctx->text.wrap == XawtextWrapNever) )d     width = BIGNUM;n   else Y@     width = Max(0, ((int)ctx->core.width - (int)HMargins(ctx)));  5   y = ( (line == 0) ? ctx->text.margin.top : lt->y );t     while ( TRUE ) {     lt->y = y;     lt->position = position;     M     XawTextSinkFindPosition( ctx->text.sink, position, ctx->text.margin.left,*0 			    width, ctx->text.wrap == XawtextWrapWord,  			    &endPos, &realW, &realH);     lt->textWidth = realW;     y += realH;t  ,     if (ctx->text.wrap == XawtextWrapNever) E       endPos = SrcScan(src, position, XawstEOL, XawsdRight, 1, TRUE);   F     if ( endPos == ctx->text.lastPos) { /* We have reached the end. */J       if(SrcScan(src, position, XawstEOL, XawsdRight, 1, FALSE) == endPos) 	break;X     }l  	     ++lt;i     ++line;a'     if ( (line > ctx->text.lt.lines) ||iC 	 ((lt->position == (position = endPos)) && (position > min_pos)) )        return(position);    }s   /*I  * If we are at the end of the buffer put two special lines in the table.X  *>  * a) Both have position > text.lastPos and lt->textWidth = 0.C  * b) The first has a real height, and the second has a height thate   *    is the rest of the screen.  *H  * I counld fill in the rest of the table with valid heights and a largeG  * lastPos, but this method keeps the number of fill regions down to a }  * minimum.p  *G  * One valid endty is needed at the end of the table so that the cursor(.  * does not jump off the bottom of the window.  */e  (   for ( count = 0; count < 2 ; count++) M     if (line++ < ctx->text.lt.lines) { /* make sure not to run of the end. */ 6       (++lt)->y = (count == 0) ? y : ctx->core.height;       lt->textWidth = 0;-       lt->position = ctx->text.lastPos + 100;N     }r  ?   if (line < ctx->text.lt.lines) /* Clear out rest of table. */r     bzero( (char *) (lt + 1), A 	  (ctx->text.lt.lines - line) * sizeof(XawTextLineTableEntry) );t  @   ctx->text.lt.info[ctx->text.lt.lines].position = lt->position;     return(endPos);  }M   /*	Function Name: GetWidestLinenE  *	Description: Returns the width (in pixels) of the widest line that *  *                   is currently visable.$  *	Arguments: ctx - the text widget.)  *	Returns: the width of the widest line.n  *3  * NOTE: This function requires a valid line table.u  */X   static Dimension GetWidestLine(ctx) TextWidget ctx;I {d   int i;   Dimension widest;t+   XawTextLineTablePtr lt = &(ctx->text.lt);o  /   for (i = 0, widest = 1 ; i < lt->lines ; i++)a'     if (widest < lt->info[i].textWidth)l%       widest = lt->info[i].textWidth;,      return(widest);e }r   static voido CheckVBarScrolling(ctx)R TextWidget ctx;f {w   float first, last;*   Boolean temp = (ctx->text.vbar == NULL);  :   if (ctx->text.scroll_vert == XawtextScrollNever) return;  =   if ( (ctx->text.lastPos > 0) && (ctx->text.lt.lines > 0)) {s     first = ctx->text.lt.top;P'     first /= (float) ctx->text.lastPos; :     last = ctx->text.lt.info[ctx->text.lt.lines].position;M     if ( ctx->text.lt.info[ctx->text.lt.lines].position < ctx->text.lastPos )z(       last /= (float) ctx->text.lastPos;	     else f       last = 1.0;t  ;     if (ctx->text.scroll_vert == XawtextScrollWhenNeeded) {t       int line;l       XawTextPosition last_pos;e?       Position y = ctx->core.height - ctx->text.margin.bottom;	l  !       if (ctx->text.hbar != NULL),$ 	y -= (ctx->text.hbar->core.height +. 	      2 * ctx->text.hbar->core.border_width);  C       last_pos = PositionForXY(ctx, (Position) ctx->core.width, y); ,       line = LineForPosition(ctx, last_pos);  J       if ( (y < ctx->text.lt.info[line + 1].y) || ((last - first) < 1.0) ) 	CreateVScrollBar(ctx);V       else e 	DestroyVScrollBar(ctx);     }l         if (ctx->text.vbar != NULL) @       XawScrollbarSetThumb(ctx->text.vbar, first, last - first);   ,     if ( (ctx->text.vbar == NULL) != temp) {B       _XawTextNeedsUpdating(ctx, zeroPosition, ctx->text.lastPos);!       if (ctx->text.vbar == NULL) 3 	_XawTextBuildLineTable (ctx, zeroPosition, FALSE);      }r   }S"   else if (ctx->text.vbar != NULL)9     if (ctx->text.scroll_vert == XawtextScrollWhenNeeded)h       DestroyVScrollBar(ctx); :     else if (ctx->text.scroll_vert == XawtextScrollAlways)5       XawScrollbarSetThumb(ctx->text.vbar, 0.0, 1.0);c }    /*H  * This routine is used by Text to notify an associated scrollbar of theM  * correct metrics (position and shown fraction) for the text being currentlyN  * displayed in the window.x  */l   void e _XawTextSetScrollBars(ctx) TextWidget ctx;r {M   float first, last, widest;*   Boolean temp = (ctx->text.hbar == NULL);+   Boolean vtemp = (ctx->text.vbar == NULL);       CheckVBarScrolling(ctx);  ;   if (ctx->text.scroll_horiz == XawtextScrollNever) return;V     if (ctx->text.vbar != NULL) A     widest = (int)(ctx->core.width - ctx->text.vbar->core.width -l( 		   ctx->text.vbar->core.border_width);   else     widest = ctx->core.width;e(   widest /= (last = GetWidestLine(ctx));9   if (ctx->text.scroll_horiz == XawtextScrollWhenNeeded)       if (widest < 1.0)!       CreateHScrollBar(ctx);     else       DestroyHScrollBar(ctx);   +   if ( (ctx->text.hbar == NULL) != temp ) {L9     _XawTextBuildLineTable (ctx, ctx->text.lt.top, TRUE);rH     CheckVBarScrolling(ctx);	/* Recheck need for vbar, now that we added 				   or removed the hbar.*/r   }n      if (ctx->text.hbar != NULL) {=<     first = ctx->text.r_margin.left - ctx->text.margin.left;     first /= last;9     XawScrollbarSetThumb(ctx->text.hbar, first, widest);     }o  <   if (((ctx->text.hbar == NULL) && (ctx->text.margin.left !=# 				   ctx->text.r_margin.left)) ||a(       (ctx->text.vbar == NULL) != vtemp)   {t4     ctx->text.margin.left = ctx->text.r_margin.left;F     _XawTextNeedsUpdating(ctx, zeroPosition, ctx->text.lastPos);           FlushUpdate(ctx);m   }  }V   /*G  * The routine will scroll the displayed text by lines.  If the arg  is K  * positive, move up; otherwise, move down. [note: this is really a private .  * procedure but is used in multiple modules].  */e   void _XawTextVScroll(ctx, n)) TextWidget ctx;v	 int n;			r {r   XawTextPosition top, target;   int y;*   XawTextLineTable * lt = &(ctx->text.lt);  #   if (abs(n) > ctx->text.lt.lines)  ;     n = (n > 0) ? ctx->text.lt.lines : -ctx->text.lt.lines;t     if (n == 0) return;Q     if (n > 0) {     if ( IsValidLine(ctx, n) )9       top = Min(lt->info[n].position, ctx->text.lastPos);a     else       top = ctx->text.lastPos;  ?     y = IsValidLine(ctx, n) ? lt->info[n].y : ctx->core.height;z,     _XawTextBuildLineTable(ctx, top, FALSE);!     if (top >= ctx->text.lastPos) '       DisplayTextWindow( (Widget) ctx);r
     else {K       XCopyArea(XtDisplay(ctx), XtWindow(ctx), XtWindow(ctx), ctx->text.gc,t8 		0, y, (int)ctx->core.width, (int)ctx->core.height - y, 		0, ctx->text.margin.top);a  &       PushCopyQueue(ctx, 0, (int) -y);$       SinkClearToBG(ctx->text.sink,  		    (Position) 0,1? 		    (Position) (ctx->text.margin.top + ctx->core.height - y),_@ 		   (Dimension) ctx->core.width, (Dimension) ctx->core.height);  ?       if (n < lt->lines) n++; /* update descenders at bottom */;C       _XawTextNeedsUpdating(ctx, lt->info[lt->lines - n].position, T 			    ctx->text.lastPos);!       _XawTextSetScrollBars(ctx);S     }n   }    else {     XawTextPosition updateTo;_&     unsigned int height, clear_height;       n = -n;t     target = lt->top;x5     top = SrcScan(ctx->text.source, target, XawstEOL,T 		  XawsdLeft, n+1, FALSE);;  ,     _XawTextBuildLineTable(ctx, top, FALSE);?     y = IsValidLine(ctx, n) ? lt->info[n].y : ctx->core.height;rN     updateTo = IsValidLine(ctx, n) ? lt->info[n].position : ctx->text.lastPos;(     if (IsValidLine(ctx, lt->lines - n))>       height = lt->info[lt->lines-n].y - ctx->text.margin.top;.     else if (ctx->core.height - HMargins(ctx))0       height = ctx->core.height - HMargins(ctx);     else       height = 0;r'     if (y > (int) ctx->text.margin.top) .       clear_height = y - ctx->text.margin.top;     else       clear_height = 0;        if ( updateTo == target ) { L       XCopyArea(XtDisplay(ctx), XtWindow(ctx), XtWindow(ctx), ctx->text.gc, @ 		0, ctx->text.margin.top, (int) ctx->core.width, height, 0, y);%       PushCopyQueue(ctx, 0, (int) y);hG       SinkClearToBG(ctx->text.sink, (Position) 0, ctx->text.margin.top, < 		   (Dimension) ctx->core.width, (Dimension) clear_height);       A       _XawTextNeedsUpdating(ctx, lt->info[0].position, updateTo);a!       _XawTextSetScrollBars(ctx);g     }      else if (lt->top != target) %       DisplayTextWindow((Widget)ctx);i   }o }i   /*ARGSUSED*/ static void  HScroll(w, closure, callData)d	 Widget w;t$ XtPointer closure;		/* TextWidget */" XtPointer callData;		/* #pixels */ { (   TextWidget ctx = (TextWidget) closure;   Widget tw = (Widget) ctx;=7   Position old_left, pixels = (Position)(int) callData;t   XRectangle rect, t_rect;      _XawTextPrepareToUpdate(ctx);t  #   old_left = ctx->text.margin.left;t"   ctx->text.margin.left -= pixels;8   if (ctx->text.margin.left > ctx->text.r_margin.left) {4     ctx->text.margin.left = ctx->text.r_margin.left;.     pixels = old_left - ctx->text.margin.left;   }r      if (pixels > 0) {tB     rect.width = (unsigned short) pixels + ctx->text.margin.right;:     rect.x = (short) ctx->core.width - (short) rect.width;*     rect.y = (short) ctx->text.margin.top;=     rect.height = (unsigned short) ctx->core.height - rect.y;   F     XCopyArea(XtDisplay(tw), XtWindow(tw), XtWindow(tw), ctx->text.gc, 	      pixels, (int) rect.y,> 	      (unsigned int) rect.x, (unsigned int) ctx->core.height, 	      0, (int) rect.y);  )     PushCopyQueue(ctx, (int) -pixels, 0);    }y   else if (pixels < 0) {     rect.x = 0;e       if (ctx->text.vbar != NULL)z5       rect.x += (short) (ctx->text.vbar->core.width +F' 			 ctx->text.vbar->core.border_width);r  %     rect.width = (Position) - pixels;*"     rect.y = ctx->text.margin.top;,     rect.height = ctx->core.height - rect.y;  F     XCopyArea(XtDisplay(tw), XtWindow(tw), XtWindow(tw), ctx->text.gc," 	      (int) rect.x, (int) rect.y,3 	      (unsigned int) ctx->core.width - rect.width, " 	      (unsigned int) rect.height,0 	      (int) rect.x + rect.width, (int) rect.y);  ,     PushCopyQueue(ctx, (int) rect.width, 0);   /*"  * Redraw the line overflow marks.  */c  8     t_rect.x = ctx->core.width - ctx->text.margin.right;*     t_rect.width = ctx->text.margin.right;     t_rect.y = rect.y;      t_rect.height = rect.height;       K     SinkClearToBG(ctx->text.sink, (Position) t_rect.x, (Position) t_rect.y, 9 		  (Dimension) t_rect.width, (Dimension) t_rect.height);e     (     UpdateTextInRectangle(ctx, &t_rect);   }a   /*  ,  * Put in the text that just became visible.  */r     if ( pixels != 0 ) {G     SinkClearToBG(ctx->text.sink, (Position) rect.x, (Position) rect.y,,5 		  (Dimension) rect.width, (Dimension) rect.height);.     &     UpdateTextInRectangle(ctx, &rect);   }t   _XawTextExecuteUpdate(ctx);r   _XawTextSetScrollBars(ctx);L }    /*ARGSUSED*/ static void  HJump(w, closure, callData)x	 Widget w;tL XtPointer closure, callData; /* closure = TextWidget, callData = percent. */ {o(   TextWidget ctx = (TextWidget) closure;'   float * percent = (float *) callData; <   Position move, new_left, old_left = ctx->text.margin.left;  %   new_left = ctx->text.r_margin.left;c9   new_left -= (Position) (*percent * GetWidestLine(ctx));    move = old_left - new_left;x  )   if (abs(move) < (int)ctx->core.width) {-2     HScroll(w, (XtPointer) ctx, (XtPointer) move);     return;g   }t   _XawTextPrepareToUpdate(ctx); #   ctx->text.margin.left = new_left;tC   if (XtIsRealized((Widget) ctx)) DisplayTextWindow((Widget) ctx); e   _XawTextExecuteUpdate(ctx);b };  " /*	Function Name: UpdateTextInLine2  *	Description: Updates some text in a given line.$  *	Arguments: ctx - the text widget.K  *                 line - the line number (in the line table) of this line.iD  *                 left, right - left and right pixel offsets of the0  *                               area to update.  *	Returns: none.x  */t   static voido( UpdateTextInLine(ctx, line, left, right) TextWidget ctx;z	 int line;S Position left, right;x {.   XawTextPosition pos1, pos2; -   int width, height, local_left, local_width;e8   XawTextLineTableEntry * lt = ctx->text.lt.info + line;  ?   if ( ((int)(lt->textWidth + ctx->text.margin.left) < left) ||.*        ( ctx->text.margin.left > right ) )&     return;			/* no need to update. */  -   local_width = left - ctx->text.margin.left;x7   XawTextSinkFindPosition(ctx->text.sink, lt->position,o" 			  (int) ctx->text.margin.left, 1 			  local_width, FALSE, &pos1, &width, &height);-  A   if (right >= (Position) lt->textWidth - ctx->text.margin.left) C(     if ( (IsValidLine(ctx, line + 1)) &&? 	 (ctx->text.lt.info[line + 1].position <= ctx->text.lastPos) )uL       pos2 = SrcScan( ctx->text.source, (lt + 1)->position, XawstPositions,  			   XawsdLeft, 1, TRUE);	     else x       pos2 = GETLASTPOS;   else {     XawTextPosition t_pos;  /     local_left = ctx->text.margin.left + width; &     local_width = right  - local_left;=     XawTextSinkFindPosition(ctx->text.sink, pos1, local_left,T3 			    local_width, FALSE, &pos2, &width, &height);t     ,     t_pos = SrcScan( ctx->text.source, pos2,, 		     XawstPositions, XawsdRight, 1, TRUE);#     if (t_pos < (lt + 1)->position)x       pos2 = t_pos;    }i  )   _XawTextNeedsUpdating(ctx, pos1, pos2);c }>   /*L  * The routine will scroll the displayed text by pixels.  If the calldata is+  * positive, move up; otherwise, move down.   */    /*ARGSUSED*/ static void  VScroll(w, closure, callData) 	 Widget w;t$ XtPointer closure;		/* TextWidget */" XtPointer callData;		/* #pixels */ {_'   TextWidget ctx = (TextWidget)closure;e%   int height, lines = (int) callData;o  ,   height = ctx->core.height - VMargins(ctx);   if (height < 1)W     height = 1; <   lines = (int) (lines * (int) ctx->text.lt.lines) / height;   _XawTextPrepareToUpdate(ctx);g   _XawTextVScroll(ctx, lines);   _XawTextExecuteUpdate(ctx);l }g   /*I  * The routine "thumbs" the displayed text. Thumbing means reposition the J  * displayed view of the source to a new position determined by a fractionJ  * of the way from beginning to end. Ideally, this should be determined byK  * the number of displayable lines in the source. This routine does it as a\J  * fraction of the first position and last position and then normalizes to1  * the start of the line containing the position.b  *E  * BUG/deficiency: The normalize to line portion of this routine will @  * cause thumbing to always position to the start of the source.  */    /*ARGSUSED*/ static void  VJump(w, closure, callData)s	 Widget w;rL XtPointer closure, callData; /* closuer = TextWidget, callData = percent. */ {i'   float * percent = (float *) callData;r'   TextWidget ctx = (TextWidget)closure;x-   XawTextPosition position, old_top, old_bot;)*   XawTextLineTable * lt = &(ctx->text.lt);     _XawTextPrepareToUpdate(ctx);u   old_top = lt->top;=   if ( (lt->lines > 0) && (IsValidLine(ctx, lt->lines - 1)) )u/     old_bot = lt->info[lt->lines - 1].position;b   else      old_bot = ctx->text.lastPos;  ;   position = (long) (*percent * (float) ctx->text.lastPos);/O   position= SrcScan(ctx->text.source, position, XawstEOL, XawsdLeft, 1, FALSE); 9   if ( (position >= old_top) && (position <= old_bot) ) {X     int line = 0;(O     for (;(line < lt->lines) && (position > lt->info[line].position) ; line++);r     _XawTextVScroll(ctx, line);i   }	   else {     XawTextPosition new_bot;1     _XawTextBuildLineTable(ctx, position, FALSE);/M     new_bot = IsValidLine(ctx, lt->lines-1) ? lt->info[lt->lines-1].position  @                                             : ctx->text.lastPos;  7     if ((old_top >= lt->top) && (old_top <= new_bot)) {i       int line = 0;xO       for (;(line < lt->lines) && (old_top > lt->info[line].position); line++);s2       _XawTextBuildLineTable(ctx, old_top, FALSE);"       _XawTextVScroll(ctx, -line);     }t	     else c'       DisplayTextWindow( (Widget) ctx);d   }r   _XawTextExecuteUpdate(ctx);x }    static Boolean MatchSelection(selection, s) Atom		    selection; XawTextSelection    *s;  {_     Atom    *match;y     int	    count;  S     for (count = 0, match = s->selections; count < s->atom_count; match++, count++), 	if (*match == selection)p 	    return True;      return False;A }T   static Boolean rC ConvertSelection(w, selection, target, type, value, length, format) 	 Widget w;E  Atom *selection, *target, *type; XtPointer *value;A unsigned long *length; int *format; {E   Display* d = XtDisplay(w);!   TextWidget ctx = (TextWidget)w;*    Widget src = ctx->text.source;   XawTextEditType edit_mode;   Arg args[1];$   XawTextSelectionSalt	*salt = NULL;   XawTextSelection  *s;   !   if (*target == XA_TARGETS(d)) {y!     Atom* targetP, * std_targets;h     unsigned long std_length;e  J     if ( SrcCvtSel(src, selection, target, type, value, length, format) ) 
 	return True;   >     XmuConvertStandardSelection(w, ctx->text.time, selection, ) 				target, type, (caddr_t*)&std_targets,( 				&std_length, format);u     @     *value = XtMalloc((unsigned) sizeof(Atom)*(std_length + 7));     targetP = *(Atom**)value;e     *length = std_length + 6;t     *targetP++ = XA_STRING;-     *targetP++ = XA_TEXT(d);%     *targetP++ = XA_COMPOUND_TEXT(d);[     *targetP++ = XA_LENGTH(d);#     *targetP++ = XA_LIST_LENGTH(d);i*     *targetP++ = XA_CHARACTER_POSITION(d);  .     XtSetArg(args[0], XtNeditType,&edit_mode);      XtGetValues(src, args, ONE);  #     if (edit_mode == XawtextEdit) {s        *targetP++ = XA_DELETE(d);       (*length)++;     }uG     bcopy((char*)std_targets, (char*)targetP, sizeof(Atom)*std_length);u     XtFree((char*)std_targets);d     *type = XA_ATOM;     *format = 32;c     return True;   }e   G   if ( SrcCvtSel(src, selection, target, type, value, length, format) )x     return True;  0   if (MatchSelection (*selection, &ctx->text.s))     s = &ctx->text.s;m   else   {>8     for (salt = ctx->text.salt; salt; salt = salt->next)+ 	if (MatchSelection (*selection, &salt->s)). 	    break;      if (!salt) 	return False;     s = &salt->s;e   }    if (*target == XA_STRING ||t       *target == XA_TEXT(d) ||'       *target == XA_COMPOUND_TEXT(d)) { '     if (*target == XA_COMPOUND_TEXT(d))e       *type = *target;     else       *type = XA_STRING;     if (!salt)     {*4 	*value = _XawTextGetSTRING(ctx, s->left, s->right); 	*length = strlen(*value);     }      else     {*& 	*value = XtMalloc (salt->length + 1);! 	strcpy (*value, salt->contents);> 	*length = salt->length;     }      *format = 8;     return True;   }1  F   if ( (*target == XA_LIST_LENGTH(d)) || (*target == XA_LENGTH(d)) ) {     long * temp;     +     temp = (long *) XtMalloc(sizeof(long)); %     if (*target == XA_LIST_LENGTH(d))y       *temp = 1L;i(     else			/* *target == XA_LENGTH(d) */*       *temp = (long) (s->right - s->left);          *value = (caddr_t) temp;     *type = XA_INTEGER;o     *length = 1L;      *format = 32;m     return True;   }k  ,   if (*target == XA_CHARACTER_POSITION(d)) {     long * temp;     /     temp = (long *) XtMalloc(2 * sizeof(long));e#     temp[0] = (long) (s->left + 1);h     temp[1] = s->right;.     *value = (caddr_t) temp;     *type = XA_SPAN(d);.     *length = 2L;      *format = 32;e     return True;   }m      if (*target == XA_DELETE(d)) {8     void _XawTextZapSelection(); /* From TextAction.c */          if (!salt)3 	_XawTextZapSelection( ctx, (XEvent *) NULL, TRUE);g     *value = NULL;     *type = XA_NULL(d);      *length = 0;     *format = 32;r     return True;   }e  M   if (XmuConvertStandardSelection(w, ctx->text.time, selection, target, type, ( 				  (caddr_t *)value, length, format))     return True;      /* else */   return False;  }   % /*	Function Name: GetCutBuffferNumber 5  *	Description: Returns the number of the cut buffer.='  *	Arguments: atom - the atom to check. B  *	Returns: the number of the cut buffer representing this atom or"  *               NOT_A_CUT_BUFFER.  */a   #define NOT_A_CUT_BUFFER -1d  
 static int GetCutBufferNumber(atom) register Atom atom;n { (   if (atom == XA_CUT_BUFFER0) return(0);(   if (atom == XA_CUT_BUFFER1) return(1);(   if (atom == XA_CUT_BUFFER2) return(2);(   if (atom == XA_CUT_BUFFER3) return(3);(   if (atom == XA_CUT_BUFFER4) return(4);(   if (atom == XA_CUT_BUFFER5) return(5);(   if (atom == XA_CUT_BUFFER6) return(6);(   if (atom == XA_CUT_BUFFER7) return(7);   return(NOT_A_CUT_BUFFER);n }    static void  LoseSelection(w, selection) 	 Widget w;= Atom *selection; {n"   TextWidget ctx = (TextWidget) w;   register Atom* atomP;o   register int i; 3   XawTextSelectionSalt	*salt, *prevSalt, *nextSalt;e     _XawTextPrepareToUpdate(ctx);t  !   atomP = ctx->text.s.selections;P8   for (i = 0 ; i < ctx->text.s.atom_count; i++, atomP++)#     if ( (*selection == *atomP) ||  H 	(GetCutBufferNumber(*atomP) != NOT_A_CUT_BUFFER) )/* is a cut buffer */       *atomP = (Atom)0;c  "   while (ctx->text.s.atom_count &&8 	 ctx->text.s.selections[ctx->text.s.atom_count-1] == 0)     ctx->text.s.atom_count--;i   /*F  * Must walk the selection list in opposite order from UnsetSelection.  */u  !   atomP = ctx->text.s.selections;l8   for (i = 0 ; i < ctx->text.s.atom_count; i++, atomP++)     if (*atomP == (Atom)0) {@       *atomP = ctx->text.s.selections[--ctx->text.s.atom_count];&       while (ctx->text.s.atom_count &&< 	     ctx->text.s.selections[ctx->text.s.atom_count-1] == 0) 	ctx->text.s.atom_count--;     }n   "   if (ctx->text.s.atom_count == 0)C     ModifySelection(ctx, ctx->text.insertPos, ctx->text.insertPos);e       :   if (ctx->text.old_insert >= 0) /* Update in progress. */     _XawTextExecuteUpdate(ctx);*       prevSalt = 0;a6     for (salt = ctx->text.salt; salt; salt = nextSalt)     {I      	atomP = salt->s.selections; 	nextSalt = salt->next;i7     	for (i = 0 ; i < salt->s.atom_count; i++, atomP++)( 	    if (*selection == *atomP) 		*atomP = (Atom)0;t     	;!     	while (salt->s.atom_count && 6 	       salt->s.selections[salt->s.atom_count-1] == 0) 	{ 	    salt->s.atom_count--; 	}     	=     	/*tK     	 * Must walk the selection list in opposite order from UnsetSelection.l     	 */     	       	atomP = salt->s.selections;7     	for (i = 0 ; i < salt->s.atom_count; i++, atomP++)e     	    if (*atomP == (Atom)0)t  	    {t?       	      *atomP = salt->s.selections[--salt->s.atom_count];n)       	      while (salt->s.atom_count &&o: 	     	     salt->s.selections[salt->s.atom_count-1] == 0)     	    	salt->s.atom_count--;l
     	    } 	if (salt->s.atom_count == 0)  	{* 	    XtFree ((char *) salt->s.selections); 	    XtFree (salt->contents);o 	    if (prevSalt) 		prevSalt->next = nextSalt;	 	    elset 		ctx->text.salt = nextSalt; 	    XtFree ((char *) salt); 	} 	elsee 	    prevSalt = salt;f     }n }e   void6 _XawTextSaltAwaySelection (ctx, selections, num_atoms) TextWidget ctx;d Atom	*selections;s int	num_atoms; {o"     XawTextSelectionSalt    *salt;     int			    i, j;o  #     for (i = 0; i < num_atoms; i++)a. 	LoseSelection ((Widget) ctx, selections + i);     if (num_atoms == 0)t 	return;M     salt = (XawTextSelectionSalt *) XtMalloc (sizeof (XawTextSelectionSalt));g     if (!salt) 	return;G     salt->s.selections = (Atom *) XtMalloc (num_atoms * sizeof (Atom));.     if (!salt->s.selections)     {  	XtFree ((char *) salt); 	return;     }a$     salt->s.left = ctx->text.s.left;&     salt->s.right = ctx->text.s.right;$     salt->s.type = ctx->text.s.type;Q     salt->contents = _XawTextGetSTRING(ctx, ctx->text.s.left, ctx->text.s.right);{+     salt->length = strlen (salt->contents);;      salt->next = ctx->text.salt;     ctx->text.salt = salt;
     j = 0;#     for (i = 0; i < num_atoms; i++)e     {t< 	if (GetCutBufferNumber (selections[i]) == NOT_A_CUT_BUFFER) 	{- 	    salt->s.selections[j++] = selections[i];eA 	    XtOwnSelection ((Widget) ctx, selections[i], ctx->text.time,e. 			    ConvertSelection, LoseSelection, NULL); 	}     }l     salt->s.atom_count = j;s }    static void 2 _SetSelection(ctx, left, right, selections, count) TextWidget ctx;  XawTextPosition left, right; Atom *selections;) Cardinal count;. {i   XawTextPosition pos;       if (left < ctx->text.s.left) {'     pos = Min(right, ctx->text.s.left); *     _XawTextNeedsUpdating(ctx, left, pos);   }h    if (left > ctx->text.s.left) {'     pos = Min(left, ctx->text.s.right);-6     _XawTextNeedsUpdating(ctx, ctx->text.s.left, pos);   }n"   if (right < ctx->text.s.right) {'     pos = Max(right, ctx->text.s.left);x7     _XawTextNeedsUpdating(ctx, pos, ctx->text.s.right);t   }a"   if (right > ctx->text.s.right) {'     pos = Max(left, ctx->text.s.right);=+     _XawTextNeedsUpdating(ctx, pos, right);W   }v      ctx->text.s.left = left;   ctx->text.s.right = right;  0   SrcSetSelection(ctx->text.source, left, right,) 		  (count == 0) ? None : selections[0]);      if (left < right) {      Widget w = (Widget) ctx;     int buffer;e          while (count) { +       Atom selection = selections[--count];i /*  * If this is a cut buffer.s  */   I       if ((buffer = GetCutBufferNumber(selection)) != NOT_A_CUT_BUFFER) {  	unsigned char *ptr, *tptr;e: 	unsigned int amount, max_len = MAX_CUT_LEN(XtDisplay(w)); 	unsigned long len;.  G 	tptr= ptr= (unsigned char *) _XawTextGetSTRING(ctx, ctx->text.s.left, s  						       ctx->text.s.right); 	if (buffer == 0) {e# 	  _CreateCutBuffers(XtDisplay(w));o# 	  XRotateBuffers(XtDisplay(w), 1);l 	}6 	amount = Min ( (len = strlen((char *)ptr)), max_len);G 	XChangeProperty(XtDisplay(w), RootWindow(XtDisplay(w), 0), selection,  / 			XA_STRING, 8, PropModeReplace, ptr, amount);    	while (len > max_len) { 	    len -= max_len; 	    tptr += max_len;;! 	    amount = Min (len, max_len);e@ 	    XChangeProperty(XtDisplay(w), RootWindow(XtDisplay(w), 0), 0 			    selection, XA_STRING, 8, PropModeAppend,  			    tptr, amount);  	} 	XtFree ((char *)ptr);       }+,       else			/* This is a real selection. */- 	XtOwnSelection(w, selection, ctx->text.time,(0 		       ConvertSelection, LoseSelection, NULL);     }z   }a   else'     XawTextUnsetSelection((Widget)ctx);t }t   /*K  * This internal routine deletes the text from pos1 to pos2 in a source andeG  * then inserts, at pos1, the text that was passed. As a side effect itd=  * "invalidates" that portion of the displayed text (if any).A  *O  * NOTE: It is illegal to call this routine unless there is a valid line table!N  */T   int ' _XawTextReplace (ctx, pos1, pos2, text)  TextWidget ctx;n XawTextPosition pos1, pos2;g XawTextBlock *text;; {    int i, line1, delta, error;n'   XawTextPosition updateFrom, updateTo;     Widget src = ctx->text.source;   XawTextEditType edit_mode;   Arg args[1];   J   ctx->text.update_disabled = True; /* No redisplay during replacement. */   /*J  * The insertPos may not always be set to the right spot in XawtextAppend   */a  -   XtSetArg(args[0], XtNeditType, &edit_mode);t   XtGetValues(src, args, ONE);  F   if ((pos1 == ctx->text.insertPos) && (edit_mode == XawtextAppend)) {,     ctx->text.insertPos = ctx->text.lastPos;H     pos2 = SrcScan(src, ctx->text.insertPos, XawstPositions, XawsdRight,) 		   (ctx->text.insertPos - pos1), TRUE);.     pos1 = ctx->text.insertPos; 2     if ( (pos1 == pos2) && (text->length == 0) ) {?       ctx->text.update_disabled = FALSE; /* rearm redisplay. */.       return( XawEditError );n     }    }   G   updateFrom = SrcScan(src, pos1, XawstWhiteSpace, XawsdLeft, 1, TRUE);oL   updateFrom = SrcScan(src, updateFrom, XawstPositions, XawsdLeft, 1, TRUE);1   updateFrom = Max(updateFrom, ctx->text.lt.top);x  +   line1 = LineForPosition(ctx, updateFrom);p:   if ( (error = SrcReplace(src, pos1, pos2, text)) != 0) {=     ctx->text.update_disabled = FALSE; /* rearm redisplay. */t     return(error);   }.  %   XawTextUnsetSelection((Widget)ctx);c  !   ctx->text.lastPos = GETLASTPOS;y.   if (ctx->text.lt.top >= ctx->text.lastPos) {:     _XawTextBuildLineTable(ctx, ctx->text.lastPos, FALSE);     ClearWindow( (Widget) ctx);(=     ctx->text.update_disabled = FALSE; /* rearm redisplay. */n'     return(0);			/* Things are fine. */    }   B   ctx->text.single_char = (text->length <= 1 && pos2 - pos1 <= 1);  '   delta = text->length - (pos2 - pos1);>  "   if (delta < ctx->text.lastPos) {>     for (pos2 += delta, i = 0; i < ctx->text.numranges; i++) {)       if (ctx->text.updateFrom[i] > pos1)t" 	ctx->text.updateFrom[i] += delta;(       if (ctx->text.updateTo[i] >= pos1)  	ctx->text.updateTo[i] += delta;     }T   }o      /* a:    * fixup all current line table entries to reflect edit.7    * %%% it is not legal to do arithmetic on positions.y%    * using Scan would be more proper.w    */    if (delta != 0) {i!     XawTextLineTableEntry *lineP;,'     i = LineForPosition(ctx, pos1) + 1;rN     for (lineP = ctx->text.lt.info + i; i <= ctx->text.lt.lines; i++, lineP++)       lineP->position += delta;l   }z      /*>    * Now process the line table and fixup in case edits causedC    * changes in line breaks. If we are breaking on word boundaries,x9    * this code checks for moving words to and from lines.>    */d   +   if (IsPositionVisible(ctx, updateFrom)) { $     updateTo = _BuildLineTable(ctx, : 			       ctx->text.lt.info[line1].position, pos1, line1);5     _XawTextNeedsUpdating(ctx, updateFrom, updateTo);    }f  ;   ctx->text.update_disabled = FALSE; /* rearm redisplay. */T%   return(0);			/* Things are fine. */  }h   /*I  * This routine will display text between two arbitrary source positions.oL  * In the event that this span contains highlighted text for the selection, 3  * only that portion will be displayed highlighted.s  *8  * NOTE: it is illegal to call this routine unless there   *       is a valid line table!   */r   static void  DisplayText(w, pos1, pos2)	 Widget w;t XawTextPosition pos1, pos2;c {>!   TextWidget ctx = (TextWidget)w;    Position x, y;3   int height, line, i, lastPos = ctx->text.lastPos;U#   XawTextPosition startPos, endPos;l#   Boolean clear_eol, done_painting;m  =   pos1 = (pos1 < ctx->text.lt.top) ? ctx->text.lt.top : pos1;y%   pos2 = FindGoodPosition(ctx, pos2);mJ   if ( (pos1 >= pos2) || !LineAndXYForPosition(ctx, pos1, &line, &x, &y) )6     return;			/* line not visible, or pos1 >= pos2. */  :   for ( startPos = pos1, i = line; IsValidLine(ctx, i) && D                                    (i < ctx->text.lt.lines) ; i++) {       @     if ( (endPos = ctx->text.lt.info[i + 1].position) > pos2 ) {/       clear_eol = ((endPos = pos2) >= lastPos);0<       done_painting = (!clear_eol || ctx->text.single_char);     }o
     else {       clear_eol = TRUE;x       done_painting = FALSE;     }t  A     height = ctx->text.lt.info[i + 1].y - ctx->text.lt.info[i].y;-        if ( (endPos > startPos) ) {?       if ( (x == (Position) ctx->text.margin.left) && (x > 0) )   	 SinkClearToBG (ctx->text.sink, 			(Position) 0, y, : 			(Dimension) ctx->text.margin.left, (Dimension)height);   M       if ( (startPos >= ctx->text.s.right) || (endPos <= ctx->text.s.left) ) eG 	XawTextSinkDisplayText(ctx->text.sink, x, y, startPos, endPos, FALSE);aO       else if ((startPos >= ctx->text.s.left) && (endPos <= ctx->text.s.right))tF 	XawTextSinkDisplayText(ctx->text.sink, x, y, startPos, endPos, TRUE);       else {, 	DisplayText(w, startPos, ctx->text.s.left);0 	DisplayText(w, Max(startPos, ctx->text.s.left),& 		    Min(endPos, ctx->text.s.right));+ 	DisplayText(w, ctx->text.s.right, endPos);        }e     }B     startPos = endPos;     if (clear_eol) { 	SinkClearToBG(ctx->text.sink, d4 		      (Position) (ctx->text.lt.info[i].textWidth + 				  ctx->text.margin.left),(9 		      (Position) y, w->core.width, (Dimension) height);A   	/* = 	 * We only get here if single character is true, and we needL@ 	 * to clear to the end of the screen.  We know that since there7 	 * was only on character deleted that this is the samet; 	 * as clearing an extra line, so we do this, and are done.= 	 * B 	 * This a performance hack, and a pretty gross one, but it works. 	 *  	 * Chris Peterson 11/13/89. 	 */   	if (done_painting) {c 	    y += height; # 	    SinkClearToBG(ctx->text.sink, -5 			  (Position) ctx->text.margin.left, (Position) y, m( 			  w->core.width, (Dimension) height);  7 	    break;		/* set single_char to FALSE and return. */t 	}     })  )     x = (Position) ctx->text.margin.left; #     y = ctx->text.lt.info[i + 1].y;x     if ( done_painting? 	 || (y >= (int)(ctx->core.height - ctx->text.margin.bottom)) )(       break;   }s    ctx->text.single_char = FALSE; }    /*G  * This routine implements multi-click selection in a hardwired manner.tL  * It supports multi-click entity cycling (char, word, line, file) and mouseK  * motion adjustment of the selected entitie (i.e. select a word then, with(M  * button still down, adjust wich word you really meant by moving the mouse).lD  * [NOTE: This routine is to be replaced by a set of procedures thatE  * will allows clients to implements a wide class of draw through and *  * multi-click selection user interfaces.]  */p   static void $ DoSelection (ctx, pos, time, motion) TextWidget ctx;X XawTextPosition pos;
 Time time; Boolean motion;e {m$   XawTextPosition newLeft, newRight;%   XawTextSelectType newType, *sarray;     Widget src = ctx->text.source;  
   if (motion)l     newType = ctx->text.s.type;    else {M     if ( (abs((long) time - (long) ctx->text.lasttime) < MULTI_CLICK_TIME) &&d> 	 ((pos >= ctx->text.s.left) && (pos <= ctx->text.s.right))) {        sarray = ctx->text.sarray;O       for (;*sarray != XawselectNull && *sarray != ctx->text.s.type; sarray++);u  #       if (*sarray == XawselectNull)y 	newType = *(ctx->text.sarray);,       else { 	newType = *(sarray + 1);, 	if (newType == XawselectNull)  ! 	  newType = *(ctx->text.sarray);e       }x     } :     else 			                      /* single-click event */$       newType = *(ctx->text.sarray);       ctx->text.lasttime = time;   }f   switch (newType) {   case XawselectPosition:      newLeft = newRight = pos;F
     break;   case XawselectChar:      newLeft = pos;G     newRight = SrcScan(src, pos, XawstPositions, XawsdRight, 1, FALSE);t
     break;   case XawselectWord:    case XawselectParagraph: w     {n       XawTextScanType stype;  #       if (newType == XawselectWord).          stype = XawstWhiteSpace;
       else 	stype = XawstParagraph;         /*F        * Somewhat complicated, but basically I treat the space betweenG        * two objects as another object.  The object that I am currentlyk2        * in then becomes the end of the selection.	        * i"        * Chris Peterson - 4/19/90.	        */;  M       newRight = SrcScan(ctx->text.source, pos, stype, XawsdRight, 1, FALSE);TM       newRight =SrcScan(ctx->text.source, newRight,stype,XawsdLeft,1, FALSE);          if (pos != newRight) tF 	newLeft = SrcScan(ctx->text.source, pos, stype, XawsdLeft, 1, FALSE);
       else 	newLeft = pos;t  M       newLeft =SrcScan(ctx->text.source, newLeft, stype, XawsdRight,1,FALSE);k         if (newLeft > newRight) {t" 	  XawTextPosition temp = newLeft; 	  newLeft = newRight; 	  newRight = temp;t       }l     }&
     break;   case XawselectLine: ?     newLeft = SrcScan(src, pos, XawstEOL, XawsdLeft, 1, FALSE);tA     newRight = SrcScan(src, pos, XawstEOL, XawsdRight, 1, FALSE);r
     break;   case XawselectAll: t?     newLeft = SrcScan(src, pos, XawstAll, XawsdLeft, 1, FALSE);sA     newRight = SrcScan(src, pos, XawstAll, XawsdRight, 1, FALSE);w
     break;
   default:<     XtAppWarning(XtWidgetToApplicationContext((Widget) ctx),/ 	       "Text Widget: empty selection array.");c     return;e   }d  G   if ( (newLeft != ctx->text.s.left) || (newRight != ctx->text.s.right)l)       || (newType != ctx->text.s.type)) { ,     ModifySelection(ctx, newLeft, newRight);9     if (pos - ctx->text.s.left < ctx->text.s.right - pos)z$       ctx->text.insertPos = newLeft;	     else ;%       ctx->text.insertPos = newRight;      ctx->text.s.type = newType;i   }*D   if (!motion) { /* setup so we can freely mix select extend calls*/.     ctx->text.origSel.type = ctx->text.s.type;.     ctx->text.origSel.left = ctx->text.s.left;0     ctx->text.origSel.right = ctx->text.s.right;  O     if (pos >= ctx->text.s.left + ((ctx->text.s.right - ctx->text.s.left) / 2))o'       ctx->text.extendDir = XawsdRight;i     else&       ctx->text.extendDir = XawsdLeft;   }S }o   /*F  * This routine implements extension of the currently selected text inD  * the "current" mode (i.e. char word, line, etc.). It worries aboutK  * extending from either end of the selection and handles the case when you)I  * cross through the "center" of the current selection (e.g. switch whicht  * end you are extending!). C  * [NOTE: This routine will be replaced by a set of procedures that.E  * will allows clients to implements a wide class of draw through andd*  * multi-click selection user interfaces.] */   static void " ExtendSelection (ctx, pos, motion) TextWidget ctx;( XawTextPosition pos; Boolean motion;> {t   XawTextScanDirection dir;=  5   if (!motion) {		/* setup for extending selection */oJ     if (ctx->text.s.left == ctx->text.s.right) /* no current selection. */D       ctx->text.s.left = ctx->text.s.right = ctx->text.insertPos;   
     else {0       ctx->text.origSel.left = ctx->text.s.left;2       ctx->text.origSel.right = ctx->text.s.right;     }(       .     ctx->text.origSel.type = ctx->text.s.type;  O     if (pos >= ctx->text.s.left + ((ctx->text.s.right - ctx->text.s.left) / 2))," 	ctx->text.extendDir = XawsdRight;     else! 	ctx->text.extendDir = XawsdLeft;n   } 1   else /* check for change in extend direction */(O     if ((ctx->text.extendDir == XawsdRight && pos <= ctx->text.origSel.left) ||xH 	(ctx->text.extendDir == XawsdLeft && pos >= ctx->text.origSel.right)) {A       ctx->text.extendDir = (ctx->text.extendDir == XawsdRight) ?iD 	                                            XawsdLeft : XawsdRight;L       ModifySelection(ctx, ctx->text.origSel.left, ctx->text.origSel.right);     }t     dir = ctx->text.extendDir;   switch (ctx->text.s.type) {    case XawselectWord:    case XawselectParagraph:     {**       XawTextPosition left_pos, right_pos;       XawTextScanType stype;  ,       if (ctx->text.s.type == XawselectWord)          stype = XawstWhiteSpace;
       else 	stype = XawstParagraph;         /*F        * Somewhat complicated, but basically I treat the space betweenG        * two objects as another object.  The object that I am currentlyo2        * in then becomes the end of the selection.	        *  "        * Chris Peterson - 4/19/90.	        */   N       right_pos = SrcScan(ctx->text.source, pos, stype, XawsdRight, 1, FALSE);O       right_pos =SrcScan(ctx->text.source, right_pos,stype,XawsdLeft,1, FALSE);r         if (pos != right_pos) G 	left_pos = SrcScan(ctx->text.source, pos, stype, XawsdLeft, 1, FALSE);R
       else 	left_pos = pos;  O       left_pos =SrcScan(ctx->text.source, left_pos, stype, XawsdRight,1,FALSE);i         if (dir == XawsdLeft)i  	pos = Min(left_pos, right_pos);"       else /* dir == XawsdRight */  	pos = Max(left_pos, right_pos);     }n
     break;   case XawselectLine:TN     pos = SrcScan(ctx->text.source, pos, XawstEOL, dir, 1, dir == XawsdRight);
     break;   case XawselectAll: I     pos = ctx->text.insertPos;-   case XawselectPosition:	/* fall through. */i
   default:
     break;   }t      if (dir == XawsdRight)0     ModifySelection(ctx, ctx->text.s.left, pos);   else1     ModifySelection(ctx, pos, ctx->text.s.right);      ctx->text.insertPos = pos; }i   /*(  * Clear the window to background color.  */n   static void  ClearWindow (w)t	 Widget w;  {s"   TextWidget ctx = (TextWidget) w;     if (XtIsRealized(w))"     SinkClearToBG(ctx->text.sink,   		  (Position) 0, (Position) 0, # 		  w->core.width, w->core.height);A })  / /*	Function Name: _XawTextClearAndCenterDisplaytC  *	Description: Redraws the display with the cursor in insert point )  *                   centered vertically.t$  *	Arguments: ctx - the text widget.  *	Returns: none.e  */x   void" _XawTextClearAndCenterDisplay(ctx) TextWidget ctx;. {i>   int insert_line = LineForPosition(ctx, ctx->text.insertPos);5   int scroll_by = insert_line - ctx->text.lt.lines/2;l  "   _XawTextVScroll(ctx, scroll_by);#   DisplayTextWindow( (Widget) ctx);t }t    /*$  * Internal redisplay entire window.,  * Legal to call only if widget is realized.  */    static void  DisplayTextWindow (w)n	 Widget w;; { "   TextWidget ctx = (TextWidget) w;   ClearWindow(w);t7   _XawTextBuildLineTable(ctx, ctx->text.lt.top, FALSE); >   _XawTextNeedsUpdating(ctx, zeroPosition, ctx->text.lastPos);   _XawTextSetScrollBars(ctx);t }e   /*G  * This routine checks to see if the window should be resized (grown or <  * shrunk) when text to be painted overflows to the right orF  * the bottom of the window. It is used by the keyboard input routine.  */c   void _XawTextCheckResize(ctx) TextWidget ctx;  {r   Widget w = (Widget) ctx;   int line = 0, old_height;x%   XtWidgetGeometry rbox, return_geom;_  2   if ( (ctx->text.resize == XawtextResizeWidth) ||2        (ctx->text.resize == XawtextResizeBoth) ) {     XawTextLineTableEntry *lt;     rbox.width = 0; !     for (lt = ctx->text.lt.info; t8 	 IsValidLine(ctx, line) && (line < ctx->text.lt.lines); 	 line++, lt++) {sI       if ((int)(lt->textWidth + ctx->text.margin.left) > (int)rbox.width)g6 	  rbox.width = lt->textWidth + ctx->text.margin.left;     }l     )     rbox.width += ctx->text.margin.right;P=     if (rbox.width > ctx->core.width) { /* Only get wider. */="       rbox.request_mode = CWWidth;L       if (XtMakeGeometryRequest(w, &rbox, &return_geom) == XtGeometryAlmost)5 	(void) XtMakeGeometryRequest(w, &return_geom, NULL);T     }i   }e  5   if ( !((ctx->text.resize == XawtextResizeHeight) || , 	 (ctx->text.resize == XawtextResizeBoth)) )
       return;*  0   if (IsPositionVisible(ctx, ctx->text.lastPos))3     line = LineForPosition(ctx, ctx->text.lastPos);(   else     line = ctx->text.lt.lines;   1   if ( (line + 1) == ctx->text.lt.lines ) return;f       old_height = ctx->core.height;   rbox.request_mode = CWHeight; O   rbox.height = XawTextSinkMaxHeight(ctx->text.sink, line + 1) + VMargins(ctx);>   K   if ((int)rbox.height < old_height) return; /* It will only get taller. */   H   if (XtMakeGeometryRequest(w, &rbox, &return_geom) == XtGeometryAlmost)F     if (XtMakeGeometryRequest(w, &return_geom, NULL) != XtGeometryYes)
       return;    6   _XawTextBuildLineTable(ctx, ctx->text.lt.top, TRUE); }    /*@  * Converts (params, num_params) to a list of atoms & caches the#  * list in the TextWidget instance.l  */    Atom*a( _XawTextSelectionList(ctx, list, nelems) TextWidget ctx;=
 String *list;; Cardinal nelems; { &   Atom * sel = ctx->text.s.selections;)   Display *dpy = XtDisplay((Widget) ctx);*   int n;  (   if (nelems > ctx->text.s.array_size) {B     sel = (Atom *) XtRealloc((char *) sel, sizeof(Atom) * nelems);$     ctx->text.s.array_size = nelems;!     ctx->text.s.selections = sel;a   }s)   for (n=nelems; --n >= 0; sel++, list++)L*     *sel = XInternAtom(dpy, *list, False);"   ctx->text.s.atom_count = nelems;    return ctx->text.s.selections; }    /*	Function Name: SetSelection+  *	Description: Sets the current selection. $  *	Arguments: ctx - the text widget.6  *                 defaultSel - the default selection.C  *                 l, r - the left and right ends of the selection.)B  *                 list, nelems - the selection list (as strings).  *	Returns: none._  *G  *  NOTE: if (ctx->text.s.left >= ctx->text.s.right) then the selection   *        is unset.   */f   void- _XawTextSetSelection(ctx, l, r, list, nelems)t TextWidget ctx;x XawTextPosition l, r; 
 String *list;a Cardinal nelems; {x/   if (nelems == 1 && !strcmp (list[0], "none"))      return;N   if (nelems == 0) {"     String defaultSel = "PRIMARY";     list = &defaultSel;C     nelems = 1;e   }(M   _SetSelection(ctx, l, r, _XawTextSelectionList(ctx, list, nelems), nelems);o }t    ! /*	Function Name: ModifySelection /  *	Description: Modifies the current selection.u$  *	Arguments: ctx - the text widget.J  *                 left, right - the left and right ends of the selection.  *	Returns: none.r  *G  *  NOTE: if (ctx->text.s.left >= ctx->text.s.right) then the selectionE  *        is unset.O  */U   static void ! ModifySelection(ctx, left, right)) TextWidget ctx;t XawTextPosition left, right; {F   if (left == right) (     ctx->text.insertPos = left;;/   _SetSelection( ctx, left, right, NULL, ZERO);( }m   /*K  * This routine is used to perform various selection functions. The goal ismG  * to be able to specify all the more popular forms of draw-through and :  * multi-click selection user interfaces from the outside.  */E   void  > _XawTextAlterSelection (ctx, mode, action, params, num_params) TextWidget ctx; E XawTextSelectionMode mode;   /* {XawsmTextSelect, XawsmTextExtend} */i3 XawTextSelectionAction action; /* {XawactionStart, t' 				  XawactionAdjust, XawactionEnd} */t String	*params;- Cardinal	*num_params;  {    XawTextPosition position;_   Boolean flag;+   /*K  * This flag is used by TextPop.c:DoReplace() to determine if the selection_.  * is okay to use, or if it has been modified.  */0        if (ctx->text.search != NULL)&/     ctx->text.search->selection_changed = TRUE;-  M   position = PositionForXY (ctx, (int) ctx->text.ev_x, (int) ctx->text.ev_y);n  $   flag = (action != XawactionStart);   if (mode == XawsmTextSelect)6     DoSelection (ctx, position, ctx->text.time, flag);&   else			/* mode == XawsmTextExtend */)    ExtendSelection (ctx, position, flag);t     if (action == XawactionEnd) B     _XawTextSetSelection(ctx, ctx->text.s.left, ctx->text.s.right, 			 params, *num_params);x }e  # /*	Function Name: RectanglesOverlapt7  *	Description: Returns TRUE if two rectangles overlap.>9  *	Arguments: rect1, rect2 - the two rectangles to check.t.  *	Returns: TRUE iff these rectangles overlap.  */X   static Boolean RectanglesOverlap(rect1, rect2)  XRectangle *rect1, *rect2; {a:   return ( (rect1->x < rect2->x + (short) rect2->width) &&3 	   (rect2->x < rect1->x + (short) rect1->width) &&a4 	   (rect1->y < rect2->y + (short) rect2->height) &&4 	   (rect2->y < rect1->y + (short) rect1->height) ); }t  ( /*	Function Name: UpdateTextInRectangle.0  *	Description: Updates the text in a rectangle.$  *	Arguments: ctx - the text widget.2  *                 rect - the rectangle to update.  *	Returns: none.n  */    static void   UpdateTextInRectangle(ctx, rect) TextWidget ctx;  XRectangle * rect; { 2   XawTextLineTableEntry *info = ctx->text.lt.info;%   int line, x = rect->x, y = rect->y;e9   int right = rect->width + x, bottom = rect->height + y;>  0   for (line = 0;( (line < ctx->text.lt.lines) &&A 		 IsValidLine(ctx, line) && (info->y < bottom)); line++, info++)      if ( (info + 1)->y >= y ) ,       UpdateTextInLine(ctx, line, x, right); };   /*J  * This routine processes all "expose region" XEvents. In general, its jobG  * is to the best job at minimal re-paint of the text, displayed in the   * window, that it can.   */t   /* ARGSUSED */ static voidt% ProcessExposeRegion(w, event, region)_	 Widget w;t XEvent *event; Region region;			/* Unused. */ {o$     TextWidget ctx = (TextWidget) w;     XRectangle expose, cursor;     Boolean need_to_draw;a           if (event->type == Expose) { 	expose.x = event->xexpose.x;0 	expose.y = event->xexpose.y;x% 	expose.width = event->xexpose.width;T' 	expose.height = event->xexpose.height;t     } -     else if (event->type == GraphicsExpose) {t% 	expose.x = event->xgraphicsexpose.x;s% 	expose.y = event->xgraphicsexpose.y; - 	expose.width = event->xgraphicsexpose.width;x/ 	expose.height = event->xgraphicsexpose.height;i     }      t     else { /* No Expose */ 	PopCopyQueue(ctx);		_. 	return;			/* no more processing necessary. */     }h  7     need_to_draw = TranslateExposeRegion(ctx, &expose);tO     if ((event->type == GraphicsExpose) && (event->xgraphicsexpose.count == 0))  	PopCopyQueue(ctx);	       if (!need_to_draw) m0 	return;			/* don't draw if we don't need to. */  !     _XawTextPrepareToUpdate(ctx);[(     UpdateTextInRectangle(ctx, &expose);8     XawTextSinkGetCursorBounds(ctx->text.sink, &cursor);.     if (RectanglesOverlap(&cursor, &expose)) {H 	SinkClearToBG(ctx->text.sink, (Position) cursor.x, (Position) cursor.y,= 		      (Dimension) cursor.width, (Dimension) cursor.height);t% 	UpdateTextInRectangle(ctx, &cursor);      }x     _XawTextExecuteUpdate(ctx);c }>   /*L  * This routine does all setup required to syncronize batched screen updates  */l   _XawTextPrepareToUpdate(ctx) TextWidget ctx;{ { !   if (ctx->text.old_insert < 0) {)(     InsertCursor((Widget)ctx, XawisOff);     ctx->text.numranges = 0;#     ctx->text.showposition = FALSE; /     ctx->text.old_insert = ctx->text.insertPos;d   }t }(   /*F  * This is a private utility routine used by _XawTextExecuteUpdate. ItB  * processes all the outstanding update requests and merges update  * ranges where possible.   */t   static = void FlushUpdate(ctx)i TextWidget ctx;  {S   int i, w;t'   XawTextPosition updateFrom, updateTo;=#   if (!XtIsRealized((Widget)ctx)) {f     ctx->text.numranges = 0;     return;    } #   while (ctx->text.numranges > 0) {u)     updateFrom = ctx->text.updateFrom[0];-
     w = 0;1     for (i = 1 ; i < ctx->text.numranges ; i++) {b1       if (ctx->text.updateFrom[i] < updateFrom) {_& 	updateFrom = ctx->text.updateFrom[i]; 	w = i;e       }u     }_%     updateTo = ctx->text.updateTo[w];g     ctx->text.numranges--;H     ctx->text.updateFrom[w] = ctx->text.updateFrom[ctx->text.numranges];D     ctx->text.updateTo[w] = ctx->text.updateTo[ctx->text.numranges];6     for (i = ctx->text.numranges - 1 ; i >= 0 ; i--) {N       while (ctx->text.updateFrom[i] <= updateTo && i < ctx->text.numranges) {" 	updateTo = ctx->text.updateTo[i]; 	ctx->text.numranges--;GE 	ctx->text.updateFrom[i] = ctx->text.updateFrom[ctx->text.numranges];lA 	ctx->text.updateTo[i] = ctx->text.updateTo[ctx->text.numranges];_       }      }n3     DisplayText((Widget)ctx, updateFrom, updateTo);    }  }s   /*H  * This is a private utility routine used by _XawTextExecuteUpdate. ThisO  * routine worries about edits causing new data or the insertion point becomingtH  * invisible (off the screen, or under the horiz. scrollbar). Currently >  * it always makes it visible by scrolling. It probably needs (  * generalization to allow more options.  */d   _XawTextShowPosition(ctx)p TextWidget ctx;n {    int x, y, lines, number;   Boolean no_scroll;&   XawTextPosition max_pos, top, first;  B   if ( (!XtIsRealized((Widget)ctx)) || (ctx->text.lt.lines <= 0) )     return;t   /*A  * Find out the bottom the visable window, and make sure that thee3  * cursor does not go past the end of this space.  T  *C  * This makes sure that the cursor does not go past the end of the ,  * visable window. s  */      x = ctx->core.width;1   y = ctx->core.height - ctx->text.margin.bottom;d   if (ctx->text.hbar != NULL) M     y -= ctx->text.hbar->core.height + 2 * ctx->text.hbar->core.border_width;    &   max_pos = PositionForXY (ctx, x, y);K   lines = LineForPosition(ctx, max_pos) + 1; /* number of visable lines. */t   3   if ( (ctx->text.insertPos >= ctx->text.lt.top) &&='        (ctx->text.insertPos < max_pos))w     return;{     first = ctx->text.lt.top;-   no_scroll = FALSE;  B   if (ctx->text.insertPos < first) { /* We need to scroll down. */:       top = SrcScan(ctx->text.source, ctx->text.insertPos,% 		    XawstEOL, XawsdLeft, 1, FALSE);   7       /* count the number of lines we have to scroll */          number = 0;i       while (first > top) {E+ 	  first = SrcScan(ctx->text.source, first,S# 			  XawstEOL, XawsdLeft, 1, TRUE);w   	  if ( - number > lines ) m
 	      break;    	  number--;       }s  :       if (first <= top) {	/* If we found the proper number 				   of lines. */e      e, 	  /* Back up to just before the last CR. */       + 	  first = SrcScan(ctx->text.source, first,-* 			  XawstPositions, XawsdRight, 1, TRUE); 	  .2 	  /* Check to make sure the cursor is visable. */ 	  ( 	  if (first <= top) 	      number++; 	  S 	  lines = number;       }p
       else 	  no_scroll = TRUE;   }u%   else {			/* We need to Scroll up */L:       top = SrcScan(ctx->text.source, ctx->text.insertPos,) 		    XawstEOL, XawsdLeft, lines, FALSE);          if (top < max_pos) e% 	  lines = LineForPosition(ctx, top);c       else l 	  no_scroll = TRUE;   }=     if (no_scroll) {4       _XawTextBuildLineTable(ctx, top, FALSE);      %       DisplayTextWindow((Widget)ctx);    }<   else t"       _XawTextVScroll(ctx, lines);     _XawTextSetScrollBars(ctx);> }t   /*A  * This routine causes all batched screen updates to be performed>  */u   void _XawTextExecuteUpdate(ctx) TextWidget ctx;f {pA   if ( ctx->text.update_disabled || (ctx->text.old_insert < 0) ) t     return;a  O   if((ctx->text.old_insert != ctx->text.insertPos) || (ctx->text.showposition))t     _XawTextShowPosition(ctx);   FlushUpdate(ctx); %   InsertCursor((Widget)ctx, XawisOn);    ctx->text.old_insert = -1; }i     static void  TextDestroy(w)	 Widget w;  {i!   TextWidget ctx = (TextWidget)w;      DestroyHScrollBar(ctx);n   DestroyVScrollBar(ctx);d  )   XtFree((char *)ctx->text.s.selections);e$   XtFree((char *)ctx->text.lt.info);#   XtFree((char *)ctx->text.search);t'   XtFree((char *)ctx->text.updateFrom);o%   XtFree((char *)ctx->text.updateTo);  }a   /*>  * by the time we are managed (and get this far) we had better!  * have both a source and a sink d  */t   static voidF	 Resize(w)T	 Widget w;  { "   TextWidget ctx = (TextWidget) w;     PositionVScrollBar(ctx);   PositionHScrollBar(ctx);  6   _XawTextBuildLineTable(ctx, ctx->text.lt.top, TRUE);   _XawTextSetScrollBars(ctx);o }*   /*@  * This routine allow the application program to Set attributes.  */*   /*ARGSUSED*/ static Boolean y0 SetValues(current, request, new, args, num_args) Widget current, request, new;*
 ArgList args;i Cardinal *num_args;  {t*   TextWidget oldtw = (TextWidget) current;&   TextWidget newtw = (TextWidget) new;   Boolean    redisplay = FALSE;w7   Boolean    display_caret = newtw->text.display_caret;x    8   newtw->text.display_caret = oldtw->text.display_caret;!   _XawTextPrepareToUpdate(newtw); ,   newtw->text.display_caret = display_caret;  ?   if (oldtw->text.r_margin.left != newtw->text.r_margin.left) {18     newtw->text.margin.left = newtw->text.r_margin.left;!     if (newtw->text.vbar != NULL)i?       newtw->text.margin.left += newtw->text.vbar->core.width +V> 	                         newtw->text.vbar->core.border_width;     redisplay = TRUE;)   }    ;   if (oldtw->text.scroll_vert != newtw->text.scroll_vert) {27     if (newtw->text.scroll_vert == XawtextScrollNever)         DestroyVScrollBar(newtw);|<     else if (newtw->text.scroll_vert == XawtextScrollAlways)       CreateVScrollBar(newtw);     redisplay = TRUE;e   }=  C   if (oldtw->text.r_margin.bottom != newtw->text.r_margin.bottom) {P<     newtw->text.margin.bottom = newtw->text.r_margin.bottom;!     if (newtw->text.hbar != NULL)TB       newtw->text.margin.bottom += newtw->text.hbar->core.height +@ 	                           newtw->text.hbar->core.border_width;     redisplay = TRUE;o   }c   =   if (oldtw->text.scroll_horiz != newtw->text.scroll_horiz) { 8     if (newtw->text.scroll_horiz == XawtextScrollNever)        DestroyHScrollBar(newtw);-=     else if (newtw->text.scroll_horiz == XawtextScrollAlways)        CreateHScrollBar(newtw);     redisplay = TRUE;    }P  1   if ( oldtw->text.source != newtw->text.source ) N     XawTextSetSource( (Widget) newtw, newtw->text.source, newtw->text.lt.top);  '   newtw->text.redisplay_needed = False; =   XtSetValues( (Widget)newtw->text.source, args, *num_args );x;   XtSetValues( (Widget)newtw->text.sink, args, *num_args );W  .   if ( oldtw->text.wrap != newtw->text.wrap ||2        oldtw->text.lt.top != newtw->text.lt.top ||B        oldtw->text.r_margin.right != newtw->text.r_margin.right ||>        oldtw->text.r_margin.top != newtw->text.r_margin.top ||.        oldtw->text.sink != newtw->text.sink ||%        newtw->text.redisplay_needed )l   {s<     _XawTextBuildLineTable(newtw, newtw->text.lt.top, TRUE);     redisplay = TRUE;n   }t  7   if (oldtw->text.insertPos != newtw->text.insertPos) { $     newtw->text.showposition = TRUE;     redisplay = TRUE;x   }t     _XawTextExecuteUpdate(newtw);.   if (redisplay)!     _XawTextSetScrollBars(newtw);m     return redisplay;  }e  . /* invoked by the Simple widget's SetValues */! static Boolean ChangeSensitive(w)x"     Widget w;	/* the new widget */ {.     Arg args[1];#     TextWidget tw = (TextWidget) w;(  ;     (*(&simpleClassRec)->simple_class.change_sensitive)(w);a  ,     XtSetArg(args[0], XtNancestorSensitive, = 	       (tw->core.ancestor_sensitive && tw->core.sensitive));d     if (tw->text.vbar)' 	XtSetValues(tw->text.vbar, args, ONE);w     if (tw->text.hbar)' 	XtSetValues(tw->text.hbar, args, ONE);e     return False;  }o   /*	Function Name: GetValuesHookn?  *	Description: This is a get values hook routine that gets theO8  *                   values in the text source and sink."  *	Arguments: w - the Text Widget.,  *                 args - the argument list.1  *                 num_args - the number of args.t  *	Returns: none.o  */x   static voidt  GetValuesHook(w, args, num_args)	 Widget w; 
 ArgList args;l Cardinal * num_args; {x@   XtGetValues( ((TextWidget) w)->text.source, args, *num_args );>   XtGetValues( ((TextWidget) w)->text.sink, args, *num_args ); }   " /*	Function Name: FindGoodPosition<  *	Description: Returns a valid position given any postition!  *	Arguments: pos - any position.l/  *	Returns: a position between (0 and lastPos);r  */c   static XawTextPosition FindGoodPosition(ctx, pos) TextWidget ctx;x XawTextPosition pos; {u   if (pos < 0) return(0);wC   return ( ((pos > ctx->text.lastPos) ? ctx->text.lastPos : pos) );e }*  = /************************************************************c  * e4  * Routines for handling the copy area expose queue.  *>  ************************************************************/   /*	Function Name: PushCopyQueuet3  *	Description: Pushes a value onto the copy queue.i$  *	Arguments: ctx - the text widget.L  *                 h, v - amount of offset in the horiz and vert directions.  *	Returns: none  */i   static void, PushCopyQueue(ctx, h, v) TextWidget ctx;o	 int h, v;e {w9     struct text_move * offsets = XtNew(struct text_move);        offsets->h = h;w     offsets->v = v;      offsets->next = NULL;   ,     if (ctx->text.copy_area_offsets == NULL)' 	ctx->text.copy_area_offsets = offsets;l
     else {6 	struct text_move * end = ctx->text.copy_area_offsets;/ 	for ( ; end->next != NULL; end = end->next) {}h 	end->next = offsets;h     }t }.   /*	Function Name: PopCopyQueue9  *	Description: Pops the top value off of the copy queue.>$  *	Arguments: ctx - the text widget.  *	Returns: none.e  */t   static voidt PopCopyQueue(ctx)t TextWidget ctx;1 {A=     struct text_move * offsets = ctx->text.copy_area_offsets;>       if (offsets == NULL) 	printf("empty copy queue\n");
     else {- 	ctx->text.copy_area_offsets = offsets->next;,8 	XtFree((char *) offsets);	/* free what you allocate. */     }R }t  ( /*	Function Name:  TranslateExposeRegion4  *	Description: Translates the expose that came intoF  *                   the cordinates that now exist in the Text widget.$  *	Arguments: ctx - the text widget.?  *                 expose - a Rectangle, who's region currentlyr?  *                          contains the expose event location.pC  *                          this region will be returned containing,.  *                          the new rectangle.;  *	Returns: True if there is drawing that needs to be done.d  */c   static Boolean" TranslateExposeRegion(ctx, expose) TextWidget ctx;  XRectangle * expose; {c=     struct text_move * offsets = ctx->text.copy_area_offsets;(     int value;     int x, y, width, height;       /*I      * Skip over the first one, this has already been taken into account.-      */   /     if (!offsets || !(offsets = offsets->next))  	return(TRUE);       x = expose->x;     y = expose->y;     width = expose->width;     height = expose->height;       while (offsets) {s 	x += offsets->h;r 	y += offsets->v;e 	offsets = offsets->next;r     }e       /*E      * remove that area of the region that is now outside the window.f      */c       if (y < 0) {
 	height += y;h 	y = 0;t     }e  *     value = y + height - ctx->core.height;     if (value > 0) 	height -= value;d       if (height <= 0): 	return(FALSE);		/* no need to draw outside the window. */       /*(      * and now in the horiz direction...      */l       if (x < 0) { 	width += x; 	x = 0;f     }h  (     value = x + width - ctx->core.width;     if (value > 0) 	width -= value;       if (width <= 0)c: 	return(FALSE);		/* no need to draw outside the window. */          expose->x = x;     expose->y = y;     expose->width = width;     expose->height = height;     return(TRUE);  }o  D /*******************************************************************I The following routines provide procedural interfaces to Text window state;I setting and getting. They need to be redone so than the args code can use*E them. I suggest we create a complete set that takes the context as anxH argument and then have the public version lookp the context and call theN internal one. The major value of this set is that they have actual applicationK clients and therefore the functionality provided is required for any future  version of Text.E ********************************************************************/    void #if NeedFunctionPrototypes XawTextDisplay (Widget w)t #else= XawTextDisplay (w)	 Widget w;e #endif {r   if (!XtIsRealized(w)) return;h   +   _XawTextPrepareToUpdate( (TextWidget) w);c   DisplayTextWindow(w);s)   _XawTextExecuteUpdate( (TextWidget) w);x }(   void #if NeedFunctionPrototypes= XawTextSetSelectionArray(Widget w, XawTextSelectType *sarray)  #elsee# XawTextSetSelectionArray(w, sarray) 	 Widget w;  XawTextSelectType *sarray; #endif {X(   ((TextWidget)w)->text.sarray = sarray; }e   void #if NeedFunctionPrototypesO XawTextGetSelectionPos(Widget w, XawTextPosition *left, XawTextPosition *right)  #elsew& XawTextGetSelectionPos(w, left, right)	 Widget w;  XawTextPosition *left, *right; #endif { (   *left = ((TextWidget) w)->text.s.left;*   *right = ((TextWidget) w)->text.s.right; }      void e #if NeedFunctionPrototypesC XawTextSetSource(Widget w, Widget source, XawTextPosition startPos)c #elset% XawTextSetSource(w, source, startPos)j Widget w, source;e XawTextPosition startPos;u #endif { "   TextWidget ctx = (TextWidget) w;     ctx->text.source = source;   ctx->text.lt.top = startPos;+   ctx->text.s.left = ctx->text.s.right = 0;x!   ctx->text.insertPos = startPos;,!   ctx->text.lastPos = GETLASTPOS;c   6   _XawTextBuildLineTable(ctx, ctx->text.lt.top, TRUE);   XawTextDisplay(w); }    /*O  * This public routine deletes the text from startPos to endPos in a source and K  * then inserts, at startPos, the text that was passed. As a side effect it,L  * "invalidates" that portion of the displayed text (if any), so that things  * will be repainted properly.  */d   int  #if NeedFunctionPrototypesJ XawTextReplace(Widget w, XawTextPosition startPos, XawTextPosition endPos, 	       XawTextBlock *text)r #elser) XawTextReplace(w, startPos, endPos, text)e	 Widget w; " XawTextPosition  startPos, endPos; XawTextBlock *text;* #endif {g"   TextWidget ctx = (TextWidget) w;
   int result;      _XawTextPrepareToUpdate(ctx);()   endPos = FindGoodPosition(ctx, endPos);o-   startPos = FindGoodPosition(ctx, startPos); O   if ((result = _XawTextReplace(ctx, startPos, endPos, text)) == XawEditDone) { 3     int delta = text->length - (endPos - startPos);s2     if (ctx->text.insertPos >= (endPos + delta)) {E       XawTextScanDirection sd = (delta < 0) ? XawsdLeft : XawsdRight;tJ       ctx->text.insertPos = SrcScan(ctx->text.source, ctx->text.insertPos,. 				    XawstPositions, sd, abs(delta), TRUE);     }    }a     _XawTextCheckResize(ctx);n   _XawTextExecuteUpdate(ctx);e   _XawTextSetScrollBars(ctx);t      return result; }R   XawTextPosition  #if NeedFunctionPrototypes XawTextTopPosition(Widget w) #elsei XawTextTopPosition(w)i	 Widget w;o #endif {>*   return( ((TextWidget) w)->text.lt.top ); }    void x #if NeedFunctionPrototypes< XawTextSetInsertionPoint(Widget w, XawTextPosition position) #else % XawTextSetInsertionPoint(w, position)o	 Widget w;l XawTextPosition position;r #endif {*"   TextWidget ctx = (TextWidget) w;     _XawTextPrepareToUpdate(ctx);t8   ctx->text.insertPos = FindGoodPosition(ctx, position);    ctx->text.showposition = TRUE;     _XawTextExecuteUpdate(ctx);( },   XawTextPosition> #if NeedFunctionPrototypes" XawTextGetInsertionPoint(Widget w) #elsen XawTextGetInsertionPoint(w) 	 Widget w;e #endif {n,   return( ((TextWidget) w)->text.insertPos); }s   /*K  * NOTE: Must walk the selection list in opposite order from LoseSelection.t  */    void o #if NeedFunctionPrototypes XawTextUnsetSelection(Widget w)w #elseg XawTextUnsetSelection(w)	 Widget w;x #endif {t*   register TextWidget ctx = (TextWidget)w;  '   while (ctx->text.s.atom_count != 0) { B     Atom sel = ctx->text.s.selections[ctx->text.s.atom_count - 1];     if ( sel != (Atom) 0 ) { /*8  * As selections are lost the atom_count will decrement.  */ 6       if (GetCutBufferNumber(sel) == NOT_A_CUT_BUFFER)+ 	XtDisownSelection(w, sel, ctx->text.time);fB       LoseSelection(w, &sel); /* In case this is a cut buffer, or , 				 XtDisownSelection failed to call us. */     }.   }n }g   void #if NeedFunctionPrototypesK XawTextSetSelection (Widget w, XawTextPosition left, XawTextPosition right)f #elsee$ XawTextSetSelection (w, left, right)	 Widget w;e XawTextPosition left, right; #endif {("   TextWidget ctx = (TextWidget) w;      _XawTextPrepareToUpdate(ctx);a8   _XawTextSetSelection(ctx, FindGoodPosition(ctx, left),3 		       FindGoodPosition(ctx, right), NULL, ZERO);(   _XawTextExecuteUpdate(ctx);i }=   void o #if NeedFunctionPrototypesE XawTextInvalidate(Widget w, XawTextPosition from, XawTextPosition to)c #elset XawTextInvalidate(w, from, to)	 Widget w;x XawTextPosition from,to; #endif { "   TextWidget ctx = (TextWidget) w;  %   from = FindGoodPosition(ctx, from);V!   to = FindGoodPosition(ctx, to);.!   ctx->text.lastPos = GETLASTPOS;w   _XawTextPrepareToUpdate(ctx);('   _XawTextNeedsUpdating(ctx, from, to);e6   _XawTextBuildLineTable(ctx, ctx->text.lt.top, TRUE);   _XawTextExecuteUpdate(ctx);m }y   /*ARGSUSED*/ void #if NeedFunctionPrototypes! XawTextDisableRedisplay(Widget w)  #else* XawTextDisableRedisplay(w)	 Widget w;t #endif { 0   ((TextWidget) w)->text.update_disabled = True;+   _XawTextPrepareToUpdate( (TextWidget) w);s }n   void e #if NeedFunctionPrototypes  XawTextEnableRedisplay(Widget w) #elsec XawTextEnableRedisplay(w)i	 Widget w;= #endif {(*   register TextWidget ctx = (TextWidget)w;   XawTextPosition lastPos;  )   if (!ctx->text.update_disabled) return;o  $   ctx->text.update_disabled = False;+   lastPos = ctx->text.lastPos = GETLASTPOS;==   ctx->text.lt.top = FindGoodPosition(ctx, ctx->text.lt.top);sC   ctx->text.insertPos = FindGoodPosition(ctx, ctx->text.insertPos);mG   if ( (ctx->text.s.left > lastPos) || (ctx->text.s.right > lastPos) ) n-     ctx->text.s.left = ctx->text.s.right = 0;    6   _XawTextBuildLineTable(ctx, ctx->text.lt.top, TRUE);   if (XtIsRealized(w))     DisplayTextWindow(w);    _XawTextExecuteUpdate(ctx);  }t   Widget #if NeedFunctionPrototypes XawTextGetSource(Widget w) #elses XawTextGetSource(w) 	 Widget w;  #endif {f&   return ((TextWidget)w)->text.source; }e   void #if NeedFunctionPrototypes XawTextDisplayCaret (Widget w, #if NeedWidePrototypes' 		     /* Boolean */ int display_caret)o #else  		     Boolean display_caret)m #endif #elsee& XawTextDisplayCaret (w, display_caret)	 Widget w;n Boolean display_caret; #endif {g"   TextWidget ctx = (TextWidget) w;  7   if (ctx->text.display_caret == display_caret) return;,     if (XtIsRealized(w)) {!     _XawTextPrepareToUpdate(ctx); ,     ctx->text.display_caret = display_caret;     _XawTextExecuteUpdate(ctx);l   }n   else,     ctx->text.display_caret = display_caret; }   . /*	Function Name: XawTextSearch(w, dir, text).2  *	Description: searches for the given text block."  *	Arguments: w - The text widget.2  *                 dir - The direction to search. I  *                 text - The text block containing info about the strings(  *                        to search for.E  *	Returns: The position of the text found, or XawTextSearchError on h  *               an error.  */i   XawTextPositiono #if NeedFunctionPrototypes XawTextSearch(Widget w,* #if NeedWidePrototypes* 	      /* XawTextScanDirection */ int dir, #elsem  	      XawTextScanDirection dir, #endif 	      XawTextBlock *text) #elsee XawTextSearch(w, dir, text) 	 Widget w;m XawTextScanDirection dir;c XawTextBlock * text; #endif { "   TextWidget ctx = (TextWidget) w;  F   return(SrcSearch(ctx->text.source, ctx->text.insertPos, dir, text)); }A    TextClassRec textClassRec = {a   { /* core fields */a>     /* superclass       */      (WidgetClass) &simpleClassRec,'     /* class_name       */      "Text",l0     /* widget_size      */      sizeof(TextRec),0     /* class_initialize */      ClassInitialize,      /* class_part_init  */	NULL,&     /* class_inited     */      FALSE,+     /* initialize       */      Initialize,n      /* initialize_hook  */	NULL,(     /* realize          */      Realize,5     /* actions          */      _XawTextActionsTable, O     /* num_actions      */      0,                /* Set in ClassInitialize. */ *     /* resources        */      resources,4     /* num_ resource    */      XtNumber(resources),*     /* xrm_class        */      NULLQUARK,%     /* compress_motion  */      TRUE,FJ     /* compress_exposure*/      XtExposeGraphicsExpose | XtExposeNoExpose,"     /* compress_enterleave*/	TRUE,&     /* visible_interest */      FALSE,,     /* destroy          */      TextDestroy,'     /* resize           */      Resize,a4     /* expose           */      ProcessExposeRegion,*     /* set_values       */      SetValues,      /* set_values_hook  */	NULL,4     /* set_values_almost*/	XtInheritSetValuesAlmost,)     /* get_values_hook  */	GetValuesHook,>%     /* accept_focus     */      NULL,;%     /* version          */	XtVersion,e%     /* callback_private */      NULL,eE     /* tm_table         */      NULL,    /* set in ClassInitialize */ 2     /* query_geometry   */	XtInheritQueryGeometry,9     /* display_accelerator*/	XtInheritDisplayAccelerator,)     /* extension	*/	NULL   },   { /* Simple fields */T*     /* change_sensitive	*/	ChangeSensitive   },   { /* text fields */y     /* empty            */	0   }b };  9 WidgetClass textWidgetClass = (WidgetClass)&textClassRec;.