B /* $XConsortium: SmeBSB.c,v 1.16 91/03/15 15:59:41 gildea Exp $ */   /*7  * Copyright 1989 Massachusetts Institute of Technology   *N  * Permission to use, copy, modify, distribute, and sell this software and itsM  * documentation for any purpose is hereby granted without fee, provided that E  * the above copyright notice appear in all copies and that both that C  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION J  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   */    /*9  * SmeBSB.c - Source code file for BSB Menu Entry object.   *  * Date:    September 26, 1989  *  * By:      Chris D. Peterson   *          MIT X Consortium     *          kit@expo.lcs.mit.edu  */    #include <X11/IntrinsicP.h>  #include <X11/StringDefs.h>  #include <X11/Xos.h>   #include <X11/Xmu/Drawing.h>   #include <X11/Xaw/XawInit.h> #include <X11/Xaw/SimpleMenu.h>  #include <X11/Xaw/SmeBSBP.h> #include <X11/Xaw/Cardinals.h>   #include <stdio.h>   #define ONE_HUNDRED 100   : #define offset(field) XtOffsetOf(SmeBSBRec, sme_bsb.field)  ! static XtResource resources[] = { 2   {XtNlabel,  XtCLabel, XtRString, sizeof(String),%      offset(label), XtRString, NULL}, 4   {XtNvertSpace,  XtCVertSpace, XtRInt, sizeof(int),7      offset(vert_space), XtRImmediate, (XtPointer) 25}, ;   {XtNleftBitmap, XtCLeftBitmap, XtRBitmap, sizeof(Pixmap), 9      offset(left_bitmap), XtRImmediate, (XtPointer)None}, 9   {XtNjustify, XtCJustify, XtRJustify, sizeof(XtJustify), ?      offset(justify), XtRImmediate, (XtPointer) XtJustifyLeft}, =   {XtNrightBitmap, XtCRightBitmap, XtRBitmap, sizeof(Pixmap), :      offset(right_bitmap), XtRImmediate, (XtPointer)None},I   {XtNleftMargin,  XtCHorizontalMargins, XtRDimension, sizeof(Dimension), 7      offset(left_margin), XtRImmediate, (XtPointer) 4}, J   {XtNrightMargin,  XtCHorizontalMargins, XtRDimension, sizeof(Dimension),8      offset(right_margin), XtRImmediate, (XtPointer) 4},9   {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel), 9      offset(foreground), XtRString, XtDefaultForeground}, ;   {XtNfont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *), -      offset(font), XtRString, XtDefaultFont},  };    
 #undef offset    /*%  * Semi Public function definitions.    */   ? static void Redisplay(), Destroy(), Initialize(), FlipColors();  static void ClassInitialize(); static Boolean SetValues(); ( static XtGeometryResult QueryGeometry();   /*     * Private Function Definitions.  */   = static void GetDefaultSize(), DrawBitmaps(), GetBitmapInfo(); & static void CreateGCs(), DestroyGCs();     ! #define superclass (&smeClassRec) ! SmeBSBClassRec smeBSBClassRec = {    { 9     /* superclass         */    (WidgetClass) superclass, )     /* class_name         */    "SmeBSB", 2     /* size               */    sizeof(SmeBSBRec),-     /* class_initializer  */	ClassInitialize, $     /* class_part_initialize*/	NULL,#     /* Class init'ed      */	FALSE, +     /* initialize         */    Initialize, "     /* initialize_hook    */	NULL,%     /* realize            */    NULL, %     /* actions            */    NULL, %     /* num_actions        */    ZERO, *     /* resources          */    resources,1     /* resource_count     */	XtNumber(resources), *     /* xrm_class          */    NULLQUARK,'     /* compress_motion    */    FALSE,  &     /* compress_exposure  */    FALSE,$     /* compress_enterleave*/ 	FALSE,&     /* visible_interest   */    FALSE,(     /* destroy            */    Destroy,%     /* resize             */    NULL, *     /* expose             */    Redisplay,*     /* set_values         */    SetValues,"     /* set_values_hook    */	NULL,8     /* set_values_almost  */	XtInheritSetValuesAlmost,  %     /* get_values_hook    */	NULL,			 %     /* accept_focus       */    NULL, '     /* intrinsics version */	XtVersion, %     /* callback offsets   */    NULL,      /* tm_table		  */    NULL,,     /* query_geometry	  */    QueryGeometry,%     /* display_accelerator*/    NULL,      /* extension	  */    NULL    },{      /* Menu Entry Fields */        +     /* highlight */             FlipColors, +     /* unhighlight */           FlipColors, $     /* notify */		XtInheritNotify,		     /* extension	  */    NULL    }, {!     /* BSB Menu entry Fields */          /* extension	  */    NULL    }  };  > WidgetClass smeBSBObjectClass = (WidgetClass) &smeBSBClassRec;  = /************************************************************   *  * Semi-Public Functions.   *>  ************************************************************/  ! /*	Function Name: ClassInitialize .  *	Description: Initializes the SmeBSBObject.   *	Arguments: none.   *	Returns: none.   */    static void  ClassInitialize()  {      XawInitializeWidgetSet(); L     XtAddConverter( XtRString, XtRJustify, XmuCvtStringToJustify, NULL, 0 ); }   ! /*      Function Name: Initialize 7  *      Description: Initializes the simple menu widget G  *      Arguments: request - the widget requested by the argument list. F  *                 new     - the new widget with both resource and non-  *                           resource values.   *      Returns: none.  */    /* ARGSUSED */ static void  Initialize(request, new) Widget request, new; { ,     SmeBSBObject entry = (SmeBSBObject) new;  &     if (entry->sme_bsb.label == NULL) $ 	entry->sme_bsb.label = XtName(new);     else< 	entry->sme_bsb.label = XtNewString( entry->sme_bsb.label );  O     GetDefaultSize(new, &(entry->rectangle.width), &(entry->rectangle.height));      CreateGCs(new);   M     entry->sme_bsb.left_bitmap_width = entry->sme_bsb.left_bitmap_height = 0; O     entry->sme_bsb.right_bitmap_width = entry->sme_bsb.right_bitmap_height = 0;   4     GetBitmapInfo(new, TRUE);	/* Left Bitmap Info */6     GetBitmapInfo(new, FALSE);	/* Right Bitmap Info */ }    /*      Function Name: Destroy7  *      Description: Called at destroy time, cleans up. .  *      Arguments: w - the simple menu widget.  *      Returns: none.  */    static void 
 Destroy(w)	 Widget w;  { *     SmeBSBObject entry = (SmeBSBObject) w;       DestroyGCs(w);*     if (entry->sme_bsb.label != XtName(w)) 	XtFree(entry->sme_bsb.label); }     /*      Function Name: Redisplay;  *      Description: Redisplays the contents of the widget. .  *      Arguments: w - the simple menu widget.B  *                 event - the X event that caused this redisplay.B  *                 region - the region the needs to be repainted.   *      Returns: none.  */    /* ARGSUSED */ static void  Redisplay(w, event, region) 	 Widget w;  XEvent * event;  Region region; { 
     GC gc;*     SmeBSBObject entry = (SmeBSBObject) w;)     int	font_ascent, font_descent, y_loc;   7     entry->sme_bsb.set_values_area_cleared = FALSE;     9     font_ascent = entry->sme_bsb.font->max_bounds.ascent; ;     font_descent = entry->sme_bsb.font->max_bounds.descent;        y_loc = entry->rectangle.y;      <     if (XtIsSensitive(w) && XtIsSensitive( XtParent(w) ) ) {7 	if ( w == XawSimpleMenuGetActiveEntry(XtParent(w)) ) { ? 	    XFillRectangle(XtDisplayOfObject(w), XtWindowOfObject(w),  ' 			   entry->sme_bsb.norm_gc, 0, y_loc, , 			   (unsigned int) entry->rectangle.width,. 			   (unsigned int) entry->rectangle.height);  	    gc = entry->sme_bsb.rev_gc; 	} 	else ! 	    gc = entry->sme_bsb.norm_gc;      }      else" 	gc = entry->sme_bsb.norm_gray_gc;     '     if (entry->sme_bsb.label != NULL) { ( 	int x_loc = entry->sme_bsb.left_margin;( 	int len = strlen(entry->sme_bsb.label);% 	char * label = entry->sme_bsb.label;   ! 	switch(entry->sme_bsb.justify) {  	    int width, t_width;   	case XtJustifyCenter:; 	    t_width = XTextWidth(entry->sme_bsb.font, label, len); C 	    width = entry->rectangle.width - (entry->sme_bsb.left_margin + ( 					      entry->sme_bsb.right_margin);" 	    x_loc += (width - t_width)/2; 	    break;  	case XtJustifyRight: ; 	    t_width = XTextWidth(entry->sme_bsb.font, label, len); D 	    x_loc = entry->rectangle.width - (entry->sme_bsb.right_margin + 					      t_width); 	    break;  	case XtJustifyLeft:	 	default:  	    break;  	}  * 	y_loc += ((int)entry->rectangle.height - 4 		  (font_ascent + font_descent)) / 2 + font_ascent; 	 ; 	XDrawString(XtDisplayOfObject(w), XtWindowOfObject(w), gc,   		    x_loc, y_loc, label, len);     }        DrawBitmaps(w, gc);  }       /*      Function Name: SetValuesL  *      Description: Relayout the menu when one of the resources is changed.9  *      Arguments: current - current state of the widget. 0  *                 request - what was requested.5  *                 new - what the widget will become.   *      Returns: none   */    /* ARGSUSED */ static Boolean  SetValues(current, request, new) Widget current, request, new;  { ,     SmeBSBObject entry = (SmeBSBObject) new;4     SmeBSBObject old_entry = (SmeBSBObject) current;     Boolean ret_val = FALSE;  ;     if (old_entry->sme_bsb.label != entry->sme_bsb.label) { 7         if (old_entry->sme_bsb.label != XtName( new ) ) 1 	    XtFree( (char *) old_entry->sme_bsb.label );   + 	if (entry->sme_bsb.label != XtName(new) )  @ 	    entry->sme_bsb.label = XtNewString( entry->sme_bsb.label );   	ret_val = True;     }   F     if (entry->rectangle.sensitive != old_entry->rectangle.sensitive ) 	ret_val = TRUE;  G     if (entry->sme_bsb.left_bitmap != old_entry->sme_bsb.left_bitmap) {  	GetBitmapInfo(new, TRUE); 	ret_val = TRUE;     }   I     if (entry->sme_bsb.right_bitmap != old_entry->sme_bsb.right_bitmap) {  	GetBitmapInfo(new, FALSE);  	ret_val = TRUE;     }   <     if ( (old_entry->sme_bsb.font != entry->sme_bsb.font) ||B 	 (old_entry->sme_bsb.foreground != entry->sme_bsb.foreground) ) { 	DestroyGCs(current);  	CreateGCs(new); 	ret_val = TRUE;     }        if (ret_val) { 	GetDefaultSize(new,  @ 		       &(entry->rectangle.width), &(entry->rectangle.height));/ 	entry->sme_bsb.set_values_area_cleared = TRUE;      }      return(ret_val); }     /*	Function Name: QueryGeometry.?  *	Description: Returns the preferred geometry for this widget. (  *	Arguments: w - the menu entry object.O  *                 itended, return_val - the intended and return geometry info.   *	Returns: A Geometry Result.  *F  * See the Intrinsics manual for details on what this function is for.  *  D  * I just return the height and width of the label plus the margins.  */    static XtGeometryResult ' QueryGeometry(w, intended, return_val)  	 Widget w; ( XtWidgetGeometry *intended, *return_val; { *     SmeBSBObject entry = (SmeBSBObject) w;     Dimension width, height;-     XtGeometryResult ret_val = XtGeometryYes; 1     XtGeometryMask mode = intended->request_mode;   ,     GetDefaultSize(w, &width, &height );      <     if ( ((mode & CWWidth) && (intended->width != width)) || 	 !(mode & CWWidth) ) { % 	return_val->request_mode |= CWWidth;  	return_val->width = width;  	ret_val = XtGeometryAlmost;     }   ?     if ( ((mode & CWHeight) && (intended->height != height)) ||  	 !(mode & CWHeight) ) {& 	return_val->request_mode |= CWHeight; 	return_val->height = height;  	ret_val = XtGeometryAlmost;     }   &     if (ret_val == XtGeometryAlmost) {! 	mode = return_val->request_mode;  	 @ 	if ( ((mode & CWWidth) && (width == entry->rectangle.width)) &&B 	     ((mode & CWHeight) && (height == entry->rectangle.height)) ) 	    return(XtGeometryNo);     }        return(ret_val); }      ! /*      Function Name: FlipColors <  *      Description: Invert the colors of the current entry.1  *      Arguments: w - the bsb menu entry widget.   *      Returns: none.  */    static void 
 FlipColors(w) 	 Widget w;  { *     SmeBSBObject entry = (SmeBSBObject) w;  7     if (entry->sme_bsb.set_values_area_cleared) return;   =     XFillRectangle(XtDisplayOfObject(w), XtWindowOfObject(w), ; 		   entry->sme_bsb.invert_gc, 0, (int) entry->rectangle.y, , 		   (unsigned int) entry->rectangle.width, - 		   (unsigned int) entry->rectangle.height);  }   = /************************************************************   *  * Private Functions.   *>  ************************************************************/    /*	Function Name: GetDefaultSize:  *	Description: Calculates the Default (preferred) size of%  *                   this menu entry. (  *	Arguments: w - the menu entry widget.<  *                 width, height - default sizes (RETURNED).  *	Returns: none.   */    static void ! GetDefaultSize(w, width, height)  	 Widget w;  Dimension * width, * height; { *     SmeBSBObject entry = (SmeBSBObject) w;  &     if (entry->sme_bsb.label == NULL)  	*width = 0;     else? 	*width = XTextWidth(entry->sme_bsb.font, entry->sme_bsb.label, % 			    strlen(entry->sme_bsb.label));   G     *width += entry->sme_bsb.left_margin + entry->sme_bsb.right_margin;      7     *height = (entry->sme_bsb.font->max_bounds.ascent + 1 	       entry->sme_bsb.font->max_bounds.descent);   .     *height = ((int)*height * ( ONE_HUNDRED + 6 			        entry->sme_bsb.vert_space )) / ONE_HUNDRED; }   " /*      Function Name: DrawBitmaps2  *      Description: Draws left and right bitmaps..  *      Arguments: w - the simple menu widget.<  *                 gc - graphics context to use for drawing.  *      Returns: none   */    static void  DrawBitmaps(w, gc)	 Widget w;  GC gc; {      int x_loc, y_loc; *     SmeBSBObject entry = (SmeBSBObject) w;     1     if ( (entry->sme_bsb.left_bitmap == None) &&  1 	 (entry->sme_bsb.right_bitmap == None) ) return;    /*  * Draw Left Bitmap.  */   +   if (entry->sme_bsb.left_bitmap != None) { .     x_loc = (int)(entry->sme_bsb.left_margin -1 	          entry->sme_bsb.left_bitmap_width) / 2;   @     y_loc = entry->rectangle.y + (int)(entry->rectangle.height -2 				       entry->sme_bsb.left_bitmap_height) / 2;  @     XCopyPlane(XtDisplayOfObject(w), entry->sme_bsb.left_bitmap,' 	       XtWindowOfObject(w), gc, 0, 0,  ) 	       entry->sme_bsb.left_bitmap_width, < 	       entry->sme_bsb.left_bitmap_height, x_loc, y_loc, 1);   }    /*  * Draw Right Bitmap.   */     ,   if (entry->sme_bsb.right_bitmap != None) {$     x_loc = entry->rectangle.width -* 	      (int)(entry->sme_bsb.right_margin +- 		    entry->sme_bsb.right_bitmap_width) / 2;   @     y_loc = entry->rectangle.y + (int)(entry->rectangle.height -3 				       entry->sme_bsb.right_bitmap_height) / 2;   A     XCopyPlane(XtDisplayOfObject(w), entry->sme_bsb.right_bitmap, ' 	       XtWindowOfObject(w), gc, 0, 0,  * 	       entry->sme_bsb.right_bitmap_width,= 	       entry->sme_bsb.right_bitmap_height, x_loc, y_loc, 1);    }  }   $ /*      Function Name: GetBitmapInfoL  *      Description: Gets the bitmap information from either of the bitmaps.1  *      Arguments: w - the bsb menu entry widget. @  *                 is_left - TRUE if we are testing left bitmap,F  *                           FALSE if we are testing the right bitmap.  *      Returns: none   */    static void  GetBitmapInfo(w, is_left) 	 Widget w;  Boolean is_left; { .     SmeBSBObject entry = (SmeBSBObject) w;         unsigned int depth, bw;      Window root;
     int x, y;      unsigned int width, height;      char buf[BUFSIZ];           if (is_left) {* 	if (entry->sme_bsb.left_bitmap != None) {- 	    if (!XGetGeometry(XtDisplayOfObject(w),  , 			      entry->sme_bsb.left_bitmap, &root, 1 			      &x, &y, &width, &height, &bw, &depth)) { ; 		sprintf(buf, "SmeBSB Object: %s %s \"%s\".", "Could not", : 			"get Left Bitmap geometry information for menu entry ", 			XtName(w));3 		XtAppError(XtWidgetToApplicationContext(w), buf);  	    } 	    if (depth != 1) {. 		sprintf(buf, "SmeBSB Object: %s \"%s\"%s.",  			"Left Bitmap of entry ", ' 			XtName(w), " is not one bit deep."); 3 		XtAppError(XtWidgetToApplicationContext(w), buf);  	    }; 	    entry->sme_bsb.left_bitmap_width = (Dimension) width;  < 	    entry->sme_bsb.left_bitmap_height = (Dimension) height; 	}     } 3     else if (entry->sme_bsb.right_bitmap != None) { ( 	if (!XGetGeometry(XtDisplayOfObject(w),( 			  entry->sme_bsb.right_bitmap, &root,- 			  &x, &y, &width, &height, &bw, &depth)) { > 	    sprintf(buf, "SmeBSB Object: %s %s \"%s\".", "Could not",> 		    "get Right Bitmap geometry information for menu entry ", 		    XtName(w)); 6 	    XtAppError(XtWidgetToApplicationContext(w), buf); 	} 	if (depth != 1) {1 	    sprintf(buf, "SmeBSB Object: %s \"%s\"%s.",  * 		    "Right Bitmap of entry ", XtName(w), 		    " is not one bit deep."); 6 	    XtAppError(XtWidgetToApplicationContext(w), buf); 	}8 	entry->sme_bsb.right_bitmap_width = (Dimension) width; 9 	entry->sme_bsb.right_bitmap_height = (Dimension) height;      }  }           /*      Function Name: CreateGCsA  *      Description: Creates all gc's for the simple menu widget. .  *      Arguments: w - the simple menu widget.  *      Returns: none.  */    static void  CreateGCs(w)	 Widget w;  { .     SmeBSBObject entry = (SmeBSBObject) w;         XGCValues values;      XtGCMask mask;     ;     values.foreground = XtParent(w)->core.background_pixel; 2     values.background = entry->sme_bsb.foreground;+     values.font = entry->sme_bsb.font->fid; &     values.graphics_exposures = FALSE;M     mask        = GCForeground | GCBackground | GCFont | GCGraphicsExposures; 6     entry->sme_bsb.rev_gc = XtGetGC(w, mask, &values);     2     values.foreground = entry->sme_bsb.foreground;;     values.background = XtParent(w)->core.background_pixel; 7     entry->sme_bsb.norm_gc = XtGetGC(w, mask, &values);      "     values.fill_style = FillTiled;A     values.tile   = XmuCreateStippledPixmap(XtScreenOfObject(w),  # 					    entry->sme_bsb.foreground, , 					    XtParent(w)->core.background_pixel," 					    XtParent(w)->core.depth);&     values.graphics_exposures = FALSE;!     mask |= GCTile | GCFillStyle; <     entry->sme_bsb.norm_gray_gc = XtGetGC(w, mask, &values);     +     values.foreground ^= values.background;      values.background = 0;     values.function = GXxor;J     mask = GCForeground | GCBackground | GCGraphicsExposures | GCFunction;9     entry->sme_bsb.invert_gc = XtGetGC(w, mask, &values);  }   ! /*      Function Name: DestroyGCs A  *      Description: Removes all gc's for the simple menu widget. .  *      Arguments: w - the simple menu widget.  *      Returns: none.  */    static void 
 DestroyGCs(w) 	 Widget w;  { .     SmeBSBObject entry = (SmeBSBObject) w;      +     XtReleaseGC(w, entry->sme_bsb.norm_gc); 0     XtReleaseGC(w, entry->sme_bsb.norm_gray_gc);*     XtReleaseGC(w, entry->sme_bsb.rev_gc);-     XtReleaseGC(w, entry->sme_bsb.invert_gc);  }   
 #ifdef apollo    /*=  * The apollo compiler that we have optomizes out my code for B  * FlipColors() since it is static. and no one executes it in thisG  * file.  I am setting the function pointer into the class structure so A  * that it can be called by my parent who will tell me to when to   * highlight and unhighlight.   */    void _XawSmeBSBApolloHack () {      FlipColors();  }  #endif /* apollo */ 