 /*@  * $XConsortium: SimpleMenu.h,v 1.20 91/02/17 13:18:55 rws Exp $  *7  * Copyright 1989 Massachusetts Institute of Technology   *N  * Permission to use, copy, modify, distribute, and sell this software and itsM  * documentation for any purpose is hereby granted without fee, provided that E  * the above copyright notice appear in all copies and that both that C  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION J  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   */  * Author:  Chris D. Peterson, MIT X Consortium   */    /*;  * SimpleMenu.h - Public Header file for SimpleMenu widget.   *C  * This is the public header file for the Athena SimpleMenu widget. E  * It is intended to provide one pane pulldown and popup menus within I  * the framework of the X Toolkit.  As the name implies it is a first and K  * by no means complete implementation of menu code. It does not attempt to I  * fill the needs of all applications, but does allow a resource oriented   * interface to menus.  *  * Date:    April 3, 1989   *  * By:      Chris D. Peterson   *          MIT X Consortium     *          kit@expo.lcs.mit.edu  */    #ifndef _SimpleMenu_h  #define _SimpleMenu_h    #include <X11/Shell.h> #include <X11/Xmu/Converters.h>  #include <X11/Xfuncproto.h>   A /****************************************************************   *  * SimpleMenu widget  *B  ****************************************************************/   /* SimpleMenu Resources:  )  Name		     Class		RepType		Default Value )  ----		     -----		-------		------------- 7  background	     Background		Pixel		XtDefaultBackground :  backgroundPixmap    BackgroundPixmap	Pixmap          None8  borderColor	     BorderColor	Pixel		XtDefaultForeground,  borderPixmap	     BorderPixmap	Pixmap		None)  borderWidth	     BorderWidth	Dimension	1 E  bottomMargin        VerticalMargins    Dimension       VerticalSpace L  columnWidth         ColumnWidth        Dimension       Width of widest text<  cursor              Cursor             Cursor          None,  destroyCallback     Callback		Pointer		NULL!  height		     Height		Dimension	0 G  label               Label              String          NULL (No label) I  labelClass          LabelClass         Pointer         smeBSBObjectClass 4  mappedWhenManaged   MappedWhenManaged	Boolean		TrueF  rowHeight           RowHeight          Dimension       Height of Font(  sensitive	     Sensitive		Boolean		TrueE  topMargin           VerticalMargins    Dimension       VerticalSpace   width		     Width		Dimension	0   x		     Position		Position	0n  y		     Position		Position	0    */  : typedef struct _SimpleMenuClassRec*	SimpleMenuWidgetClass;1 typedef struct _SimpleMenuRec*		SimpleMenuWidget;   ) extern WidgetClass simpleMenuWidgetClass;    #define XtNcursor "cursor"& #define XtNbottomMargin "bottomMargin"$ #define XtNcolumnWidth "columnWidth"" #define XtNlabelClass "labelClass"& #define XtNmenuOnScreen "menuOnScreen"& #define XtNpopupOnEntry "popupOnEntry"  #define XtNrowHeight "rowHeight"  #define XtNtopMargin "topMargin"  $ #define XtCColumnWidth "ColumnWidth"" #define XtCLabelClass "LabelClass"& #define XtCMenuOnScreen "MenuOnScreen"& #define XtCPopupOnEntry "PopupOnEntry"  #define XtCRowHeight "RowHeight", #define XtCVerticalMargins "VerticalMargins"  = /************************************************************   *  * Public Functions.  *>  ************************************************************/   _XFUNCPROTOBEGIN  / /*	Function Name: XawSimpleMenuAddGlobalActions B  *	Description: adds the global actions to the simple menu widget.'  *	Arguments: app_con - the appcontext.   *	Returns: none.   */   * extern void XawSimpleMenuAddGlobalActions( #if NeedFunctionPrototypes     XtAppContext	/* app_con */ #endif );   - /*	Function Name: XawSimpleMenuGetActiveEntry 6  *	Description: Gets the currently active (set) entry.!  *	Arguments: w - the smw widget. ;  *	Returns: the currently set entry or NULL if none is set.   */   * extern Widget XawSimpleMenuGetActiveEntry( #if NeedFunctionPrototypes     Widget		/* w */  #endif );  / /*	Function Name: XawSimpleMenuClearActiveEntry 8  *	Description: Unsets the currently active (set) entry.!  *	Arguments: w - the smw widget.   *	Returns: none.   */   * extern void XawSimpleMenuClearActiveEntry( #if NeedFunctionPrototypes     Widget		/* w */  #endif );   _XFUNCPROTOEND   #endif /* _SimpleMenu_h */