C /* $XConsortium: SimpleMenu.c,v 1.39 91/06/22 18:03:29 rws Exp $ */    /*7  * Copyright 1989 Massachusetts Institute of Technology   *N  * Permission to use, copy, modify, distribute, and sell this software and itsM  * documentation for any purpose is hereby granted without fee, provided that E  * the above copyright notice appear in all copies and that both that C  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION J  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   */    /*9  * SimpleMenu.c - Source code file for SimpleMenu widget.   *  * Date:    April 3, 1989   *  * By:      Chris D. Peterson   *          MIT X Consortium     *          kit@expo.lcs.mit.edu  */    #include <stdio.h> #include <X11/IntrinsicP.h>  #include <X11/StringDefs.h>    #include <X11/Xaw/XawInit.h> #include <X11/Xaw/SimpleMenP.h>  #include <X11/Xaw/SmeBSB.h>  #include <X11/Xaw/Cardinals.h>   #include <X11/Xmu/Initer.h>  #include <X11/Xmu/CharSet.h>  4 #define streq(a, b)        ( strcmp((a), (b)) == 0 )  B #define offset(field) XtOffsetOf(SimpleMenuRec, simple_menu.field)  " static XtResource resources[] = {    /*  * Label Resources.   */   2   {XtNlabel,  XtCLabel, XtRString, sizeof(String),,      offset(label_string), XtRString, NULL},B   {XtNlabelClass,  XtCLabelClass, XtRPointer, sizeof(WidgetClass),:      offset(label_class), XtRImmediate, (XtPointer) NULL},   /*  * Layout Resources.  */   @   {XtNrowHeight,  XtCRowHeight, XtRDimension, sizeof(Dimension),6      offset(row_height), XtRImmediate, (XtPointer) 0},F   {XtNtopMargin,  XtCVerticalMargins, XtRDimension, sizeof(Dimension),6      offset(top_margin), XtRImmediate, (XtPointer) 0},I   {XtNbottomMargin,  XtCVerticalMargins, XtRDimension, sizeof(Dimension), 9      offset(bottom_margin), XtRImmediate, (XtPointer) 0},    /*  * Misc. Resources  */   J   { XtNallowShellResize, XtCAllowShellResize, XtRBoolean, sizeof(Boolean),:       XtOffsetOf(SimpleMenuRec, shell.allow_shell_resize),'       XtRImmediate, (XtPointer) TRUE }, 3   {XtNcursor, XtCCursor, XtRCursor, sizeof(Cursor), 6       offset(cursor), XtRImmediate, (XtPointer) None},B   {XtNmenuOnScreen,  XtCMenuOnScreen, XtRBoolean, sizeof(Boolean),>       offset(menu_on_screen), XtRImmediate, (XtPointer) TRUE},@   {XtNpopupOnEntry,  XtCPopupOnEntry, XtRWidget, sizeof(Widget),,       offset(popup_entry), XtRWidget, NULL},C   {XtNbackingStore, XtCBackingStore, XtRBackingStore, sizeof (int),        offset(backing_store),  C       XtRImmediate, (XtPointer) (Always + WhenMapped + NotUseful)},  };  
 #undef offset   # static char defaultTranslations[] = 3     "<EnterWindow>:     highlight()             \n\ 3      <LeaveWindow>:     unhighlight()           \n\ 3      <BtnMotion>:       highlight()             \n\ ?      <BtnUp>:           MenuPopdown() notify() unhighlight()";     /*%  * Semi Public function definitions.    */   > static void Redisplay(), Realize(), Resize(), ChangeManaged();C static void Initialize(), ClassInitialize(), ClassPartInitialize(); , static Boolean SetValues(), SetValuesHook();* static XtGeometryResult GeometryManager();   /*  * Action Routine Definitions   */   G static void Highlight(), Unhighlight(), Notify(), PositionMenuAction();    /*     * Private Function Definitions.  */   < static void MakeSetValuesRequest(), CreateLabel(), Layout();F static void AddPositionAction(), PositionMenu(), ChangeCursorOnGrab();1 static Dimension GetMenuWidth(), GetMenuHeight();  static Widget FindMenu(); ! static SmeObject GetEventEntry();  static void MoveMenu();   # static XtActionsRec actionsList[] =  {     {"notify",            Notify},#   {"highlight",         Highlight}, %   {"unhighlight",       Unhighlight},  };   3 static CompositeClassExtensionRec extension_rec = {      /* next_extension */  NULL, $     /* record_type */     NULLQUARK,6     /* version */         XtCompositeExtensionVersion,=     /* record_size */     sizeof(CompositeClassExtensionRec),      /* accepts_objects */ TRUE,  };  + #define superclass (&overrideShellClassRec)      ) SimpleMenuClassRec simpleMenuClassRec = {    { 9     /* superclass         */    (WidgetClass) superclass, -     /* class_name         */    "SimpleMenu", 6     /* size               */    sizeof(SimpleMenuRec),-     /* class_initialize   */	ClassInitialize, 3     /* class_part_initialize*/	ClassPartInitialize, #     /* Class init'ed      */	FALSE, +     /* initialize         */    Initialize, "     /* initialize_hook    */	NULL,(     /* realize            */    Realize,,     /* actions            */    actionsList,6     /* num_actions        */    XtNumber(actionsList),*     /* resources          */    resources,1     /* resource_count     */	XtNumber(resources), *     /* xrm_class          */    NULLQUARK,&     /* compress_motion    */    TRUE, %     /* compress_exposure  */    TRUE, #     /* compress_enterleave*/ 	TRUE, &     /* visible_interest   */    FALSE,%     /* destroy            */    NULL, '     /* resize             */    Resize, *     /* expose             */    Redisplay,*     /* set_values         */    SetValues,+     /* set_values_hook    */	SetValuesHook, 8     /* set_values_almost  */	XtInheritSetValuesAlmost,  %     /* get_values_hook    */	NULL,			 %     /* accept_focus       */    NULL, '     /* intrinsics version */	XtVersion, %     /* callback offsets   */    NULL, -     /* tm_table		  */    defaultTranslations, #     /* query_geometry	  */    NULL, %     /* display_accelerator*/    NULL,      /* extension	  */    NULL    },{ 0     /* geometry_manager   */    GeometryManager,.     /* change_managed     */    ChangeManaged,.     /* insert_child	  */	XtInheritInsertChild,.     /* delete_child	  */	XtInheritDeleteChild,     /* extension	  */    NULL    },{ #     /* Shell extension	  */    NULL    },{ $     /* Override extension */    NULL   },{ $     /* Simple Menu extension*/  NULL   }  };  E WidgetClass simpleMenuWidgetClass = (WidgetClass)&simpleMenuClassRec;   = /************************************************************   *  * Semi-Public Functions.   *>  ************************************************************/  & /*      Function Name: ClassInitialize@  *      Description: Class Initialize routine, called only once.  *      Arguments: none.  *      Returns: none.  */    static void  ClassInitialize()  {    XawInitializeWidgetSet(); I   XtAddConverter( XtRString, XtRBackingStore, XmuCvtStringToBackingStore, 
 		 NULL, 0 ); .   XmuAddInitializer( AddPositionAction, NULL); }   & /*      Function Name: ClassInitializeD  *      Description: Class Part Initialize routine, called for everyG  *                   subclass.  Makes sure that the subclasses pick up  *  *                   the extension record.9  *      Arguments: wc - the widget class of the subclass.   *      Returns: none.  */    static void  ClassPartInitialize(wc)  WidgetClass wc;  { <     SimpleMenuWidgetClass smwc = (SimpleMenuWidgetClass) wc;   /*:  * Make sure that our subclass gets the extension rec too.  */   C     extension_rec.next_extension = smwc->composite_class.extension; A     smwc->composite_class.extension = (XtPointer) &extension_rec;  }   ! /*      Function Name: Initialize 7  *      Description: Initializes the simple menu widget G  *      Arguments: request - the widget requested by the argument list. F  *                 new     - the new widget with both resource and non-  *                           resource values.   *      Returns: none.  */    /* ARGSUSED */ static void  Initialize(request, new) Widget request, new; { 0   SimpleMenuWidget smw = (SimpleMenuWidget) new;  9   XmuCallInitializers(XtWidgetToApplicationContext(new));   ,   if (smw->simple_menu.label_class == NULL) 7       smw->simple_menu.label_class = smeBSBObjectClass;       smw->simple_menu.label = NULL;$   smw->simple_menu.entry_set = NULL;0   smw->simple_menu.recursive_set_values = FALSE;  ,   if (smw->simple_menu.label_string != NULL)       CreateLabel(new);   %   smw->simple_menu.menu_width = TRUE;      if (smw->core.width == 0) { *       smw->simple_menu.menu_width = FALSE;0       smw->core.width = GetMenuWidth(new, NULL);   }   &   smw->simple_menu.menu_height = TRUE;     if (smw->core.height == 0) {+       smw->simple_menu.menu_height = FALSE; ,       smw->core.height = GetMenuHeight(new);   }    /*8  * Add a popup_callback routine for changing the cursor.  */    A   XtAddCallback(new, XtNpopupCallback, ChangeCursorOnGrab, NULL);  }     /*      Function Name: Redisplay;  *      Description: Redisplays the contents of the widget. .  *      Arguments: w - the simple menu widget.B  *                 event - the X event that caused this redisplay.B  *                 region - the region the needs to be repainted.   *      Returns: none.  */    /* ARGSUSED */ static void  Redisplay(w, event, region) 	 Widget w;  XEvent * event;  Region region; { 0     SimpleMenuWidget smw = (SimpleMenuWidget) w;     SmeObject * entry;     SmeObjectClass class;        if (region == NULL) ) 	XClearWindow(XtDisplay(w), XtWindow(w));        /*A      * Check and Paint each of the entries - including the label.       */         ForAllChildren(smw, entry) {/ 	if (!XtIsManaged ( (Widget) *entry)) continue;    	if (region != NULL)  > 	    switch(XRectInRegion(region, (int) (*entry)->rectangle.x,! 				 (int) (*entry)->rectangle.y, . 				 (unsigned int) (*entry)->rectangle.width,2 				 (unsigned int) (*entry)->rectangle.height)) { 	    case RectangleIn: 	    case RectanglePart: 		break;
 	    default:  		continue;  	    }8 	class = (SmeObjectClass) (*entry)->object.widget_class;  & 	if (class->rect_class.expose != NULL)> 	    (class->rect_class.expose)( (Widget) *entry, NULL, NULL);     }  }    /*      Function Name: Realize)  *      Description: Realizes the widget. .  *      Arguments: w - the simple menu widget.>  *                 mask - value mask for the window to create.?  *                 attrs - attributes for the window to create.   *      Returns: none   */    static void  Realize(w, mask, attrs) 	 Widget w;  XtValueMask * mask;  XSetWindowAttributes * attrs;  { 0     SimpleMenuWidget smw = (SimpleMenuWidget) w;  ,     attrs->cursor = smw->simple_menu.cursor;     *mask |= CWCursor;5     if ((smw->simple_menu.backing_store == Always) || 1 	(smw->simple_menu.backing_store == NotUseful) || 3 	(smw->simple_menu.backing_store == WhenMapped) ) {  	*mask |= CWBackingStore; 7 	attrs->backing_store = smw->simple_menu.backing_store;      }      else 	*mask &= ~CWBackingStore;  7     (*superclass->core_class.realize) (w, mask, attrs);  }    /*      Function Name: Resize :  *      Description: Handle the menu being resized bigger..  *      Arguments: w - the simple menu widget.  *      Returns: none.  */    static void 	 Resize(w) 	 Widget w;  { 0     SimpleMenuWidget smw = (SimpleMenuWidget) w;     SmeObject * entry;  #     if ( !XtIsRealized(w) ) return;   A     ForAllChildren(smw, entry) 	/* reset width of all entries. */ # 	if (XtIsManaged( (Widget) *entry)) 1 	    (*entry)->rectangle.width = smw->core.width;      1     Redisplay(w, (XEvent *) NULL, (Region) NULL);  }     /*      Function Name: SetValuesL  *      Description: Relayout the menu when one of the resources is changed.9  *      Arguments: current - current state of the widget. 0  *                 request - what was requested.5  *                 new - what the widget will become.   *      Returns: none   */    /* ARGSUSED */ static Boolean  SetValues(current, request, new) Widget current, request, new;  { :     SimpleMenuWidget smw_old = (SimpleMenuWidget) current;6     SimpleMenuWidget smw_new = (SimpleMenuWidget) new;,     Boolean ret_val = FALSE, layout = FALSE;     .     if (!XtIsRealized(current)) return(FALSE);     5     if (!smw_new->simple_menu.recursive_set_values) { 2 	if (smw_new->core.width != smw_old->core.width) {B 	    smw_new->simple_menu.menu_width = (smw_new->core.width != 0); 	    layout = TRUE;  	}4 	if (smw_new->core.height != smw_old->core.height) {D 	    smw_new->simple_menu.menu_height = (smw_new->core.height != 0); 	    layout = TRUE;  	}     }   C     if (smw_old->simple_menu.cursor != smw_new->simple_menu.cursor)  	XDefineCursor(XtDisplay(new),4 		      XtWindow(new), smw_new->simple_menu.cursor);     O     if (smw_old->simple_menu.label_string !=smw_new->simple_menu.label_string)  F 	if (smw_new->simple_menu.label_string == NULL)         /* Destroy. */: 	    XtDestroyWidget((Widget) smw_old->simple_menu.label);E 	else if (smw_old->simple_menu.label_string == NULL)    /* Create. */  	    CreateLabel(new);E 	else {                                                 /* Change. */  	    Arg args[1];  	     D 	    XtSetArg(args[0], XtNlabel, smw_new->simple_menu.label_string);A 	    XtSetValues((Widget) smw_new->simple_menu.label, args, ONE);  	}     M     if (smw_old->simple_menu.label_class != smw_new->simple_menu.label_class) 0 	XtAppWarning(XtWidgetToApplicationContext(new),; 		     "No Dynamic class change of the SimpleMenu Label.");      O     if ((smw_old->simple_menu.top_margin != smw_new->simple_menu.top_margin) || ( 	(smw_old->simple_menu.bottom_margin != H 	 smw_new->simple_menu.bottom_margin) /* filler.................  */ ) { 	layout = TRUE;  	ret_val = TRUE;     }        if (layout)  	Layout(new, NULL, NULL);        return(ret_val); }   $ /*      Function Name: SetValuesHookA  *      Description: To handle a special case, this is passed the &  *                   actual arguments.'  *      Arguments: w - the menu widget. E  *                 arglist - the argument list passed to XtSetValues. 1  *                 num_args - the number of args.   *      Returns: none   */    /*  ?  * If the user actually passed a width and height to the widget E  * then this MUST be used, rather than our newly calculated width and 
  * height.  */    static Boolean# SetValuesHook(w, arglist, num_args) 	 Widget w;  ArgList arglist; Cardinal *num_args;  {      register Cardinal i;     Dimension width, height;          width = w->core.width;     height = w->core.height;     (     for ( i = 0 ; i < *num_args ; i++) {( 	if ( streq(arglist[i].name, XtNwidth) )* 	    width = (Dimension) arglist[i].value;) 	if ( streq(arglist[i].name, XtNheight) ) + 	    height = (Dimension) arglist[i].value;      }   ?     if ((width != w->core.width) || (height != w->core.height)) ( 	MakeSetValuesRequest(w, width, height);     return(FALSE); }   = /************************************************************   *   * Geometry Management routines.  *>  ************************************************************/  ! /*	Function Name: GeometryManager A  *	Description: This is the SimpleMenu Widget's Geometry Manager. 4  *	Arguments: w - the Menu Entry making the request.4  *                 request - requested new geometry.0  *                 reply - the allowed geometry.(  *	Returns: XtGeometry{Yes, No, Almost}.  */    static XtGeometryResult " GeometryManager(w, request, reply)	 Widget w; $ XtWidgetGeometry * request, * reply; { :     SimpleMenuWidget smw = (SimpleMenuWidget) XtParent(w);$     SmeObject entry = (SmeObject) w;0     XtGeometryMask mode = request->request_mode;     XtGeometryResult answer;$     Dimension old_height, old_width;  2     if ( !(mode & CWWidth) && !(mode & CWHeight) ) 	return(XtGeometryNo);  "     reply->width = request->width;$     reply->height = request->height;  '     old_width = entry->rectangle.width; )     old_height = entry->rectangle.height;   2     Layout(w, &(reply->width), &(reply->height) );   /*G  * Since we are an override shell and have no parent there is no one to G  * ask to see if this geom change is okay, so I am just going to assume I  * we can do whatever we want.  If you subclass be very careful with this !  * assumption, it could bite you.   *"  * Chris D. Peterson - Sept. 1989.  */   ,     if ( (reply->width == request->width) &&( 	 (reply->height == request->height) ) {  A 	if ( mode & XtCWQueryOnly ) { /* Actually perform the layout. */ ( 	    entry->rectangle.width = old_width;+ 	    entry->rectangle.height = old_height;	  	} 	else { ' 	    Layout(( Widget) smw, NULL, NULL);  	} 	answer = XtGeometryDone;      } 
     else {$ 	entry->rectangle.width = old_width;' 	entry->rectangle.height = old_height;	   A 	if ( ((reply->width == request->width) && !(mode & CWHeight)) || C 	      ((reply->height == request->height) && !(mode & CWWidth)) || , 	      ((reply->width == request->width) && - 	       (reply->height == request->height)) )  	    answer = XtGeometryNo;  	else {  	    answer = XtGeometryAlmost;  	    reply->request_mode = 0; ( 	    if (reply->width != request->width)! 		reply->request_mode |= CWWidth; * 	    if (reply->height != request->height)" 		reply->request_mode |= CWHeight; 	}     }      return(answer);  }    /*	Function Name: ChangeManaged 7  *	Description: called whenever a new child is managed. )  *	Arguments: w - the simple menu widget.   *	Returns: none.   */    static void  ChangeManaged(w)	 Widget w;  {      Layout(w, NULL, NULL); }   = /************************************************************   *  * Global Action Routines.  *  <  * These actions routines will be added to the application's  * global action list.    *  >  ************************************************************/  ) /*      Function Name: PositionMenuAction 6  *      Description: Positions the simple menu widget.<  *      Arguments: w - a widget (no the simple menu widget.)=  *                 event - the event that caused this action. I  *                 params, num_params - parameters passed to the routine. L  *                                      we expect the name of the menu here.  *      Returns: none   */    /* ARGSUSED */ static void 0 PositionMenuAction(w, event, params, num_params)	 Widget w;  XEvent * event;  String * params; Cardinal * num_params; {    Widget menu;
   XPoint loc;      if (*num_params != 1) {      char error_buf[BUFSIZ];      sprintf(error_buf, "%s %s", E 	    "Xaw - SimpleMenuWidget: position menu action expects only one", 1 	    "parameter which is the name of the menu."); =     XtAppWarning(XtWidgetToApplicationContext(w), error_buf);      return;    }   1   if ( (menu = FindMenu(w, params[0])) == NULL) {      char error_buf[BUFSIZ]; !     sprintf(error_buf, "%s '%s'", G 	    "Xaw - SimpleMenuWidget: could not find menu named: ", params[0]); =     XtAppWarning(XtWidgetToApplicationContext(w), error_buf);      return;    }       switch (event->type) {   case ButtonPress:    case ButtonRelease: "     loc.x = event->xbutton.x_root;"     loc.y = event->xbutton.y_root;     PositionMenu(menu, &loc); 
     break;   case EnterNotify:    case LeaveNotify: $     loc.x = event->xcrossing.x_root;$     loc.y = event->xcrossing.y_root;     PositionMenu(menu, &loc); 
     break;   case MotionNotify:"     loc.x = event->xmotion.x_root;"     loc.y = event->xmotion.y_root;     PositionMenu(menu, &loc); 
     break;
   default:     PositionMenu(menu, NULL); 
     break;   }  }     = /************************************************************   *  * Widget Action Routines.  *  >  ************************************************************/  " /*      Function Name: Unhighlight0  *      Description: Unhighlights current entry..  *      Arguments: w - the simple menu widget.=  *                 event - the event that caused this action. 6  *                 params, num_params - ** NOT USED **  *      Returns: none   */    /* ARGSUSED */ static void ) Unhighlight(w, event, params, num_params) 	 Widget w;  XEvent * event;  String * params; Cardinal * num_params; { 0     SimpleMenuWidget smw = (SimpleMenuWidget) w;1     SmeObject entry = smw->simple_menu.entry_set;      SmeObjectClass class;         if ( entry == NULL) return;   &     smw->simple_menu.entry_set = NULL;8     class = (SmeObjectClass) entry->object.widget_class;5     (class->sme_class.unhighlight) ( (Widget) entry);  }     /*      Function Name: Highlight.  *      Description: Highlights current entry..  *      Arguments: w - the simple menu widget.=  *                 event - the event that caused this action. 6  *                 params, num_params - ** NOT USED **  *      Returns: none   */    /* ARGSUSED */ static void ' Highlight(w, event, params, num_params) 	 Widget w;  XEvent * event;  String * params; Cardinal * num_params; { 0     SimpleMenuWidget smw = (SimpleMenuWidget) w;     SmeObject entry;     SmeObjectClass class;      $     if ( !XtIsSensitive(w) ) return;     $     entry = GetEventEntry(w, event);  4     if (entry == smw->simple_menu.entry_set) return;  0     Unhighlight(w, event, params, num_params);         if (entry == NULL) return;  +     if ( !XtIsSensitive( (Widget) entry)) { # 	smw->simple_menu.entry_set = NULL;  	return;     }   '     smw->simple_menu.entry_set = entry; 8     class = (SmeObjectClass) entry->object.widget_class;  3     (class->sme_class.highlight) ( (Widget) entry);  }    /*      Function Name: Notify 2  *      Description: Notify user of current entry..  *      Arguments: w - the simple menu widget.=  *                 event - the event that caused this action. 6  *                 params, num_params - ** NOT USED **  *      Returns: none   */    /* ARGSUSED */ static void $ Notify(w, event, params, num_params)	 Widget w;  XEvent * event;  String * params; Cardinal * num_params; { 0     SimpleMenuWidget smw = (SimpleMenuWidget) w;1     SmeObject entry = smw->simple_menu.entry_set;      SmeObjectClass class;      D     if ( (entry == NULL) || !XtIsSensitive((Widget) entry) ) return;  8     class = (SmeObjectClass) entry->object.widget_class;0     (class->sme_class.notify)( (Widget) entry ); }   = /************************************************************   *  * Public Functions.  *>  ************************************************************/   / /*	Function Name: XawSimpleMenuAddGlobalActions B  *	Description: adds the global actions to the simple menu widget.'  *	Arguments: app_con - the appcontext.   *	Returns: none.   */    void #if NeedFunctionPrototypes3 XawSimpleMenuAddGlobalActions(XtAppContext app_con)  #else & XawSimpleMenuAddGlobalActions(app_con) XtAppContext app_con;  #endif { 3     XtInitializeWidgetClass(simpleMenuWidgetClass); #     XmuCallInitializers( app_con );  }      - /*	Function Name: XawSimpleMenuGetActiveEntry 6  *	Description: Gets the currently active (set) entry.!  *	Arguments: w - the smw widget. ;  *	Returns: the currently set entry or NULL if none is set.   */    Widget #if NeedFunctionPrototypes% XawSimpleMenuGetActiveEntry(Widget w)  #else  XawSimpleMenuGetActiveEntry(w)	 Widget w;  #endif { 0     SimpleMenuWidget smw = (SimpleMenuWidget) w;  1     return( (Widget) smw->simple_menu.entry_set);  }   / /*	Function Name: XawSimpleMenuClearActiveEntry 8  *	Description: Unsets the currently active (set) entry.!  *	Arguments: w - the smw widget.   *	Returns: none.   */    void #if NeedFunctionPrototypes' XawSimpleMenuClearActiveEntry(Widget w)  #else   XawSimpleMenuClearActiveEntry(w)	 Widget w;  #endif { 0     SimpleMenuWidget smw = (SimpleMenuWidget) w;  &     smw->simple_menu.entry_set = NULL; }   = /************************************************************   *  * Private Functions.   *>  ************************************************************/   /*	Function Name: CreateLabel )  *	Description: Creates a the menu label. !  *	Arguments: w - the smw widget.   *	Returns: none.   *  C  * Creates the label object and makes sure it is the first child in   * in the list.   */*   static voidS CreateLabel(w)	 Widget w;  {00     SimpleMenuWidget smw = (SimpleMenuWidget) w;*     register Widget * child, * next_child;     register int i;      Arg args[2];  3     if ( (smw->simple_menu.label_string == NULL) ||a& 	 (smw->simple_menu.label != NULL) ) { 	char error_buf[BUFSIZ];  ; 	sprintf(error_buf, "Xaw Simple Menu Widget: %s or %s, %s", 2 		"label string is NULL", "label already exists",   		"no label is being created.");: 	XtAppWarning(XtWidgetToApplicationContext(w), error_buf); 	return;     }r  ?     XtSetArg(args[0], XtNlabel, smw->simple_menu.label_string);t3     XtSetArg(args[1], XtNjustify, XtJustifyCenter); )     smw->simple_menu.label = (SmeObject)  : 	                      XtCreateManagedWidget("menuLabel", ) 					    smw->simple_menu.label_class, w,A 					    args, TWO);       next_child = NULL;G     for (child = smw->composite.children + smw->composite.num_children,N; 	 i = smw->composite.num_children ; i > 0 ; i--, child--) {O 	if (next_child != NULL) 	    *next_child = *child; 	next_child = child;     }A-     *child = (Widget) smw->simple_menu.label;T }T   /*	Function Name: Layout<  *	Description: lays the menu entries out all nice and neat.!  *	Arguments: w - See below (+++)*B  *                 width_ret, height_ret - The returned width and 9  *                                         height values.P  *	Returns: none.   *I  * if width == NULL || height == NULL then it assumes the you do not care.5  * about the return values, and just want a relayout.e  *D  * if this is not the case then it will set width_ret and height_retG  * to be width and height that the child would get if it were layed out<  * at this time.  *G  * +++ "w" can be the simple menu widget or any of its object children.)  */0   static voidf  Layout(w, width_ret, height_ret)	 Widget w;m" Dimension *width_ret, *height_ret; {e$     SmeObject current_entry, *entry;     SimpleMenuWidget smw;b     Dimension width, height;F     Boolean do_layout = ((height_ret == NULL) || (width_ret == NULL));     Boolean allow_change_size;     height = 0;o  3     if ( XtIsSubclass(w, simpleMenuWidgetClass) ) {  	smw = (SimpleMenuWidget) w; 	current_entry = NULL;     }g
     else {& 	smw = (SimpleMenuWidget) XtParent(w); 	current_entry = (SmeObject) w;e     }   6     allow_change_size = (!XtIsRealized((Widget)smw) ||% 			 (smw->shell.allow_shell_resize));X  '     if ( smw->simple_menu.menu_height )a 	height = smw->core.height;R     else 	if (do_layout) { * 	    height = smw->simple_menu.top_margin;! 	    ForAllChildren(smw, entry) {s/ 		if (!XtIsManaged( (Widget) *entry)) continue;S  - 		if ( (smw->simple_menu.row_height != 0) && t+ 		    (*entry != smw->simple_menu.label) ) i? 		    (*entry)->rectangle.height = smw->simple_menu.row_height;C 		! 		(*entry)->rectangle.y = height;  		(*entry)->rectangle.x = 0;' 		height += (*entry)->rectangle.height;  	    }. 	    height += smw->simple_menu.bottom_margin; 	} 	else {s/ 	    if ((smw->simple_menu.row_height != 0) && o- 		(current_entry != smw->simple_menu.label) )(' 		height = smw->simple_menu.row_height;i 	}     $     if (smw->simple_menu.menu_width) 	width = smw->core.width;(!     else if ( allow_change_size ),< 	width = GetMenuWidth((Widget) smw, (Widget) current_entry);     else 	width = smw->core.width;t       if (do_layout) { 	ForAllChildren(smw, entry)>( 	    if (XtIsManaged( (Widget) *entry)) $ 		(*entry)->rectangle.width = width;   	if (allow_change_size) 7 	    MakeSetValuesRequest((Widget) smw, width, height);      }o
     else { 	*width_ret = width; 	if (height != 0)l 	    *height_ret = height;     }  }t     # /*	Function Name: AddPositionActionhC  *	Description: Adds the XawPositionSimpleMenu action to the globalt1  *                   action list for this appcon.e=  *	Arguments: app_con - the application context for this app.A#  *                 data - NOT USED.t  *	Returns: none.(  */h   /* ARGSUSED */ static voide  AddPositionAction(app_con, data) XtAppContext app_con;*
 caddr_t data;i {a(     static XtActionsRec pos_action[] = {8         { "XawPositionSimpleMenu", PositionMenuAction },     };  ?     XtAppAddActions(app_con, pos_action, XtNumber(pos_action));t }W   /*	Function Name: FindMenu?  *	Description: Find the menu give a name and reference widget.t(  *	Arguments: widget - reference widget.3  *                 name   - the menu widget's name.h$  *	Returns: the menu widget or NULL.  */    static Widget  FindMenu(widget, name) Widget widget; String name; {_     register Widget w, menu;     4     for ( w = widget ; w != NULL ; w = XtParent(w) )0 	if ( (menu = XtNameToWidget(w, name)) != NULL ) 	    return(menu);     return(NULL);  }    /*	Function Name: PositionMenu  *	Description: Places the menue)  *	Arguments: w - the simple menu widget.lA  *                 location - a pointer the the position or NULL.a  *	Returns: none.   */c   static void  PositionMenu(w, location) 	 Widget w;  XPoint * location; {S0     SimpleMenuWidget smw = (SimpleMenuWidget) w;     SmeObject entry;     XPoint t_point;/          if (location == NULL) {s 	Window junk1, junk2; " 	int root_x, root_y, junkX, junkY; 	unsigned int junkM; 	l 	location = &t_point; > 	if (XQueryPointer(XtDisplay(w), XtWindow(w), &junk1, &junk2, : 			  &root_x, &root_y, &junkX, &junkY, &junkM) == FALSE) { 	    char error_buf[BUFSIZ];; 	    sprintf(error_buf, "%s %s", "Xaw - SimpleMenuWidget:",X2 		    "Could not find location of mouse pointer");> 	    XtAppWarning(XtWidgetToApplicationContext(w), error_buf); 	    return; 	} 	location->x = (short) root_x; 	location->y = (short) root_y;     }s          /*;      * The width will not be correct unless it is realized.       *//          XtRealizeWidget(w);      .     location->x -= (Position) w->core.width/2;     -     if (smw->simple_menu.popup_entry == NULL)s  	entry = smw->simple_menu.label;     else& 	entry = smw->simple_menu.popup_entry;       if (entry != NULL)? 	location->y -= entry->rectangle.y + entry->rectangle.height/2;X  @     MoveMenu(w, (Position) location->x, (Position) location->y); }*   /*	Function Name: MoveMenu8  *	Description: Actually moves the menu, may force it toC  *                   to be fully visable if menu_on_screen is TRUE.e)  *	Arguments: w - the simple menu widget.*=  *                 x, y - the current location of the widget.   *	Returns: none h  */    static voidh MoveMenu(w, x, y)e	 Widget w;  Position x, y; {*     Arg arglist[2];      Cardinal num_args = 0;0     SimpleMenuWidget smw = (SimpleMenuWidget) w;     *     if (smw->simple_menu.menu_on_screen) {6 	int width = w->core.width + 2 * w->core.border_width;8 	int height = w->core.height + 2 * w->core.border_width; 	* 	if (x >= 0) {0 	    int scr_width = WidthOfScreen(XtScreen(w)); 	    if (x + width > scr_width)* 		x = scr_width - width; 	} 	if (x < 0)  	    x = 0;C 	s 	if (y >= 0) {2 	    int scr_height = HeightOfScreen(XtScreen(w));! 	    if (y + height > scr_height)  		y = scr_height - height; 	} 	if (y < 0)  	    y = 0;z     }      5     XtSetArg(arglist[num_args], XtNx, x); num_args++;X5     XtSetArg(arglist[num_args], XtNy, y); num_args++;0&     XtSetValues(w, arglist, num_args); }n  $ /*	Function Name: ChangeCursorOnGrab@  *	Description: Changes the cursor on the active grab to the one4  *                   specified in out resource list.  *	Arguments: w - the widget.c2  *                 junk, garbage - ** NOT USED **.  *	Returns: None.w  */h   /* ARGSUSED */ static void $ ChangeCursorOnGrab(w, junk, garbage)	 Widget w;l XtPointer junk, garbage; {t0     SimpleMenuWidget smw = (SimpleMenuWidget) w;          /*J      * The event mask here is what is currently in the MIT implementation.F      * There really needs to be a way to get the value of the mask out$      * of the toolkit (CDP 5/26/89).      */      M     XChangeActivePointerGrab(XtDisplay(w), ButtonPressMask|ButtonReleaseMask,i! 			     smw->simple_menu.cursor, w0 			     XtLastTimestampProcessed(XtDisplay(w))); }s  + /*      Function Name: MakeSetValuesRequestnD  *      Description: Makes a (possibly recursive) call to SetValues,H  *                   I take great pains to not go into an infinite loop..  *      Arguments: w - the simple menu widget.;  *                 width, height - the size of the ask for.g  *      Returns: nonei  */z   static voidp& MakeSetValuesRequest(w, width, height)	 Widget w;l Dimension width, height; {m0     SimpleMenuWidget smw = (SimpleMenuWidget) w;     Arg arglist[2];l%     Cardinal num_args = (Cardinal) 0;s     3     if ( !smw->simple_menu.recursive_set_values ) {;D 	if ( (smw->core.width != width) || (smw->core.height != height) ) {2 	    smw->simple_menu.recursive_set_values = TRUE;@ 	    XtSetArg(arglist[num_args], XtNwidth, width);   num_args++;@ 	    XtSetArg(arglist[num_args], XtNheight, height); num_args++;' 	    XtSetValues(w, arglist, num_args);  	}& 	else if (XtIsRealized( (Widget) smw))= 	    Redisplay((Widget) smw, (XEvent *) NULL, (Region) NULL);e     }t2     smw->simple_menu.recursive_set_values = FALSE; }   # /*      Function Name: GetMenuWidthCC  *      Description: Sets the length of the widest entry in pixels. .  *      Arguments: w - the simple menu widget.  *      Returns: width of menu.   */t   static Dimension GetMenuWidth(w, w_ent) Widget w, w_ent; { ,     SmeObject cur_entry = (SmeObject) w_ent;0     SimpleMenuWidget smw = (SimpleMenuWidget) w;,     Dimension width, widest = (Dimension) 0;     SmeObject * entry;     '     if ( smw->simple_menu.menu_width )   	return(smw->core.width);         ForAllChildren(smw, entry) { 	XtWidgetGeometry preferred;  . 	if (!XtIsManaged( (Widget) *entry)) continue; 	s 	if (*entry != cur_entry) { 8 	    XtQueryGeometry((Widget) *entry, NULL, &preferred); 	    e* 	    if (preferred.request_mode & CWWidth) 		width = preferred.width;	 	    elsel$ 		width = (*entry)->rectangle.width; 	} 	else*' 	    width = (*entry)->rectangle.width;) 	  	if ( width > widest ) 	    widest = width;     }t          return(widest);y }r  $ /*      Function Name: GetMenuHeightC  *      Description: Sets the length of the widest entry in pixels.).  *      Arguments: w - the simple menu widget.  *      Returns: width of menu.	  */n   static Dimension GetMenuHeight(w)	 Widget w;> {e0     SimpleMenuWidget smw = (SimpleMenuWidget) w;     SmeObject * entry;     Dimension height;g     %     if (smw->simple_menu.menu_height)  	return(smw->core.height);  J     height = smw->simple_menu.top_margin + smw->simple_menu.bottom_margin;     *     if (smw->simple_menu.row_height == 0)  	ForAllChildren(smw, entry) ( 	    if (XtIsManaged ((Widget) *entry)) ' 		height += (*entry)->rectangle.height; 	     else tE 	height += smw->simple_menu.row_height * smw->composite.num_children;  	t     return(height);t }   $ /*      Function Name: GetEventEntryJ  *      Description: Gets an entry given an event that has X and Y coords..  *      Arguments: w - the simple menu widget.%  *                 event - the event.b1  *      Returns: the entry that this point is in.b  */g   static SmeObject GetEventEntry(w, event)n	 Widget w;a XEvent * event;r {      Position x_loc, y_loc;0     SimpleMenuWidget smw = (SimpleMenuWidget) w;     SmeObject * entry;          switch (event->type) {     case MotionNotify: 	x_loc = event->xmotion.x; 	y_loc = event->xmotion.y; 	break;z     case EnterNotify:u     case LeaveNotify:e 	x_loc = event->xcrossing.x; 	y_loc = event->xcrossing.y; 	break;      case ButtonPress:p     case ButtonRelease:e 	x_loc = event->xbutton.x; 	y_loc = event->xbutton.y; 	break;w     default:, 	XtAppError(XtWidgetToApplicationContext(w),/ 		   "Unknown event type in GetEventEntry().");) 	break;      }(     I     if ( (x_loc < 0) || (x_loc >= (int)smw->core.width) || (y_loc < 0) ||U# 	(y_loc >= (int)smw->core.height) )u 	return(NULL);           ForAllChildren(smw, entry) {. 	if (!XtIsManaged ((Widget) *entry)) continue;  ( 	if ( ((*entry)->rectangle.y < y_loc) &&I 	    ((*entry)->rectangle.y + (int) (*entry)->rectangle.height > y_loc) ) , 	    if ( *entry == smw->simple_menu.label ). 		return(NULL);	/* cannot select the label. */	 	    elsen 		return(*entry);,     }t          return(NULL);e }s