 /*B  * $XConsortium: Repeater.c,v 1.8 91/03/14 16:48:04 converse Exp $  *7  * Copyright 1990 Massachusetts Institute of Technology   *N  * Permission to use, copy, modify, distribute, and sell this software and itsM  * documentation for any purpose is hereby granted without fee, provided that E  * the above copyright notice appear in all copies and that both that C  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION J  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *(  * Author:  Jim Fulton, MIT X Consortium  *  8  * This widget is used for press-and-hold style buttons.  */   @ #include <X11/IntrinsicP.h>		/* for toolkit inheritance stuff */: #include <X11/StringDefs.h>		/* for XtN and XtC defines */@ #include <X11/Xaw/XawInit.h>		/* for XawInitializeWidgetSet() */( #include <X11/Xaw/RepeaterP.h>		/* us */  ( static void tic();			/* clock timeout */   #define DO_CALLBACK(rw) \ A     XtCallCallbackList ((Widget) rw, rw->command.callbacks, NULL)      #define ADD_TIMEOUT(rw,delay) \ @   XtAppAddTimeOut (XtWidgetToApplicationContext ((Widget) rw), \0 		   (unsigned long) delay, tic, (XtPointer) rw)   #define CLEAR_TIMEOUT(rw) \    if ((rw)->repeater.timer) { \ /       XtRemoveTimeOut ((rw)->repeater.timer); \ !       (rw)->repeater.timer = 0; \    }      /*J  * Translations to give user interface of press-notify...-release_or_leave  */ $ static char defaultTranslations[] = %   "<EnterWindow>:     highlight() \n\ '    <LeaveWindow>:     unhighlight() \n\ '    <Btn1Down>:        set() start() \n\ '    <Btn1Up>:          stop() unset() ";      /*  * Actions added by this widget   */ ( static void ActionStart(), ActionStop();  ! static XtActionsRec actions[] = { 3     { "start", ActionStart },		/* trigger timers */ /     { "stop", ActionStop },		/* clear timers */  };     /*%  * New resources added by this widget   */ ! static XtResource resources[] = { : #define off(field) XtOffsetOf(RepeaterRec, repeater.field)/     { XtNdecay, XtCDecay, XtRInt, sizeof (int), 7 	off(decay), XtRImmediate, (XtPointer) REP_DEF_DECAY }, 6     { XtNinitialDelay, XtCDelay, XtRInt, sizeof (int),G 	off(initial_delay), XtRImmediate, (XtPointer) REP_DEF_INITIAL_DELAY }, =     { XtNminimumDelay, XtCMinimumDelay, XtRInt, sizeof (int), G 	off(minimum_delay), XtRImmediate, (XtPointer) REP_DEF_MINIMUM_DELAY }, 5     { XtNrepeatDelay, XtCDelay, XtRInt, sizeof (int), E 	off(repeat_delay), XtRImmediate, (XtPointer) REP_DEF_REPEAT_DELAY }, 9     { XtNflash, XtCBoolean, XtRBoolean, sizeof (Boolean), / 	off(flash), XtRImmediate, (XtPointer) FALSE }, J     { XtNstartCallback, XtCStartCallback, XtRCallback, sizeof (XtPointer),8 	off(start_callbacks), XtRImmediate, (XtPointer) NULL },H     { XtNstopCallback, XtCStopCallback, XtRCallback, sizeof (XtPointer),7 	off(stop_callbacks), XtRImmediate, (XtPointer) NULL }, 
 #undef off };     /*  * Class Methods  */   3 static void Initialize();		/* setup private data */ + static void Destroy();			/* clear timers */ 0 static Boolean SetValues();		/* set resources */  % RepeaterClassRec repeaterClassRec = {    { /* core fields */ 5     /* superclass		*/	(WidgetClass) &commandClassRec, !     /* class_name		*/	"Repeater", +     /* widget_size		*/	sizeof(RepeaterRec), 3     /* class_initialize		*/	XawInitializeWidgetSet, %     /* class_part_initialize	*/	NULL,      /* class_inited		*/	FALSE,!     /* initialize		*/	Initialize,       /* initialize_hook		*/	NULL,%     /* realize			*/	XtInheritRealize,      /* actions			*/	actions,)     /* num_actions		*/	XtNumber(actions),      /* resources		*/	resources, -     /* num_resources		*/	XtNumber(resources),      /* xrm_class		*/	NULLQUARK,       /* compress_motion		*/	TRUE,!     /* compress_exposure	*/	TRUE, #     /* compress_enterleave	*/	TRUE, "     /* visible_interest		*/	FALSE,     /* destroy			*/	Destroy,#     /* resize			*/	XtInheritResize, #     /* expose			*/	XtInheritExpose,       /* set_values		*/	SetValues,      /* set_values_hook		*/	NULL,5     /* set_values_almost	*/	XtInheritSetValuesAlmost,       /* get_values_hook		*/	NULL,     /* accept_focus		*/	NULL,      /* version			*/	XtVersion,!     /* callback_private		*/	NULL, )     /* tm_table			*/	defaultTranslations, 1     /* query_geometry		*/	XtInheritQueryGeometry, :     /* display_accelerator	*/	XtInheritDisplayAccelerator,     /* extension		*/	NULL    },   { /* simple fields */ 4     /* change_sensitive		*/	XtInheritChangeSensitive   },   { /* label fields */     /* ignore			*/	0   },   { /* command fields */     /* ignore			*/	0   },   { /* repeater fields */ $     /* ignore                   */	0   }  };  B WidgetClass repeaterWidgetClass = (WidgetClass) &repeaterClassRec;    N /*****************************************************************************N  *                                                                           *;  *			   repeater utility routines                         * N  *                                                                           *O  *****************************************************************************/    /* ARGSUSED */! static void tic (client_data, id)      XtPointer client_data;     XtIntervalId *id;  { 5     RepeaterWidget rw = (RepeaterWidget) client_data;   3     rw->repeater.timer = 0;		/* timer is removed */      if (rw->repeater.flash) {  	XtExposeProc expose; H 	expose = repeaterWidgetClass->core_class.superclass->core_class.expose;> 	XClearWindow (XtDisplay((Widget) rw), XtWindow((Widget) rw)); 	rw->command.set = FALSE; 9 	(*expose) ((Widget) rw, (XEvent *) NULL, (Region) NULL); > 	XClearWindow (XtDisplay((Widget) rw), XtWindow((Widget) rw)); 	rw->command.set = TRUE;9 	(*expose) ((Widget) rw, (XEvent *) NULL, (Region) NULL);      }      DO_CALLBACK (rw);   C     rw->repeater.timer = ADD_TIMEOUT (rw, rw->repeater.next_delay);   * 					/* decrement delay time, but clamp */     if (rw->repeater.decay) { / 	rw->repeater.next_delay -= rw->repeater.decay; : 	if (rw->repeater.next_delay < rw->repeater.minimum_delay)8 	  rw->repeater.next_delay = rw->repeater.minimum_delay;     }  }     N /*****************************************************************************N  *                                                                           *<  * 			    repeater class methods                           *N  *                                                                           *O  *****************************************************************************/    /* ARGSUSED */# static void Initialize (greq, gnew)      Widget greq, gnew; { /     RepeaterWidget new = (RepeaterWidget) gnew;   I     if (new->repeater.minimum_delay < 0) new->repeater.minimum_delay = 0; +     new->repeater.timer = (XtIntervalId) 0;  }    static void Destroy (gw)     Widget gw; { (     CLEAR_TIMEOUT ((RepeaterWidget) gw); }    /* ARGSUSED */+ static Boolean SetValues (gcur, greq, gnew)      Widget gcur, greq, gnew; { /     RepeaterWidget cur = (RepeaterWidget) gcur; /     RepeaterWidget new = (RepeaterWidget) gnew;      Boolean redisplay = FALSE;  E     if (cur->repeater.minimum_delay != new->repeater.minimum_delay) { = 	if (new->repeater.next_delay < new->repeater.minimum_delay)  : 	  new->repeater.next_delay = new->repeater.minimum_delay;     }        return redisplay;  }   N /*****************************************************************************N  *                                                                           *<  * 			     repeater action procs                           *N  *                                                                           *O  *****************************************************************************/    /* ARGSUSED */7 static void ActionStart (gw, event, params, num_params)      Widget gw;     XEvent *event;"     String *params;			/* unused */'     Cardinal *num_params;		/* unused */  { ,     RepeaterWidget rw = (RepeaterWidget) gw;       CLEAR_TIMEOUT (rw); &     if (rw->repeater.start_callbacks) B       XtCallCallbackList (gw, rw->repeater.start_callbacks, NULL);       DO_CALLBACK (rw); F     rw->repeater.timer = ADD_TIMEOUT (rw, rw->repeater.initial_delay);8     rw->repeater.next_delay = rw->repeater.repeat_delay; }      /* ARGSUSED */6 static void ActionStop (gw, event, params, num_params)     Widget gw;     XEvent *event;"     String *params;			/* unused */'     Cardinal *num_params;		/* unused */  { ,     RepeaterWidget rw = (RepeaterWidget) gw;  (     CLEAR_TIMEOUT ((RepeaterWidget) gw);%     if (rw->repeater.stop_callbacks)  A       XtCallCallbackList (gw, rw->repeater.stop_callbacks, NULL);  }   