 /*?  * $XConsortium: Panner.c,v 1.43 91/08/26 10:53:17 gildea Exp $   *7  * Copyright 1989 Massachusetts Institute of Technology   *N  * Permission to use, copy, modify, distribute, and sell this software and itsM  * documentation for any purpose is hereby granted without fee, provided that E  * the above copyright notice appear in all copies and that both that C  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION J  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *(  * Author:  Jim Fulton, MIT X Consortium  */   7 #include <X11/IntrinsicP.h>		/* for toolkit routines */ : #include <X11/StringDefs.h>		/* for XtN and XtC defines */= #include <X11/Xmu/CharSet.h>		/* for XmuCompareISOLatin1() */ > #include <X11/Xaw/XawInit.h>		/* for XawInitializeWidgetSet */& #include <X11/Xaw/PannerP.h>		/* us */( #include <X11/Xmu/Misc.h>		/* for Min */- #include <ctype.h>			/* for isascii() etc. */ $ #include <math.h>			/* for atof() */  A #if defined(ISC) && defined(SYSV) && defined(SYSV386) && __STDC__  extern double atof(char *);  #endif  $ static char defaultTranslations[] =    "<Btn1Down>:    start() \n\     <Btn1Motion>:  move() \n\%    <Btn1Up>:      notify() stop() \n\     <Btn2Down>:    abort() \n\ ,    <Key>KP_Enter: set(rubberband,toggle) \n\#    <Key>space:    page(+1p,+1p) \n\ #    <Key>Delete:   page(-1p,-1p) \n\ %    <Key>BackSpace:  page(-1p,-1p) \n\ #    <Key>Left:     page(-.5p,+0) \n\ #    <Key>Right:    page(+.5p,+0) \n\ #    <Key>Up:       page(+0,-.5p) \n\ #    <Key>Down:     page(+0,+.5p) \n\     <Key>Home:     page(0,0) ";    E static void ActionStart(), ActionStop(), ActionAbort(), ActionMove(); 6 static void ActionPage(), ActionNotify(), ActionSet();  ! static XtActionsRec actions[] = { 7     { "start", ActionStart },		/* start tmp graphics */ 4     { "stop", ActionStop },		/* stop tmp graphics */)     { "abort", ActionAbort },		/* punt */ D     { "move", ActionMove },		/* move tmp graphics on Motion event */D     { "page", ActionPage },		/* page around usually from keyboard */<     { "notify", ActionNotify },		/* callback new position */7     { "set", ActionSet },		/* set various parameters */  };     /*  * resources for the panner   */ ! static XtResource resources[] = { 7 #define poff(field) XtOffsetOf(PannerRec, panner.field) <     { XtNallowOff, XtCAllowOff, XtRBoolean, sizeof(Boolean),4 	poff(allow_off), XtRImmediate, (XtPointer) FALSE },8     { XtNresize, XtCResize, XtRBoolean, sizeof(Boolean),8 	poff(resize_to_pref), XtRImmediate, (XtPointer) TRUE },K     { XtNreportCallback, XtCReportCallback, XtRCallback, sizeof(XtPointer), 9 	poff(report_callbacks), XtRCallback, (XtPointer) NULL }, H     { XtNdefaultScale, XtCDefaultScale, XtRDimension, sizeof(Dimension),G 	poff(default_scale), XtRImmediate, (XtPointer) PANNER_DEFAULT_SCALE }, @     { XtNrubberBand, XtCRubberBand, XtRBoolean, sizeof(Boolean),6 	poff(rubber_band), XtRImmediate, (XtPointer) FALSE },=     { XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),  @ 	poff(foreground), XtRString, (XtPointer) XtDefaultBackground },J     { XtNinternalSpace, XtCInternalSpace, XtRDimension, sizeof(Dimension),6 	poff(internal_border), XtRImmediate, (XtPointer) 4 },B     { XtNlineWidth, XtCLineWidth, XtRDimension, sizeof(Dimension),1 	poff(line_width), XtRImmediate, (XtPointer) 0 }, F     { XtNcanvasWidth, XtCCanvasWidth, XtRDimension, sizeof(Dimension),3 	poff(canvas_width), XtRImmediate, (XtPointer) 0 }, H     { XtNcanvasHeight, XtCCanvasHeight, XtRDimension, sizeof(Dimension),4 	poff(canvas_height), XtRImmediate, (XtPointer) 0 },<     { XtNsliderX, XtCSliderX, XtRPosition, sizeof(Position),/ 	poff(slider_x), XtRImmediate, (XtPointer) 0 }, <     { XtNsliderY, XtCSliderY, XtRPosition, sizeof(Position),/ 	poff(slider_y), XtRImmediate, (XtPointer) 0 }, F     { XtNsliderWidth, XtCSliderWidth, XtRDimension, sizeof(Dimension),3 	poff(slider_width), XtRImmediate, (XtPointer) 0 }, H     { XtNsliderHeight, XtCSliderHeight, XtRDimension, sizeof(Dimension),4 	poff(slider_height), XtRImmediate, (XtPointer) 0 },>     { XtNshadowColor, XtCShadowColor, XtRPixel, sizeof(Pixel),B 	poff(shadow_color), XtRString, (XtPointer) XtDefaultForeground },N     { XtNshadowThickness, XtCShadowThickness, XtRDimension, sizeof(Dimension),7 	poff(shadow_thickness), XtRImmediate, (XtPointer) 2 }, L     { XtNbackgroundStipple, XtCBackgroundStipple, XtRString, sizeof(String),6 	poff(stipple_name), XtRImmediate, (XtPointer) NULL }, #undef poff  };     /*"  * widget class methods used below  */ , static void Initialize();		/* create gc's */, static void Realize();			/* create window */. static void Destroy();			/* clean up widget */7 static void Resize();			/* need to rescale ourselves */ . static void Redisplay();		/* draw ourselves */; static Boolean SetValues();		/* set all of the resources */ F static void SetValuesAlmost();		/* deal with failed setval geom req */O static XtGeometryResult QueryGeometry();  /* say how big we would like to be */   ! PannerClassRec pannerClassRec = {    { /* core fields */ 4     /* superclass		*/	(WidgetClass) &simpleClassRec,     /* class_name		*/	"Panner", )     /* widget_size		*/	sizeof(PannerRec), 3     /* class_initialize		*/	XawInitializeWidgetSet, %     /* class_part_initialize	*/	NULL,      /* class_inited		*/	FALSE,!     /* initialize		*/	Initialize,       /* initialize_hook		*/	NULL,     /* realize			*/	Realize,     /* actions			*/	actions,)     /* num_actions		*/	XtNumber(actions),      /* resources		*/	resources, -     /* num_resources		*/	XtNumber(resources),      /* xrm_class		*/	NULLQUARK,       /* compress_motion		*/	TRUE,!     /* compress_exposure	*/	TRUE, #     /* compress_enterleave	*/	TRUE, "     /* visible_interest		*/	FALSE,     /* destroy			*/	Destroy,     /* resize			*/	Resize,     /* expose			*/	Redisplay,       /* set_values		*/	SetValues,      /* set_values_hook		*/	NULL,,     /* set_values_almost	*/	SetValuesAlmost,      /* get_values_hook		*/	NULL,     /* accept_focus		*/	NULL,      /* version			*/	XtVersion,!     /* callback_private		*/	NULL, )     /* tm_table			*/	defaultTranslations, (     /* query_geometry		*/	QueryGeometry,:     /* display_accelerator	*/	XtInheritDisplayAccelerator,     /* extension		*/	NULL    },   { /* simple fields */ 4     /* change_sensitive		*/	XtInheritChangeSensitive   },   { /* panner fields */ $     /* ignore                   */	0   }  };  > WidgetClass pannerWidgetClass = (WidgetClass) &pannerClassRec;    N /*****************************************************************************N  *                                                                           *;  *			    panner utility routines                          * N  *                                                                           *O  *****************************************************************************/   A static void reset_shadow_gc (pw)	/* used when resources change */      PannerWidget pw; { &     XtGCMask valuemask = GCForeground;     XGCValues values;      unsigned long   pixels[3];  N     if (pw->panner.shadow_gc) XtReleaseGC ((Widget) pw, pw->panner.shadow_gc);  &     pixels[0] = pw->panner.foreground;*     pixels[1] = pw->core.background_pixel;(     pixels[2] = pw->panner.shadow_color;#     if (!pw->panner.stipple_name && > 	!XmuDistinguishablePixels (XtDisplay (pw), pw->core.colormap, 				    pixels, 3) && = 	XmuDistinguishablePixels (XtDisplay (pw), pw->core.colormap,  				    pixels, 2))      { " 	valuemask = GCTile | GCFillStyle; 	values.fill_style = FillTiled; < 	values.tile = XmuCreateStippledPixmap(XtScreen((Widget)pw),! 					      pw->panner.foreground, % 					      pw->core.background_pixel,  					      pw->core.depth);      }      else     {  	if (!pw->panner.line_width &&B 	    !XmuDistinguishablePixels (XtDisplay (pw), pw->core.colormap, 				       pixels, 2)) 	    pw->panner.line_width = 1;  	valuemask = GCForeground;- 	values.foreground = pw->panner.shadow_color;      } $     if (pw->panner.line_width > 0) {+ 	values.line_width = pw->panner.line_width;  	valuemask |= GCLineWidth;     }   E     pw->panner.shadow_gc = XtGetGC ((Widget) pw, valuemask, &values);  }   A static void reset_slider_gc (pw)	/* used when resources change */      PannerWidget pw; { &     XtGCMask valuemask = GCForeground;     XGCValues values;   N     if (pw->panner.slider_gc) XtReleaseGC ((Widget) pw, pw->panner.slider_gc);  .     values.foreground = pw->panner.foreground;  E     pw->panner.slider_gc = XtGetGC ((Widget) pw, valuemask, &values);  }   ? static void reset_xor_gc (pw)		/* used when resources change */      PannerWidget pw; { H     if (pw->panner.xor_gc) XtReleaseGC ((Widget) pw, pw->panner.xor_gc);  !     if (pw->panner.rubber_band) { 2 	XtGCMask valuemask = (GCForeground | GCFunction); 	XGCValues values; 	Pixel tmp;   > 	tmp = ((pw->panner.foreground == pw->core.background_pixel) ?9 	       pw->panner.shadow_color : pw->panner.foreground); 5 	values.foreground = tmp ^ pw->core.background_pixel;  	values.function = GXxor; ! 	if (pw->panner.line_width > 0) {  	    valuemask |= GCLineWidth;/ 	    values.line_width = pw->panner.line_width;  	}? 	pw->panner.xor_gc = XtGetGC ((Widget) pw, valuemask, &values);      } else { 	pw->panner.xor_gc = NULL;     }  }     ! static void check_knob (pw, knob)      register PannerWidget pw;      Boolean knob;  { 2     Position pad = pw->panner.internal_border * 2;8     Position maxx = (((Position) pw->core.width) - pad -+ 		     ((Position) pw->panner.knob_width)); 9     Position maxy = (((Position) pw->core.height) - pad - , 		     ((Position) pw->panner.knob_height));B     Position *x = (knob ? &pw->panner.knob_x : &pw->panner.tmp.x);B     Position *y = (knob ? &pw->panner.knob_y : &pw->panner.tmp.y);       /*G      * note that positions are already normalized (i.e. internal_border       * has been subtracted out)       */      if (*x < 0) *x = 0;      if (*x > maxx) *x = maxx;        if (*y < 0) *y = 0;      if (*y > maxy) *y = maxy;        if (knob) { A 	pw->panner.slider_x = (Position) (((double) pw->panner.knob_x) / ! 					  pw->panner.haspect + 0.5); A 	pw->panner.slider_y = (Position) (((double) pw->panner.knob_y) / ! 					  pw->panner.vaspect + 0.5); ; 	pw->panner.last_x = pw->panner.last_y = PANNER_OUTOFRANGE;      }  }      static void move_shadow (pw)     register PannerWidget pw;  { *     if (pw->panner.shadow_thickness > 0) {B 	int lw = pw->panner.shadow_thickness + pw->panner.line_width * 2;& 	int pad = pw->panner.internal_border;  K 	if ((int)pw->panner.knob_height > lw && (int)pw->panner.knob_width > lw) { 6 	    register XRectangle *r = pw->panner.shadow_rects;F 	    r->x = (short) (pw->panner.knob_x + pad + pw->panner.knob_width);3 	    r->y = (short) (pw->panner.knob_y + pad + lw); , 	    r->width = pw->panner.shadow_thickness;@ 	    r->height = (unsigned short) (pw->panner.knob_height - lw);	 	    r++; 3 	    r->x = (short) (pw->panner.knob_x + pad + lw); G 	    r->y = (short) (pw->panner.knob_y + pad + pw->panner.knob_height); > 	    r->width = (unsigned short) (pw->panner.knob_width - lw +# 					 pw->panner.shadow_thickness); - 	    r->height = pw->panner.shadow_thickness; $ 	    pw->panner.shadow_valid = TRUE; 	    return; 	}     } $     pw->panner.shadow_valid = FALSE; }   K static void scale_knob (pw, location, size)  /* set knob size and/or loc */      PannerWidget pw;     Boolean location, size;  {      if (location) { H 	pw->panner.knob_x = (Position) PANNER_HSCALE (pw, pw->panner.slider_x);H 	pw->panner.knob_y = (Position) PANNER_VSCALE (pw, pw->panner.slider_y);     }      if (size) {  	Dimension width, height;   # 	if (pw->panner.slider_width < 1) { 7 	    pw->panner.slider_width = pw->panner.canvas_width;  	}$ 	if (pw->panner.slider_height < 1) {9 	    pw->panner.slider_height = pw->panner.canvas_height;  	}@ 	width = Min (pw->panner.slider_width, pw->panner.canvas_width);C 	height = Min (pw->panner.slider_height, pw->panner.canvas_height);   ? 	pw->panner.knob_width = (Dimension) PANNER_HSCALE (pw, width); A 	pw->panner.knob_height = (Dimension) PANNER_VSCALE (pw, height);      } 5     if (!pw->panner.allow_off) check_knob (pw, TRUE);      move_shadow (pw);  }    static void rescale (pw)     PannerWidget pw; { .     int hpad = pw->panner.internal_border * 2;     int vpad = hpad;  $     if (pw->panner.canvas_width < 1)/       pw->panner.canvas_width = pw->core.width; %     if (pw->panner.canvas_height < 1) 1       pw->panner.canvas_height = pw->core.height;   .     if ((int)pw->core.width <= hpad) hpad = 0;/     if ((int)pw->core.height <= vpad) vpad = 0;   ;     pw->panner.haspect = ((double) pw->core.width - hpad) / & 			  (double) pw->panner.canvas_width;<     pw->panner.vaspect = ((double) pw->core.height - vpad) /' 			  (double) pw->panner.canvas_height;       scale_knob (pw, TRUE, TRUE); }     ) static void get_default_size (pw, wp, hp)      PannerWidget pw;     Dimension *wp, *hp;  { 3     Dimension pad = pw->panner.internal_border * 2; <     *wp = PANNER_DSCALE (pw, pw->panner.canvas_width) + pad;=     *hp = PANNER_DSCALE (pw, pw->panner.canvas_height) + pad;  }   - static Boolean get_event_xy (pw, event, x, y)      PannerWidget pw;     XEvent *event;     int *x, *y;  { )     int pad = pw->panner.internal_border;        switch (event->type) {       case ButtonPress:        case ButtonRelease:  	*x = event->xbutton.x - pad;  	*y = event->xbutton.y - pad; 
 	return TRUE;          case KeyPress:       case KeyRelease: 	*x = event->xkey.x - pad; 	*y = event->xkey.y - pad;
 	return TRUE;          case EnterNotify:        case LeaveNotify:  	*x = event->xcrossing.x - pad;  	*y = event->xcrossing.y - pad; 
 	return TRUE;          case MotionNotify: 	*x = event->xmotion.x - pad;  	*y = event->xmotion.y - pad; 
 	return TRUE;      }        return FALSE;  }   @ static int parse_page_string (s, pagesize, canvassize, relative)     register char *s;      int pagesize, canvassize;      Boolean *relative; { 
     char *cp;      double val = 1.0;      Boolean rel = FALSE;       /*9      * syntax:    spaces [+-] number spaces [pc\0] spaces       */   D     for (; isascii(*s) && isspace(*s); s++) ;	/* skip white space */  7     if (*s == '+' || *s == '-') {	/* deal with signs */  	rel = TRUE; 	if (*s == '-') val = -1.0;  	s++;      } 3     if (!*s) {				/* if null then return nothing */  	*relative = TRUE;
 	return 0;     }    					/* skip over numbers */B     for (cp = s; isascii(*s) && (isdigit(*s) || *s == '.'); s++) ;     val *= atof (cp);    					/* skip blanks */-     for (; isascii(*s) && isspace(*s); s++) ;        if (*s) {				/* if units */  	switch (s[0]) { 	  case 'p': case 'P': 	    val *= (double) pagesize; 	    break;    	  case 'c': case 'C':  	    val *= (double) canvassize; 	    break;  	}     }      *relative = rel;     return ((int) val);  }      #define DRAW_TMP(pw) \ { \ 2     XDrawRectangle (XtDisplay(pw), XtWindow(pw), \ 		    pw->panner.xor_gc, \> 		    (int) (pw->panner.tmp.x + pw->panner.internal_border), \> 		    (int) (pw->panner.tmp.y + pw->panner.internal_border), \3 		    (unsigned int) (pw->panner.knob_width - 1), \ 5 		    (unsigned int) (pw->panner.knob_height - 1)); \ 7     pw->panner.tmp.showing = !pw->panner.tmp.showing; \  }    #define UNDRAW_TMP(pw) \ { \ /     if (pw->panner.tmp.showing) DRAW_TMP(pw); \  }     #define BACKGROUND_STIPPLE(pw) \B   XmuLocatePixmapFile (pw->core.screen, pw->panner.stipple_name, \> 		       pw->panner.shadow_color, pw->core.background_pixel, \9 		       pw->core.depth, NULL, 0, NULL, NULL, NULL, NULL)      E #define PIXMAP_OKAY(pm) ((pm) != None && (pm) != XtUnspecifiedPixmap)     N /*****************************************************************************N  *                                                                           *<  * 			     panner class methods                            *N  *                                                                           *O  *****************************************************************************/     # static void Initialize (greq, gnew)      Widget greq, gnew; { F     PannerWidget req = (PannerWidget) greq, new = (PannerWidget) gnew;"     Dimension defwidth, defheight;  C     if (req->panner.canvas_width < 1) new->panner.canvas_width = 1; E     if (req->panner.canvas_height < 1) new->panner.canvas_height = 1; &     if (req->panner.default_scale < 1)7       new->panner.default_scale = PANNER_DEFAULT_SCALE;   2     get_default_size (req, &defwidth, &defheight);8     if (req->core.width < 1) new->core.width = defwidth;;     if (req->core.height < 1) new->core.height = defheight;   !     new->panner.shadow_gc = NULL; -     reset_shadow_gc (new);		/* shadowColor */ !     new->panner.slider_gc = NULL; ,     reset_slider_gc (new);		/* foreground */     new->panner.xor_gc = NULL;7     reset_xor_gc (new);			/* foreground ^ background */   0     rescale (new);			/* does a position check */%     new->panner.shadow_valid = FALSE; "     new->panner.tmp.doing = FALSE;$     new->panner.tmp.showing = FALSE; }     * static void Realize (gw, valuemaskp, attr)     Widget gw;     XtValueMask *valuemaskp;     XSetWindowAttributes *attr;  { (     PannerWidget pw = (PannerWidget) gw;$     Pixmap pm = XtUnspecifiedPixmap;     Boolean gotpm = FALSE;  <     if (pw->core.background_pixmap == XtUnspecifiedPixmap) {; 	if (pw->panner.stipple_name) pm = BACKGROUND_STIPPLE (pw);    	if (PIXMAP_OKAY(pm)) { " 	    attr->background_pixmap = pm;! 	    *valuemaskp |= CWBackPixmap; ! 	    *valuemaskp &= ~CWBackPixel;  	    gotpm = TRUE; 	}     } G     (*gw->core.widget_class->core_class.superclass->core_class.realize)        (gw, valuemaskp, attr);   /     if (gotpm) XFreePixmap (XtDisplay(gw), pm);  }      static void Destroy (gw)     Widget gw; { (     PannerWidget pw = (PannerWidget) gw;  +     XtReleaseGC (gw, pw->panner.shadow_gc); +     XtReleaseGC (gw, pw->panner.slider_gc); (     XtReleaseGC (gw, pw->panner.xor_gc); }      static void Resize (gw)      Widget gw; {       rescale ((PannerWidget) gw); }      /* ARGSUSED */) static void Redisplay (gw, event, region)      Widget gw;     XEvent *event;     Region region; { (     PannerWidget pw = (PannerWidget) gw;!     Display *dpy = XtDisplay(gw);      Window w = XtWindow(gw);)     int pad = pw->panner.internal_border; )     Dimension lw = pw->panner.line_width; ;     Dimension extra = pw->panner.shadow_thickness + lw * 2; C     int kx = pw->panner.knob_x + pad, ky = pw->panner.knob_y + pad;   #     pw->panner.tmp.showing = FALSE; -     XClearArea (XtDisplay(pw), XtWindow(pw),  . 		(int) pw->panner.last_x - ((int) lw) + pad, . 		(int) pw->panner.last_y - ((int) lw) + pad, 1 		(unsigned int) (pw->panner.knob_width + extra), 2 		(unsigned int) (pw->panner.knob_height + extra),	 		False); *     pw->panner.last_x = pw->panner.knob_x;*     pw->panner.last_y = pw->panner.knob_y;  9     XFillRectangle (dpy, w, pw->panner.slider_gc, kx, ky, = 		    pw->panner.knob_width - 1, pw->panner.knob_height - 1);        if (lw)      { :     	XDrawRectangle (dpy, w, pw->panner.shadow_gc, kx, ky,3 		    	(unsigned int) (pw->panner.knob_width - 1),  4 		    	(unsigned int) (pw->panner.knob_height - 1));     }   "     if (pw->panner.shadow_valid) {/ 	XFillRectangles (dpy, w, pw->panner.shadow_gc,   			 pw->panner.shadow_rects, 2);     } F     if (pw->panner.tmp.doing && pw->panner.rubber_band) DRAW_TMP (pw); }      /* ARGSUSED */+ static Boolean SetValues (gcur, greq, gnew)      Widget gcur, greq, gnew; { +     PannerWidget cur = (PannerWidget) gcur; +     PannerWidget new = (PannerWidget) gnew;      Boolean redisplay = FALSE;  ;     if (cur->panner.foreground != new->panner.foreground) {  	reset_slider_gc (new); : 	if (cur->panner.foreground != cur->core.background_pixel) 	  reset_xor_gc (new); 	redisplay = TRUE;B     } else if (cur->panner.line_width != new->panner.line_width ||C 	       cur->core.background_pixel != new->core.background_pixel) {  	reset_xor_gc (new); 	redisplay = TRUE;     } ?     if (cur->panner.shadow_color != new->panner.shadow_color) {  	reset_shadow_gc (new); : 	if (cur->panner.foreground == cur->core.background_pixel) 	  reset_xor_gc (new); 	redisplay = TRUE;     } G     if (cur->panner.shadow_thickness != new->panner.shadow_thickness) {  	move_shadow (new);  	redisplay = TRUE;     } =     if (cur->panner.rubber_band != new->panner.rubber_band) {  	reset_xor_gc (new);- 	if (new->panner.tmp.doing) redisplay = TRUE;      }   @     if ((cur->panner.stipple_name != new->panner.stipple_name ||9 	 cur->panner.shadow_color != new->panner.shadow_color || > 	 cur->core.background_pixel != new->core.background_pixel) && 	XtIsRealized(gnew)) {A 	Pixmap pm = (new->panner.stipple_name ? BACKGROUND_STIPPLE (new)  		     : XtUnspecifiedPixmap);   	if (PIXMAP_OKAY(pm)) { E 	    XSetWindowBackgroundPixmap (XtDisplay (new), XtWindow(new), pm); ' 	    XFreePixmap (XtDisplay (new), pm); 	 	} else { : 	    XSetWindowBackground (XtDisplay (new), XtWindow(new)," 				  new->core.background_pixel); 	} 	redisplay = TRUE;     }   %     if (new->panner.resize_to_pref && 9 	(cur->panner.canvas_width != new->panner.canvas_width || ; 	 cur->panner.canvas_height != new->panner.canvas_height || > 	 cur->panner.resize_to_pref != new->panner.resize_to_pref)) {= 	get_default_size (new, &new->core.width, &new->core.height);  	redisplay = TRUE;F     } else if (cur->panner.canvas_width != new->panner.canvas_width ||: 	cur->panner.canvas_height != new->panner.canvas_height ||> 	cur->panner.internal_border != new->panner.internal_border) {1 	rescale (new);			/* does a scale_knob as well */  	redisplay = TRUE;     } else {? 	Boolean loc = (cur->panner.slider_x != new->panner.slider_x || 7 		       cur->panner.slider_y != new->panner.slider_y); G 	Boolean siz = (cur->panner.slider_width != new->panner.slider_width || A 		       cur->panner.slider_height != new->panner.slider_height);  	if (loc || siz ||7 	    (cur->panner.allow_off != new->panner.allow_off &&  	     new->panner.allow_off)) {   	    scale_knob (new, loc, siz); 	    redisplay = TRUE; 	}     }        return redisplay;  }   4 static void SetValuesAlmost (gold, gnew, req, reply)     Widget gold, gnew;"     XtWidgetGeometry *req, *reply; { B     if (reply->request_mode == 0) {	/* got turned down, so cope */ 	Resize (gnew);      } M     (*pannerWidgetClass->core_class.superclass->core_class.set_values_almost)  	(gold, gnew, req, reply); }   : static XtGeometryResult QueryGeometry (gw, intended, pref)     Widget gw;&     XtWidgetGeometry *intended, *pref; { (     PannerWidget pw = (PannerWidget) gw;  .     pref->request_mode = (CWWidth | CWHeight);7     get_default_size (pw, &pref->width, &pref->height);   ;     if (((intended->request_mode & (CWWidth | CWHeight)) ==  	 (CWWidth | CWHeight)) &&" 	intended->width == pref->width &&" 	intended->height == pref->height)       return XtGeometryYes; N     else if (pref->width == pw->core.width && pref->height == pw->core.height)       return XtGeometryNo;     else       return XtGeometryAlmost; }     N /*****************************************************************************N  *                                                                           *<  * 			      panner action procs                            *N  *                                                                           *O  *****************************************************************************/    /* ARGSUSED */7 static void ActionStart (gw, event, params, num_params)      Widget gw;     XEvent *event;"     String *params;			/* unused */'     Cardinal *num_params;		/* unused */  {5(     PannerWidget pw = (PannerWidget) gw;
     int x, y;n  ,     if (!get_event_xy (pw, event, &x, &y)) {8 	XBell (XtDisplay(gw), 0);	/* should do error message */ 	return;     }n        pw->panner.tmp.doing = TRUE;.     pw->panner.tmp.startx = pw->panner.knob_x;.     pw->panner.tmp.starty = pw->panner.knob_y;=     pw->panner.tmp.dx = (((Position) x) - pw->panner.knob_x);p=     pw->panner.tmp.dy = (((Position) y) - pw->panner.knob_y);u)     pw->panner.tmp.x = pw->panner.knob_x;n)     pw->panner.tmp.y = pw->panner.knob_y; .     if (pw->panner.rubber_band) DRAW_TMP (pw); }k   /* ARGSUSED */6 static void ActionStop (gw, event, params, num_params)     Widget gw;     XEvent *event;"     String *params;			/* unused */'     Cardinal *num_params;		/* unused */S {T(     PannerWidget pw = (PannerWidget) gw;
     int x, y;A  +     if (get_event_xy (pw, event, &x, &y)) {N7 	pw->panner.tmp.x = ((Position) x) - pw->panner.tmp.dx; 7 	pw->panner.tmp.y = ((Position) y) - pw->panner.tmp.dy;T3 	if (!pw->panner.allow_off) check_knob (pw, FALSE);A     } 0     if (pw->panner.rubber_band) UNDRAW_TMP (pw);!     pw->panner.tmp.doing = FALSE;T }    /* ARGSUSED */7 static void ActionAbort (gw, event, params, num_params)      Widget gw;     XEvent *event;"     String *params;			/* unused */'     Cardinal *num_params;		/* unused *// {o(     PannerWidget pw = (PannerWidget) gw;  &     if (!pw->panner.tmp.doing) return;  0     if (pw->panner.rubber_band) UNDRAW_TMP (pw);  >     if (!pw->panner.rubber_band) {		/* restore old position */* 	pw->panner.tmp.x = pw->panner.tmp.startx;* 	pw->panner.tmp.y = pw->panner.tmp.starty;. 	ActionNotify (gw, event, params, num_params);     }e!     pw->panner.tmp.doing = FALSE;_ }D     /* ARGSUSED */6 static void ActionMove (gw, event, params, num_params)     Widget gw;1     XEvent *event;			/* must be a motion event */\"     String *params;			/* unused */'     Cardinal *num_params;		/* unused */< {>(     PannerWidget pw = (PannerWidget) gw;
     int x, y;a  &     if (!pw->panner.tmp.doing) return;  ,     if (!get_event_xy (pw, event, &x, &y)) {8 	XBell (XtDisplay(gw), 0);	/* should do error message */ 	return;     }   0     if (pw->panner.rubber_band) UNDRAW_TMP (pw);:     pw->panner.tmp.x = ((Position) x) - pw->panner.tmp.dx;:     pw->panner.tmp.y = ((Position) y) - pw->panner.tmp.dy;  "     if (!pw->panner.rubber_band) {B 	ActionNotify (gw, event, params, num_params);  /* does a check */     } else {3 	if (!pw->panner.allow_off) check_knob (pw, FALSE);  	DRAW_TMP (pw);t     }/ }t     /* ARGSUSED */6 static void ActionPage (gw, event, params, num_params)     Widget gw;!     XEvent *event;			/* unused */n     String *params;c'     Cardinal *num_params;		/* unused */k {o(     PannerWidget pw = (PannerWidget) gw;     Cardinal zero = 0;(     Boolean isin = pw->panner.tmp.doing;
     int x, y;*     Boolean relx, rely;c-     int pad = pw->panner.internal_border * 2;o       if (*num_params != 2) {d 	XBell (XtDisplay(gw), 0); 	return;     }   B     x = parse_page_string (params[0], (int) pw->panner.knob_width,+ 			   ((int) pw->core.width) - pad, &relx); C     y = parse_page_string (params[1], (int) pw->panner.knob_height,r, 			   ((int) pw->core.height) - pad, &rely);  %     if (relx) x += pw->panner.knob_x;C%     if (rely) y += pw->panner.knob_y;o  -     if (isin) {				/* if in, then use move */  	XEvent ev;u 	ev.xbutton.type = ButtonPress;n 	ev.xbutton.x = x; 	ev.xbutton.y = y;. 	ActionMove (gw, &ev, (String *) NULL, &zero);%     } else {				/* else just do it */b 	pw->panner.tmp.doing = TRUE;e 	pw->panner.tmp.x = x; 	pw->panner.tmp.y = y;2 	ActionNotify (gw, event, (String *) NULL, &zero); 	pw->panner.tmp.doing = FALSE;     }u },     /* ARGSUSED */8 static void ActionNotify (gw, event, params, num_params)     Widget gw;!     XEvent *event;			/* unused */("     String *params;			/* unused */'     Cardinal *num_params;		/* unused */W {h(     PannerWidget pw = (PannerWidget) gw;  &     if (!pw->panner.tmp.doing) return;  6     if (!pw->panner.allow_off) check_knob (pw, FALSE);)     pw->panner.knob_x = pw->panner.tmp.x;m)     pw->panner.knob_y = pw->panner.tmp.y;H     move_shadow (pw);   D     pw->panner.slider_x = (Position) (((double) pw->panner.knob_x) /$ 				      pw->panner.haspect + 0.5);D     pw->panner.slider_y = (Position) (((double) pw->panner.knob_y) /$ 				      pw->panner.vaspect + 0.5);      if (!pw->panner.allow_off) { 	Position tmp; 	d 	if (pw->panner.slider_x >4 	    (tmp = (((Position) pw->panner.canvas_width) - - 		    ((Position) pw->panner.slider_width))))h 	  pw->panner.slider_x = tmp;}6 	if (pw->panner.slider_x < 0) pw->panner.slider_x = 0; 	if (pw->panner.slider_y >5 	    (tmp = (((Position) pw->panner.canvas_height) - t. 		    ((Position) pw->panner.slider_height)))) 	  pw->panner.slider_y = tmp;R6 	if (pw->panner.slider_y < 0) pw->panner.slider_y = 0;     }k  1     if (pw->panner.last_x != pw->panner.knob_x ||i* 	pw->panner.last_y != pw->panner.knob_y) { 	XawPannerReport rep;   / 	Redisplay (gw, (XEvent*) NULL, (Region) NULL);r- 	rep.changed = (XawPRSliderX | XawPRSliderY);m$ 	rep.slider_x = pw->panner.slider_x;$ 	rep.slider_y = pw->panner.slider_y;, 	rep.slider_width = pw->panner.slider_width;. 	rep.slider_height = pw->panner.slider_height;, 	rep.canvas_width = pw->panner.canvas_width;. 	rep.canvas_height = pw->panner.canvas_height;H 	XtCallCallbackList (gw, pw->panner.report_callbacks, (XtPointer) &rep);     }t }c   /* ARGSUSED */5 static void ActionSet (gw, event, params, num_params)l     Widget gw;!     XEvent *event;			/* unused *//     String *params;s     Cardinal *num_params;y {w(     PannerWidget pw = (PannerWidget) gw;     Boolean rb;e       if (*num_params < 2 ||6 	XmuCompareISOLatin1 (params[0], "rubberband") != 0) { 	XBell (XtDisplay(gw), 0); 	return;     }e  5     if (XmuCompareISOLatin1 (params[1], "on") == 0) {* 	rb = TRUE;z=     } else if (XmuCompareISOLatin1 (params[1], "off") == 0) {a 	rb = FALSE;@     } else if (XmuCompareISOLatin1 (params[1], "toggle") == 0) { 	rb = !pw->panner.rubber_band;     } else { 	XBell (XtDisplay(gw), 0); 	return;     }	  '     if (rb != pw->panner.rubber_band) {/
 	Arg args[1]; ' 	XtSetArg (args[0], XtNrubberBand, rb);)& 	XtSetValues (gw, args, (Cardinal) 1);     }m }s