A /* $XConsortium: Paned.c,v 1.23 91/07/21 18:56:15 gildea Exp $ */   < /***********************************************************N Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,H and the Massachusetts Institute of Technology, Cambridge, Massachusetts.  +                         All Rights Reserved   F Permission to use, copy, modify, and distribute this software and its A documentation for any purpose and without fee is hereby granted,  F provided that the above copyright notice appear in all copies and that@ both that copyright notice and this permission notice appear in E supporting documentation, and that the names of Digital or MIT not be B used in advertising or publicity pertaining to distribution of the6 software without specific, written prior permission.    H DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDINGH ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALLG DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR C ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, F WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,C ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 	 SOFTWARE.   C ******************************************************************/    /*$  * Paned.c - Paned Composite Widget.  *D  * Updated and significantly modified from the Athena VPaned Widget.  *  * Date:    March 1, 1989   *  * By:      Chris D. Peterson   *          MIT X Consortium   *          kit@expo.lcs.mit.edu  */    #include <X11/IntrinsicP.h>  #include <X11/cursorfont.h>  #include <X11/StringDefs.h>    #include <X11/Xmu/Misc.h>  #include <X11/Xmu/Converters.h>    #include <X11/Xaw/XawInit.h> #include <X11/Xaw/Grip.h>  #include <X11/Xaw/PanedP.h>    #include <ctype.h>  4 typedef enum {UpLeftPane = 'U', LowRightPane = 'L', 7 	      ThisBorderOnly = 'T', AnyPane = 'A' } Direction;    #define NO_INDEX -100  #define IS_GRIP  NULL   1 #define PaneInfo(w)	((Pane)(w)->core.constraints) . #define HasGrip(w)	(PaneInfo(w)->grip != NULL)= #define IsPane(w)	((w)->core.widget_class != gripWidgetClass) , #define PaneIndex(w)	(PaneInfo(w)->position)F #define IsVert(w)       ( (w)->paned.orientation == XtorientVertical )  ! #define ForAllPanes(pw, childP) \ /   for ( (childP) = (pw)->composite.children ; \ G         (childP) < (pw)->composite.children + (pw)->paned.num_panes ; \          (childP)++ )  $ #define ForAllChildren(pw, childP) \/   for ( (childP) = (pw)->composite.children ; \ N         (childP) < (pw)->composite.children + (pw)->composite.num_children ; \         (childP)++ )  N /*****************************************************************************  *#  * Full instance record declaration   *N  ****************************************************************************/  # static char defGripTranslations[] = 3     "<Btn1Down>:		GripAction(Start, UpLeftPane) \n\ 7      <Btn2Down>:		GripAction(Start, ThisBorderOnly) \n\ 5      <Btn3Down>:		GripAction(Start, LowRightPane) \n\ 0      <Btn1Motion>:		GripAction(Move, UpLeft) \n\4      <Btn2Motion>:		GripAction(Move, ThisBorder) \n\2      <Btn3Motion>:		GripAction(Move, LowRight) \n\&      Any<BtnUp>:		GripAction(Commit)";  7 #define offset(field) XtOffsetOf(PanedRec, paned.field)   ! static XtResource resources[] = { E     {XtNinternalBorderColor, XtCBorderColor, XtRPixel, sizeof(Pixel), " 	 offset(internal_bp), XtRString, *          (XtPointer) XtDefaultForeground},M     {XtNinternalBorderWidth, XtCBorderWidth, XtRDimension, sizeof(Dimension), 4 	 offset(internal_bw), XtRImmediate, (XtPointer) 1},A     {XtNgripIndent, XtCGripIndent, XtRPosition, sizeof(Position), 5 	 offset(grip_indent), XtRImmediate, (XtPointer) 10}, >     {XtNrefigureMode, XtCBoolean, XtRBoolean, sizeof(Boolean),?          offset(refiguremode), XtRImmediate, (XtPointer) TRUE}, ?     {XtNgripTranslations, XtCTranslations, XtRTranslationTable,            sizeof(XtTranslations),O          offset(grip_translations), XtRString, (XtPointer)defGripTranslations}, L     {XtNorientation,  XtCOrientation, XtROrientation, sizeof(XtOrientation),J          offset(orientation), XtRImmediate, (XtPointer) XtorientVertical},  9     /* Cursors - both horiz and vertical have to work. */   5     {XtNcursor, XtCCursor, XtRCursor, sizeof(Cursor), -          offset(cursor), XtRImmediate, None}, 9     {XtNgripCursor, XtCCursor, XtRCursor, sizeof(Cursor), 2          offset(grip_cursor), XtRImmediate, None},A     {XtNverticalGripCursor, XtCCursor, XtRCursor, sizeof(Cursor), @          offset(v_grip_cursor), XtRString, "sb_v_double_arrow"},C     {XtNhorizontalGripCursor, XtCCursor, XtRCursor, sizeof(Cursor), @          offset(h_grip_cursor), XtRString, "sb_h_double_arrow"},  <     {XtNbetweenCursor, XtCCursor, XtRCursor, sizeof(Cursor),6          offset(adjust_this_cursor), XtRString, None},D     {XtNverticalBetweenCursor, XtCCursor, XtRCursor, sizeof(Cursor),C          offset(v_adjust_this_cursor), XtRString, "sb_left_arrow"}, F     {XtNhorizontalBetweenCursor, XtCCursor, XtRCursor, sizeof(Cursor),A          offset(h_adjust_this_cursor), XtRString, "sb_up_arrow"},   :     {XtNupperCursor, XtCCursor, XtRCursor, sizeof(Cursor),@          offset(adjust_upper_cursor), XtRString, "sb_up_arrow"},:     {XtNlowerCursor, XtCCursor, XtRCursor, sizeof(Cursor),B          offset(adjust_lower_cursor), XtRString, "sb_down_arrow"},9     {XtNleftCursor, XtCCursor, XtRCursor, sizeof(Cursor), A          offset(adjust_left_cursor), XtRString, "sb_left_arrow"}, :     {XtNrightCursor, XtCCursor, XtRCursor, sizeof(Cursor),C          offset(adjust_right_cursor), XtRString, "sb_right_arrow"},  };  
 #undef offset   B #define offset(field) XtOffsetOf(PanedConstraintsRec, paned.field)  $ static XtResource subresources[] = {=     {XtNallowResize, XtCBoolean, XtRBoolean, sizeof(Boolean), 9 	 offset(allow_resize), XtRImmediate, (XtPointer) FALSE}, 3     {XtNposition, XtCPosition, XtRInt, sizeof(int), 8          offset(position), XtRImmediate, (XtPointer) 0},5     {XtNmin, XtCMin, XtRDimension, sizeof(Dimension), A          offset(min), XtRImmediate, (XtPointer) PANED_GRIP_SIZE}, 5     {XtNmax, XtCMax, XtRDimension, sizeof(Dimension), 4          offset(max), XtRImmediate, (XtPointer) ~0},>     {XtNpreferredPaneSize, XtCPreferredPaneSize, XtRDimension,- 	 sizeof(Dimension), offset(preferred_size),  4          XtRImmediate, (XtPointer) PANED_ASK_CHILD},C     {XtNresizeToPreferred, XtCBoolean, XtRBoolean, sizeof(Boolean), B          offset(resize_to_pref), XtRImmediate, (XtPointer) FALSE},<     {XtNskipAdjust, XtCBoolean, XtRBoolean, sizeof(Boolean),?          offset(skip_adjust), XtRImmediate, (XtPointer) FALSE}, ;     {XtNshowGrip, XtCShowGrip, XtRBoolean, sizeof(Boolean), 5 	 offset(show_grip), XtRImmediate, (XtPointer) TRUE},  };  
 #undef offset   , static void ClassInitialize(), Initialize();  static void Realize(), Resize(); static void Redisplay();# static void GetGCs(), ReleaseGCs(); ) static void RefigureLocationsAndCommit();  static Boolean SetValues(); * static XtGeometryResult GeometryManager(); static void ChangeManaged(); static void InsertChild(); static void DeleteChild(); static Boolean PaneSetValues(); . static Dimension PaneSize(), GetRequestInfo();D static Boolean SatisfiesRule1(), SatisfiesRule2(), SatisfiesRule3();   static void PushPaneStack(); static void GetPaneStack();  static Boolean PopPaneStack(); static void ClearPaneStack();   ? #define SuperClass ((ConstraintWidgetClass)&constraintClassRec)    PanedClassRec panedClassRec = {     { /* core class fields */ 8     /* superclass         */   (WidgetClass) SuperClass,'     /* class name         */   "Paned", 0     /* size               */   sizeof(PanedRec),/     /* class_initialize   */   ClassInitialize, $     /* class_part init    */   NULL,%     /* class_inited       */   FALSE, *     /* initialize         */   Initialize,$     /* initialize_hook    */   NULL,'     /* realize            */   Realize, $     /* actions            */   NULL,!     /* num_actions        */   0, )     /* resources          */   resources, 3     /* resource_count     */   XtNumber(resources), )     /* xrm_class          */   NULLQUARK, $     /* compress_motion    */   TRUE,$     /* compress_exposure  */   TRUE,$     /* compress_enterleave*/   TRUE,%     /* visible_interest   */   FALSE, *     /* destroy            */   ReleaseGCs,&     /* resize             */   Resize,)     /* expose             */   Redisplay, )     /* set_values         */   SetValues, $     /* set_values_hook    */   NULL,8     /* set_values_almost  */   XtInheritSetValuesAlmost,$     /* get_values_hook    */   NULL,$     /* accept_focus       */   NULL,)     /* version            */   XtVersion, $     /* callback_private   */   NULL,$     /* tm_table           */   NULL,4     /* query_geometry	  */   XtInheritQueryGeometry,;     /* display_accelerator*/   XtInheritDisplayAccelerator, #     /* extension          */   NULL     }, {  /* composite class fields *//     /* geometry_manager   */   GeometryManager, -     /* change_managed     */   ChangeManaged, +     /* insert_child       */   InsertChild, +     /* delete_child       */   DeleteChild, #     /* extension          */   NULL     }, {  /* constraint class fields */ ,     /* subresources       */   subresources,6     /* subresource_count  */   XtNumber(subresources),;     /* constraint_size    */   sizeof(PanedConstraintsRec), $     /* initialize         */   NULL,$     /* destroy            */   NULL,-     /* set_values         */   PaneSetValues, #     /* extension          */   NULL     } };  < WidgetClass panedWidgetClass = (WidgetClass) &panedClassRec;   /* For compatibility. */= WidgetClass vPanedWidgetClass = (WidgetClass) &panedClassRec;   < /***********************************************************  *  * Private Functions.   *>  ************************************************************/  ! /*	Function Name: AdjustPanedSize -  *	Description: Adjusts the size of the pane. .  *	Arguments: pw - the paned widget to adjust.6  *                 off_size - the new off_size to use.>  *                 result_ret - result of query ** RETURNED **?  *                 on_size_ret - the new on_size ** RETURNED ** A  *                 off_size_ret - the new off_size ** RETURNED ** )  *	Returns: the amount of change in size.   */    static void D AdjustPanedSize(pw, off_size, result_ret, on_size_ret, off_size_ret) PanedWidget pw;  Dimension off_size;  XtGeometryResult * result_ret;( Dimension * on_size_ret, * off_size_ret; { <     Dimension old_size = PaneSize( (Widget) pw, IsVert(pw));     Dimension newsize = 0;     Widget * childP;$     XtWidgetGeometry request, reply;.     request.request_mode = CWWidth | CWHeight;       ForAllPanes(pw, childP) { M         int size = Max(PaneInfo(*childP)->size, (int)PaneInfo(*childP)->min); / 	AssignMin(size, (int) PaneInfo(*childP)->max); 0         newsize += size + pw->paned.internal_bw;     } %     newsize -= pw->paned.internal_bw;   !     if (newsize < 1) newsize = 1;        if ( IsVert(pw) ) { !         request.width = off_size;  	request.height = newsize;     } 
     else {          request.width = newsize; 	request.height = off_size;      }        if (result_ret != NULL) { ,       request.request_mode |= XtCWQueryOnly;  K       *result_ret = XtMakeGeometryRequest( (Widget) pw, &request, &reply );   E       if ( (newsize == old_size) || (*result_ret == XtGeometryNo) ) {  	  *on_size_ret = old_size;  	  *off_size_ret = off_size;
 	  return;       } ,       if (*result_ret != XtGeometryAlmost) {9 	  *on_size_ret = GetRequestInfo( &request, IsVert(pw) ); A       	  *off_size_ret = GetRequestInfo( &request, !IsVert(pw) ); 
 	  return;       } :       *on_size_ret = GetRequestInfo( &reply, IsVert(pw) );<       *off_size_ret = GetRequestInfo( &reply, !IsVert(pw) );
       return;      }   $     if (newsize == old_size) return;  +     if (XtMakeGeometryRequest( (Widget) pw, / 			      &request, &reply) == XtGeometryAlmost) >         XtMakeGeometryRequest( (Widget) pw, &reply, &request); }    /*	Function Name: PaneSizeA  *	Description: returns the width or height of the pane depending 7  *                   upon the orientation we are using.   *	Arguments: w - and widget. G  *                 vertical - TRUE if this is vertically oriented pane.   *	Returns: the size requested  *!  *      vertical  - return height    *      !vertical - return width  */    static Dimension PaneSize(w, vertical) 	 Widget w;  Boolean vertical;  { *     if (vertical) return (w->core.height);     return (w->core.width);  }     /*	Function Name: GetRequestInfo,  *	Description: returns request information.H  *	Arguments:  geo_struct - a geometry struct to get information out of.C  *                  vert - TRUE if this is a vertical paned widget. $  *	Returns: the request information.  */    static Dimension  GetRequestInfo(geo_struct, vert) XtWidgetGeometry * geo_struct;
 Boolean vert;  { 9     if ( vert ) return ( (Dimension) geo_struct->height); ,     return ( (Dimension) geo_struct->width); }   % /*	Function Name: ChoosePaneToResize. 7  *	Description: This function chooses a pane to resize. ?  *                   They are chosen using the following rules:   *0  *                   1) size < max && size > min,  *                   2) skip adjust == FALSE9  *                   3) widget not its prefered height && ;  *                      this change will bring it closer && ;  *                      The user has not resized this pane. 
  *            I  *                   If no widgets are found that fits all the rules then *  *                      rule #3 is broken.=  *                   If there are still no widgets found than *  *                      rule #2 is broken.-  *                   Rule #1 is never broken. C  *                   If no widgets are found then NULL is returned.   *  $  *	Arguments: pw - the paned widget.=  *                 paneindex - the index of the current pane. 3  *                 dir - direction to search first. N  *                 shrink - TRUE if we need to shrink a pane, FALSE otherwise.#  *	Returns: pane to resize or NULL.   */    static Pane . ChoosePaneToResize(pw, paneindex, dir, shrink) PanedWidget pw;  int paneindex; Direction dir; Boolean shrink;  {      Widget *childP;      int rules = 3;     Direction _dir = dir;      int _index = paneindex;   M     if ( (paneindex == NO_INDEX) || (dir == AnyPane) ) {  /* Use defaults. */ 2       _dir = LowRightPane;		/* Go up. - really. */H       _index = pw->paned.num_panes - 1;	/* Start the last pane, and work 					   backwards. */      } -     childP = pw->composite.children + _index;      while(TRUE) { /         register Pane pane = PaneInfo(*childP);          ;         if ( (rules < 3 || SatisfiesRule3(pane, shrink)) && 4 	     (rules < 2 || SatisfiesRule2(pane))         &&4 	     (SatisfiesRule1(pane, shrink))              &&? 	     ((paneindex != PaneIndex(*childP)) || (dir == AnyPane)) )  	    return(pane);   /*=  * This is counter-intuitive, but if we are resizing the pane B  * above the grip we want to choose a pane below the grip to lose,  * and visa-versa.  */   3 	if (_dir == LowRightPane) --childP; else ++childP;    /*G  * If we have come to and edge then reduce the rule set, and try again. 9  * If we are reduced the rules to none, then return NULL.   */  	 . 	if ( (childP - pw->composite.children < 0) ||B 	     (childP - pw->composite.children >= pw->paned.num_panes) ) {/ 	    if (--rules < 1)  /* less strict rules. */  	      return(NULL);. 	    childP = pw->composite.children + _index; 	}     }  }   ! /*	Function Name: StatisfiesRule1 ?  *	Description: check for to see if this pane satisfies rule 1. '  *	Arguments: pane - the pane to check. O  *                 shrink -TRUE if we want to shrink this pane, FALSE otherwise *  *	Returns: TRUE if the rule is satisfied.  */    static Boolean SatisfiesRule1(pane, shrink)
 Pane pane; Boolean shrink;  { 2   return( (shrink && (pane->size != pane->min)) ||, 	  (!shrink && (pane->size != pane->max)) ); }    ! /*	Function Name: StatisfiesRule2 ?  *	Description: check for to see if this pane satisfies rule 2. '  *	Arguments: pane - the pane to check. *  *	Returns: TRUE if the rule is satisfied.  */    static Boolean SatisfiesRule2(pane)
 Pane pane; { 8   return(!pane->skip_adjust || pane->paned_adjusted_me); }    ! /*	Function Name: StatisfiesRule3 ?  *	Description: check for to see if this pane satisfies rule 3. '  *	Arguments: pane - the pane to check. O  *                 shrink -TRUE if we want to shrink this pane, FALSE otherwise *  *	Returns: TRUE if the rule is satisfied.  */    static Boolean SatisfiesRule3(pane, shrink)
 Pane pane; Boolean shrink;  { %   return ( pane->paned_adjusted_me && 7 	   ( (shrink && ((int)pane->wp_size <= pane->size)) || 9 	     (!shrink && ((int)pane->wp_size >= pane->size))) );  }   * /*	Function Name: LoopAndRefigureChildren.I  *	Description: if we are resizing either the UpleftPane or LowRight Pane N  *                   loop through all the children to see if any will allow us$  *                   to resize them.$  *	Arguments: pw - the paned widget.K  *                 paneindex - the number of the pane border we are moving. N  *                 dir - the pane to move (either UpLeftPane or LowRightPane).<  *                 sizeused - current amount of space used. >  *                            THIS VALUE IS USED AND RETURNED.  *	Returns: none.   */    static void 5 LoopAndRefigureChildren(pw, paneindex, dir, sizeused)  PanedWidget pw;  int paneindex, *sizeused;  Direction dir; { =     int pane_size = (int) PaneSize( (Widget) pw, IsVert(pw)); -     Boolean shrink = (*sizeused > pane_size);   )     if (dir == LowRightPane) paneindex++;   O     while (*sizeused != pane_size) { /* While all panes do not fit properly. */  /*  * Choose a pane to resize. E  * First look on the Pane Stack, and then go hunting for another one. 4  * If we fail to find a pane to resize then give up.  */          Pane pane; 	int start_size; 	Dimension old; - 	Boolean rule3_ok = FALSE, from_stack = TRUE;   . 	GetPaneStack(pw, shrink, &pane, &start_size); 	if (pane == NULL) {; 	    pane = ChoosePaneToResize(pw, paneindex, dir, shrink);  	    if (pane == NULL)  1 	        return; /* no one to resize, give up. */   - 	    rule3_ok = SatisfiesRule3(pane, shrink);  	    from_stack = FALSE; 	    PushPaneStack(pw, pane);  	}     /*G  * Try to resize this pane so that all panes will fit, take min and max   * into account.  */  	old = pane->size;% 	pane->size += pane_size - *sizeused;    	if (from_stack) { 	    if (shrink) {+ 	        AssignMax(pane->size, start_size); ) 	    }			/* don't remove these braces. */ 	 	    else + 	        AssignMin(pane->size, start_size);   ; 	    if (pane->size == start_size) (void) PopPaneStack(pw);  	} 	else if (rule3_ok) {  	    if (shrink) {4 	        AssignMax(pane->size, (int) pane->wp_size);) 	    }			/* don't remove these braces. */ 	 	    else 4 	        AssignMin(pane->size, (int) pane->wp_size); 	}  9 	pane->paned_adjusted_me = (pane->size != pane->wp_size); ( 	AssignMax(pane->size, (int) pane->min);( 	AssignMin(pane->size, (int) pane->max);! 	*sizeused += (pane->size - old);      }  }   # /*	Function Name: RefigureLocations 4  *	Description: refigures all locations of children.$  *	Arguments: pw - the paned widget.<  *                 paneindex - child to start refiguring at.6  *                 dir - direction to move from child.  *	Returns: none.   *C  *      There are special arguments to paneindex and dir, they are:   *      paneindex - NO_INDEX.   *      dir   - AnyPane.  *D  *      If either of these is true then all panes may be resized andI  *      the choosing of panes procedes in reverse order starting with the   *      last child.   */    static void % RefigureLocations(pw, paneindex, dir)  PanedWidget pw;  int paneindex; Direction dir; {      register Widget *childP;>     int pane_size = (int) PaneSize( (Widget) pw, IsVert(pw) );     int sizeused = 0;      Position loc = 0;   D     if (pw->paned.num_panes == 0 || !pw->paned.refiguremode) return;   /*3  * Get an initial estimate of the size we will use.   */        ForAllPanes(pw, childP) { /         register Pane pane = PaneInfo(*childP); ( 	AssignMax(pane->size, (int) pane->min);( 	AssignMin(pane->size, (int) pane->max);< 	sizeused += (int) pane->size + (int) pw->paned.internal_bw;     } ,     sizeused -= (int) pw->paned.internal_bw;  >     if ( (dir != ThisBorderOnly) && (sizeused != pane_size) ) =       LoopAndRefigureChildren(pw, paneindex, dir, &sizeused);    /*  >  * If we still are not the right size, then tell the pane that"  * wanted to resize that it can't.  */     8     if ( (paneindex != NO_INDEX) && (dir != AnyPane) ) {= 	Pane pane = PaneInfo(*(pw->composite.children + paneindex)); #         Dimension old = pane->size;   $ 	pane->size += pane_size - sizeused;( 	AssignMax(pane->size, (int) pane->min);( 	AssignMin(pane->size, (int) pane->max); 	sizeused += pane->size - old;     }       /*K  * It is possible that the panes will not fit inside the vpaned widget, but   * we have tried out best.  *  * Assign each pane a location.   */        ForAllPanes(pw, childP) { '         PaneInfo(*childP)->delta = loc; ?         loc += PaneInfo(*childP)->size + pw->paned.internal_bw;      }  }   $ /*	Function Name: CommitNewLocations@  *	Description: Commits all of the previously figured locations.$  *	Arguments: pw - the paned widget.  *	Returns: none.   */    static void  CommitNewLocations(pw) PanedWidget pw;  {      register Widget *childP;     XWindowChanges changes;        changes.stack_mode = Above;        ForAllPanes(pw, childP) { ( 	register Pane pane = PaneInfo(*childP);6 	register Widget grip = pane->grip; /* may be NULL. */   	if (IsVert(pw)) {6 	    XtMoveWidget(*childP, (Position) 0, pane->delta);D 	    XtResizeWidget(*childP, pw->core.width, (Dimension) pane->size, 			   (Dimension) 0);   @ 	    if (HasGrip(*childP)) {	    /* Move and Display the Grip */= 	        changes.x = pw->core.width - pw->paned.grip_indent - ; 		            grip->core.width - grip->core.border_width*2; : 		changes.y = (*childP)->core.y + (*childP)->core.height -> 		            grip->core.height/2 - grip->core.border_width +  			    pw->paned.internal_bw/2;  	    } 	} 	else { 6 	    XtMoveWidget(*childP, pane->delta, (Position) 0);E 	    XtResizeWidget(*childP, (Dimension) pane->size, pw->core.height,  			   (Dimension) 0);     @ 	    if (HasGrip(*childP)) {	    /* Move and Display the Grip */@ 	        changes.x = (*childP)->core.x + (*childP)->core.width -D 	                    grip->core.width/2 - grip->core.border_width +  			    pw->paned.internal_bw/2; 7 		changes.y = pw->core.height - pw->paned.grip_indent - C 	                    grip->core.height - grip->core.border_width*2;  	    } 	}   /*G  * This should match XtMoveWidget, except that we're also insuring the  &  * grip is Raised in the same request.  */    	if (HasGrip(*childP)) { 	    grip->core.x = changes.x; 	    grip->core.y = changes.y;  " 	    if (XtIsRealized(pane->grip))G 	        XConfigureWindow( XtDisplay(pane->grip), XtWindow(pane->grip), * 				  CWX | CWY | CWStackMode, &changes ); 	}     }      ClearPaneStack(pw);  }   , /*	Function Name: RefigureLocationsAndCommit=  *	Description: Refigures all locations in a paned widget and .  *                   commits them immediately.$  *	Arguments: pw - the paned widget.  *	Returns: none  *D  *      This function does nothing if any of the following are true.   *      o refiguremode is false.#  *      o The widget is unrealized. 1  *      o There are no panes is the paned widget.   *@  *      NOTE: This is the resize Procedure for the Paned widget.  */    static void  RefigureLocationsAndCommit(w) 	 Widget w;  { %     PanedWidget pw = (PanedWidget) w; ?     if (pw->paned.refiguremode && XtIsRealized( (Widget) pw) &&  	pw->paned.num_panes > 0 ) {* 	RefigureLocations(pw, NO_INDEX, AnyPane); 	CommitNewLocations(pw);     }  }    /*	Function Name: _DrawRect <  *	Description: Draws a rectangle in the proper orientation.$  *	Arguments: pw - the paned widget.0  *                 gc - gc to used for the draw.K  *                 on_olc, off_loc - location of upper left corner of rect.69  *                 on_size, off_size - size of rectangle.*  *	Returns: none  */*   static void75 _DrawRect(pw, gc, on_loc, off_loc, on_size, off_size)c PanedWidget pw;  GC gc; int on_loc, off_loc; unsigned int on_size, off_size;. {    if (IsVert(pw)) 4     XFillRectangle(XtDisplay(pw), XtWindow(pw), gc, ) 		   off_loc, on_loc, off_size, on_size);    else3     XFillRectangle(XtDisplay(pw), XtWindow(pw), gc,n) 		   on_loc, off_loc, on_size, off_size);o }e  & /*	Function Name: _DrawInternalBordersA  *	Description: Draws the internal borders into the paned widget.d$  *	Arguments: pw - the paned widget.:  *                 gc - the GC to use to draw the borders.  *	Returns: none.o  */t   static voidt _DrawInternalBorders(pw, gc) PanedWidget pw;I GC gc; {A     Widget *childP;T     int on_loc, off_loc;#     unsigned int on_size, off_size;    /*A  * This is an optimization.  Do not paint the internal borders if -  * they are the same color as the background.   */A  ;     if (pw->core.background_pixel == pw->paned.internal_bp)  	return;       off_loc = 0; TC     off_size = (unsigned int) PaneSize( (Widget) pw, !IsVert(pw) );O3     on_size = (unsigned int) pw->paned.internal_bw;        ForAllPanes(pw, childP) {*D         on_loc = IsVert(pw) ? (*childP)->core.y : (*childP)->core.x; 	on_loc -= (int) on_size;d  8 	_DrawRect( pw, gc, on_loc, off_loc, on_size, off_size);     }: }    /* ,I  * This allows good reuse of code, as well as descriptive function names.*  */   O #define DrawInternalBorders(pw) _DrawInternalBorders((pw), (pw)->paned.normgc);rO #define EraseInternalBorders(pw) _DrawInternalBorders((pw), (pw)->paned.invgc);1  ! /*	Function Name: _DrawTrackLines/F  *	Description: Draws the lines that animate the pane borders when the%  *                   grips are moved.{$  *	Arguments: pw - the Paned widget.D  *                 erase - if True then just erase track lines, else(  *                         draw them in.  *	Returns: none.	  */e   static voidt _DrawTrackLines(pw, erase) PanedWidget pw;i Boolean erase; {      Widget *childP;w     Pane pane;     int on_loc, off_loc;#     unsigned int on_size, off_size;        off_loc = 0;3     off_size = PaneSize( (Widget) pw, !IsVert(pw));        ForAllPanes(pw, childP) { !         pane = PaneInfo(*childP);e2 	if ( erase || (pane->olddelta != pane->delta) ) {& 	    on_size = pw->paned.internal_bw;  	    if (!erase) {> 	        on_loc = PaneInfo(*childP)->olddelta - (int) on_size;  " 		_DrawRect( pw, pw->paned.flipgc,) 			  on_loc, off_loc, on_size, off_size);p 	    }  7 	    on_loc = PaneInfo(*childP)->delta - (int) on_size;*  $ 	    _DrawRect(pw, pw->paned.flipgc,, 		      on_loc, off_loc, on_size, off_size);  " 	    pane->olddelta = pane->delta; 	}     }* }*   /* *I  * This allows good reuse of code, as well as descriptive function names.   */   8 #define DrawTrackLines(pw) _DrawTrackLines((pw), FALSE);8 #define EraseTrackLines(pw) _DrawTrackLines((pw), TRUE);  " /*	Function Name: GetEventLocation:  *	Description: Converts and event to an x and y location.$  *	Arguments: pw - the paned widget.1  *                 event - a pointer to an event.L9  *	Returns: if this is a vertical pane then (y) else (x).f  */f  
 static int GetEventLocation(pw, event)d PanedWidget pw;s XEvent *event; { 
     int x, y;e       switch (event->xany.type) {R         case ButtonPress:f 	case ButtonRelease: t&             x = event->xbutton.x_root; 	    y = event->xbutton.y_root;r 	    break;d 	case KeyPress:s 	case KeyRelease:      	    x = event->xkey.x_root; 	    y = event->xkey.y_root; 	    break;t         case MotionNotify:   	    x = event->xmotion.x_root;_ 	    y = event->xmotion.y_root;) 	    break;X 	default:	     	    x = pw->paned.start_loc;B 	    y = pw->paned.start_loc;u     },     if (IsVert(pw))          return(y);     return(x); }   % /*	Function Name: StartGripAdjustment 5  *	Description: Starts the grip adjustment procedure.a$  *	Arguments: pw - the paned widget.3  *                 grip - the grip widget selected.i@  *                 dir - the direction that we are to be moving.  *	Returns: none.e  */P   static voidt" StartGripAdjustment(pw, grip, dir) PanedWidget pw;l Widget grip; Direction dir; {s     Widget *childP;s     Cursor cursor;  <     pw->paned.whichadd = pw->paned.whichsub = (Widget) NULL;  3     if (dir == ThisBorderOnly || dir == UpLeftPane)oC       pw->paned.whichadd = pw->composite.children[PaneIndex(grip)]; 5     if (dir == ThisBorderOnly || dir == LowRightPane)(G       pw->paned.whichsub = pw->composite.children[PaneIndex(grip) + 1];u   /*  * Change the cursor.i  */C       if (XtIsRealized(grip)) {c         if ( IsVert(pw) ) {l 	    if (dir == UpLeftPane) 0 	        cursor = pw->paned.adjust_upper_cursor;# 	    else if (dir == LowRightPane) t2   	        cursor = pw->paned.adjust_lower_cursor; 	    else {,3 	        if ( pw->paned.adjust_this_cursor == None)r. 		    cursor = pw->paned.v_adjust_this_cursor; 		else, 		    cursor = pw->paned.adjust_this_cursor; 	    } 	} 	else {_ 	    if (dir == UpLeftPane) / 	        cursor = pw->paned.adjust_left_cursor;s# 	    else if (dir == LowRightPane)  2   	        cursor = pw->paned.adjust_right_cursor; 	    else {X2 	        if (pw->paned.adjust_this_cursor == None). 		    cursor = pw->paned.h_adjust_this_cursor; 		else, 		    cursor = pw->paned.adjust_this_cursor; 	    } 	}     8 	XDefineCursor(XtDisplay(grip), XtWindow(grip), cursor);     }t       EraseInternalBorders(pw);X     ForAllPanes(pw, childP) *         PaneInfo(*childP)->olddelta = -99; }t  $ /*	Function Name: MoveGripAdjustmentJ  *	Description: This routine moves all panes around when a grip is moved. $  *	Arguments: pw - the paned widget.6  *                 grip - the grip that we are moving.N  *                 dir - the direction the pane we are interested is w.r.t the  *                       grip.A  *                 loc - location of pointer in proper direction.e  *	Returns: none.,  */i   static void,& MoveGripAdjustment(pw, grip, dir, loc) PanedWidget pw;  Widget grip; Direction dir; int loc; {,)     int diff, add_size = 0, sub_size = 0;   %     diff = loc - pw->paned.start_loc;i       if (pw->paned.whichadd) D         add_size = PaneSize(pw->paned.whichadd, IsVert(pw) ) + diff;       if (pw->paned.whichsub) D         sub_size = PaneSize(pw->paned.whichsub, IsVert(pw) ) - diff;   /*E  * If moving this border only then do not allow either of the bordersX,  * to go beyond the min or max size allowed.  */t  $     if ( (dir == ThisBorderOnly) ) {0       int old_add_size = add_size, old_sub_size;  C       AssignMax(add_size, (int) PaneInfo(pw->paned.whichadd)->min);oC       AssignMin(add_size, (int) PaneInfo(pw->paned.whichadd)->max); $       if (add_size != old_add_size) ' 	  sub_size += old_add_size - add_size;e         old_sub_size = sub_size;C       AssignMax(sub_size, (int) PaneInfo(pw->paned.whichsub)->min);eC       AssignMin(sub_size, (int) PaneInfo(pw->paned.whichsub)->max);rI       if (sub_size != old_sub_size) return; /* Abort to current sizes. */t     };       if (add_size != 0)6         PaneInfo(pw->paned.whichadd)->size = add_size;     if (sub_size != 0)6         PaneInfo(pw->paned.whichsub)->size = sub_size;0     RefigureLocations(pw, PaneIndex(grip), dir);     DrawTrackLines(pw);k }   & /*	Function Name: CommitGripAdjustment,  *	Description: Commits the grip adjustment.$  *	Arguments: pw - the paned widget.  *	Returns: none  */    static void  CommitGripAdjustment(pw) PanedWidget pw;s {r     EraseTrackLines(pw);     CommitNewLocations(pw);a     DrawInternalBorders(pw); 	    /*H  * Since the user selected this size then use it as the preferred size.   */n       if (pw->paned.whichadd) {t1         Pane pane = PaneInfo(pw->paned.whichadd);E 	pane->wp_size = pane->size;     }i     if (pw->paned.whichsub) {k1         Pane pane = PaneInfo(pw->paned.whichsub);i 	pane->wp_size = pane->size;     }N },   /*	Function Name: HandleGrip/  *	Description: Handles the grip manipulations. 9  *	Arguments: grip - the grip widget that has been moved.*(  *                 junk - ** NOT USED **F  *                 call_data - data passed to us from the grip widget.  *	Returns: none.e  */e   /* ARGSUSED */ static voidr  HandleGrip(grip, junk, callData) Widget grip; XtPointer junk, callData;z { :     XawGripCallData call_data = (XawGripCallData)callData;2     PanedWidget pw = (PanedWidget) XtParent(grip);     int loc;     char action_type;      Cursor cursor;     Direction direction;     Arg arglist[1];t  (     action_type = *call_data->params[0];  A     if (call_data->num_params == 0                             || ; 	(action_type == 'C' && call_data->num_params != 1)      ||/4 	(action_type != 'C' && call_data->num_params != 2))K       	XtError( "Paned GripAction has been passed incorrect parameters." );*  A     if (islower(action_type)) action_type = toupper(action_type);/  >     loc = GetEventLocation(pw, (XEvent *) (call_data->event));       if (action_type != 'C') { & 	if ( isupper(*call_data->params[1]) )1 	  direction = (Direction) *call_data->params[1];  	elsee: 	  direction = (Direction) toupper(*call_data->params[1]);     }*       switch (action_type) {" 	case 'S':		/* Start adjustment */6             pw->paned.resize_children_to_pref = FALSE;5             StartGripAdjustment(pw, grip, direction);i  	    pw->paned.start_loc = loc;	 	    break;    	case 'M': ,2 	    MoveGripAdjustment(pw, grip, direction, loc); 	    break;n  
 	case 'C':. 	    XtSetArg(arglist[0], XtNcursor, &cursor);. 	    XtGetValues(grip, arglist, (Cardinal) 1);< 	    XDefineCursor(XtDisplay(grip), XtWindow(grip), cursor); 	    CommitGripAdjustment(pw); 	    break;*  	 	default:*< 	    XtError( "Paned GripAction(); 1st parameter invalid" );      } }*    /*	Function Name: ResortChildrenA  *	Description: Resorts the children so that all managed children   *                   are first.n$  *	Arguments: pw - the paned widget.  *	Returns: none.o  */z   static void_ ResortChildren(pw) PanedWidget pw;l {e"     Widget * unmanagedP, * childP;       unmanagedP = NULL;      ForAllChildren(pw, childP) {7        if (!IsPane(*childP) || !XtIsManaged(*childP)) {* 	   /*6 	    * We only keep track of the first unmanaged pane. 	    */c 	   if (unmanagedP == NULL)    i 	       unmanagedP = childP;        }1        else {			     /* must be a managed pane */t 	   /*> 	    * If an earlier widget was not a managed pane, then swap  	    */o! 	   if (unmanagedP != NULL) {	    # 	       Widget child = *unmanagedP;  	       *unmanagedP = *childP; 	       *childP = child;> 	       childP = unmanagedP;  /* easiest to just back-track */D 	       unmanagedP = NULL;    /* in case there is another managed */ 	   }P        }    } }i  ( /*	Function Name: ManageAndUnmanageGripsE  *	Description: This function manages and unmanages the grips so that M  *                   the managed state of each grip matches that of its pane. $  *	Arguments: pw - the paned widget.  *	Returns: none.   */q   static void    ManageAndUnmanageGrips(pw) PanedWidget pw;t { -    WidgetList managed_grips, unmanaged_grips; *    Widget *managedP, *unmanagedP, *childP;    Cardinal alloc_size;u  K    alloc_size = (Cardinal) sizeof(Widget) * pw->composite.num_children / 2;r@    managedP = managed_grips = (WidgetList) XtMalloc(alloc_size);D    unmanagedP = unmanaged_grips = (WidgetList) XtMalloc(alloc_size);      ForAllChildren(pw, childP) /        if (IsPane(*childP) && HasGrip(*childP))s  	   if ( XtIsManaged(*childP) ) . 	       *managedP++ = PaneInfo(*childP)->grip; 	   else0 	       *unmanagedP++ = PaneInfo(*childP)->grip;     #    if (managedP != managed_grips) {,F        *unmanagedP++ = *--managedP;   /* Last grip is never managed */O        XtManageChildren( managed_grips, (Cardinal)(managedP - managed_grips) );t    }  %    if (unmanagedP != unmanaged_grips)e+        XtUnmanageChildren( unmanaged_grips, 1 			   (Cardinal)(unmanagedP - unmanaged_grips) );t  !    XtFree((char *)managed_grips); #    XtFree((char *)unmanaged_grips);h }h   /*	Function Name: CreateGrip&  *	Description: Creates a grip widget.G  *	Arguments: child - the child that wants a grip to be created for it.   *	Returns: none.t  */y   static void  CreateGrip(child)i
 Widget child;* {*3     PanedWidget pw = (PanedWidget) XtParent(child);      Arg arglist[2];      Cardinal num_args = 0;     Cursor cursor;      oN     XtSetArg(arglist[num_args], XtNtranslations, pw->paned.grip_translations);     num_args++; 3     if ( (cursor = pw->paned.grip_cursor) == None )          if (IsVert(pw))o& 	    cursor = pw->paned.v_grip_cursor; 	elsec& 	    cursor = pw->paned.h_grip_cursor;  3     XtSetArg(arglist[num_args], XtNcursor, cursor);t     num_args++;hO     PaneInfo(child)->grip = XtCreateWidget("grip", gripWidgetClass, (Widget)pw,) 					   arglist, num_args);c     6     XtAddCallback(PaneInfo(child)->grip, XtNcallback, # 		  HandleGrip, (XtPointer) child);i }s   /*	Function Name: GetGCs  *	Description: Gets new GC's.#  *	Arguments: w - the paned widget.t  *	Returns: none.t  */i   static void 	 GetGCs(w)T	 Widget w;s {u%     PanedWidget pw = (PanedWidget) w;      XtGCMask valuemask;x     XGCValues values;    /*/  * Draw pane borders in internal border color.    */   /     values.foreground = pw->paned.internal_bp;	      valuemask = GCForeground;i6     pw->paned.normgc = XtGetGC(w, valuemask, &values);   /*-  * Erase pane borders with background color.    */   3     values.foreground = pw->core.background_pixel;	      valuemask = GCForeground;b5     pw->paned.invgc = XtGetGC(w, valuemask, &values);e   /*O  * Draw Track lines (animate pane borders) in internal border color ^ bg color.1  */e       values.function = GXinvert;IJ     values.plane_mask = pw->paned.internal_bp ^ pw->core.background_pixel;.     values.subwindow_mode = IncludeInferiors; ;     valuemask = GCPlaneMask | GCFunction | GCSubwindowMode;c6     pw->paned.flipgc = XtGetGC(w, valuemask, &values); }   ' /*	Function Name: SetChildrenPrefSizes. 9  *	Description: Sets the preferred sizes of the children. $  *	Arguments: pw - the paned widget.  *	Returns: none.e  */    static void;" SetChildrenPrefSizes(pw, off_size) PanedWidget pw;h Dimension off_size;  {;     Widget * childP;     Boolean vert = IsVert(pw);$     XtWidgetGeometry request, reply;       ForAllPanes(pw, childP)U:         if ( pw->paned.resize_children_to_pref          ||3 	     (PaneInfo(*childP)->size == 0)             ||S- 	     (PaneInfo(*childP)->resize_to_pref) ) {.  ? 	    if (PaneInfo(*childP)->preferred_size != PANED_ASK_CHILD) hF 	        PaneInfo(*childP)->wp_size=PaneInfo(*childP)->preferred_size; 	    else {( 	        if( vert ) {s% 		    request.request_mode = CWWidth;< 		    request.width = off_size;  		}  		else {& 		    request.request_mode = CWHeight;  		    request.height = off_size; 		}l  4 		if ((XtQueryGeometry( *childP, &request, &reply ) A 	                                         == XtGeometryAlmost) &&a9 		    (reply.request_mode = (vert ? CWHeight : CWWidth)))s@ 		    PaneInfo(*childP)->wp_size = GetRequestInfo(&reply, vert); 		else; 		    PaneInfo(*childP)->wp_size = PaneSize(*childP, vert);t 	    } e  : 	    PaneInfo(*childP)->size = PaneInfo(*childP)->wp_size; 	  } }   & /*	Function Name: ChangeAllGripCursors-  *	Description: Changes all the grip cursors.p$  *	Arguments: pw - the paned widget.  *	Returns: none  */<   static voidr ChangeAllGripCursors(pw) PanedWidget pw;c {d     Widget * childP;       ForAllPanes(pw, childP) {  	Arg arglist[1]; 	Cursor cursor;        0 	if ( (cursor = pw->paned.grip_cursor) == None ) 	    if ( IsVert(pw) )* 	        cursor = pw->paned.v_grip_cursor;	 	    elseU* 	        cursor = pw->paned.h_grip_cursor;   	if (HasGrip (*childP)) {h- 	    XtSetArg(arglist[0], XtNcursor, cursor);aA 	    XtSetValues(PaneInfo(*childP)->grip, arglist, (Cardinal) 1);u 	}     }  }(       = /************************************************************   *)  * Stack Manipulation routines (Private).   *>  ************************************************************/   /*	Function Name: PushPaneStackk3  *	Description: Pushes a value onto the pane stack. $  *	Arguments: pw - the paned widget.7  *                 pane - the pane that we are pushing.n  *	Returns: none.   */    static voide PushPaneStack(pw, pane)s PanedWidget pw;o
 Pane pane; {s@   PaneStack * stack = (PaneStack *) XtMalloc(sizeof(PaneStack));      stack->next = pw->paned.stack;   stack->pane = pane; !   stack->start_size = pane->size;      pw->paned.stack = stack; }*   /*	Function Name: GetPaneStack7  *	Description: Gets the top value from the pane stack.u$  *	Arguments: pw - the paned widget.@  *                 shrink - TRUE if we want to shrink this pane,,  *                          FALSE otherwise.7  * ** RETURNED **  pane - the pane that we are popping.sD  * ** RETURNED **  start_size - the size that this pane started at.   *	Returns: none.   */    static void * GetPaneStack(pw, shrink, pane, start_size) PanedWidget pw;  Boolean shrink;A Pane * pane; int * start_size;  { !   if (pw->paned.stack == NULL) { e     *pane = NULL;      return;g   }*      *pane = pw->paned.stack->pane;,   *start_size = pw->paned.stack->start_size;  <   if (shrink != ((*pane)->size > *start_size)) *pane = NULL; }    /*	Function Name: PopPaneStack5  *	Description: Pops the top item off the pane stack.v$  *	Arguments: pw - the paned widget.>  *	Returns: TRUE if this is not the last element on the stack.  */    static Boolean PopPaneStack(pw) PanedWidget pw;e {W&   PaneStack * stack = pw->paned.stack;  #   if (stack == NULL) return(FALSE);       pw->paned.stack = stack->next;   XtFree((char*)stack);d  -   if (pw->paned.stack == NULL) return(FALSE);o   return(TRUE);* }o    /*	Function Name: ClearPaneStack8  *	Description: removes all entries from the pane stack.$  *	Arguments: pw - the paned widget.  *	Returns: none  */    static voidn ClearPaneStack(pw) PanedWidget pw;  {B   while(PopPaneStack(pw)); }t  = /************************************************************i  *  * Semi-public routines.    *>  ************************************************************/  ! /*	Function Name: ClassInitialize <  *	Description: The Paned widgets class initialization proc.  *	Arguments: none.t  *	Returns: none.P  */n   static void  ClassInitialize()T {t     XawInitializeWidgetSet();pI     XtAddConverter( XtRString, XtROrientation, XmuCvtStringToOrientation,; 		    NULL, (Cardinal)0 ); }i  < /* The Geometry Manager only allows changes after Realize if4  * allow_resize is True in the constraints record.    * t   * For vertically paned widgets:  *A  * It only allows height changes, but offers the requested heighttC  * as a compromise if both width and height changes were requested.   */  * For horizontal widgets the converse is true.-A  * As all good Geometry Managers should, we will return No if the B  * request will have no effect; i.e. when the requestor is already  * of the desired geometry.e  */a  : static XtGeometryResult GeometryManager(w, request, reply)	 Widget w;-" XtWidgetGeometry *request, *reply; { /     PanedWidget pw = (PanedWidget) XtParent(w);a0     XtGeometryMask mask = request->request_mode;3     Dimension old_size, old_wpsize, old_paned_size;n     Pane pane = PaneInfo(w);'     register Boolean vert = IsVert(pw);.      Dimension on_size, off_size;     XtGeometryResult result;     Boolean almost = FALSE;r   /*A  * If any of the following is true, disallow the geometry change.e  *I  * o The paned widget is realized and allow_resize is false for the pane.e1  * o The child did not ask to change the on_size.o2  * o The request is not a width or height request.8  * o The requested size is the same as the current size.  */a  D     if ( (XtIsRealized((Widget)pw) && !pane->allow_resize)        ||= 	 !(mask & ((vert) ? CWHeight : CWWidth))                  ||tD          (mask & ~(CWWidth | CWHeight))                           ||B          (GetRequestInfo(request, vert) ==  PaneSize(w, vert)) ) {         return XtGeometryNo;     }   2     old_paned_size = PaneSize( (Widget) pw, vert);     old_wpsize = pane->wp_size;      old_size = pane->size;  ?     pane->wp_size = pane->size = GetRequestInfo(request, vert);M  H     AdjustPanedSize(pw, PaneSize((Widget) pw, !vert), &result, &on_size, 		    &off_size);    /*;  * Fool the Refigure Locations proc to thinking that we arei  * a different on_size;s  */e        if (result != XtGeometryNo)  	if (vert) ( 	    pw->core.height = on_size;  	else  	    pw->core.width = on_size;     1     RefigureLocations(pw, PaneIndex(w), AnyPane);i   /* ..  * Set up reply struct and reset core on_size.  */!          if (vert) {a)         pw->core.height = old_paned_size;n#         reply->height = pane->size;a 	reply->width = off_size;=     }i
     else {(         pw->core.width = old_paned_size;!         reply->height = off_size;n 	reply->width = pane->size;s	     }        /*&  * IF either of the following is true.  *G  * o There was a "off_size" request and the new "off_size" is different   *   from that requested.oH  * o There was no "off_size" request and the new "off_size" is different  * lB  * o The "on_size" we will allow is different from that requested.  * w  * THEN: set almostF  */o  /     if ( !((vert ? CWWidth : CWHeight) & mask))          if (vert) $ 	    request->width = w->core.width; 	elsep& 	    request->height = w->core.height;  L     almost = GetRequestInfo(request, !vert) != GetRequestInfo(reply, !vert);K     almost |= GetRequestInfo(request, vert) != GetRequestInfo(reply, vert);   -     if ( (mask & XtCWQueryOnly) || almost ) {p 	pane->wp_size = old_wpsize; 	pane->size = old_size;>. 	RefigureLocations(pw, PaneIndex(w), AnyPane);* 	reply->request_mode = CWWidth | CWHeight;% 	if (almost) return XtGeometryAlmost;,     }r
     else {L         AdjustPanedSize(pw, PaneSize((Widget) pw, !vert), NULL, NULL, NULL);: 	CommitNewLocations( pw );	/* layout already refigured. */     }i     return XtGeometryDone; }    /* ARGSUSED */$ static void Initialize(request, new) Widget request, new; {l&     PanedWidget pw = (PanedWidget)new;       GetGCs( (Widget) pw);h  )     pw->paned.recursively_called = False;p     pw->paned.stack = NULL; -     pw->paned.resize_children_to_pref = TRUE;d     pw->paned.num_panes = 0; }z   static void ! Realize(w, valueMask, attributes)e	 Widget w;  Mask *valueMask;! XSetWindowAttributes *attributes;  {/%     PanedWidget pw = (PanedWidget) w;      Widget * childP;  :     if ((attributes->cursor = (pw)->paned.cursor) != None) 	*valueMask |= CWCursor;  A     (*SuperClass->core_class.realize) (w, valueMask, attributes);>   /*J  * Before we commit the new locations we need to realize all the panes and  * their grips.w  */2       ForAllPanes(pw, childP) {u#         XtRealizeWidget( *childP );' 	if (HasGrip (*childP))*0 	    XtRealizeWidget( PaneInfo(*childP)->grip );     }p  "     RefigureLocationsAndCommit(w);.     pw->paned.resize_children_to_pref = FALSE; } /* Realize */a   static void 
 ReleaseGCs(w)W	 Widget w;s {y-     register PanedWidget pw = (PanedWidget)w;   '     XtReleaseGC( w, pw->paned.normgc ); &     XtReleaseGC( w, pw->paned.invgc );'     XtReleaseGC( w, pw->paned.flipgc );* }    static void InsertChild(w) register Widget w; {n    Pane pane = PaneInfo(w);i  H    /* insert the child widget in the composite children list with the */H    /* superclass insert_child routine.                                */2    (*SuperClass->composite_class.insert_child)(w);      if (!IsPane(w)) return;  K    /* ||| Panes will be added in the order they are created, temporarily */e  #    if ( pane->show_grip == TRUE ) {         CreateGrip(w);e)        if (pane->min == PANED_GRIP_SIZE)  H 	   pane->min = PaneSize(pane->grip, IsVert((PanedWidget) XtParent(w)));    }	    else {)(        if (pane->min == PANED_GRIP_SIZE) 	   pane->min = 1;        pane->grip = NULL;i    }      pane->size = 0;#    pane->paned_adjusted_me = FALSE;*   } /* InsertChild */e   static void DeleteChild(w)	 Widget w;g {n8     /* remove the subwidget info and destroy the grip */    fF     if ( IsPane(w) && HasGrip(w) ) XtDestroyWidget(PaneInfo(w)->grip);  I     /* delete the child widget in the composite children list with the */*I     /* superclass delete_child routine.                                */,4     (*SuperClass->composite_class.delete_child) (w);   } /* DeleteChild */d   static void ChangeManaged(w)    Widget w; { #    PanedWidget pw = (PanedWidget)w;i    Boolean vert = IsVert(pw);n    Dimension size;    register Widget *childP;a  .    if (pw->paned.recursively_called++) return;   /*M  * If the size is zero then set it to the size of the widest or tallest pane.s  */i  7    if ( (size = PaneSize( (Widget) pw, !vert )) == 0) {A        size = 1;!        ForAllChildren(pw, childP)gF 	   if ( XtIsManaged(*childP) && (PaneSize( *childP, !vert ) > size) )* 	       size = PaneSize( *childP, !vert );    }      ManageAndUnmanageGrips(pw);(    pw->paned.recursively_called = False;    ResortChildren(pw);		      pw->paned.num_panes = 0;a    ForAllChildren(pw, childP)         if ( IsPane(*childP) )a! 	   if ( XtIsManaged(*childP) ) { & 	       Pane pane = PaneInfo(*childP); 	       if (HasGrip(*childP));: 		   PaneInfo(pane->grip)->position = pw->paned.num_panes;D 	       pane->position = pw->paned.num_panes; /*TEMPORY -CDP 3/89 */ 	       pw->paned.num_panes++; 	   }  	   else2 	       break;		/* This list is already sorted. */  0    SetChildrenPrefSizes( (PanedWidget) w, size);   /*   * ForAllPanes can now be used.   */f  +    if ( PaneSize((Widget) pw, vert) == 0 ) o3        AdjustPanedSize(pw, size, NULL, NULL, NULL);s  #    if (XtIsRealized( (Widget) pw)) (1        RefigureLocationsAndCommit( (Widget) pw); r   } /* ChangeManaged */r   /*	Function Name: Resize/  *	Description: The paned widget's resize proc. #  *	Arguments: w - the paned widget.w  *	Returns: none.i  */t   static void 	 Resize(w)*	 Widget w;  { *     SetChildrenPrefSizes( (PanedWidget) w,- 			  PaneSize(w, !IsVert((PanedWidget) w)) );r"     RefigureLocationsAndCommit(w); }*   /* ARGSUSED */ static voidh Redisplay(w, event, region)*	 Widget w;c XEvent * event;			/* unused. */) Region region;			/* unused. */ { *     DrawInternalBorders( (PanedWidget) w); }n   /* ARGSUSED */ static Boolean t SetValues(old, request, new) Widget old, request, new;P {S+     PanedWidget old_pw = (PanedWidget) old;l+     PanedWidget new_pw = (PanedWidget) new;(     Boolean redisplay = FALSE;  M     if ( (old_pw->paned.cursor != new_pw->paned.cursor) && XtIsRealized(new))!K         XDefineCursor(XtDisplay(new), XtWindow(new), new_pw->paned.cursor);	  D     if ( (old_pw->paned.internal_bp != new_pw->paned.internal_bp) ||F 	 (old_pw->core.background_pixel != new_pw->core.background_pixel) ) {         ReleaseGCs(old);
 	GetGCs(new);  	redisplay = TRUE;     }_  H     if ( (old_pw->paned.grip_cursor != new_pw->paned.grip_cursor)     ||B  	 (old_pw->paned.v_grip_cursor != new_pw->paned.v_grip_cursor) ||C  	 (old_pw->paned.h_grip_cursor != new_pw->paned.h_grip_cursor) ) {F%         ChangeAllGripCursors(new_pw);a     }i 	(,     if ( IsVert(old_pw) != IsVert(new_pw)) { /*A  * We are fooling the paned widget into thinking that is needs tog4  * fully refigure everything, which is what we want.  */a         if (IsVert(new_pw))t 	    new_pw->core.width = 0; 	else  	    new_pw->core.height = 0;i  . 	new_pw->paned.resize_children_to_pref = TRUE;H         ChangeManaged(new);	/* Seems weird, but does the right thing. *// 	new_pw->paned.resize_children_to_pref = FALSE;t' 	if (new_pw->paned.grip_cursor == None) " 	    ChangeAllGripCursors(new_pw); 	return(TRUE);     }e  A     if (old_pw->paned.internal_bw != new_pw->paned.internal_bw) {e@         AdjustPanedSize( new_pw, PaneSize(new, !IsVert(old_pw)), 			 NULL, NULL, NULL);(         RefigureLocationsAndCommit(new);? 	return(TRUE);		/* We have done a full configuration, return.*/      }-     D     if ( (old_pw->paned.grip_indent != new_pw->paned.grip_indent) && 	 (XtIsRealized(new)) ) { #         CommitNewLocations(new_pw);p 	redisplay = TRUE;     }t       return (redisplay);n } /* SetValues */w     /* ARGSUSED */ static Boolean    PaneSetValues(old, request, new) Widget old, request, new;n {a"     Pane old_pane = PaneInfo(old);"     Pane new_pane = PaneInfo(new);     Boolean redisplay = FALSE;  $     /* Check for new min and max. */  I     if (old_pane->min != new_pane->min || old_pane->max != new_pane->max)=@ 	XawPanedSetMinMax(new, (int)new_pane->min, (int)new_pane->max);  *     /* Check for change in XtNshowGrip. */  3     if (old_pane->show_grip != new_pane->show_grip) *         if (new_pane->show_grip == TRUE) { 	    CreateGrip(new);.' 	    if (XtIsRealized(XtParent(new))) {eB 	        if (XtIsManaged(new)) /* if paned is unrealized this will2 				       happen automatically at realize time.*/@ 		    XtManageChild(PaneInfo(new)->grip); /* manage the grip. */? 		XtRealizeWidget(PaneInfo(new)->grip); /* realize the grip. */ ; 	        CommitNewLocations( (PanedWidget) XtParent(new) );  	    } 	} 	else if ( HasGrip(old) ) {	' 	    XtDestroyWidget( old_pane->grip );o 	    new_pane->grip = NULL;- 	    redisplay = TRUE; 	}  ,   /* ||| need to look at position changes */       return(redisplay); }e  = /************************************************************   *  * Public routines.   *>  ************************************************************/  # /*	Function Name: XawPanedSetMinMaxp5  *	Description: Sets the min and max size for a pane.pF  *	Arguments: widget - the widget that is a child of the Paned widget.D  *                 min, max - the new min and max size for the pane.  *	Returns: none.w  */l   void   #if NeedFunctionPrototypes2 XawPanedSetMinMax(Widget widget, int min, int max) #elseD# XawPanedSetMinMax(widget, min, max)n Widget widget;
 int min, max;  #endif {n!     Pane pane = PaneInfo(widget);        pane->min = min;     pane->max = max;6     RefigureLocationsAndCommit( widget->core.parent ); }t  # /*	Function Name: XawPanedGetMinMax 5  *	Description: Gets the min and max size for a pane.tF  *	Arguments: widget - the widget that is a child of the Paned widget.H  ** RETURNED **    min, max - the current min and max size for the pane.  *	Returns: none.   */    void f #if NeedFunctionPrototypes4 XawPanedGetMinMax(Widget widget, int *min, int *max) #elsea# XawPanedGetMinMax(widget, min, max)n Widget widget; int    *min, *max; #endif { !     Pane pane = PaneInfo(widget);        *min = pane->min;w     *max = pane->max;t })  ) /*	Function Name: XawPanedSetRefigureModel9  *	Description: Allows a flag to be set the will inhibit  8  *                   the paned widgets relayout routine.#  *	Arguments: w - the paned widget.i9  *                 mode - if FALSE then inhibit refigure.i  *	Returns: none.n  */i   void i #if NeedFunctionPrototypes! XawPanedSetRefigureMode(Widget w,d #if NeedWidePrototypes 			int mode) #elsee 			Boolean mode) #endif #else   XawPanedSetRefigureMode(w, mode)	 Widget w; 
 Boolean mode;( #endif {i1     ((PanedWidget) w)->paned.refiguremode = mode;i$     RefigureLocationsAndCommit( w ); }w  # /*	Function Name: XawPanedGetNumSub @  *	Description: Returns the number of panes in the paned widget.#  *	Arguments: w - the paned widget.o4  *	Returns: the number of panes in the paned widget.  */    int  #if NeedFunctionPrototypes XawPanedGetNumSub(Widget w)e #elseo XawPanedGetNumSub(w)	 Widget w;; #endif {r-     return ((PanedWidget)w)->paned.num_panes;r }d  % /*	Function Name: XawPanedAllowResizepD  *	Description: Allows a flag to be set that determines if the panedH  *                   widget will allow geometry requests from this child3  *	Arguments: widget - a child of the paned widget.   *	Returns: none.r  */;   void * #if NeedFunctionPrototypes" XawPanedAllowResize(Widget widget, #if NeedWidePrototypes 		    int allow_resize)t #else  		    Boolean allow_resize)n #endif #else ) XawPanedAllowResize(widget, allow_resize)f Widget widget; Boolean allow_resize;p #endif {n2     PaneInfo(widget)->allow_resize = allow_resize; } 