C /* $XConsortium: MenuButton.c,v 1.18 91/06/22 18:03:46 rws Exp $ */    /*7  * Copyright 1989 Massachusetts Institute of Technology   *N  * Permission to use, copy, modify, distribute, and sell this software and itsM  * documentation for any purpose is hereby granted without fee, provided that E  * the above copyright notice appear in all copies and that both that C  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION J  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *  */     H /***********************************************************************  *  * MenuButton Widget  *I  ***********************************************************************/    /*4  * MenuButton.c - Source code for MenuButton widget.  *<  * This is the source code for the Athena MenuButton widget.I  * It is intended to provide an easy method of activating pulldown menus.   *  * Date:    May 2, 1989   *  * By:      Chris D. Peterson   *          MIT X Consortium     *          kit@expo.lcs.mit.edu  */    #include <stdio.h> #include <X11/IntrinsicP.h>  #include <X11/StringDefs.h>    #include <X11/Xaw/XawInit.h> #include <X11/Xaw/MenuButtoP.h>    static void ClassInitialize(); static void PopupMenu();  9 #define superclass ((CommandWidgetClass)&commandClassRec)   $ static char defaultTranslations[] = 3     "<EnterWindow>:     highlight()             \n\ 3      <LeaveWindow>:     reset()                 \n\ 2      <BtnDown>:         reset() PopupMenu()     ";  A /****************************************************************   *  * Full class record constant   *B  ****************************************************************/   /* Private Data */  6 #define offset(field) XtOffsetOf(MenuButtonRec, field)! static XtResource resources[] = {    { 9     XtNmenuName, XtCMenuName, XtRString, sizeof(String),  A     offset(menu_button.menu_name), XtRString, (XtPointer)"menu"},  };
 #undef offset   # static XtActionsRec actionsList[] =  {    {"PopupMenu",	PopupMenu} };  ) MenuButtonClassRec menuButtonClassRec = {    { 3     (WidgetClass) superclass,		/* superclass		  */	 '     "MenuButton",			/* class_name		  */ 0     sizeof(MenuButtonRec),       	/* size			  *//     ClassInitialize,			/* class_initialize	  */ )     NULL,				/* class_part_initialize  */ #     FALSE,				/* class_inited		  */       NULL,				/* initialize		  */$     NULL,				/* initialize_hook	  */(     XtInheritRealize,			/* realize		  */#     actionsList,			/* actions		  */ 0     XtNumber(actionsList),		/* num_actions		  */$     resources,				/* resources		  */0     XtNumber(resources),		/* resource_count	  */$     NULLQUARK,				/* xrm_class		  */%     FALSE,				/* compress_motion	  */ &     TRUE,				/* compress_exposure	  */)     TRUE,				/* compress_enterleave    */ &     FALSE,				/* visible_interest	  */     NULL,				/* destroy		  */ &     XtInheritResize,			/* resize		  */&     XtInheritExpose,			/* expose		  */      NULL,				/* set_values		  */$     NULL,				/* set_values_hook	  */8     XtInheritSetValuesAlmost,		/* set_values_almost	  */$     NULL,				/* get_values_hook	  */"     NULL,				/* accept_focus		  */"     XtVersion,				/* version		  */%     NULL,				/* callback_private	  */ 9     defaultTranslations,               	/* tm_table		  */ 3     XtInheritQueryGeometry,		/* query_geometry	  */ <     XtInheritDisplayAccelerator,	/* display_accelerator	  */     NULL				/* extension		  */+   },  /* CoreClass fields initialization */    { 7     XtInheritChangeSensitive		/* change_sensitive	  */  -   },  /* SimpleClass fields initialization */    { B     0,                                     /* field not used    */,   },  /* LabelClass fields initialization */   { B     0,                                     /* field not used    */.   },  /* CommandClass fields initialization */   { B     0,                                     /* field not used    */1   },  /* MenuButtonClass fields initialization */  };     /* for public consumption */F WidgetClass menuButtonWidgetClass = (WidgetClass) &menuButtonClassRec;  A /****************************************************************   *  * Private Procedures   *B  ****************************************************************/   static void ClassInitialize()  {      XawInitializeWidgetSet(); N     XtRegisterGrabAction(PopupMenu, True, ButtonPressMask | ButtonReleaseMask," 			 GrabModeAsync, GrabModeAsync); }    /* ARGSUSED */ static void ' PopupMenu(w, event, params, num_params) 	 Widget w;  XEvent * event;  String * params; Cardinal * num_params; { .   MenuButtonWidget mbw = (MenuButtonWidget) w;   Widget menu, temp;   Arg arglist[2];    Cardinal num_args;=   int menu_x, menu_y, menu_width, menu_height, button_height;    Position button_x, button_y;     temp = w;    while(temp != NULL) { <     menu = XtNameToWidget(temp, mbw->menu_button.menu_name);     if (menu == NULL)        temp = XtParent(temp);     else       break;   }      if (menu == NULL) {      char error_buf[BUFSIZ]; ,     sprintf(error_buf, "MenuButton: %s %s.",E 	    "Could not find menu widget named", mbw->menu_button.menu_name); =     XtAppWarning(XtWidgetToApplicationContext(w), error_buf);      return;    }    if (!XtIsRealized(menu))     XtRealizeWidget(menu);   >   menu_width = menu->core.width + 2 * menu->core.border_width;<   button_height = w->core.height + 2 * w->core.border_width;@   menu_height = menu->core.height + 2 * menu->core.border_width;  3   XtTranslateCoords(w, 0, 0, &button_x, &button_y);    menu_x = button_x;$   menu_y = button_y + button_height;     if (menu_x >= 0) {2     int scr_width = WidthOfScreen(XtScreen(menu));(     if (menu_x + menu_width > scr_width)&       menu_x = scr_width - menu_width;   }    if (menu_x < 0)      menu_x = 0;      if (menu_y >= 0) {4     int scr_height = HeightOfScreen(XtScreen(menu));*     if (menu_y + menu_height > scr_height)(       menu_y = scr_height - menu_height;   }    if (menu_y < 0)      menu_y = 0;      num_args = 0; 8   XtSetArg(arglist[num_args], XtNx, menu_x); num_args++;8   XtSetArg(arglist[num_args], XtNy, menu_y); num_args++;'   XtSetValues(menu, arglist, num_args);      XtPopupSpringLoaded(menu); }   