 /*?  * $XConsortium: Mailbox.c,v 1.58 91/06/13 16:50:32 keith Exp $   *7  * Copyright 1988 Massachusetts Institute of Technology   *H  * Permission to use, copy, modify, and distribute this software and itsL  * documentation for any purpose and without fee is hereby granted, providedJ  * that the above copyright notice appear in all copies and that both thatC  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *(  * Author:  Jim Fulton, MIT X Consortium  *M  * I recommend that you use the new mailfull and mailempty bitmaps instead of   * the ugly mailboxes:  *&  *         XBiff*fullPixmap:  mailfull(  *         XBiff*emptyPixmap:  mailempty  */   4 #include <X11/IntrinsicP.h>		/* for toolkit stuff */8 #include <X11/StringDefs.h>		/* for useful atom names */7 #include <X11/cursorfont.h>		/* for cursor constants */ 3 #include <X11/Xosdefs.h>		/* for X_NOT_POSIX def */ ; #include <sys/stat.h>			/* for stat() ** needs types.h ***/ 6 #include <stdio.h>			/* for printing error messages */- #include <pwd.h>			/* for getting username */    #ifndef X_NOT_POSIX  #ifdef _POSIX_SOURCE # include <sys/wait.h> #else  #define _POSIX_SOURCE  # include <sys/wait.h> #undef _POSIX_SOURCE #endif# # define waitCode(w)	WEXITSTATUS(w) " # define waitSig(w)	WIFSIGNALED(w) typedef int		waitType; # define INTWAITTYPE #else /* ! X_NOT_POSIX */  #ifdef SYSV ( # define waitCode(w)	(((w) >> 8) & 0x7f)  # define waitSig(w)	((w) & 0xff) typedef int		waitType; # define INTWAITTYPE #else  # include	<sys/wait.h>( # define waitCode(w)	((w).w_T.w_Retcode)' # define waitSig(w)	((w).w_T.w_Termsig)  typedef union wait	waitType; #endif /* SYSV else */ #endif /* ! X_NOT_POSIX else */   F #include <X11/bitmaps/mailfull>		/* for flag up (mail present) bits */D #include <X11/bitmaps/mailempty>	/* for flag down (mail not here) */   #include <X11/Xaw/XawInit.h>E #include <X11/Xaw/MailboxP.h>		/* for implementation mailbox stuff */  #include <X11/Xmu/Drawing.h>! #include <X11/extensions/shape.h>    /*M  * The default user interface is to have the mailbox turn itself off whenever J  * the user presses a button in it.  Expert users might want to make this O  * happen on EnterWindow.  It might be nice to provide support for some sort of @  * exit callback so that you can do things like press q to quit.  */   $ static char defaultTranslations[] =    "<ButtonPress>:  unset()";  $ static void Check(), Set(), Unset();  & static XtActionsRec actionsList[] = {      { "check",	Check },      { "unset",	Unset },      { "set",	Set },  };      /* Initialization of defaults */  ; #define offset(field) XtOffsetOf(MailboxRec, mailbox.field) 8 #define goffset(field) XtOffsetOf(WidgetRec, core.field)   static Dimension defDim = 48;  static Pixmap nopix = None;   ! static XtResource resources[] = { <     { XtNwidth, XtCWidth, XtRDimension, sizeof (Dimension), 5 	goffset (width), XtRDimension, (XtPointer)&defDim }, =     { XtNheight, XtCHeight, XtRDimension, sizeof (Dimension), 6 	goffset (height), XtRDimension, (XtPointer)&defDim },3     { XtNupdate, XtCInterval, XtRInt, sizeof (int), $ 	offset (update), XtRString, "30" },=     { XtNforeground, XtCForeground, XtRPixel, sizeof (Pixel), = 	offset (foreground_pixel), XtRString, XtDefaultForeground }, 3     { XtNfile, XtCFile, XtRString, sizeof (String), & 	offset (filename), XtRString, NULL },A     { XtNcheckCommand, XtCCheckCommand, XtRString, sizeof(char*), * 	offset (check_command), XtRString, NULL},0     { XtNvolume, XtCVolume, XtRInt, sizeof(int),# 	offset (volume), XtRString, "33"}, ;     { XtNonceOnly, XtCBoolean, XtRBoolean, sizeof(Boolean), 6 	offset (once_only), XtRImmediate, (XtPointer)False },:     { XtNfullPixmap, XtCPixmap, XtRBitmap, sizeof(Pixmap),- 	offset (full.bitmap), XtRString, "flagup" }, B     { XtNfullPixmapMask, XtCPixmapMask, XtRBitmap, sizeof(Pixmap),5 	offset (full.mask), XtRBitmap, (XtPointer) &nopix }, ;     { XtNemptyPixmap, XtCPixmap, XtRBitmap, sizeof(Pixmap), 0 	offset (empty.bitmap), XtRString, "flagdown" },C     { XtNemptyPixmapMask, XtCPixmapMask, XtRBitmap, sizeof(Pixmap), 6 	offset (empty.mask), XtRBitmap, (XtPointer) &nopix },4     { XtNflip, XtCFlip, XtRBoolean, sizeof(Boolean),& 	offset (flipit), XtRString, "true" },B     { XtNshapeWindow, XtCShapeWindow, XtRBoolean, sizeof(Boolean),/         offset (shapeit), XtRString, "false" },  };  
 #undef offset  #undef goffset  ' static void GetMailFile(), CloseDown(); 6 static void check_mailbox(), redraw_mailbox(), beep();< static void Initialize(), Realize(), Destroy(), Redisplay(); static Boolean SetValues();   # MailboxClassRec mailboxClassRec = {      { /* core fields */ 4     /* superclass		*/	(WidgetClass) &simpleClassRec,      /* class_name		*/	"Mailbox",*     /* widget_size		*/	sizeof(MailboxRec),3     /* class_initialize		*/	XawInitializeWidgetSet, %     /* class_part_initialize	*/	NULL,      /* class_inited		*/	FALSE,!     /* initialize		*/	Initialize,       /* initialize_hook		*/	NULL,     /* realize			*/	Realize,      /* actions			*/	actionsList,-     /* num_actions		*/	XtNumber(actionsList),      /* resources		*/	resources, .     /* resource_count		*/	XtNumber(resources),     /* xrm_class		*/	NULLQUARK,       /* compress_motion		*/	TRUE,!     /* compress_exposure	*/	TRUE, #     /* compress_enterleave	*/	TRUE, "     /* visible_interest		*/	FALSE,     /* destroy			*/	Destroy,     /* resize			*/	NULL,     /* expose			*/	Redisplay,       /* set_values		*/	SetValues,      /* set_values_hook		*/	NULL,5     /* set_values_almost	*/	XtInheritSetValuesAlmost,       /* get_values_hook		*/	NULL,     /* accept_focus		*/	NULL,      /* version			*/	XtVersion,!     /* callback_private		*/	NULL, )     /* tm_table			*/	defaultTranslations, 1     /* query_geometry		*/	XtInheritQueryGeometry, :     /* display_accelerator	*/	XtInheritDisplayAccelerator,     /* extension		*/	NULL      },     { /* simple fields */ ;     /* change_sensitive         */	XtInheritChangeSensitive      },     { /* mailbox fields */$     /* ignore                   */	0     }  };  @ WidgetClass mailboxWidgetClass = (WidgetClass) &mailboxClassRec;     /*  * widget initialization  */    static GC get_mailbox_gc (w)     MailboxWidget w; {      XtGCMask valuemask;      XGCValues xgcv;   O     valuemask = GCForeground | GCBackground | GCFunction | GCGraphicsExposures; 2     xgcv.foreground = w->mailbox.foreground_pixel;/     xgcv.background = w->core.background_pixel;      xgcv.function = GXcopy; D     xgcv.graphics_exposures = False;	/* this is Bool, not Boolean */4     return (XtGetGC ((Widget) w, valuemask, &xgcv)); }      /* ARGSUSED */% static void Initialize (request, new)      Widget request, new; { *     MailboxWidget w = (MailboxWidget) new;+     int shape_event_base, shape_error_base;   .     if (w->core.width <= 0) w->core.width = 1;0     if (w->core.height <= 0) w->core.height = 1;  C     if (w->mailbox.shapeit && !XShapeQueryExtension (XtDisplay (w),  						     &shape_event_base,  						     &shape_error_base))!       w->mailbox.shapeit = False; '     w->mailbox.shape_cache.mask = None; '     w->mailbox.gc = get_mailbox_gc (w); .     w->mailbox.interval_id = (XtIntervalId) 0;"     w->mailbox.full.pixmap = None;#     w->mailbox.empty.pixmap = None;      w->mailbox.flag_up = FALSE;      w->mailbox.last_size = 0; .     if (!w->mailbox.filename) GetMailFile (w);     return;  }      /*  * action procedures  */    /*8  * pretend there is new mail; put widget in flagup state  */    /* ARGSUSED */, static void Set (gw, event, params, nparams)     Widget gw;     XEvent *event;     String *params;      Cardinal *nparams; { )     MailboxWidget w = (MailboxWidget) gw;        w->mailbox.last_size = -1;  :     check_mailbox (w, TRUE, FALSE);	/* redraw, no reset */       return;  }      /*6  * ack the existing mail; put widget in flagdown state  */    /* ARGSUSED */. static void Unset (gw, event, params, nparams)     Widget gw;     XEvent *event;     String *params;      Cardinal *nparams; { )     MailboxWidget w = (MailboxWidget) gw;   6     check_mailbox (w, TRUE, TRUE);	/* redraw, reset */       return;  }      /*;  * look to see if there is new mail; if so, Set, else Unset   */    /* ARGSUSED */. static void Check (gw, event, params, nparams)     Widget gw;     XEvent *event;     String *params;      Cardinal *nparams; { )     MailboxWidget w = (MailboxWidget) gw;   :     check_mailbox (w, TRUE, FALSE);	/* redraw, no reset */       return;  }      /* ARGSUSED */' static void clock_tic (client_data, id)      XtPointer client_data;     XtIntervalId *id;  { 2     MailboxWidget w = (MailboxWidget) client_data;  >     check_mailbox (w, FALSE, FALSE);	/* no redraw, no reset */       /*      * and reset the timer      */        w->mailbox.interval_id =; 	XtAppAddTimeOut (XtWidgetToApplicationContext((Widget) w), 6 			 w->mailbox.update * 1000, clock_tic, client_data);       return;  }   H static Pixmap make_pixmap (dpy, w, bitmap, depth, flip, widthp, heightp)     Display *dpy;      MailboxWidget w;     Pixmap bitmap;     Boolean flip;      int depth;     int *widthp, *heightp; {      Window root;
     int x, y; (     unsigned int width, height, bw, dep;     unsigned long fore, back;   O     if (!XGetGeometry (dpy, bitmap, &root, &x, &y, &width, &height, &bw, &dep))        return None;       *widthp = (int) width;     *heightp = (int) height;     if (flip) { ! 	fore = w->core.background_pixel; $ 	back = w->mailbox.foreground_pixel;     } else {$ 	fore = w->mailbox.foreground_pixel;! 	back = w->core.background_pixel;      } C     return XmuCreatePixmapFromBitmap (dpy, w->core.window, bitmap,  , 				      width, height, depth, fore, back); }   * static void Realize (gw, valuemaskp, attr)     Widget gw;     XtValueMask *valuemaskp;     XSetWindowAttributes *attr;  { )     MailboxWidget w = (MailboxWidget) gw; *     register Display *dpy = XtDisplay (w);     int depth = w->core.depth;  -     *valuemaskp |= (CWBitGravity | CWCursor); &     attr->bit_gravity = ForgetGravity;>     attr->cursor = XCreateFontCursor (dpy, XC_top_left_arrow);  D     (*mailboxWidgetClass->core_class.superclass->core_class.realize) 	(gw, valuemaskp, attr);       /*9      * build up the pixmaps that we'll put into the image       */ )     if (w->mailbox.full.bitmap == None) {  	w->mailbox.full.bitmap = F 	  XCreateBitmapFromData (dpy, w->core.window, (char *) mailfull_bits,& 				 mailfull_width, mailfull_height);     } *     if (w->mailbox.empty.bitmap == None) { 	w->mailbox.empty.bitmap =G 	  XCreateBitmapFromData (dpy, w->core.window, (char *) mailempty_bits, ( 				 mailempty_width, mailempty_height);     }   K     w->mailbox.empty.pixmap = make_pixmap (dpy, w, w->mailbox.empty.bitmap,  					   depth, False,   					   &w->mailbox.empty.width," 					   &w->mailbox.empty.height);I     w->mailbox.full.pixmap = make_pixmap (dpy, w, w->mailbox.full.bitmap,   					  depth, w->mailbox.flipit, 					  &w->mailbox.full.width,  					  &w->mailbox.full.height); 			 F     if (w->mailbox.empty.mask == None && w->mailbox.full.mask == None)!       w->mailbox.shapeit = False;        w->mailbox.interval_id =  ; 	XtAppAddTimeOut (XtWidgetToApplicationContext((Widget) w), 8 			 w->mailbox.update * 1000, clock_tic, (XtPointer) w);  '     w->mailbox.shape_cache.mask = None;   #     check_mailbox (w, TRUE, FALSE);        return;  }      static void Destroy (gw)     Widget gw; { )     MailboxWidget w = (MailboxWidget) gw; "     Display *dpy = XtDisplay (gw);  !     XtFree (w->mailbox.filename); I     if (w->mailbox.interval_id) XtRemoveTimeOut (w->mailbox.interval_id); #     XtReleaseGC(gw, w->mailbox.gc); . #define freepix(p) if (p) XFreePixmap (dpy, p)E     freepix (w->mailbox.full.bitmap);		/* until cvter does ref cnt */ C     freepix (w->mailbox.full.mask);		/* until cvter does ref cnt */ %     freepix (w->mailbox.full.pixmap); F     freepix (w->mailbox.empty.bitmap);		/* until cvter does ref cnt */D     freepix (w->mailbox.empty.mask);		/* until cvter does ref cnt */&     freepix (w->mailbox.empty.pixmap);*     freepix (w->mailbox.shape_cache.mask); #undef freepix     return;  }      static void Redisplay (gw)     Widget gw; { )     MailboxWidget w = (MailboxWidget) gw;   #     check_mailbox (w, TRUE, FALSE);  }     2 static void check_mailbox (w, force_redraw, reset)     MailboxWidget w;      Boolean force_redraw, reset; {      long mailboxsize = 0; '     Boolean readSinceLastWrite = FALSE;   +     if (w->mailbox.check_command != NULL) {  	waitType wait_status; 	int	check_status; #ifdef INTWAITTYPE0 	wait_status = system(w->mailbox.check_command); #else 9 	wait_status.w_status = system(w->mailbox.check_command);  #endif& 	check_status = waitCode(wait_status);  ) 	/* error in sh checkCommand execution */  	if (waitSig(wait_status))8 	    check_status = 2;		/* act as if there is no mail */   	switch (check_status) {
 	  case 0:, 	    mailboxsize = w->mailbox.last_size + 1; 	    break; 
 	  case 2: 	    mailboxsize = 0;  	    break; 4 	  default:	/* treat everything else as no change */' 	    	        /* case 1 is no change */ ( 	    mailboxsize = w->mailbox.last_size; 	}     } else { 	struct stat st;, 	if (stat (w->mailbox.filename, &st) == 0) { 	    mailboxsize = st.st_size;6 	    readSinceLastWrite = (st.st_atime > st.st_mtime); 	}     }        /*K      * Now check for changes.  If reset is set then we want to pretent that J      * there is no mail.  If the mailbox is empty then we want to turn offK      * the flag.  Otherwise if the mailbox has changed size then we want to H      * put the flag up, unless the mailbox has been read since the last 
      * write.       *      * The cases are: =      *    o  forced reset by user                        DOWN =      *    o  no mailbox or empty (zero-sized) mailbox    DOWN 4      *    o  if read after most recent write 		 DOWNB      *    o  same size as last time                      no change;      *    o  bigger than last time                       UP ;      *    o  smaller than last time but non-zero         UP       *A      * The last two cases can be expressed as different from last       * time and non-zero.       */   %     if (reset) {			/* forced reset */  	w->mailbox.flag_up = FALSE; 	force_redraw = TRUE; <     } else if (mailboxsize == 0) {	/* no mailbox or empty */ 	w->mailbox.flag_up = FALSE;D 	if (w->mailbox.last_size > 0) force_redraw = TRUE;  /* if change */J     } else if (readSinceLastWrite) { 	/* only when checkCommand is NULL */4 	/* mailbox has been read after most recent write */ 	if (w->mailbox.flag_up) {  	    w->mailbox.flag_up = FALSE; 	    force_redraw = TRUE;  	}K     } else if (mailboxsize != w->mailbox.last_size) {  /* different size */ 2 	if (!w->mailbox.once_only || !w->mailbox.flag_up) 	    beep(w);  	if (!w->mailbox.flag_up) . 	    force_redraw = w->mailbox.flag_up = TRUE;     }   '     w->mailbox.last_size = mailboxsize; )     if (force_redraw) redraw_mailbox (w);      return;  }    /*%  * get user name for building mailbox   */    static void GetMailFile (w)      MailboxWidget w; {      char *getlogin();      char *username;        username = getlogin ();      if (!username) {* 	struct passwd *pw = getpwuid (getuid ());   	if (!pw) { B 	    fprintf (stderr, "%s:  unable to find a username for you.\n", 		     "Mailbox widget");  	    CloseDown (w, 1); 	} 	username = pw->pw_name;     } M     w->mailbox.filename = (String) XtMalloc (strlen (MAILBOX_DIRECTORY) + 1 + $ 				   	     strlen (username) + 1);4     strcpy (w->mailbox.filename, MAILBOX_DIRECTORY);&     strcat (w->mailbox.filename, "/");+     strcat (w->mailbox.filename, username);      return;  }   ! static void CloseDown (w, status)      MailboxWidget w;     int status;  { !     Display *dpy = XtDisplay (w);         XtDestroyWidget ((Widget)w);     XCloseDisplay (dpy);     exit (status); }      /* ARGSUSED */3 static Boolean SetValues (gcurrent, grequest, gnew) $     Widget gcurrent, grequest, gnew; { 5     MailboxWidget current = (MailboxWidget) gcurrent; -     MailboxWidget new = (MailboxWidget) gnew;      Boolean redisplay = FALSE;  9     if (current->mailbox.update != new->mailbox.update) { # 	if (current->mailbox.interval_id)  2 	  XtRemoveTimeOut (current->mailbox.interval_id); 	new->mailbox.interval_id = 9 	    XtAppAddTimeOut (XtWidgetToApplicationContext(gnew), . 			     new->mailbox.update * 1000, clock_tic, 			     (XtPointer) gnew);     }   M     if (current->mailbox.foreground_pixel != new->mailbox.foreground_pixel || @ 	current->core.background_pixel != new->core.background_pixel) {- 	XtReleaseGC (gcurrent, current->mailbox.gc); ( 	new->mailbox.gc = get_mailbox_gc (new); 	redisplay = TRUE;     }        return (redisplay);  }      /*  * drawing code   */    static void redraw_mailbox (w)     MailboxWidget w; { *     register Display *dpy = XtDisplay (w);'     register Window win = XtWindow (w);      register int x, y;     GC gc = w->mailbox.gc;*     Pixel back = w->core.background_pixel;     struct _mbimage *im;  *     /* center the picture in the window */  <     if (w->mailbox.flag_up) {		/* paint the "up" position */ 	im = &w->mailbox.full; ; 	if (w->mailbox.flipit) back = w->mailbox.foreground_pixel; /     } else {				/* paint the "down" position */  	im = &w->mailbox.empty;     } /     x = (((int)w->core.width) - im->width) / 2; 1     y = (((int)w->core.height) - im->height) / 2;   *     XSetWindowBackground (dpy, win, back);     XClearWindow (dpy, win);L     XCopyArea (dpy, im->pixmap, win, gc, 0, 0, im->width, im->height, x, y);       /*O      * XXX - temporary hack; walk up widget tree to find top most parent (which M      * will be a shell) and mash it to have our shape.  This will be replaced !      * by a special shell widget.       */      if (w->mailbox.shapeit) {  	Widget parent;   , 	for (parent = (Widget) w; XtParent(parent);" 	     parent = XtParent(parent)) {5 	    x += parent->core.x + parent->core.border_width; 5 	    y += parent->core.y + parent->core.border_width;  	}  / 	if (im->mask != w->mailbox.shape_cache.mask || F 	    x != w->mailbox.shape_cache.x || y != w->mailbox.shape_cache.y) {< 	    XShapeCombineMask (XtDisplay(parent), XtWindow(parent),3 			       ShapeBounding, x, y, im->mask, ShapeSet); , 	    w->mailbox.shape_cache.mask = im->mask;" 	    w->mailbox.shape_cache.x = x;" 	    w->mailbox.shape_cache.y = y; 	}     }        return;  }      static void beep (w)     MailboxWidget w; { -     XBell (XtDisplay (w), w->mailbox.volume);      return;  } 