B /* $XConsortium: List.c,v 1.33 91/05/22 16:31:34 converse Exp $ */   /*7  * Copyright 1989 Massachusetts Institute of Technology   *N  * Permission to use, copy, modify, distribute, and sell this software and itsM  * documentation for any purpose is hereby granted without fee, provided that E  * the above copyright notice appear in all copies and that both that C  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION J  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *  */    /*  * List.c - List widget   *G  * This is the List widget, it is useful to display a list, without the E  * overhead of having a widget for each item in the list.  It allows  L  * the user to select an item in a list and notifies the application through  * a callback function.   *  *	Created: 	8/13/88  *	By:		Chris D. Peterson (  *                      MIT X Consortium  */    #include <stdio.h> #include <ctype.h>   #include <X11/IntrinsicP.h>  #include <X11/StringDefs.h>    #include <X11/Xmu/Drawing.h>   #include <X11/Xaw/XawInit.h> #include <X11/Xaw/ListP.h>     /*    * Default Translation table.   */   % static char defaultTranslations[] =      "<Btn1Down>:   Set()\n\     <Btn1Up>:     Notify()";   A /****************************************************************   *  * Full class record constant   *B  ****************************************************************/   /* Private Data */  1 #define offset(field) XtOffset(ListWidget, field)   ! static XtResource resources[] = { ;     {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel), : 	offset(list.foreground), XtRString, XtDefaultForeground},5     {XtNcursor, XtCCursor, XtRCursor, sizeof(Cursor), 5        offset(simple.cursor), XtRString, "left_ptr"}, =     {XtNfont,  XtCFont, XtRFontStruct, sizeof(XFontStruct *), - 	offset(list.font),XtRString, XtDefaultFont}, 3     {XtNlist, XtCList, XtRPointer, sizeof(char **), +        offset(list.list), XtRString, NULL}, 9     {XtNdefaultColumns, XtCColumns, XtRInt,  sizeof(int), 8 	offset(list.default_cols), XtRImmediate, (XtPointer)2},2     {XtNlongest, XtCLongest, XtRInt,  sizeof(int),3 	offset(list.longest), XtRImmediate, (XtPointer)0}, >     {XtNnumberStrings, XtCNumberStrings, XtRInt,  sizeof(int),2 	offset(list.nitems), XtRImmediate, (XtPointer)0},>     {XtNpasteBuffer, XtCBoolean, XtRBoolean,  sizeof(Boolean),6 	offset(list.paste), XtRImmediate, (XtPointer) False},?     {XtNforceColumns, XtCColumns, XtRBoolean,  sizeof(Boolean), ; 	offset(list.force_cols), XtRImmediate, (XtPointer) False}, ?     {XtNverticalList, XtCBoolean, XtRBoolean,  sizeof(Boolean), > 	offset(list.vertical_cols), XtRImmediate, (XtPointer) False},B     {XtNinternalWidth, XtCWidth, XtRDimension,  sizeof(Dimension),: 	offset(list.internal_width), XtRImmediate, (XtPointer)4},C     {XtNinternalHeight, XtCHeight, XtRDimension, sizeof(Dimension), ; 	offset(list.internal_height), XtRImmediate, (XtPointer)2}, D     {XtNcolumnSpacing, XtCSpacing, XtRDimension,  sizeof(Dimension),8 	offset(list.column_space), XtRImmediate, (XtPointer)6},A     {XtNrowSpacing, XtCSpacing, XtRDimension,  sizeof(Dimension), 5 	offset(list.row_space), XtRImmediate, (XtPointer)2}, >     {XtNcallback, XtCCallback, XtRCallback, sizeof(XtPointer),2         offset(list.callback), XtRCallback, NULL}, };   static void Initialize();  static void ChangeSize();  static void Resize();  static void Redisplay(); static void Destroy(); static Boolean Layout();( static XtGeometryResult PreferredGeom(); static Boolean SetValues(); % static void Notify(), Set(), Unset();   ! static XtActionsRec actions[] = { !       {"Notify",         Notify},        {"Set",            Set},        {"Unset",          Unset}, };   ListClassRec listClassRec = {    {  /* core_class fields */	% #define superclass		(&simpleClassRec) 1     /* superclass	  	*/	(WidgetClass) superclass,      /* class_name	  	*/	"List", )     /* widget_size	  	*/	sizeof(ListRec), 5     /* class_initialize   	*/	XawInitializeWidgetSet, %     /* class_part_initialize	*/	NULL, $     /* class_inited       	*/	FALSE,#     /* initialize	  	*/	Initialize,       /* initialize_hook		*/	NULL,'     /* realize		  	*/	XtInheritRealize,      /* actions		  	*/	actions,+     /* num_actions	  	*/	XtNumber(actions), !     /* resources	  	*/	resources, /     /* num_resources	  	*/	XtNumber(resources), !     /* xrm_class	  	*/	NULLQUARK, "     /* compress_motion	  	*/	TRUE,$     /* compress_exposure  	*/	FALSE,#     /* compress_enterleave	*/	TRUE, $     /* visible_interest	  	*/	FALSE,     /* destroy		  	*/	Destroy,     /* resize		  	*/	Resize,     /* expose		  	*/	Redisplay, "     /* set_values	  	*/	SetValues,      /* set_values_hook		*/	NULL,5     /* set_values_almost	*/	XtInheritSetValuesAlmost,       /* get_values_hook		*/	NULL,     /* accept_focus	 	*/	NULL,     /* version			*/	XtVersion,#     /* callback_private   	*/	NULL, ,     /* tm_table		   	*/	defaultTranslations,,    /* query_geometry		*/      PreferredGeom,   },( /* Simple class fields initialization */   { 4     /* change_sensitive		*/	XtInheritChangeSensitive   }  };  9 WidgetClass listWidgetClass = (WidgetClass)&listClassRec;   A /****************************************************************   *  * Private Procedures   *B  ****************************************************************/   static void GetGCs(w) 	 Widget w;  {      XGCValues	values; '     ListWidget lw = (ListWidget) w;       ,     values.foreground	= lw->list.foreground;&     values.font		= lw->list.font->fid;B     lw->list.normgc = XtGetGC(w, (unsigned) GCForeground | GCFont, 				 &values);  2     values.foreground	= lw->core.background_pixel;A     lw->list.revgc = XtGetGC(w, (unsigned) GCForeground | GCFont,  				 &values);  =     values.tile       = XmuCreateStippledPixmap(XtScreen(w),   						lw->list.foreground,  						lw->core.background_pixel, 						lw->core.depth);"     values.fill_style = FillTiled;  J     lw->list.graygc = XtGetGC(w, (unsigned) GCFont | GCTile | GCFillStyle, 			      &values); }    /*	Function Name: ResetList A  *	Description: Resets the new list when important things change.   *	Arguments: w - the widget. J  *                 changex, changey - allow the height or width to change?  *	Returns: none.   */    static void  ResetList(w, changex, changey)	 Widget w;  Boolean changex, changey;  { #     ListWidget lw = (ListWidget) w; $     Dimension width = w->core.width;&     Dimension height = w->core.height;     register int i, len;   /*E  * If list is NULL then the list will just be the name of the widget.   */         if (lw->list.list == NULL) {'       lw->list.list = &(lw->core.name);        lw->list.nitems = 1;     }   <     if (lw->list.nitems == 0)	    /* Get number of items. */L         for ( ; lw->list.list[lw->list.nitems] != NULL ; lw->list.nitems++);  6     if (lw->list.longest == 0) /* Get column width. */1         for ( i = 0 ; i < lw->list.nitems; i++) { 6 	    len = XTextWidth(lw->list.font, lw->list.list[i]," 			     strlen(lw->list.list[i]));  	    if (len > lw->list.longest)  	        lw->list.longest = len; 	}  B     lw->list.col_width = lw->list.longest + lw->list.column_space;  5     if (Layout(w, changex, changey, &width, &height)) #       ChangeSize(w, width, height);  }    /*	Function Name: ChangeSize. #  *	Description: Laysout the widget. 7  *	Arguments: w - the widget to try change the size of.   *	Returns: none.   */    static void  ChangeSize(w, width, height)	 Widget w;  Dimension width, height; { $     XtWidgetGeometry request, reply;  .     request.request_mode = CWWidth | CWHeight;     request.width = width;     request.height = height;     ;     switch ( XtMakeGeometryRequest(w, &request, &reply) ) {      case XtGeometryYes:      case XtGeometryNo:         break;     case XtGeometryAlmost:, 	Layout(w, (request.height != reply.height),* 	          (request.width != reply.width),) 	       &(reply.width), &(reply.height));  	request = reply; 7 	switch (XtMakeGeometryRequest(w, &request, &reply) ) {  	case XtGeometryYes: 	case XtGeometryNo:  	    break;  	case XtGeometryAlmost:  	    request = reply;   	    if (Layout(w, FALSE, FALSE,0 		       &(request.width), &(request.height))) { 	      char buf[BUFSIZ];) 	      sprintf(buf, "List Widget: %s %s", . 		      "Size Changed when it shouldn't have",! 		      "when computing layout"); : 	      XtAppWarning(XtWidgetToApplicationContext(w), buf); 	    }/ 	    request.request_mode = CWWidth | CWHeight; 0 	    XtMakeGeometryRequest(w, &request, &reply); 	    break; 	 	default: 0 	  XtAppWarning(XtWidgetToApplicationContext(w),2 		       "List Widget: Unknown geometry return.");	 	  break;  	} 	break;      default:. 	XtAppWarning(XtWidgetToApplicationContext(w),0 		     "List Widget: Unknown geometry return."); 	break;      }  }    /*	Function Name: Initialize=  *	Description: Function that initilizes the widget instance.   *	Arguments: junk - NOT USED.)  *                 new  - the new widget.   *	Returns: none  */    /* ARGSUSED */ static void  Initialize(junk, new)  Widget junk, new;  { %     ListWidget lw = (ListWidget) new;    /*  $  * Initialize all private resources.  */        GetGCs(new);       /* Set row height. */ :     lw->list.row_height = lw->list.font->max_bounds.ascent& 			+ lw->list.font->max_bounds.descent 			+ lw->list.row_space;  D     ResetList(new, (new->core.width == 0), (new->core.height == 0));  @     lw->list.highlight = lw->list.is_highlighted = NO_HIGHLIGHT;   } /* Initialize */   /*	Function Name: CvtToItem F  *	Description: Converts Xcoord to item number of item containing that  *                   point. "  *	Arguments: w - the list widget.;  *                 xloc, yloc - x location, and y location.   *	Returns: the item number.  */   
 static int CvtToItem(w, xloc, yloc, item)	 Widget w;  int xloc, yloc; 
 int *item; {      int one, another; #     ListWidget lw = (ListWidget) w;      int ret_val = OKAY;   !     if (lw->list.vertical_cols) { F         one = lw->list.nrows * ((xloc - (int) lw->list.internal_width) 	    / lw->list.col_width); :         another = (yloc - (int) lw->list.internal_height)  	        / lw->list.row_height; 7 	 /* If out of range, return minimum possible value. */ ! 	if (another >= lw->list.nrows) { " 	    another = lw->list.nrows - 1; 	    ret_val = OUT_OF_RANGE; 	}     } 
     else {I         one = (lw->list.ncols * ((yloc - (int) lw->list.internal_height)  '               / lw->list.row_height)) ; . 	/* If in right margin handle things right. */N         another = (xloc - (int) lw->list.internal_width) / lw->list.col_width;! 	if (another >= lw->list.ncols) { # 	    another = lw->list.ncols - 1;   	    ret_val = OUT_OF_RANGE; 	}     }   !     if ((xloc < 0) || (yloc < 0))          ret_val = OUT_OF_RANGE;      if (one < 0) one = 0; !     if (another < 0) another = 0;      *item = one + another;7     if (*item >= lw->list.nitems) return(OUT_OF_RANGE);      return(ret_val); }   " /*	Function Name: FindCornerItems.@  *	Description: Find the corners of the rectangle in item space."  *	Arguments: w - the list widget.L  *                 event - the event structure that has the rectangle it it.?  *                 ul_ret, lr_ret - the corners ** RETURNED **.   *	Returns: none.   */    static void ) FindCornerItems(w, event, ul_ret, lr_ret) 	 Widget w;  XEvent * event;  int *ul_ret, *lr_ret;  {      int xloc, yloc;        xloc = event->xexpose.x;     yloc = event->xexpose.y;%     CvtToItem(w, xloc, yloc, ul_ret); !     xloc += event->xexpose.width; "     yloc += event->xexpose.height;%     CvtToItem(w, xloc, yloc, lr_ret);  }   ! /*	Function Name: ItemInRectangle J  *	Description: returns TRUE if the item passed is in the given rectangle."  *	Arguments: w - the list widget.C  *                 ul, lr - corners of the rectangle in item space. (  *                 item - item to check.>  *	Returns: TRUE if the item passed is in the given rectangle.  */    static Boolean  ItemInRectangle(w, ul, lr, item)	 Widget w;  int ul, lr, item;  { #     ListWidget lw = (ListWidget) w;      register int mod_item;     int things;            if (item < ul || item > lr)          return(FALSE);     if (lw->list.vertical_cols)           things = lw->list.nrows;     else          things = lw->list.ncols;       mod_item = item % things; B     if ( (mod_item >= ul % things) && (mod_item <= lr % things ) )         return(TRUE);      return(FALSE); }   % /*	Function Name: HighlightBackground F  *	Description: paints the color of the background for the given item.  *	Arguments: w - the widget. >  *                 x, y - ul corner of the area item occupies.7  *                 item - the item we are dealing with. C  *                 gc - the gc that is used to paint this rectangle   *	Returns:   */    static void & HighlightBackground(w, x, y, item, gc)	 Widget w;  int x, y, item;  GC gc; { #     ListWidget lw = (ListWidget) w; "     int hl_x, hl_y, width, height;  '     hl_x = x - lw->list.column_space/2; :     width = XTextWidth(lw->list.font, lw->list.list[item],9 			 strlen(lw->list.list[item])) + lw->list.column_space; $     hl_y = y - lw->list.row_space/2;6     height = lw->list.row_height + lw->list.row_space;  M     XFillRectangle(XtDisplay(w), XtWindow(w), gc, hl_x, hl_y, width, height);  }    /*	Function Name: PaintItemName H  *	Description: paints the name of the item in the appropriate location."  *	Arguments: w - the list widget.+  *                 item - the item to draw.   *	Returns: none.   *6  *      NOTE: no action taken on an unrealized widget.  */    static void  PaintItemName(w, item)	 Widget w; 	 int item;  {      char * str; 
     GC gc;     int x, y, str_y;#     ListWidget lw = (ListWidget) w;   7     if (!XtIsRealized(w)) return; /* Just in case... */      !     if (lw->list.vertical_cols) { 1 	x = lw->list.col_width * (item / lw->list.nrows)  	  + lw->list.internal_width; 9         y = lw->list.row_height * (item % lw->list.nrows)  	  + lw->list.internal_height;     } 
     else {8         x = lw->list.col_width * (item % lw->list.ncols) 	  + lw->list.internal_width; 9         y = lw->list.row_height * (item / lw->list.ncols)  	  + lw->list.internal_height;     }   1     str_y = y + lw->list.font->max_bounds.ascent;   *     if (item == lw->list.is_highlighted) {)         if (item == lw->list.highlight) {               gc = lw->list.revgc;9 	    HighlightBackground(w, x, y, item, lw->list.normgc);  	}         else { 	    if (XtIsSensitive(w))   	        gc = lw->list.normgc;	 	    else  	        gc = lw->list.graygc;8 	    HighlightBackground(w, x, y, item, lw->list.revgc);, 	    lw->list.is_highlighted = NO_HIGHLIGHT;	         }      } 
     else {)         if (item == lw->list.highlight) {               gc = lw->list.revgc;9 	    HighlightBackground(w, x, y, item, lw->list.normgc); $ 	    lw->list.is_highlighted = item; 	} 	else {  	    if (XtIsSensitive(w))   	        gc = lw->list.normgc;	 	    else  	        gc = lw->list.graygc; 	}     }   -     str =  lw->list.list[item];	/* draw it */ K     XDrawString(XtDisplay(w), XtWindow(w), gc, x, str_y, str, strlen(str));  }       /*	Function Name: Redisplay <  *	Description: Repaints the widget window on expose events."  *	Arguments: w - the list widget.=  *                 event - the expose event for this repaint. #  *                 junk - NOT USED.   *	Returns:   */    /* ARGSUSED */ static void  Redisplay(w, event, junk) 	 Widget w;  XEvent *event; Region junk; { +     int item;			/* an item to work with. */ H     int ul_item, lr_item;       /* corners of items we need to paint. */#     ListWidget lw = (ListWidget) w;   +     if (event == NULL) {	/* repaint all. */          ul_item = 0;/ 	lr_item = lw->list.nrows * lw->list.ncols - 1; ) 	XClearWindow(XtDisplay(w), XtWindow(w));      }      else6         FindCornerItems(w, event, &ul_item, &lr_item);     N     for (item = ul_item; (item <= lr_item && item < lw->list.nitems) ; item++)5       if (ItemInRectangle(w, ul_item, lr_item, item))  	PaintItemName(w, item); }    /*	Function Name: PreferredGeom C  *	Description: This tells the parent what size we would like to be /  *                   given certain constraints.   *	Arguments: w - the widget. D  *                 intended - what the parent intends to do with us.6  *                 requested - what we want to happen.  *	Returns: none.   */    static XtGeometryResult % PreferredGeom(w, intended, requested) 	 Widget w; ' XtWidgetGeometry *intended, *requested;  { $     Dimension new_width, new_height;*     Boolean change, width_req, height_req;     1     width_req = intended->request_mode & CWWidth; 3     height_req = intended->request_mode & CWHeight;        if (width_req)"       new_width = intended->width;     else        new_width = w->core.width;       if (height_req) $       new_height = intended->height;     else"       new_height = w->core.height;        requested->request_mode = 0;      /*+  * We only care about our height and width.   */   #     if ( !width_req && !height_req)        return(XtGeometryYes);     I     change = Layout(w, !width_req, !height_req, &new_width, &new_height);   '     requested->request_mode |= CWWidth; !     requested->width = new_width; (     requested->request_mode |= CWHeight;#     requested->height = new_height;        if (change) !         return(XtGeometryAlmost);      return(XtGeometryYes); }    /*	Function Name: ResizeF  *	Description: resizes the widget, by changing the number of rows and  *                   columns.   *	Arguments: w - the widget.   *	Returns: none.   */    static void 	 Resize(w) 	 Widget w;  {    Dimension width, height;     width = w->core.width;   height = w->core.height;  /   if (Layout(w, FALSE, FALSE, &width, &height)) 1     XtAppWarning(XtWidgetToApplicationContext(w), H 	    "List Widget: Size changed when it shouldn't have when resising."); }    /*	Function Name: Layout.  *	Description: lays out the item in the list.  *	Arguments: w - the widget. M  *                 xfree, yfree - TRUE if we are free to resize the widget in 1  *                                this direction. L  *                 width, height - the is the current width and height that M  *                                 we are going to layout the list widget to, J  *                                 depending on xfree and yfree of course.!  *                                6  *	Returns: TRUE if width or height have been changed.  */    static Boolean& Layout(w, xfree, yfree, width, height)	 Widget w;  Boolean xfree, yfree;  Dimension *width, *height; { #     ListWidget lw = (ListWidget) w;      Boolean change = FALSE;       /*  F  * If force columns is set then always use number of columns specified  * by default_cols.   */        if (lw->list.force_cols) {/         lw->list.ncols = lw->list.default_cols; - 	if (lw->list.ncols <= 0) lw->list.ncols = 1; ) 	/* 12/3 = 4 and 10/3 = 4, but 9/3 = 3 */ B 	lw->list.nrows = ( ( lw->list.nitems - 1) / lw->list.ncols) + 1 ;- 	if (xfree) {		/* If allowed resize width. */ 2 	    *width = lw->list.ncols * lw->list.col_width * 	           + 2 * lw->list.internal_width; 	    change = TRUE;  	}. 	if (yfree) {		/* If allowed resize height. */5 	    *height = (lw->list.nrows * lw->list.row_height) 3                     + 2 * lw->list.internal_height;  	    change = TRUE;  	} 	return(change);     }    /*C  * If both width and height are free to change the use default_cols B  * to determine the number columns and set new width and height to  * just fit the window.   */        if (xfree && yfree) { /         lw->list.ncols = lw->list.default_cols; - 	if (lw->list.ncols <= 0) lw->list.ncols = 1; B 	lw->list.nrows = ( ( lw->list.nitems - 1) / lw->list.ncols) + 1 ;4         *width = lw->list.ncols * lw->list.col_width& 	       + 2 * lw->list.internal_width;1 	*height = (lw->list.nrows * lw->list.row_height) /                 + 2 * lw->list.internal_height;  	change = TRUE;      }  /*  H  * If the width is fixed then use it to determine the number of columns.K  * If the height is free to move (width still fixed) then resize the height 1  * of the widget to fit the current list exactly.   */      else if (!xfree) {F         lw->list.ncols = ( (int)(*width - 2 * lw->list.internal_width)0 	                    / (int)lw->list.col_width);- 	if (lw->list.ncols <= 0) lw->list.ncols = 1; B 	lw->list.nrows = ( ( lw->list.nitems - 1) / lw->list.ncols) + 1 ; 	if ( yfree ) { 7   	    *height = (lw->list.nrows * lw->list.row_height) % 		    + 2 * lw->list.internal_height;  	    change = TRUE;  	}     }  /*  C  * The last case is xfree and !yfree we use the height to determine F  * the number of rows and then set the width to just fit the resulting  * number of columns.   */ 1     else if (!yfree) {		/* xfree must be TRUE. */ G         lw->list.nrows = (int)(*height - 2 * lw->list.internal_height)  - 	                 / (int)lw->list.row_height; - 	if (lw->list.nrows <= 0) lw->list.nrows = 1; A 	lw->list.ncols = (( lw->list.nitems - 1 ) / lw->list.nrows) + 1; . 	*width = lw->list.ncols * lw->list.col_width & 	       + 2 * lw->list.internal_width; 	change = TRUE;      }            return(change);  }    /*	Function Name: NotifyE  *	Description: Notifies the user that a button has been pressed, and H  *                   calles the callback, if the XtNpasteBuffer resourceI  *                   is true then the name of the item is also put in the .  *                   X cut buffer ( buf (0) ).8  *	Arguments: w - the widget that the notify occured in.?  *                 event - event that caused this notification. 1  *                 params, num_params - not used.   *	Returns: none.   */    /* ARGSUSED */ static void $ Notify(w, event, params, num_params)	 Widget w;  XEvent * event;  String * params; Cardinal *num_params;  { %     ListWidget lw = ( ListWidget ) w;      int item, item_len; "     XawListReturnStruct ret_value;   /*  >  * Find item and if out of range then unhighlight and return.   *  E  * If the current item is unhighlighted then the user has aborted the %  * notify, so unhighlight and return.   */   C     if ( ((CvtToItem(w, event->xbutton.x, event->xbutton.y, &item)) 7 	  == OUT_OF_RANGE) || (lw->list.highlight != item) ) {          XawListUnhighlight(w);         return;      }   +     item_len = strlen(lw->list.list[item]);   D     if ( lw->list.paste )	/* if XtNpasteBuffer set then paste it. */A         XStoreBytes(XtDisplay(w), lw->list.list[item], item_len);    /*    * Call Callback function.  */   +     ret_value.string = lw->list.list[item];       ret_value.list_index = item;     =     XtCallCallbacks( w, XtNcallback, (XtPointer) &ret_value);  }    /*	Function Name: Unset 1  *	Description: unhighlights the current element. 7  *	Arguments: w - the widget that the event occured in. $  *                 event - not used.1  *                 params, num_params - not used.   *	Returns: none.   */    /* ARGSUSED */ static void # Unset(w, event, params, num_params) 	 Widget w;  XEvent * event;  String * params; Cardinal *num_params;  {    XawListUnhighlight(w); }    /*	Function Name: Set /  *	Description: Highlights the current element. 7  *	Arguments: w - the widget that the event occured in. ?  *                 event - event that caused this notification. 1  *                 params, num_params - not used.   *	Returns: none.   */    /* ARGSUSED */ static void ! Set(w, event, params, num_params) 	 Widget w;  XEvent * event;  String * params; Cardinal *num_params;  {    int item;o!   ListWidget lw = (ListWidget) w;:  @   if ( (CvtToItem(w, event->xbutton.x, event->xbutton.y, &item))       == OUT_OF_RANGE)C     XawListUnhighlight(w);		        /* Unhighlight current item. */aI   else if ( lw->list.is_highlighted != item )   /* If this item is not */vL     XawListHighlight(w, item);	                /* highlighted then do it. */ }    /*&  * Set specified arguments into widget  */p   static Boolean    SetValues(current, request, new) Widget current, request, new;r {i)     ListWidget cl = (ListWidget) current;t)     ListWidget rl = (ListWidget) request;w%     ListWidget nl = (ListWidget) new;n     Boolean redraw = FALSE;   7     if ((cl->list.foreground != rl->list.foreground) ||v< 	(cl->core.background_pixel != rl->core.background_pixel) ||% 	(cl->list.font != rl->list.font) ) {E 	XGCValues values;D 	XGetGCValues(XtDisplay(current), cl->list.graygc, GCTile, &values);: 	XmuReleaseStippledPixmap(XtScreen(current), values.tile);' 	XtReleaseGC(current, cl->list.graygc);M& 	XtReleaseGC(current, cl->list.revgc);' 	XtReleaseGC(current, cl->list.normgc);T         GetGCs(new);         redraw = TRUE;     }T       /* Reset row height. */C  5     if ((cl->list.row_space != rl->list.row_space) || # 	(cl->list.font != rl->list.font)) e>         nl->list.row_height = nl->list.font->max_bounds.ascent8 	                    + nl->list.font->max_bounds.descent 			    + nl->list.row_space;     A     if ((cl->core.width != rl->core.width)                     ||r: 	(cl->core.height != rl->core.height)                   ||: 	(cl->list.internal_width != rl->list.internal_width)   ||: 	(cl->list.internal_height != rl->list.internal_height) ||: 	(cl->list.column_space != rl->list.column_space)       ||: 	(cl->list.row_space != rl->list.row_space)             ||: 	(cl->list.default_cols != rl->list.default_cols)       ||3 	(  (cl->list.force_cols != rl->list.force_cols) && : 	   (rl->list.force_cols != rl->list.ncols) )           ||: 	(cl->list.vertical_cols != rl->list.vertical_cols)     ||: 	(cl->list.longest != rl->list.longest)                 ||: 	(cl->list.nitems != rl->list.nitems)                   ||: 	(cl->list.font != rl->list.font)                       ||< 	(cl->list.list != rl->list.list)                        ) {  !       ResetList(new, TRUE, TRUE);,       redraw = TRUE;     }t  '     if (cl->list.list != rl->list.list)d(       nl->list.highlight = NO_HIGHLIGHT;  5     if ((cl->core.sensitive != rl->core.sensitive) ||,@ 	(cl->core.ancestor_sensitive != rl->core.ancestor_sensitive)) {*         nl->list.highlight = NO_HIGHLIGHT; 	redraw = TRUE;      }N          if (!XtIsRealized(current))*       return(FALSE);            return(redraw);  }    static void Destroy(w)
     Widget w;s {o#     ListWidget lw = (ListWidget) w;      XGCValues values;r     A     XGetGCValues(XtDisplay(w), lw->list.graygc, GCTile, &values);n7     XmuReleaseStippledPixmap(XtScreen(w), values.tile);g$     XtReleaseGC(w, lw->list.graygc);#     XtReleaseGC(w, lw->list.revgc);a$     XtReleaseGC(w, lw->list.normgc); }X   /* Exported Functions */    /*	Function Name: XawListChange.6  *	Description: Changes the list being used and shown."  *	Arguments: w - the list widget.'  *                 list - the new list.d<  *                 nitems - the number of items in the list.J  *                 longest - the length (in Pixels) of the longest element)  *                           in the list.X<  *                 resize - if TRUE the the list widget will1  *                          try to resize itself.n  *	Returns: none.iN  *      NOTE:      If nitems of longest are <= 0 then they will be calculated.O  *                 If nitems is <= 0 then the list needs to be NULL terminated.m  */n   void #if NeedFunctionPrototypes> XawListChange(Widget w, char ** list, int nitems, int longest, #if NeedWidePrototypes 	      int resize_it)s #elseX 	      Boolean resize_it)  #endif #elsea2 XawListChange(w, list, nitems, longest, resize_it)	 Widget w;t
 char ** list;, int nitems, longest; Boolean resize_it; #endif { #     ListWidget lw = (ListWidget) w;v       lw->list.list = list;e        if (nitems <= 0) nitems = 0;     lw->list.nitems = nitems;c"     if (longest <= 0) longest = 0;     lw->list.longest = longest;t  '     ResetList(w, resize_it, resize_it);c@     lw->list.is_highlighted = lw->list.highlight = NO_HIGHLIGHT;     if ( XtIsRealized(w) )       Redisplay(w, NULL, NULL);t }   $ /*	Function Name: XawListUnhighlight9  *	Description: unlights the current highlighted element.l  *	Arguments: w - the widget.*  *	Returns: none.e  */s   void #if NeedFunctionPrototypes XawListUnhighlight(Widget w) #elset XawListUnhighlight(w)i	 Widget w;* #endif {l%     ListWidget lw = ( ListWidget ) w;a  &     lw->list.highlight = NO_HIGHLIGHT;0     if (lw->list.is_highlighted != NO_HIGHLIGHT)N         PaintItemName(w, lw->list.is_highlighted); /* unhighlight this one. */ }a  " /*	Function Name: XawListHighlight*  *	Description: Highlights the given item."  *	Arguments: w - the list widget.1  *                 item - the item to hightlight.a  *	Returns: none.   */    void #if NeedFunctionPrototypes$ XawListHighlight(Widget w, int item) #elser XawListHighlight(w, item) 	 Widget w;e	 int item;  #endif { %     ListWidget lw = ( ListWidget ) w;r          if (XtIsSensitive(w)) {	"         lw->list.highlight = item;4         if (lw->list.is_highlighted != NO_HIGHLIGHT)J             PaintItemName(w, lw->list.is_highlighted);  /* Unhighlight. */3 	PaintItemName(w, item); /* HIGHLIGHT this one. */ v     }	 }	  $ /*	Function Name: XawListShowCurrent9  *	Description: returns the currently highlighted object./"  *	Arguments: w - the list widget.<  *	Returns: the info about the currently highlighted object.  */c   XawListReturnStruct *e #if NeedFunctionPrototypes XawListShowCurrent(Widget w) #elsed XawListShowCurrent(w) 	 Widget w;* #endif {*%     ListWidget lw = ( ListWidget ) w;*"     XawListReturnStruct * ret_val;  N     ret_val = (XawListReturnStruct *) XtMalloc (sizeof (XawListReturnStruct));     -     ret_val->list_index = lw->list.highlight; -     if (ret_val->list_index == XAW_LIST_NONE)        ret_val->string = "";t     else=       ret_val->string = lw->list.list[ ret_val->list_index ];        return(ret_val); }o  