A /* $XConsortium: AsciiSrc.c,v 1.55 91/07/25 18:09:27 rws Exp $ */    /*7  * Copyright 1989 Massachusetts Institute of Technology   *N  * Permission to use, copy, modify, distribute, and sell this software and itsM  * documentation for any purpose is hereby granted without fee, provided that E  * the above copyright notice appear in all copies and that both that C  * copyright notice and this permission notice appear in supporting K  * documentation, and that the name of M.I.T. not be used in advertising or I  * publicity pertaining to distribution of the software without specific, G  * written prior permission.  M.I.T. makes no representations about the H  * suitability of this software for any purpose.  It is provided "as is"'  * without express or implied warranty.   *N  * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALLN  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.N  * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGESO  * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION I  * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN ;  * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.   *-  * Author:  Chris Peterson, MIT X Consortium.   *6  * Much code taken from X11R3 String and Disk Sources.  */    /*@  * AsciiSrc.c - AsciiSrc object. (For use with the text widget).  *  */    #include <X11/IntrinsicP.h>  #include <stdio.h> #include <ctype.h> #include <errno.h> #include <X11/StringDefs.h>  #include <X11/Xos.h> #include <X11/Xfuncs.h>  #include <X11/Xaw/XawInit.h> #include <X11/Xaw/AsciiSrcP.h> #include <X11/Xmu/Misc.h>  #include <X11/Xmu/CharSet.h>  2 #if (defined(ASCII_STRING) || defined(ASCII_DISK)): #  include <X11/Xaw/AsciiText.h> /* for Widget Classes. */ #endif    A /****************************************************************   *  * Full class record constant   *B  ****************************************************************/   /* Private Data */  % static int magic_value = MAGIC_VALUE;   > #define offset(field) XtOffsetOf(AsciiSrcRec, ascii_src.field)  ! static XtResource resources[] = { 6     {XtNstring, XtCString, XtRString, sizeof (char *),(        offset(string), XtRString, NULL},;     {XtNtype, XtCType, XtRAsciiType, sizeof (XawAsciiType), >        offset(type), XtRImmediate, (XtPointer)XawAsciiString},J     {XtNdataCompression, XtCDataCompression, XtRBoolean, sizeof (Boolean),A        offset(data_compression), XtRImmediate, (XtPointer) TRUE}, B     {XtNpieceSize, XtCPieceSize, XtRInt, sizeof (XawTextPosition),=        offset(piece_size), XtRImmediate, (XtPointer) BUFSIZ}, ?     {XtNcallback, XtCCallback, XtRCallback, sizeof(XtPointer),  7        offset(callback), XtRCallback, (XtPointer)NULL}, L     {XtNuseStringInPlace, XtCUseStringInPlace, XtRBoolean, sizeof (Boolean),E        offset(use_string_in_place), XtRImmediate, (XtPointer) FALSE}, 0     {XtNlength, XtCLength, XtRInt, sizeof (int),?        offset(ascii_length), XtRInt, (XtPointer) &magic_value},    #ifdef ASCII_DISK 2     {XtNfile, XtCFile, XtRString, sizeof (String),*        offset(filename), XtRString, NULL}, #endif /* ASCII_DISK */  };
 #undef offset   4 static XawTextPosition Scan(), Search(), ReadText(); static int ReplaceText(); . static Piece * FindPiece(), * AllocNewPiece();! static FILE * InitStringOrFile(); G static void FreeAllPieces(), RemovePiece(), BreakPiece(), LoadPieces(); = static void RemoveOldStringOrFile(),  CvtStringToAsciiType(); H static void ClassInitialize(), Initialize(), Destroy(), GetValuesHook();1 static String MyStrncpy(), StorePiecesInString(); * static Boolean SetValues(), WriteToFile(); extern int errno, sys_nerr;  extern char* sys_errlist[];   & #define superclass		(&textSrcClassRec)% AsciiSrcClassRec asciiSrcClassRec = {    {  /* core_class fields */	1     /* superclass	  	*/	(WidgetClass) superclass, #     /* class_name	  	*/	"AsciiSrc", -     /* widget_size	  	*/	sizeof(AsciiSrcRec), .     /* class_initialize   	*/	ClassInitialize,%     /* class_part_initialize	*/	NULL, $     /* class_inited       	*/	FALSE,#     /* initialize	  	*/	Initialize,       /* initialize_hook		*/	NULL,     /* realize		  	*/	NULL,      /* actions		  	*/	NULL,      /* num_actions	  	*/	0, !     /* resources	  	*/	resources, /     /* num_resources	  	*/	XtNumber(resources), !     /* xrm_class	  	*/	NULLQUARK, #     /* compress_motion	  	*/	FALSE, $     /* compress_exposure  	*/	FALSE,$     /* compress_enterleave	*/	FALSE,$     /* visible_interest	  	*/	FALSE,     /* destroy		  	*/	Destroy,     /* resize		  	*/	NULL,     /* expose		  	*/	NULL,"     /* set_values	  	*/	SetValues,      /* set_values_hook		*/	NULL,!     /* set_values_almost	*/	NULL, )     /* get_values_hook		*/	GetValuesHook,      /* accept_focus	 	*/	NULL,     /* version			*/	XtVersion,#     /* callback_private   	*/	NULL,      /* tm_table		   	*/	NULL,      /* query_geometry		*/	NULL, #     /* display_accelerator	*/	NULL,      /* extension		*/	NULL    }, /* textSrc_class fields */   { 1     /* Read                     */      ReadText, 4     /* Replace                  */      ReplaceText,-     /* Scan                     */      Scan, /     /* Search                   */      Search, >     /* SetSelection             */      XtInheritSetSelection,A     /* ConvertSelection         */      XtInheritConvertSelection    }, /* asciiSrc_class fields */    { )     /* Keep the compiler happy */       0    }  };  A WidgetClass asciiSrcObjectClass = (WidgetClass)&asciiSrcClassRec;   = /************************************************************   *  * Semi-Public Interfaces.  *>  ************************************************************/  & /*      Function Name: ClassInitialize@  *      Description: Class Initialize routine, called only once.  *      Arguments: none.  *      Returns: none.  */    static void  ClassInitialize()  {    XawInitializeWidgetSet(); @   XtAddConverter( XtRString, XtRAsciiType, CvtStringToAsciiType, 		 NULL, (Cardinal) 0);  }   ! /*      Function Name: Initialize 7  *      Description: Initializes the simple menu widget G  *      Arguments: request - the widget requested by the argument list. F  *                 new     - the new widget with both resource and non-  *                           resource values.   *      Returns: none.  */    /* ARGSUSED */ static void  Initialize(request, new) Widget request, new; { ,   AsciiSrcObject src = (AsciiSrcObject) new;   FILE * file;   /*F  * Set correct flags (override resources) depending upon widget class.  */    #ifdef ASCII_DISK :   if (XtIsSubclass(XtParent(new), asciiDiskWidgetClass)) {'     src->ascii_src.type = XawAsciiFile; 4     src->ascii_src.string = src->ascii_src.filename;   }  #endif   #ifdef ASCII_STRING <   if (XtIsSubclass(XtParent(new), asciiStringWidgetClass)) {.     src->ascii_src.use_string_in_place = TRUE;)     src->ascii_src.type = XawAsciiString;    }  #endif  !   src->ascii_src.changes = FALSE; *   src->ascii_src.allocated_string = FALSE;  D   file = InitStringOrFile(src, src->ascii_src.type == XawAsciiFile);   LoadPieces(src, file, NULL);  !   if (file != NULL) fclose(file);  }    /*	Function Name: ReadText/  *	Description: This function reads the source. )  *	Arguments: w - the AsciiSource widget. :  *                 pos - position of the text to retreive.E  * RETURNED        text - text block that will contain returned text. A  *                 length - maximum number of characters to read. :  *	Returns: The number of characters read into the buffer.  */    static XawTextPosition ReadText(w, pos, text, length)	 Widget w;  XawTextPosition pos; XawTextBlock *text;	
 int length;		  { *   AsciiSrcObject src = (AsciiSrcObject) w;   XawTextPosition count, start; .   Piece * piece = FindPiece(src, pos, &start);        text->firstPos = pos; *   text->ptr = piece->text + (pos - start);&   count = piece->used - (pos - start);3   text->length = (length > count) ? count : length;    return(pos + text->length);  }    /*	Function Name: ReplaceText.7  *	Description: Replaces a block of text with new text. )  *	Arguments: w - the AsciiSource widget. H  *                 startPos, endPos - ends of text that will be removed.J  *                 text - new text to be inserted into buffer at startPos.(  *	Returns: XawEditError or XawEditDone.  */    /*ARGSUSED*/ static int  ' ReplaceText (w, startPos, endPos, text) 	 Widget w; ! XawTextPosition startPos, endPos;  XawTextBlock *text;  { *   AsciiSrcObject src = (AsciiSrcObject) w;.   Piece *start_piece, *end_piece, *temp_piece;)   XawTextPosition start_first, end_first;    int length, firstPos;    /*-  * Editing a read only source is not allowed.   */   .   if (src->text_src.edit_mode == XawtextRead)      return(XawEditError);   7   start_piece = FindPiece(src, startPos, &start_first); 1   end_piece = FindPiece(src, endPos, &end_first);   B   src->ascii_src.changes = TRUE; /* We have changed the buffer. */   /*    * Remove Old Stuff.    */   !   if (start_piece != end_piece) { #     temp_piece = start_piece->next;    /*3  * If empty and not the only piece then remove it.    */   ?     if ( ((start_piece->used = startPos - start_first) == 0) && A 	 !((start_piece->next == NULL) && (start_piece->prev == NULL)) ) $       RemovePiece(src, start_piece);  %     while (temp_piece != end_piece) { $       temp_piece = temp_piece->next;)       RemovePiece(src, temp_piece->prev);      } *     end_piece->used -= endPos - end_first;     if (end_piece->used != 0) H       MyStrncpy(end_piece->text, (end_piece->text + endPos - end_first), 		(int) end_piece->used);    } +   else {			/* We are fully in one piece. */ 9     if ( (start_piece->used -= endPos - startPos) == 0) { J       if ( !((start_piece->next == NULL) && (start_piece->prev == NULL)) ) 	RemovePiece(src, start_piece);      } 
     else {=       MyStrncpy(start_piece->text + (startPos - start_first), - 		start_piece->text + (endPos - start_first), 9 		(int) (start_piece->used - (startPos - start_first)) ); 1       if ( src->ascii_src.use_string_in_place &&  5 	   ((src->ascii_src.length - (endPos - startPos)) <  ( 	    (src->ascii_src.piece_size - 1)) ) G 	start_piece->text[src->ascii_src.length - (endPos - startPos)] = '\0';      }    }   ?   src->ascii_src.length += -(endPos - startPos) + text->length;      if ( text->length != 0) {        /*        * Put in the New Stuff.      */      9     start_piece = FindPiece(src, startPos, &start_first);           length = text->length;     firstPos = text->firstPos;          while (length > 0) {       char * ptr;        int fill;        /       if (src->ascii_src.use_string_in_place) { < 	if (start_piece->used == (src->ascii_src.piece_size - 1)) { 	  /* 8 	   * If we are in ascii string emulation mode. Then the% 	   *  string is not allowed to grow.  	   *// 	  start_piece->used = src->ascii_src.length =  H 	                                         src->ascii_src.piece_size - 1;3 	  start_piece->text[src->ascii_src.length] = '\0';  	  return(XawEditError); 	}       }     ;       if (start_piece->used == src->ascii_src.piece_size) {  	BreakPiece(src, start_piece);6 	start_piece = FindPiece(src, startPos, &start_first);       }   O       fill = Min((int)(src->ascii_src.piece_size - start_piece->used), length);        9       ptr = start_piece->text + (startPos - start_first); !       MyStrncpy(ptr + fill, ptr,  6 		(int) start_piece->used - (startPos - start_first));/       strncpy(ptr, text->ptr + firstPos, fill);               startPos += fill;        firstPos += fill;         start_piece->used += fill;       length -= fill;      }    }   )   if (src->ascii_src.use_string_in_place) 0     start_piece->text[start_piece->used] = '\0';  L   XtCallCallbacks(w, XtNcallback, NULL); /* Call callbacks, we have changed  					    the buffer. */      return(XawEditDone); }    /*	Function Name: Scan=  *	Description: Scans the text source for the number and type '  *                   of item specified. )  *	Arguments: w - the AsciiSource widget. =  *                 position - the position to start scanning. 4  *                 type - type of thing to scan for.+  *                 dir - direction to scan. G  *                 count - which occurance if this thing to search for. M  *                 include - whether or not to include the character found in <  *                           the position that is returned. +  *	Returns: the position of the item found.   *G  * Note: While there are only 'n' characters in the file there are n+1  F  *       possible cursor positions (one before the first character and&  *       one after the last character.  */    static   XawTextPosition - Scan (w, position, type, dir, count, include)  Widget                w; XawTextPosition       position;  XawTextScanType       type;  XawTextScanDirection  dir; int     	      count;  Boolean	              include; { *   AsciiSrcObject src = (AsciiSrcObject) w;   register int inc;    Piece * piece;,   XawTextPosition first, first_eol_position;   register char * ptr;  :   if (type == XawstAll) {	/* Optomize this common case. */     if (dir == XawsdRight)$       return(src->ascii_src.length);     return(0);			/* else. */   }   '   if (position > src->ascii_src.length) %     position = src->ascii_src.length;      if ( dir == XawsdRight ) {*     if (position == src->ascii_src.length) /*/  * Scanning right from src->ascii_src.length???   */ $       return(src->ascii_src.length);     inc = 1;   }    else {     if (position == 0)/       return(0);		/* Scanning left from 0??? */ 
     inc = -1;      position--;    }   +   piece = FindPiece(src, position, &first);    /*)  * If the buffer is empty then return 0.    */   %   if ( piece->used == 0 ) return(0);    )   ptr = (position - first) + piece->text;      switch (type) {    case XawstEOL:     case XawstParagraph:     case XawstWhiteSpace: #     for ( ; count > 0 ; count-- ) { 2       Boolean non_space = FALSE, first_eol = TRUE;       while (TRUE) {! 	register unsigned char c = *ptr;    	ptr += inc; 	position += inc;  	  	if (type == XawstWhiteSpace) {  	  if (isspace(c)) { 	    if (non_space) 
 	      break;  	  } 	  else  	    non_space = TRUE; 	} 	else if (type == XawstEOL) {  	  if (c == '\n') break; 	} 	else { /* XawstParagraph */ 	  if (first_eol) {  	    if (c == '\n') { % 	      first_eol_position = position;  	      first_eol = FALSE;  	    } 	  } 	  else  	    if ( c == '\n')  
 	      break;  	    else if ( !isspace(c) ) 	      first_eol = TRUE; 	} 	          	if ( ptr < piece->text ) {  	  piece = piece->prev; - 	  if (piece == NULL)	/* Begining of text. */  	    return(0); ' 	  ptr = piece->text + piece->used - 1;  	}1 	else if ( ptr >= (piece->text + piece->used) ) {  	  piece = piece->next; ( 	  if (piece == NULL)	/* End of text. */# 	    return(src->ascii_src.length);  	  ptr = piece->text;  	}       }      }      if (!include) { "       if ( type == XawstParagraph) 	position = first_eol_position;        position -= inc;     } 
     break;   case XawstPositions:       position += count * inc;
     break;9 /*  case XawstAll:		---- handled in special code above */    }      if ( dir == XawsdLeft )      position++;   (   if (position >= src->ascii_src.length)"     return(src->ascii_src.length);   if (position < 0)      return(0);     return(position);  }    /*	Function Name: SearchA  *	Description: Searchs the text source for the text block passed )  *	Arguments: w - the AsciiSource Widget. =  *                 position - the position to start scanning. +  *                 dir - direction to scan. 7  *                 text - the text block to search for. +  *	Returns: the position of the item found.   */    static XawTextPosition   Search(w, position, dir, text) Widget                w; XawTextPosition       position;  XawTextScanDirection  dir; XawTextBlock *        text;  { *   AsciiSrcObject src = (AsciiSrcObject) w;   register int inc, count = 0;   register char * ptr;   Piece * piece;
   char * buf;    XawTextPosition first;     if ( dir == XawsdRight )     inc = 1;   else {
     inc = -1;      if (position == 0)?       return(XawTextSearchError);	/* scanning left from 0??? */      position--;    }   7   buf = XtMalloc(sizeof(unsigned char) * text->length); ;   strncpy(buf, (text->ptr + text->firstPos), text->length); +   piece = FindPiece(src, position, &first); )   ptr = (position - first) + piece->text;      while (TRUE) {6     if (*ptr == ((dir == XawsdRight) ? *(buf + count) ? 		                     : *(buf + text->length - count - 1)) ) { &       if (count == (text->length - 1)) 	break; 
       else	 	count++;      } 
     else {       if (count != 0) {  	position -=inc * count; 	ptr -= inc * count;       }        count = 0;     }        ptr += inc;      position += inc;     !     while ( ptr < piece->text ) {        piece = piece->prev;2       if (piece == NULL) {	/* Begining of text. */
 	XtFree(buf);  	return(XawTextSearchError);       } *       ptr = piece->text + piece->used - 1;     }      2     while ( ptr >= (piece->text + piece->used) ) {       piece = piece->next;-       if (piece == NULL) {	/* End of text. */ 
 	XtFree(buf);  	return(XawTextSearchError);       }        ptr = piece->text;     }    }      XtFree(buf);   if (dir == XawsdLeft)      return(position); (   return(position - (text->length - 1)); }    /*	Function Name: SetValues 4  *	Description: Sets the values for the AsciiSource.4  *	Arguments: current - current state of the widget.0  *                 request - what was requested.5  *                 new - what the widget will become. (  *	Returns: True if redisplay is needed.  */    /* ARGSUSED */ static Boolean0 SetValues(current, request, new, args, num_args) Widget current, request, new; 
 ArgList args;  Cardinal * num_args; { 1   AsciiSrcObject src =      (AsciiSrcObject) new; 4   AsciiSrcObject old_src = (AsciiSrcObject) current;2   Boolean total_reset = FALSE, string_set = FALSE;   FILE * file;   int i;  1   if ( old_src->ascii_src.use_string_in_place !=  -        src->ascii_src.use_string_in_place ) { 6       XtAppWarning( XtWidgetToApplicationContext(new),F 	   "AsciiSrc: The XtNuseStringInPlace resource may not be changed.");,        src->ascii_src.use_string_in_place = + 	   old_src->ascii_src.use_string_in_place;    }   $   for (i = 0; i < *num_args ; i++ ) +       if (streq(args[i].name, XtNstring)) {  	  string_set = TRUE; 	 	  break;        }    I   if ( string_set || (old_src->ascii_src.type != src->ascii_src.type) ) { F     RemoveOldStringOrFile(old_src, string_set); /* remove old info. */B     file = InitStringOrFile(src, string_set);	/* Init new info. */N     LoadPieces(src, file, NULL);    /* load new info into internal buffers. */#     if (file != NULL) fclose(file); C     XawTextSetSource( XtParent(new), new, 0);   /* Tell text widget  						   what happened. */     total_reset = TRUE;    }   H   if ( old_src->ascii_src.ascii_length != src->ascii_src.ascii_length ) >       src->ascii_src.piece_size = src->ascii_src.ascii_length;     if ( !total_reset &&  F       (old_src->ascii_src.piece_size != src->ascii_src.piece_size) ) {3       String string = StorePiecesInString(old_src);        FreeAllPieces(old_src); $       LoadPieces(src, NULL, string);       XtFree(string);    }      return(FALSE); }    /*	Function Name: GetValuesHook ?  *	Description: This is a get values hook routine that sets the 9  *                   values specific to the ascii source. )  *	Arguments: w - the AsciiSource Widget. ,  *                 args - the argument list.1  *                 num_args - the number of args.   *	Returns: none.   */    static void   GetValuesHook(w, args, num_args)	 Widget w; 
 ArgList args;  Cardinal * num_args; { *   AsciiSrcObject src = (AsciiSrcObject) w;   register int i;   .   if (src->ascii_src.type == XawAsciiString) {&     for (i = 0; i < *num_args ; i++ ) +       if (streq(args[i].name, XtNstring)) { , 	  if (src->ascii_src.use_string_in_place) {E 	      *((char **) args[i].value) = src->ascii_src.first_piece->text;  	  }	 	  else { 4 	      if (XawAsciiSave(w))	/* If save sucessful. */7 		  *((char **) args[i].value) = src->ascii_src.string;  	  } 	break;        }    }  }        /*	Function Name: Destroy 9  *	Description: Destroys an ascii source (frees all data) 4  *	Arguments: src - the Ascii source Widget to free.  *	Returns: none.   */    static void  Destroy (w) 	 Widget w;  { 2   RemoveOldStringOrFile((AsciiSrcObject) w, True); }   = /************************************************************   *  * Public routines    *>  ************************************************************/  * /*	Function Name: XawAsciiSourceFreeString>  *	Description: Frees the string returned by a get values callE  *                   on the string when the source is of type string. &  *	Arguments: w - the AsciiSrc widget.  *	Returns: none.   */    void #if NeedFunctionPrototypes" XawAsciiSourceFreeString(Widget w) #else  XawAsciiSourceFreeString(w) 	 Widget w;  #endif { *   AsciiSrcObject src = (AsciiSrcObject) w;  O   if (src->ascii_src.allocated_string && src->ascii_src.type != XawAsciiFile) { ,     src->ascii_src.allocated_string = FALSE;"     XtFree(src->ascii_src.string);!     src->ascii_src.string = NULL;    }  }    /*	Function Name: XawAsciiSaveG  *	Description: Saves all the pieces into a file or string as required. &  *	Arguments: w - the asciiSrc Widget.,  *	Returns: TRUE if the save was successful.  */    Boolean  #if NeedFunctionPrototypes XawAsciiSave(Widget w) #else  XawAsciiSave(w) 	 Widget w;  #endif { *   AsciiSrcObject src = (AsciiSrcObject) w;   /*C  * If using the string in place then there is no need to play games 3  * to get the internal info into a readable string.   */   *   if (src->ascii_src.use_string_in_place)      return(TRUE);   ,   if (src->ascii_src.type == XawAsciiFile) {     char * string;  <     if (!src->ascii_src.changes) 		/* No changes to save. */       return(TRUE);   &     string = StorePiecesInString(src);  >     if (WriteToFile(string, src->ascii_src.string) == FALSE) {       XtFree(string);        return(FALSE);     }      XtFree(string);    } )   else {			/* This is a string widget. */ 1     if (src->ascii_src.allocated_string == TRUE)  $       XtFree(src->ascii_src.string);     else-       src->ascii_src.allocated_string = TRUE;      5     src->ascii_src.string = StorePiecesInString(src);    } !   src->ascii_src.changes = FALSE;    return(TRUE);  }   $ /*	Function Name: XawAsciiSaveAsFile2  *	Description: Save the current buffer as a file.&  *	Arguments: w - the AsciiSrc widget.B  *                 name - name of the file to save this file into.+  *	Returns: True if the save was sucessful.   */    Boolean  #if NeedFunctionPrototypes0 XawAsciiSaveAsFile(Widget w, _Xconst char* name) #else  XawAsciiSaveAsFile(w, name) 	 Widget w;  String name; #endif { *   AsciiSrcObject src = (AsciiSrcObject) w;   String string;   Boolean ret;  %   string = StorePiecesInString(src);    "   ret = WriteToFile(string, name);   XtFree(string);    return(ret); }   ' /*	Function Name: XawAsciiSourceChanged H  *	Description: Returns true if the source has changed since last saved.*  *	Arguments: w - the ascii source widget.(  *	Returns: a Boolean (see description).  */    Boolean  #if NeedFunctionPrototypes XawAsciiSourceChanged(Widget w)  #else  XawAsciiSourceChanged(w)	 Widget w;  #endif { 4   return( ((AsciiSrcObject) w)->ascii_src.changes ); }    = /************************************************************   *  * Private Functions.   *>  ************************************************************/   static void ( RemoveOldStringOrFile(src, checkString)  AsciiSrcObject src;  Boolean checkString; {    FreeAllPieces(src);   7   if (checkString && src->ascii_src.allocated_string) { "     XtFree(src->ascii_src.string);,     src->ascii_src.allocated_string = False;!     src->ascii_src.string = NULL;    }  }    /*	Function Name: WriteToFile F  *	Description: Write the string specified to the begining of the file  *                   specified. '  *	Arguments: string - string to write. .  *                 name - the name of the file7  *	Returns: returns TRUE if sucessful, FALSE otherwise.*  */C   static Boolean WriteToFile(string, name)n String string, name; { 	   int fd;y   +   if ( ((fd = creat(name, 0666)) == -1 ) ||iJ        (write(fd, string, sizeof(unsigned char) * strlen(string)) == -1) )     return(FALSE);     if ( close(fd) == -1 ) l     return(FALSE);     return(TRUE);g }n  % /*	Function Name: StorePiecesInStringnH  *	Description: store the pieces in memory into a standard ascii string.,  *	Arguments: data - the ascii pointer data.  *	Returns: none.s  */r  
 static Stringc StorePiecesInString(src) AsciiSrcObject src;n {e   String string;   XawTextPosition first;   Piece * piece;  G   string = XtMalloc(sizeof(unsigned char) * src->ascii_src.length + 1);y   F   for (first = 0, piece = src->ascii_src.first_piece ; piece != NULL; 2        first += piece->used, piece = piece->next) 6     strncpy(string + first, piece->text, piece->used);  I   string[src->ascii_src.length] = '\0';	/* NULL terminate this sucker. */    /*,  * This will refill all pieces to capacity.   */N  )   if (src->ascii_src.data_compression) {	      FreeAllPieces(src);O"     LoadPieces(src, NULL, string);   }O     return(string);  }T  # /*	Function Name: InitStringOrFile. /  *	Description: Initializes the string or file.1$  *	Arguments: src - the AsciiSource.#  *	Returns: none - May exit though.(  */s  
 static FILE *i  InitStringOrFile(src, newString) AsciiSrcObject src;u Boolean newString; {<     char * open_mode;n     FILE * file;     char fileName[TMPSIZ];  0     if (src->ascii_src.type == XawAsciiString) {  # 	if (src->ascii_src.string == NULL)S 	    src->ascii_src.length = 0;   1 	else if (! src->ascii_src.use_string_in_place) {S@ 	    src->ascii_src.string = XtNewString(src->ascii_src.string);, 	    src->ascii_src.allocated_string = True;; 	    src->ascii_src.length = strlen(src->ascii_src.string);* 	}  * 	if (src->ascii_src.use_string_in_place) {; 	    src->ascii_src.length = strlen(src->ascii_src.string);P9 	    /* In case the length resource is incorrectly set */ = 	    if (src->ascii_src.length > src->ascii_src.ascii_length) 6 		src->ascii_src.ascii_length = src->ascii_src.length;  5 	    if (src->ascii_src.ascii_length == MAGIC_VALUE) g4 		src->ascii_src.piece_size = src->ascii_src.length;	 	    else > 		src->ascii_src.piece_size = src->ascii_src.ascii_length + 1; 	} 		 	return(NULL);     }o   /*  * type is XawAsciiFile.  */l     '     src->ascii_src.is_tempfile = FALSE;r  &     switch (src->text_src.edit_mode) {     case XawtextRead:C# 	if (src->ascii_src.string == NULL)i: 	    XtErrorMsg("NoFile", "asciiSourceCreate", "XawError",A 		     "Creating a read only disk widget and no file specified.",i 		       NULL, 0); 	open_mode = "r";a 	break;X     case XawtextAppend:N     case XawtextEdit:e% 	if (src->ascii_src.string == NULL) {e& 	    src->ascii_src.string = fileName;* 	    (void) tmpnam(src->ascii_src.string);' 	    src->ascii_src.is_tempfile = TRUE;, 	    open_mode = "w";e 	} elseR 	    open_mode = "r+"; 	break;      default:7 	XtErrorMsg("badMode", "asciiSourceCreate", "XawError",,A 		"Bad editMode for ascii source; must be Read, Append or Edit.",* 		   NULL, NULL);e     }t  G     /* Allocate new memory for the temp filename, because it is held in)F      * a stack variable, not static memory.  This widget does not needI      * to keep the private state field is_tempfile -- it is only accessedo9      * in this routine, and its former setting is unused.n      */y2     if (newString || src->ascii_src.is_tempfile) {< 	src->ascii_src.string = XtNewString(src->ascii_src.string);( 	src->ascii_src.allocated_string = TRUE;     }r     &     if (!src->ascii_src.is_tempfile) {= 	if ((file = fopen(src->ascii_src.string, open_mode)) != 0) {s 	    (void) fseek(file, 0L, 2);a) 	    src->ascii_src.length = ftell(file);  	    return file; 	 	} else {C 	    String params[2]; 	    Cardinal num_params = 2;  	    char msg[11]; 	    s' 	    params[0] = src->ascii_src.string;l 	    if (errno <= sys_nerr) ! 		params[1] = sys_errlist[errno];  	    else {s$ 		sprintf(msg, "errno=%.4d", errno); 		params[1] = msg; 	    }? 	    XtAppWarningMsg(XtWidgetToApplicationContext((Widget)src), 6 			    "openError", "asciiSourceCreate", "XawWarning",7 			    "Cannot open file %s; %s", params, &num_params);  	}     }      src->ascii_src.length = 0;     return((FILE *)NULL);c }r   static void/ LoadPieces(src, file, string)u AsciiSrcObject src;* FILE * file; char * string; {    char *local_str, *ptr;    register Piece * piece = NULL;   XawTextPosition left;	     if (string == NULL) {	.     if (src->ascii_src.type == XawAsciiFile) {O       local_str = XtMalloc((src->ascii_src.length + 1) *sizeof(unsigned char));l'       if (src->ascii_src.length != 0) {p 	fseek(file, 0L, 0);- 	if ( fread(local_str, sizeof(unsigned char),r= 		   src->ascii_src.length, file) != src->ascii_src.length ) y; 	  XtErrorMsg("readError", "asciiSourceCreate", "XawError", , 		     "fread returned error.", NULL, NULL);       } .       local_str[src->ascii_src.length] = '\0';     }e     else(       local_str = src->ascii_src.string;   },   else     local_str = string;    /*L  * If we are using teh string in place then set the other fields as follows:  *  * piece_size = length;i'  * piece->used = src->ascii_src.length;   */    +   if (src->ascii_src.use_string_in_place) {i&     piece = AllocNewPiece(src, piece);H     piece->used = Min(src->ascii_src.length, src->ascii_src.piece_size);(     piece->text = src->ascii_src.string;     return;*   }*     ptr = local_str;   left = src->ascii_src.length;u     do {&     piece = AllocNewPiece(src, piece);  N     piece->text = XtMalloc(src->ascii_src.piece_size * sizeof(unsigned char));7     piece->used = Min(left, src->ascii_src.piece_size);c     if (piece->used != 0).-       strncpy(piece->text, ptr, piece->used);        left -= piece->used;     ptr += piece->used;    } while (left > 0);r  B   if ( (src->ascii_src.type == XawAsciiFile) && (string == NULL) )     XtFree(local_str); }I   /*	Function Name: AllocNewPiecei0  *	Description: Allocates a new piece of memory.(  *	Arguments: src - The AsciiSrc Widget.B  *                 prev - the piece just before this one, or NULL.   *	Returns: the allocated piece.  */    static Piece * AllocNewPiece(src, prev) AsciiSrcObject src;G
 Piece * prev;c {i   Piece * piece = XtNew(Piece);g     if (prev == NULL) {s'     src->ascii_src.first_piece = piece;      piece->next = NULL;S   }r   else {     if (prev->next != NULL)n!       (prev->next)->prev = piece;f     piece->next = prev->next;s     prev->next = piece;W   }C      piece->prev = prev;c     return(piece); }    /*	Function Name: FreeAllPiecesc$  *	Description: Frees all the pieces(  *	Arguments: src - The AsciiSrc Widget.  *	Returns: none.n  */e   static void  FreeAllPieces(src) AsciiSrcObject src;; { 5   Piece * next, * first = src->ascii_src.first_piece;      if (first->prev != NULL)O     printf("Programmer Botch in FreeAllPieces, there may be a memory leak.\n");r  *   for ( ; first != NULL ; first = next ) {     next = first->next;;     RemovePiece(src, first);   }) }     /*	Function Name: RemovePiece*.  *	Description: Removes a piece from the list.  *	Arguments: /  *                 piece - the piece to remove.s  *	Returns: none.t  */o   static voidR RemovePiece(src, piece)t AsciiSrcObject src;a Piece * piece; {    if (piece->prev == NULL)-     src->ascii_src.first_piece = piece->next;r   else&     (piece->prev)->next = piece->next;     if (piece->next != NULL)&     (piece->next)->prev = piece->prev;  *   if (!src->ascii_src.use_string_in_place)     XtFree(piece->text);     XtFree((char *)piece); }S   /*	Function Name: FindPiece B  *	Description: Finds the piece containing the position indicated.(  *	Arguments: src - The AsciiSrc Widget.E  *                 position - the position that we are searching for. M  * RETURNED        first - the position of the first character in this piece.):  *	Returns: piece - the piece that contains this position.  */s   static Piece * FindPiece(src, position, first)  AsciiSrcObject src;t! XawTextPosition position, *first;d { :   Piece * old_piece, * piece = src->ascii_src.first_piece;   XawTextPosition temp;e  O   for ( temp = 0 ; piece != NULL ; temp += piece->used, piece = piece->next ) {S     *first = temp;     old_piece = piece;  )     if ((temp + piece->used) > position) o       return(piece);   }xL   return(old_piece);	  /* if we run off the end the return the last piece */ }e      /*	Function Name: MyStrncpyTA  *	Description: Just like string copy, but slower and will always*1  *                   work on overlapping strings.*B  *	Arguments: (same as strncpy) - s1, s2 - strings to copy (2->1).4  *                  n - the number of chars to copy.  *	Returns: s1.   */n  
 static Stringc MyStrncpy(s1, s2, n) char * s1, * s2; int n; {a4   char * temp = XtMalloc(sizeof(unsigned char) * n);  H   strncpy(temp, s2, n);		/* Saber has a bug that causes it to generate*/H   strncpy(s1, temp, n);		/* a bogus warning message here (CDP 6/32/89)*/   XtFree(temp); 
   return(s1);( }s    /*	Function Name: BreakPiece8  *	Description: Breaks a full piece into two new pieces.(  *	Arguments: src - The AsciiSrc Widget..  *                 piece - the piece to break.  *	Returns: none.   */   0 #define HALF_PIECE (src->ascii_src.piece_size/2)   static voidp BreakPiece(src, piece) AsciiSrcObject src;  Piece * piece; {f*   Piece * new = AllocNewPiece(src, piece);   J   new->text = XtMalloc(src->ascii_src.piece_size * sizeof(unsigned char));.   strncpy(new->text, piece->text + HALF_PIECE,+ 	  src->ascii_src.piece_size - HALF_PIECE);    piece->used = HALF_PIECE;f6   new->used = src->ascii_src.piece_size - HALF_PIECE;  }U   /* ARGSUSED */ static void_4 CvtStringToAsciiType(args, num_args, fromVal, toVal)  XrmValuePtr *args;		/* unused */  Cardinal	*num_args;	/* unused */ XrmValuePtr	fromVal; XrmValuePtr	toVal; {d   static XawAsciiType type;)*   static XrmQuark  XtQEstring = NULLQUARK;   static XrmQuark  XtQEfile;
   XrmQuark q;d   char lowerName[BUFSIZ];(      if (XtQEstring == NULLQUARK) {1     XtQEstring = XrmPermStringToQuark(XtEstring);-/     XtQEfile   = XrmPermStringToQuark(XtEfile);i   }l  =   XmuCopyISOLatin1Lowered(lowerName, (char *) fromVal->addr);n"   q = XrmStringToQuark(lowerName);  -   if (q == XtQEstring) type = XawAsciiString;c*   if (q == XtQEfile)  type = XawAsciiFile;  '   (*toVal).size = sizeof(XawAsciiType);s#   (*toVal).addr = (XPointer) &type;l	   return;  }{  2 #if (defined(ASCII_STRING) || defined(ASCII_DISK))  #  include <X11/Xaw/Cardinals.h> #endif   #ifdef ASCII_STRINGd= /************************************************************   *  * Compatability functions.h  *>  ************************************************************/  >) /*	Function Name: AsciiStringSourceCreate (  *	Description: Creates a string source.<  *	Arguments: parent - the widget that will own this source.6  *                 args, num_args - the argument list.-  *	Returns: a pointer to the new text source..  */_   Widget- XawStringSourceCreate(parent, args, num_args)F Widget parent;
 ArgList args;f Cardinal num_args; {    XawTextSource src;   ArgList ascii_args;-   Arg temp[2];  -   XtSetArg(temp[0], XtNtype, XawAsciiString);t/   XtSetArg(temp[1], XtNuseStringInPlace, TRUE);(:   ascii_args = XtMergeArgLists(temp, TWO, args, num_args);  I   src = XtCreateWidget("genericAsciiString", asciiSrcObjectClass, parent, % 		       ascii_args, num_args + TWO);    XtFree((char *)ascii_args);    return(src); }g   /*<  * This is hacked up to try to emulate old functionality, it6  * may not work, as I have not old code to test it on.  *  * Chris D. Peterson  8/31/89.  */;   void c XawTextSetLastPos (w, lastPos)	 Widget w;f XawTextPosition lastPos; {o<   AsciiSrcObject src = (AsciiSrcObject) XawTextGetSource(w);  &   src->ascii_src.piece_size = lastPos; }  #endif /* ASCII_STRING */i   #ifdef ASCII_DISK ' /*	Function Name: AsciiDiskSourceCreate &  *	Description: Creates a disk source.<  *	Arguments: parent - the widget that will own this source.6  *                 args, num_args - the argument list.-  *	Returns: a pointer to the new text source.g  */e   Widget+ XawDiskSourceCreate(parent, args, num_args)  Widget parent;
 ArgList args;i Cardinal num_args; {    XawTextSource src;   ArgList ascii_args;R   Arg temp[1];   register int i;u  +   XtSetArg(temp[0], XtNtype, XawAsciiFile);r:   ascii_args = XtMergeArgLists(temp, ONE, args, num_args);
   num_args++;   !   for (i = 0; i < num_args; i++)  .     if (streq(ascii_args[i].name, XtNfile) || / 	          streq(ascii_args[i].name, XtCFile)) r%       ascii_args[i].name = XtNstring;   G   src = XtCreateWidget("genericAsciiDisk", asciiSrcObjectClass, parent,x 		       ascii_args, num_args);    XtFree((char *)ascii_args);    return(src); }s #endif /* ASCII_DISK */S