G /* $XConsortium: AsciiSink.c,v 1.57 91/07/21 20:35:00 converse Exp $ */   < /***********************************************************N Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,H and the Massachusetts Institute of Technology, Cambridge, Massachusetts.  +                         All Rights Reserved   F Permission to use, copy, modify, and distribute this software and its A documentation for any purpose and without fee is hereby granted,  F provided that the above copyright notice appear in all copies and that@ both that copyright notice and this permission notice appear in E supporting documentation, and that the names of Digital or MIT not be B used in advertising or publicity pertaining to distribution of the6 software without specific, written prior permission.    H DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDINGH ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALLG DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR C ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, F WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,C ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS 	 SOFTWARE.   C ******************************************************************/    #include <stdio.h>   #include <X11/Xlib.h>  #include <X11/Xutil.h> #include <X11/Xatom.h> #include <X11/IntrinsicP.h>  #include <X11/StringDefs.h>  #include <X11/Xaw/XawInit.h> #include <X11/Xaw/AsciiSinkP.h> > #include <X11/Xaw/AsciiSrcP.h>	/* For source function defs. */C #include <X11/Xaw/TextP.h>	/* I also reach into the text widget. */    #ifdef GETLASTPOS 8 #undef GETLASTPOS		/* We will use our own GETLASTPOS. */ #endif  N #define GETLASTPOS XawTextSourceScan(source, 0, XawstAll, XawsdRight, 1, TRUE)  $ static void Initialize(), Destroy(); static Boolean SetValues();   : static void DisplayText(), InsertCursor(), FindPosition();9 static void FindDistance(), Resolve(), GetCursorBounds();   @ #define offset(field) XtOffsetOf(AsciiSinkRec, ascii_sink.field)  ! static XtResource resources[] = { 5     {XtNecho, XtCOutput, XtRBoolean, sizeof(Boolean), / 	offset(echo), XtRImmediate, (XtPointer) True}, C     {XtNdisplayNonprinting, XtCOutput, XtRBoolean, sizeof(Boolean), > 	offset(display_nonprinting), XtRImmediate, (XtPointer) True}, };
 #undef offset   ' #define SuperClass		(&textSinkClassRec) ' AsciiSinkClassRec asciiSinkClassRec = {    {  /* core_class fields */	1     /* superclass	  	*/	(WidgetClass) SuperClass, $     /* class_name	  	*/	"AsciiSink",.     /* widget_size	  	*/	sizeof(AsciiSinkRec),5     /* class_initialize   	*/	XawInitializeWidgetSet, %     /* class_part_initialize	*/	NULL, $     /* class_inited       	*/	FALSE,#     /* initialize	  	*/	Initialize,       /* initialize_hook		*/	NULL,     /* obj1		  	*/	NULL,     /* obj2		  	*/	NULL,     /* obj3		  	*/	0, !     /* resources	  	*/	resources, /     /* num_resources	  	*/	XtNumber(resources), !     /* xrm_class	  	*/	NULLQUARK,      /* obj4		  	*/	FALSE,      /* obj5		  	*/	FALSE,      /* obj6			*/	FALSE,      /* obj7		  	*/	FALSE,      /* destroy		  	*/	Destroy,     /* obj8		  	*/	NULL,     /* obj9		  	*/	NULL,"     /* set_values	  	*/	SetValues,      /* set_values_hook		*/	NULL,     /* obj10			*/	NULL,       /* get_values_hook		*/	NULL,     /* obj11		 	*/	NULL,     /* version			*/	XtVersion,#     /* callback_private   	*/	NULL,      /* obj12		   	*/	NULL,     /* obj13			*/	NULL,      /* obj14			*/	NULL,      /* extension		*/	NULL    }, /* text_sink_class fields */   { 4     /* DisplayText              */      DisplayText,5     /* InsertCursor             */      InsertCursor, C     /* ClearToBackground        */      XtInheritClearToBackground, 5     /* FindPosition             */      FindPosition, 5     /* FindDistance             */      FindDistance, 0     /* Resolve                  */      Resolve,:     /* MaxLines                 */      XtInheritMaxLines,;     /* MaxHeight                */      XtInheritMaxHeight, 9     /* SetTabs                  */      XtInheritSetTabs, 7     /* GetCursorBounds          */      GetCursorBounds    }, /* ascii_sink_class fields */    {      /* unused			*/	0   }  };  C WidgetClass asciiSinkObjectClass = (WidgetClass)&asciiSinkClassRec;    /* Utilities */    static int   CharWidth (w, x, c) 	 Widget w;  int x; unsigned char c; { *     register int    i, width, nonPrinting;/     AsciiSinkObject sink = (AsciiSinkObject) w; -     XFontStruct *font = sink->text_sink.font;      Position *tab;        if ( c == XawLF ) return(0);       if (c == XawTAB) { 	/* Adjust for Left Margin. */3 	x -= ((TextWidget) XtParent(w))->text.margin.left;   1 	if (x >= (int)XtParent(w)->core.width) return 0; * 	for (i = 0, tab = sink->text_sink.tabs ; 3 	     i < sink->text_sink.tab_count ; i++, tab++) {  	    if (x < *tab) {* 		if (*tab < (int)XtParent(w)->core.width) 		    return *tab - x; 		else 		    return 0;  	    } 	}
 	return 0;     }   6     if ( (nonPrinting = (c < (unsigned char) XawSP)) )* 	if (sink->ascii_sink.display_nonprinting) 	    c += '@'; 	else {  	    c = XawSP;  	    nonPrinting = False;  	}       if (font->per_char && D 	    (c >= font->min_char_or_byte2 && c <= font->max_char_or_byte2)); 	width = font->per_char[c - font->min_char_or_byte2].width;      else  	width = font->min_bounds.width;       if (nonPrinting)/ 	width += CharWidth(w, x, (unsigned char) '^');        return width;  }    /*	Function Name: PaintText 9  *	Description: Actually paints the text into the windoe. "  *	Arguments: w - the text widget..  *                 gc - gc to paint text with.5  *                 x, y - location to paint the text. A  *                 buf, len - buffer and length of text to paint. 0  *	Returns: the width of the text painted, or 0.  *E  * NOTE:  If this string attempts to paint past the end of the window .  *        then this function will return zero.  */    static Dimension  PaintText(w, gc, x, y, buf, len)	 Widget w;  GC gc; Position x, y; unsigned char * buf; int len; { /     AsciiSinkObject sink = (AsciiSinkObject) w; .     TextWidget ctx = (TextWidget) XtParent(w);       Position max_x; K     Dimension width = XTextWidth(sink->text_sink.font, (char *) buf, len);  '     max_x = (Position) ctx->core.width;   M     if ( ((int) width) <= -x)	           /* Don't draw if we can't see it. */        return(width);  8     XDrawImageString(XtDisplay(ctx), XtWindow(ctx), gc, , 		     (int) x, (int) y, (char *) buf, len);N     if ( (((Position) width + x) > max_x) && (ctx->text.margin.right != 0) ) {. 	x = ctx->core.width - ctx->text.margin.right;  	width = ctx->text.margin.right;A 	XFillRectangle(XtDisplay((Widget) ctx), XtWindow( (Widget) ctx), * 		       sink->ascii_sink.normgc, (int) x,1 		       (int) y - sink->text_sink.font->ascent,   		       (unsigned int) width,7 		       (unsigned int) (sink->text_sink.font->ascent + + 				       sink->text_sink.font->descent));  	return(0);      }      return(width); }    /* Sink Object Functions */    /*H  * This function does not know about drawing more than one line of text.  */     static void + DisplayText(w, x, y, pos1, pos2, highlight) 	 Widget w;  Position x, y; Boolean highlight; XawTextPosition pos1, pos2;  { /     AsciiSinkObject sink = (AsciiSinkObject) w; 2     Widget source = XawTextGetSource(XtParent(w));     unsigned char buf[BUFSIZ];  
     int j, k;      XawTextBlock blk; I     GC gc = highlight ? sink->ascii_sink.invgc : sink->ascii_sink.normgc; L     GC invgc = highlight ? sink->ascii_sink.normgc : sink->ascii_sink.invgc;  '     if (!sink->ascii_sink.echo) return;   &     y += sink->text_sink.font->ascent;#     for ( j = 0 ; pos1 < pos2 ; ) { ; 	pos1 = XawTextSourceRead(source, pos1, &blk, pos2 - pos1); # 	for (k = 0; k < blk.length; k++) { 9 	    if (j >= BUFSIZ) {	/* buffer full, dump the text. */ - 	        x += PaintText(w, gc, x, y, buf, j);  		j = 0; 	    } 	    buf[j] = blk.ptr[k]; B 	    if (buf[j] == XawLF)	/* line feeds ('\n') are not printed. */ 	        continue;   	    else if (buf[j] == '\t') {  	        Position temp = 0;  		Dimension width;  H 	        if ((j != 0) && ((temp = PaintText(w, gc, x, y, buf, j)) == 0)) 		  return;    	        x += temp; 0 		width = CharWidth(w, x, (unsigned char) '\t');; 		XFillRectangle(XtDisplayOfObject(w), XtWindowOfObject(w),  			       invgc, (int) x, 1 			       (int) y - sink->text_sink.font->ascent,  			       (unsigned int) width, 8 			       (unsigned int) (sink->text_sink.font->ascent +, 					       sink->text_sink.font->descent));
 		x += width; 	 		j = -1;  	    }/ 	    else if ( buf[j] < (unsigned char) ' ' ) { 4 	        if (sink->ascii_sink.display_nonprinting) {  		    buf[j + 1] = buf[j] + '@'; 		    buf[j] = '^'; 
 		    j++; 		}  		else 		    buf[j] = ' ';  	    }	 	    j++;  	}     }      if (j > 0).         (void) PaintText(w, gc, x, y, buf, j); }    #define insertCursor_width 6 #define insertCursor_height 3 5 static char insertCursor_bits[] = {0x0c, 0x1e, 0x33};   
 static Pixmap  CreateInsertCursor(s) 
 Screen *s; { M     return (XCreateBitmapFromData (DisplayOfScreen(s), RootWindowOfScreen(s), A 		  insertCursor_bits, insertCursor_width, insertCursor_height));  }   ! /*	Function Name: GetCursorBounds <  *	Description: Returns the size and location of the cursor."  *	Arguments: w - the text object.H  * RETURNED        rect - an X rectangle to return the cursor bounds in.  *	Returns: none.   */    static void  GetCursorBounds(w, rect)	 Widget w;  XRectangle * rect; { /     AsciiSinkObject sink = (AsciiSinkObject) w;   6     rect->width = (unsigned short) insertCursor_width;8     rect->height = (unsigned short) insertCursor_height;D     rect->x = sink->ascii_sink.cursor_x - (short) (rect->width / 2);?     rect->y = sink->ascii_sink.cursor_y - (short) rect->height;  }    /*7  * The following procedure manages the "insert" cursor.   */    static void  InsertCursor (w, x, y, state) 	 Widget w;  Position x, y; XawTextInsertState state;  { /     AsciiSinkObject sink = (AsciiSinkObject) w; %     Widget text_widget = XtParent(w);      XRectangle rect;  "     sink->ascii_sink.cursor_x = x;"     sink->ascii_sink.cursor_y = y;       GetCursorBounds(w, &rect);J     if (state != sink->ascii_sink.laststate && XtIsRealized(text_widget)) *         XCopyPlane(XtDisplay(text_widget),% 		   sink->ascii_sink.insertCursorOn, 3 		   XtWindow(text_widget), sink->ascii_sink.xorgc, A 		   0, 0, (unsigned int) rect.width, (unsigned int) rect.height, $ 		   (int) rect.x, (int) rect.y, 1);'     sink->ascii_sink.laststate = state;  }    /*7  * Given two positions, find the distance between them.   */    static void D FindDistance (w, fromPos, fromx, toPos, resWidth, resPos, resHeight)	 Widget w; . XawTextPosition fromPos;	/* First position. */9 int fromx;			/* Horizontal location of first position. */ . XawTextPosition toPos;		/* Second position. */; int *resWidth;			/* Distance between fromPos and resPos. */ ; XawTextPosition *resPos;	/* Actual second position used. */ ( int *resHeight;			/* Height required. */ { /     AsciiSinkObject sink = (AsciiSinkObject) w; 2     Widget source = XawTextGetSource(XtParent(w));  ,     register XawTextPosition index, lastPos;     register unsigned char c;      XawTextBlock blk;        /* we may not need this */     lastPos = GETLASTPOS; >     XawTextSourceRead(source, fromPos, &blk, toPos - fromPos);     *resWidth = 0;G     for (index = fromPos; index != toPos && index < lastPos; index++) { ( 	if (index - blk.firstPos >= blk.length)= 	    XawTextSourceRead(source, index, &blk, toPos - fromPos); # 	c = blk.ptr[index - blk.firstPos]; 1 	*resWidth += CharWidth(w, fromx + *resWidth, c);  	if (c == XawLF) {
 	    index++;  	    break;  	}     }      *resPos = index;M     *resHeight = sink->text_sink.font->ascent +sink->text_sink.font->descent;  }      static void 8 FindPosition(w, fromPos, fromx, width, stopAtWordBreak,   		  resPos, resWidth, resHeight)	 Widget w; 2 XawTextPosition fromPos; 	/* Starting position. */; int fromx;			/* Horizontal location of starting position.*/ ! int width;			/* Desired width. */ D int stopAtWordBreak;		/* Whether the resulting position should be at 				   a word break. */ 2 XawTextPosition *resPos;	/* Resulting position. */) int *resWidth;			/* Actual width used. */ ( int *resHeight;			/* Height required. */ { /     AsciiSinkObject sink = (AsciiSinkObject) w; 2     Widget source = XawTextGetSource(XtParent(w));  7     XawTextPosition lastPos, index, whiteSpacePosition; '     int     lastWidth, whiteSpaceWidth;      Boolean whiteSpaceSeen;      unsigned char c;     XawTextBlock blk;        lastPos = GETLASTPOS;   5     XawTextSourceRead(source, fromPos, &blk, BUFSIZ);      *resWidth = 0;     whiteSpaceSeen = FALSE; 
     c = 0;K     for (index = fromPos; *resWidth <= width && index < lastPos; index++) {  	lastWidth = *resWidth; ( 	if (index - blk.firstPos >= blk.length)4 	    XawTextSourceRead(source, index, &blk, BUFSIZ);# 	c = blk.ptr[index - blk.firstPos]; 1 	*resWidth += CharWidth(w, fromx + *resWidth, c);   9 	if ((c == XawSP || c == XawTAB) && *resWidth <= width) {  	    whiteSpaceSeen = TRUE;   	    whiteSpacePosition = index;! 	    whiteSpaceWidth = *resWidth;  	} 	if (c == XawLF) {
 	    index++;  	    break;  	}     } /     if (*resWidth > width && index > fromPos) {  	*resWidth = lastWidth; 	 	index--; ) 	if (stopAtWordBreak && whiteSpaceSeen) { $ 	    index = whiteSpacePosition + 1;! 	    *resWidth = whiteSpaceWidth;  	}     } <     if (index == lastPos && c != XawLF) index = lastPos + 1;     *resPos = index;M     *resHeight = sink->text_sink.font->ascent +sink->text_sink.font->descent;  }    static void 1 Resolve (w, pos, fromx, width, leftPos, rightPos) 	 Widget w;  XawTextPosition pos; int fromx, width; $ XawTextPosition *leftPos, *rightPos; {      int resWidth, resHeight;2     Widget source = XawTextGetSource(XtParent(w));  N     FindPosition(w, pos, fromx, width, FALSE, leftPos, &resWidth, &resHeight);     if (*leftPos > GETLASTPOS)       *leftPos = GETLASTPOS;     *rightPos = *leftPos;  }    static void  GetGC(sink)  AsciiSinkObject sink;  { #     XtGCMask valuemask = (GCFont |  9 			  GCGraphicsExposures | GCForeground | GCBackground );      XGCValues values;   ,     values.font = sink->text_sink.font->fid;-     values.graphics_exposures = (Bool) FALSE;      3     values.foreground = sink->text_sink.foreground; 3     values.background = sink->text_sink.background; H     sink->ascii_sink.normgc = XtGetGC((Widget)sink, valuemask, &values);     3     values.foreground = sink->text_sink.background; 3     values.background = sink->text_sink.foreground; G     sink->ascii_sink.invgc = XtGetGC((Widget)sink, valuemask, &values);           values.function = GXxor;A     values.background = (unsigned long) 0L;	/* (pix ^ 0) = pix */ 6     values.foreground = (sink->text_sink.background ^   			 sink->text_sink.foreground);O     valuemask = GCGraphicsExposures | GCFunction | GCForeground | GCBackground;      G     sink->ascii_sink.xorgc = XtGetGC((Widget)sink, valuemask, &values);  }      /***** Public routines *****/    /*	Function Name: Initialize0  *	Description: Initializes the TextSink Object.H  *	Arguments: request, new - the requested and new values for the object+  *                                instance.   *	Returns: none.   *  */    /* ARGSUSED */ static void  Initialize(request, new) Widget request, new; { 1     AsciiSinkObject sink = (AsciiSinkObject) new;        GetGC(sink);     O     sink->ascii_sink.insertCursorOn= CreateInsertCursor(XtScreenOfObject(new)); *     sink->ascii_sink.laststate = XawisOff;>     sink->ascii_sink.cursor_x = sink->ascii_sink.cursor_y = 0; }    /*	Function Name: Destroy ;  *	Description: This function cleans up when the object is    *                   destroyed. '  *	Arguments: w - the AsciiSink Object.   *	Returns: none.   */    static void 
 Destroy(w)	 Widget w;  { .    AsciiSinkObject sink = (AsciiSinkObject) w;  +    XtReleaseGC(w, sink->ascii_sink.normgc); *    XtReleaseGC(w, sink->ascii_sink.invgc);*    XtReleaseGC(w, sink->ascii_sink.xorgc);F    XFreePixmap(XtDisplayOfObject(w), sink->ascii_sink.insertCursorOn); }    /*	Function Name: SetValues 1  *	Description: Sets the values for the AsciiSink 4  *	Arguments: current - current state of the object.0  *                 request - what was requested.5  *                 new - what the object will become. (  *	Returns: True if redisplay is needed.  */    /* ARGSUSED */ static Boolean  SetValues(current, request, new) Widget current, request, new;  { .     AsciiSinkObject w = (AsciiSinkObject) new;6     AsciiSinkObject old_w = (AsciiSinkObject) current;  2     if (w->text_sink.font != old_w->text_sink.font: 	|| w->text_sink.background != old_w->text_sink.background= 	|| w->text_sink.foreground != old_w->text_sink.foreground) { . 	XtReleaseGC((Widget)w, w->ascii_sink.normgc);- 	XtReleaseGC((Widget)w, w->ascii_sink.invgc); - 	XtReleaseGC((Widget)w, w->ascii_sink.xorgc); 
 	GetGC(w);; 	((TextWidget)XtParent(new))->text.redisplay_needed = True;      } else {7 	if ( (w->ascii_sink.echo != old_w->ascii_sink.echo) || , 	     (w->ascii_sink.display_nonprinting != M                                      old_w->ascii_sink.display_nonprinting) ) ? 	    ((TextWidget)XtParent(new))->text.redisplay_needed = True;      }           return False;  } 