SAVE_CFLAGS="${CFLAGS}"

AC_DEFUN(ACX_PROG_CC_M,
[
AC_REQUIRE([AC_PROG_CC])
AC_CACHE_CHECK(whether ${CC-cc} accepts -m$1, ac_$2,
[echo 'void f(){}' > conftest.c
if test -z "`${CC-cc} -m$1 -c conftest.c 2>&1`"; then
	ac_$2=yes
else
	ac_$2=no
fi
rm -f conftest*
])])

AC_DEFUN(ACX_CHECK_CC_FLAGS,
[
AC_REQUIRE([AC_PROG_CC])
AC_MSG_CHECKING([whether ${CC-cc} accepts $1])
echo 'void f(){}' > conftest.c
if test -z "`${CC-cc} $1 -c conftest.c 2>&1`"; then
        ac_prog_cc_flags_ok=yes
        $2
else	
        ac_prog_cc_flags_ok=no
        $3
fi
rm -f conftest*
AC_MSG_RESULT(${ac_prog_cc_flags_ok})
])

AC_DEFUN(ACX_PROG_CC_EGCS,
[AC_CACHE_CHECK(whether we are using the egcs variant of GCC, acx_cv_prog_egcs,
[dnl The semicolon is to pacify NeXT's syntax-checking cpp.
cat > conftest.c <<EOF
#ifdef __GNUC__
#if __GNUC_MINOR__ >= 90
  yes;
#endif
#endif
EOF
if AC_TRY_COMMAND(${CC-cc} -E conftest.c) | egrep yes >/dev/null 2>&1; then
  acx_cv_prog_egcs=yes
else
  acx_cv_prog_egcs=no
fi])])

AC_DEFUN(ACX_PROG_CC_MAXOPT,
[
AC_REQUIRE([AC_PROG_CC])
AC_REQUIRE([ACX_PROG_CC_EGCS])
AC_REQUIRE([AC_CANONICAL_HOST])

# Try to determine "good" native compiler flags if none specified on command
# line
if test "xxx${SAVE_CFLAGS}" = "xxx"; then
  CFLAGS=""
  case "${host_cpu}-${host_os}" in

  *linux*)
	echo "*******************************************************"
	echo "*       Congratulations! You are running linux.       *"
	echo "*******************************************************"
	;;
  sparc-solaris2*) if test "$CC" = cc; then
                    CFLAGS="-native -fast -xO5 -dalign"
                 fi;;

  alpha*-osf*)  if test "$CC" = cc; then
                    CFLAGS="-newc -w0 -O5 -ansi_alias -ansi_args -fp_reorder -tune host -std1"
                fi;;

  hppa*-hpux*)  if test "$CC" = cc; then
                    CFLAGS="-Ae +O3 +Oall"
                fi;;

  rs6000-aix*)  if test "$CC" = cc -o "$CC" = xlc; then
                    CFLAGS="-O3 -qarch=pwrx -qtune=pwrx -qansialias"
                fi;;
  esac

  # use default flags for gcc on all systems
  if test $ac_cv_prog_gcc = yes; then
     CFLAGS="-O6 -fomit-frame-pointer -Wall -W -Wcast-qual -Wpointer-arith -Wcast-align -pedantic"
  fi

  # the egcs scheduler is too smart and destroys our own schedule.
  # Disable the first instruction scheduling pass.  The second
  # scheduling pass (after register reload) is ok.
  if test $acx_cv_prog_egcs = yes; then
     CFLAGS="$CFLAGS -fno-schedule-insns -fschedule-insns2"
  fi

  # test for -malign-double on x86 systems
  if test $ac_cv_prog_gcc = yes; then
    ACX_PROG_CC_M(align-double,align_double)
    if test "$ac_align_double" = yes; then
       CFLAGS="$CFLAGS -malign-double"
    fi
  fi

  if test "xxx${CFLAGS}" = "xxx"; then
	echo ""
	echo "********************************************************"
        echo "* WARNING: Don't know the best CFLAGS for this system  *"
        echo "* Use  make CFLAGS=..., or edit the top level Makefile *"
	echo "* (otherwise, a default of CFLAGS=-O3 will be used)    *"
	echo "********************************************************"
	echo ""
        CFLAGS="-O3"
  fi

  ACX_CHECK_CC_FLAGS(${CFLAGS}, , [
	echo ""
        echo "********************************************************"
        echo "* WARNING: The guessed CFLAGS don't seem to work with  *"
        echo "* your compiler.                                       *"
        echo "* Use  make CFLAGS=..., or edit the top level Makefile *"
        echo "********************************************************"
        echo ""
        CFLAGS=""
  ])

  dnl try to guess correct CPU flags, at least for linux
  CPU_FLAGS=
  case "${host_cpu}" in
  i586*)	ACX_PROG_CC_M(cpu=pentium,cpu_pentium)
	if test "$ac_cpu_pentium" = yes; then
		CPU_FLAGS=-mcpu=pentium
	else
	ACX_PROG_CC_M(pentium,pentium)
	if test "$ac_mpentium" = yes; then
		CPU_FLAGS=-mpentium
	fi
	fi;;
  i686*)  ACX_PROG_CC_M(cpu=pentiumpro,cpu_pentiumpro)
	if test "$ac_cpu_pentiumpro" = yes; then
		CPU_FLAGS=-mcpu=pentiumpro
	else
	ACX_PROG_CC_M(pentiumpro,pentiumpro)
	if test "$ac_pentiumpro" = yes; then
		CPU_FLAGS=-mpentiumpro
	fi
	fi;;

  powerpc*)
        ACX_PROG_CC_M(cpu=powerpc,cpu_powerpc)
	if test "$ac_cpu_powerpc" = yes; then
		CPU_FLAGS=-mcpu=powerpc
	else
	ACX_PROG_CC_M(powerpc,powerpc)
	if test "$ac_powerpc" = yes; then
		CPU_FLAGS=-mpowerpc
	fi
	fi
        ACX_PROG_CC_M(tune=powerpc,tune_powerpc)
	if test "$ac_tune_powerpc" = yes; then
		CPU_FLAGS="${CPU_FLAGS} -mtune=powerpc"
	fi;;
  esac

  CFLAGS="$CFLAGS $CPU_FLAGS"

fi
])

dnl---------------------------------------------------------------------------

dnl detect Fortran name-mangling scheme

AC_DEFUN(ACX_F77_FUNC_MANGLE,
[
AC_REQUIRE([AC_PROG_CC])
AC_MSG_CHECKING(how f77 mangles function names)
cat > mangle-func.f <<EOF
      subroutine foobar()
      return
      end
      subroutine foo_bar()
      return
      end
EOF
ac_try='$F77 -c $FFLAGS mangle-func.f 1>&AC_FD_CC'
if AC_TRY_EVAL(ac_try); then
  ac_try=""
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat mangle-func.f >&AC_FD_CC
  rm -f mangle-func*
  AC_MSG_ERROR(failed to compile fortran test program)
fi

ac_f77_mangle_type=unknown
AC_LANG_SAVE
AC_LANG_C
ac_save_LIBS="$LIBS"
LIBS="mangle-func.o $LIBS"
AC_TRY_LINK(,foobar();,
     ac_f77_mangle_type=lowercase,
     AC_TRY_LINK(,foobar_();,
          ac_f77_mangle_type=lowercase-underscore,
          AC_TRY_LINK(,FOOBAR();,
               ac_f77_mangle_type=uppercase,
               AC_TRY_LINK(,FOOBAR_();,
                    ac_f77_mangle_type=uppercase-underscore))))
LIBS="$ac_save_LIBS"
AC_LANG_RESTORE
AC_MSG_RESULT($ac_f77_mangle_type)

case $ac_f77_mangle_type in
        lowercase)
                AC_DEFINE(FFTW_FORTRANIZE_LOWERCASE)
                mangle_try=foo_bar_
                ;;
        lowercase-underscore)
                AC_DEFINE(FFTW_FORTRANIZE_LOWERCASE_UNDERSCORE)
                mangle_try=foo_bar__
                ;;
        uppercase)
                AC_DEFINE(FFTW_FORTRANIZE_UPPERCASE)
                mangle_try=FOO_BAR_
                ;;
        uppercase-underscore)
                AC_DEFINE(FFTW_FORTRANIZE_UPPERCASE_UNDERSCORE)
                mangle_try=FOO_BAR__
                ;;
esac

AC_MSG_CHECKING(if f77 functions with an underscore get an extra underscore)

AC_LANG_SAVE
AC_LANG_C
ac_save_LIBS="$LIBS"
LIBS="mangle-func.o $LIBS"
AC_TRY_LINK(,$mangle_try();,
            [ac_f77_mangle_underscore=yes;
             AC_DEFINE(FFTW_FORTRANIZE_EXTRA_UNDERSCORE)],
            [ac_f77_mangle_underscore=no])
LIBS="$ac_save_LIBS"
AC_LANG_RESTORE
rm -f mangle-func*
AC_MSG_RESULT($ac_f77_mangle_underscore)
])

dnl like AC_SUBST, but replace XXX_variable_XXX instead of @variable@
dnl This macro protects VARIABLE from being diverted twice
dnl if this macro is called twice for it.
dnl AC_SUBST(VARIABLE)
define(ACX_SUBST_XXX,
[ifdef([ACX_SUBST_XXX_$1], ,
[define([ACX_SUBST_XXX_$1], )dnl
AC_DIVERT_PUSH(AC_DIVERSION_SED)dnl
s=XXX_$1_XXX=[$]$1=g
AC_DIVERT_POP()dnl
])])
