/*

    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#include <stdio.h>
#ifndef NO_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#include "timidity.h"
#include "aenc.h"
#include "audriv.h"
#include "timer.h"

#ifdef DEBUG
#include "audio_cnv.h"
#include <math.h>
#endif

void (* audriv_error_handler)(const char *errmsg) = NULL;

static int play_sample_rate = 8000;
static int play_sample_size = 1;
static double play_start_time;
static long play_counter, reset_samples;
static int play_encoding   = AENC_G711_ULAW;
static int play_channels = 1;
static int output_port = AUDRIV_OUTPUT_SPEAKER;
static int play_volume   = 0;
static Bool play_open_flag = False;

char audriv_errmsg[BUFSIZ];

static void audriv_err(const char *msg)
{
    strcpy(audriv_errmsg, msg);
    if(audriv_error_handler != NULL)
	audriv_error_handler(audriv_errmsg);
}

Bool audriv_setup_audio(void)
/* ǥνԤޤ
 *  True 򡤼Ԥ False ֤ޤ
 */
{
    return True;
}

void audriv_free_audio(void)
/* audio θԤޤ
 */
{
}

Bool audriv_play_open(void)
/* audio Ѥ˳ĤǤ audriv_write() ˤղǽ
 * ֤ˤޤ˳ƤϤʤˤԤޤ
 *  True 򡤼Ԥ False ֤ޤ
 */
{
    if(play_open_flag)
	return True;
    play_counter = 0;
    reset_samples = 0;
    play_open_flag = True;
    return True;
}

void audriv_play_close(void)
/* Ѥ˥ץ󤵤줿 audio ĤޤǤĤƤ
 * ϤʤˤԤޤ
 */
{
    play_open_flag = False;
}

static long calculate_play_samples(void)
{
    long n, ret;

    if(play_counter <= 0)
	return 0;

    n = (long)((double)play_sample_rate
	       * (double)play_sample_size
	       * (get_current_calender_time() - play_start_time));
    if(n > play_counter)
	ret = play_counter / play_sample_size;
    else
	ret = n / play_sample_size;

    return ret;
}

long audriv_play_stop(void)
/* դ¨¤ߤľΥץ֤ޤ
 * audriv_play_stop() θƤӽФˤäơaudio Ĥޤ
 * audio ĤƤ audriv_play_stop() ƤӽФ 0 
 * ֤ޤ
 * 顼ξ -1 ֤ޤ
 */
{
    long n;

    n = audriv_play_samples();
    play_open_flag = False;
    return n;
}

Bool audriv_is_play_open(void)
/* audio դǥץ󤵤Ƥ True,
 * ĤƤ False ֤ޤ
 */
{
    return play_open_flag;
}

Bool audriv_set_play_volume(int volume)
/* ղ̤ 0  255 ϰꤷޤ0 ̵255 Ϻ粻̡
 * 0 ̤ 0255 Ķͤ 255 
 *  True 򡤼Ԥ False ֤ޤ
 */
{
    if(volume < 0)
	play_volume = 0;
    else if(volume > 255)
	play_volume = 255;
    else
	play_volume = volume;
    return True;
}

int audriv_get_play_volume(void)
/* ղ̤ 0  255 ޤ0 ̵255 Ϻ粻̡
 * Ԥ -1 ֤Ǥʤ 0  255 β̤֤ޤ
 */
{
    return play_volume;
}

Bool audriv_set_play_output(int port)
/* audio ν port ꤷޤport ˤϰʲΤɤ줫ꤷޤ
 *
 *     AUDRIV_OUTPUT_SPEAKER	ԡ˽ϡ
 *     AUDRIV_OUTPUT_HEADPHONE	إåɥۥ˽ϡ
 *     AUDRIV_OUTPUT_LINE_OUT	饤󥢥Ȥ˽ϡ
 *
 *  True 򡤼Ԥ False ֤ޤ
 */
{
    switch(port)
    {
      case AUDRIV_OUTPUT_SPEAKER:
      case AUDRIV_OUTPUT_HEADPHONE:
      case AUDRIV_OUTPUT_LINE_OUT:
	output_port = port;
	break;
      default:
	audriv_err("곰νϥݡȤꤵޤ");
	return False;
    }
    return True;
}

int audriv_get_play_output(void)
/* audio ν port ޤ
 * Ԥ -1 ֤ȰʲΤ줫֤ͤޤ
 *
 *     AUDRIV_OUTPUT_SPEAKER	ԡ˽ϡ
 *     AUDRIV_OUTPUT_HEADPHONE	إåɥۥ˽ϡ
 *     AUDRIV_OUTPUT_LINE_OUT	饤󥢥Ȥ˽ϡ
 *
 */
{
    return output_port;
}

int audriv_get_record_volume(void)
/* Ͽ̤ 0  255 ޤ0 ̵255 Ϻ粻̡
 * Ԥ -1 ֤Ǥʤ 0  255 β̤֤ޤ
 */
{
    return record_volume;
}

int audriv_write(char *buff, int n)
/* audio  buff  n Хʬήߤޤ
 * audriv_set_noblock_write() ֥å⡼ɤꤵ줿
 * ϡδؿθƤӽФ¨¤˽֤ޤ
 * ֤ͤϼºݤήޤ줿ХȿǤꡤ֥å⡼ɤ
 * Ƥϡ n 꾯ʤ礬ޤ
 * Ԥ -1 ֤ȡºݤήޤ줿Хȿ֤ޤ
 */
{
    long qsz;

    qsz = audriv_get_filled();
    if(qsz == -1)
	return -1;
    if(qsz == 0)
    {
	reset_samples += play_counter / play_sample_size;
	play_counter = 0; /* Reset start time */
    }
    if(play_counter == 0)
	play_start_time = get_current_calender_time();
    play_counter += n;
    return n;
}

Bool audriv_set_noblock_write(Bool noblock)
/* noblock  True ꤹȡaudriv_write() ƤӽФǥ֥åޤ
 * False ꤹȡǥեȤξ֤ᤷޤ
 *  True 򡤼Ԥ False ֤ޤ
 */
{
    return True;
}

int audriv_play_active(void)
/* ʤ 1Ǥʤʤ 0, 顼ʤ -1 ֤ޤ
 */
{
    long n;

    n = audriv_get_filled();
    if(n > 0)
	return 1;
    return n;
}

long audriv_play_samples(void)
/* ߱Υץ֤֤ޤ
 */
{
    return reset_samples + calculate_play_samples();
}

long audriv_get_filled(void)
/* ǥХåեΥХȿ֤ޤ
 * 顼ξ -1 ֤ޤ
 */
{
    long n;

    if(play_counter <= 0)
	return 0;
    n = (int)((double)play_sample_rate
	      * play_sample_size
	      * (get_current_calender_time() - play_start_time));
    if(n > play_counter)
	return 0;
    return play_counter - n;
}

const long *audriv_available_encodings(int *n_ret)
/* ޥ󤬥ݡȤƤ뤹٤Ƥ沽ꥹȤ֤ޤn_ret ˤ
 * μο֤ޤ沽򤢤魯ͤ
 * usffd.h Ƥ enum usffd_data_encoding ͤǤ
 * ֤ͤ free ƤϤʤޤ
 */
{
    static const long encoding_list[] =
    {
	AENC_SIGBYTE, AENC_UNSIGBYTE, AENC_G711_ULAW,
	AENC_G711_ALAW, AENC_SIGWORDB, AENC_UNSIGWORDB,
	AENC_SIGWORDL, AENC_UNSIGWORDL
    };

    *n_ret = 8;
    return encoding_list;
}

const long *audriv_available_sample_rates(int *n_ret)
/* ޥ󤬥ݡȤƤ뤹٤ƤΥץ졼ȤΥꥹȤ֤ޤ
 * n_ret ˤϤμο֤ޤ
 * ֤ͤ free ƤϤʤޤ
 */
{
    static const long sample_rates[] =
    {
	5512, 6615,
	8000, 9600, 11025, 16000, 18900, 22050, 32000, 37800, 44100, 48000
    };
    *n_ret = 12;
    return sample_rates;
}

const long *audriv_available_channels(int *n_ret)
/* ޥ󤬥ݡȤƤ뤹٤ƤΥͥΥꥹȤ֤ޤ
 * n_ret ˤϤμο֤ޤ
 * ֤ͤ free ƤϤʤޤ
 */
{
    static const long channels[] = {1, 2};
    *n_ret = 2;
    return channels;
}

Bool audriv_set_play_encoding(long encoding)
/* audio ջ沽ꤷޤ
 *  True 򡤼Ԥ False ֤ޤ
 */
{
    int i, n;
    const long *enc;

    enc = audriv_available_encodings(&n);
    for(i = 0; i < n; i++)
	if(enc[i] == encoding)
	{
	    play_encoding = encoding;
	    play_sample_size = AENC_SAMPW(encoding) * play_channels;
	    return True;
	}
    return False;
}

Bool audriv_set_play_sample_rate(long sample_rate)
/* audio ջΥץ졼Ȥꤷޤ
 *  True 򡤼Ԥ False ֤ޤ
 */
{
    int i, n;
    const long *r;

    r = audriv_available_sample_rates(&n);
    for(i = 0; i < n; i++)
	if(r[i] == sample_rate)
	{
	    play_sample_rate = sample_rate;
	    return True;
	}
    return False;
}

Bool audriv_set_play_channels(long channels)
/* ѤΥͥꤷޤ
 * Ԥ False ֤ True ֤ޤ
 */
{
    int i, n;
    const long *c = audriv_available_channels(&n);

    for(i = 0; i < n; i++)
	if(channels == c[i])
	{
	    play_channels = channels;
	    return True;
	}
    return False;
}

void audriv_wait_play(void)
/* CPU ѥϲ񤷤ʤ褦ˤ뤿ˡŪߤޤ*/
{
}
