/*

    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    audio_cnv.c

    Audio conversion for U-law, A-law, linear pcm 16-bit.
    Final update: Thu Feb 22 1996
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#include "timidity.h"
#include "audio_cnv.h"

/* audio_cnv.c
 * audio U-law, A-law, linear pcm 16-bit conversions.
 *
 * Final update: Thu Feb 22 1996
 */

#define TABLE_SIZE8  256
#define TABLE_SIZE14 16384

const char u2c_table[TABLE_SIZE8] = {
0x82,	0x86,	0x8a,	0x8e,	0x92,	0x96,	0x9a,	0x9e,
0xa2,	0xa6,	0xaa,	0xae,	0xb2,	0xb6,	0xba,	0xbe,
0xc1,	0xc3,	0xc5,	0xc7,	0xc9,	0xcb,	0xcd,	0xcf,
0xd1,	0xd3,	0xd5,	0xd7,	0xd9,	0xdb,	0xdd,	0xdf,
0xe0,	0xe1,	0xe2,	0xe3,	0xe4,	0xe5,	0xe6,	0xe7,
0xe8,	0xe9,	0xea,	0xeb,	0xec,	0xed,	0xee,	0xef,
0xf0,	0xf1,	0xf1,	0xf2,	0xf2,	0xf3,	0xf3,	0xf4,
0xf4,	0xf5,	0xf5,	0xf6,	0xf6,	0xf7,	0xf7,	0xf8,
0xf8,	0xf8,	0xf9,	0xf9,	0xf9,	0xf9,	0xfa,	0xfa,
0xfa,	0xfa,	0xfb,	0xfb,	0xfb,	0xfb,	0xfc,	0xfc,
0xfc,	0xfc,	0xfc,	0xfc,	0xfd,	0xfd,	0xfd,	0xfd,
0xfd,	0xfd,	0xfd,	0xfd,	0xfe,	0xfe,	0xfe,	0xfe,
0xfe,	0xfe,	0xfe,	0xfe,	0xfe,	0xfe,	0xfe,	0xfe,
0xff,	0xff,	0xff,	0xff,	0xff,	0xff,	0xff,	0xff,
0xff,	0xff,	0xff,	0xff,	0xff,	0xff,	0xff,	0xff,
0xff,	0xff,	0xff,	0xff,	0xff,	0xff,	0xff,	0x00,
0x7e,	0x79,	0x75,	0x71,	0x6d,	0x69,	0x65,	0x61,
0x5d,	0x59,	0x55,	0x51,	0x4d,	0x49,	0x45,	0x41,
0x3e,	0x3c,	0x3a,	0x38,	0x36,	0x34,	0x32,	0x30,
0x2e,	0x2c,	0x2a,	0x28,	0x26,	0x24,	0x22,	0x20,
0x1f,	0x1e,	0x1d,	0x1c,	0x1b,	0x1a,	0x19,	0x18,
0x17,	0x16,	0x15,	0x14,	0x13,	0x12,	0x11,	0x10,
0x0f,	0x0e,	0x0e,	0x0d,	0x0d,	0x0c,	0x0c,	0x0b,
0x0b,	0x0a,	0x0a,	0x09,	0x09,	0x08,	0x08,	0x07,
0x07,	0x07,	0x06,	0x06,	0x06,	0x06,	0x05,	0x05,
0x05,	0x05,	0x04,	0x04,	0x04,	0x04,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00};

const char c2u_table[TABLE_SIZE8] = {
0xf0,	0xe0,	0xd8,	0xd0,	0xcc,	0xc8,	0xc4,	0xc0,
0xbe,	0xbc,	0xba,	0xb8,	0xb6,	0xb4,	0xb2,	0xb0,
0xaf,	0xae,	0xad,	0xac,	0xab,	0xaa,	0xa9,	0xa8,
0xa7,	0xa6,	0xa5,	0xa4,	0xa3,	0xa2,	0xa1,	0xa0,
0x9f,	0x9f,	0x9e,	0x9e,	0x9d,	0x9d,	0x9c,	0x9c,
0x9b,	0x9b,	0x9a,	0x9a,	0x99,	0x99,	0x98,	0x98,
0x97,	0x97,	0x96,	0x96,	0x95,	0x95,	0x94,	0x94,
0x93,	0x93,	0x92,	0x92,	0x91,	0x91,	0x90,	0x90,
0x8f,	0x8f,	0x8f,	0x8f,	0x8e,	0x8e,	0x8e,	0x8e,
0x8d,	0x8d,	0x8d,	0x8d,	0x8c,	0x8c,	0x8c,	0x8c,
0x8b,	0x8b,	0x8b,	0x8b,	0x8a,	0x8a,	0x8a,	0x8a,
0x89,	0x89,	0x89,	0x89,	0x88,	0x88,	0x88,	0x88,
0x87,	0x87,	0x87,	0x87,	0x86,	0x86,	0x86,	0x86,
0x85,	0x85,	0x85,	0x85,	0x84,	0x84,	0x84,	0x84,
0x83,	0x83,	0x83,	0x83,	0x82,	0x82,	0x82,	0x82,
0x81,	0x81,	0x81,	0x81,	0x80,	0x80,	0x80,	0x80,
0x00,	0x00,	0x00,	0x00,	0x01,	0x01,	0x01,	0x01,
0x02,	0x02,	0x02,	0x02,	0x03,	0x03,	0x03,	0x03,
0x04,	0x04,	0x04,	0x04,	0x05,	0x05,	0x05,	0x05,
0x06,	0x06,	0x06,	0x06,	0x07,	0x07,	0x07,	0x07,
0x08,	0x08,	0x08,	0x08,	0x09,	0x09,	0x09,	0x09,
0x0a,	0x0a,	0x0a,	0x0a,	0x0b,	0x0b,	0x0b,	0x0b,
0x0c,	0x0c,	0x0c,	0x0c,	0x0d,	0x0d,	0x0d,	0x0d,
0x0e,	0x0e,	0x0e,	0x0e,	0x0f,	0x0f,	0x0f,	0x0f,
0x10,	0x10,	0x11,	0x11,	0x12,	0x12,	0x13,	0x13,
0x14,	0x14,	0x15,	0x15,	0x16,	0x16,	0x17,	0x17,
0x18,	0x18,	0x19,	0x19,	0x1a,	0x1a,	0x1b,	0x1b,
0x1c,	0x1c,	0x1d,	0x1d,	0x1e,	0x1e,	0x1f,	0x1f,
0x20,	0x21,	0x22,	0x23,	0x24,	0x25,	0x26,	0x27,
0x28,	0x29,	0x2a,	0x2b,	0x2c,	0x2d,	0x2e,	0x2f,
0x30,	0x32,	0x34,	0x36,	0x38,	0x3a,	0x3c,	0x3d,
0x3f,	0x43,	0x47,	0x4b,	0x4f,	0x57,	0x5f,	0x6f};

const char c2a_table[TABLE_SIZE8] = {
0xd5,	0xc5,	0xf5,	0xfd,	0xe5,	0xe1,	0xed,	0xe9,
0x95,	0x97,	0x91,	0x93,	0x9d,	0x9f,	0x99,	0x9b,
0x85,	0x84,	0x87,	0x86,	0x81,	0x80,	0x83,	0x82,
0x8d,	0x8c,	0x8f,	0x8e,	0x89,	0x88,	0x8b,	0x8a,
0xb5,	0xb5,	0xb4,	0xb4,	0xb7,	0xb7,	0xb6,	0xb6,
0xb1,	0xb1,	0xb0,	0xb0,	0xb3,	0xb3,	0xb2,	0xb2,
0xbd,	0xbd,	0xbc,	0xbc,	0xbf,	0xbf,	0xbe,	0xbe,
0xb9,	0xb9,	0xb8,	0xb8,	0xbb,	0xbb,	0xba,	0xba,
0xa5,	0xa5,	0xa5,	0xa5,	0xa4,	0xa4,	0xa4,	0xa4,
0xa7,	0xa7,	0xa7,	0xa7,	0xa6,	0xa6,	0xa6,	0xa6,
0xa1,	0xa1,	0xa1,	0xa1,	0xa0,	0xa0,	0xa0,	0xa0,
0xa3,	0xa3,	0xa3,	0xa3,	0xa2,	0xa2,	0xa2,	0xa2,
0xad,	0xad,	0xad,	0xad,	0xac,	0xac,	0xac,	0xac,
0xaf,	0xaf,	0xaf,	0xaf,	0xae,	0xae,	0xae,	0xae,
0xa9,	0xa9,	0xa9,	0xa9,	0xa8,	0xa8,	0xa8,	0xa8,
0xab,	0xab,	0xab,	0xab,	0xaa,	0xaa,	0xaa,	0xaa,
0x2a,	0x2a,	0x2a,	0x2a,	0x2b,	0x2b,	0x2b,	0x2b,
0x28,	0x28,	0x28,	0x28,	0x29,	0x29,	0x29,	0x29,
0x2e,	0x2e,	0x2e,	0x2e,	0x2f,	0x2f,	0x2f,	0x2f,
0x2c,	0x2c,	0x2c,	0x2c,	0x2d,	0x2d,	0x2d,	0x2d,
0x22,	0x22,	0x22,	0x22,	0x23,	0x23,	0x23,	0x23,
0x20,	0x20,	0x20,	0x20,	0x21,	0x21,	0x21,	0x21,
0x26,	0x26,	0x26,	0x26,	0x27,	0x27,	0x27,	0x27,
0x24,	0x24,	0x24,	0x24,	0x25,	0x25,	0x25,	0x25,
0x3a,	0x3a,	0x3b,	0x3b,	0x38,	0x38,	0x39,	0x39,
0x3e,	0x3e,	0x3f,	0x3f,	0x3c,	0x3c,	0x3d,	0x3d,
0x32,	0x32,	0x33,	0x33,	0x30,	0x30,	0x31,	0x31,
0x36,	0x36,	0x37,	0x37,	0x34,	0x34,	0x35,	0x35,
0x0a,	0x0b,	0x08,	0x09,	0x0e,	0x0f,	0x0c,	0x0d,
0x02,	0x03,	0x00,	0x01,	0x06,	0x07,	0x04,	0x05,
0x1a,	0x18,	0x1e,	0x1c,	0x12,	0x10,	0x16,	0x14,
0x6a,	0x6e,	0x62,	0x66,	0x7a,	0x72,	0x4a,	0x5a};

const char a2c_table[TABLE_SIZE8] = {
0xeb,	0xec,	0xe9,	0xea,	0xef,	0xf0,	0xed,	0xee,
0xe3,	0xe4,	0xe1,	0xe2,	0xe7,	0xe8,	0xe5,	0xe6,
0xf6,	0xf6,	0xf5,	0xf5,	0xf8,	0xf8,	0xf7,	0xf7,
0xf2,	0xf2,	0xf1,	0xf1,	0xf4,	0xf4,	0xf3,	0xf3,
0xaa,	0xae,	0xa2,	0xa6,	0xba,	0xbe,	0xb2,	0xb6,
0x8a,	0x8e,	0x82,	0x86,	0x9a,	0x9e,	0x92,	0x96,
0xd5,	0xd7,	0xd1,	0xd3,	0xdd,	0xdf,	0xd9,	0xdb,
0xc5,	0xc7,	0xc1,	0xc3,	0xcd,	0xcf,	0xc9,	0xcb,
0xff,	0xff,	0xff,	0xff,	0xff,	0xff,	0xff,	0xff,
0xff,	0xff,	0xff,	0xff,	0xff,	0xff,	0xff,	0xff,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0xfb,	0xfb,	0xfb,	0xfb,	0xfc,	0xfc,	0xfc,	0xfc,
0xf9,	0xf9,	0xf9,	0xf9,	0xfa,	0xfa,	0xfa,	0xfa,
0xfe,	0xfe,	0xfe,	0xfe,	0xfe,	0xfe,	0xfe,	0xfe,
0xfd,	0xfd,	0xfd,	0xfd,	0xfd,	0xfd,	0xfd,	0xfd,
0x15,	0x14,	0x17,	0x16,	0x11,	0x10,	0x13,	0x12,
0x1d,	0x1c,	0x1f,	0x1e,	0x19,	0x18,	0x1b,	0x1a,
0x0a,	0x0a,	0x0b,	0x0b,	0x08,	0x08,	0x09,	0x09,
0x0e,	0x0e,	0x0f,	0x0f,	0x0c,	0x0c,	0x0d,	0x0d,
0x56,	0x52,	0x5e,	0x5a,	0x46,	0x42,	0x4e,	0x4a,
0x76,	0x72,	0x7e,	0x7a,	0x66,	0x62,	0x6e,	0x6a,
0x2b,	0x29,	0x2f,	0x2d,	0x23,	0x21,	0x27,	0x25,
0x3b,	0x39,	0x3f,	0x3d,	0x33,	0x31,	0x37,	0x35,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x05,	0x05,	0x05,	0x05,	0x04,	0x04,	0x04,	0x04,
0x07,	0x07,	0x07,	0x07,	0x06,	0x06,	0x06,	0x06,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03};

const short u2s_table[TABLE_SIZE8] = {
0x8284,	0x8684,	0x8a84,	0x8e84,	0x9284,	0x9684,	0x9a84,	0x9e84,
0xa284,	0xa684,	0xaa84,	0xae84,	0xb284,	0xb684,	0xba84,	0xbe84,
0xc184,	0xc384,	0xc584,	0xc784,	0xc984,	0xcb84,	0xcd84,	0xcf84,
0xd184,	0xd384,	0xd584,	0xd784,	0xd984,	0xdb84,	0xdd84,	0xdf84,
0xe104,	0xe204,	0xe304,	0xe404,	0xe504,	0xe604,	0xe704,	0xe804,
0xe904,	0xea04,	0xeb04,	0xec04,	0xed04,	0xee04,	0xef04,	0xf004,
0xf0c4,	0xf144,	0xf1c4,	0xf244,	0xf2c4,	0xf344,	0xf3c4,	0xf444,
0xf4c4,	0xf544,	0xf5c4,	0xf644,	0xf6c4,	0xf744,	0xf7c4,	0xf844,
0xf8a4,	0xf8e4,	0xf924,	0xf964,	0xf9a4,	0xf9e4,	0xfa24,	0xfa64,
0xfaa4,	0xfae4,	0xfb24,	0xfb64,	0xfba4,	0xfbe4,	0xfc24,	0xfc64,
0xfc94,	0xfcb4,	0xfcd4,	0xfcf4,	0xfd14,	0xfd34,	0xfd54,	0xfd74,
0xfd94,	0xfdb4,	0xfdd4,	0xfdf4,	0xfe14,	0xfe34,	0xfe54,	0xfe74,
0xfe8c,	0xfe9c,	0xfeac,	0xfebc,	0xfecc,	0xfedc,	0xfeec,	0xfefc,
0xff0c,	0xff1c,	0xff2c,	0xff3c,	0xff4c,	0xff5c,	0xff6c,	0xff7c,
0xff88,	0xff90,	0xff98,	0xffa0,	0xffa8,	0xffb0,	0xffb8,	0xffc0,
0xffc8,	0xffd0,	0xffd8,	0xffe0,	0xffe8,	0xfff0,	0xfff8,	0x0000,
0x7d7c,	0x797c,	0x757c,	0x717c,	0x6d7c,	0x697c,	0x657c,	0x617c,
0x5d7c,	0x597c,	0x557c,	0x517c,	0x4d7c,	0x497c,	0x457c,	0x417c,
0x3e7c,	0x3c7c,	0x3a7c,	0x387c,	0x367c,	0x347c,	0x327c,	0x307c,
0x2e7c,	0x2c7c,	0x2a7c,	0x287c,	0x267c,	0x247c,	0x227c,	0x207c,
0x1efc,	0x1dfc,	0x1cfc,	0x1bfc,	0x1afc,	0x19fc,	0x18fc,	0x17fc,
0x16fc,	0x15fc,	0x14fc,	0x13fc,	0x12fc,	0x11fc,	0x10fc,	0x0ffc,
0x0f3c,	0x0ebc,	0x0e3c,	0x0dbc,	0x0d3c,	0x0cbc,	0x0c3c,	0x0bbc,
0x0b3c,	0x0abc,	0x0a3c,	0x09bc,	0x093c,	0x08bc,	0x083c,	0x07bc,
0x075c,	0x071c,	0x06dc,	0x069c,	0x065c,	0x061c,	0x05dc,	0x059c,
0x055c,	0x051c,	0x04dc,	0x049c,	0x045c,	0x041c,	0x03dc,	0x039c,
0x036c,	0x034c,	0x032c,	0x030c,	0x02ec,	0x02cc,	0x02ac,	0x028c,
0x026c,	0x024c,	0x022c,	0x020c,	0x01ec,	0x01cc,	0x01ac,	0x018c,
0x0174,	0x0164,	0x0154,	0x0144,	0x0134,	0x0124,	0x0114,	0x0104,
0x00f4,	0x00e4,	0x00d4,	0x00c4,	0x00b4,	0x00a4,	0x0094,	0x0084,
0x0078,	0x0070,	0x0068,	0x0060,	0x0058,	0x0050,	0x0048,	0x0040,
0x0038,	0x0030,	0x0028,	0x0020,	0x0018,	0x0010,	0x0008,	0x0000};

const char s2u_table[TABLE_SIZE14] = {
0xff,	0xfe,	0xfe,	0xfd,	0xfd,	0xfc,	0xfc,	0xfb,
0xfb,	0xfa,	0xfa,	0xf9,	0xf9,	0xf8,	0xf8,	0xf7,
0xf7,	0xf6,	0xf6,	0xf5,	0xf5,	0xf4,	0xf4,	0xf3,
0xf3,	0xf2,	0xf2,	0xf1,	0xf1,	0xf0,	0xf0,	0xef,
0xef,	0xef,	0xef,	0xee,	0xee,	0xee,	0xee,	0xed,
0xed,	0xed,	0xed,	0xec,	0xec,	0xec,	0xec,	0xeb,
0xeb,	0xeb,	0xeb,	0xea,	0xea,	0xea,	0xea,	0xe9,
0xe9,	0xe9,	0xe9,	0xe8,	0xe8,	0xe8,	0xe8,	0xe7,
0xe7,	0xe7,	0xe7,	0xe6,	0xe6,	0xe6,	0xe6,	0xe5,
0xe5,	0xe5,	0xe5,	0xe4,	0xe4,	0xe4,	0xe4,	0xe3,
0xe3,	0xe3,	0xe3,	0xe2,	0xe2,	0xe2,	0xe2,	0xe1,
0xe1,	0xe1,	0xe1,	0xe0,	0xe0,	0xe0,	0xe0,	0xdf,
0xdf,	0xdf,	0xdf,	0xdf,	0xdf,	0xdf,	0xdf,	0xde,
0xde,	0xde,	0xde,	0xde,	0xde,	0xde,	0xde,	0xdd,
0xdd,	0xdd,	0xdd,	0xdd,	0xdd,	0xdd,	0xdd,	0xdc,
0xdc,	0xdc,	0xdc,	0xdc,	0xdc,	0xdc,	0xdc,	0xdb,
0xdb,	0xdb,	0xdb,	0xdb,	0xdb,	0xdb,	0xdb,	0xda,
0xda,	0xda,	0xda,	0xda,	0xda,	0xda,	0xda,	0xd9,
0xd9,	0xd9,	0xd9,	0xd9,	0xd9,	0xd9,	0xd9,	0xd8,
0xd8,	0xd8,	0xd8,	0xd8,	0xd8,	0xd8,	0xd8,	0xd7,
0xd7,	0xd7,	0xd7,	0xd7,	0xd7,	0xd7,	0xd7,	0xd6,
0xd6,	0xd6,	0xd6,	0xd6,	0xd6,	0xd6,	0xd6,	0xd5,
0xd5,	0xd5,	0xd5,	0xd5,	0xd5,	0xd5,	0xd5,	0xd4,
0xd4,	0xd4,	0xd4,	0xd4,	0xd4,	0xd4,	0xd4,	0xd3,
0xd3,	0xd3,	0xd3,	0xd3,	0xd3,	0xd3,	0xd3,	0xd2,
0xd2,	0xd2,	0xd2,	0xd2,	0xd2,	0xd2,	0xd2,	0xd1,
0xd1,	0xd1,	0xd1,	0xd1,	0xd1,	0xd1,	0xd1,	0xd0,
0xd0,	0xd0,	0xd0,	0xd0,	0xd0,	0xd0,	0xd0,	0xcf,
0xcf,	0xcf,	0xcf,	0xcf,	0xcf,	0xcf,	0xcf,	0xcf,
0xcf,	0xcf,	0xcf,	0xcf,	0xcf,	0xcf,	0xcf,	0xce,
0xce,	0xce,	0xce,	0xce,	0xce,	0xce,	0xce,	0xce,
0xce,	0xce,	0xce,	0xce,	0xce,	0xce,	0xce,	0xcd,
0xcd,	0xcd,	0xcd,	0xcd,	0xcd,	0xcd,	0xcd,	0xcd,
0xcd,	0xcd,	0xcd,	0xcd,	0xcd,	0xcd,	0xcd,	0xcc,
0xcc,	0xcc,	0xcc,	0xcc,	0xcc,	0xcc,	0xcc,	0xcc,
0xcc,	0xcc,	0xcc,	0xcc,	0xcc,	0xcc,	0xcc,	0xcb,
0xcb,	0xcb,	0xcb,	0xcb,	0xcb,	0xcb,	0xcb,	0xcb,
0xcb,	0xcb,	0xcb,	0xcb,	0xcb,	0xcb,	0xcb,	0xca,
0xca,	0xca,	0xca,	0xca,	0xca,	0xca,	0xca,	0xca,
0xca,	0xca,	0xca,	0xca,	0xca,	0xca,	0xca,	0xc9,
0xc9,	0xc9,	0xc9,	0xc9,	0xc9,	0xc9,	0xc9,	0xc9,
0xc9,	0xc9,	0xc9,	0xc9,	0xc9,	0xc9,	0xc9,	0xc8,
0xc8,	0xc8,	0xc8,	0xc8,	0xc8,	0xc8,	0xc8,	0xc8,
0xc8,	0xc8,	0xc8,	0xc8,	0xc8,	0xc8,	0xc8,	0xc7,
0xc7,	0xc7,	0xc7,	0xc7,	0xc7,	0xc7,	0xc7,	0xc7,
0xc7,	0xc7,	0xc7,	0xc7,	0xc7,	0xc7,	0xc7,	0xc6,
0xc6,	0xc6,	0xc6,	0xc6,	0xc6,	0xc6,	0xc6,	0xc6,
0xc6,	0xc6,	0xc6,	0xc6,	0xc6,	0xc6,	0xc6,	0xc5,
0xc5,	0xc5,	0xc5,	0xc5,	0xc5,	0xc5,	0xc5,	0xc5,
0xc5,	0xc5,	0xc5,	0xc5,	0xc5,	0xc5,	0xc5,	0xc4,
0xc4,	0xc4,	0xc4,	0xc4,	0xc4,	0xc4,	0xc4,	0xc4,
0xc4,	0xc4,	0xc4,	0xc4,	0xc4,	0xc4,	0xc4,	0xc3,
0xc3,	0xc3,	0xc3,	0xc3,	0xc3,	0xc3,	0xc3,	0xc3,
0xc3,	0xc3,	0xc3,	0xc3,	0xc3,	0xc3,	0xc3,	0xc2,
0xc2,	0xc2,	0xc2,	0xc2,	0xc2,	0xc2,	0xc2,	0xc2,
0xc2,	0xc2,	0xc2,	0xc2,	0xc2,	0xc2,	0xc2,	0xc1,
0xc1,	0xc1,	0xc1,	0xc1,	0xc1,	0xc1,	0xc1,	0xc1,
0xc1,	0xc1,	0xc1,	0xc1,	0xc1,	0xc1,	0xc1,	0xc0,
0xc0,	0xc0,	0xc0,	0xc0,	0xc0,	0xc0,	0xc0,	0xc0,
0xc0,	0xc0,	0xc0,	0xc0,	0xc0,	0xc0,	0xc0,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x40,	0x40,	0x40,	0x40,	0x40,	0x40,
0x40,	0x40,	0x40,	0x40,	0x40,	0x40,	0x40,	0x40,
0x40,	0x40,	0x41,	0x41,	0x41,	0x41,	0x41,	0x41,
0x41,	0x41,	0x41,	0x41,	0x41,	0x41,	0x41,	0x41,
0x41,	0x41,	0x42,	0x42,	0x42,	0x42,	0x42,	0x42,
0x42,	0x42,	0x42,	0x42,	0x42,	0x42,	0x42,	0x42,
0x42,	0x42,	0x43,	0x43,	0x43,	0x43,	0x43,	0x43,
0x43,	0x43,	0x43,	0x43,	0x43,	0x43,	0x43,	0x43,
0x43,	0x43,	0x44,	0x44,	0x44,	0x44,	0x44,	0x44,
0x44,	0x44,	0x44,	0x44,	0x44,	0x44,	0x44,	0x44,
0x44,	0x44,	0x45,	0x45,	0x45,	0x45,	0x45,	0x45,
0x45,	0x45,	0x45,	0x45,	0x45,	0x45,	0x45,	0x45,
0x45,	0x45,	0x46,	0x46,	0x46,	0x46,	0x46,	0x46,
0x46,	0x46,	0x46,	0x46,	0x46,	0x46,	0x46,	0x46,
0x46,	0x46,	0x47,	0x47,	0x47,	0x47,	0x47,	0x47,
0x47,	0x47,	0x47,	0x47,	0x47,	0x47,	0x47,	0x47,
0x47,	0x47,	0x48,	0x48,	0x48,	0x48,	0x48,	0x48,
0x48,	0x48,	0x48,	0x48,	0x48,	0x48,	0x48,	0x48,
0x48,	0x48,	0x49,	0x49,	0x49,	0x49,	0x49,	0x49,
0x49,	0x49,	0x49,	0x49,	0x49,	0x49,	0x49,	0x49,
0x49,	0x49,	0x4a,	0x4a,	0x4a,	0x4a,	0x4a,	0x4a,
0x4a,	0x4a,	0x4a,	0x4a,	0x4a,	0x4a,	0x4a,	0x4a,
0x4a,	0x4a,	0x4b,	0x4b,	0x4b,	0x4b,	0x4b,	0x4b,
0x4b,	0x4b,	0x4b,	0x4b,	0x4b,	0x4b,	0x4b,	0x4b,
0x4b,	0x4b,	0x4c,	0x4c,	0x4c,	0x4c,	0x4c,	0x4c,
0x4c,	0x4c,	0x4c,	0x4c,	0x4c,	0x4c,	0x4c,	0x4c,
0x4c,	0x4c,	0x4d,	0x4d,	0x4d,	0x4d,	0x4d,	0x4d,
0x4d,	0x4d,	0x4d,	0x4d,	0x4d,	0x4d,	0x4d,	0x4d,
0x4d,	0x4d,	0x4e,	0x4e,	0x4e,	0x4e,	0x4e,	0x4e,
0x4e,	0x4e,	0x4e,	0x4e,	0x4e,	0x4e,	0x4e,	0x4e,
0x4e,	0x4e,	0x4f,	0x4f,	0x4f,	0x4f,	0x4f,	0x4f,
0x4f,	0x4f,	0x4f,	0x4f,	0x4f,	0x4f,	0x4f,	0x4f,
0x4f,	0x4f,	0x50,	0x50,	0x50,	0x50,	0x50,	0x50,
0x50,	0x50,	0x51,	0x51,	0x51,	0x51,	0x51,	0x51,
0x51,	0x51,	0x52,	0x52,	0x52,	0x52,	0x52,	0x52,
0x52,	0x52,	0x53,	0x53,	0x53,	0x53,	0x53,	0x53,
0x53,	0x53,	0x54,	0x54,	0x54,	0x54,	0x54,	0x54,
0x54,	0x54,	0x55,	0x55,	0x55,	0x55,	0x55,	0x55,
0x55,	0x55,	0x56,	0x56,	0x56,	0x56,	0x56,	0x56,
0x56,	0x56,	0x57,	0x57,	0x57,	0x57,	0x57,	0x57,
0x57,	0x57,	0x58,	0x58,	0x58,	0x58,	0x58,	0x58,
0x58,	0x58,	0x59,	0x59,	0x59,	0x59,	0x59,	0x59,
0x59,	0x59,	0x5a,	0x5a,	0x5a,	0x5a,	0x5a,	0x5a,
0x5a,	0x5a,	0x5b,	0x5b,	0x5b,	0x5b,	0x5b,	0x5b,
0x5b,	0x5b,	0x5c,	0x5c,	0x5c,	0x5c,	0x5c,	0x5c,
0x5c,	0x5c,	0x5d,	0x5d,	0x5d,	0x5d,	0x5d,	0x5d,
0x5d,	0x5d,	0x5e,	0x5e,	0x5e,	0x5e,	0x5e,	0x5e,
0x5e,	0x5e,	0x5f,	0x5f,	0x5f,	0x5f,	0x5f,	0x5f,
0x5f,	0x5f,	0x60,	0x60,	0x60,	0x60,	0x61,	0x61,
0x61,	0x61,	0x62,	0x62,	0x62,	0x62,	0x63,	0x63,
0x63,	0x63,	0x64,	0x64,	0x64,	0x64,	0x65,	0x65,
0x65,	0x65,	0x66,	0x66,	0x66,	0x66,	0x67,	0x67,
0x67,	0x67,	0x68,	0x68,	0x68,	0x68,	0x69,	0x69,
0x69,	0x69,	0x6a,	0x6a,	0x6a,	0x6a,	0x6b,	0x6b,
0x6b,	0x6b,	0x6c,	0x6c,	0x6c,	0x6c,	0x6d,	0x6d,
0x6d,	0x6d,	0x6e,	0x6e,	0x6e,	0x6e,	0x6f,	0x6f,
0x6f,	0x6f,	0x70,	0x70,	0x71,	0x71,	0x72,	0x72,
0x73,	0x73,	0x74,	0x74,	0x75,	0x75,	0x76,	0x76,
0x77,	0x77,	0x78,	0x78,	0x79,	0x79,	0x7a,	0x7a,
0x7b,	0x7b,	0x7c,	0x7c,	0x7d,	0x7d,	0x7e,	0x7e};

const short a2s_table[TABLE_SIZE8] = {
0xea80,	0xeb80,	0xe880,	0xe980,	0xee80,	0xef80,	0xec80,	0xed80,
0xe280,	0xe380,	0xe080,	0xe180,	0xe680,	0xe780,	0xe480,	0xe580,
0xf540,	0xf5c0,	0xf440,	0xf4c0,	0xf740,	0xf7c0,	0xf640,	0xf6c0,
0xf140,	0xf1c0,	0xf040,	0xf0c0,	0xf340,	0xf3c0,	0xf240,	0xf2c0,
0xaa00,	0xae00,	0xa200,	0xa600,	0xba00,	0xbe00,	0xb200,	0xb600,
0x8a00,	0x8e00,	0x8200,	0x8600,	0x9a00,	0x9e00,	0x9200,	0x9600,
0xd500,	0xd700,	0xd100,	0xd300,	0xdd00,	0xdf00,	0xd900,	0xdb00,
0xc500,	0xc700,	0xc100,	0xc300,	0xcd00,	0xcf00,	0xc900,	0xcb00,
0xfea8,	0xfeb8,	0xfe88,	0xfe98,	0xfee8,	0xfef8,	0xfec8,	0xfed8,
0xfe28,	0xfe38,	0xfe08,	0xfe18,	0xfe68,	0xfe78,	0xfe48,	0xfe58,
0xffa8,	0xffb8,	0xff88,	0xff98,	0xffe8,	0xfff8,	0xffc8,	0xffd8,
0xff28,	0xff38,	0xff08,	0xff18,	0xff68,	0xff78,	0xff48,	0xff58,
0xfaa0,	0xfae0,	0xfa20,	0xfa60,	0xfba0,	0xfbe0,	0xfb20,	0xfb60,
0xf8a0,	0xf8e0,	0xf820,	0xf860,	0xf9a0,	0xf9e0,	0xf920,	0xf960,
0xfd50,	0xfd70,	0xfd10,	0xfd30,	0xfdd0,	0xfdf0,	0xfd90,	0xfdb0,
0xfc50,	0xfc70,	0xfc10,	0xfc30,	0xfcd0,	0xfcf0,	0xfc90,	0xfcb0,
0x1580,	0x1480,	0x1780,	0x1680,	0x1180,	0x1080,	0x1380,	0x1280,
0x1d80,	0x1c80,	0x1f80,	0x1e80,	0x1980,	0x1880,	0x1b80,	0x1a80,
0x0ac0,	0x0a40,	0x0bc0,	0x0b40,	0x08c0,	0x0840,	0x09c0,	0x0940,
0x0ec0,	0x0e40,	0x0fc0,	0x0f40,	0x0cc0,	0x0c40,	0x0dc0,	0x0d40,
0x5600,	0x5200,	0x5e00,	0x5a00,	0x4600,	0x4200,	0x4e00,	0x4a00,
0x7600,	0x7200,	0x7e00,	0x7a00,	0x6600,	0x6200,	0x6e00,	0x6a00,
0x2b00,	0x2900,	0x2f00,	0x2d00,	0x2300,	0x2100,	0x2700,	0x2500,
0x3b00,	0x3900,	0x3f00,	0x3d00,	0x3300,	0x3100,	0x3700,	0x3500,
0x0158,	0x0148,	0x0178,	0x0168,	0x0118,	0x0108,	0x0138,	0x0128,
0x01d8,	0x01c8,	0x01f8,	0x01e8,	0x0198,	0x0188,	0x01b8,	0x01a8,
0x0058,	0x0048,	0x0078,	0x0068,	0x0018,	0x0008,	0x0038,	0x0028,
0x00d8,	0x00c8,	0x00f8,	0x00e8,	0x0098,	0x0088,	0x00b8,	0x00a8,
0x0560,	0x0520,	0x05e0,	0x05a0,	0x0460,	0x0420,	0x04e0,	0x04a0,
0x0760,	0x0720,	0x07e0,	0x07a0,	0x0660,	0x0620,	0x06e0,	0x06a0,
0x02b0,	0x0290,	0x02f0,	0x02d0,	0x0230,	0x0210,	0x0270,	0x0250,
0x03b0,	0x0390,	0x03f0,	0x03d0,	0x0330,	0x0310,	0x0370,	0x0350};

const char s2a_table[TABLE_SIZE14] = {
0xd5,	0xd5,	0xd5,	0xd5,	0xd4,	0xd4,	0xd4,	0xd4,
0xd7,	0xd7,	0xd7,	0xd7,	0xd6,	0xd6,	0xd6,	0xd6,
0xd1,	0xd1,	0xd1,	0xd1,	0xd0,	0xd0,	0xd0,	0xd0,
0xd3,	0xd3,	0xd3,	0xd3,	0xd2,	0xd2,	0xd2,	0xd2,
0xdd,	0xdd,	0xdd,	0xdd,	0xdc,	0xdc,	0xdc,	0xdc,
0xdf,	0xdf,	0xdf,	0xdf,	0xde,	0xde,	0xde,	0xde,
0xd9,	0xd9,	0xd9,	0xd9,	0xd8,	0xd8,	0xd8,	0xd8,
0xdb,	0xdb,	0xdb,	0xdb,	0xda,	0xda,	0xda,	0xda,
0xc5,	0xc5,	0xc5,	0xc5,	0xc4,	0xc4,	0xc4,	0xc4,
0xc7,	0xc7,	0xc7,	0xc7,	0xc6,	0xc6,	0xc6,	0xc6,
0xc1,	0xc1,	0xc1,	0xc1,	0xc0,	0xc0,	0xc0,	0xc0,
0xc3,	0xc3,	0xc3,	0xc3,	0xc2,	0xc2,	0xc2,	0xc2,
0xcd,	0xcd,	0xcd,	0xcd,	0xcc,	0xcc,	0xcc,	0xcc,
0xcf,	0xcf,	0xcf,	0xcf,	0xce,	0xce,	0xce,	0xce,
0xc9,	0xc9,	0xc9,	0xc9,	0xc8,	0xc8,	0xc8,	0xc8,
0xcb,	0xcb,	0xcb,	0xcb,	0xca,	0xca,	0xca,	0xca,
0xf5,	0xf5,	0xf5,	0xf5,	0xf5,	0xf5,	0xf5,	0xf5,
0xf4,	0xf4,	0xf4,	0xf4,	0xf4,	0xf4,	0xf4,	0xf4,
0xf7,	0xf7,	0xf7,	0xf7,	0xf7,	0xf7,	0xf7,	0xf7,
0xf6,	0xf6,	0xf6,	0xf6,	0xf6,	0xf6,	0xf6,	0xf6,
0xf1,	0xf1,	0xf1,	0xf1,	0xf1,	0xf1,	0xf1,	0xf1,
0xf0,	0xf0,	0xf0,	0xf0,	0xf0,	0xf0,	0xf0,	0xf0,
0xf3,	0xf3,	0xf3,	0xf3,	0xf3,	0xf3,	0xf3,	0xf3,
0xf2,	0xf2,	0xf2,	0xf2,	0xf2,	0xf2,	0xf2,	0xf2,
0xfd,	0xfd,	0xfd,	0xfd,	0xfd,	0xfd,	0xfd,	0xfd,
0xfc,	0xfc,	0xfc,	0xfc,	0xfc,	0xfc,	0xfc,	0xfc,
0xff,	0xff,	0xff,	0xff,	0xff,	0xff,	0xff,	0xff,
0xfe,	0xfe,	0xfe,	0xfe,	0xfe,	0xfe,	0xfe,	0xfe,
0xf9,	0xf9,	0xf9,	0xf9,	0xf9,	0xf9,	0xf9,	0xf9,
0xf8,	0xf8,	0xf8,	0xf8,	0xf8,	0xf8,	0xf8,	0xf8,
0xfb,	0xfb,	0xfb,	0xfb,	0xfb,	0xfb,	0xfb,	0xfb,
0xfa,	0xfa,	0xfa,	0xfa,	0xfa,	0xfa,	0xfa,	0xfa,
0xe5,	0xe5,	0xe5,	0xe5,	0xe5,	0xe5,	0xe5,	0xe5,
0xe5,	0xe5,	0xe5,	0xe5,	0xe5,	0xe5,	0xe5,	0xe5,
0xe4,	0xe4,	0xe4,	0xe4,	0xe4,	0xe4,	0xe4,	0xe4,
0xe4,	0xe4,	0xe4,	0xe4,	0xe4,	0xe4,	0xe4,	0xe4,
0xe7,	0xe7,	0xe7,	0xe7,	0xe7,	0xe7,	0xe7,	0xe7,
0xe7,	0xe7,	0xe7,	0xe7,	0xe7,	0xe7,	0xe7,	0xe7,
0xe6,	0xe6,	0xe6,	0xe6,	0xe6,	0xe6,	0xe6,	0xe6,
0xe6,	0xe6,	0xe6,	0xe6,	0xe6,	0xe6,	0xe6,	0xe6,
0xe1,	0xe1,	0xe1,	0xe1,	0xe1,	0xe1,	0xe1,	0xe1,
0xe1,	0xe1,	0xe1,	0xe1,	0xe1,	0xe1,	0xe1,	0xe1,
0xe0,	0xe0,	0xe0,	0xe0,	0xe0,	0xe0,	0xe0,	0xe0,
0xe0,	0xe0,	0xe0,	0xe0,	0xe0,	0xe0,	0xe0,	0xe0,
0xe3,	0xe3,	0xe3,	0xe3,	0xe3,	0xe3,	0xe3,	0xe3,
0xe3,	0xe3,	0xe3,	0xe3,	0xe3,	0xe3,	0xe3,	0xe3,
0xe2,	0xe2,	0xe2,	0xe2,	0xe2,	0xe2,	0xe2,	0xe2,
0xe2,	0xe2,	0xe2,	0xe2,	0xe2,	0xe2,	0xe2,	0xe2,
0xed,	0xed,	0xed,	0xed,	0xed,	0xed,	0xed,	0xed,
0xed,	0xed,	0xed,	0xed,	0xed,	0xed,	0xed,	0xed,
0xec,	0xec,	0xec,	0xec,	0xec,	0xec,	0xec,	0xec,
0xec,	0xec,	0xec,	0xec,	0xec,	0xec,	0xec,	0xec,
0xef,	0xef,	0xef,	0xef,	0xef,	0xef,	0xef,	0xef,
0xef,	0xef,	0xef,	0xef,	0xef,	0xef,	0xef,	0xef,
0xee,	0xee,	0xee,	0xee,	0xee,	0xee,	0xee,	0xee,
0xee,	0xee,	0xee,	0xee,	0xee,	0xee,	0xee,	0xee,
0xe9,	0xe9,	0xe9,	0xe9,	0xe9,	0xe9,	0xe9,	0xe9,
0xe9,	0xe9,	0xe9,	0xe9,	0xe9,	0xe9,	0xe9,	0xe9,
0xe8,	0xe8,	0xe8,	0xe8,	0xe8,	0xe8,	0xe8,	0xe8,
0xe8,	0xe8,	0xe8,	0xe8,	0xe8,	0xe8,	0xe8,	0xe8,
0xeb,	0xeb,	0xeb,	0xeb,	0xeb,	0xeb,	0xeb,	0xeb,
0xeb,	0xeb,	0xeb,	0xeb,	0xeb,	0xeb,	0xeb,	0xeb,
0xea,	0xea,	0xea,	0xea,	0xea,	0xea,	0xea,	0xea,
0xea,	0xea,	0xea,	0xea,	0xea,	0xea,	0xea,	0xea,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,	0x95,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,	0x94,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,	0x97,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,	0x96,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,	0x91,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,	0x90,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,	0x93,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,	0x92,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,	0x9d,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,	0x9c,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,	0x9f,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,	0x9e,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,	0x99,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,	0x98,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,	0x9b,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,	0x9a,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,	0x85,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,	0x84,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,	0x87,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,	0x86,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,	0x81,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,	0x80,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,	0x83,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,	0x82,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,	0x8d,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,	0x8c,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,	0x8f,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,	0x8e,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,	0x89,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,	0x88,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,	0x8b,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,	0x8a,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,	0xb5,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,	0xb4,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,	0xb7,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,	0xb6,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,	0xb1,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,	0xb0,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,	0xb3,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,	0xb2,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,	0xbd,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,	0xbc,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,	0xbf,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,	0xbe,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,	0xb9,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,	0xb8,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,	0xbb,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,	0xba,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,	0xa5,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,	0xa4,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,	0xa7,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,	0xa6,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,	0xa1,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,	0xa0,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,	0xa3,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,	0xa2,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,	0xad,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,	0xac,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,	0xaf,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,	0xae,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,	0xa9,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,	0xa8,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,	0xab,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,	0xaa,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,	0x2a,
0x2a,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,	0x2b,
0x2b,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,	0x28,
0x28,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,	0x29,
0x29,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,	0x2e,
0x2e,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,	0x2f,
0x2f,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,	0x2c,
0x2c,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,	0x2d,
0x2d,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,	0x22,
0x22,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,	0x23,
0x23,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,	0x20,
0x20,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,	0x21,
0x21,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,	0x26,
0x26,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,	0x27,
0x27,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,	0x24,
0x24,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,	0x25,
0x25,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,	0x3a,
0x3a,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,	0x3b,
0x3b,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,	0x38,
0x38,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,	0x39,
0x39,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,	0x3e,
0x3e,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,	0x3f,
0x3f,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,	0x3c,
0x3c,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,	0x3d,
0x3d,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,	0x32,
0x32,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,	0x33,
0x33,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,	0x30,
0x30,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,	0x31,
0x31,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,	0x36,
0x36,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,	0x37,
0x37,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,	0x34,
0x34,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,	0x35,
0x35,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,	0x0a,
0x0a,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,	0x0b,
0x0b,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,	0x08,
0x08,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,	0x09,
0x09,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,	0x0e,
0x0e,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,	0x0f,
0x0f,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,	0x0c,
0x0c,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,	0x0d,
0x0d,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,	0x02,
0x02,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,	0x03,
0x03,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,	0x00,
0x00,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,	0x01,
0x01,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,	0x06,
0x06,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,	0x07,
0x07,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,	0x04,
0x04,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,	0x05,
0x05,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,	0x1a,
0x1a,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,	0x1b,
0x1b,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,	0x18,
0x18,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,	0x19,
0x19,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,	0x1e,
0x1e,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,	0x1f,
0x1f,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,	0x1c,
0x1c,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,	0x1d,
0x1d,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,	0x12,
0x12,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,	0x13,
0x13,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,	0x10,
0x10,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,	0x11,
0x11,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,	0x16,
0x16,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,	0x17,
0x17,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,	0x14,
0x14,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,	0x15,
0x15,	0x6a,	0x6a,	0x6a,	0x6a,	0x6a,	0x6a,	0x6a,
0x6a,	0x6a,	0x6a,	0x6a,	0x6a,	0x6a,	0x6a,	0x6a,
0x6a,	0x6b,	0x6b,	0x6b,	0x6b,	0x6b,	0x6b,	0x6b,
0x6b,	0x6b,	0x6b,	0x6b,	0x6b,	0x6b,	0x6b,	0x6b,
0x6b,	0x68,	0x68,	0x68,	0x68,	0x68,	0x68,	0x68,
0x68,	0x68,	0x68,	0x68,	0x68,	0x68,	0x68,	0x68,
0x68,	0x69,	0x69,	0x69,	0x69,	0x69,	0x69,	0x69,
0x69,	0x69,	0x69,	0x69,	0x69,	0x69,	0x69,	0x69,
0x69,	0x6e,	0x6e,	0x6e,	0x6e,	0x6e,	0x6e,	0x6e,
0x6e,	0x6e,	0x6e,	0x6e,	0x6e,	0x6e,	0x6e,	0x6e,
0x6e,	0x6f,	0x6f,	0x6f,	0x6f,	0x6f,	0x6f,	0x6f,
0x6f,	0x6f,	0x6f,	0x6f,	0x6f,	0x6f,	0x6f,	0x6f,
0x6f,	0x6c,	0x6c,	0x6c,	0x6c,	0x6c,	0x6c,	0x6c,
0x6c,	0x6c,	0x6c,	0x6c,	0x6c,	0x6c,	0x6c,	0x6c,
0x6c,	0x6d,	0x6d,	0x6d,	0x6d,	0x6d,	0x6d,	0x6d,
0x6d,	0x6d,	0x6d,	0x6d,	0x6d,	0x6d,	0x6d,	0x6d,
0x6d,	0x62,	0x62,	0x62,	0x62,	0x62,	0x62,	0x62,
0x62,	0x62,	0x62,	0x62,	0x62,	0x62,	0x62,	0x62,
0x62,	0x63,	0x63,	0x63,	0x63,	0x63,	0x63,	0x63,
0x63,	0x63,	0x63,	0x63,	0x63,	0x63,	0x63,	0x63,
0x63,	0x60,	0x60,	0x60,	0x60,	0x60,	0x60,	0x60,
0x60,	0x60,	0x60,	0x60,	0x60,	0x60,	0x60,	0x60,
0x60,	0x61,	0x61,	0x61,	0x61,	0x61,	0x61,	0x61,
0x61,	0x61,	0x61,	0x61,	0x61,	0x61,	0x61,	0x61,
0x61,	0x66,	0x66,	0x66,	0x66,	0x66,	0x66,	0x66,
0x66,	0x66,	0x66,	0x66,	0x66,	0x66,	0x66,	0x66,
0x66,	0x67,	0x67,	0x67,	0x67,	0x67,	0x67,	0x67,
0x67,	0x67,	0x67,	0x67,	0x67,	0x67,	0x67,	0x67,
0x67,	0x64,	0x64,	0x64,	0x64,	0x64,	0x64,	0x64,
0x64,	0x64,	0x64,	0x64,	0x64,	0x64,	0x64,	0x64,
0x64,	0x65,	0x65,	0x65,	0x65,	0x65,	0x65,	0x65,
0x65,	0x65,	0x65,	0x65,	0x65,	0x65,	0x65,	0x65,
0x65,	0x7a,	0x7a,	0x7a,	0x7a,	0x7a,	0x7a,	0x7a,
0x7a,	0x7b,	0x7b,	0x7b,	0x7b,	0x7b,	0x7b,	0x7b,
0x7b,	0x78,	0x78,	0x78,	0x78,	0x78,	0x78,	0x78,
0x78,	0x79,	0x79,	0x79,	0x79,	0x79,	0x79,	0x79,
0x79,	0x7e,	0x7e,	0x7e,	0x7e,	0x7e,	0x7e,	0x7e,
0x7e,	0x7f,	0x7f,	0x7f,	0x7f,	0x7f,	0x7f,	0x7f,
0x7f,	0x7c,	0x7c,	0x7c,	0x7c,	0x7c,	0x7c,	0x7c,
0x7c,	0x7d,	0x7d,	0x7d,	0x7d,	0x7d,	0x7d,	0x7d,
0x7d,	0x72,	0x72,	0x72,	0x72,	0x72,	0x72,	0x72,
0x72,	0x73,	0x73,	0x73,	0x73,	0x73,	0x73,	0x73,
0x73,	0x70,	0x70,	0x70,	0x70,	0x70,	0x70,	0x70,
0x70,	0x71,	0x71,	0x71,	0x71,	0x71,	0x71,	0x71,
0x71,	0x76,	0x76,	0x76,	0x76,	0x76,	0x76,	0x76,
0x76,	0x77,	0x77,	0x77,	0x77,	0x77,	0x77,	0x77,
0x77,	0x74,	0x74,	0x74,	0x74,	0x74,	0x74,	0x74,
0x74,	0x75,	0x75,	0x75,	0x75,	0x75,	0x75,	0x75,
0x75,	0x4a,	0x4a,	0x4a,	0x4a,	0x4b,	0x4b,	0x4b,
0x4b,	0x48,	0x48,	0x48,	0x48,	0x49,	0x49,	0x49,
0x49,	0x4e,	0x4e,	0x4e,	0x4e,	0x4f,	0x4f,	0x4f,
0x4f,	0x4c,	0x4c,	0x4c,	0x4c,	0x4d,	0x4d,	0x4d,
0x4d,	0x42,	0x42,	0x42,	0x42,	0x43,	0x43,	0x43,
0x43,	0x40,	0x40,	0x40,	0x40,	0x41,	0x41,	0x41,
0x41,	0x46,	0x46,	0x46,	0x46,	0x47,	0x47,	0x47,
0x47,	0x44,	0x44,	0x44,	0x44,	0x45,	0x45,	0x45,
0x45,	0x5a,	0x5a,	0x5a,	0x5a,	0x5b,	0x5b,	0x5b,
0x5b,	0x58,	0x58,	0x58,	0x58,	0x59,	0x59,	0x59,
0x59,	0x5e,	0x5e,	0x5e,	0x5e,	0x5f,	0x5f,	0x5f,
0x5f,	0x5c,	0x5c,	0x5c,	0x5c,	0x5d,	0x5d,	0x5d,
0x5d,	0x52,	0x52,	0x52,	0x52,	0x53,	0x53,	0x53,
0x53,	0x50,	0x50,	0x50,	0x50,	0x51,	0x51,	0x51,
0x51,	0x56,	0x56,	0x56,	0x56,	0x57,	0x57,	0x57,
0x57,	0x54,	0x54,	0x54,	0x54,	0x55,	0x55,	0x55};

const char u2a_table[TABLE_SIZE8] = {
0x2a,   0x2b,   0x28,   0x29,   0x2e,   0x2f,   0x2c,   0x2d,
0x22,   0x23,   0x20,   0x21,   0x26,   0x27,   0x24,   0x25,
0x3a,   0x3b,   0x38,   0x39,   0x3e,   0x3f,   0x3c,   0x3d,
0x32,   0x33,   0x30,   0x31,   0x36,   0x37,   0x34,   0x35,
0x0a,   0x0b,   0x08,   0x09,   0x0e,   0x0f,   0x0c,   0x0d,
0x02,   0x03,   0x00,   0x01,   0x06,   0x07,   0x04,   0x05,
0x1b,   0x18,   0x19,   0x1e,   0x1f,   0x1c,   0x1d,   0x12,
0x13,   0x10,   0x11,   0x16,   0x17,   0x14,   0x15,   0x6a,
0x68,   0x69,   0x6e,   0x6f,   0x6c,   0x6d,   0x62,   0x63,
0x60,   0x61,   0x66,   0x67,   0x64,   0x65,   0x7a,   0x78,
0x7e,   0x7f,   0x7c,   0x7d,   0x72,   0x73,   0x70,   0x71,
0x76,   0x77,   0x74,   0x75,   0x4b,   0x49,   0x4f,   0x4d,
0x42,   0x43,   0x40,   0x41,   0x46,   0x47,   0x44,   0x45,
0x5a,   0x5b,   0x58,   0x59,   0x5e,   0x5f,   0x5c,   0x5d,
0x52,   0x52,   0x53,   0x53,   0x50,   0x50,   0x51,   0x51,
0x56,   0x56,   0x57,   0x57,   0x54,   0x54,   0x55,   0x55,
0xaa,   0xab,   0xa8,   0xa9,   0xae,   0xaf,   0xac,   0xad,
0xa2,   0xa3,   0xa0,   0xa1,   0xa6,   0xa7,   0xa4,   0xa5,
0xba,   0xbb,   0xb8,   0xb9,   0xbe,   0xbf,   0xbc,   0xbd,
0xb2,   0xb3,   0xb0,   0xb1,   0xb6,   0xb7,   0xb4,   0xb5,
0x8a,   0x8b,   0x88,   0x89,   0x8e,   0x8f,   0x8c,   0x8d,
0x82,   0x83,   0x80,   0x81,   0x86,   0x87,   0x84,   0x85,
0x9b,   0x98,   0x99,   0x9e,   0x9f,   0x9c,   0x9d,   0x92,
0x93,   0x90,   0x91,   0x96,   0x97,   0x94,   0x95,   0xea,
0xe8,   0xe9,   0xee,   0xef,   0xec,   0xed,   0xe2,   0xe3,
0xe0,   0xe1,   0xe6,   0xe7,   0xe4,   0xe5,   0xfa,   0xf8,
0xfe,   0xff,   0xfc,   0xfd,   0xf2,   0xf3,   0xf0,   0xf1,
0xf6,   0xf7,   0xf4,   0xf5,   0xcb,   0xc9,   0xcf,   0xcd,
0xc2,   0xc3,   0xc0,   0xc1,   0xc6,   0xc7,   0xc4,   0xc5,
0xda,   0xdb,   0xd8,   0xd9,   0xde,   0xdf,   0xdc,   0xdd,
0xd2,   0xd2,   0xd3,   0xd3,   0xd0,   0xd0,   0xd1,   0xd1,
0xd6,   0xd6,   0xd7,   0xd7,   0xd4,   0xd4,   0xd5,   0xd5};

const char a2u_table[TABLE_SIZE8] = {
0x2a,	0x2b,	0x28,	0x29,	0x2e,	0x2f,	0x2c,	0x2d,
0x22,	0x23,	0x20,	0x21,	0x26,	0x27,	0x24,	0x25,
0x39,	0x3a,	0x37,	0x38,	0x3d,	0x3e,	0x3b,	0x3c,
0x31,	0x32,	0x30,	0x30,	0x35,	0x36,	0x33,	0x34,
0x0a,	0x0b,	0x08,	0x09,	0x0e,	0x0f,	0x0c,	0x0d,
0x02,	0x03,	0x00,	0x01,	0x06,	0x07,	0x04,	0x05,
0x1a,	0x1b,	0x18,	0x19,	0x1e,	0x1f,	0x1c,	0x1d,
0x12,	0x13,	0x10,	0x11,	0x16,	0x17,	0x14,	0x15,
0x62,	0x63,	0x60,	0x61,	0x66,	0x67,	0x64,	0x65,
0x5d,	0x5d,	0x5c,	0x5c,	0x5f,	0x5f,	0x5e,	0x5e,
0x74,	0x76,	0x70,	0x72,	0x7c,	0x7e,	0x78,	0x7a,
0x6a,	0x6b,	0x68,	0x69,	0x6e,	0x6f,	0x6c,	0x6d,
0x48,	0x49,	0x46,	0x47,	0x4c,	0x4d,	0x4a,	0x4b,
0x40,	0x41,	0x3f,	0x3f,	0x44,	0x45,	0x42,	0x43,
0x56,	0x57,	0x54,	0x55,	0x5a,	0x5b,	0x58,	0x59,
0x4f,	0x4f,	0x4e,	0x4e,	0x52,	0x53,	0x50,	0x51,
0xaa,	0xab,	0xa8,	0xa9,	0xae,	0xaf,	0xac,	0xad,
0xa2,	0xa3,	0xa0,	0xa1,	0xa6,	0xa7,	0xa4,	0xa5,
0xb9,	0xba,	0xb7,	0xb8,	0xbd,	0xbe,	0xbb,	0xbc,
0xb1,	0xb2,	0xb0,	0xb0,	0xb5,	0xb6,	0xb3,	0xb4,
0x8a,	0x8b,	0x88,	0x89,	0x8e,	0x8f,	0x8c,	0x8d,
0x82,	0x83,	0x80,	0x81,	0x86,	0x87,	0x84,	0x85,
0x9a,	0x9b,	0x98,	0x99,	0x9e,	0x9f,	0x9c,	0x9d,
0x92,	0x93,	0x90,	0x91,	0x96,	0x97,	0x94,	0x95,
0xe2,	0xe3,	0xe0,	0xe1,	0xe6,	0xe7,	0xe4,	0xe5,
0xdd,	0xdd,	0xdc,	0xdc,	0xdf,	0xdf,	0xde,	0xde,
0xf4,	0xf6,	0xf0,	0xf2,	0xfc,	0xfe,	0xf8,	0xfa,
0xea,	0xeb,	0xe8,	0xe9,	0xee,	0xef,	0xec,	0xed,
0xc8,	0xc9,	0xc6,	0xc7,	0xcc,	0xcd,	0xca,	0xcb,
0xc0,	0xc1,	0xbf,	0xbf,	0xc4,	0xc5,	0xc2,	0xc3,
0xd6,	0xd7,	0xd4,	0xd5,	0xda,	0xdb,	0xd8,	0xd9,
0xcf,	0xcf,	0xce,	0xce,	0xd2,	0xd3,	0xd0,	0xd1};

void convert_u2c(const char *src, char *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_U2C(*src);
	tar++;
	src++;
    }
}

void convert_c2u(const char *src, char *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_C2U(*src);
	tar++;
	src++;
    }
}

void convert_a2c(const char *src, char *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_A2C(*src);
	tar++;
	src++;
    }
}

void convert_c2a(const char *src, char *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_C2A(*src);
	tar++;
	src++;
    }
}

void convert_u2s(const char *src, short *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_U2S(*src);
	tar++;
	src++;
    }
}

void convert_s2u(const short *src, char *tar, int n)
{
    const short *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_S2U(*src);
	tar++;
	src++;
    }
}

void convert_a2s(const char *src, short *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_A2S(*src);
	tar++;
	src++;
    }
}

void convert_s2a(const short *src, char *tar, int n)
{
    const short *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_S2A(*src);
	tar++;
	src++;
    }
}

void convert_u2a(const char *src, char *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_U2A(*src);
	tar++;
	src++;
    }
}

void convert_a2u(const char *src, char *tar, int n)
{
    const char *p = src + n;

    while(src < p - 9)
    {
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
    }

    while(src < p)
    {
	*tar = AUDIO_A2U(*src);
	tar++;
	src++;
    }
}

