#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>

#define GRIDSIZE (128)
#define GREYS (64)

Display *dpy;
Window   win;
GC       gcwhite, gcblack; 
GC gcballs[16];
static short grid[GRIDSIZE*2][GRIDSIZE*2];

void init()
{
    int      scn;
    XSetWindowAttributes attr;
    XGCValues gcvalues;

    dpy = XOpenDisplay((char *) NULL);
    if ((Display *) NULL == dpy) {
	fprintf(stderr, "xbox:  could not open display.\n");
	exit(-1);
    }

    
    scn = DefaultScreen(dpy);
    win = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy),
			       200, 200, 500, 500, 1,
			       BlackPixel(dpy, scn),
			       WhitePixel(dpy, scn));
   
    attr.event_mask = ButtonPressMask | KeyPressMask | ExposureMask;
    XChangeWindowAttributes(dpy, win, CWEventMask, &attr);

    XSetWindowBackground(dpy, win, BlackPixel(dpy, scn));

    XMapWindow(dpy, win);
    
    gcvalues.foreground = WhitePixel(dpy, scn);
    gcvalues.background = BlackPixel(dpy, scn);
    gcwhite = XCreateGC(dpy, win, GCForeground|GCBackground,
			&gcvalues);

    gcvalues.foreground = BlackPixel(dpy, scn);
    gcvalues.background = WhitePixel(dpy, scn);
    gcblack = XCreateGC(dpy, win, GCForeground|GCBackground,
			&gcvalues);
}

void disc(x,y,n,rad)
int x,y,n,rad;
{
    register int ix, iy;
    int ir;
    double r, theta;
    double xn, yn;
    double xd, yd, zd;
    double xl=0.5, yl=0.3, zl=sqrt(1.0-xl*xl-yl*yl);

    printf("shade = %d\n", n);

    XFillArc(dpy, win, gcblack, x-rad, y-rad,
	     rad*2, rad*2, 0, 23040);

    bzero(grid, sizeof(short)*GRIDSIZE*2*GRIDSIZE*2);

    for (ix=GRIDSIZE-rad; ix<GRIDSIZE+rad; ix++) 
	for (iy=GRIDSIZE-rad; iy<GRIDSIZE+rad; iy++) {
	    r = ((double)((ix-GRIDSIZE)*(ix-GRIDSIZE) +
		(iy-GRIDSIZE)*(iy-GRIDSIZE))) / (double)(rad*rad);
	    if (r>1.0) grid[ix][iy] = 0;
	    else {
		xd = (double)(GRIDSIZE-ix)/(double)rad;
		yd = (double)(GRIDSIZE-iy)/(double)rad;
		zd = sqrt(1.0-xd*xd-yd*yd);

		ir = (int)(11.0 * (xl*xd+yl*yd+zl*zd));
		if (ir<0) ir=0;
		else if (ir+n >= GREYS) ir=GREYS-n;
		grid[ix][iy] = n + ir;
		/*grid[ix][iy] = (ir%2)*GREYS;*/
	    }
	    grid[ix][iy] += (7*grid[ix-1][iy] + 1*grid[ix-1][iy-1] +
		5*grid[ix][iy-1] + 3*grid[ix+1][iy-1]) / 16;
	    if (grid[ix][iy]>=(GREYS/2)) {
		XDrawPoint(dpy, win, gcwhite,
		    x+ix-GRIDSIZE, y+iy-GRIDSIZE);
		grid[ix][iy] -= GREYS;
	    }
	    /*else {
		XDrawPoint(dpy, win, gcblack,
	     x+ix-GRIDSIZE, y+iy-GRIDSIZE);
	    };*/

	}
}

void redraw()
{
    XClearWindow(dpy, win);
}

void bye()
{
    XCloseDisplay(dpy);
}

main()
{
    Bool   done = False;
    XEvent event;
    char   c;
    int dens = 1;


    init();

    while (!done) {
	XNextEvent(dpy, &event);
	switch (event.type) {
	    case ButtonPress:
		printf("button %d at %d %d\n",
		       event.xbutton.button,
		       event.xbutton.x, event.xbutton.y);
		switch (event.xbutton.button) {
		    case 1:
			disc(event.xbutton.x, event.xbutton.y,
			     dens, 30);
			break;
		    case 2:
			disc(event.xbutton.x, event.xbutton.y,
			     dens, 50);
			break;
		    case 3:
			disc(event.xbutton.x, event.xbutton.y,
			     dens, 100);
			break;
		    default:
			break;
		}
		break;
	    case KeyPress:
		if (1 == XLookupString(&event, &c, 1, NULL, NULL)) {
		    printf("key %c\n", c);
		    switch (c) {
			case 'q':
			    done = True;
			    break;
			case '1':
			    dens = 9;
			    break;
			case '2':
			    dens = 20;
			    break;
			case '3':
			    dens = 31;
			    break;
			case '4':
			    dens = 44;
			    break;
			case '-':
			    dens--;
			    break;
			case '+':
			case '=':
			    dens++;
			    break;			    
			case 'r':
			case 'c':
			    redraw();
			    break;
			default:
			    break;
		    }
		}
		break;
	    case Expose:
		printf("expose\n");
		redraw();
	    default:
		break;
	}
    }

    bye();
}
