/* (C) Copyright 1991 Andrew Plotkin. Permission is
 given to copy and use, as long as this copyright
 notice is retained. */


#define	PI	    (3.14159265)
#define	ROOTHALF    (0.70710678)

#define MAXFIELDX (10)
#define MAXFIELDZ (15)

#define MAXBALLS (6)
#define MAXPIECES (30)

#define NUMGAMERS (20)

#define NUMSHADES (4)
#define NUMBALLSIZES (128)

#define	OUT_COLLIDE	(-1)
#define	OUT_NOT		(0)
#define	OUT_UP		(1)
#define	OUT_DOWN	(2)
#define	OUT_SOUTH	(4)
#define	OUT_NORTHWEST	(8)
#define	OUT_NORTHEAST	(16)

#define F_OFF (0)
#define F_ON (1)
#define F_TEMP (2)

#ifdef VMS
#include "unix_time.h"
#include "unix_types.h"
#endif

typedef struct _point {
    double x, y, z, w;
} point;

typedef double matrix[4][4];

typedef XPoint fieldplist[MAXFIELDX][MAXFIELDX][MAXFIELDZ];
typedef int fieldrlist[MAXFIELDX][MAXFIELDX][MAXFIELDZ];

typedef struct _piecelist {
    short numballs;
    point points[MAXBALLS];
} piecelist;

typedef struct _piecesum {
    short numballs;
    XPoint p[MAXBALLS];
    int rad[MAXBALLS];
    double scalex, scaley;
} piecesum;

typedef struct _gamer {
    char userid[16];
    char name[16];
    long score;
    char scoret[16];
} gamer;

extern gamer hscores[NUMGAMERS];

extern piecelist pieces[MAXPIECES];

extern unsigned char field[MAXFIELDX][MAXFIELDX][MAXFIELDZ];
extern fieldplist fieldpts;
extern fieldrlist fieldrads;

extern short fieldx, fieldz;
extern double fieldoffx, fieldoffy, fieldoffz;
/*extern int meterx, meterx2, metery, metersize,
 meterlev, meteroldlev, meter_f_b, meter_b_d; */

extern short numpieces;
extern short curpiece;

extern Display *dpy;
extern Window win;
extern int scn;
extern int scndepth;
extern int monomode;

extern int dispx, dispy; /* size of window */
extern Pixmap backpm; /* size of window */
extern Pixmap fieldpm; /* size of window */
extern int sshapx1, sshapx2, sshapy1, sshapy2;
/* size of rectangle that contains shape */
extern int bbackx1, bbackx2, bbacky1, bbacky2;
/* coords of rectangle of backpm that is usable */
extern int ddispx1, ddispx2, ddispy1, ddispy2;
/* coords of rectangle of display that is different
 from fieldpm */
extern long score, dropticks;
extern double boardscale;
extern int halfboardx, halfboardy;

extern long random();
