/* (C) Copyright 1991 Andrew Plotkin. Permission is
 given to copy and use, as long as this copyright
 notice is retained. */

#include <stdio.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include "spheral.h"

#ifdef VMS
float seconds;
#endif

#define TICKLENGTH (50000)
#define xputs(x, y, str)  \
XDrawImageString(dpy, win, gcwhite, x, y, str, strlen(str))
#define xline(x1, y1, x2, y2)  \
XDrawLine(dpy, win, gcwhite, x1, y1, x2, y2) 
#define xlineo(x1, y1, x2, y2)  \
XDrawLine(dpy, win, gcocto, x1, y1, x2, y2) 

extern gamer hscores[NUMGAMERS];
extern GC gcblack, gcwhite, gccopy, gcline, gcfield, gcocto; 
extern int errdiflag;

extern void intro_redraw(), redo_board_globals();

void initintro()
{
    intro_redraw();
}

void introloop()
{
    short status, res;
    Bool eventp;
    XEvent event, nextevent;
    long evmasks;
    char key;
    KeySym ksym;
    long lasttime;
    struct timeval tv;
    fd_set readbits;

    while (1) {
	tv.tv_sec = 0;
	tv.tv_usec = TICKLENGTH;
	FD_ZERO(&readbits);
	FD_SET(ConnectionNumber(dpy), &readbits);

#ifdef VMS
        seconds = (float) tv.tv_sec;
        (void) LIB$WAIT(&seconds);
#else
	(void)select(1+ConnectionNumber(dpy), &readbits, 0, 0, &tv);
#endif

	evmasks = (KeyPressMask | ExposureMask
		   | StructureNotifyMask);
	eventp = XCheckWindowEvent(dpy, win, evmasks, &event);
	if (eventp) switch (event.type) {
	    case Expose:
		eventp = XCheckWindowEvent(dpy, win,
			evmasks, &nextevent);
		while (eventp && nextevent.type == Expose) {
		    eventp = XCheckWindowEvent(dpy, win,
			evmasks, &nextevent);
		};
		if (eventp) {
		    XPutBackEvent(dpy, &nextevent);
		};
		intro_redraw();
		break;
	    case KeyPress:
		XLookupString(&event, &key, 1, &ksym, NULL);
		/*printf("got '%s'\n", XKeysymToString(ksym));*/
		switch (ksym) {
		    case XK_q:
		    case XK_Q:
			exit(0);
			break;
		    case XK_c:
		    case XK_C:
			errdiflag = !errdiflag;
			intro_redraw();
			break;
		    case XK_s:
		    case XK_S:
			return;
		};
		break;
	    case ConfigureNotify:
		if (event.xconfigure.width != dispx
		    || event.xconfigure.height != dispy) {
		    dispx = event.xconfigure.width;
		    dispy = event.xconfigure.height;
		    redo_board_globals();
		    XFreePixmap(dpy, backpm);
		    XFreePixmap(dpy, fieldpm);
		    backpm = XCreatePixmap(dpy, win, dispx,
			dispy, scndepth);   
		    fieldpm = XCreatePixmap(dpy, win, dispx,
			dispy, scndepth);   
		}
		break;
	}
    }
}

void intro_redraw()
{
    register int ix;
    char buf[255];

    XFillRectangle(dpy, win, gcblack, 0, 0, dispx, dispy);
    xputs(50, 50, "Spheral");
    xputs(50, 100, "A Sadistic Software Production");
    xputs(50, 120, "(C) Copyright 1991-3 Andrew Plotkin");
    xputs(50, 140, " (ap1i@andrew.cmu.edu)");
    if (score!=(-1)) {
	sprintf(buf, "Your score: %d", score);
	xputs(50, 160, buf);
    }

    xputs(50, 180, "Commands:");
    xputs(70, 200, "s: start game");
    xputs(70, 220, "Escape: pause");
    if (!errdiflag)
	xputs(70, 240, "c: change display mode (now boring)");
    else
	xputs(70, 240, "c: change display mode (now neato)");
    xputs(70, 260, "Q: quit program");

    xputs(350, 150, "High Scores:");
    for (ix=0; ix<NUMGAMERS; ix++) {
	xputs(390, 170+20*ix, hscores[ix].name);
	xputs(490, 170+20*ix, hscores[ix].userid);
	xputs(590, 170+20*ix, hscores[ix].scoret);
    };

    xline(50, 320, 190, 320);
    xline(90, 290, 165, 360);
    xline(75, 360, 150, 290);
    xputs(64, 325, "4j");
    xputs(163, 325, "6l");
    xputs(96, 304, "7u");
    xputs(135, 304, "9o");
    xputs(84, 346, "1m");
    xputs(145, 346, "3.");

    xline(70, 385, 170, 385);
    xline(75, 385, 70, 390);
    xline(75, 385, 70, 380);
    xline(165, 385, 170, 390);
    xline(165, 385, 170, 380);
    xputs(111, 390, " v ");

    XDrawArc(dpy, win, gcfield, 50, 410, 140, 140, 0, 23040);

    XDrawArc(dpy, win, gcfield, 50, 470, 140, 20, 0, 23040);
    XDrawArc(dpy, win, gcfield, 50, 469, 140, 22, 11520, 11520);

    XDrawArc(dpy, win, gcwhite, 50, 480, 140, 20, 18000, 2880);
    XDrawArc(dpy, win, gcwhite, 50, 480, 140, 20, 13680, 2880);
    XDrawArc(dpy, win, gcwhite, 50, 482, 140, 20, 18000, 2880);
    XDrawArc(dpy, win, gcwhite, 50, 482, 140, 20, 13680, 2880);
    xline(59, 496, 65, 502);
    xline(59, 496, 65, 492);
    xline(181, 496, 175, 502);
    xline(181, 496, 175, 492);

    XDrawArc(dpy, win, gcfield, 70, 410, 100, 140, 0, 23040);
    XDrawArc(dpy, win, gcfield, 69, 410, 102, 140, 5760, 11520);
    XDrawArc(dpy, win, gcfield, 69, 410, 102, 140, 17280, 11520);

    XDrawArc(dpy, win, gcwhite, 110, 410, 100, 140, 18720, 2880);
    XDrawArc(dpy, win, gcwhite, 110, 410, 100, 140, 1440, 2880);
    XDrawArc(dpy, win, gcwhite, 114, 410, 92, 140, 18720, 2880);
    XDrawArc(dpy, win, gcwhite, 114, 410, 92, 140, 1440, 2880);
    xline(177, 415, 190, 420);
    xline(177, 415, 180, 420);
    xline(177, 545, 190, 540);
    xline(177, 545, 180, 540);

    XDrawArc(dpy, win, gcwhite, 30, 410, 100, 140, 12960, 2880);
    XDrawArc(dpy, win, gcwhite, 30, 410, 100, 140, 7200, 2880);
    XDrawArc(dpy, win, gcwhite, 34, 410, 92, 140, 12960, 2880);
    XDrawArc(dpy, win, gcwhite, 34, 410, 92, 140, 7200, 2880);
    xline(63, 415, 50, 420);
    xline(63, 415, 60, 420);
    xline(63, 545, 50, 540);
    xline(63, 545, 60, 540);

    XDrawArc(dpy, win, gcfield, 90, 410, 60, 140, 0, 23040);

    xlineo(70, 486, 90, 472);
    xlineo(72, 486, 168, 486);
    xlineo(90, 472, 150, 472);
    xlineo(168, 486, 150, 472);

    xputs(112, 504, "s g");
    xputs(32, 500, "d");
    xputs(32, 468, "r");
    xputs(204, 500, "f");
    xputs(204, 468, "e");

    /*xlineo(120, 410, 70, 486);
    xlineo(120, 410, 90, 472);
    xlineo(120, 410, 150, 472);
    xlineo(120, 410, 168, 486);
    xlineo(120, 550, 70, 486);
    xlineo(120, 550, 90, 472);
    xlineo(120, 550, 150, 472);
    xlineo(120, 550, 168, 486);*/
}
