/* (C) Copyright 1991 Andrew Plotkin. Permission is
 given to copy and use, as long as this copyright
 notice is retained. */

#include <stdio.h>
#include <X11/Xlib.h>
#include "spheral.h"
#include "grey01.bm"
#include "grey02.bm"
#include "grey03.bm"
#include "grey04.bm"
#include "grey05.bm"
#include "grey06.bm"
#include "grey07.bm"
#include "grey08.bm"
#include "grey09.bm"
#include "grey10.bm"
#include "grey11.bm"
#include "grey12.bm"
#include "grey13.bm"
#include "grey14.bm"
#include "grey15.bm"
#include "grey16.bm"

extern GC gcballs[16];

void setup_grey()
{
    Pixmap greypm[16];
    register int ix;
    XGCValues gcvalues;
    Status res;
    XColor col, sccol;
    static unsigned short colvalues[16][3] = {
	{0x6000, 0xA000, 0x6000}, /* green grey */
	{0x6000, 0x6000, 0xA000}, /* blue grey */
	{0xC000, 0x0000, 0x0000}, /* red */
	{0xAA00, 0x8000, 0x0000}, /* orange */
	{0xC000, 0xC000, 0x0000}, /* yellow */
	{0x0000, 0xC000, 0x0000}, /* green */
	{0x0000, 0x0000, 0xFF00}, /* blue */
	{0x8000, 0x0000, 0xC000}, /* purple */
	{0xFF00, 0x6000, 0x6000}, /* light red */
	{0x8000, 0x8000, 0xFF00}, /* light blue */
	{0xC000, 0xC000, 0xC000},  /* light grey */
	{0x6000, 0xA000, 0x6000}, /* green grey */
	{0x6000, 0x6000, 0xA000}, /* blue grey */
	{0xC000, 0x0000, 0x0000}, /* red */
	{0xAA00, 0x8000, 0x0000}  /* orange */
    };

    if (monomode) {
	greypm[0] = XCreatePixmapFromBitmapData(dpy, win, grey01_bits,
	grey01_width, grey01_height, 0, 1, 1);
	greypm[1] = XCreatePixmapFromBitmapData(dpy, win, grey02_bits,
	grey02_width, grey02_height, 0, 1, 1);
	greypm[2] = XCreatePixmapFromBitmapData(dpy, win, grey03_bits,
	grey03_width, grey03_height, 0, 1, 1);
	greypm[3] = XCreatePixmapFromBitmapData(dpy, win, grey04_bits,
	grey04_width, grey04_height, 0, 1, 1);
	greypm[4] = XCreatePixmapFromBitmapData(dpy, win, grey05_bits,
	grey05_width, grey05_height, 0, 1, 1);
	greypm[5] = XCreatePixmapFromBitmapData(dpy, win, grey06_bits,
	grey06_width, grey06_height, 0, 1, 1);
	greypm[6] = XCreatePixmapFromBitmapData(dpy, win, grey07_bits,
	grey07_width, grey07_height, 0, 1, 1);
	greypm[7] = XCreatePixmapFromBitmapData(dpy, win, grey08_bits,
	grey08_width, grey08_height, 0, 1, 1);
	greypm[8] = XCreatePixmapFromBitmapData(dpy, win, grey09_bits,
	grey09_width, grey09_height, 0, 1, 1);
	greypm[9] = XCreatePixmapFromBitmapData(dpy, win, grey10_bits,
	grey10_width, grey10_height, 0, 1, 1);
	greypm[10] = XCreatePixmapFromBitmapData(dpy, win, grey11_bits,
	 grey11_width, grey11_height, 0, 1, 1);
	greypm[11] = XCreatePixmapFromBitmapData(dpy, win, grey12_bits,
	 grey12_width, grey12_height, 0, 1, 1);
	greypm[12] = XCreatePixmapFromBitmapData(dpy, win, grey13_bits,
	 grey13_width, grey13_height, 0, 1, 1);
	greypm[13] = XCreatePixmapFromBitmapData(dpy, win, grey14_bits,
	 grey14_width, grey14_height, 0, 1, 1);
	greypm[14] = XCreatePixmapFromBitmapData(dpy, win, grey15_bits,
	 grey15_width, grey15_height, 0, 1, 1);
	greypm[15] = XCreatePixmapFromBitmapData(dpy, win, grey16_bits,
	 grey16_width, grey16_height, 0, 1, 1);

	gcvalues.foreground = WhitePixel(dpy, scn);
	gcvalues.background = BlackPixel(dpy, scn);

	gcvalues.fill_style = FillOpaqueStippled;
	for (ix=0; ix<16; ix++) {
	    gcvalues.stipple = greypm[ix];
	    gcballs[ix] = XCreateGC(dpy, win,
		GCForeground|GCBackground|GCFillStyle|GCStipple,
		 &gcvalues);
	};
    }
    else {
	for (ix=0; ix<16; ix++) {
	    col.red = colvalues[ix][0];
	    col.green = colvalues[ix][1];
	    col.blue = colvalues[ix][2];
	    res = XAllocColor(dpy, DefaultColormap(dpy, scn),
		&col);
	    if (!res) {
		fprintf(stderr, "spatial: unable to allocate colors\n");
		exit(-1);
	    }
	    gcvalues.foreground = col.pixel;
	    gcballs[ix] = XCreateGC(dpy, win, GCForeground,
		&gcvalues);
	}
    }
}
