/* (C) Copyright 1991 Andrew Plotkin. Permission is
 given to copy and use, as long as this copyright
 notice is retained. */

#include <stdio.h>
#include <math.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include "spheral.h"

#ifdef VMS
float seconds;
#endif

#define TICKLENGTH (25000)
#define GLIDELENGTH (8)
#define TURNLENGTH (8)
#define PLUMLENGTH (3)
#define FALLLENGTH (8)
#define MIRRORLENGTH (12)

/* int meterx, meterx2, metery, metersize, meterlev,
 meteroldlev, meter_f_b, meter_b_d;
 oldlev is level on fieldpm */

unsigned char field[MAXFIELDX][MAXFIELDX][MAXFIELDZ];
short fieldx, fieldz;
double fieldoffx, fieldoffy, fieldoffz;
extern double offx, offy, offz;
long score=(-1), dropticks;

extern int aspectflag;
extern double aspect;

extern point plist[], traplist[], templist[];

extern void setup_backpm(), setup_fieldpm(), setup_fieldpts(),
plop_piece(), add_balls(), round_piece(), draw_score();
extern void rotate_piece(), reverse_piece(), pauseloop();

void clearfield()
{
    int ix, iy, iz;
    for (ix=0; ix<fieldx; ix++)
	for (iy=0; iy<fieldx; iy++)
	    for (iz=0; iz<fieldz; iz++) 
		field[ix][iy][iz] = 0;
}

void initgame()
{
    curpiece = -1;
    score = 0;
    dropticks = 800;
    /*meterlev = 0;*/
    clearfield();
    setup_fieldpts();
    setup_fieldpm();
}

void redo_board_globals()  /* using dispx, dispy */
{
    if (dispy*ROOTHALF < dispx/2) 
	boardscale = 2.5 * (double)(dispy*ROOTHALF);
    else
	boardscale = 2.5 * (double)(dispx/2);
    halfboardx = dispx/2;
    halfboardy = dispy/2;
/*
    if (dispy-(int)boardscale > 60) {
	meterx = 32;
	metery = boardscale+30;
    }
    else {
	meterx = 176;
	metery = boardscale+10;
    }
    metersize = (((int)boardscale) - meterx) / fieldz;
    if (metersize<1) metersize = 1;*/
}

void gameloop()
{
#define ST_STILL (0)
#define ST_FALL (1)
#define ST_TURN (2)
#define ST_GLIDE (3)
#define ST_PLUMMET (4)
#define ST_SPACEHIT (5)
#define ST_PAUSE (6)
#define ST_MIRROR (7)

    short status, res;
    short droptimer=0, stattick;
    Bool eventp;
    XEvent event, nextevent;
    long evmasks;
    char key;
    KeySym ksym;
    long lasttime;
    double toffx, toffy, toffz;
    int taxis; /* 1=x, 2=y, 3=z */
    int tdir;
    struct timeval tv;
    fd_set readbits;
    int gotit;

    status = ST_PAUSE;
    /*lasttime = current_usec();*/

    while (1) {
	if (curpiece==(-1)) {
	    startpiece();
	    if (curpiece==(-2)) break; /* game over, man */
	    setup_backpm();
	    back_to_disp(0);
	    draw_score(win);
	    droptimer = 0;

	    do {
		eventp = XCheckWindowEvent(dpy, win,
		KeyPressMask, &event);
	    }
	    while (eventp);
	};

	XFlush(dpy);

	tv.tv_sec = 0;
	tv.tv_usec = TICKLENGTH;
	FD_ZERO(&readbits);
	FD_SET(ConnectionNumber(dpy), &readbits);

#ifdef VMS
        seconds = (float) tv.tv_sec;
        (void) LIB$WAIT(&seconds);
#else
	(void)select(1+ConnectionNumber(dpy), &readbits, 0, 0, &tv);
#endif

	if (status == ST_STILL)
	    evmasks = (KeyPressMask | ExposureMask
		       | StructureNotifyMask);
	else
	    evmasks = (ExposureMask | StructureNotifyMask);
	eventp = XCheckWindowEvent(dpy, win, evmasks, &event);
	if (eventp) switch (event.type) {
	    case Expose:
		do {
		    gotit = XCheckWindowEvent(dpy, win,
			ExposureMask, &nextevent);
		} while (gotit);
		back_to_disp(1);
		break;
	    case KeyPress:
		XLookupString(&event, &key, 1, &ksym, NULL);
		/*printf("got '%s'\n", XKeysymToString(ksym));*/
		switch (ksym) {
		    case XK_Q:
			return;
			break;
/*		    case XK_equal:
			curpiece = (-1);
			break;*/
		    case XK_Escape:
			pauseloop();
			setup_fieldpm();
			add_balls(0);   
			setup_backpm();
			back_to_disp(1);		    
			draw_score(win);
			break;
		    case XK_s:
		    case XK_g:
		    case XK_e:
		    case XK_f:
		    case XK_r:
		    case XK_d:
			if (status != ST_STILL) break;
			if (ksym==XK_s || ksym==XK_g) taxis=1;
			if (ksym==XK_e || ksym==XK_f) taxis=2;
			if (ksym==XK_r || ksym==XK_d) taxis=3;
			if (ksym==XK_s || ksym==XK_f || ksym==XK_r)
			    tdir=1;
			else tdir=(-1);
			toffx = 0.0;
			toffy = 0.0;
			toffz = 0.0;
			updatetemp_tra(toffx, toffy, toffz, taxis, tdir);
			res = collision(1);
			while (res!=OUT_NOT && res!=OUT_COLLIDE
			       && res!=OUT_DOWN) {
			    switch (res) { /* as collision, ignore 2 */
				case OUT_UP:
				    toffz = toffz - 1.0 ;
				    break;
				case OUT_NORTHEAST:
				    toffx = toffx - 0.5;
				    toffy = toffy - ROOTHALF;
				    toffz = toffz + 0.5;
				    break;
				case OUT_SOUTH:
				    toffx = toffx - 0.5;
				    toffy = toffy + ROOTHALF;
				    toffz = toffz - 0.5;
				    break;
				case OUT_NORTHWEST:
				    toffx = toffx + 1.0;
				    break;
			    }
			    updatetemp_tra(toffx, toffy, toffz,
					   taxis, tdir);
			    res = collision(1);
			};
			if (res==OUT_NOT) {
			    status = ST_TURN;
			    stattick = 0;
			};
			break;
		    case XK_v:
			if (status != ST_STILL) break;
			toffx = 0.0;
			toffy = 0.0;
			toffz = 0.0;
			updatetemp_tra(toffx, toffy, toffz, -1, 0);
			res = collision(1);
			while (res!=OUT_NOT && res!=OUT_COLLIDE && res!=OUT_DOWN) {
			    switch (res) { /* as collision, ignore 2 */
				case OUT_UP:
				    toffz = toffz - 1.0 ;
				    break;
				case OUT_NORTHEAST:
				    toffx = toffx - 0.5;
				    toffy = toffy - ROOTHALF;
				    toffz = toffz + 0.5;
				    break;
				case OUT_SOUTH:
				    toffx = toffx - 0.5;
				    toffy = toffy + ROOTHALF;
				    toffz = toffz - 0.5;
				    break;
				case OUT_NORTHWEST:
				    toffx = toffx + 1.0;
				    break;
			    }
			    updatetemp_tra(toffx, toffy, toffz, -1, 0);
			    res = collision(1);
			};
			if (res==OUT_NOT) {
			    status = ST_MIRROR;
			    aspectflag = 1;
			    aspect = 1.0;
			    stattick = 0;
			};
			break;
		    case XK_p:
			if (status != ST_STILL) break;
			droptimer = dropticks+100;
			break;
		    case XK_space:
			if (status != ST_STILL) break;
			status = ST_SPACEHIT;
			break;
		    case XK_KP_1:
		    case XK_KP_3:
		    case XK_KP_4:
		    case XK_KP_6:
		    case XK_KP_7:
		    case XK_KP_9:
		    case XK_u:
		    case XK_o:
		    case XK_l:
		    case XK_period:
		    case XK_m:
		    case XK_j:
			if (status != ST_STILL) break;
			toffx = 0.0;
			toffy = 0.0;
			toffz = 0.0;
			if (ksym==XK_KP_4 || ksym==XK_j) toffx = -1.0;
			if (ksym==XK_KP_6 || ksym==XK_l) toffx = 1.0;
			if (ksym==XK_KP_9 || ksym==XK_o) {
			    toffx = 0.5;
			    toffy = ROOTHALF;
			    toffz = -0.5;
			}
			if (ksym==XK_KP_1 || ksym==XK_m) {
			    toffx = -0.5;
			    toffy = -ROOTHALF;
			    toffz = 0.5;
			}
			if (ksym==XK_KP_3 || ksym==XK_period) {
			    toffx = 0.5;
			    toffy = -ROOTHALF;
			    toffz = 0.5;
			}
			if (ksym==XK_KP_7 || ksym==XK_u) {
			    toffx = -0.5;
			    toffy = ROOTHALF;
			    toffz = -0.5;
			}
			updatetemp_tra(toffx, toffy, toffz, 0, 0);
			if (collision(1)==OUT_NOT) {
			    status = ST_GLIDE;
			    stattick = 0;
			};
			break;
		};
		break;
	    case ConfigureNotify:
		if (event.xconfigure.width != dispx ||
		    event.xconfigure.height != dispy) {
		    dispx = event.xconfigure.width;
		    dispy = event.xconfigure.height;
		    XFreePixmap(dpy, backpm);
		    XFreePixmap(dpy, fieldpm);
		    backpm = XCreatePixmap(dpy, win, dispx,
			dispy, scndepth);   
		    fieldpm = XCreatePixmap(dpy, win, dispx,
			dispy, scndepth);   
		    redo_board_globals();
		    setup_fieldpts();
		    setup_fieldpm();
		    add_balls(0);   
		    setup_backpm();
		    back_to_disp(1);		    
		    draw_score(win);
		}
		break;
	} /* done event switch */

	if (status==ST_PAUSE) status=ST_STILL;
	switch (status) {
	    case ST_STILL:
		droptimer++;
		if (droptimer>dropticks) {
		    droptimer=0;
		    updatetemp_tra(0.0, 0.0, -1.0, 0, 0);
		    if (collision(1)==OUT_NOT) {   
			stattick=0;
			status = ST_FALL;
		    }
		    else {
			plop_piece();
			curpiece = -1;
		    }
		}
		break;
	    case ST_SPACEHIT:
		updatetemp_tra(0.0, 0.0, -1.0, 0, 0);
		if (collision(1)==OUT_NOT) {  
		    score++;
		    stattick=1;
		    status = ST_PLUMMET;
		    offz -= 1.0/PLUMLENGTH;
		    updatepiece();
		    setup_backpm();
		    back_to_disp(0);
		}
		else {
		    plop_piece();
		    curpiece = -1;
		    status = ST_PAUSE;
		}
		break;
	    case ST_GLIDE:
		stattick++;
		offx += (double)toffx/GLIDELENGTH;
		offy += (double)toffy/GLIDELENGTH;
		offz += (double)toffz/GLIDELENGTH;
		if (stattick==GLIDELENGTH) {
		    round_piece(); 
		};
		updatepiece();
		setup_backpm();
		back_to_disp(0);
		if (stattick==GLIDELENGTH) {
		    status = ST_PAUSE;
		};
		break;
	    case ST_FALL:
		stattick++;
		offz -= 1.0/FALLLENGTH;
		if (stattick==FALLLENGTH) {
		    round_piece(); 
		};
		updatepiece();
		setup_backpm();
		back_to_disp(0);
		if (stattick==FALLLENGTH) {
		    status = ST_PAUSE;
		};
		break;
	    case ST_PLUMMET:
		stattick++;
		offz -= 1.0/PLUMLENGTH;
		if (stattick==PLUMLENGTH) {
		    round_piece(); 
		};
		updatepiece();
		setup_backpm();
		back_to_disp(0);
		if (stattick==PLUMLENGTH) {
		    status = ST_SPACEHIT;
		};
		break;
	    case ST_TURN:
		stattick++;
		rotate_piece(plist, taxis, ((double)(tdir))*PI/2.0/TURNLENGTH);
		offx += (double)toffx/TURNLENGTH;
		offy += (double)toffy/TURNLENGTH;
		offz += (double)toffz/TURNLENGTH;
		if (stattick==TURNLENGTH) {
		    round_piece(); 
		};
		updatepiece();
		setup_backpm();
		back_to_disp(0);
		if (stattick==TURNLENGTH) {
		    status = ST_PAUSE;
		};
		break;
	    case ST_MIRROR:
		stattick++;
		if (stattick == MIRRORLENGTH/2) {
		    reverse_piece(plist, -1);
		};
		if (stattick < MIRRORLENGTH/2) {
		    aspect = (double)(MIRRORLENGTH/2-stattick)
		      / (double)(MIRRORLENGTH/2);
		}
		else {
		    aspect = (double)(stattick-MIRRORLENGTH/2)
		      / (double)(MIRRORLENGTH/2);
		};
		offx += (double)toffx/MIRRORLENGTH;
		offy += (double)toffy/MIRRORLENGTH;
		offz += (double)toffz/MIRRORLENGTH;
		if (stattick==MIRRORLENGTH) {
		    round_piece(); 
		    aspectflag = 0;
		};
		updatepiece();
		setup_backpm();
		back_to_disp(0);
		if (stattick==MIRRORLENGTH) {
		    status = ST_PAUSE;
		};
		break;
	} /* done switch status */
    }
}

