/* (C) Copyright 1991 Andrew Plotkin. Permission is
 given to copy and use, as long as this copyright
 notice is retained. */

#include <stdio.h>
#include <math.h>    
#include <X11/Xlib.h>
#include "spheral.h"

#define GRIDSIZE (NUMBALLSIZES)
#define GREYS (64)

Pixmap ballpm[NUMBALLSIZES][NUMSHADES];
short ballpmflag[NUMBALLSIZES][NUMSHADES];

int errdiflag = 0;

extern GC gcblack, gcwhite;

void init_ballpmflags()
{
    register int ix, jx;

    for (ix=0; ix<NUMBALLSIZES; ix++) 
	for (jx=0; jx<NUMSHADES; jx++) {
	    ballpmflag[ix][jx] = 0;
	}
}

void create_ballpm(rad, shad)
int rad, shad;
{
    static short grid[GRIDSIZE*2][GRIDSIZE*2];
    static int shades[NUMSHADES] = {9, 20, 31, 44};
    static double xl=0.5, yl=0.3, zl=0.81240384;

    static XPoint *pts = NULL;
    int numpts = 0;

    register int ix, iy;
    double r;
    int ir;
    double xd, yd, zd;
    int lowshad = shades[shad];
    Pixmap pm;

    if (ballpmflag[rad][shad]) return;

    if (!pts) {
	pts = (XPoint *)malloc(sizeof(XPoint) * 52000);
    };

    pm = XCreatePixmap(dpy, win, rad*2, rad*2, scndepth);

    for (ix=GRIDSIZE-rad; ix<GRIDSIZE+rad; ix++) 
	for (iy=GRIDSIZE-rad; iy<GRIDSIZE+rad; iy++) {
	    r = ((double)((ix-GRIDSIZE)*(ix-GRIDSIZE) +
		(iy-GRIDSIZE)*(iy-GRIDSIZE))) / (double)(rad*rad);
	    if (r>1.0) grid[ix][iy] = 0;
	    else {
		xd = (double)(GRIDSIZE-ix)/(double)rad;
		yd = (double)(GRIDSIZE-iy)/(double)rad;
		zd = sqrt(1.0001-xd*xd-yd*yd);

		ir = (int)(15.0 * (xl*xd+yl*yd+zl*zd));
		if (ir<0) ir=0;
		else if (ir+lowshad >= GREYS) ir=GREYS-lowshad;
		grid[ix][iy] = lowshad + ir;
		/*grid[ix][iy] = (ir%2)*GREYS;*/
	    }
	    grid[ix][iy] += (7*grid[ix-1][iy] + 1*grid[ix-1][iy-1] +
		5*grid[ix][iy-1] + 3*grid[ix+1][iy-1]) / 16;
	    if (grid[ix][iy]>=(GREYS/2)) {
		/*XDrawPoint(dpy, pm, gcwhite, rad+ix-GRIDSIZE,
		 rad+iy-GRIDSIZE);*/
		pts[numpts].x = rad+ix-GRIDSIZE;
		pts[numpts].y = rad+iy-GRIDSIZE;
		numpts++;
		grid[ix][iy] -= GREYS;
	    }
	    /*else {
		XDrawPoint(dpy, pm, gcblack,
	        rad+ix-GRIDSIZE, rad+iy-GRIDSIZE);
	    };*/

	}

    XFillRectangle(dpy, pm, gcblack, 0, 0, rad*2, rad*2);
    XDrawPoints(dpy, pm, gcwhite, pts, numpts,
		CoordModeOrigin);

    ballpm[rad][shad] = pm;
    ballpmflag[rad][shad] = 1;
}
