/* (C) Copyright 1991 Andrew Plotkin. Permission is
 given to copy and use, as long as this copyright
 notice is retained. */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "spheral.h"

Display *dpy;
Window win;
Pixmap backpm, fieldpm, piecepm;
GC gcblack, gcwhite, gcinv, gccopy, gcline,
  gcfield, gcocto, gcadd, gcballs[16],
  gcpiece1, gcpiece0, gcpieceadd;
int scn;
int scndepth;

piecelist pieces[MAXPIECES];

short numpieces;
short curpiece;

int dispx, dispy; /* size of window */
int sshapx1, sshapx2, sshapy1, sshapy2;
/* size of rectangle that contains current shape */
int bbackx1, bbackx2, bbacky1, bbacky2;
/* coords of rectangle of backpm that is usable */
int ddispx1, ddispx2, ddispy1, ddispy2;
/* coords of rectangle of display that is
 different from fieldpm */

extern void draw_curpiece(), measure_curpiece(), setup_grey();

void xinit() /* using dispx, dispy */
{
    register int ix;
    XSetWindowAttributes attr;
    XGCValues gcvalues;
    static char dashes[2] = {1, 1};
    static char widedashes[2] = {1, 3};
    XSizeHints hints;

    dpy = XOpenDisplay((char *) NULL);
    if ((Display *) NULL == dpy) {
	fprintf(stderr, "spheral: could not open display.\n");
	exit(-1);
    }

    scn = DefaultScreen(dpy);
    scndepth = DefaultDepth(dpy, scn);
    if (scndepth==1) monomode = 1;

    win = XCreateSimpleWindow(dpy, DefaultRootWindow(dpy),
	100, 100, dispx, dispy, 1,
	BlackPixel(dpy, scn), WhitePixel(dpy, scn));

    hints.min_width = 100;
    hints.min_height = 100;
    hints.width = dispx;
    hints.height = dispy;
    hints.flags = PMinSize | PSize;
    XSetWMNormalHints(dpy, win, &hints);
    {
	XWMHints wmhints;
	wmhints.flags = InputHint;
	wmhints.input = True;
	XSetWMHints(dpy, win, &wmhints);
    }

    XStoreName(dpy, win, "Spheral");

    attr.event_mask = (KeyPressMask | ExposureMask
		       | StructureNotifyMask);
    XChangeWindowAttributes(dpy, win, CWEventMask, &attr);

    XSetWindowBackground(dpy, win, BlackPixel(dpy, scn));

    XMapWindow(dpy, win);

    gcvalues.foreground = WhitePixel(dpy, scn);
    gcvalues.background = BlackPixel(dpy, scn);
    gcwhite = XCreateGC(dpy, win, GCForeground|GCBackground,
			&gcvalues);

    gcvalues.line_style = LineOnOffDash;
    gcfield = XCreateGC(dpy, win, GCForeground|GCLineStyle,
			&gcvalues);
    XSetDashes(dpy, gcfield, 0, dashes, 2);
    gcocto = XCreateGC(dpy, win, GCForeground|GCLineStyle,
		       &gcvalues);
    XSetDashes(dpy, gcocto, 0, widedashes, 2);

    gcvalues.line_width = 2;
    gcline = XCreateGC(dpy, win, GCForeground|GCLineWidth,
		       &gcvalues);

    if (WhitePixel(dpy, scn))
	gcvalues.function = GXor;
    else
	gcvalues.function = GXand;
    gcadd = XCreateGC(dpy, win, GCForeground|GCBackground|GCFunction,
		      &gcvalues);
    XSetGraphicsExposures(dpy, gcadd, 0);

    gcvalues.function = GXinvert;
    gcinv = XCreateGC(dpy, win, GCForeground|GCFunction,
		      &gcvalues);

    gcvalues.foreground = BlackPixel(dpy, scn);
    gcblack = XCreateGC(dpy, win, GCForeground, &gcvalues);

    gcvalues.background = WhitePixel(dpy, scn);
    gccopy = XCreateGC(dpy, win, GCForeground|GCBackground,
		       &gcvalues);
    XSetGraphicsExposures(dpy, gccopy, 0);

    setup_grey();

    backpm = XCreatePixmap(dpy, win, dispx, dispy, scndepth);   
    fieldpm = XCreatePixmap(dpy, win, dispx, dispy, scndepth);
    if (monomode) {
	piecepm = NULL;
	gcpiece0 = NULL;
	gcpiece1 = NULL;
	gcpieceadd = NULL;
    }
    else {
	piecepm = XCreatePixmap(dpy, win, dispx, dispy, 1);
	gcvalues.foreground = 0;
	gcpiece0 = XCreateGC(dpy, piecepm, GCForeground,
		&gcvalues);
	gcvalues.foreground = 1;
	gcpiece1 = XCreateGC(dpy, piecepm, GCForeground,
		&gcvalues);
	gcvalues.foreground = WhitePixel(dpy, scn);
	gcvalues.background = BlackPixel(dpy, scn);
	gcvalues.function = GXand;
	gcpieceadd = XCreateGC(dpy, win,
		GCForeground|GCBackground|GCFunction,
		&gcvalues);
	XSetGraphicsExposures(dpy, gcpieceadd, 0);
    }
}

void setup_fieldpm() /* clear, draw field box and side text.
 Also set bback{x,y}{1,2} to window size */
{
    register int ix, iz;

    XFillRectangle(dpy, fieldpm, gcblack, 0, 0, dispx, dispy);
    XDrawImageString(dpy, fieldpm, gcwhite, 20, 20, "Score: ", 7); 

    /* draw triangles (sort of) parallel to screen */
    for (iz=fieldz-1; iz<fieldz; iz++) {
	XDrawLine(dpy, fieldpm, gcfield, fieldpts[0][0][iz].x,
		  fieldpts[0][0][iz].y, fieldpts[fieldx-1][0][iz].x,
		  fieldpts[fieldx-1][0][iz].y);
	XDrawLine(dpy, fieldpm, gcfield, fieldpts[0][0][iz].x,
		  fieldpts[0][0][iz].y, fieldpts[0][fieldx-1][iz].x,
		  fieldpts[0][fieldx-1][iz].y);
	XDrawLine(dpy, fieldpm, gcfield, fieldpts[fieldx-1][0][iz].x,
		  fieldpts[fieldx-1][0][iz].y, fieldpts[0][fieldx-1][iz].x,
		  fieldpts[0][fieldx-1][iz].y);
    };

    /* draw perpendiculars to screen */
    for (ix=0; ix<fieldx; ix++) {
	XDrawLine(dpy, fieldpm, gcfield, fieldpts[ix][0][0].x,
		  fieldpts[ix][0][0].y, fieldpts[ix][0][fieldz-1].x,
		  fieldpts[ix][0][fieldz-1].y);
	XDrawLine(dpy, fieldpm, gcfield, fieldpts[0][ix][0].x,
		  fieldpts[0][ix][0].y, fieldpts[0][ix][fieldz-1].x,
		  fieldpts[0][ix][fieldz-1].y);
	XDrawLine(dpy, fieldpm, gcfield, fieldpts[ix][fieldx-1-ix][0].x,
		  fieldpts[ix][fieldx-1-ix][0].y,
		  fieldpts[ix][fieldx-1-ix][fieldz-1].x,
		  fieldpts[ix][fieldx-1-ix][fieldz-1].y);
    }

    for (ix=0; ix<fieldx-1; ix++) {
	XDrawLine(dpy, fieldpm, gcfield, fieldpts[ix+1][0][0].x,
		  fieldpts[ix+1][0][0].y, fieldpts[0][ix+1][0].x,
		  fieldpts[0][ix+1][0].y);
	XDrawLine(dpy, fieldpm, gcfield, fieldpts[ix][0][0].x,
		  fieldpts[ix][0][0].y, fieldpts[ix][fieldx-ix-1][0].x,
		  fieldpts[ix][fieldx-ix-1][0].y);
	XDrawLine(dpy, fieldpm, gcfield, fieldpts[0][ix][0].x,
		  fieldpts[0][ix][0].y, fieldpts[fieldx-ix-1][ix][0].x,
		  fieldpts[fieldx-ix-1][ix][0].y);
    }

    bbackx1 = dispx-1;
    bbackx2 = 0;

    ddispx1 = 0;
    ddispx2 = dispx-1;
    ddispy1 = 0;
    ddispy2 = dispy-1;
    /*meteroldlev = 0;*/
}

void setup_backpm()
/* put stuff on the backpm, so that bback is the smallest
 area different from fieldpm (but larger than ddisp), and
 those together are an accurate picture of the board */
{
    piecesum psum;
    register int ix;
    int rad;

    /* measure piece, store max{sshap, ddisp} in bback limits */
    measure_curpiece(&psum);
    sshapx1 = dispx;
    sshapx2 = 0;
    sshapy1 = dispy;
    sshapy2 = 0;
    for (ix=0; ix<psum.numballs; ix++) {
	rad = psum.rad[ix];
	if (psum.p[ix].x-rad < sshapx1) sshapx1 = psum.p[ix].x-rad;
	if (psum.p[ix].x+rad > sshapx2) sshapx2 = psum.p[ix].x+rad;
	if (psum.p[ix].y-rad < sshapy1) sshapy1 = psum.p[ix].y-rad;
	if (psum.p[ix].y+rad > sshapy2) sshapy2 = psum.p[ix].y+rad;
    }
    sshapx1 -= 2;
    sshapy1 -= 2;
    sshapx2 += 2;
    sshapy2 += 2;

    bbackx1 = (sshapx1 < ddispx1) ? sshapx1 : ddispx1;
    bbacky1 = (sshapy1 < ddispy1) ? sshapy1 : ddispy1;
    bbackx2 = (sshapx2 > ddispx2) ? sshapx2 : ddispx2;
    bbacky2 = (sshapy2 > ddispy2) ? sshapy2 : ddispy2;

    if (monomode) {
	/* clear backpm, using bback limits */
	XFillRectangle(dpy, backpm, gcblack, bbackx1, bbacky1,
		bbackx2-bbackx1+1, bbacky2-bbacky1+1);
	/* draw piece on backpm */
	draw_curpiece(backpm, &psum, gcwhite, gcblack);

	/* overlay fieldpm on backpm, using bback limits */
	XCopyArea(dpy, fieldpm, backpm, gcadd, bbackx1, bbacky1,
		bbackx2-bbackx1+1, bbacky2-bbacky1+1, bbackx1, bbacky1);
    }
    else {
	/* clear piecepm, using bback limits */
	XFillRectangle(dpy, piecepm, gcpiece0, bbackx1, bbacky1,
		bbackx2-bbackx1+1, bbacky2-bbacky1+1);
	/* draw piece on piecepm */
	draw_curpiece(piecepm, &psum, gcpiece1, gcpiece0);

	/* copy fieldpm to backpm, using bback limits */
	XCopyArea(dpy, fieldpm, backpm, gccopy, bbackx1, bbacky1,
		bbackx2-bbackx1+1, bbacky2-bbacky1+1, bbackx1, bbacky1);
	XCopyPlane(dpy, piecepm, backpm, gcpieceadd, bbackx1, bbacky1,
		bbackx2-bbackx1+1, bbacky2-bbacky1+1,
		bbackx1, bbacky1, 1);
    }
}

void back_to_disp(all)
int all; 
{
    if (all || (bbackx2==0)) {
	/* copy fieldpm to display, then backpm
	 to display (using sshap), then set ddisp to sshap */
	XCopyArea(dpy, fieldpm, win, gccopy, 0, 0, dispx, dispy, 0, 0);
	XCopyArea(dpy, backpm, win, gccopy, sshapx1, sshapy1,
		  sshapx2-sshapx1+1, sshapy2-sshapy1+1, sshapx1, sshapy1);
	ddispx1 = sshapx1;
	ddispy1 = sshapy1;
	ddispx2 = sshapx2;
	ddispy2 = sshapy2;
    }
    else {
	/* copy from backpm to display (using bback) */
	XCopyArea(dpy, backpm, win, gccopy, bbackx1, bbacky1,
		  bbackx2-bbackx1+1, bbacky2-bbacky1+1, bbackx1, bbacky1);

	/* set ddisp limits to ddisp limits; */
	ddispx1 = sshapx1;
	ddispy1 = sshapy1;
	ddispx2 = sshapx2;
	ddispy2 = sshapy2;

	/*if (meter_b_d) {
	    XCopyArea(dpy, backpm, win, gccopy, meterx, metery,
		      metersize*fieldz+1, 21, meterx, metery);
	    if (stereo) {
		XCopyArea(dpy, backpm, win, gccopy, meterx2, metery,
			  metersize*fieldz+1, 21, meterx2, metery);
	    }
	    meter_b_d = 0;
	}*/

    }
}

void draw_curpiece(drw, psum, gcon, gcoff) /* just that */
Drawable drw;
piecesum *psum;
GC gcon, gcoff;
{
    register int ix;
    int rad, radx, rady, lradx, lrady;

    for (ix=0; ix<psum->numballs; ix++) {
	rad = psum->rad[ix];
	radx = (int)(rad*psum->scalex);
	if (radx < 3) radx=3;
	rady = (int)(rad*psum->scaley);
	if (rady < 3) rady=3;

	XFillArc(dpy, drw, gcon, psum->p[ix].x-radx,
		 psum->p[ix].y-rady, radx*2, rady*2, 0, 23040); 
	XFillArc(dpy, drw, gcoff, psum->p[ix].x-radx+2,
		 psum->p[ix].y-rady+2, radx*2-4, rady*2-4, 0, 23040); 

	/*XFillArc(dpy, drw, gcoff, psum->p[ix].x-rad,
	 psum->p[ix].y-rad, rad*2, rad*2, 0, 23040); 
	 XDrawArc(dpy, drw, gcon, psum->p[ix].x-rad,
	 psum->p[ix].y-rad, rad*2, rad*2, 0, 23040); */

	/*XDrawArc(dpy, drw, gcon, psum->p[ix].x-rad/2,
	 psum->p[ix].y-rad, rad, rad*2, 0, 23040); 
	 XDrawArc(dpy, drw, gcon, psum->p[ix].x-rad,
	 psum->p[ix].y-rad/2, rad*2, rad, 0, 23040); */

	lradx = radx/16;
	if (lradx < 2) lradx = 2;
	lrady = rady/16;
	if (lrady < 2) lrady = 2;
	XFillArc(dpy, drw, gcon, psum->p[ix].x-lradx,
		 psum->p[ix].y-lrady, 2*lradx, 2*lrady, 0, 23040); 
    }
}

void draw_score(drw)
Drawable drw;
{
    static char buf[32];
    register int ix;
    long sc;

    if (score==0) {
	XDrawImageString(dpy, drw, gcwhite, 76, 20,
			 "0         ", 10);
    }
    else {
	sc = score;
	ix = 32;
	buf[--ix] = '\0';
	while (sc) {
	    buf[--ix] = (sc%10) + '0';
	    sc /= 10;
	};
	XDrawImageString(dpy, drw, gcwhite, 76, 20,
			 buf+ix, 31-ix);
    }
}

void loadpieces(flname)
char *flname;
{
    register int jx, ix;
    FILE *fl;
    int res;

    fl = fopen(flname, "r");
    if (fl==NULL) {
	fprintf(stderr, "spheral: could not open shape file.\n");
	exit(-1);
    };

    res=fscanf(fl, "%hd\n", &numpieces);
    if (res!=1) {
	fprintf(stderr, "spheral: error 0 in shape file.\n");
	exit(-1);
    };

    for (ix=0; ix<numpieces; ix++) {
	int in1, in2, in3;
	res=fscanf(fl, "%d\n", &in1);
	if (res!=1) {
	    fprintf(stderr, "spheral: error 1 in shape file.\n");
	    exit(-1);
	};
	pieces[ix].numballs=in1;
	if (pieces[ix].numballs>MAXBALLS) {
	    fprintf(stderr, "spheral: shape %d is too complex.\n", ix);
	    exit(-1);
	};
	for (jx=0; jx<pieces[ix].numballs; jx++) {
	    point *p = &(pieces[ix].points[jx]);
	    res=fscanf(fl, "%lf, %lf, %lf\n", &(p->x),
		       &(p->y), &(p->z));
	    if (res!=3) {
		fprintf(stderr, "spheral: error 2 in shape file.\n");
		exit(-1);
	    };
	    p->w = 1.0;
	};
    }
}

