/* (C) Copyright 1991 Andrew Plotkin. Permission is
 given to copy and use, as long as this copyright
 notice is retained. */

#define MAXFIELDWIDTH (10)
#define MAXFIELDDEPTH (10)

#define MAXFIELDXY (10)
#define MAXFIELDZ (15)

#define MAXCUBES (8)
#define MAXVERTS (30)
#define MAXPOINTS (MAXCUBES+MAXVERTS)
#define MAXEDGES (40)
#define MAXPIECES (30)

#define NUMGAMERS (20)

#define F_OFF (0)
#define F_ON (1)
#define F_TEMP (2)

#define CUF_SIDEX (1)
#define CUF_SIDEY (2)

#ifdef VMS
#include "unix_time.h"
#include "unix_types.h"
#endif

typedef struct _point {
    double x, y, z, w;
} point;

typedef struct _edge {
    short head, tail;
} edge;

typedef double matrix[4][4];

typedef XPoint fieldplist[MAXFIELDXY+1][MAXFIELDXY+1][MAXFIELDZ+1];

typedef struct _piecelist {
    short numcubes;
    short numverts;
    short numpoints;  /* sum of cubes and verts */
    short numedges;
    point *verts;     /* set to &(points[numcubes]) */
    point points[MAXPOINTS];
    edge edges[MAXEDGES];
} piecelist;

typedef struct _gamer {
    char userid[16];
    char name[16];
    long score;
    char scoret[16];
} gamer;

extern gamer hscores[NUMGAMERS];

extern piecelist pieces[MAXPIECES];

extern unsigned char field[MAXFIELDXY][MAXFIELDXY][MAXFIELDZ];
extern fieldplist fieldpts;
extern fieldplist fieldpts2;

extern short fieldx, fieldy, fieldz;
extern double fieldoffx, fieldoffx2, fieldoffy, fieldoffz;
extern int meterx, meterx2, metery, metersize,
meterlev, meteroldlev, meter_f_b, meter_b_d;
/* oldlev is level on fieldpm */

extern short numpieces;
extern short curpiece;

extern int colors[];

extern Display *dpy;
extern Window win;
extern int scndepth;

extern int stereo;
extern int dispx, dispy; /* size of window */
extern Pixmap backpm; /* size of window */
extern int shapex1, shapex2, shapey1, shapey2;
/* coords of rectangle of backpm that is different from fieldpm */
extern int ddispx1, ddispx2, ddispy1, ddispy2;
/* coords of rectangle of display that is different from fieldpm */
extern Pixmap fieldpm; /* size of window */
extern long score, dropticks;
extern double boardscale;
extern int halfboard, halfboard2;

extern void clearfield();
/* zero out field[][][] */
extern void setup_fieldpm();
/* clear, draw field box and side text. Also set
 shape{x,y}{1,2} to window size */
extern void startpiece();
/* pick a piece and put it in the pipeline */
extern long current_usec();
extern int elapsed();

extern long random();
