/* (C) Copyright 1991 Andrew Plotkin. Permission is
given to copy and use, as long as this copyright
 notice is retained. */

#include <stdio.h>
#include <X11/Xlib.h>
#include "spatial.h"
#include "patchlevel.h"

#define INITWINSIZEX (720)
#define INITWINSIZEY (740)

extern void srandom();

extern double focallen;
extern int forcemono;

extern void xinit(), loadpieces(), gameloop(),
initintro(), introloop(), get_names(), load_hscores(),
redo_board_globals();
extern int checkmod_scores();

main(argc, argv)
int argc;
char *argv[];
{
    int ix;

    srandom(getpid());

    for (ix=1; ix<argc; ix++) {
	if (strcmp(argv[ix], "-m")) {
	    fprintf(stderr, "usage: spatial [ -m ]\n");
	    exit(-1);
	}
	else
	    forcemono = 1;
    }

    loadpieces(PIECEFILENAME);
    fieldx = 5;
    fieldy = 5;
    fieldz = 11;
    fieldoffx = -2.5;
    fieldoffy = -2.5;
    fieldoffz = -4.0-(double)fieldz;
    focallen = 1.0;
    stereo = 0;
    dispx = INITWINSIZEX;
    dispy = INITWINSIZEY;
    redo_board_globals();
    xinit();
    get_names();
    load_hscores(0);
    while (1) {
	initintro();
	introloop();
	initgame();
	gameloop();
	if (checkmod_scores()) {
	    load_hscores(1);
	}
    }
}
