/* (C) Copyright 1991 Andrew Plotkin. Permission is
 given to copy and use, as long as this copyright
 notice is retained. */

#include <stdio.h>
#include <errno.h>
#include <ctype.h> 

#ifdef VMS
#include "pwd.h"
#else
#include <pwd.h>    
#endif

#include <sys/file.h>
#include <X11/Xlib.h>
#ifdef AFS
#include <niftyprofile.h>    
#endif
#include "spatial.h"

#ifdef VMS
char * vmsusername;
int vmsuserlen;
#endif

extern char *getenv();
char ProgramName[] = "spatial";

gamer hscores[NUMGAMERS];
char hscorefl[512];
char userid[16], gamename[16];

extern int errno;

void load_hscores(save)
int save;
{
    FILE *fl;
    register int ix, jx;
    int fd, res;
    char buf[255];

    fl = fopen(hscorefl, "r+");
    if (!fl) {
	fprintf(stderr,
	    "spatial: unable to open high score file\n");
	fprintf(stderr,
	    "spatial: generating empty score file\n");

	fl = fopen(hscorefl, "w");
	if (!fl) {
	    fprintf(stderr,
		    "spatial: unable to create high score file\n");
	    exit(-1);
	}

	for (ix=0; ix<NUMGAMERS; ix++) {
	    fprintf(fl, "----\nSpatial\n0\n");
	}
	fclose(fl);
	fl = fopen(hscorefl, "r+");
	if (!fl) {
	    fprintf(stderr,
		    "spatial: unable to reopen high score file\n");
	    exit(-1);
	}
    }

    fd = fileno(fl);
#ifndef VMS
#ifdef USELOCKF
    res = lockf(fd, F_LOCK, 0);
#else
    res = flock(fd, LOCK_NB | LOCK_EX);
#endif
    while (res) {
	if (errno != EWOULDBLOCK) {
	    fprintf(stderr,
		    "spatial: unable to lock high score file\n");
	    exit(-1);
	};
	sleep(1);
#ifdef USELOCKF
	res = lockf(fd, F_LOCK, 0);
#else
	res = flock(fd, LOCK_NB | LOCK_EX);
#endif
    };
#endif /*VMS */

    for (ix=0; ix<NUMGAMERS; ix++) {
	long val;

	fgets(buf, 255, fl);
	for (jx=0; jx<15 && buf[jx]!='\n'; jx++) 
	    hscores[ix].userid[jx] = buf[jx];
	hscores[ix].userid[jx] = '\0';
	
	fgets(buf, 255, fl);
	for (jx=0; jx<15 && buf[jx]!='\n'; jx++) 
	    hscores[ix].name[jx] = buf[jx];
	hscores[ix].name[jx] = '\0';
	
	fgets(buf, 255, fl);
	val=0;
	for (jx=0; buf[jx]!='\n'; jx++) 
	    val = val*10 + buf[jx] - '0';
	hscores[ix].score = val;
	sprintf(hscores[ix].scoret, "%d", val);
    };

    if (save) {
	if (checkmod_scores()) {
	    rewind(fl);
	    for (ix=0; ix<NUMGAMERS; ix++) {
		fprintf(fl, "%s\n%s\n%d\n", hscores[ix].userid,
			hscores[ix].name, hscores[ix].score);
	    }
	}
    }

#ifndef VMS
#ifdef USELOCKF
    lockf(fd, F_ULOCK, 0);
#else
    flock(fd, LOCK_UN);
#endif
#endif
    fclose(fl);
}

int checkmod_scores()
{
    register int ix;
    int new, bottom;
    
    if (score <= hscores[NUMGAMERS-1].score) return 0;
    
    for (ix=0; strcmp(hscores[ix].userid, userid)
      && ix<NUMGAMERS; ix++);
    
    if (ix<NUMGAMERS) { /* was in list */
	if (score <= hscores[ix].score) return 0;
	bottom = ix;
    }
    else { /* wasn't in list */
	bottom = NUMGAMERS-1;
    };

    for (new=0; score<=hscores[new].score; new++);
    for (ix=bottom; ix>new; ix--) {
	strcpy(hscores[ix].name, hscores[ix-1].name);
	strcpy(hscores[ix].userid, hscores[ix-1].userid);
	strcpy(hscores[ix].scoret, hscores[ix-1].scoret);
	hscores[ix].score = hscores[ix-1].score;
    };
    strcpy(hscores[new].name, gamename);
    strcpy(hscores[new].userid, userid);
    hscores[new].score = score;
    sprintf(hscores[new].scoret, "%d", score);

    return 1;
}

void get_names()
{
    register int ix;
    struct passwd *tp;
    char *tcp;

    strcpy(hscorefl, SCOREFILENAME);

#ifdef VMS
    vmsusername = getenv("USER");
    vmsuserlen  = strlen(vmsusername);
    strncpy (userid, (const)vmsusername, vmsuserlen); 
#else
    tp = getpwuid(getuid());
    if (!tp) {
	printf("unable to get userid!\n");
	strcpy(userid, "????");
    }
    else {
	strncpy(userid, tp->pw_name, 16);
	userid[15] = '\0';
    }
#endif /* VMS */

    tcp = getenv("NAME");
    if (tcp) {
	strncpy(gamename, tcp, 16);
	gamename[15] = '\0';
    }
    else if (tcp=XGetDefault(dpy, "spatial", "name")) {
	strncpy(gamename, tcp, 16);
	gamename[15] = '\0';
    }
    else {
	strcpy(gamename, userid);
    };


    printf("Welcome, %s (%s)\n", gamename, userid);

}
