/* (C) Copyright 1991 Andrew Plotkin. Permission is
 given to copy and use, as long as this copyright
 notice is retained. */

#include <stdio.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include "spatial.h"

#ifdef VMS
float seconds;
#endif

#define TICKLENGTH (50000)
#define xputs(x, y, str)  \
XDrawImageString(dpy, win, gcwhite, x, y, str, strlen(str))

#define xline(x1, y1, x2, y2)  \
XDrawLine(dpy, win, gcwhite, x1, y1, x2, y2) 

extern GC gcblack, gcwhite, gcinv, gccopy, gcline,
gcfield, gccubes[];

extern void intro_redraw(), redo_board_globals();

void initintro()
{
    intro_redraw();
}

void introloop()
{
    short status, res;
    Bool eventp;
    XEvent event, nextevent;
    long evmasks;
    char key;
    KeySym ksym;
    long lasttime;
    struct timeval tv;
    fd_set readbits;

    while (1) {
	tv.tv_sec = 0;
	tv.tv_usec = TICKLENGTH;
	FD_ZERO(&readbits);
	FD_SET(ConnectionNumber(dpy), &readbits);

#ifdef VMS
        seconds = (float) tv.tv_sec;
        (void) LIB$WAIT(&seconds);
#else
	(void)select(1+ConnectionNumber(dpy), &readbits, 0, 0, &tv);
#endif
	evmasks = (KeyPressMask | ExposureMask | StructureNotifyMask);
	eventp = XCheckWindowEvent(dpy, win, evmasks, &event);
	if (eventp) switch (event.type) {
	    case Expose:
		eventp = XCheckWindowEvent(dpy, win, evmasks,
			&nextevent);
		while (eventp && nextevent.type == Expose) {
		    eventp = XCheckWindowEvent(dpy, win, evmasks,
			&nextevent);
		};
		if (eventp) {
		    XPutBackEvent(dpy, &nextevent);
		};
		intro_redraw();
		break;
	    case KeyPress:
		XLookupString(&event, &key, 1, &ksym, NULL);
		/*printf("got '%s'\n", XKeysymToString(ksym));*/
		switch (ksym) {
		    case XK_q:
		    case XK_Q:
			exit(0);
			break;
		    case XK_c:
		    case XK_C:
			if (!stereo) {
			    stereo = 1;
			    fieldoffx = -2.65;
			    fieldoffx2 = -2.35;
			}
			else if (fieldoffx < -2.5) {
			    fieldoffx = -2.35;
			    fieldoffx2 = -2.65;
			}
			else {
			    stereo = 0;
			    fieldoffx = -2.5;
			};
			redo_board_globals();
			intro_redraw();
			break;
		    case XK_s:
		    case XK_S:
			return;
		};
		break;
	    case ConfigureNotify:
		if (event.xconfigure.width != dispx || event.xconfigure.height != dispy) {
		    dispx = event.xconfigure.width;
		    dispy = event.xconfigure.height;
		    redo_board_globals();
		    XFreePixmap(dpy, backpm);
		    XFreePixmap(dpy, fieldpm);
		    backpm = XCreatePixmap(dpy, win, dispx,
					   dispy, scndepth);   
		    fieldpm = XCreatePixmap(dpy, win, dispx,
					    dispy, scndepth);   
		}
		break;
	}
    }
}

void intro_redraw()
{
    register int ix;
    char buf[255];

    XFillRectangle(dpy, win, gcblack, 0, 0, dispx, dispy);
    xputs(50, 180, "Spatial");
    xputs(50, 200, "A Sadistic Software Production");
    xputs(50, 220, "(C) Copyright 1991-3 Andrew Plotkin");
    xputs(50, 240, " (ap1i@andrew.cmu.edu)");
    if (score!=(-1)) {
	sprintf(buf, "Your score: %d", score);
	xputs(50, 260, buf);
    }

    xputs(50, 280, "Commands:");
    xputs(70, 300, "s: start game");
    if (!stereo) xputs(70, 320, "c: change display (normal)");
    else if (fieldoffx < -2.5)
	xputs(70, 320, "c: change display (reversed stereoscopic)");
    else
	xputs(70, 320, "c: change display (normal stereoscopic)");
    xputs(70, 340, "Escape: pause");
    xputs(70, 360, "q: quit program");

    xputs(50, 400, "Game controls:");

    XDrawArc(dpy, win, gcfield, 50, 410, 140, 140, 0, 23040);
    XDrawArc(dpy, win, gcfield, 100, 410, 40, 140, 0, 23040);
    XDrawArc(dpy, win, gcfield, 50, 460, 140, 40, 0, 23040);
    XDrawArc(dpy, win, gcfield, 102, 410, 40, 140, 5760, 11520);
    XDrawArc(dpy, win, gcfield, 50, 462, 140, 40, 11520, 11520);
    XDrawArc(dpy, win, gcwhite, 101, 410, 40, 140, 8000, 3000);
    XDrawArc(dpy, win, gcwhite, 101, 410, 40, 140, 14000, 2000);
    XDrawArc(dpy, win, gcwhite, 50, 461, 140, 40, 13000, 2000);
    XDrawArc(dpy, win, gcwhite, 50, 461, 140, 40, 17800, 3000);
    XDrawArc(dpy, win, gcwhite, 51, 411, 138, 138, 1920, 1920);
    XDrawArc(dpy, win, gcwhite, 51, 411, 138, 138, 7680, 1920);
    xline(110, 421, 114, 430);
    xline(110, 421, 100, 427);
    xline(179, 492, 170, 488);
    xline(179, 492, 173, 502);
    xline(57, 489, 60, 498);
    xline(57, 489, 60, 484);
    xline(114, 546, 105, 543);
    xline(114, 546, 119, 543);
    xline(182, 448, 172, 445);
    xline(58, 448, 68, 445);

    xputs(83, 501, "h");
    xputs(120, 503, "l");
    xputs(99, 483, "i");
    xputs(102, 518, "m");
    xputs(91, 418, "k");
    xputs(144, 416, "j");

    xputs(70, 570, "rotation keys as shown above");
    xputs(70, 590, "arrow keys: move piece sideways");
    xputs(70, 610, "p: drop piece by 1");
    xputs(70, 630, "space: drop piece to bottom");
    xputs(70, 650, "q: quit game and return to this menu");

    xputs(350, 250, "High Scores:");
    for (ix=0; ix<NUMGAMERS; ix++) {
	xputs(390, 270+20*ix, hscores[ix].name);
	xputs(490, 270+20*ix, hscores[ix].userid);
	xputs(590, 270+20*ix, hscores[ix].scoret);
    }
}
