/* (C) Copyright 1991 Andrew Plotkin. Permission is
 given to copy and use, as long as this copyright
 notice is retained. */

#include <stdio.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include "spatial.h"

#ifdef VMS
float seconds;
#endif

extern GC gcblack, gcwhite, gcinv, gccopy, gcline, gcfield, gccubes[]; 

extern void pause_redraw(), add_cubie();

void pauseloop()
{
    short status, res, lev;
    short droptimer, stattick;
    Bool eventp;
    XEvent event, nextevent;
    long evmasks;
    char key;
    KeySym ksym;
    struct timeval timeout;

    setup_fieldpm();
    pause_redraw();
    lev = 0;
    droptimer=0;

    while (1) {
	evmasks = (KeyPressMask | ExposureMask | StructureNotifyMask);
	eventp = XCheckWindowEvent(dpy, win, evmasks, &event);
	if (eventp) switch (event.type) {
	    case Expose:
		eventp = XCheckWindowEvent(dpy, win, evmasks, &nextevent);
		while (eventp && nextevent.type == Expose) {
		    eventp = XCheckWindowEvent(dpy, win, evmasks, &nextevent);
		};
		if (eventp) {
		    XPutBackEvent(dpy, &nextevent);
		};
		pause_redraw();
		break;
	    case KeyPress:
		XLookupString(&event, &key, 1, &ksym, NULL);
		/*printf("got '%s'\n", XKeysymToString(ksym));*/
		switch (ksym) {
		    case XK_Escape:
		    case XK_Q:
		    case XK_q:
		    case XK_S:
		    case XK_s:
			return;
			break;
		}
		break;
	    case ConfigureNotify:
		if (event.xconfigure.width != dispx || event.xconfigure.height != dispy) {
		    dispx = event.xconfigure.width;
		    dispy = event.xconfigure.height;
		    XFreePixmap(dpy, backpm);
		    XFreePixmap(dpy, fieldpm);
		    backpm = XCreatePixmap(dpy, win, dispx, dispy,
					   scndepth);   
		    fieldpm = XCreatePixmap(dpy, win, dispx, dispy,
					    scndepth);   
		    redo_board_globals();
		    setup_cubies();
		    setup_fieldpm();
		    pause_redraw();
		}
		break;
	};
	timeout.tv_sec = 0;
	timeout.tv_usec = 50000;
#ifdef VMS
       seconds = (float) timeout.tv_sec;
       (void) LIB$WAIT(&seconds);
#else
	select(0, 0, 0, 0, &timeout);	
#endif
	droptimer++;
	if (droptimer>=5) {
	    droptimer=0;
	    if (lev==fieldz) {
		lev=0;
		setup_fieldpm();
		pause_redraw();
	    }
	    else {
		add_cubie(random()%fieldx, random()%fieldy, lev);
		pause_redraw();
		lev++;
	    }
	}
    }
}

void pause_redraw()
{
    XCopyArea(dpy, fieldpm, win, gccopy, 0, 0, dispx, dispy, 0, 0);
}
