/* Description :
	 tabul.c : the DrFermi (or whatever you call it) tabulator sequencer.
*/
/* Copyright notice :
   Copyright 1993 Stefane Fermigier (fermigie@dmi.ens.fr).
*/
/* Licence :
	 You have the right to use, read, compile, modify these files. 
	 But don't remove the copyright notice, and don't distribute without
	 the appropriate manual.

	 No warranty are provided that this program will do what it claims.
*/

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "midifile.h"
#include "tabul.h"

int debug = 0, verbose = 0;
char *progname;

FILE *input_file, *output_file;
char *file_name; /* input file name */

/* From config.c */
int ReadConfig();
void FinishConfig();
void BeginConfig();
void MidiClose();
extern unsigned long def_tempo;
extern int tempo_set_from_args;

/* From decode.c */
int DecodeBlock();

/* This file */
void Init(), Work(), Fail();

/* parse arguments */
main(argc, argv)
	int  argc;
	char **argv;
{
	int  c;
	int err_flag = 0;
	double tempo;
	extern char *optarg;
	extern int optind;

	progname = argv[0];

	while ((c = getopt(argc, argv, "d:vt:")) != -1)
		switch (c) {
		case 'd': 
			debug = atoi(optarg);
			break;
		case 'v': 
			verbose = 1;
			break;
		case 't':
			tempo = atof(optarg);
			if (tempo <= 0.0) {
				fprintf (stderr, "Tempo <= 0\n");
				exit(0);
			}
			def_tempo = 60.0 / tempo * 1e6;
			tempo_set_from_args = 1;
			break;
		case '?':
		default :
			err_flag++;
	}
	if (debug) 
		printf("\n");
	if (err_flag) {
		(void) fprintf(stderr, "usage: %s [-d<debug_level>] [-v] [-t<tempo>] source_file", 
			progname);
		exit(2);
	}
	printf ("DrFermi tabulator notation program,\n");
	printf ("written by fermigie@ens.fr\n");

	/* let's open the input and output files. */
	if(optind < argc) {
		file_name = argv[optind];
		input_file = fopen(argv[optind], "r");
		if (input_file == NULL) {
			fprintf(stderr, "Could not open input file ``%s''.\n", file_name);
			exit(1);
		}
		printf ("input from %s, ", file_name);
		optind++;
		if (optind < argc) {
			output_file = fopen(argv[optind], "w");
			if (output_file == NULL) {
				Fail("Could not open output file %s.\n", argv[optind]);
			}
		} else {
			char buff[100];

			strcpy (buff, file_name);
			strcat (buff, ".mid");
			output_file = fopen(buff, "w");
			if (output_file == NULL) {
				Fail("Could not open output file %s.\n", buff);
			}
			printf ("output to %s\n", buff);
		}
	} else {
		fprintf (stderr, "I can't work with stdin & stdout, sorry.\n");
		exit(0);
	}

 	Init(); 

	Work();

	MidiClose();
	fclose(stdout);
	exit(0);
	/* NOTREACHED */
}

void Init()
{
	FILE *rc_file;
	char *rc_name = RC_NAME;
	int stat;

	BeginConfig ();

	rc_file = fopen (rc_name, "r");
	if (rc_file == NULL) {
		char *home = getenv("HOME");
		rc_name = (char *) malloc(strlen(home)+strlen(ALT_RC_NAME)+2);
#ifndef VMS
		sprintf(rc_name, "%s/%s", home, ALT_RC_NAME);
#else
		sprintf(rc_name, "%s%s", home, ALT_RC_NAME);
#endif
		rc_file = fopen (rc_name, "r");
		free(rc_name);
	}
	if (rc_file != NULL) {
		stat = ReadConfig(rc_file, rc_name);
		if (stat == STAT_END_CONFIG) {
			fprintf(stderr, "There should be only config instructions in config file %s\n", 
				rc_name);
		}
	} else {
		fprintf(stderr, "Maybe there should be a configuration file (%s)\n",
			rc_name);
	}

	stat = ReadConfig(input_file, file_name);

	if (debug) 
		fprintf (stderr, "Status from ReadConfig = %d\n", stat);

	FinishConfig();
}

void Work()
{
	while( STAT_EOF != DecodeBlock())
		;
}

void Fail(s)
char *s;
{
	fprintf(stderr, s);
	perror("");
	exit(1);
}
