/* hash.c : manages the (hashed) symbol table. */
/* This program has been written in 1/2 hour and doesn't claim to be
very efficient. */

#include <string.h>
#include <stdio.h>
#ifndef VMS
#include <malloc.h>
#endif
#include <memory.h>
#include "tabul.h"

/* from main.c */
void Fail();
extern int debug;

static int hash_size=0, hash_num=0;
struct entry { 
	char *key, *data; 
};
static struct entry *hash_table;
static unsigned int char_key[256];

static unsigned int hash_key (s) 
char *s;
{
	unsigned int key = 0;
	while (*s != (char) 0) {
		key += char_key[*s];
		s++;
	}
	return key;
}

void HashInit (size)
int size;
{
	int i;

	hash_size = size;
	hash_num = 0;
	hash_table = (struct entry *) malloc((unsigned int) size 
		* sizeof(struct entry));
	if (hash_table == NULL)
		Fail ("Could not allocate memory for symbol table.\n");
	memset (hash_table, 0, hash_size * sizeof(struct entry *));
	for (i = 0; i < 256; i++) 
#ifndef VMS
		char_key[i] = (unsigned int) lrand48();
#else
		char_key[i] = (unsigned int) rand();
#endif
}

void HashDump()
{
	int i;

	for (i = 0; i < hash_size; i++) {
		if (hash_table[i].key != NULL)
			fprintf (stderr, "hash[%d] = '%s' -> %x\n", i, hash_table[i].key+1, 
				(int) hash_table[i].data);
	}
}

void HashDestroy()
{
	free(hash_table);
}

/* Retrieve data from hashtable. */
char *HashGet(symbol, type)
char *symbol;
int type;
{
	struct entry *item;
	char buff[NAME_LENGTH+1];
	unsigned int index;

	buff[0] = (char) type;
	strcpy (buff + 1, symbol);
	index = hash_key(buff) % hash_size;
	while (1) {
		item = &hash_table[index];
		if (item->key == NULL)
			return NULL;
		if (!strcmp(item->key, buff)) {
			return item->data;
		}
		index++;
		index = index % hash_size;
	}
}

/* Put data in hash table. */
void HashPut(symbol, type, data)
char *symbol;
int type; 
char *data;
{
	struct entry *item;
	unsigned int index;
	char buff[NAME_LENGTH+1];

	buff[0] = (char) type;
	strcpy (buff + 1, symbol);
	
	index = hash_key(buff) % hash_size;
	while (1) {
		item = &hash_table[index];
		if (item->key == NULL) {
			item->key = strdup(buff);
			item->data = data;
			break;
		}
		index++;
		index = index % hash_size;
	}
	hash_num++;
}

void HashStat() 
{
	fprintf(stderr, "Symbol table : using %d symbols out of %d\n", hash_num,
		hash_size);
	if (debug)
		HashDump();
}
