/* control.c : deal with control commands like repeat... */
/* Copyright 1993 Stefane Fermigier. */

#include <stdio.h>
#include <string.h>
#include <strings.h>

#include "tabul.h"

/* from main.c */
extern int debug;
extern FILE *input_file;

static struct mark repeat_positions[MAX_DEPTH];
static depth = -1;

int Repeat (char list[MAX_TOK][NAME_LENGTH])
{
	int current_position = ftell (input_file);

	if ((depth < 0) || (repeat_positions[depth].offset != current_position)) {
		++depth;
		if (depth >= MAX_DEPTH) {
			fprintf (stderr, "Too much nested repeat...end\n");
			exit(0);
		}
		repeat_positions[depth].offset = current_position;
		repeat_positions[depth].repetition = atoi(list[1]);
	}
	return STAT_OK;
}

int End (char list[MAX_TOK][NAME_LENGTH])
{
	if (--repeat_positions[depth].repetition > 0)
		fseek (input_file, repeat_positions[depth].offset, 0);
	else 
		--depth;
	if (depth < -1) {
		fprintf (stderr, "Error, depth = %d, should be >= -1.\n", depth);
		exit(0);
	}
	return STAT_OK;
}

int Goto()
{
}

Label()
{
}

