 /*J  * This source code is a product of Sun Microsystems, Inc. and is providedK  * for unrestricted use.  Users may copy or modify this source code without 
  * charge.  *M  * SUN SOURCE CODE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING I  * THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR I  * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.   *L  * Sun source code is provided with no support and without any obligation onG  * the part of Sun Microsystems, Inc. to assist in its use, correction,   * modification or enhancement.   *E  * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE L  * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS SOFTWARE  * OR ANY PART THEREOF.   *I  * In no event will Sun Microsystems, Inc. be liable for any lost revenue K  * or profits or other special, indirect and consequential damages, even if ;  * Sun has been advised of the possibility of such damages.   *  * Sun Microsystems, Inc.   * 2550 Garcia Avenue #  * Mountain View, California  94043   */    /*	  * g721.c   *  * Description:   *!  * g721_encoder(), g721_decoder()   *E  * These routines comprise an implementation of the CCITT G.721 ADPCM F  * coding algorithm.  Essentially, this implementation is identical to>  * the bit level description except for a few deviations whichB  * take advantage of work station attributes, such as hardware 2'sF  * complement arithmetic and large memory.  Specifically, certain time<  * consuming operations such as multiplications are replaced@  * with lookup tables and software 2's complement operations are)  * replaced with hardware 2's complement.   *A  * The deviation from the bit level specification (lookup tables) 6  * preserves the bit level performance specifications.  *C  * As outlined in the G.721 Recommendation, the algorithm is broken @  * down into modules.  Each section of code below is preceded by3  * the name of the module which it is implementing.   *  */    #include "st.h"  #include "g72x.h"   ? static short qtab_721[7] = {-124, 80, 178, 246, 300, 349, 400};  /*D  * Maps G.721 code word to reconstructed scale factor normalized log  * magnitude values.  */ D static short	_dqlntab[16] = {-2048, 4, 135, 213, 273, 323, 373, 425,, 				425, 373, 323, 273, 213, 135, 4, -2048};  = /* Maps G.721 code word to log of scale factor multiplier. */ @ static short	_witab[16] = {-12, 18, 41, 64, 112, 198, 355, 1122,* 				1122, 355, 198, 112, 64, 41, 18, -12}; /*@  * Maps G.721 code words to a set of values whose long and shortE  * term averages are computed and then compared to give an indication /  * how stationary (steady state) the signal is.   */ F static short	_fitab[16] = {0, 0, 0, 0x200, 0x200, 0x200, 0x600, 0xE00,0 				0xE00, 0x600, 0x200, 0x200, 0x200, 0, 0, 0};   /*  * g721_encoder()   *K  * Encodes the input vale of linear PCM, A-law or u-law data sl and returns E  * the resulting code. -1 is returned for unknown input coding value.   */  int % g721_encoder(sl, in_coding,state_ptr) 	 	int		sl;  	int		in_coding; 	struct g72x_state *state_ptr; { # 	short		sezi, se, sez;		/* ACCUM */  	short		d;			/* SUBTA */ 	short		sr;			/* ADDB */ 	short		y;			/* MIX */ 	short		dqsez;			/* ADDC */  	short		dq, i;  @ 	switch (in_coding) {	/* linearize input sample to 14-bit PCM */ 	case AUDIO_ENCODING_ALAW: 		sl = alaw2linear(sl) >> 2; 		break; 	case AUDIO_ENCODING_ULAW: 		sl = ulaw2linear(sl) >> 2; 		break; 	case AUDIO_ENCODING_LINEAR:( 		sl >>= 2;			/* 14-bit dynamic range */ 		break;	 	default:  		return (-1); 	}  " 	sezi = predictor_zero(state_ptr); 	sez = sezi >> 1; E 	se = (sezi + predictor_pole(state_ptr)) >> 1;	/* estimated signal */   , 	d = sl - se;				/* estimation difference */  ) 	/* quantize the prediction difference */ 5 	y = step_size(state_ptr);		/* quantizer step size */ 6 	i = quantize(d, y, qtab_721, 7);	/* i = ADPCM code */  B 	dq = reconstruct(i & 8, _dqlntab[i], y);	/* quantized est diff */  D 	sr = (dq < 0) ? se - (dq & 0x3FFF) : se + dq;	/* reconst. signal */  5 	dqsez = sr + sez - se;			/* pole prediction diff. */   C 	update(4, y, _witab[i] << 5, _fitab[i], dq, sr, dqsez, state_ptr);    	return (i); }    /*  * g721_decoder()   *  * Description:   *6  * Decodes a 4-bit code of G.721 encoded data of i and:  * returns the resulting linear PCM, A-law or u-law value.*  * return -1 for unknown out_coding value.  */  int & g721_decoder(i, out_coding, state_ptr) 	int		i; 	int		out_coding;  	struct g72x_state *state_ptr; { ' 	short		sezi, sei, sez, se;	/* ACCUM */  	short		y;			/* MIX */ 	short		sr;			/* ADDB */ 	short		dq;  	short		dqsez;  + 	i &= 0x0f;			/* mask to get proper bits */ " 	sezi = predictor_zero(state_ptr); 	sez = sezi >> 1; ( 	sei = sezi + predictor_pole(state_ptr);- 	se = sei >> 1;			/* se = estimated signal */   < 	y = step_size(state_ptr);	/* dynamic quantizer step size */  B 	dq = reconstruct(i & 0x08, _dqlntab[i], y); /* quantized diff. */  F 	sr = (dq < 0) ? (se - (dq & 0x3FFF)) : se + dq;	/* reconst. signal */  5 	dqsez = sr - se + sez;			/* pole prediction diff. */   C 	update(4, y, _witab[i] << 5, _fitab[i], dq, sr, dqsez, state_ptr);    	switch (out_coding) { 	case AUDIO_ENCODING_ALAW:9 		return (tandem_adjust_alaw(sr, se, y, i, 8, qtab_721));  	case AUDIO_ENCODING_ULAW:9 		return (tandem_adjust_ulaw(sr, se, y, i, 8, qtab_721));  	case AUDIO_ENCODING_LINEAR:5 		return (sr << 2);	/* sr was 14-bit dynamic range */ 	 	default:  		return (-1); 	} } 