
/*  @(#)trans.c 1.1 93/12/26
 *
 *  Copyright (C) 1991 - Valerie Haecky.
 *  All rights reserved.
 * 
 *  Permission is granted to copy this source, for redistribution 
 *  in source form only, provided the news headers in "substantially 
 *  unaltered format" are retained, the introductory messages are not 
 *  removed, and no monies are exchanged. 
 * 
 *  Permission is also granted to copy this source, without the 
 *  news headers, for the purposes of making an executable copy by 
 *  means of compilation, provided that such copy will not be used 
 *  for the purposes of competition in any othello tournaments, without 
 *  prior permission from the authors. 
 * 
 *  No responsibility is taken for any errors on inaccuracies inherent 
 *  either to the comments or the code of this program, but if reported 
 *  (see README file), then an attempt will be made to fix them. 
 */ 
 
#include <stdio.h>
#include <sys/param.h>
#include <ctype.h>

#define FCLOSE  (void) fclose
#define FPRINTF (void) fprintf
#define PRINTF  (void) printf
#define PUTC    (void) putc
#define SPRINTF (void) sprintf

#define TRUE  1    
#define FALSE 0             

#define BLACK 0
#define WHITE 1
#define EMPTY ""

extern void exit() ;

#ifndef  PROLOGUE       /* Trans PostScript prologue file location. */
#define  PROLOGUE "/usr/local/lib"
#endif /*PROLOGUE*/

#ifndef  MAXPATHLEN
#define  MAXPATHLEN   1024
#endif /*MAXPATHLEN*/

FILE * gamefp;		/* File containing ASCII transcript */
FILE * trfp;		/* File for PostScript transcript */
FILE * psfp;		/* Template PostScript File */

int infile = FALSE;
int outfile = FALSE;

char * blackPlayer = EMPTY;
char * whitePlayer = EMPTY;
char * result = EMPTY;
char * date = EMPTY;
char * place = EMPTY;
char * comment = EMPTY;
char * gamename = "reve.game";
char * transname = "reve.trans.ps";
char * scale = "1";
char * ptime = EMPTY;


/* Copy the template file into the transcript file */
int
initTranscript()
{
   char c, tpsname[MAXPATHLEN];
   if (outfile)
   {
      if ((trfp = fopen(transname, "w")) == NULL)
      {
	 FPRINTF(stderr,"\n\tERROR:Destination file %s can't be opened\n", transname);
	 return(-1);
      }
   } else
   {
      trfp = stdout;
   }

   /* put the first things into the transcript file */
   PUTC('%', trfp);
   FPRINTF(trfp, "! \n\n");

   /* put the definitions into the transcript file */
   FPRINTF(trfp, "/Scale {%s %s} def \n", scale, scale);
   FPRINTF(trfp, "/BlackPlayer (%s) def \n", blackPlayer);
   FPRINTF(trfp, "/WhitePlayer (%s) def \n", whitePlayer);
   FPRINTF(trfp, "/Score (%s) def \n", result);
   FPRINTF(trfp, "/Date (%s) def \n", date);
   FPRINTF(trfp, "/Place (%s) def \n", place);
   FPRINTF(trfp, "/Time (%s) def \n", ptime);
   FPRINTF(trfp, "/Comments (%s) def \n\n", comment);

   /* copy the template into the transcript file */
   PUTC('%',trfp);
   FPRINTF(trfp, " --------- Start imported trans.ps --------\n\n");
   SPRINTF(tpsname, "%s/trans.ps", PROLOGUE);
   if ((psfp = fopen(tpsname, "r")) == NULL)
   {
      PRINTF ("\n\tERROR: File trans.ps not found.\n");
      return(-1);
   }
   while ((c = getc(psfp)) != EOF) PUTC(c,trfp); /* copy the template */
   FCLOSE(psfp);
   PUTC('%',trfp);
   FPRINTF(trfp, " --------- End imported trans.ps --------\n\n");
   return(0);
}

void
drawStone(move, square, color)
  int move, square, color;
{
  FPRINTF(trfp, "  %d %d %d drawStone \n", move, square, color);
}


void
endTranscript()
{
   /* write final grestore and showpage into transcript */ 
   FPRINTF(trfp, "grestore \n\n");
   FPRINTF(trfp, "showpage \n\n");
   FCLOSE(trfp);
}


/* This function interprets the gamefile. It is heavily dependend on
 * the current format of the gamefile. If that format changes, this
 * function needs to be rewritten (nothing else);
 */
void drawMoves()
{
    char   c;			/* Last character read from gamefp */
    int    move;		/* Number of current move */
    int    color;		/* Color of current move */
    int    square;		/* numerical value of square of move */

    
    while ((c = getc(gamefp)) != EOF) 
        {
        if (!isdigit(c))
            {
            while (c != '\n') c = getc(gamefp);
            }
        else
            {
            /* First we get the move number */
            /* First character is always a number */
            move = c - '0';

            /* Second character is a number or a coma. */
            if ((c = getc(gamefp)) != ',')
                {
                move = 10*move +  c - '0';
                c = getc(gamefp); /* get the coma */
                }
 
            /* next we have spaces */
            while ((c = getc(gamefp)) == ' ');
  
            /* now we get a '-' or a '<' */
            if (c  == '-')
                {
                color = WHITE;
                while ((c = getc(gamefp)) != '<');
                }
            else
                color = BLACK;
  
            /* next we read alpha-dash-number for square */
            /* convert the alpha to a number and ignore the dash */
            c = getc(gamefp);
            if (isupper(c))
                square = c - 'A' + 1; 
            else 
                square = c - 'a' + 1;
            c = getc(gamefp);
            c = getc(gamefp); 
            square = 10*square + c - '0';
  
            /* then read to EOL */
            while ((c = getc(gamefp)) != ']');
            c = getc(gamefp); 
  
            /* and draw the move */
            drawStone(move, square, color);
            }/*end else*/
        }/*end while*/
}


main(argc,argv)
    int		argc;
    char	**argv;
{
   /* interpret the command line arguments */

  if (argc != 1)
    {
    argv++;  /* point to the first argument */
    while (*argv != NULL)
      {  
      if (strcmp (*argv, "-b") == 0)
          {
          argv++;
          blackPlayer = *argv;
/*          FPRINTF(stderr,"Black: %s \n", blackPlayer); */
          }
      else if (strcmp (*argv, "-w") == 0)
          {
          argv++;
          whitePlayer = *argv;
         FPRINTF(stderr,"White: %s \n", whitePlayer);
          }
      else if (strcmp (*argv, "-r") == 0)
          {
          argv++;
          result = *argv;
         FPRINTF(stderr,"Result: %s \n", result);
          }
      else if (strcmp (*argv, "-d") == 0)
          {
          argv++;
          date = *argv;
         FPRINTF(stderr,"Date: %s \n", date);
          }
      else if (strcmp (*argv, "-c") == 0)
          {
          argv++;
          comment = *argv;
         FPRINTF(stderr,"Comment: %s \n", comment);
          }
      else if (strcmp (*argv, "-s") == 0)
          {
          argv++;
          scale = *argv;
         FPRINTF(stderr,"Scale Factor: %s \n", scale);
          }
      else if (strcmp (*argv, "-g") == 0)
          {
          argv++; infile = TRUE ;
          gamename = *argv;
         FPRINTF(stderr,"Game File: %s \n", gamename);
          }
      else if (strcmp (*argv, "-l") == 0)
          {
          argv++;
          ptime = *argv;
         FPRINTF(stderr,"Time Limit: %s \n", ptime);
          }
      else if (strcmp (*argv, "-p") == 0)
          {
          argv++;
          place = *argv;
         FPRINTF(stderr,"Place: %s \n", place);
          }
      else if (strcmp (*argv, "-t") == 0)
          {
          argv++; outfile = TRUE ;
          transname = *argv;
         FPRINTF(stderr,"Transcript File: %s \n", transname);
          }
      else if (strcmp (*argv, "-h") == 0)
          {
         FPRINTF(stderr,"\n\tUseage: trans [options|-h] \n\n");
         FPRINTF(stderr,"\tOptions:\n\n");
         FPRINTF(stderr,"\t  -b string   black player \n");
         FPRINTF(stderr,"\t  -w string   white player \n");
         FPRINTF(stderr,"\t  -r string   result/score \n");
         FPRINTF(stderr,"\t  -d string   date \n");
         FPRINTF(stderr,"\t  -c string   comment \n");
         FPRINTF(stderr,"\t  -g string   game file path \n");
         FPRINTF(stderr,"\t  -t string   transcript file path \n");
         FPRINTF(stderr,"\t  -s string   scaling factor for transcript \n");
         FPRINTF(stderr,"\t  -p string   place or occasion \n");
         FPRINTF(stderr,"\t  -l string   time limit \n");
         FPRINTF(stderr,"\t  -h          display this help mesg \n\n");
         FPRINTF(stderr," To print your transcript, send the transcript \n");
         FPRINTF(stderr," file to any PostScript printer. \n\n");
         FPRINTF(stderr," For more help, read the README file. \n\n");
          return(3);
          }
      else
          {
         FPRINTF(stderr,"ERROR: Invalid argument list.\n");
         FPRINTF(stderr,"       Type 'trans -h' for help \n\n");
          return(4);
          }
      argv++;
      }/*endwhile*/
    }/*endif*/

    /* open the appropriate files for reading and writing */
    if (infile)
    {
    
    if ((gamefp = fopen(gamename, "r")) == NULL) 
        {
       FPRINTF(stderr,"\n\tERROR: Source file %s cannot be opened\n", gamename);
        return(5);
        }
    } else
    {
	gamefp = stdin ;
    }

    if (initTranscript() != 0) return(-1);
    drawMoves();
    endTranscript();

    FCLOSE(gamefp);
    exit(0);
/*NOTREACHED*/
}
