
/*  @(#)reve_proc.c 1.2 94/01/20
 *
 *  Main routine for the separate play_reve program.
 *
 *  Copyright (C) 1990 - 1994 - Rich Burridge & Yves Gallot.
 *  All rights reserved.
 *
 *  Permission is granted to copy this source, for redistribution
 *  in source form only, provided the news headers in "substantially
 *  unaltered format" are retained, the introductory messages are not
 *  removed, and no monies are exchanged.
 *
 *  Permission is also granted to copy this source, without the
 *  news headers, for the purposes of making an executable copy by
 *  means of compilation, provided that such copy will not be used
 *  for the purposes of competition in any othello tournaments, without
 *  prior permission from the authors.
 *
 *  No responsibility is taken for any errors on inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file), then an attempt will be made to fix them.
 */

#include "reve.h"

struct reve_in in ;          /* Input supplied on standard input. */
struct reve_out out ;        /* Results written to standard output. */

int sbufn ;                  /* Size of the input buffer. */

char progname[MAXLINE] ;     /* The name of this program. */
time_t savetime ;            /* Restore correct time after a suggestion. */

CVars c ;                    /* REVE global variables */

#ifdef HASREVEPROC

FILE *find_file      (char *) ;

int main             (int, char **) ;

void get_options     (int, char **) ;
void getparam        (char *, char **, char *) ;
void init_edge_table (char *) ;
void show_best       (int, long) ;


/*ARGSUSED*/
int
main(argc, argv)
int argc ;
char *argv[] ;
{
  int reply ;

  c = (CVars) LINT_CAST(calloc(1, sizeof(CompVars))) ;
  c->max_depth = 2 ;               /* Computer strategy - maximum depth. */
  STRCPY(progname, argv[0]) ;   /* Save program name for later use. */
  get_options(argc, argv) ;     /* Extract command line options. */
  for (;;)
    {
      sbufn = sizeof(struct reve_in) ;
      if ((reply = read(0, (char *) &in, sbufn)) > 0)
        {
               if (in.type == M_TIME)    c->timeleft  = in.timeleft ;
          else if (in.type == M_PROFMAX) c->max_depth = in.level ;
          else
            {
              if (in.type == M_SUGGESTION) savetime = c->timeleft ;
              play_reve(in.board, in.player, in.level,
                        &out.move, (long *) &out.note) ;
              out.type = in.type ;
              WRITE(1, (char *) &out, sizeof(struct reve_out)) ;
              if (in.type == M_SUGGESTION) c->timeleft = savetime ; 
            }
        }
      else if (reply == 0) exit(1) ;
    }
}


void
get_options(argc, argv)
int argc ;
char *argv[] ;
{
  INC ;
  while (argc > 0)
    {
      if (argv[0][0] == '-')
        switch (argv[0][1])
          {
            case 'd' : if (EQUAL(argv[0], "-debug")) c->debug = TRUE ;
                       break ;
            case 'e' : INC ;
                       getparam(c->edgefile, argv, "-e needs an edgetable file") ;
                       init_edge_table(c->edgefile) ;
                       break ;
            case 'l' : if (EQUAL(argv[0], "-log")) c->saveres = TRUE ;
          }
      INC ;
    }
}


void
getparam(s, argv, errmes)
char *s, *argv[], *errmes ;
{
  if (*argv != NULL && argv[0][0] != '-') STRCPY(s, *argv) ;
  else
    { 
      FPRINTF(stderr,"%s: %s as next argument.\n", progname, errmes) ;
      exit(1) ;
    }
}
#else
/*ARGSUSED*/
main(argc, argv)
int argc ;
char *argv[] ;
{
  FPRINTF(stderr, "%s: no separate computer process enabled.\n", argv[0]) ;
}
#endif /*HASREVEPROC*/


void
show_best(move, note)
int move ;
long note ;
{
  out.type  = M_BEST ;
  out.move  = move ;
  out.note  = note ;
  out.depth = c->profmax ;
  WRITE(1, (char *) &out, sizeof(struct reve_out)) ;
}
