.\" @(#)reve.man 1.15 91/11/13
.TH REVE 6 "13 November 1991"
.SH NAME
reve \- an othello game.
.SH SYNOPSIS
.B "reve
[
.B \-animate
] [
.B \-bestmove
] [
.B \-black
] [
.B \-clock
] [
.B \-d
.I difficulty
] [
.B \-e
.I edgefile
] [
.B \-g
.I geometry
] [
.B \-h
.I helpfile
] [
.B \-help
] [
.B \-i
] [
.B \-last
] [
.B \-load
.I gamefile
] [
.B \-log
] [
.B \-m
] [
.B \-notes
] [
.B \-number
] [
.B \-opponent
.I user@host
] [
.B \-props
] [
.B \-quick
] [
.B \-r
.I reve_proc
] [
.B \-v
] [
.B \-white
] [
.B \-?
] [
.B \-Wi
] [
.B \-Wp
.I x y
] [
.B \-WP
.I x y
]
.SH DESCRIPTION
.I Reve
is a version of the popular Othello game. It contains graphical interfaces
for SunView, X11 and XView, as well as being able to function on
normal display terminals using a termcap interface.
.LP
Reve is played on an 8 x 8 board, with stones which should be considered to
be black on one side and white on the other. A legal move consists of placing
a stone of one's own color on the board so as to "sandwich" one or more rows
(orthogonal or diagonal) of stones of the opposite color between the stone
just placed and another stone of the same color. All stones so sandwiched are
flipped over to reveal the color of the other side (your own color).
.LP
The object of the game, is to have more stones than the opponent at
the end of the game (ie. when the board is full or neither side has
a legal move). If you have no legal move, you simply miss a turn.
Black goes first.
.LP
With
.I reve,
to place one of your own stones simply click with the mouse over the
square in which you want your stone to go. Note that it is also possible
to supply a number and a letter pair, to indicate where you would like your
new stone to go. This is the only method to place stones with the dumb tty
interface. The square containing the last move will be shown with a black
outline. This is updated with each new move. If you hold the mouse button
down as you move around the board, the square you are currently over will
be highlighted.
.LP
There are various buttons, choice, toggles and cyclic selections available.
Their meanings are given below, plus an indication of their keyboard
equivalents. With the cyclic selections, clicking over the left half of the
cycle item increments the selection, and clicking over the right half of the
cycle item decrements the selection. Control-l is a keyboard accelerator
for redrawing the
.I reve
windows.
.LP
By default, a human will play black, and the computer will play white. If
you want a human vs human startup or some other combination, then you should
use the appropriate command line options (see below).
.SH REVE BUTTONS
.LP
With the graphics versions, there are ten buttons that are normally
displayed at the top of the 
.I reve
window. Each of these buttons, has a keyboard equivalent which is given in
brackets below. Note that the XView version has a slightly different
appearance, but it should be easy to deduce what each option does.
.LP
.IP "\fBload [ L ]\fP" 18
Load a game file. The format of this game file is given below. With the
graphical versions, a text field is displayed between the \fBdone\fP and
\fBquit\fP buttons for you to enter the filename of this game file. Clicking
over the \fBcancel\fP button or pressing the Escape key will cancel the
load operation. When you press the Return key, filename entry is complete,
and the program will try to load this file. If it's unsuccessful, it will
stop on the invalid line, and display an error message. As each line is
successfully read from the game file, the stone is displayed on the board,
and the appropriate stones flipped.
.IP "\fBmoves? [ A ]\fP" 18
Show all the valid moves for the current board. This is useful for beginners,
and for teaching purposes.
.IP "\fBnew game [ n ]\fP" 18
Start a new game of
.I reve
.IP "\fBhelp [ H ]\fP" 18
Display a window containing the online
.I reve
help information. A cycle at the top of this window allows you to page
through this file.
.IP "\fBredo [ r ]\fP" 18
Redo the last "move". If the opponent is the computer, then two "moves" are
redone. A "move" is considered to be all consecutive moves by the opponent.
To redo a move, you must have undone a move.
.IP "\fBprops [ p ]\fP" 18
Display a property sheet containing choices and toggles which will
alter various \fIreve\fP properties.
.IP "\fBsave [ S ]\fP" 18
Save the current game to file. See the entry for the \fBload\fP button
above for details of how to enter the filename.
.IP "\fBsuggest [ s ]\fP" 18
Let the computer suggest a good move for you. This move will be dependent
upon the current level of difficulty set.
.IP "\fBprint [ P ]\fP" 18
Print the current game to a PostScript printer. The default print command is
"trans | lpr", but this can be over-ridden for the X11 and XView versions
with an X resource (see below).
.IP "\fBundo [ u ]\fP" 18
Undo the last "move". If the opponent is the computer, then two "moves" are
undone. A "move" is considered to be all previous consecutive moves by
the opponent.
.IP "\fBquit [ q ]\fP" 18
Exit the
.I reve
program.
.SH REVE PROPERTY SHEET SELECTIONS
With the graphical versions, there is a property sheet window which can be
displayed. The property sheet has two choice items, one cyclic item, and six
toggle items. Click with the left mouse button over the option you want from
the choice items. With the cyclic items, click with the left mouse button over
the appropriate half, to either increment or decrement the current value.
Clicking left over the toggle item boxes, will toggle the value of that item
on or off.
The choice and toggle items also have keyboard equivalents which are given in
brackets below. The choice items must be followed by the value of the new
selection you wish to make. The dumb tty version has the equivalent of these
items displayed to the right of the reve board display.
.LP
.IP "\fBComputer plays: [ C ]\fP" 18
A choice item which selects what color[s] the computer should play. The
keyboard equivalents are 'b' for black, 'w' for white, 'n' for neither,
and 'a' for all (both).
.IP "\fBDifficulty: [ D ]\fP" 18
A choice item which sets the degree of difficulty for the computers moves.
Keyboard selection values are in the range '1' to '9'. The computer move is
determined on a time basis. The degree of difficulty determines the total
amount of time that the computer will take to make all its moves. Here are the
time periods for each level of difficulty:
.LP
	Difficulty	Time
.LP
	1		Time allocation disabled (fast simple move).
.br
	2		1 minutes.
.br
	3		3 minutes.
.br
	4		5 minutes.
.br
	5		10 minutes.
.br
	6		15 minutes.
.br
	7		20 minutes.
.br
	8		30 minutes.
.br
	9		60 minutes.
.LP
Level eight is tournament level.
.IP "\fBSet search depth: [ No keyboard equivalent ]\fP" 18
A cyclic item which sets the maximum search depth for each and every computer
move. By default this option is turned off, and the computer uses a clock to
time it's moves. Depending on where in the game you are, the search depth
usually varies by one or two plys. Turning on this option disables the clock.
.IP "\fBAnimate move option. [ O followed by a or A ]\fP" 18
A toggle item for animating the computer move and the dragging of human pieces.
.IP "\fBShow current best move option. [ O followed by b or B ]\fP" 18
A toggle item for showing the current best move as the computer makes it's
move.
.IP "\fBShow last move option. [ O followed by l or L ]\fP" 18
A toggle item for outlining the square containing the last move.
.IP "\fBShow evaluation information option. [ O followed by e or E ]\fP" 18
A toggle item for displaying evaluation information for each computer
move. In short, a positive number indicates a good move for the computer, and
a negative number is good for the opponent. The evaluation information also
includes the depth to which the computer searched for it's move. If that depth
value is negative, it indicates the search was not completed at that depth,
due to the timer expiring.
.IP "\fBNumber last move option. [ O followed by n or N ]\fP" 18
A toggle item for number the last move stone.
.IP "\fBDon't show flip option. [ O followed by f or F ]\fP" 18
A toggle item to prevent the flip of the stones as a turn is completed.
.IP "\fBInvalid move shows legal moves option. [ O followed by m or M ]\fP" 18
A toggle item which will show all the possible legal moves if the user makes
an invalid move.
.IP "\fBUse Clocks to Time Moves. [ O followed by c or C ]\fP" 18
A toggle item to display timer clocks for each player. If timer clocks are
shown, then each player is allowed a certain amount of time to play all their
moves. This amount of time depends on the current level of difficulty.
.SH OPTIONS
.TP
.B \-animate
Show animation. The computer's stone will glide in from the top left
corner of the board, and when you hold the left mouse button down, your
stone is dragged around.
.TP
.B \-bestmove
As the computer is making it's move, continually show the position of the
best move found so far.
.TP
.B \-black
Black will be played by a human.
.TP
.B \-clock
Display clocks to time each move. A total amount of time is allowed for each
player depending upon the level of difficulty. When that time has expired, then
the game is over.
.TP
.BI \-d " difficulty"
The level of difficulty for computer moves. See the \fBDifficulty:\fP
cyclic item description above for more information.
.TP
.BI \-e " edgefile"
Specify an alternate location for the
.I reve
edge stability table file. Normally the location of this file is compiled
in when the program is created, but
.I reve
will search every directory on your search path looking file a file called
.I reve.edgetable.
.TP
.BI \-g " geometry"
Used with the X11 variant of
.I reve
to give geometry information.
.TP
.BI \-h " helpfile"
Specify an alternate location for the
.I reve
online help file. Normally the location of this file is compiled
in when the program is created, but
.I reve
will search every directory on your search path looking file a file called
.I reve.help.
.TP
.B \-help
Initially show the
.I reve
help window.
.TP
.B \-i
Invert the reve window before displaying it. For use by people who
started their graphics environment in inverse mode. This option is
currently only implemented for the SunView version.
.TP
.B \-last
Show where the last stone was placed, by outlining the square.
.TP
.BI \-load " gamefile"
Load a game file. The format of this game file is given below. The board
will be setup with these stones.
.TP
.B \-log
Save a log of computer move information to the file
.I reve.res
as the game progresses. This information is probably only useful to
people trying to improve the computer algorithm.
.TP
.B \-m
Always display in monochrome, even on a color screen.
.TP
.B \-notes
Display computer notes.
.TP
.B \-number
Show the move number on the last stone placed.
.TP
.BI \-opponent " user@host"
Play a game against another human on another networked machine.
.I Reve
will send an invitation to that person asking if the want to play, and they
will then invoke
.I reve
on their machine (using your username and hostname), and the connection is
established. Note that both machines need to have the
.I reve
network daemon configured. See the README file for information on how to do
this.
.TP
.B \-props
Initially show the
.I reve
property window.
.TP
.B \-quick
Play a quick game. Don't flash the stones as they are being turned.
.TP
.BI \-r " reve_proc"
Full pathname of the computer strategy
.I reve_proc
program.
.TP
.B \-?
Print the version number and usage message for this release of the
.I reve
program.
.TP
.B \-v
Print the version number and usage message for this release of the
.I reve
program.
.TP
.BI \-white
White will be played by a human.
.TP
.B \-Wi
Start the
.I reve
program up in iconic form. The SunView and XView version of
.I reve
will automatically uses this flag, but the X11 version will also.
.TP
.BI \-Wp " x y"
Start the open window position at
.I x y
.TP
.BI \-WP " x y"
Start the icon position at
.I x y
.SH RESOURCES
On startup, the X11 and XView version of
.I reve
will use the following X resources. These resources can be placed in all the
normal X places. You can also set a
.I REVEDEFAULTS
environment variable to
point to a file containing them, or place them in a
.I .reverc
file in your home directory.
.TP 15
.PD 0
.B Resource:
reve.animate
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether various animation effects are shown.
.sp
.TP
.B Resource:
reve.bestmove
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether to continually show the best move so far, as the computer
is making it's move.
.sp
.TP
.B Resource:
reve.boardSize
.TP
.B Values:
Board size (numeric)
.TP
.B Description
The initial size in pixels of the reve game board.
.sp
.TP
.B Resource:
reve.difficulty
.TP
.B Values:
Difficulty value (numeric)
.TP
.B Description
The computer difficulty level.
.sp
.TP
.B Resource:
reve.last
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether the position of the last stone placed is shown by a square.
.sp
.TP
.B Resource:
reve.log
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether to save a log of computer information to the file
.I reve.res/
.sp
.TP
.B Resource:
reve.notes
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether todisplay computer notes.
.sp
.TP
.B Resource:
reve.number
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether the last stone placed in numbered.
.sp
.TP
.B Resource:
reve.quick
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether a quick game should be played. Stones are not flashed as
they are placed, if this resource is set true.
.sp
.TP
.B Resource:
reve.properties
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether the properties window is initially displayed.
.sp
.TP
.B Resource:
reve.showClocks
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether timer clocks for each player are initially displayed.
.TP
.B Resource:
reve.showHelp
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether the online help window is initially displayed.
.sp
.TP
.B Resource:
reve.showLegalMoves
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether an invalid move should show all legal moves.
.sp
.TP
.B Resource:
reve.iconiseForOpponentMove
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether the reve window should be closed during the opponents move.
.sp
.TP
.B Resource:
reve.bellAfterOpponentMove
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether there should be a beep sounded after the opponents move.
.sp
.TP
.B Resource:
reve.raiseAfterOpponentMove
.TP
.B Values:
True, False (False)
.TP
.B Description
Indicates whether the reve window should be automatically raised to the top
after the opponents move.
.sp
.TP
.B Resource:
reve.panelColor
.TP
.B Values:
Color name string or hexadecimal color specification string
.TP
.B Description
The background color of the main and property panels.
.sp
.TP
.B Resource:
reve.boardColor
.TP
.B Values:
Color name string or hexadecimal color specification string
.TP
.B Description
The color of the reve playing board.
.sp
.TP
.B Resource:
reve.boardBorderColor
.TP
.B Values:
Color name string or hexadecimal color specification string
.TP
.B Description
The border color of the reve playing board.
.sp
.TP
.B Resource:
reve.gridColor
.TP
.B Values:
Color name string or hexadecimal color specification string
.TP
.B Description
The color of the grid lines on the reve playing board.
.sp
.TP
.B Resource:
reve.textColor
.TP
.B Values:
Color name string or hexadecimal color specification string
.TP
.B Description
The color of all text panel text items.
.sp
.TP
.B Resource:
reve.itemColor
.TP
.B Values:
Color name string or hexadecimal color specification string
.TP
.B Description
The background color of the button and cycle items.
.sp
.TP
.B Resource:
reve.blackStoneColor
.TP
.B Values:
Color name string or hexadecimal color specification string
.TP
.B Description
The color of the "black" stones.
.sp
.TP
.B Resource:
reve.whiteStoneColor
.TP
.B Values:
Color name string or hexadecimal color specification string
.TP
.B Description
The color of the "white" stones.
.sp
.TP
.B Resource:
reve.blackStoneName
.TP
.B Values:
Black stone name string
.TP
.B Description
The name to be displayed in all "black" stone messages.
.sp
.TP
.B Resource:
reve.whiteStoneName
.TP
.B Values:
White stone name string.
.TP
.B Description
The name to be displayed in all "white" stone messages.
.sp
.TP   
.B Resource:
reve.printCommand
.TP   
.B Values:
Print command string
.TP   
.B Description
The print command to use to print reve game transcripts.
.sp
.TP
.B Resource:
reve.boardFont
.TP
.B Values:
Font name string
.TP
.B Description
The name of the font used to display text on the reve game board.
.sp
.TP
.B Resource:
reve.boldFont
.TP
.B Values:
Font name string
.TP
.B Description
The name of the font used to display bold text.
.sp
.TP
.B Resource:
reve.helpFont
.TP
.B Values:
Font name string
.TP
.B Description
The name of the font used to display the online help information.
.sp
.TP
.B Resource:
reve.normalFont
.TP
.B Values:
Font name string
.TP
.B Description
The name of the font used to display normal text.
.sp
.SH REVE GAMES FILE FORMAT
.I Reve
has the ability to load or save games. The format of the games files are:
.LP
	1,	<C-4>	-	[ remarks field ]
.br
	2,	-	<E-3>	[ remarks field ]
.LP
There is one move per line. Lines starting with a '#' and blank lines
are ignored. The first field of each line is the move number. This will
be present before the comma. It is used as a consistency check. Next are
the black and white fields. If the '<' character is present before the
'-' character, then this is a move for black, otherwise it's a move for
white. The three characters between the '<' and '>' are the move, and
give the column and row. The column letter can be in either lower or
upper case.
.LP
It is possible for one player to have two or more consequentive moves, hence
the need for the above scheme.
.I Reve
is flexible about white space (except between the '<' and '>' characters).
The remarks field is ignored. The program will stop on the first line it
thinks is in error, and display the reason for this. As valid lines are
read from a game file, the board is updated.
.SH FILES
.TP
.B /usr/local/lib/reve.edgetable
.TP
.B /usr/local/lib/reve.help
.TP
.B ~/.reverc
edge stability table for all possible edge combinations.
.TP
.B /etc/services
.TP
.B /etc/inetd.conf
.SH BUGS
See the TODO file for the list of known problems.
.SH AUTHORS
.br
Computer strategy:	Yves Gallot	(no net address at present).
.br
Graphics interface:	Rich Burridge	richb@Aus.Sun.COM
