
/*  @(#)xdefs.h 1.3 94/01/27
 *
 *  Xlib/Motif definitions used by the reve program.
 *
 *  Copyright (C) 1990 - 1994 - Rich Burridge & Yves Gallot.
 *  All rights reserved.
 *
 *  Permission is granted to copy this source, for redistribution
 *  in source form only, provided the news headers in "substantially
 *  unaltered format" are retained, the introductory messages are not
 *  removed, and no monies are exchanged.
 *
 *  Permission is also granted to copy this source, without the
 *  news headers, for the purposes of making an executable copy by
 *  means of compilation, provided that such copy will not be used
 *  for the purposes of competition in any othello tournaments, without
 *  prior permission from the authors.
 *
 *  No responsibility is taken for any errors on inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file), then an attempt will be made to fix them.
 */

#include <X11/Intrinsic.h>

typedef struct Xobject {             /* Motif/Xlib graphics object. */
  Cursor hour_cur ;                  /* Hourglass cursor. */
  Cursor normal_cur ;                /* Normal screen cursor. */
  Display *dpy ;
  GC gc ;                            /* Graphics context for screen images. */
  GC igc ;                           /* Graphics context for 1bit images. */
  GC ropgc ;                         /* Graphics context for rops */
  int depth ;                        /* Depth of the screen in pixels. */
  int font_height ;                  /* Height in pixels of text font. */
  int screen ;
  Pixel black ;                      /* Black pixel. */
  Pixel brown ;                      /* Brown pixel. */
  Pixel white ;                      /* White pixel. */
  Pixmap icon ;                      /* Reve icon image. */
  Pixmap move_bm ;                   /* Special move symbol image. */
  Pixmap suggest_bm ;                /* Special suggest symbol image. */
  Pixmap squares[BOARD_SIZE*BOARD_SIZE] ;
  unsigned long backgnd ;            /* Default background color. */
  unsigned long foregnd ;            /* Default foreground color. */
  unsigned long gc_mask ;            /* Mask for setting GC values. */
  Widget *dwarr ;                    /* Difficulty frame widgets. */
  Widget *hwarr ;                    /* Help frame widgets. */
  Widget *lwarr ;                    /* Load frame widgets. */
  Widget *pwarr ;                    /* Computer plays frame widgets. */
  Widget *warr ;                     /* Reve main frame widgets. */
  Widget *swarr ;                    /* Save frame widgets. */
  Window root ;
  XFontStruct *font ;                /* Default font for labeling pieces. */
  XGCValues gc_val ;                 /* Used to setup GC values. */
  XrmDatabase reve_DB ;              /* Combined resources database. */
} XObject ;

typedef struct Xobject *XVars ;

extern int  get_bool_value          (Widget) ;
extern int  get_excl_value          (Widget) ;
extern int  get_int_value           (Widget) ;

extern void add_delete_callback    (Widget) ;
extern void do_show_help           (enum help_type) ;
extern void load_help_file         () ;
extern void set_clocks_visible     () ;
extern void set_excl_value         (Widget) ;
extern void show_popup             (Widget) ;
