
/*  @(#)callbacks.c 1.3 94/01/27
 *
 *  Callbacks needed for the reve program.
 *
 *  Copyright (C) 1990 - 1994 - Rich Burridge & Yves Gallot.
 *  All rights reserved.
 *
 *  Permission is granted to copy this source, for redistribution
 *  in source form only, provided the news headers in "substantially
 *  unaltered format" are retained, the introductory messages are not
 *  removed, and no monies are exchanged.
 *
 *  Permission is also granted to copy this source, without the
 *  news headers, for the purposes of making an executable copy by
 *  means of compilation, provided that such copy will not be used
 *  for the purposes of competition in any othello tournaments, without
 *  prior permission from the authors.
 *
 *  No responsibility is taken for any errors inherent either
 *  to the comments or the code of this program, but if reported
 *  (see README file), then an attempt will be made to fix them.
 */

#include <signal.h>
#include "reve.h"
#include "widgetindex.h"
#include "xdefs.h"
#include <Xm/Text.h>

#ifdef VMS
#define PCLOSE fclose
#define popen  fopen
#endif

extern CVars c ;              /* REVE/reve_proc global variables */
extern Vars v ;               /* Reve variables and options. */
extern XVars X ;              /* X11/Motif variables. */

void do_startup(void) ;


void
Clocks(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  v->do_clock = !v->do_clock ;
  set_clocks_visible(v->do_clock) ;
}


void
ComputerPlay(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  Widget cp ;

  if (!X->pwarr)
    {
      tu_plays_frame_widget("plays", X->warr[WI_MAIN_FRAME], &X->pwarr) ;
      add_delete_callback(X->pwarr[WI_PLAYS_FRAME]) ;
           if (v->cp_value == CP_WHITE)   cp = X->pwarr[WI_WHITE] ;
      else if (v->cp_value == CP_BLACK)   cp = X->pwarr[WI_BLACK] ;
      else if (v->cp_value == CP_NEITHER) cp = X->pwarr[WI_NEITHER] ;
      else if (v->cp_value == CP_BOTH)    cp = X->pwarr[WI_BOTH] ;
      set_excl_value(cp) ;
    }
  show_popup(X->pwarr[WI_PLAYS_FRAME]) ;
}


void
Current(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  v->do_bestmove = !v->do_bestmove ;
}


void
Difficulty(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  char name[MAXLINE] ;
  Widget diff ;

  if (!X->dwarr)
    {
      tu_difficulty_frame_widget("difficulty", X->warr[WI_MAIN_FRAME],
                                 &X->dwarr) ;
      add_delete_callback(X->dwarr[WI_DIFFICULTY_FRAME]) ;
      SPRINTF(name, "diff%1d", v->level) ;
      diff = XtNameToWidget(X->dwarr[WI_DIFF_CHOICE], name) ;
      set_excl_value(diff) ;
      XtUnmapWidget(X->dwarr[WI_DEPTH_LABEL]) ;
      XtUnmapWidget(X->dwarr[WI_DEPTH]) ;
    } 
  show_popup(X->dwarr[WI_DIFFICULTY_FRAME]) ;
}


void
DifficultyApply(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  int depth ;

  v->level = get_excl_value(X->dwarr[WI_DIFF_CHOICE]) + 1 ;
  if (get_bool_value(X->dwarr[WI_DEPTH_TOGGLE]))
    {
      depth = get_int_value(X->dwarr[WI_DEPTH]) ;
      v->level = 1 ;
      if (depth > 0 && depth < MAX_PROFMAX) c->max_depth = depth ;
    }
  else c->max_depth = 2 ;
  FPRINTF(stderr, "level is now %d max_depth is %d\n",
          v->level, c->max_depth) ;
}


void
DismissFrame(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  XtUnmapWidget(XtParent(XtParent(widget))) ;
  XtUnmanageChild(XtParent(XtParent(widget))) ;
}


void
Evaluation(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  v->show_notes = !v->show_notes ;
  if (!v->show_notes) message(M_EVAL, "") ;
}


void
ExitGame(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  if (v->pid) KILL(v->pid, SIGKILL) ;
  exit(0) ;
}


void
HelpDesc(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  do_show_help(H_DESC) ;
}


void
HelpFiles(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  do_show_help(H_FILE) ;
}


void
HelpForm(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  do_show_help(H_FORM) ;
}


void
HelpOpt(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  do_show_help(H_OPT) ;
}


void
HelpRes(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  do_show_help(H_RES) ;
}


void
Invalid(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  v->show_legal = !v->show_legal ;
}


void
Last(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  int n ;

  v->do_last = !v->do_last ;
  n = 63 - v->board.moves_left ;
  show_last(v->moves[n].move, v->do_last) ;
}


void
LoadApply(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  STRCPY(v->gamefile, XmTextGetString(X->lwarr[WI_LOAD_FILENAME])) ;
  load_game() ;
}


void
LoadGame(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  if (!X->lwarr)
    {
      tu_load_frame_widget("load", X->warr[WI_MAIN_FRAME], &X->lwarr) ;
      add_delete_callback(X->lwarr[WI_LOAD_FRAME]) ;
    }
  show_popup(X->lwarr[WI_LOAD_FRAME]) ;
}


void
MakeMove(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  char col, name[MAXLINE], row ;

  STRCPY(name, XtName(widget)) ;
  SSCANF(name, "%c%c", &col, &row) ;
  v->move = (row - '1')*BOARD_SIZE + (col - 'a') ;
  update_clock(v->next_player, 1) ;
  make_move() ;
}


void
NewGame(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  initboard() ;
  v->last_move = -1 ;
  if (v->black_plays == COMPUTER) v->first_move = 1 ;
  init_clocks() ;
  paint_all() ;
  message(M_EVAL, "") ;
  message(M_PANEL, "Use left mouse button to move") ;
}


void
Number(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  int n ;

  v->do_number = !v->do_number ;
  n = 63 - v->board.moves_left ;
  if (v->board.moves_left < 60)
    show_number(v->moves[n].move, 60 - v->board.moves_left, v->do_number) ;
}


void
PlayApply(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
       if (get_bool_value(X->pwarr[WI_WHITE]))   v->cp_value = CP_WHITE ;
  else if (get_bool_value(X->pwarr[WI_BLACK]))   v->cp_value = CP_BLACK ;
  else if (get_bool_value(X->pwarr[WI_NEITHER])) v->cp_value = CP_NEITHER ;
  else if (get_bool_value(X->pwarr[WI_BOTH]))
    {
      message(M_PANEL, "Computer plays both is not implemented yet.") ;
      return ;
    }
  set_computer(v->cp_value) ;
}


void
PrintGame(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  char buf[MAXLINE] ;
  FILE *fp ;

  if ((fp = popen(v->printcommand, "w")) == NULL)
    {
      SPRINTF(buf, "Couldn't open printer: %s", v->printcommand) ;
      message(M_PANEL, buf) ;
      return ;
    }
  save_game_to(fp) ;
  PCLOSE(fp) ;
  SPRINTF(buf, "Current game printed on %s", v->printcommand) ;
  message(M_PANEL, buf) ;
}


void
Redo(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  redo() ;
}


void
SaveApply(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  STRCPY(v->gamefile, XmTextGetString(X->swarr[WI_SAVE_FILENAME])) ;
  save_game() ;
}


void
SaveGame(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  if (!X->swarr)
    {
      tu_save_frame_widget("save", X->warr[WI_MAIN_FRAME], &X->swarr) ;
      add_delete_callback(X->swarr[WI_SAVE_FRAME]) ;
    }
  show_popup(X->swarr[WI_SAVE_FRAME]) ;
}


void
SearchDepth(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  Boolean value ;

  XtVaGetValues(widget, XmNset, &value, 0) ;
  if (value)
    {
      XtMapWidget(X->dwarr[WI_DEPTH_LABEL]) ;
      XtMapWidget(X->dwarr[WI_DEPTH]) ;
    }
  else
    {
      XtUnmapWidget(X->dwarr[WI_DEPTH_LABEL]) ;
      XtUnmapWidget(X->dwarr[WI_DEPTH]) ;
    }
}


void
ShowAll(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  show_all_moves() ;
}


void
Suggest(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  suggest() ;
}


int
startup()
{
  do_startup() ;
  return(0) ;
}


void
Undo(Widget widget, tu_ccb_arg_p args, XtPointer data)
{
  undo() ;
}
