
/*  @(#)reve.h 1.3 94/01/27
 *
 *  Definitions used by the reve program.
 *
 *  Copyright (C) 1990 - 1994 - Rich Burridge & Yves Gallot.
 *  All rights reserved.
 *
 *  Permission is granted to copy this source, for redistribution
 *  in source form only, provided the news headers in "substantially
 *  unaltered format" are retained, the introductory messages are not
 *  removed, and no monies are exchanged.
 *
 *  Permission is also granted to copy this source, without the
 *  news headers, for the purposes of making an executable copy by
 *  means of compilation, provided that such copy will not be used
 *  for the purposes of competition in any othello tournaments, without
 *  prior permission from the authors.
 *
 *  No responsibility is taken for any errors on inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file), then an attempt will be made to fix them.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#ifdef SVR4
#include <string.h>
#include <sys/times.h>
#else
#ifdef VMS
#include "strings.h"
#else
#include <strings.h>
#endif /* VMS */
#include <sys/time.h>
#endif /*SVR4*/

#ifndef  LINT_CAST
#ifdef   lint
#define  LINT_CAST(arg)  (arg ? 0 : 0)
#else
#define  LINT_CAST(arg)  (arg)
#endif /*lint*/
#endif /*LINT_CAST*/

#define  ALARM         (void) alarm       /* To make lint happy. */
#define  CLOSE         (void) close
#define  DUP2          (void) dup2
#define  FCLOSE        (void) fclose
#define  FFLUSH        (void) fflush
#define  FGETS         (void) fgets
#define  FSTAT         (void) fstat
#define  FPRINTF       (void) fprintf
#define  GETHOSTNAME   (void) gethostname
#define  KILL          (void) kill
#define  MEMCPY        (void) memcpy
#define  PCLOSE        (void) pclose
#define  PIPE          (void) pipe
#define  POLL          (void) poll
#define  PRINTF        (void) printf
#define  PUTC          (void) putc
#define  READ          (void) read
#define  SSCANF        (void) sscanf
#define  SELECT        (void) select
#define  SETJMP        (void) setjmp
#define  SIGNAL        (void) signal
#define  SPRINTF       (void) sprintf
#define  STRCAT        (void) strcat
#define  STRCPY        (void) strcpy
#define  STRNCAT       (void) strncat
#define  STRNCPY       (void) strncpy
#define  WRITE         (void) write

#define  BOARD_SIZE      8      /* 8x8 playing board */
#define  BUFFERSIZE      10000
#define  MAXHELP         5      /* Maximum number of help categories. */
#define  MAXPRAD         32     /* Maximum game board piece radius. */
#define  MAXRESOURCES    15     /* Maximum number of X resources. */

/* States that the the Reve squares can be in. */
#define  BLACK         (-1)    /* Piece definitions. */
#define  FREE          0
#define  WHITE         1
#define  JPJ           2       /* A square where the computer can play. */
#define  TPJ           (-2)    /* A square where the opponent can play. */

#define  HUMAN         0       /* Player definitions. */
#define  COMPUTER      1

#define  ARG_EQUAL(s, n)  (!argcmp(argv[i], s, n))
#define  ESCAPE           27      /* ASCII escape character. */
#define  EQUAL(a, b)      !strncmp(a, b, strlen(b))
#define  FOR_BOARD(i)     for (i = 0; i < 64; i++)
#define  IMAGE_DIFF       4
#define  INIT_DEPTH       1
#define  ISMOVE(pos, player) (nextmove(pos, NOMOVE, (BOARD *) NULL, player) != NOMOVE)
#define  MAXDIFF          9       /* Number of levels of difficulty. */
#define  MAXLINE          120     /* Length of character strings. */
#define  MAX_PROFMAX      60      /* Maximum search depth. */
#define  NIVEAUMAX        25      /* Maximum possible depth. */
#define  NOMOVE           -1
#define  OPPONENT(p)      p * -1
#define  PAUSE            reve_sleep(500000)    /* 0.5 second. */
#define  PIECE_MARGIN     6
#define  SHEIGHT          16      /* Game board special symbol height. */
#define  SWIDTH           16      /* Game board special symbol width. */

#ifndef  EDGENAME
#define  EDGENAME      "/usr/local/lib/reve.edgetable"
#endif /*!EDGENAME*/

#ifndef  HELPNAME
#define  HELPNAME      "/usr/local/lib/reve.help"
#endif /*!HELPNAME*/

#ifndef  REVEPROC
#define  REVEPROC      "/usr/local/bin/reve_proc"
#endif /*!REVEPROC*/

#ifndef  INT_SIGNAL
#define  SIGRET        void
#else
#define  SIGRET        int
#endif /*!INT_SIGNAL*/

#define  VINVUL        50

enum cp_type { CP_WHITE, CP_BLACK, CP_NEITHER, CP_BOTH } ;

enum disp_type { XBLACK, XBOTH, XWHITE } ;        /* Possible displays. */

enum cur_type   { C_NORMAL, C_HOURGLASS } ;
enum help_type  { H_DESC,   H_OPT,    H_RES,    H_FORM,   H_FILE } ;
enum image_type { I_MOVE,   I_SUGGEST } ;
enum mes_type   { M_PANEL,  M_EVAL,   M_BSCORE, M_WSCORE, M_TURN,
                  M_BCLOCK, M_WCLOCK, M_BPLAYS, M_WPLAYS } ;
enum opt_type   { O_BEST,   O_LAST,   O_EVAL,   O_NUM,    O_MOVE,  O_CLK } ;

/* Reve_proc move operations. */
enum move_type { M_BEST, M_MOVE, M_PROFMAX, M_SUGGESTION, M_TIME } ;

/* X resources used by reve. */
enum res_type { R_BESTMOVE,  R_CLOCK,   R_DIFFICULTY, R_LAST,
                R_LEGALMOVE, R_LOG,     R_NOTES,      R_NUMBER,
                R_BSTONEN,   R_WSTONEN, R_PCMD,       R_OPPICON,
                R_OPPBELL,   R_OPPRAISE } ;

enum playtype { PLAY_BLACK, PLAY_WHITE } ; /* What the computer is playing. */

typedef struct {
  int square[64] ;
  int player ;
  int move ;
  int moves_left ;
  long note ;
  time_t timeleft ;
} BOARD ;

struct reve_in {     /* Input supplied on standard input to reve_proc. */
  enum move_type type ;
  int board[64] ;
  int player ;
  int level ;
  time_t timeleft ;
} ;

struct reve_out {    /* Results written to standard output by reve_proc. */
  enum move_type type ;
  int move ;
  int note ;
  int depth ;
} ;

struct reveVars {                 /* Reve variables and options. */
  BOARD board ;                   /* The current reve board. */
  BOARD moves[64] ;               /* Complete array of board moves. */
  BOARD old_board ;               /* The previous reve board. */
  BOARD *s_pos ;
  BOARD s_all ;                   /* List of valid positions for this move. */

  char *black_plays_text ;        /* Who's playing the black pieces. */
  char *bstone_name ;             /* "Black" stone name for messages. */
  char *comp_plays[4] ;
  char *display ;                 /* X11 display information. */
  char gamefile[MAXLINE] ;        /* Name of file for load/save. */
  char helpfile[MAXLINE] ;        /* Location of reve online help file. */
  char line[40] ;
  char *myname ;                  /* user@host for this local person. */
  char *opponent ;                /* user@host for remote networked person. */
  char *player_values[3] ;        /* Values for cyclic black/white item. */
  char *printcommand ;            /* Command for printing the game. */
  char *progname ;                /* The name of this program. */
  char *resources[MAXRESOURCES] ; /* Reve X resources read. */
  char reveproc[MAXLINE] ;        /* Pathname of the reve_proc program. */
  char *white_dpy ;               /* White piece display information. */
  char *white_plays_text ;        /* Who's playing the white pieces. */
  char *wstone_name ;             /* "White" stone name for messages. */

  enum cp_type cp_value ;         /* What the computer is playing. */
  enum disp_type dtype ;

  FILE *rem_fp ;

  int bclock_value ;    /* Black clock time value. */
  int best_cmove ;      /* Best computer move so far. */
  int black_plays ;
  int bp_value ;        /* Black plays value. */
  int cell_height ;     /* Height of individual game board square. */
  int cell_width ;      /* Width of individual game board square. */
  int cmove_depth ;     /* Depth of current best computer move. */
  int cpos ;            /* Current column position for usage output. */
  int cur_ch ;          /* Current character pressed. */
  int do_bestmove ;
  int do_clock ;
  int do_last ;
  int do_number ;
  int first_move ;      /* Set if computer plays first move. */
  int gameover ;        /* Set true if the game is over. */
  int help_offsets[MAXHELP] ;    /* Offsets into the reve help file. */
  int iconic ;          /* Set if window is currently iconic. */
  int inv_video ;       /* Set if displaying in inverse video. */
  int invalid ;         /* Set if last move was invalid. */
  int isblack ;         /* Set if human to play the black pieces. */
  int iscolor ;         /* Set if this is a color screen. */
  int isremote ;        /* Set if playing remote user@host. */
  int iswhite ;         /* Set if human to play the white pieces. */
  int last_move ;       /* Last valid computer move. */
  int last_outline ;    /* Position of last piece outline whilst dragging. */
  int level ;           /* Current level of difficulty for computer moves. */
  int loadgame  ;       /* Set if there is a game file to load. */
  int monochrome ;      /* If set, display will be in monochrome. */
  int move ;            /* Current move being evaluated. */
  int next_player ;     /* Next player (BLACK or WHITE) to move. */
  int old_diffval ;     /* Old difficulty value (possibly restored). */
  int opp_bell ;        /* If set, sound bell after opponents move. */
  int opp_iconise ;     /* If set, close reve window for opponents move. */
  int opp_raise ;       /* If set, auto raise window after opponent move. */
  int pid ;             /* Process id of the reve_proc process. */
  int pipe_io[2][2] ;
  int play_computer ;   /* Set if playing against the computer. */
  int processing ;      /* If set, opponent is processing a move. */
  int props_showing ;   /* If set, the property window is visible. */
  int restore_moves ;   /* Should legal moves be reshown? */

/*  Globals for passing arguments to "sandwich"; this is to save time putting
 *  arguments on and off the stack in a very heavily used piece of code.
 */

  int s_flip ;
  int s_move ;
  int s_opponent ;
  int s_player ;
  int s_row ;
  int s_col ;

  int show_legal ;
  int show_notes ;
  int show_moves ;        /* If set, all possible moves are being shown. */
  int snote ;             /* Note value for current suggestion. */
  int socketfd ;          /* Socket no. for user@host. */
  int squareh ;           /* Height of a board square. */
  int squarew ;           /* Width of a board square. */
  int sstate ;            /* State of suggestion (showing/not showing). */
  int started ;           /* Set just before window is displayed. */
  int suggestion ;        /* Positive if a suggested move. */
  int timevals[MAXDIFF] ; /* Total time (in minutes) for each diff. level. */
  int tinput  ;           /* Set, when getting text input for load/save. */
  int validkey ;          /* Set if half way though a valid multiple key. */
  int wclock_value ;      /* White clock time value. */
  int white_plays ;
  int wp_value ;          /* White plays value. */

  time_t last_btime ;     /* Last black time value. */
  time_t last_wtime ;     /* Last white time value. */
  time_t start_time ;     /* Start time for current move. */
} ReveVars ;

typedef struct reveVars *Vars ;

struct compVars {              /* REVE global variables */
  char edgefile[MAXLINE] ;     /* Location of the reve edge table file. */

  int damier[NIVEAUMAX][64] ;  /* Boards at different depth level */
  int debug ;                  /* If set, prints out various debug messages. */
  int tacouleur, macouleur ;   /* Your and my colors during evaluation */
  int mnb, profmax ;           /* Number of moves played, current max. depth */
  int max_depth ;              /* Computer strategy - maximum depth. */
  int saveres ;                /* If set, save computer results to log file. */
  int vp0, vo0 ;               /* Current mobility components */
  long c1, c2, c3 ;            /* Constants used in evaluation function */
  long edges[6561] ;           /* Edges Stability Table */
  long note ;                  /* Note value for current computer move. */
  time_t timeleft ;            /* Amount of time left for computer moves. */
} CompVars ;

typedef struct compVars *CVars ;

FILE *find_file         (char *) ;

char *concat_strs       (char **) ;
char *get_resource      (enum res_type) ;
char *getuserhost       () ;

int argcmp              (char *, char *, int) ;
int check               (int) ;
int count               (BOARD *, int) ;
int find_offset         (char *, char *) ;
int formfliplist        (int, int) ;
int fork_child          () ;
int get_bool_resource   (enum res_type, int *) ;
int get_int_resource    (enum res_type, int *) ;
int get_str_resource    (enum res_type, char *) ;
int is_local            () ;
int legal               (int, int, BOARD *) ;
int jejoueen            (int, int, int) ;
int jepeuxjouer         (int) ;
int load_move           (int, int) ;
int play_reve           (int *, int, int, int *, long *) ;
int sandwich            (int) ;
int tujouesen           (int, int, int) ;
int tupeuxjouer         (int) ;
int valid_move          (BOARD *, int) ;

long evalue             (int) ;

void beep               () ;
void close_reve         () ;
void connect_io         () ;
void create_menu        () ;
void destroy_reve       () ;
void display_time       (int, int) ;
void do_edit            () ;
void do_key_move        (int, int) ;
void do_move            (int) ;
void do_opponent_move   (int) ;
void do_props           () ;
void do_read_from_reve  (struct reve_out) ;
void do_stop            () ;
void do_suggestion      (int, int, int, int) ;
void domove             (BOARD *, int, BOARD *, int) ;
void done               () ;
void draw_image         (enum image_type, int, int) ;
void draw_line          (int, int, int, int, int, int) ;
void draw_move          (int, int) ;
void draw_outline       (int, int) ;
void draw_piece         (int, int, int, int, int) ;
void draw_rect          (int, int, int, int, int, int) ;
void draw_square        (int, int, int) ;
void draw_suggest       (int, int) ;
void end_msgs           () ;
void get_addrs          (char *, char *) ;
void get_options        (int, char **) ;
void handle_key         () ;
void init_canvas        () ;
void init_clocks        () ;
void init_data          () ;
void init_edge_table    () ;
void initboard          () ;
void initialise         () ;
void invite_remote      () ;
void load_and_move      () ;
void load_game          () ;
void load_resources     () ;
void make_move          () ;
void message            (enum mes_type, char *) ;
void open_ctl           () ;
void open_reve          () ;
void open_socket        () ;
void opponent_move      (int) ;
void opt_set            (enum opt_type, int) ;
void paint_all          () ;
void paint_board        () ;
void paint_panel        () ;
void paint_prop_sheet   () ;
void raise_reve         () ;
void read_resources     () ;
void read_from_reve     (int) ;
void read_from_sock     (int) ;
void read_str           (char **, char *) ;
void redo               () ;
void redo_move          (int) ;
void reset_clock        (int) ;
void reset_time         (time_t) ;
void save_game_to       (FILE *) ;
void save_game          () ;
void set_computer       (int) ;
void set_config         (enum disp_type) ;
void set_cursor         (enum cur_type) ;
void set_display_types  () ;
void set_eval           (int, int, long) ;
void set_image          (int, int) ;
void set_option         () ;
void set_score          () ;
void set_turn           (int) ;
void show_all           (int) ;
void show_all_moves     () ;
void show_best          (int, long) ;
void show_last          (int, int) ;
void show_number        (int, int, int) ;
void start_msgs         () ;
void suggest            () ;
void think              () ;
void undo               () ;
void undo_move          (int) ;
void update_board_image (int, int) ;
void update_clock       (int, int) ;
void update_pieces      (int, int) ;
void usage              () ;
void usageoption        (char *) ;
void who_wins           () ;
void write_to_reve      (enum move_type, int *, int, int) ;
void write_to_sock      (int, int) ;
