
/*  @(#)rev_iycp.c 1.3 94/01/27
 *
 *  Copyright (C) 1990 - 1994 - Yves Gallot - all rights reserved.
 *
 *  Permission is granted to copy this source, for redistribution
 *  in source form only, provided the news headers in "substantially
 *  unaltered format" are retained, the introductory messages are not
 *  removed, and no monies are exchanged.
 *
 *  Permission is also granted to copy this source, without the
 *  news headers, for the purposes of making an executable copy by
 *  means of compilation, provided that such copy will not be used
 *  for the purposes of competition in any othello tournaments, without
 *  prior permission from the authors.
 *
 *  No responsibility is taken for any errors on inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file), then an attempt will be made to fix them.
 */

#include "reve.h"

extern CVars c ;
extern Vars v ;

/*  Functions used by the "fast" alpha-beta pruning.
 *  - JePeuxJouer( niv ) and TuPeuxJouer( niv ) :
 *    Test if I Can Play or You Can Play on the Board number niv ( which is
 *    current board at depth niv ). "I" is for macouleur value ( my color )
 *    and "You" for tacouleur value ( your color ). Return TRUE or FALSE.
 *    If TRUE, put JPJ on every squares where I Can Play, or TPJ on every
 *    squares where You Can Play.
 *  - JeJoueen( x, y, niv ) and TuJouesen( x, y, niv ) :
 *    I Play square (x, y) on Board number niv and You Play square (x, y)
 *    on Board number niv. It puts piece color macouleur or tacouleur and
 *    returns pieces that must be.
 */

int
jepeuxjouer(niv)
int niv ;
{
  register int *d ;
  register int x, y, posx, posy, pos8x, poscr, flag ;

  d = c->damier[niv] ;
  flag = 0 ;
  c->vp0 = 0 ;

  for (posx = 0; posx < 8; posx++)
    {
      pos8x = posx << 3 ;
      for (posy = 0; posy < 8; posy++)
        {
          poscr = pos8x + posy;  
          if  ((d[poscr] == TPJ) || (d[poscr] == JPJ)) d[poscr] = FREE ;
          if (d[poscr] == FREE)
            {

              for (x = posx + 1;
                   (x < 7) && (d[(x << 3) + posy] == c->tacouleur);
                   x++) continue ;
              if ((x != posx + 1) && (d[(x << 3) + posy] == c->macouleur))
                {
                  flag = 1 ;
                  d[poscr] = JPJ ;
                  c->vp0++ ;
                  goto endloopj ;
                } 

              for (x = posx - 1;
                   (x > 0) && (d[(x << 3) + posy] == c->tacouleur);
                   x--) continue ;
              if ((x != posx - 1) && (d[(x << 3) + posy] == c->macouleur))
                {
                  flag = 1 ;
                  d[poscr] = JPJ ;
                  c->vp0++ ;
                  goto endloopj ;
                } 

              for (y = posy + 1;
                   (y < 7) && (d[pos8x + y] == c->tacouleur);
                   y++) continue ;
              if ((y != posy + 1) && (d[pos8x + y] == c->macouleur))
                {
                  flag = 1 ;
                  d[poscr] = JPJ ;
                  c->vp0++ ;
                  goto endloopj ;
                } 

              for (y = posy - 1;
                   (y > 0) && (d[pos8x + y] == c->tacouleur);
                   y--) continue ;
              if ((y != posy - 1) && (d[pos8x + y] == c->macouleur))
                {
                  flag = 1 ;
                  d[poscr] = JPJ ;
                  c->vp0++ ;
                  goto endloopj ;
                } 

              for (x = posx + 1,  y = posy + 1; 
                   (x < 7) && (y < 7) && (d[(x << 3) + y] == c->tacouleur);
                   x++, y++) continue ;
              if ((x != posx + 1) && (d[(x << 3) + y] == c->macouleur))
                {
                  flag = 1 ;
                  d[poscr] = JPJ ;
                  c->vp0++ ;
                  goto endloopj ;
                }

              for (x = posx - 1,  y = posy + 1; 
                   (x > 0) && (y < 7) && (d[(x << 3) + y] == c->tacouleur);
                   x--, y++) continue ;
              if ((x != posx - 1) && (d[(x << 3) + y] == c->macouleur))
                {
                  flag = 1 ;
                  d[poscr] = JPJ ;
                  c->vp0++ ;
                  goto endloopj ;
                }

              for (x = posx + 1,  y = posy - 1; 
                   (x < 7) && (y > 0) && (d[(x << 3) + y] == c->tacouleur);
                   x++, y--) continue ;
              if ((x != posx + 1) && (d[(x << 3) + y] == c->macouleur))
                {
                  flag = 1 ;
                  d[poscr] = JPJ ;
                  c->vp0++ ;
                  goto endloopj ;
                }

              for (x = posx - 1,  y = posy - 1; 
                   (x > 0) && (y > 0) && (d[(x << 3) + y] == c->tacouleur);
                   x--, y--) continue ;
              if ((x != posx - 1) && (d[(x << 3) + y] == c->macouleur))
                {
                  flag = 1 ;
                  d[poscr] = JPJ ;
                  c->vp0++ ;
                }
endloopj: ; 
            }
        }
    }
  return flag ;
}


int
jejoueen(posx, posy, niv)
int posx, posy, niv ;
{
  register int *d ;
  register int x, y, pos8x ;

  pos8x = posx << 3 ;

  d = c->damier[niv] ;

  d[pos8x + posy] = c->macouleur ;

  for (x = posx + 1;
       (x < 7) && (d[(x << 3) + posy] == c->tacouleur); x++) continue ;
  if ((x != posx + 1) && (d[(x << 3) + posy] == c->macouleur))
    {
      for (x = posx + 1; d[(x << 3) + posy] == c->tacouleur; x++)
        d[(x << 3) + posy] = c->macouleur ;
    }

  for (x = posx - 1;
       (x > 0) && (d[(x << 3) + posy] == c->tacouleur); x--) continue ;
  if ((x != posx - 1) && (d[(x << 3) + posy] == c->macouleur))
    {
      for (x = posx - 1; d[(x << 3) + posy] == c->tacouleur; x--)
        d[(x << 3) + posy] = c->macouleur ;
    }

  for (y = posy + 1;
       (y < 7) && (d[pos8x + y] == c->tacouleur); y++) continue ;
  if ((y != posy + 1) && (d[pos8x + y] == c->macouleur))
    {
      for (y = posy + 1; d[pos8x + y] == c->tacouleur; y++)
        d[pos8x + y] = c->macouleur ;
    }

  for (y = posy - 1;
       (y > 0) && (d[pos8x + y] == c->tacouleur); y--) continue ;
  if ((y != posy - 1) && (d[pos8x + y] == c->macouleur))
    {
      for (y = posy - 1; d[pos8x + y] == c->tacouleur; y--)
        d[pos8x + y] = c->macouleur ;
    }

  for (x = posx + 1, y = posy + 1;
       (x < 7) && (y < 7) && (d[(x << 3) + y] == c->tacouleur);
       x++, y++) continue ;
  if ((x != posx + 1) && (d[(x << 3) + y] == c->macouleur))
    {
      for (x = posx + 1, y = posy + 1; d[(x << 3) + y] == c->tacouleur; x++, y++)
        d[(x << 3) + y] = c->macouleur ;
    }

  for (x = posx - 1, y = posy + 1;
       (x > 0) && (y < 7) && (d[(x << 3) + y] == c->tacouleur);
       x--, y++) continue ;
  if ((x != posx - 1) && (d[(x << 3) + y] == c->macouleur))
    {
      for (x = posx - 1, y = posy + 1; d[(x << 3) + y] == c->tacouleur; x--, y++)
        d[(x << 3) + y] = c->macouleur ;
    }

  for (x = posx + 1, y = posy - 1;
       (x < 7) && (y > 0) && (d[(x << 3) + y] == c->tacouleur);
       x++, y--) continue ;
  if ((x != posx + 1) && (d[(x << 3) + y] == c->macouleur))
    {
      for (x = posx + 1, y = posy - 1; d[(x << 3) + y] == c->tacouleur; x++, y--)
        d[(x << 3) + y] = c->macouleur ;
    }

  for (x = posx - 1, y = posy - 1;
       (x > 0) && (y > 0) && (d[(x << 3) + y] == c->tacouleur);
       x--, y--) continue ;
  if ((x != posx - 1) && (d[(x << 3) + y] == c->macouleur))
    {
      for (x = posx - 1, y = posy - 1; d[(x << 3) + y] == c->tacouleur; x--, y--)
        d[(x << 3) + y] = c->macouleur ;
    }
}


int
tupeuxjouer(niv)
int niv ;
{
  register int *d ;
  register int x, y, posx, posy, pos8x, poscr, flag ;

  d = c->damier[niv] ;
  flag = 0 ;
  c->vo0 = 0 ;

  for (posx = 0; posx < 8; posx++)
    {
      pos8x = posx << 3 ;
      for (posy = 0; posy < 8; posy++)
        {
          poscr = pos8x + posy ;
          if ((d[poscr] == TPJ) || (d[poscr] == JPJ)) d[poscr] = FREE ;
          if (d[poscr] == FREE)
            {
              for (x = posx + 1;
                   (x < 7) && (d[(x << 3) + posy] == c->macouleur);
                   x++) continue ;
              if ((x != posx + 1) && (d[(x << 3) + posy] == c->tacouleur))
                {
                  flag = 1 ;
                  d[poscr] = TPJ ;
                  c->vo0++ ;
                  goto endloopt ;
                } 

              for (x = posx - 1;
                   (x > 0) && (d[(x << 3) + posy] == c->macouleur) ;
                   x--) continue ;
              if ((x != posx - 1) && (d[(x << 3) + posy] == c->tacouleur))
                {
                  flag = 1 ;
                  d[poscr] = TPJ ;
                  c->vo0++ ;
                  goto endloopt ;
                } 

              for (y = posy + 1;
                   (y < 7) && (d[pos8x + y] == c->macouleur);
                   y++) continue ;
              if ((y != posy + 1) && (d[pos8x + y] == c->tacouleur))
                {
                  flag = 1 ;
                  d[poscr] = TPJ ;
                  c->vo0++ ;
                  goto endloopt ;
                } 

              for (y = posy - 1;
                   (y > 0) && (d[pos8x + y] == c->macouleur);
                   y--) continue ;
              if ((y != posy - 1) && (d[pos8x + y] == c->tacouleur))
                {
                  flag = 1 ;
                  d[poscr] = TPJ ;
                  c->vo0++ ;
                  goto endloopt ;
                } 

              for (x = posx + 1,  y = posy + 1; 
                   (x < 7) && (y < 7) && (d[(x << 3) + y] == c->macouleur);
                   x++, y++) continue ;
              if ((x != posx + 1) && (d[(x << 3) + y] == c->tacouleur))
                {
                  flag = 1 ;
                  d[poscr] = TPJ ;
                  c->vo0++ ;
                  goto endloopt ;
                }

              for (x = posx - 1,  y = posy + 1; 
                   (x > 0) && (y < 7) && (d[(x << 3) + y] == c->macouleur);
                   x--, y++) continue ;
              if ((x != posx - 1) && (d[(x << 3) + y] == c->tacouleur))
                {
                  flag = 1 ;
                  d[poscr] = TPJ ;
                  c->vo0++ ;
                  goto endloopt ;
                }

              for (x = posx + 1,  y = posy - 1; 
                   (x < 7) && (y > 0) && (d[(x << 3) + y] == c->macouleur);
                   x++, y--) continue ;
              if ((x != posx + 1) && (d[(x << 3) + y] == c->tacouleur))
                {
                  flag = 1 ;
                  d[poscr] = TPJ ;
                  c->vo0++ ;
                  goto endloopt ;
                }

              for (x = posx - 1,  y = posy - 1; 
                   (x > 0) && (y > 0) && (d[(x << 3) + y] == c->macouleur) ;
                   x--, y-- ) continue ;
              if ((x != posx - 1) && (d[(x << 3) + y] == c->tacouleur))
                {
                  flag = 1 ;
                  d[poscr] = TPJ ;
                  c->vo0++ ;
                }
endloopt: ;
            }
        } 
    }
  return(flag) ;
}


int
tujouesen(posx, posy, niv)
int posx, posy, niv ;
{
  register int *d ;
  register int x, y, pos8x ;

  pos8x = posx << 3 ;
  d = c->damier[niv] ;
  d[pos8x + posy] = c->tacouleur ;

  for (x = posx + 1;
       (x < 7) && (d[(x << 3) + posy] == c->macouleur); x++) continue ;
  if ((x != posx + 1) && (d[(x << 3) + posy] == c->tacouleur))
    {
      for (x = posx + 1; d[(x << 3) + posy] == c->macouleur; x++)
        d[(x << 3) + posy] = c->tacouleur ;
    }

  for (x = posx - 1;
       (x > 0) && (d[(x << 3) + posy] == c->macouleur); x--) continue ;
  if ((x != posx - 1) && (d[(x << 3) + posy] == c->tacouleur))
    {
      for (x = posx - 1; d[(x << 3) + posy] == c->macouleur; x--)
        d[(x << 3) + posy] = c->tacouleur ;
    }

  for (y = posy + 1;
       (y < 7) && (d[pos8x + y] == c->macouleur); y++) continue ;
  if ((y != posy + 1) && (d[pos8x + y] == c->tacouleur))
    {
      for (y = posy + 1; d[pos8x + y] == c->macouleur; y++)
        d[pos8x + y] = c->tacouleur ;
    }

  for (y = posy - 1;
       (y > 0) && (d[pos8x + y] == c->macouleur); y--) continue ;
  if ((y != posy - 1) && (d[pos8x + y] == c->tacouleur))
    {
      for (y = posy - 1; d[pos8x + y] == c->macouleur; y--)
        d[pos8x + y] = c->tacouleur ;
    }

  for (x = posx + 1, y = posy + 1;
       (x < 7) && (y < 7) && (d[(x << 3) + y] == c->macouleur);
       x++, y++) continue ;
  if ((x != posx + 1) && (d[(x << 3) + y] == c->tacouleur))
    {
      for (x = posx + 1, y = posy + 1; d[(x << 3) + y] == c->macouleur; x++, y++)
        d[(x << 3) + y] = c->tacouleur ;
    }

  for (x = posx - 1, y = posy + 1;
       (x > 0) && (y < 7) && (d[(x << 3) + y] == c->macouleur);
       x--, y++) continue ;
  if ((x != posx - 1) && (d[(x << 3) + y] == c->tacouleur))
    {
      for (x = posx - 1, y = posy + 1; d[(x << 3) + y] == c->macouleur; x--, y++)
        d[(x << 3) + y] = c->tacouleur ;
    }

  for (x = posx + 1, y = posy - 1;
       (x < 7) && (y > 0) && (d[(x << 3) + y] == c->macouleur);
       x++, y--) continue ;
  if ((x != posx + 1) && (d[(x << 3) + y] == c->tacouleur))
    {
      for (x = posx + 1, y = posy - 1; d[(x << 3) + y] == c->macouleur; x++, y--)
        d[(x << 3) + y] = c->tacouleur ;
    }

  for (x = posx - 1, y = posy - 1;
       (x > 0) && (y > 0) && (d[(x << 3) + y] == c->macouleur);
       x--, y--) continue ;
  if ((x != posx - 1) && (d[(x << 3) + y] == c->tacouleur))
    {
      for (x = posx - 1, y = posy - 1; d[(x << 3) + y] == c->macouleur; x--, y--)
        d[(x << 3) + y] = c->tacouleur ;
    }
}
