
/*  @(#)rev_ip.c 1.3 94/01/27
 *
 *  Copyright (C) 1990 - 1994 - Yves Gallot - all rights reserved.
 *
 *  Permission is granted to copy this source, for redistribution
 *  in source form only, provided the news headers in "substantially
 *  unaltered format" are retained, the introductory messages are not
 *  removed, and no monies are exchanged.
 *
 *  Permission is also granted to copy this source, without the
 *  news headers, for the purposes of making an executable copy by
 *  means of compilation, provided that such copy will not be used
 *  for the purposes of competition in any othello tournaments, without
 *  prior permission from the authors.
 *
 *  No responsibility is taken for any errors on inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file), then an attempt will be made to fix them.
 */

#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
#include <sys/types.h>
#include "reve.h"

extern CVars c ;
extern Vars v ;

#define NOTE_DELTA  50
#define INF	    1000000000

#define max(x,y) ((x)>(y)?x:y)
#define min(x,y) ((x)<(y)?x:y)

extern int node_count ;
static int tot_node_count ;
static int top_note ;        /* Best note found at top level of search */

/*  These global variables are only used in the play_reve routine. We place
 *  them here as their values might otherwise be clobbered by some longjmp
 *  implementations.
 */  
static int note, oldnote, oldnote2 ;
static int oldprofmax, win_top, win_bot ;

/*  Reve structure. Play_Reve evaluates a board and returns a move and a note
 *  for a given color.
 *  It makes an interface between graphic variables and Reve heart variables.
 *  It computes a timing function, depending on level used.
 *  Then an Alpha-Beta pruning is called and stopped when no time left to Reve.
 *  JePlonge and TuPlonges are typical F and G functions of an Alpha-Beta.
 *  "Plonger dans un arbre" is the french translation of "to descend in a
 *  tree", so I Descend and You Descend.
 */

/*  Modified by Robert Cohen, 10 Jan 1991
 *  Changed search list reordering to make the principal variation
 *  of the previous iteration the first path tried at each level
 *  of the iterative deepening search.
 *  
 *  Added aspiration using failsoft alpha-beta to search.
 *  Now tries search window of oldnote +- NOTE_DELTA
 */

static int cpiinit[60] = { 0, 0, 7, 7,
                           2, 2, 5, 5, 2, 2, 3, 3,
                           4, 4, 5, 5, 1, 1, 3, 3,
                           4, 4, 6, 6, 1, 1, 2, 2,
                           5, 5, 6, 6, 0, 0, 0, 0,
                           2, 3, 4, 5, 2, 3, 4, 5,
                           7, 7, 7, 7, 1, 1, 6, 6,
                           0, 0, 1, 1, 6, 6, 7, 7
                         } ;

static int cpjinit[60] = { 0, 7, 0, 7,
                           2, 5, 2, 5, 3, 4, 2, 5,
                           2, 5, 3, 4, 3, 4, 1, 6,
                           1, 6, 3, 4, 2, 5, 1, 6,
                           1, 6, 2, 5, 2, 3, 4, 5,
                           0, 0, 0, 0, 7, 7, 7, 7,
                           2, 3, 4, 5, 1, 6, 1, 6,
                           1, 6, 0, 7, 0, 7, 1, 6
                         } ;

/*  Total amount of time (in minutes) to allow, at this level of difficulty.
 *  The time allocation function is not used at level 1.
 */

static int timevals[MAXDIFF] = { 0, 1, 3, 5, 10, 15, 20, 30, 60 } ;

static int cpi[60], cpj[60], cpk[60], cpf[60] ;
static int cpi2[60], cpj2[60], cpk2[60] ;
static int cpmaxi[NIVEAUMAX][NIVEAUMAX] ;

static int locallevel = -1 ;
static firsttime, timeused, allotime ;

jmp_buf jumper ;

static void catcher   () ;

static long jeplonge  (int, long, long) ;
static long tuplonges (int, long, long) ;
extern long evalue    (int) ;


static void
catcher()
{
  longjmp(jumper, 1) ;
}


FILE *
find_file(filename)
char *filename ;
{
  char name[MAXLINE], *paths, *ptr ;
  int i = 0 ;
  FILE *fp = NULL ;

  if ((fp = fopen(filename, "r")) == NULL)
    {
      paths = getenv("PATH") ;
      if ((ptr = paths) && filename[0] != '/')
        for (;;)
          if (*ptr == ':' || *ptr == 0)
            {
              if (*ptr == 0) break ;
              name[i++] = '/' ;
              name[i] = 0 ;
              STRCAT(name, c->edgefile) ;
              if ((fp = fopen(name, "r")) != NULL) break ;
              if (*ptr == '\0') break ;
              ptr++ ;
              i = 0 ;
            }
          else name[i++] = *ptr++ ;
    }
  return(fp) ;
}


void
init_edge_table(edgefile)     /* Load reve edge table values. */
char *edgefile ;
{
  char buf[MAXLINE], *ptr ;
  int i, line ;
  FILE *fp = NULL ;

  if ((fp = find_file(edgefile)) == NULL)
    {
      FPRINTF(stderr, "Cannot open Edge Stability Table file\n") ;
      exit(1) ;
    }
  line = 0 ;
  while (fgets(buf, MAXLINE, fp) != NULL)
    {
      line++ ;
      if (buf[0] == '\n' || buf[0] == '#') continue ;
      if ((ptr = strchr(buf, '[')) == NULL)
        {
          FPRINTF(stderr, "Cannot read edge table file at line %d\n", line) ;
          exit(1) ;
        }
      SSCANF(ptr+1, "%d", &i) ;
      if ((ptr = strchr(buf, '=')) == NULL)
        {
          FPRINTF(stderr, "Cannot read edge table file at line %d\n", line) ;
          exit(1) ;
        }
      SSCANF(ptr+1, "%ld", &c->edges[i]) ;
    }
  FCLOSE(fp) ;
  for (i = 0 ; i < 3281; i++) c->edges[6560 - i] = - c->edges[i] ;
}


int
play_reve(board, color, level, rtnmv, rtnnote)
int *board, color, level, *rtnmv ;
long *rtnnote ;
{
  register int *d0, *d1 ;
  register int k, cp ;
  register int count ;
  FILE *dp, *fp ;
  int pass ;

  if (c->debug)
    if ((dp = fopen("reve.debug", "a")) == NULL)
      c->debug = 0 ;

  for (k = 0; k < 60; k++)
    {
      cpi[k] = cpiinit[k] ;
      cpj[k] = cpjinit[k] ;
      cpk[k] = 8 * cpi[k] + cpj[k] ;
    }

  d0 = c->damier[0] ;
  d1 = c->damier[1] ;

  for (k = 0; k < 64; k++)
    {
           if (board[k] == BLACK) d0[k] = BLACK ;
      else if (board[k] == WHITE) d0[k] = WHITE ;
      else                        d0[k] = FREE ;
    }

  if (color == WHITE)
    {
      c->macouleur = WHITE ;
      c->tacouleur = BLACK ;
    }
  else
    {
      c->macouleur = BLACK ;
      c->tacouleur = WHITE ;
    }

  if (!jepeuxjouer(0))
    {
      *rtnmv = -1 ;
      return ;
    }

  c->mnb = 1 ;
  for (k = 0; k < 64; k++)
    if ((k != 27) && (k != 28) && (k != 35) && (k != 36))
      if ((d0[k] == WHITE) || (d0[k] == BLACK))
        {
          c->mnb++ ;
          cp = 0 ;
          while (cpk[cp] != k) cp++ ;
          for ( ; cp < 59; cp++)
            {
              cpi[cp] = cpi[cp + 1] ;
              cpj[cp] = cpj[cp + 1] ;
              cpk[cp] = cpk[cp + 1] ; 
            }
        }

  if ((locallevel != level) || (c->mnb == 1) || (c->mnb == 2))
    {
      c->timeleft = timevals[level-1] * 60 ;
      locallevel = level ;
    }

  k = 0 ;
  for (cp = 0; cp <= 60 - c->mnb; cp++)
    if (d0[cpk[cp]] == JPJ) k++ ;

  count = note = 0 ;
  timeused = 1 ;
  c->profmax = c->max_depth - 1 ;

  if (((k == 1) && (c->mnb < 52)) || (c->mnb == 1))
    {
      for (cp = 0; d0[cpk[cp]] != JPJ; cp++) continue ;
      cpi[0] = cpi[cp] ;
      cpj[0] = cpj[cp] ;
      cpk[0] = cpk[cp] ;
    }
  else if (c->mnb == 2)
    {
      if (d0[2 * 8 + 3] == BLACK)
        {
          cpi[0] = 4 ;
          cpj[0] = 2 ;
        }
      else if (d0[3 * 8 + 2] == BLACK)
        {
          cpi[0] = 2 ;
          cpj[0] = 4 ;
        }
      else if (d0[4 * 8 + 5] == BLACK)
        {
          cpi[0] = 5 ;
          cpj[0] = 3 ;
        }
      else if (d0[5 * 8 + 4] == BLACK)
        {
          cpi[0] = 3 ;
          cpj[0] = 5 ;
        }
      cpk[0] = cpi[0] * 8 + cpj[0] ;
    }
  else if (c->mnb == 3)
    {
      if (d0[4 * 8 + 2] == WHITE)
        {
          cpi[0] = 5 ;
          cpj[0] = 3 ;
        }
      else if (d0[2 * 8 + 2] == WHITE)
        {
          cpi[0] = 3 ;
          cpj[0] = 2 ;
        }
      else if (d0[2 * 8 + 4] == WHITE)
        {
          cpi[0] = 3 ;
          cpj[0] = 5 ;
        }
      cpk[0] = cpi[0] * 8 + cpj[0] ;
    }
  else
    {
      allotime = c->timeleft * 4 / (61 - c->mnb) ;
      firsttime = time((time_t *) NULL) ;
      tot_node_count = 0 ;
      pass = 0 ;

      win_top = win_bot = oldnote = oldprofmax = 0 ;

      SIGNAL(SIGALRM, catcher) ;

      if (setjmp(jumper) != 0)
        {
          if (c->debug)
            {
              FPRINTF(dp, "%d nodes visited when interrupted", node_count) ;
              FPRINTF(dp, " at ply %d, note = %d\n", c->profmax, top_note) ;
            }
          tot_node_count += node_count ;

          if (top_note <= win_bot || top_note >= win_top)
            {

/*  Didn't find move at this level so restore principal variation from
 * last level.
 */
              if (c->debug)
                FPRINTF(dp, "no valid move found in window %d - %d\n",
                        win_bot, win_top) ;
              note = oldnote ;
              c->profmax = oldprofmax ;
              for (k = 0; k < c->profmax; k++)
                {
                  cpi[k] = cpi2[k] ;
                  cpj[k] = cpj2[k] ;
                  cpk[k] = cpk2[k] ;
                }
            }
          else
            {

/* Copy from principal variation into cpi... */

              for (k = 0; k < c->profmax; k++)
                {
                  cpi2[k] = cpi[cpmaxi[0][k]] ;
                  cpj2[k] = cpj[cpmaxi[0][k]] ;
                  cpk2[k] = cpk[cpmaxi[0][k]] ;
                }
              for (k = 0; k < c->profmax; k++)
                {
                  cpi[k] = cpi2[k] ;
                  cpj[k] = cpj2[k] ;
                  cpk[k] = cpk2[k] ;
                }
              c->profmax = -c->profmax ;
              note = top_note ;
            }
          goto trap ;
        }

      do
        {
          oldnote2 = oldnote ;
          oldnote = note ;
          oldprofmax = c->profmax ;
          top_note = -INF ;
          node_count = 0 ;

          if ((int) (allotime - timeused) > 2)
            ALARM((unsigned) (allotime - timeused)) ;

          c->profmax++ ;
          pass++ ;

          c->c1 = 312 + 6 * (c->mnb + c->profmax - 1) ;
          if (c->mnb + c->profmax - 1 < 25)
            c->c2 = 50 + 2 * (c->mnb + c->profmax - 1) ;
          else
            c->c2 = 75 + c->mnb + c->profmax - 1 ;
          c->c3 = 99 ;

          if (c->profmax > 53 - c->mnb)
            {
              c->profmax = 61 - c->mnb ;
              allotime = c->timeleft * 2 / 3 ;
              if ((int) (allotime - timeused) > 2)
                ALARM((unsigned) (allotime - timeused)) ;
            }

          if (pass > 2 && c->profmax < 61 - c->mnb)
            {

/* Use aspiration search */

              if (abs(oldnote2) < NOTE_DELTA * 2)
                {
                  win_bot = oldnote2 - NOTE_DELTA ;
                  win_top = oldnote2 + NOTE_DELTA ;
                }
              else
                {
                  win_bot = min(oldnote2 * 1.5, oldnote2 / 2) ;
                  win_top = max(oldnote2 * 1.5, oldnote2 / 2) ;
                }
              note = jeplonge(0, win_bot, win_top) ;
              if (note >= win_top)
                {
                  if (c->debug)
                    {
                      FPRINTF(dp, "failing high, note = %d, ", note) ;
                      FPRINTF(dp, "win top = %d, wasted nodes visited = %d\n",
                              win_top, node_count) ;
                    }
                  win_top = INF ;
                  win_bot = note ;
                  top_note = -INF ;
                  note = jeplonge(0, win_bot, win_top) ;
                }
              else if (note <= win_bot)
                {
                  if (c->debug)
                    {
                      FPRINTF(dp, "failing low, note = %d, ", note) ;
                      FPRINTF(dp, "win bot = %d, wasted nodes visited = %d\n",
                              win_bot, node_count) ;
                    }
                  win_bot = -INF ;
                  win_top = note ;
                  top_note = -INF ;
                  note = jeplonge(0, win_bot, win_top) ;
                }
            }
          else
            {
              win_bot = -INF ;
              win_top = INF ;
              note = jeplonge(0, win_bot, win_top) ;
            }

          ALARM(0) ;
          if (cpmaxi[0][0] == 0) count += 2 ;
          else            count = 1 ;

          for (cp = 0; cp <= 60 - c->mnb; cp++) cpf[cp] = 1 ;
          for (k = 0; k < c->profmax; k++)
             {
               cpi2[k] = cpi[cpmaxi[0][k]] ;
               cpj2[k] = cpj[cpmaxi[0][k]] ;
               cpk2[k] = cpk[cpmaxi[0][k]] ;
               cpf[cpmaxi[0][k]] = 0 ;
             }
           k = c->profmax ;
           for (cp = 0; cp <= 60 - c->mnb; cp++)
             if (cpf[cp])
               {
                 cpi2[k] = cpi[cp] ;
                 cpj2[k] = cpj[cp] ;
                 cpk2[k] = cpk[cp] ;
                 k++ ;
               }
           for (cp = 0; cp <= 60 - c->mnb; cp++)
             {
               cpi[cp] = cpi2[cp] ;
               cpj[cp] = cpj2[cp] ;
               cpk[cp] = cpk2[cp] ;
             }

          timeused = time((time_t *) NULL) - firsttime ;
          if (c->debug)
            {
              FPRINTF(dp, "%d nodes visited at ply %d,", node_count, c->profmax) ;
              FPRINTF(dp, " window %0.4g - %0.4g,",
                      (float) win_bot, (float) win_top) ;
              FPRINTF(dp, " note = %d, best move = <%c-%c>\n",
                      note, 'A' + cpj[0], '1' + cpi[0]) ;
            }
          tot_node_count += node_count ;
          if ((c->mnb == 4) && (c->profmax > 2)) break ;
        }
      while ((timeused * count < allotime * 4 / 5) &&
             (c->profmax != 61 - c->mnb)) ;

trap:

      timeused = time((time_t *) NULL) - firsttime ;
      if (timeused == 0) timeused = 1 ;

      if (c->debug)
        {
          FPRINTF(dp, "total nodes visited was %d, time used was %d secs,",
                  tot_node_count, timeused) ;
          FPRINTF(dp, " %d nodes/sec\n", tot_node_count / timeused) ;
          FPRINTF(dp, "alloc'ed time was %d, time left = %d\n",
                  allotime, c->timeleft - timeused);
          FPRINTF(dp, "best move sequence: ") ;
          for (k = 0; k < abs(c->profmax); k++)
            FPRINTF(dp, "<%c-%c>, ", 'A' + cpj[k], '1' + cpi[k]) ;
          FPRINTF(dp, "\n") ;
        }
    }

  if (*rtnmv) c->timeleft -= timeused ;
  if ((int) c->timeleft < 0) c->timeleft = 0 ;

  if (c->saveres)
    {
      if ((c->mnb == 1) || (c->mnb == 2))
        {
          fp = fopen("reve.res", "w") ;
          FPRINTF(fp, "\n") ;
          FCLOSE(fp) ;
        }
      fp = fopen("reve.res", "a") ;
      FPRINTF(fp, "%2d, <%c-%c>, ", c->mnb, 'A' + cpj[0], '1' + cpi[0]) ;
      FPRINTF(fp, "nt : %5d, pmax : %3d, tmleft : %d, level : %d, ",
               note,     c->profmax,    c->timeleft, level) ;
      FPRINTF(fp, "exp : <%c-%c>\n", 'A' + cpj[1], '1' + cpi[1]) ;
      FCLOSE(fp) ;
    }

  *rtnmv = cpk[0] ;
  *rtnnote = note ;
  if (c->debug) FCLOSE(dp) ;
}


/*  If interrupted, global variables top_note contains the best note
 *  found, cpmaxi[0] contains the principal variation.
 */

static long
jeplonge(niv, alpha, beta)
int niv ;
long alpha, beta ;
{
  register int *d0, *d1 ;
  register int k, cp ;
  register long lnote, note ;
  int atime;

  d0 = c->damier[niv] ;
  d1 = c->damier[niv + 1] ;

  note = -INF ;

  for (cp = 0; cp <= 60 - c->mnb; cp++)
    {
      if (d0[cpk[cp]] == JPJ)
        {
#ifdef hp9000s300                
          for (k = 0; k < 64; k++) c->damier[niv + 1][k] = c->damier[niv][k] ;
#else
          for (k = 0; k < 64; k++) d1[k] = d0[k] ;
#endif
          jejoueen(cpi[cp], cpj[cp], niv + 1) ;
          if (niv == c->profmax - 1) lnote = evalue(niv + 1) ;
          else if (tupeuxjouer(niv + 1))
            lnote = tuplonges(niv + 1, max(note,alpha), beta) ;
          else if (jepeuxjouer(niv + 1))
            lnote = jeplonge(niv + 1, max(note,alpha), beta) ;
          else
            lnote = evalue(niv + 1) ;
          if (lnote > note)
            {
              if (niv == 0)
                {
                  atime = alarm(0) ;
                  note = lnote ;
                  for (k = niv + 1; k < c->profmax; k++)
                    cpmaxi[niv][k] = cpmaxi[niv+1][k] ;
                  cpmaxi[niv][niv] = cp ;
                  top_note = note ;
                  show_best(cpk[cp],note) ;
                  ALARM(atime) ;
                }
              else
                {
                  note = lnote ;
                  for (k = niv + 1; k < c->profmax; k++)
                    cpmaxi[niv][k] = cpmaxi[niv+1][k] ;
                  cpmaxi[niv][niv] = cp ;
                }
            }
          if (note >= beta) return note ;
        }
    }

  return note ;
}


static long
tuplonges(niv, alpha, beta)
int niv ;
long alpha, beta ;
{
  register int *d0, *d1 ;
  register int k, cp ;
  register long lnote, note ;

  d0 = c->damier[niv] ;
  d1 = c->damier[niv + 1] ;

  note = INF ;

  for (cp = 0; cp <= 60 - c->mnb; cp++)
    {
      if (d0[cpk[cp]] == TPJ)
        {
#ifdef hp9000s300                
          for (k = 0; k < 64; k++) c->damier[niv + 1][k] = c->damier[niv][k] ;
#else                            
          for (k = 0; k < 64; k++) d1[k] = d0[k] ;
#endif                           
          tujouesen(cpi[cp], cpj[cp], niv + 1) ;
          if (niv == c->profmax - 1) lnote = evalue(niv + 1) ;
          else if (jepeuxjouer(niv + 1))
            lnote = jeplonge(niv + 1, alpha, min(note,beta)) ;
          else if (tupeuxjouer(niv + 1))
            lnote = tuplonges(niv + 1, alpha, min(note,beta)) ;
          else
            lnote = evalue(niv + 1) ;
          if (lnote < note)
            {
              note = lnote ;
              for (k = niv + 1; k < c->profmax; k++)
                cpmaxi[niv][k] = cpmaxi[niv+1][k] ;
              cpmaxi[niv][niv] = cp;
            }
          if (note <= alpha) return note ;
        }
    }

  return note ;
}
