
/*  @(#)rev_eval.c 1.2 94/01/20
 *
 *  Copyright (C) 1990 - 1994 - Yves Gallot - all rights reserved.
 *
 *  Permission is granted to copy this source, for redistribution
 *  in source form only, provided the news headers in "substantially
 *  unaltered format" are retained, the introductory messages are not
 *  removed, and no monies are exchanged.
 *
 *  Permission is also granted to copy this source, without the
 *  news headers, for the purposes of making an executable copy by
 *  means of compilation, provided that such copy will not be used
 *  for the purposes of competition in any othello tournaments, without
 *  prior permission from the authors.
 *
 *  No responsibility is taken for any errors on inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file), then an attempt will be made to fix them.
 */

#include "reve.h"

extern CVars c ;
extern Vars v ;

/*  Evaluation function : gives a note to a board = damier[ niv ].
 *  It computes 4 components :
 *     - Edge Stability, using Edge Stability Table pre-computed before
 *     - Current Mobility, in fact computed during alpha-beta pruning
 *     - X squares Values
 *     - Potential Mobility, looking at squares contacts
 *  And then Eval = c1 * ES + c2 * ( CM + cx * XV ) + c3 * PM
 *  Eval is replaced by - Eval if Black is replaced by White. Eval is positive
 *  if macouleur ( my color ) has a good position and negative if tacouleur
 *  position is good.
 *  If we are "near" the end of the game, then Eval is equal to final disc
 *  differential.
 */
 
int node_count ;

long
evalue(niv)
int niv ;
{
  register int *d, *p ;
  register int i, x, y, tc, mc ;
  register long note ;
  register int vp, vo ;
  register long tnote, cx ;

  node_count++ ;
  d = c->damier[niv] ;
  tc = c->tacouleur ;
  mc = c->macouleur ;

  if (c->mnb > 60 - c->profmax)
    {
      note = 0 ;
      for (p = &d[0]; p < &d[64]; p++)
	     if (*p == mc) note++ ;
	else if (*p == tc) note-- ;
      return(note) ;
    }
  else
    {
      x = y = 0 ;
      for (p = &d[0]; p < &d[64]; p++)
	     if (*p == mc) x++ ;
	else if (*p == tc) y++ ;
      if (x == 0) return(-100000000) ;
      if (y == 0) return( 100000000) ;

      for (p = &d[0]; p < &d[64]; p++)
        if ((*p == TPJ) || (*p == JPJ)) *p = FREE ;

      i = 0 ;
      for (p = &d[0]; p < &d[8]; p++)
        {
          i += i + i ;
	       if (*p == FREE) i++ ;
	  else if (*p == mc)   i += 2 ;
        }
      note = c->edges[i] ;

      i = 0 ;
      for (p = &d[56]; p < &d[64]; p++)
        {
          i += i + i ;
	       if (*p == FREE) i++ ;
	  else if (*p == mc)   i += 2 ;
        }
      note += c->edges[i] ;

      i = 0 ;
      for (p = &d[0]; p < &d[64]; p += 8)
        {
          i += i + i ;
	       if (*p == FREE) i++ ;
	  else if (*p == mc)   i += 2 ;
        }
      note += c->edges[i] ;

      i = 0 ;
      for (p = &d[7]; p < &d[64]; p += 8)
        {
          i += i + i ;
	       if (*p == FREE) i++ ;
	  else if (*p == mc)   i += 2 ;
        }
      note += c->edges[i] ;

      cx = 8 * (50 - c->mnb - c->profmax) ;

      if (d[0] == FREE)
        {
	       if (d[9] == mc) note -= cx ;
	  else if (d[9] == tc) note += cx ;
        }

      if (d[7] == FREE)
        {
	       if (d[14] == mc) note -= cx ;
	  else if (d[14] == tc) note += cx ;
        }

      if (d[56] == FREE)
        {
	       if (d[49] == mc) note -= cx ;
	  else if (d[49] == tc) note += cx ;
        }

      if (d[63] == FREE)
        {
	       if (d[54] == mc) note -= cx ;
	  else if (d[54] == tc) note += cx ;
        }

      tnote = c->c1 * note + c->c2 * (long) 1000 *
                (c->vp0 - c->vo0) / (c->vp0 + c->vo0 + 2) ;

      vp = vo = 0 ;
      for (x = 0; x < 8; x++)
        for (y = 0; y < 8; y++)
          {
            i = (x << 3) + y ;
	    if (d[i] == tc)
              {
                     if ((x > 0) && (d[i - 8] == FREE))            vp++ ;
                else if ((x < 7) && (d[i + 8] == FREE))            vp++ ;
                else if ((y > 0) && (d[i - 1] == FREE))            vp++ ;
                else if ((y < 7) && (d[i + 1] == FREE))            vp++ ;
                else if ((x > 0) && (y > 0) && (d[i - 9] == FREE)) vp++ ;
                else if ((x < 7) && (y > 0) && (d[i + 7] == FREE)) vp++ ;
                else if ((x > 0) && (y < 7) && (d[i - 7] == FREE)) vp++ ;
                else if ((x < 7) && (y < 7) && (d[i + 9] == FREE)) vp++ ;
              }
	    if (d[i] == mc)
              {
                     if ((x > 0) && (d[i - 8] == FREE))             vo++ ;
                else if ((x < 7) && (d[i + 8] == FREE))             vo++ ;
                else if ((y > 0) && (d[i - 1] == FREE))             vo++ ;
                else if ((y < 7) && (d[i + 1] == FREE))             vo++ ;
                else if ((x > 0) && (y > 0) && ( d[i - 9] == FREE)) vo++ ;
                else if ((x < 7) && (y > 0) && ( d[i + 7] == FREE)) vo++ ;
                else if ((x > 0) && (y < 7) && ( d[i - 7] == FREE)) vo++ ;
                else if ((x < 7) && (y < 7) && ( d[i + 9] == FREE)) vo++ ;
              }
          }

      note = ((long) 1000 * (vp - vo)) / (vp + vo + 2) ;

      vp = vo = 0 ;
      for (x = 0; x < 8; x++)
        for (y = 0; y < 8; y++)
          {
            i = (x << 3) + y ;
            if (d[i] == FREE)
              {
		     if ((x > 0) && (d[i - 8] == tc))            vp++ ;
		else if ((x < 7) && (d[i + 8] == tc))            vp++ ;
		else if ((y > 0) && (d[i - 1] == tc))            vp++ ;
		else if ((y < 7) && (d[i + 1] == tc))            vp++ ;
		else if ((x > 0) && (y > 0) && (d[i - 9] == tc)) vp++ ;
		else if ((x < 7) && (y > 0) && (d[i + 7] == tc)) vp++ ;
		else if ((x > 0) && (y < 7) && (d[i - 7] == tc)) vp++ ;
		else if ((x < 7) && (y < 7) && (d[i + 9] == tc)) vp++ ;

		     if ((x > 0) && (d[i - 8] == mc))            vo++ ;
		else if ((x < 7) && (d[i + 8] == mc))            vo++ ;
		else if ((y > 0) && (d[i - 1] == mc))            vo++ ;
		else if ((y < 7) && (d[i + 1] == mc))            vo++ ;
		else if ((x > 0) && (y > 0) && (d[i - 9] == mc)) vo++ ;
		else if ((x < 7) && (y > 0) && (d[i + 7] == mc)) vo++ ;
		else if ((x > 0) && (y < 7) && (d[i - 7] == mc)) vo++ ;
		else if ((x < 7) && (y < 7) && (d[i + 9] == mc)) vo++ ;
              }
          }

      note += ((long) 1000 * (vp - vo)) / (vp + vo + 2) ;

      vp = vo = 0 ;
      for (x = 0; x < 8; x++)
        for (y = 0; y < 8; y++)
          {
            i = (x << 3) + y ;
            if (d[i] == FREE)
              {
		if ((x > 0) && (d[i - 8] == tc))            vp++ ;
		if ((x < 7) && (d[i + 8] == tc))            vp++ ;
		if ((y > 0) && (d[i - 1] == tc))            vp++ ;
		if ((y < 7) && (d[i + 1] == tc))            vp++ ;
		if ((x > 0) && (y > 0) && (d[i - 9] == tc)) vp++ ;
		if ((x < 7) && (y > 0) && (d[i + 7] == tc)) vp++ ;
		if ((x > 0) && (y < 7) && (d[i - 7] == tc)) vp++ ;
		if ((x < 7) && (y < 7) && (d[i + 9] == tc)) vp++ ;

		if ((x > 0) && (d[i - 8] == mc))            vo++ ;
		if ((x < 7) && (d[i + 8] == mc))            vo++ ;
		if ((y > 0) && (d[i - 1] == mc))            vo++ ;
		if ((y < 7) && (d[i + 1] == mc))            vo++ ;
		if ((x > 0) && (y > 0) && (d[i - 9] == mc)) vo++ ;
		if ((x < 7) && (y > 0) && (d[i + 7] == mc)) vo++ ;
		if ((x > 0) && (y < 7) && (d[i - 7] == mc)) vo++ ;
		if ((x < 7) && (y < 7) && (d[i + 9] == mc)) vo++ ;
              }
          }

      note += ((long) 1000 * (vp - vo)) / (vp + vo + 2) ;
      tnote += c->c3 * note ;
      return(tnote / 1000) ;
    }
}
